/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.representer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions$FlowStyle;
import org.yaml.snakeyaml.DumperOptions$ScalarStyle;
import org.yaml.snakeyaml.introspector.PropertyUtils;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.BaseRepresenter$1;
import org.yaml.snakeyaml.representer.Represent;

public abstract class BaseRepresenter {
    protected final Map<Class<?>, Represent> representers = new HashMap();
    protected Represent nullRepresenter;
    protected final Map<Class<?>, Represent> multiRepresenters = new LinkedHashMap();
    protected DumperOptions$ScalarStyle defaultScalarStyle = DumperOptions$ScalarStyle.PLAIN;
    protected DumperOptions$FlowStyle defaultFlowStyle = DumperOptions$FlowStyle.AUTO;
    protected final Map<Object, Node> representedObjects = new BaseRepresenter$1(this);
    protected Object objectToRepresent;
    private PropertyUtils propertyUtils;
    private boolean explicitPropertyUtils = false;

    public Node represent(Object object) {
        Node node = this.representData(object);
        this.representedObjects.clear();
        this.objectToRepresent = null;
        return node;
    }

    protected final Node representData(Object object) {
        Node node;
        this.objectToRepresent = object;
        if (this.representedObjects.containsKey(this.objectToRepresent)) {
            Node node2 = this.representedObjects.get(this.objectToRepresent);
            return node2;
        }
        if (object == null) {
            Node node3 = this.nullRepresenter.representData(null);
            return node3;
        }
        Class<?> clazz = object.getClass();
        if (this.representers.containsKey(clazz)) {
            Represent represent = this.representers.get(clazz);
            node = represent.representData(object);
        } else {
            Object object2;
            for (Class<?> clazz2 : this.multiRepresenters.keySet()) {
                if (clazz2 == null || !clazz2.isInstance(object)) continue;
                Represent represent = this.multiRepresenters.get(clazz2);
                Node node4 = represent.representData(object);
                return node4;
            }
            if (this.multiRepresenters.containsKey(null)) {
                object2 = this.multiRepresenters.get(null);
                node = object2.representData(object);
            } else {
                object2 = this.representers.get(null);
                node = object2.representData(object);
            }
        }
        return node;
    }

    protected Node representScalar(Tag tag, String string, DumperOptions$ScalarStyle dumperOptions$ScalarStyle) {
        if (dumperOptions$ScalarStyle == null) {
            dumperOptions$ScalarStyle = this.defaultScalarStyle;
        }
        ScalarNode scalarNode = new ScalarNode(tag, string, null, null, dumperOptions$ScalarStyle);
        return scalarNode;
    }

    protected Node representScalar(Tag tag, String string) {
        return this.representScalar(tag, string, this.defaultScalarStyle);
    }

    protected Node representSequence(Tag tag, Iterable<?> iterable, DumperOptions$FlowStyle dumperOptions$FlowStyle) {
        int n2 = 10;
        if (iterable instanceof List) {
            n2 = ((List)iterable).size();
        }
        ArrayList<Node> arrayList = new ArrayList<Node>(n2);
        SequenceNode sequenceNode = new SequenceNode(tag, arrayList, dumperOptions$FlowStyle);
        this.representedObjects.put(this.objectToRepresent, sequenceNode);
        DumperOptions$FlowStyle dumperOptions$FlowStyle2 = DumperOptions$FlowStyle.FLOW;
        for (Object obj : iterable) {
            Node node = this.representData(obj);
            if (!(node instanceof ScalarNode) || !((ScalarNode)node).isPlain()) {
                dumperOptions$FlowStyle2 = DumperOptions$FlowStyle.BLOCK;
            }
            arrayList.add(node);
        }
        if (dumperOptions$FlowStyle == DumperOptions$FlowStyle.AUTO) {
            if (this.defaultFlowStyle != DumperOptions$FlowStyle.AUTO) {
                sequenceNode.setFlowStyle(this.defaultFlowStyle);
            } else {
                sequenceNode.setFlowStyle(dumperOptions$FlowStyle2);
            }
        }
        return sequenceNode;
    }

    protected Node representMapping(Tag tag, Map<?, ?> map, DumperOptions$FlowStyle dumperOptions$FlowStyle) {
        ArrayList<NodeTuple> arrayList = new ArrayList<NodeTuple>(map.size());
        MappingNode mappingNode = new MappingNode(tag, arrayList, dumperOptions$FlowStyle);
        this.representedObjects.put(this.objectToRepresent, mappingNode);
        DumperOptions$FlowStyle dumperOptions$FlowStyle2 = DumperOptions$FlowStyle.FLOW;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Node node = this.representData(entry.getKey());
            Node node2 = this.representData(entry.getValue());
            if (!(node instanceof ScalarNode) || !((ScalarNode)node).isPlain()) {
                dumperOptions$FlowStyle2 = DumperOptions$FlowStyle.BLOCK;
            }
            if (!(node2 instanceof ScalarNode) || !((ScalarNode)node2).isPlain()) {
                dumperOptions$FlowStyle2 = DumperOptions$FlowStyle.BLOCK;
            }
            arrayList.add(new NodeTuple(node, node2));
        }
        if (dumperOptions$FlowStyle == DumperOptions$FlowStyle.AUTO) {
            if (this.defaultFlowStyle != DumperOptions$FlowStyle.AUTO) {
                mappingNode.setFlowStyle(this.defaultFlowStyle);
            } else {
                mappingNode.setFlowStyle(dumperOptions$FlowStyle2);
            }
        }
        return mappingNode;
    }

    public void setDefaultScalarStyle(DumperOptions$ScalarStyle dumperOptions$ScalarStyle) {
        this.defaultScalarStyle = dumperOptions$ScalarStyle;
    }

    public DumperOptions$ScalarStyle getDefaultScalarStyle() {
        if (this.defaultScalarStyle == null) {
            return DumperOptions$ScalarStyle.PLAIN;
        }
        return this.defaultScalarStyle;
    }

    public void setDefaultFlowStyle(DumperOptions$FlowStyle dumperOptions$FlowStyle) {
        this.defaultFlowStyle = dumperOptions$FlowStyle;
    }

    public DumperOptions$FlowStyle getDefaultFlowStyle() {
        return this.defaultFlowStyle;
    }

    public void setPropertyUtils(PropertyUtils propertyUtils) {
        this.propertyUtils = propertyUtils;
        this.explicitPropertyUtils = true;
    }

    public final PropertyUtils getPropertyUtils() {
        if (this.propertyUtils == null) {
            this.propertyUtils = new PropertyUtils();
        }
        return this.propertyUtils;
    }

    public final boolean isExplicitPropertyUtils() {
        return this.explicitPropertyUtils;
    }
}

