/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.parser;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions$FlowStyle;
import org.yaml.snakeyaml.DumperOptions$ScalarStyle;
import org.yaml.snakeyaml.DumperOptions$Version;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.comments.CommentType;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.CommentEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.Event$ID;
import org.yaml.snakeyaml.events.ImplicitTuple;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.NodeEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;
import org.yaml.snakeyaml.parser.Parser;
import org.yaml.snakeyaml.parser.ParserException;
import org.yaml.snakeyaml.parser.ParserImpl$ParseBlockMappingFirstKey;
import org.yaml.snakeyaml.parser.ParserImpl$ParseBlockSequenceFirstEntry;
import org.yaml.snakeyaml.parser.ParserImpl$ParseFlowMappingFirstKey;
import org.yaml.snakeyaml.parser.ParserImpl$ParseFlowSequenceFirstEntry;
import org.yaml.snakeyaml.parser.ParserImpl$ParseIndentlessSequenceEntryKey;
import org.yaml.snakeyaml.parser.ParserImpl$ParseStreamStart;
import org.yaml.snakeyaml.parser.Production;
import org.yaml.snakeyaml.parser.VersionTagsTuple;
import org.yaml.snakeyaml.reader.StreamReader;
import org.yaml.snakeyaml.scanner.Scanner;
import org.yaml.snakeyaml.scanner.ScannerImpl;
import org.yaml.snakeyaml.tokens.AliasToken;
import org.yaml.snakeyaml.tokens.AnchorToken;
import org.yaml.snakeyaml.tokens.CommentToken;
import org.yaml.snakeyaml.tokens.DirectiveToken;
import org.yaml.snakeyaml.tokens.ScalarToken;
import org.yaml.snakeyaml.tokens.TagToken;
import org.yaml.snakeyaml.tokens.TagTuple;
import org.yaml.snakeyaml.tokens.Token;
import org.yaml.snakeyaml.tokens.Token$ID;
import org.yaml.snakeyaml.util.ArrayStack;

public class ParserImpl
implements Parser {
    private static final Map<String, String> DEFAULT_TAGS = new HashMap<String, String>();
    protected final Scanner scanner;
    private Event currentEvent;
    private final ArrayStack<Production> states;
    private final ArrayStack<Mark> marks;
    private Production state;
    private VersionTagsTuple directives;

    public ParserImpl(StreamReader streamReader, LoaderOptions loaderOptions) {
        this(new ScannerImpl(streamReader, loaderOptions));
    }

    public ParserImpl(Scanner scanner) {
        this.scanner = scanner;
        this.currentEvent = null;
        this.directives = new VersionTagsTuple(null, new HashMap<String, String>(DEFAULT_TAGS));
        this.states = new ArrayStack(100);
        this.marks = new ArrayStack(10);
        this.state = new ParserImpl$ParseStreamStart(this, null);
    }

    @Override
    public boolean checkEvent(Event$ID event$ID) {
        this.peekEvent();
        return this.currentEvent != null && this.currentEvent.is(event$ID);
    }

    @Override
    public Event peekEvent() {
        if (this.currentEvent == null && this.state != null) {
            this.currentEvent = this.state.produce();
        }
        return this.currentEvent;
    }

    @Override
    public Event getEvent() {
        this.peekEvent();
        Event event = this.currentEvent;
        this.currentEvent = null;
        return event;
    }

    private CommentEvent produceCommentEvent(CommentToken commentToken) {
        Mark mark = commentToken.getStartMark();
        Mark mark2 = commentToken.getEndMark();
        String string = commentToken.getValue();
        CommentType commentType = commentToken.getCommentType();
        return new CommentEvent(commentType, string, mark, mark2);
    }

    private VersionTagsTuple processDirectives() {
        Object object;
        HashMap<String, String> hashMap = new HashMap<String, String>(this.directives.getTags());
        for (String list : DEFAULT_TAGS.keySet()) {
            hashMap.remove(list);
        }
        this.directives = new VersionTagsTuple(null, hashMap);
        while (this.scanner.checkToken(Token$ID.Directive)) {
            Object object2;
            object = (DirectiveToken)this.scanner.getToken();
            if (((DirectiveToken)object).getName().equals("YAML")) {
                if (this.directives.getVersion() != null) {
                    throw new ParserException(null, null, "found duplicate YAML directive", ((Token)object).getStartMark());
                }
                List list = ((DirectiveToken)object).getValue();
                Integer n2 = (Integer)list.get(0);
                if (n2 != 1) {
                    throw new ParserException(null, null, "found incompatible YAML document (version 1.* is required)", ((Token)object).getStartMark());
                }
                object2 = (Integer)list.get(1);
                if ((Integer)object2 == 0) {
                    this.directives = new VersionTagsTuple(DumperOptions$Version.V1_0, hashMap);
                    continue;
                }
                this.directives = new VersionTagsTuple(DumperOptions$Version.V1_1, hashMap);
                continue;
            }
            if (!((DirectiveToken)object).getName().equals("TAG")) continue;
            List list = ((DirectiveToken)object).getValue();
            String string = (String)list.get(0);
            object2 = (String)list.get(1);
            if (hashMap.containsKey(string)) {
                throw new ParserException(null, null, "duplicate tag handle " + string, ((Token)object).getStartMark());
            }
            hashMap.put(string, (String)object2);
        }
        object = new HashMap();
        if (!hashMap.isEmpty()) {
            object = new HashMap<String, String>(hashMap);
        }
        for (String string : DEFAULT_TAGS.keySet()) {
            if (hashMap.containsKey(string)) continue;
            hashMap.put(string, DEFAULT_TAGS.get(string));
        }
        return new VersionTagsTuple(this.directives.getVersion(), (Map<String, String>)object);
    }

    private Event parseFlowNode() {
        return this.parseNode(false, false);
    }

    private Event parseBlockNodeOrIndentlessSequence() {
        return this.parseNode(true, true);
    }

    private Event parseNode(boolean bl2, boolean bl3) {
        NodeEvent nodeEvent;
        Mark mark = null;
        Mark mark2 = null;
        Mark mark3 = null;
        if (this.scanner.checkToken(Token$ID.Alias)) {
            AliasToken aliasToken = (AliasToken)this.scanner.getToken();
            nodeEvent = new AliasEvent(aliasToken.getValue(), aliasToken.getStartMark(), aliasToken.getEndMark());
            this.state = this.states.pop();
        } else {
            boolean bl4;
            Object object;
            Object object2;
            Object object3;
            String string = null;
            TagTuple tagTuple = null;
            if (this.scanner.checkToken(Token$ID.Anchor)) {
                object3 = (AnchorToken)this.scanner.getToken();
                mark = ((Token)object3).getStartMark();
                mark2 = ((Token)object3).getEndMark();
                string = ((AnchorToken)object3).getValue();
                if (this.scanner.checkToken(Token$ID.Tag)) {
                    object2 = (TagToken)this.scanner.getToken();
                    mark3 = ((Token)object2).getStartMark();
                    mark2 = ((Token)object2).getEndMark();
                    tagTuple = ((TagToken)object2).getValue();
                }
            } else if (this.scanner.checkToken(Token$ID.Tag)) {
                object3 = (TagToken)this.scanner.getToken();
                mark3 = mark = ((Token)object3).getStartMark();
                mark2 = ((Token)object3).getEndMark();
                tagTuple = ((TagToken)object3).getValue();
                if (this.scanner.checkToken(Token$ID.Anchor)) {
                    object2 = (AnchorToken)this.scanner.getToken();
                    mark2 = ((Token)object2).getEndMark();
                    string = ((AnchorToken)object2).getValue();
                }
            }
            object3 = null;
            if (tagTuple != null) {
                object2 = tagTuple.getHandle();
                object = tagTuple.getSuffix();
                if (object2 != null) {
                    if (!this.directives.getTags().containsKey(object2)) {
                        throw new ParserException("while parsing a node", mark, "found undefined tag handle " + (String)object2, mark3);
                    }
                    object3 = this.directives.getTags().get(object2) + (String)object;
                } else {
                    object3 = object;
                }
            }
            if (mark == null) {
                mark2 = mark = this.scanner.peekToken().getStartMark();
            }
            nodeEvent = null;
            boolean bl5 = bl4 = object3 == null || ((String)object3).equals("!");
            if (bl3 && this.scanner.checkToken(Token$ID.BlockEntry)) {
                mark2 = this.scanner.peekToken().getEndMark();
                nodeEvent = new SequenceStartEvent(string, (String)object3, bl4, mark, mark2, DumperOptions$FlowStyle.BLOCK);
                this.state = new ParserImpl$ParseIndentlessSequenceEntryKey(this, null);
            } else if (this.scanner.checkToken(Token$ID.Scalar)) {
                object = (ScalarToken)this.scanner.getToken();
                mark2 = ((Token)object).getEndMark();
                ImplicitTuple implicitTuple = ((ScalarToken)object).getPlain() && object3 == null || "!".equals(object3) ? new ImplicitTuple(true, false) : (object3 == null ? new ImplicitTuple(false, true) : new ImplicitTuple(false, false));
                nodeEvent = new ScalarEvent(string, (String)object3, implicitTuple, ((ScalarToken)object).getValue(), mark, mark2, ((ScalarToken)object).getStyle());
                this.state = this.states.pop();
            } else if (this.scanner.checkToken(Token$ID.FlowSequenceStart)) {
                mark2 = this.scanner.peekToken().getEndMark();
                nodeEvent = new SequenceStartEvent(string, (String)object3, bl4, mark, mark2, DumperOptions$FlowStyle.FLOW);
                this.state = new ParserImpl$ParseFlowSequenceFirstEntry(this, null);
            } else if (this.scanner.checkToken(Token$ID.FlowMappingStart)) {
                mark2 = this.scanner.peekToken().getEndMark();
                nodeEvent = new MappingStartEvent(string, (String)object3, bl4, mark, mark2, DumperOptions$FlowStyle.FLOW);
                this.state = new ParserImpl$ParseFlowMappingFirstKey(this, null);
            } else if (bl2 && this.scanner.checkToken(Token$ID.BlockSequenceStart)) {
                mark2 = this.scanner.peekToken().getStartMark();
                nodeEvent = new SequenceStartEvent(string, (String)object3, bl4, mark, mark2, DumperOptions$FlowStyle.BLOCK);
                this.state = new ParserImpl$ParseBlockSequenceFirstEntry(this, null);
            } else if (bl2 && this.scanner.checkToken(Token$ID.BlockMappingStart)) {
                mark2 = this.scanner.peekToken().getStartMark();
                nodeEvent = new MappingStartEvent(string, (String)object3, bl4, mark, mark2, DumperOptions$FlowStyle.BLOCK);
                this.state = new ParserImpl$ParseBlockMappingFirstKey(this, null);
            } else if (string != null || object3 != null) {
                nodeEvent = new ScalarEvent(string, (String)object3, new ImplicitTuple(bl4, false), "", mark, mark2, DumperOptions$ScalarStyle.PLAIN);
                this.state = this.states.pop();
            } else {
                object = this.scanner.peekToken();
                throw new ParserException("while parsing a " + (bl2 ? "block" : "flow") + " node", mark, "expected the node content, but found '" + (Object)((Object)((Token)object).getTokenId()) + "'", ((Token)object).getStartMark());
            }
        }
        return nodeEvent;
    }

    private Event processEmptyScalar(Mark mark) {
        return new ScalarEvent(null, null, new ImplicitTuple(true, false), "", mark, mark, DumperOptions$ScalarStyle.PLAIN);
    }

    static /* synthetic */ Production access$102(ParserImpl parserImpl, Production production) {
        parserImpl.state = production;
        return parserImpl.state;
    }

    static /* synthetic */ CommentEvent access$300(ParserImpl parserImpl, CommentToken commentToken) {
        return parserImpl.produceCommentEvent(commentToken);
    }

    static /* synthetic */ ArrayStack access$500(ParserImpl parserImpl) {
        return parserImpl.states;
    }

    static /* synthetic */ VersionTagsTuple access$800(ParserImpl parserImpl) {
        return parserImpl.processDirectives();
    }

    static /* synthetic */ ArrayStack access$1000(ParserImpl parserImpl) {
        return parserImpl.marks;
    }

    static /* synthetic */ Event access$1100(ParserImpl parserImpl, Mark mark) {
        return parserImpl.processEmptyScalar(mark);
    }

    static /* synthetic */ Event access$1200(ParserImpl parserImpl, boolean bl2, boolean bl3) {
        return parserImpl.parseNode(bl2, bl3);
    }

    static /* synthetic */ Event access$2100(ParserImpl parserImpl) {
        return parserImpl.parseBlockNodeOrIndentlessSequence();
    }

    static /* synthetic */ Production access$100(ParserImpl parserImpl) {
        return parserImpl.state;
    }

    static /* synthetic */ Event access$2400(ParserImpl parserImpl) {
        return parserImpl.parseFlowNode();
    }

    static {
        DEFAULT_TAGS.put("!", "!");
        DEFAULT_TAGS.put("!!", "tag:yaml.org,2002:");
    }
}

