/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.external.com.google.gdata.util.common.base;

import org.yaml.snakeyaml.external.com.google.gdata.util.common.base.Escaper;
import org.yaml.snakeyaml.external.com.google.gdata.util.common.base.UnicodeEscaper$1;
import org.yaml.snakeyaml.external.com.google.gdata.util.common.base.UnicodeEscaper$2;

public abstract class UnicodeEscaper
implements Escaper {
    private static final int DEST_PAD = 32;
    private static final ThreadLocal<char[]> DEST_TL = new UnicodeEscaper$2();

    protected abstract char[] escape(int var1);

    protected int nextEscapeIndex(CharSequence charSequence, int n2, int n3) {
        int n4;
        int n5;
        for (n4 = n2; n4 < n3 && (n5 = UnicodeEscaper.codePointAt(charSequence, n4, n3)) >= 0 && this.escape(n5) == null; n4 += Character.isSupplementaryCodePoint(n5) ? 2 : 1) {
        }
        return n4;
    }

    @Override
    public String escape(String string) {
        int n2 = string.length();
        int n3 = this.nextEscapeIndex(string, 0, n2);
        return n3 == n2 ? string : this.escapeSlow(string, n3);
    }

    protected final String escapeSlow(String string, int n2) {
        int n3;
        int n4 = string.length();
        char[] cArray = DEST_TL.get();
        int n5 = 0;
        int n6 = 0;
        while (n2 < n4) {
            n3 = UnicodeEscaper.codePointAt(string, n2, n4);
            if (n3 < 0) {
                throw new IllegalArgumentException("Trailing high surrogate at end of input");
            }
            char[] cArray2 = this.escape(n3);
            if (cArray2 != null) {
                int n7 = n2 - n6;
                int n8 = n5 + n7 + cArray2.length;
                if (cArray.length < n8) {
                    int n9 = n8 + (n4 - n2) + 32;
                    cArray = UnicodeEscaper.growBuffer(cArray, n5, n9);
                }
                if (n7 > 0) {
                    string.getChars(n6, n2, cArray, n5);
                    n5 += n7;
                }
                if (cArray2.length > 0) {
                    System.arraycopy(cArray2, 0, cArray, n5, cArray2.length);
                    n5 += cArray2.length;
                }
            }
            n6 = n2 + (Character.isSupplementaryCodePoint(n3) ? 2 : 1);
            n2 = this.nextEscapeIndex(string, n6, n4);
        }
        n3 = n4 - n6;
        if (n3 > 0) {
            int n10 = n5 + n3;
            if (cArray.length < n10) {
                cArray = UnicodeEscaper.growBuffer(cArray, n5, n10);
            }
            string.getChars(n6, n4, cArray, n5);
            n5 = n10;
        }
        return new String(cArray, 0, n5);
    }

    @Override
    public Appendable escape(Appendable appendable) {
        assert (appendable != null);
        return new UnicodeEscaper$1(this, appendable);
    }

    protected static final int codePointAt(CharSequence charSequence, int n2, int n3) {
        if (n2 < n3) {
            char c2;
            if ((c2 = charSequence.charAt(n2++)) < '\ud800' || c2 > '\udfff') {
                return c2;
            }
            if (c2 <= '\udbff') {
                if (n2 == n3) {
                    return -c2;
                }
                char c3 = charSequence.charAt(n2);
                if (Character.isLowSurrogate(c3)) {
                    return Character.toCodePoint(c2, c3);
                }
                throw new IllegalArgumentException("Expected low surrogate but got char '" + c3 + "' with value " + c3 + " at index " + n2);
            }
            throw new IllegalArgumentException("Unexpected low surrogate character '" + c2 + "' with value " + c2 + " at index " + (n2 - 1));
        }
        throw new IndexOutOfBoundsException("Index exceeds specified range");
    }

    private static final char[] growBuffer(char[] cArray, int n2, int n3) {
        char[] cArray2 = new char[n3];
        if (n2 > 0) {
            System.arraycopy(cArray, 0, cArray2, 0, n2);
        }
        return cArray2;
    }
}

