/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.emitter;

import java.io.Writer;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.DumperOptions$ScalarStyle;
import org.yaml.snakeyaml.DumperOptions$Version;
import org.yaml.snakeyaml.comments.CommentEventsCollector;
import org.yaml.snakeyaml.comments.CommentLine;
import org.yaml.snakeyaml.comments.CommentType;
import org.yaml.snakeyaml.emitter.Emitable;
import org.yaml.snakeyaml.emitter.Emitter$ExpectFirstBlockMappingKey;
import org.yaml.snakeyaml.emitter.Emitter$ExpectFirstBlockSequenceItem;
import org.yaml.snakeyaml.emitter.Emitter$ExpectFirstFlowMappingKey;
import org.yaml.snakeyaml.emitter.Emitter$ExpectFirstFlowSequenceItem;
import org.yaml.snakeyaml.emitter.Emitter$ExpectStreamStart;
import org.yaml.snakeyaml.emitter.EmitterException;
import org.yaml.snakeyaml.emitter.EmitterState;
import org.yaml.snakeyaml.emitter.ScalarAnalysis;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.CollectionEndEvent;
import org.yaml.snakeyaml.events.CollectionStartEvent;
import org.yaml.snakeyaml.events.CommentEvent;
import org.yaml.snakeyaml.events.DocumentEndEvent;
import org.yaml.snakeyaml.events.DocumentStartEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.Event$ID;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.NodeEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceEndEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;
import org.yaml.snakeyaml.events.StreamEndEvent;
import org.yaml.snakeyaml.events.StreamStartEvent;
import org.yaml.snakeyaml.reader.StreamReader;
import org.yaml.snakeyaml.scanner.Constant;
import org.yaml.snakeyaml.util.ArrayStack;

public final class Emitter
implements Emitable {
    public static final int MIN_INDENT = 1;
    public static final int MAX_INDENT = 10;
    private static final char[] SPACE = new char[]{' '};
    private static final Pattern SPACES_PATTERN = Pattern.compile("\\s");
    private static final Set<Character> INVALID_ANCHOR = new HashSet<Character>();
    private static final Map<Character, String> ESCAPE_REPLACEMENTS;
    private static final Map<String, String> DEFAULT_TAG_PREFIXES;
    private final Writer stream;
    private final ArrayStack<EmitterState> states;
    private EmitterState state;
    private final Queue<Event> events;
    private Event event;
    private final ArrayStack<Integer> indents;
    private Integer indent;
    private int flowLevel;
    private boolean rootContext;
    private boolean mappingContext;
    private boolean simpleKeyContext;
    private int column;
    private boolean whitespace;
    private boolean indention;
    private boolean openEnded;
    private final Boolean canonical;
    private final Boolean prettyFlow;
    private final boolean allowUnicode;
    private int bestIndent;
    private final int indicatorIndent;
    private final boolean indentWithIndicator;
    private int bestWidth;
    private final char[] bestLineBreak;
    private final boolean splitLines;
    private final int maxSimpleKeyLength;
    private final boolean emitComments;
    private Map<String, String> tagPrefixes;
    private String preparedAnchor;
    private String preparedTag;
    private ScalarAnalysis analysis;
    private DumperOptions$ScalarStyle style;
    private final CommentEventsCollector blockCommentsCollector;
    private final CommentEventsCollector inlineCommentsCollector;
    private static final Pattern HANDLE_FORMAT;

    public Emitter(Writer writer, DumperOptions dumperOptions) {
        if (writer == null) {
            throw new NullPointerException("Writer must be provided.");
        }
        if (dumperOptions == null) {
            throw new NullPointerException("DumperOptions must be provided.");
        }
        this.stream = writer;
        this.states = new ArrayStack(100);
        this.state = new Emitter$ExpectStreamStart(this, null);
        this.events = new ArrayDeque<Event>(100);
        this.event = null;
        this.indents = new ArrayStack(10);
        this.indent = null;
        this.flowLevel = 0;
        this.mappingContext = false;
        this.simpleKeyContext = false;
        this.column = 0;
        this.whitespace = true;
        this.indention = true;
        this.openEnded = false;
        this.canonical = dumperOptions.isCanonical();
        this.prettyFlow = dumperOptions.isPrettyFlow();
        this.allowUnicode = dumperOptions.isAllowUnicode();
        this.bestIndent = 2;
        if (dumperOptions.getIndent() > 1 && dumperOptions.getIndent() < 10) {
            this.bestIndent = dumperOptions.getIndent();
        }
        this.indicatorIndent = dumperOptions.getIndicatorIndent();
        this.indentWithIndicator = dumperOptions.getIndentWithIndicator();
        this.bestWidth = 80;
        if (dumperOptions.getWidth() > this.bestIndent * 2) {
            this.bestWidth = dumperOptions.getWidth();
        }
        this.bestLineBreak = dumperOptions.getLineBreak().getString().toCharArray();
        this.splitLines = dumperOptions.getSplitLines();
        this.maxSimpleKeyLength = dumperOptions.getMaxSimpleKeyLength();
        this.emitComments = dumperOptions.isProcessComments();
        this.tagPrefixes = new LinkedHashMap<String, String>();
        this.preparedAnchor = null;
        this.preparedTag = null;
        this.analysis = null;
        this.style = null;
        this.blockCommentsCollector = new CommentEventsCollector(this.events, CommentType.BLANK_LINE, CommentType.BLOCK);
        this.inlineCommentsCollector = new CommentEventsCollector(this.events, CommentType.IN_LINE);
    }

    @Override
    public void emit(Event event) {
        this.events.add(event);
        while (!this.needMoreEvents()) {
            this.event = this.events.poll();
            this.state.expect();
            this.event = null;
        }
    }

    private boolean needMoreEvents() {
        if (this.events.isEmpty()) {
            return true;
        }
        Iterator<Event> iterator = this.events.iterator();
        Event event = (Event)iterator.next();
        while (event instanceof CommentEvent) {
            if (!iterator.hasNext()) {
                return true;
            }
            event = (Event)iterator.next();
        }
        if (event instanceof DocumentStartEvent) {
            return this.needEvents(iterator, 1);
        }
        if (event instanceof SequenceStartEvent) {
            return this.needEvents(iterator, 2);
        }
        if (event instanceof MappingStartEvent) {
            return this.needEvents(iterator, 3);
        }
        if (event instanceof StreamStartEvent) {
            return this.needEvents(iterator, 2);
        }
        if (event instanceof StreamEndEvent) {
            return false;
        }
        if (this.emitComments) {
            return this.needEvents(iterator, 1);
        }
        return false;
    }

    private boolean needEvents(Iterator<Event> iterator, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (iterator.hasNext()) {
            Event event = iterator.next();
            if (event instanceof CommentEvent) continue;
            ++n4;
            if (event instanceof DocumentStartEvent || event instanceof CollectionStartEvent) {
                ++n3;
            } else if (event instanceof DocumentEndEvent || event instanceof CollectionEndEvent) {
                --n3;
            } else if (event instanceof StreamEndEvent) {
                n3 = -1;
            }
            if (n3 >= 0) continue;
            return false;
        }
        return n4 < n2;
    }

    private void increaseIndent(boolean bl2, boolean bl3) {
        this.indents.push(this.indent);
        if (this.indent == null) {
            this.indent = bl2 ? Integer.valueOf(this.bestIndent) : Integer.valueOf(0);
        } else if (!bl3) {
            this.indent = this.indent + this.bestIndent;
        }
    }

    private void expectNode(boolean bl2, boolean bl3, boolean bl4) {
        this.rootContext = bl2;
        this.mappingContext = bl3;
        this.simpleKeyContext = bl4;
        if (this.event instanceof AliasEvent) {
            this.expectAlias();
        } else if (this.event instanceof ScalarEvent || this.event instanceof CollectionStartEvent) {
            this.processAnchor("&");
            this.processTag();
            if (this.event instanceof ScalarEvent) {
                this.expectScalar();
            } else if (this.event instanceof SequenceStartEvent) {
                if (this.flowLevel != 0 || this.canonical.booleanValue() || ((SequenceStartEvent)this.event).isFlow() || this.checkEmptySequence()) {
                    this.expectFlowSequence();
                } else {
                    this.expectBlockSequence();
                }
            } else if (this.flowLevel != 0 || this.canonical.booleanValue() || ((MappingStartEvent)this.event).isFlow() || this.checkEmptyMapping()) {
                this.expectFlowMapping();
            } else {
                this.expectBlockMapping();
            }
        } else {
            throw new EmitterException("expected NodeEvent, but got " + this.event);
        }
    }

    private void expectAlias() {
        if (!(this.event instanceof AliasEvent)) {
            throw new EmitterException("Alias must be provided");
        }
        this.processAnchor("*");
        this.state = this.states.pop();
    }

    private void expectScalar() {
        this.increaseIndent(true, false);
        this.processScalar();
        this.indent = this.indents.pop();
        this.state = this.states.pop();
    }

    private void expectFlowSequence() {
        this.writeIndicator("[", true, true, false);
        ++this.flowLevel;
        this.increaseIndent(true, false);
        if (this.prettyFlow.booleanValue()) {
            this.writeIndent();
        }
        this.state = new Emitter$ExpectFirstFlowSequenceItem(this, null);
    }

    private void expectFlowMapping() {
        this.writeIndicator("{", true, true, false);
        ++this.flowLevel;
        this.increaseIndent(true, false);
        if (this.prettyFlow.booleanValue()) {
            this.writeIndent();
        }
        this.state = new Emitter$ExpectFirstFlowMappingKey(this, null);
    }

    private void expectBlockSequence() {
        boolean bl2 = this.mappingContext && !this.indention;
        this.increaseIndent(false, bl2);
        this.state = new Emitter$ExpectFirstBlockSequenceItem(this, null);
    }

    private void expectBlockMapping() {
        this.increaseIndent(false, false);
        this.state = new Emitter$ExpectFirstBlockMappingKey(this, null);
    }

    private boolean isFoldedOrLiteral(Event event) {
        if (!event.is(Event$ID.Scalar)) {
            return false;
        }
        ScalarEvent scalarEvent = (ScalarEvent)event;
        DumperOptions$ScalarStyle dumperOptions$ScalarStyle = scalarEvent.getScalarStyle();
        return dumperOptions$ScalarStyle == DumperOptions$ScalarStyle.FOLDED || dumperOptions$ScalarStyle == DumperOptions$ScalarStyle.LITERAL;
    }

    private boolean checkEmptySequence() {
        return this.event instanceof SequenceStartEvent && !this.events.isEmpty() && this.events.peek() instanceof SequenceEndEvent;
    }

    private boolean checkEmptyMapping() {
        return this.event instanceof MappingStartEvent && !this.events.isEmpty() && this.events.peek() instanceof MappingEndEvent;
    }

    private boolean checkEmptyDocument() {
        if (!(this.event instanceof DocumentStartEvent) || this.events.isEmpty()) {
            return false;
        }
        Event event = this.events.peek();
        if (event instanceof ScalarEvent) {
            ScalarEvent scalarEvent = (ScalarEvent)event;
            return scalarEvent.getAnchor() == null && scalarEvent.getTag() == null && scalarEvent.getImplicit() != null && scalarEvent.getValue().length() == 0;
        }
        return false;
    }

    private boolean checkSimpleKey() {
        int n2 = 0;
        if (this.event instanceof NodeEvent && ((NodeEvent)this.event).getAnchor() != null) {
            if (this.preparedAnchor == null) {
                this.preparedAnchor = Emitter.prepareAnchor(((NodeEvent)this.event).getAnchor());
            }
            n2 += this.preparedAnchor.length();
        }
        String string = null;
        if (this.event instanceof ScalarEvent) {
            string = ((ScalarEvent)this.event).getTag();
        } else if (this.event instanceof CollectionStartEvent) {
            string = ((CollectionStartEvent)this.event).getTag();
        }
        if (string != null) {
            if (this.preparedTag == null) {
                this.preparedTag = this.prepareTag(string);
            }
            n2 += this.preparedTag.length();
        }
        if (this.event instanceof ScalarEvent) {
            if (this.analysis == null) {
                this.analysis = this.analyzeScalar(((ScalarEvent)this.event).getValue());
            }
            n2 += this.analysis.getScalar().length();
        }
        return n2 < this.maxSimpleKeyLength && (this.event instanceof AliasEvent || this.event instanceof ScalarEvent && !this.analysis.isEmpty() && !this.analysis.isMultiline() || this.checkEmptySequence() || this.checkEmptyMapping());
    }

    private void processAnchor(String string) {
        NodeEvent nodeEvent = (NodeEvent)this.event;
        if (nodeEvent.getAnchor() == null) {
            this.preparedAnchor = null;
            return;
        }
        if (this.preparedAnchor == null) {
            this.preparedAnchor = Emitter.prepareAnchor(nodeEvent.getAnchor());
        }
        this.writeIndicator(string + this.preparedAnchor, true, false, false);
        this.preparedAnchor = null;
    }

    private void processTag() {
        String string = null;
        if (this.event instanceof ScalarEvent) {
            ScalarEvent scalarEvent = (ScalarEvent)this.event;
            string = scalarEvent.getTag();
            if (this.style == null) {
                this.style = this.chooseScalarStyle();
            }
            if ((!this.canonical.booleanValue() || string == null) && (this.style == null && scalarEvent.getImplicit().canOmitTagInPlainScalar() || this.style != null && scalarEvent.getImplicit().canOmitTagInNonPlainScalar())) {
                this.preparedTag = null;
                return;
            }
            if (scalarEvent.getImplicit().canOmitTagInPlainScalar() && string == null) {
                string = "!";
                this.preparedTag = null;
            }
        } else {
            CollectionStartEvent collectionStartEvent = (CollectionStartEvent)this.event;
            string = collectionStartEvent.getTag();
            if ((!this.canonical.booleanValue() || string == null) && collectionStartEvent.getImplicit()) {
                this.preparedTag = null;
                return;
            }
        }
        if (string == null) {
            throw new EmitterException("tag is not specified");
        }
        if (this.preparedTag == null) {
            this.preparedTag = this.prepareTag(string);
        }
        this.writeIndicator(this.preparedTag, true, false, false);
        this.preparedTag = null;
    }

    private DumperOptions$ScalarStyle chooseScalarStyle() {
        ScalarEvent scalarEvent = (ScalarEvent)this.event;
        if (this.analysis == null) {
            this.analysis = this.analyzeScalar(scalarEvent.getValue());
        }
        if (!scalarEvent.isPlain() && scalarEvent.getScalarStyle() == DumperOptions$ScalarStyle.DOUBLE_QUOTED || this.canonical.booleanValue()) {
            return DumperOptions$ScalarStyle.DOUBLE_QUOTED;
        }
        if (scalarEvent.isPlain() && scalarEvent.getImplicit().canOmitTagInPlainScalar() && (!this.simpleKeyContext || !this.analysis.isEmpty() && !this.analysis.isMultiline()) && (this.flowLevel != 0 && this.analysis.isAllowFlowPlain() || this.flowLevel == 0 && this.analysis.isAllowBlockPlain())) {
            return null;
        }
        if (!(scalarEvent.isPlain() || scalarEvent.getScalarStyle() != DumperOptions$ScalarStyle.LITERAL && scalarEvent.getScalarStyle() != DumperOptions$ScalarStyle.FOLDED || this.flowLevel != 0 || this.simpleKeyContext || !this.analysis.isAllowBlock())) {
            return scalarEvent.getScalarStyle();
        }
        if (!(!scalarEvent.isPlain() && scalarEvent.getScalarStyle() != DumperOptions$ScalarStyle.SINGLE_QUOTED || !this.analysis.isAllowSingleQuoted() || this.simpleKeyContext && this.analysis.isMultiline())) {
            return DumperOptions$ScalarStyle.SINGLE_QUOTED;
        }
        return DumperOptions$ScalarStyle.DOUBLE_QUOTED;
    }

    private void processScalar() {
        boolean bl2;
        ScalarEvent scalarEvent = (ScalarEvent)this.event;
        if (this.analysis == null) {
            this.analysis = this.analyzeScalar(scalarEvent.getValue());
        }
        if (this.style == null) {
            this.style = this.chooseScalarStyle();
        }
        boolean bl3 = bl2 = !this.simpleKeyContext && this.splitLines;
        if (this.style == null) {
            this.writePlain(this.analysis.getScalar(), bl2);
        } else {
            switch (this.style) {
                case DOUBLE_QUOTED: {
                    this.writeDoubleQuoted(this.analysis.getScalar(), bl2);
                    break;
                }
                case SINGLE_QUOTED: {
                    this.writeSingleQuoted(this.analysis.getScalar(), bl2);
                    break;
                }
                case FOLDED: {
                    this.writeFolded(this.analysis.getScalar(), bl2);
                    break;
                }
                case LITERAL: {
                    this.writeLiteral(this.analysis.getScalar());
                    break;
                }
                default: {
                    throw new YAMLException("Unexpected style: " + (Object)((Object)this.style));
                }
            }
        }
        this.analysis = null;
        this.style = null;
    }

    private String prepareVersion(DumperOptions$Version dumperOptions$Version) {
        if (dumperOptions$Version.major() != 1) {
            throw new EmitterException("unsupported YAML version: " + (Object)((Object)dumperOptions$Version));
        }
        return dumperOptions$Version.getRepresentation();
    }

    private String prepareTagHandle(String string) {
        if (string.length() == 0) {
            throw new EmitterException("tag handle must not be empty");
        }
        if (string.charAt(0) != '!' || string.charAt(string.length() - 1) != '!') {
            throw new EmitterException("tag handle must start and end with '!': " + string);
        }
        if (!"!".equals(string) && !HANDLE_FORMAT.matcher(string).matches()) {
            throw new EmitterException("invalid character in the tag handle: " + string);
        }
        return string;
    }

    private String prepareTagPrefix(String string) {
        if (string.length() == 0) {
            throw new EmitterException("tag prefix must not be empty");
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        int n3 = 0;
        if (string.charAt(0) == '!') {
            n3 = 1;
        }
        while (n3 < string.length()) {
            ++n3;
        }
        if (n2 < n3) {
            stringBuilder.append(string, n2, n3);
        }
        return stringBuilder.toString();
    }

    private String prepareTag(String string) {
        int n2;
        String string22;
        if (string.length() == 0) {
            throw new EmitterException("tag must not be empty");
        }
        if ("!".equals(string)) {
            return string;
        }
        String string3 = null;
        String string4 = string;
        for (String string22 : this.tagPrefixes.keySet()) {
            if (!string.startsWith(string22) || !"!".equals(string22) && string22.length() >= string.length()) continue;
            string3 = string22;
        }
        if (string3 != null) {
            string4 = string.substring(string3.length());
            string3 = this.tagPrefixes.get(string3);
        }
        String string5 = string22 = (n2 = string4.length()) > 0 ? string4.substring(0, n2) : "";
        if (string3 != null) {
            return string3 + string22;
        }
        return "!<" + string22 + ">";
    }

    static String prepareAnchor(String string) {
        if (string.length() == 0) {
            throw new EmitterException("anchor must not be empty");
        }
        for (Character c2 : INVALID_ANCHOR) {
            if (string.indexOf(c2.charValue()) <= -1) continue;
            throw new EmitterException("Invalid character '" + c2 + "' in the anchor: " + string);
        }
        Matcher matcher = SPACES_PATTERN.matcher(string);
        if (matcher.find()) {
            throw new EmitterException("Anchor may not contain spaces: " + string);
        }
        return string;
    }

    private static boolean hasLeadingZero(String string) {
        if (string.length() > 1 && string.charAt(0) == '0') {
            for (int i2 = 1; i2 < string.length(); ++i2) {
                boolean bl2;
                char c2 = string.charAt(i2);
                boolean bl3 = bl2 = c2 >= '0' && c2 <= '9' || c2 == '_';
                if (bl2) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private ScalarAnalysis analyzeScalar(String string) {
        int n2;
        int n3;
        int n4;
        if (string.length() == 0) {
            return new ScalarAnalysis(string, true, false, false, true, true, false);
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = Emitter.hasLeadingZero(string);
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = false;
        if (string.startsWith("---") || string.startsWith("...")) {
            bl2 = true;
            bl3 = true;
        }
        boolean bl13 = true;
        boolean bl14 = string.length() == 1 || Constant.NULL_BL_T_LINEBR.has(string.codePointAt(1));
        boolean bl15 = false;
        boolean bl16 = false;
        int n5 = 0;
        while (n5 < string.length()) {
            n4 = string.codePointAt(n5);
            if (n5 == 0) {
                if ("#,[]{}&*!|>'\"%@`".indexOf(n4) != -1) {
                    bl3 = true;
                    bl2 = true;
                }
                if (n4 == 63 || n4 == 58) {
                    bl3 = true;
                    if (bl14) {
                        bl2 = true;
                    }
                }
                if (n4 == 45 && bl14) {
                    bl3 = true;
                    bl2 = true;
                }
            } else {
                if (",?[]{}".indexOf(n4) != -1) {
                    bl3 = true;
                }
                if (n4 == 58) {
                    bl3 = true;
                    if (bl14) {
                        bl2 = true;
                    }
                }
                if (n4 == 35 && bl13) {
                    bl3 = true;
                    bl2 = true;
                }
            }
            if ((n3 = (int)(Constant.LINEBR.has(n4) ? 1 : 0)) != 0) {
                bl4 = true;
            }
            if (n4 != 10 && (32 > n4 || n4 > 126)) {
                if (n4 == 133 || n4 >= 160 && n4 <= 55295 || n4 >= 57344 && n4 <= 65533 || n4 >= 65536 && n4 <= 0x10FFFF) {
                    if (!this.allowUnicode) {
                        bl5 = true;
                    }
                } else {
                    bl5 = true;
                }
            }
            if (n4 == 32) {
                if (n5 == 0) {
                    bl7 = true;
                }
                if (n5 == string.length() - 1) {
                    bl9 = true;
                }
                if (bl16) {
                    bl11 = true;
                }
                bl15 = true;
                bl16 = false;
            } else if (n3 != 0) {
                if (n5 == 0) {
                    bl8 = true;
                }
                if (n5 == string.length() - 1) {
                    bl10 = true;
                }
                if (bl15) {
                    bl12 = true;
                }
                bl15 = false;
                bl16 = true;
            } else {
                bl15 = false;
                bl16 = false;
            }
            bl13 = Constant.NULL_BL_T.has(n4) || n3 != 0;
            bl14 = true;
            if ((n5 += Character.charCount(n4)) + 1 >= string.length() || (n2 = n5 + Character.charCount(string.codePointAt(n5))) >= string.length()) continue;
            bl14 = Constant.NULL_BL_T.has(string.codePointAt(n2)) || n3 != 0;
        }
        n4 = 1;
        n3 = 1;
        n2 = 1;
        int n6 = 1;
        if (bl7 || bl8 || bl9 || bl10 || bl6) {
            n3 = 0;
            n4 = 0;
        }
        if (bl9) {
            n6 = 0;
        }
        if (bl11) {
            n2 = 0;
            n3 = 0;
            n4 = 0;
        }
        if (bl12 || bl5) {
            n6 = 0;
            n2 = 0;
            n3 = 0;
            n4 = 0;
        }
        if (bl4) {
            n4 = 0;
        }
        if (bl3) {
            n4 = 0;
        }
        if (bl2) {
            n3 = 0;
        }
        return new ScalarAnalysis(string, false, bl4, n4 != 0, n3 != 0, n2 != 0, n6 != 0);
    }

    void flushStream() {
        this.stream.flush();
    }

    void writeStreamStart() {
    }

    void writeStreamEnd() {
        this.flushStream();
    }

    void writeIndicator(String string, boolean bl2, boolean bl3, boolean bl4) {
        if (!this.whitespace && bl2) {
            ++this.column;
            this.stream.write(SPACE);
        }
        this.whitespace = bl3;
        this.indention = this.indention && bl4;
        this.column += string.length();
        this.openEnded = false;
        this.stream.write(string);
    }

    void writeIndent() {
        int n2 = this.indent != null ? this.indent : 0;
        if (!this.indention || this.column > n2 || this.column == n2 && !this.whitespace) {
            this.writeLineBreak(null);
        }
        this.writeWhitespace(n2 - this.column);
    }

    private void writeWhitespace(int n2) {
        if (n2 <= 0) {
            return;
        }
        this.whitespace = true;
        char[] cArray = new char[n2];
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            cArray[i2] = 32;
        }
        this.column += n2;
        this.stream.write(cArray);
    }

    private void writeLineBreak(String string) {
        this.whitespace = true;
        this.indention = true;
        this.column = 0;
        if (string == null) {
            this.stream.write(this.bestLineBreak);
        } else {
            this.stream.write(string);
        }
    }

    void writeVersionDirective(String string) {
        this.stream.write("%YAML ");
        this.stream.write(string);
        this.writeLineBreak(null);
    }

    void writeTagDirective(String string, String string2) {
        this.stream.write("%TAG ");
        this.stream.write(string);
        this.stream.write(SPACE);
        this.stream.write(string2);
        this.writeLineBreak(null);
    }

    private void writeSingleQuoted(String string, boolean bl2) {
        this.writeIndicator("'", true, false, false);
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = 0;
        for (int i2 = 0; i2 <= string.length(); ++i2) {
            int n3;
            char c2 = '\u0000';
            if (i2 < string.length()) {
                c2 = string.charAt(i2);
            }
            if (bl3) {
                if (c2 == '\u0000' || c2 != ' ') {
                    if (n2 + 1 == i2 && this.column > this.bestWidth && bl2 && n2 != 0 && i2 != string.length()) {
                        this.writeIndent();
                    } else {
                        n3 = i2 - n2;
                        this.column += n3;
                        this.stream.write(string, n2, n3);
                    }
                    n2 = i2;
                }
            } else if (bl4) {
                if (c2 == '\u0000' || Constant.LINEBR.hasNo(c2)) {
                    if (string.charAt(n2) == '\n') {
                        this.writeLineBreak(null);
                    }
                    String string2 = string.substring(n2, i2);
                    for (char c3 : string2.toCharArray()) {
                        if (c3 == '\n') {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak(String.valueOf(c3));
                    }
                    this.writeIndent();
                    n2 = i2;
                }
            } else if (Constant.LINEBR.has(c2, "\u0000 '") && n2 < i2) {
                n3 = i2 - n2;
                this.column += n3;
                this.stream.write(string, n2, n3);
                n2 = i2;
            }
            if (c2 == '\'') {
                this.column += 2;
                this.stream.write("''");
                n2 = i2 + 1;
            }
            if (c2 == '\u0000') continue;
            bl3 = c2 == ' ';
            bl4 = Constant.LINEBR.has(c2);
        }
        this.writeIndicator("'", false, false, false);
    }

    private void writeDoubleQuoted(String string, boolean bl2) {
        this.writeIndicator("\"", true, false, false);
        int n2 = 0;
        for (int i2 = 0; i2 <= string.length(); ++i2) {
            Character c2 = null;
            if (i2 < string.length()) {
                c2 = Character.valueOf(string.charAt(i2));
            }
            if (c2 == null || "\"\\\u0085\u2028\u2029\ufeff".indexOf(c2.charValue()) != -1 || ' ' > c2.charValue() || c2.charValue() > '~') {
                if (n2 < i2) {
                    int n3 = i2 - n2;
                    this.column += n3;
                    this.stream.write(string, n2, n3);
                    n2 = i2;
                }
                if (c2 != null) {
                    String string2;
                    if (ESCAPE_REPLACEMENTS.containsKey(c2)) {
                        string2 = "\\" + ESCAPE_REPLACEMENTS.get(c2);
                    } else {
                        int n4;
                        if (Character.isHighSurrogate(c2.charValue()) && i2 + 1 < string.length()) {
                            char c3 = string.charAt(i2 + 1);
                            n4 = Character.toCodePoint(c2.charValue(), c3);
                        } else {
                            n4 = c2.charValue();
                        }
                        if (this.allowUnicode && StreamReader.isPrintable(n4)) {
                            string2 = String.valueOf(Character.toChars(n4));
                            if (Character.charCount(n4) == 2) {
                                ++i2;
                            }
                        } else if (c2.charValue() <= '\u00ff') {
                            String string3 = "0" + Integer.toString(c2.charValue(), 16);
                            string2 = "\\x" + string3.substring(string3.length() - 2);
                        } else if (Character.charCount(n4) == 2) {
                            ++i2;
                            String string4 = "000" + Long.toHexString(n4);
                            string2 = "\\U" + string4.substring(string4.length() - 8);
                        } else {
                            String string5 = "000" + Integer.toString(c2.charValue(), 16);
                            string2 = "\\u" + string5.substring(string5.length() - 4);
                        }
                    }
                    this.column += string2.length();
                    this.stream.write(string2);
                    n2 = i2 + 1;
                }
            }
            if (0 >= i2 || i2 >= string.length() - 1 || c2.charValue() != ' ' && n2 < i2 || this.column + (i2 - n2) <= this.bestWidth || !bl2) continue;
            String string6 = n2 >= i2 ? "\\" : string.substring(n2, i2) + "\\";
            if (n2 < i2) {
                n2 = i2;
            }
            this.column += string6.length();
            this.stream.write(string6);
            this.writeIndent();
            this.whitespace = false;
            this.indention = false;
            if (string.charAt(n2) != ' ') continue;
            string6 = "\\";
            this.column += string6.length();
            this.stream.write(string6);
        }
        this.writeIndicator("\"", false, false, false);
    }

    private boolean writeCommentLines(List<CommentLine> list) {
        boolean bl2 = false;
        if (this.emitComments) {
            int n2 = 0;
            boolean bl3 = true;
            for (CommentLine commentLine : list) {
                if (commentLine.getCommentType() != CommentType.BLANK_LINE) {
                    if (bl3) {
                        bl3 = false;
                        this.writeIndicator("#", commentLine.getCommentType() == CommentType.IN_LINE, false, false);
                        n2 = this.column > 0 ? this.column - 1 : 0;
                    } else {
                        this.writeWhitespace(n2);
                        this.writeIndicator("#", false, false, false);
                    }
                    this.stream.write(commentLine.getValue());
                    this.writeLineBreak(null);
                } else {
                    this.writeLineBreak(null);
                    this.writeIndent();
                }
                bl2 = true;
            }
        }
        return bl2;
    }

    private void writeBlockComment() {
        if (!this.blockCommentsCollector.isEmpty()) {
            this.writeIndent();
            this.writeCommentLines(this.blockCommentsCollector.consume());
        }
    }

    private boolean writeInlineComments() {
        return this.writeCommentLines(this.inlineCommentsCollector.consume());
    }

    private String determineBlockHints(String string) {
        char c2;
        StringBuilder stringBuilder = new StringBuilder();
        if (Constant.LINEBR.has(string.charAt(0), " ")) {
            stringBuilder.append(this.bestIndent);
        }
        if (Constant.LINEBR.hasNo(c2 = string.charAt(string.length() - 1))) {
            stringBuilder.append("-");
        } else if (string.length() == 1 || Constant.LINEBR.has(string.charAt(string.length() - 2))) {
            stringBuilder.append("+");
        }
        return stringBuilder.toString();
    }

    void writeFolded(String string, boolean bl2) {
        String string2 = this.determineBlockHints(string);
        this.writeIndicator(">" + string2, true, false, false);
        if (string2.length() > 0 && string2.charAt(string2.length() - 1) == '+') {
            this.openEnded = true;
        }
        if (!this.writeInlineComments()) {
            this.writeLineBreak(null);
        }
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = true;
        int n2 = 0;
        for (int i2 = 0; i2 <= string.length(); ++i2) {
            char c2 = '\u0000';
            if (i2 < string.length()) {
                c2 = string.charAt(i2);
            }
            if (bl5) {
                if (c2 == '\u0000' || Constant.LINEBR.hasNo(c2)) {
                    if (!bl3 && c2 != '\u0000' && c2 != ' ' && string.charAt(n2) == '\n') {
                        this.writeLineBreak(null);
                    }
                    bl3 = c2 == ' ';
                    String string3 = string.substring(n2, i2);
                    for (char c3 : string3.toCharArray()) {
                        if (c3 == '\n') {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak(String.valueOf(c3));
                    }
                    if (c2 != '\u0000') {
                        this.writeIndent();
                    }
                    n2 = i2;
                }
            } else if (bl4) {
                if (c2 != ' ') {
                    if (n2 + 1 == i2 && this.column > this.bestWidth && bl2) {
                        this.writeIndent();
                    } else {
                        int n3 = i2 - n2;
                        this.column += n3;
                        this.stream.write(string, n2, n3);
                    }
                    n2 = i2;
                }
            } else if (Constant.LINEBR.has(c2, "\u0000 ")) {
                int n4 = i2 - n2;
                this.column += n4;
                this.stream.write(string, n2, n4);
                if (c2 == '\u0000') {
                    this.writeLineBreak(null);
                }
                n2 = i2;
            }
            if (c2 == '\u0000') continue;
            bl5 = Constant.LINEBR.has(c2);
            bl4 = c2 == ' ';
        }
    }

    void writeLiteral(String string) {
        String string2 = this.determineBlockHints(string);
        this.writeIndicator("|" + string2, true, false, false);
        if (string2.length() > 0 && string2.charAt(string2.length() - 1) == '+') {
            this.openEnded = true;
        }
        if (!this.writeInlineComments()) {
            this.writeLineBreak(null);
        }
        boolean bl2 = true;
        int n2 = 0;
        for (int i2 = 0; i2 <= string.length(); ++i2) {
            char c2 = '\u0000';
            if (i2 < string.length()) {
                c2 = string.charAt(i2);
            }
            if (bl2) {
                if (c2 == '\u0000' || Constant.LINEBR.hasNo(c2)) {
                    String string3 = string.substring(n2, i2);
                    for (char c3 : string3.toCharArray()) {
                        if (c3 == '\n') {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak(String.valueOf(c3));
                    }
                    if (c2 != '\u0000') {
                        this.writeIndent();
                    }
                    n2 = i2;
                }
            } else if (c2 == '\u0000' || Constant.LINEBR.has(c2)) {
                this.stream.write(string, n2, i2 - n2);
                if (c2 == '\u0000') {
                    this.writeLineBreak(null);
                }
                n2 = i2;
            }
            if (c2 == '\u0000') continue;
            bl2 = Constant.LINEBR.has(c2);
        }
    }

    void writePlain(String string, boolean bl2) {
        if (this.rootContext) {
            this.openEnded = true;
        }
        if (string.length() == 0) {
            return;
        }
        if (!this.whitespace) {
            ++this.column;
            this.stream.write(SPACE);
        }
        this.whitespace = false;
        this.indention = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = 0;
        for (int i2 = 0; i2 <= string.length(); ++i2) {
            int n3;
            char c2 = '\u0000';
            if (i2 < string.length()) {
                c2 = string.charAt(i2);
            }
            if (bl3) {
                if (c2 != ' ') {
                    if (n2 + 1 == i2 && this.column > this.bestWidth && bl2) {
                        this.writeIndent();
                        this.whitespace = false;
                        this.indention = false;
                    } else {
                        n3 = i2 - n2;
                        this.column += n3;
                        this.stream.write(string, n2, n3);
                    }
                    n2 = i2;
                }
            } else if (bl4) {
                if (Constant.LINEBR.hasNo(c2)) {
                    if (string.charAt(n2) == '\n') {
                        this.writeLineBreak(null);
                    }
                    String string2 = string.substring(n2, i2);
                    for (char c3 : string2.toCharArray()) {
                        if (c3 == '\n') {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak(String.valueOf(c3));
                    }
                    this.writeIndent();
                    this.whitespace = false;
                    this.indention = false;
                    n2 = i2;
                }
            } else if (Constant.LINEBR.has(c2, "\u0000 ")) {
                n3 = i2 - n2;
                this.column += n3;
                this.stream.write(string, n2, n3);
                n2 = i2;
            }
            if (c2 == '\u0000') continue;
            bl3 = c2 == ' ';
            bl4 = Constant.LINEBR.has(c2);
        }
    }

    static /* synthetic */ Event access$100(Emitter emitter) {
        return emitter.event;
    }

    static /* synthetic */ EmitterState access$202(Emitter emitter, EmitterState emitterState) {
        emitter.state = emitterState;
        return emitter.state;
    }

    static /* synthetic */ boolean access$400(Emitter emitter) {
        return emitter.openEnded;
    }

    static /* synthetic */ String access$500(Emitter emitter, DumperOptions$Version dumperOptions$Version) {
        return emitter.prepareVersion(dumperOptions$Version);
    }

    static /* synthetic */ Map access$602(Emitter emitter, Map map) {
        emitter.tagPrefixes = map;
        return emitter.tagPrefixes;
    }

    static /* synthetic */ Map access$700() {
        return DEFAULT_TAG_PREFIXES;
    }

    static /* synthetic */ Map access$600(Emitter emitter) {
        return emitter.tagPrefixes;
    }

    static /* synthetic */ String access$800(Emitter emitter, String string) {
        return emitter.prepareTagHandle(string);
    }

    static /* synthetic */ String access$900(Emitter emitter, String string) {
        return emitter.prepareTagPrefix(string);
    }

    static /* synthetic */ Boolean access$1000(Emitter emitter) {
        return emitter.canonical;
    }

    static /* synthetic */ boolean access$1100(Emitter emitter) {
        return emitter.checkEmptyDocument();
    }

    static /* synthetic */ CommentEventsCollector access$1400(Emitter emitter) {
        return emitter.blockCommentsCollector;
    }

    static /* synthetic */ void access$1500(Emitter emitter) {
        emitter.writeBlockComment();
    }

    static /* synthetic */ Event access$102(Emitter emitter, Event event) {
        emitter.event = event;
        return emitter.event;
    }

    static /* synthetic */ ArrayStack access$1700(Emitter emitter) {
        return emitter.states;
    }

    static /* synthetic */ void access$1800(Emitter emitter, boolean bl2, boolean bl3, boolean bl4) {
        emitter.expectNode(bl2, bl3, bl4);
    }

    static /* synthetic */ Integer access$2002(Emitter emitter, Integer n2) {
        emitter.indent = n2;
        return emitter.indent;
    }

    static /* synthetic */ ArrayStack access$2100(Emitter emitter) {
        return emitter.indents;
    }

    static /* synthetic */ int access$2210(Emitter emitter) {
        return emitter.flowLevel--;
    }

    static /* synthetic */ CommentEventsCollector access$2300(Emitter emitter) {
        return emitter.inlineCommentsCollector;
    }

    static /* synthetic */ boolean access$2400(Emitter emitter) {
        return emitter.writeInlineComments();
    }

    static /* synthetic */ int access$2500(Emitter emitter) {
        return emitter.column;
    }

    static /* synthetic */ int access$2600(Emitter emitter) {
        return emitter.bestWidth;
    }

    static /* synthetic */ boolean access$2700(Emitter emitter) {
        return emitter.splitLines;
    }

    static /* synthetic */ Boolean access$2800(Emitter emitter) {
        return emitter.prettyFlow;
    }

    static /* synthetic */ boolean access$3100(Emitter emitter) {
        return emitter.checkSimpleKey();
    }

    static /* synthetic */ boolean access$3600(Emitter emitter) {
        return emitter.indentWithIndicator;
    }

    static /* synthetic */ int access$3700(Emitter emitter) {
        return emitter.indicatorIndent;
    }

    static /* synthetic */ void access$3800(Emitter emitter, int n2) {
        emitter.writeWhitespace(n2);
    }

    static /* synthetic */ Integer access$2000(Emitter emitter) {
        return emitter.indent;
    }

    static /* synthetic */ void access$3900(Emitter emitter, boolean bl2, boolean bl3) {
        emitter.increaseIndent(bl2, bl3);
    }

    static /* synthetic */ ScalarAnalysis access$4002(Emitter emitter, ScalarAnalysis scalarAnalysis) {
        emitter.analysis = scalarAnalysis;
        return emitter.analysis;
    }

    static /* synthetic */ ScalarAnalysis access$4100(Emitter emitter, String string) {
        return emitter.analyzeScalar(string);
    }

    static /* synthetic */ ScalarAnalysis access$4000(Emitter emitter) {
        return emitter.analysis;
    }

    static /* synthetic */ boolean access$4500(Emitter emitter, Event event) {
        return emitter.isFoldedOrLiteral(event);
    }

    static {
        INVALID_ANCHOR.add(Character.valueOf('['));
        INVALID_ANCHOR.add(Character.valueOf(']'));
        INVALID_ANCHOR.add(Character.valueOf('{'));
        INVALID_ANCHOR.add(Character.valueOf('}'));
        INVALID_ANCHOR.add(Character.valueOf(','));
        INVALID_ANCHOR.add(Character.valueOf('*'));
        INVALID_ANCHOR.add(Character.valueOf('&'));
        ESCAPE_REPLACEMENTS = new HashMap<Character, String>();
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\u0000'), "0");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\u0007'), "a");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\b'), "b");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\t'), "t");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\n'), "n");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\u000b'), "v");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\f'), "f");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\r'), "r");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\u001b'), "e");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\"'), "\"");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\\'), "\\");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\u0085'), "N");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\u00a0'), "_");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\u2028'), "L");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\u2029'), "P");
        DEFAULT_TAG_PREFIXES = new LinkedHashMap<String, String>();
        DEFAULT_TAG_PREFIXES.put("!", "!");
        DEFAULT_TAG_PREFIXES.put("tag:yaml.org,2002:", "!!");
        HANDLE_FORMAT = Pattern.compile("^![-_\\w]*!$");
    }
}

