/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.constructor;

import java.util.Collection;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.constructor.Constructor$ConstructMapping;
import org.yaml.snakeyaml.constructor.Constructor$ConstructScalar;
import org.yaml.snakeyaml.constructor.Constructor$ConstructSequence;
import org.yaml.snakeyaml.constructor.Constructor$ConstructYamlObject;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.Tag;

public class Constructor
extends SafeConstructor {
    public Constructor(LoaderOptions loaderOptions) {
        this(Object.class, loaderOptions);
    }

    public Constructor(Class<? extends Object> clazz, LoaderOptions loaderOptions) {
        this(new TypeDescription(Constructor.checkRoot(clazz)), null, loaderOptions);
    }

    private static Class<? extends Object> checkRoot(Class<? extends Object> clazz) {
        if (clazz == null) {
            throw new NullPointerException("Root class must be provided.");
        }
        return clazz;
    }

    public Constructor(TypeDescription typeDescription, LoaderOptions loaderOptions) {
        this(typeDescription, null, loaderOptions);
    }

    public Constructor(TypeDescription typeDescription, Collection<TypeDescription> collection, LoaderOptions loaderOptions) {
        super(loaderOptions);
        if (typeDescription == null) {
            throw new NullPointerException("Root type must be provided.");
        }
        this.yamlConstructors.put(null, new Constructor$ConstructYamlObject(this));
        if (!Object.class.equals(typeDescription.getType())) {
            this.rootTag = new Tag(typeDescription.getType());
        }
        this.yamlClassConstructors.put(NodeId.scalar, new Constructor$ConstructScalar(this));
        this.yamlClassConstructors.put(NodeId.mapping, new Constructor$ConstructMapping(this));
        this.yamlClassConstructors.put(NodeId.sequence, new Constructor$ConstructSequence(this));
        this.addTypeDescription(typeDescription);
        if (collection != null) {
            for (TypeDescription typeDescription2 : collection) {
                this.addTypeDescription(typeDescription2);
            }
        }
    }

    public Constructor(String string, LoaderOptions loaderOptions) {
        this(Class.forName(Constructor.check(string)), loaderOptions);
    }

    private static String check(String string) {
        if (string == null) {
            throw new NullPointerException("Root type must be provided.");
        }
        if (string.trim().length() == 0) {
            throw new YAMLException("Root type must be provided.");
        }
        return string;
    }

    protected Class<?> getClassForNode(Node node) {
        Class clazz = (Class)this.typeTags.get(node.getTag());
        if (clazz == null) {
            Class<?> clazz2;
            String string = node.getTag().getClassName();
            try {
                clazz2 = this.getClassForName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new YAMLException("Class not found: " + string);
            }
            this.typeTags.put(node.getTag(), clazz2);
            return clazz2;
        }
        return clazz;
    }

    protected Class<?> getClassForName(String string) {
        try {
            return Class.forName(string, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Class.forName(string);
        }
    }
}

