/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.simple;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.simple.SimpleLogger;

public class SimpleLoggerFactory
implements ILoggerFactory {
    ConcurrentMap<String, Logger> loggerMap = new ConcurrentHashMap<String, Logger>();

    public SimpleLoggerFactory() {
        SimpleLogger.lazyInit();
    }

    @Override
    public Logger getLogger(String string) {
        return this.loggerMap.computeIfAbsent(string, this::createLogger);
    }

    protected Logger createLogger(String string) {
        return new SimpleLogger(string);
    }

    protected void reset() {
        this.loggerMap.clear();
    }
}

