/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.simple;

import java.io.PrintStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.event.LoggingEvent;
import org.slf4j.helpers.LegacyAbstractLogger;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.helpers.NormalizedParameters;
import org.slf4j.simple.SimpleLoggerConfiguration;

public class SimpleLogger
extends LegacyAbstractLogger {
    private static final long serialVersionUID = -632788891211436180L;
    private static final long START_TIME = System.currentTimeMillis();
    protected static final int LOG_LEVEL_TRACE = 0;
    protected static final int LOG_LEVEL_DEBUG = 10;
    protected static final int LOG_LEVEL_INFO = 20;
    protected static final int LOG_LEVEL_WARN = 30;
    protected static final int LOG_LEVEL_ERROR = 40;
    static char SP = (char)32;
    static final String TID_PREFIX = "tid=";
    protected static final int LOG_LEVEL_OFF = 50;
    private static boolean INITIALIZED = false;
    static final SimpleLoggerConfiguration CONFIG_PARAMS = new SimpleLoggerConfiguration();
    protected int currentLogLevel = 20;
    private transient String shortLogName = null;
    public static final String SYSTEM_PREFIX = "org.slf4j.simpleLogger.";
    public static final String LOG_KEY_PREFIX = "org.slf4j.simpleLogger.log.";
    public static final String CACHE_OUTPUT_STREAM_STRING_KEY = "org.slf4j.simpleLogger.cacheOutputStream";
    public static final String WARN_LEVEL_STRING_KEY = "org.slf4j.simpleLogger.warnLevelString";
    public static final String LEVEL_IN_BRACKETS_KEY = "org.slf4j.simpleLogger.levelInBrackets";
    public static final String LOG_FILE_KEY = "org.slf4j.simpleLogger.logFile";
    public static final String SHOW_SHORT_LOG_NAME_KEY = "org.slf4j.simpleLogger.showShortLogName";
    public static final String SHOW_LOG_NAME_KEY = "org.slf4j.simpleLogger.showLogName";
    public static final String SHOW_THREAD_NAME_KEY = "org.slf4j.simpleLogger.showThreadName";
    public static final String SHOW_THREAD_ID_KEY = "org.slf4j.simpleLogger.showThreadId";
    public static final String DATE_TIME_FORMAT_KEY = "org.slf4j.simpleLogger.dateTimeFormat";
    public static final String SHOW_DATE_TIME_KEY = "org.slf4j.simpleLogger.showDateTime";
    public static final String DEFAULT_LOG_LEVEL_KEY = "org.slf4j.simpleLogger.defaultLogLevel";

    static void lazyInit() {
        if (INITIALIZED) {
            return;
        }
        INITIALIZED = true;
        SimpleLogger.init();
    }

    static void init() {
        CONFIG_PARAMS.init();
    }

    protected SimpleLogger(String string) {
        this.name = string;
        String string2 = this.recursivelyComputeLevelString();
        this.currentLogLevel = string2 != null ? SimpleLoggerConfiguration.stringToLevel(string2) : SimpleLogger.CONFIG_PARAMS.defaultLogLevel;
    }

    String recursivelyComputeLevelString() {
        String string = this.name;
        String string2 = null;
        int n2 = string.length();
        while (string2 == null && n2 > -1) {
            string = string.substring(0, n2);
            string2 = CONFIG_PARAMS.getStringProperty(LOG_KEY_PREFIX + string, null);
            n2 = String.valueOf(string).lastIndexOf(".");
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(StringBuilder stringBuilder, Throwable throwable) {
        PrintStream printStream = SimpleLogger.CONFIG_PARAMS.outputChoice.getTargetPrintStream();
        SimpleLoggerConfiguration simpleLoggerConfiguration = CONFIG_PARAMS;
        synchronized (simpleLoggerConfiguration) {
            printStream.println(stringBuilder.toString());
            this.writeThrowable(throwable, printStream);
            printStream.flush();
        }
    }

    protected void writeThrowable(Throwable throwable, PrintStream printStream) {
        if (throwable != null) {
            throwable.printStackTrace(printStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFormattedDate() {
        String string;
        Date date = new Date();
        DateFormat dateFormat = SimpleLogger.CONFIG_PARAMS.dateFormatter;
        synchronized (dateFormat) {
            string = SimpleLogger.CONFIG_PARAMS.dateFormatter.format(date);
        }
        return string;
    }

    private String computeShortName() {
        return this.name.substring(this.name.lastIndexOf(".") + 1);
    }

    protected boolean isLevelEnabled(int n2) {
        return n2 >= this.currentLogLevel;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isLevelEnabled(0);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isLevelEnabled(10);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isLevelEnabled(20);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isLevelEnabled(30);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isLevelEnabled(40);
    }

    @Override
    protected void handleNormalizedLoggingCall(Level level, Marker marker, String string, Object[] objectArray, Throwable throwable) {
        ArrayList<Marker> arrayList = null;
        if (marker != null) {
            arrayList = new ArrayList<Marker>();
            arrayList.add(marker);
        }
        this.innerHandleNormalizedLoggingCall(level, arrayList, string, objectArray, throwable);
    }

    private void innerHandleNormalizedLoggingCall(Level level, List<Marker> list, String string, Object[] objectArray, Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder(32);
        if (SimpleLogger.CONFIG_PARAMS.showDateTime) {
            if (SimpleLogger.CONFIG_PARAMS.dateFormatter != null) {
                stringBuilder.append(this.getFormattedDate());
                stringBuilder.append(SP);
            } else {
                stringBuilder.append(System.currentTimeMillis() - START_TIME);
                stringBuilder.append(SP);
            }
        }
        if (SimpleLogger.CONFIG_PARAMS.showThreadName) {
            stringBuilder.append('[');
            stringBuilder.append(Thread.currentThread().getName());
            stringBuilder.append("] ");
        }
        if (SimpleLogger.CONFIG_PARAMS.showThreadId) {
            stringBuilder.append(TID_PREFIX);
            stringBuilder.append(Thread.currentThread().getId());
            stringBuilder.append(SP);
        }
        if (SimpleLogger.CONFIG_PARAMS.levelInBrackets) {
            stringBuilder.append('[');
        }
        String string2 = this.renderLevel(level.toInt());
        stringBuilder.append(string2);
        if (SimpleLogger.CONFIG_PARAMS.levelInBrackets) {
            stringBuilder.append(']');
        }
        stringBuilder.append(SP);
        if (SimpleLogger.CONFIG_PARAMS.showShortLogName) {
            if (this.shortLogName == null) {
                this.shortLogName = this.computeShortName();
            }
            stringBuilder.append(String.valueOf(this.shortLogName)).append(" - ");
        } else if (SimpleLogger.CONFIG_PARAMS.showLogName) {
            stringBuilder.append(String.valueOf(this.name)).append(" - ");
        }
        if (list != null) {
            stringBuilder.append(SP);
            for (Marker marker : list) {
                stringBuilder.append(marker.getName()).append(SP);
            }
        }
        String string3 = MessageFormatter.basicArrayFormat(string, objectArray);
        stringBuilder.append(string3);
        this.write(stringBuilder, throwable);
    }

    protected String renderLevel(int n2) {
        switch (n2) {
            case 0: {
                return "TRACE";
            }
            case 10: {
                return "DEBUG";
            }
            case 20: {
                return "INFO";
            }
            case 30: {
                return "WARN";
            }
            case 40: {
                return "ERROR";
            }
        }
        throw new IllegalStateException("Unrecognized level [" + n2 + "]");
    }

    public void log(LoggingEvent loggingEvent) {
        int n2 = loggingEvent.getLevel().toInt();
        if (!this.isLevelEnabled(n2)) {
            return;
        }
        NormalizedParameters normalizedParameters = NormalizedParameters.normalize(loggingEvent);
        this.innerHandleNormalizedLoggingCall(loggingEvent.getLevel(), loggingEvent.getMarkers(), normalizedParameters.getMessage(), normalizedParameters.getArguments(), loggingEvent.getThrowable());
    }

    @Override
    protected String getFullyQualifiedCallerName() {
        return null;
    }
}

