/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.io.PrintStream;
import org.slf4j.helpers.Reporter$Level;
import org.slf4j.helpers.Reporter$TargetChoice;

public class Reporter {
    static final String SLF4J_INFO_PREFIX = "SLF4J(I): ";
    static final String SLF4J_WARN_PREFIX = "SLF4J(W): ";
    static final String SLF4J_ERROR_PREFIX = "SLF4J(E): ";
    public static final String SLF4J_INTERNAL_REPORT_STREAM_KEY = "slf4j.internal.report.stream";
    private static final String[] SYSOUT_KEYS = new String[]{"System.out", "stdout", "sysout"};
    public static final String SLF4J_INTERNAL_VERBOSITY_KEY = "slf4j.internal.verbosity";
    private static final Reporter$TargetChoice TARGET_CHOICE = Reporter.initTargetChoice();
    private static final Reporter$Level INTERNAL_VERBOSITY = Reporter.initVerbosity();

    private static Reporter$TargetChoice initTargetChoice() {
        String string = System.getProperty(SLF4J_INTERNAL_REPORT_STREAM_KEY);
        if (string == null || string.isEmpty()) {
            return Reporter$TargetChoice.Stderr;
        }
        for (String string2 : SYSOUT_KEYS) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return Reporter$TargetChoice.Stdout;
        }
        return Reporter$TargetChoice.Stderr;
    }

    private static Reporter$Level initVerbosity() {
        String string = System.getProperty(SLF4J_INTERNAL_VERBOSITY_KEY);
        if (string == null || string.isEmpty()) {
            return Reporter$Level.INFO;
        }
        if (string.equalsIgnoreCase("ERROR")) {
            return Reporter$Level.ERROR;
        }
        if (string.equalsIgnoreCase("WARN")) {
            return Reporter$Level.WARN;
        }
        return Reporter$Level.INFO;
    }

    static boolean isEnabledFor(Reporter$Level reporter$Level) {
        return reporter$Level.levelInt >= Reporter.INTERNAL_VERBOSITY.levelInt;
    }

    private static PrintStream getTarget() {
        switch (TARGET_CHOICE.ordinal()) {
            case 1: {
                return System.out;
            }
        }
        return System.err;
    }

    public static void info(String string) {
        if (Reporter.isEnabledFor(Reporter$Level.INFO)) {
            Reporter.getTarget().println(SLF4J_INFO_PREFIX + string);
        }
    }

    public static final void warn(String string) {
        if (Reporter.isEnabledFor(Reporter$Level.WARN)) {
            Reporter.getTarget().println(SLF4J_WARN_PREFIX + string);
        }
    }

    public static final void error(String string, Throwable throwable) {
        Reporter.getTarget().println(SLF4J_ERROR_PREFIX + string);
        Reporter.getTarget().println("SLF4J(E): Reported exception:");
        throwable.printStackTrace(Reporter.getTarget());
    }

    public static final void error(String string) {
        Reporter.getTarget().println(SLF4J_ERROR_PREFIX + string);
    }
}

