/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.tinyfd;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Platform;

public class TinyFileDialogs {
    public static final String tinyfd_version;
    public static final String tinyfd_needs;
    public static final IntBuffer tinyfd_verbose;
    public static final IntBuffer tinyfd_silent;
    public static final IntBuffer tinyfd_forceConsole;

    protected TinyFileDialogs() {
        throw new UnsupportedOperationException();
    }

    private static native long ntinyfd_version();

    @NativeType(value="char *")
    private static String tinyfd_version() {
        long l2 = TinyFileDialogs.ntinyfd_version();
        return MemoryUtil.memASCII(l2);
    }

    private static native long ntinyfd_needs();

    @NativeType(value="char *")
    private static String tinyfd_needs() {
        long l2 = TinyFileDialogs.ntinyfd_needs();
        return MemoryUtil.memASCII(l2);
    }

    private static native long ntinyfd_verbose();

    @NativeType(value="int *")
    private static IntBuffer tinyfd_verbose() {
        long l2 = TinyFileDialogs.ntinyfd_verbose();
        return MemoryUtil.memIntBuffer(l2, 1);
    }

    private static native long ntinyfd_silent();

    @NativeType(value="int *")
    private static IntBuffer tinyfd_silent() {
        long l2 = TinyFileDialogs.ntinyfd_silent();
        return MemoryUtil.memIntBuffer(l2, 1);
    }

    private static native long ntinyfd_winUtf8();

    @NativeType(value="int *")
    private static IntBuffer tinyfd_winUtf8() {
        long l2 = TinyFileDialogs.ntinyfd_winUtf8();
        return MemoryUtil.memIntBuffer(l2, 1);
    }

    private static native long ntinyfd_forceConsole();

    @NativeType(value="int *")
    private static IntBuffer tinyfd_forceConsole() {
        long l2 = TinyFileDialogs.ntinyfd_forceConsole();
        return MemoryUtil.memIntBuffer(l2, 1);
    }

    public static native long ntinyfd_response();

    @NativeType(value="char *")
    public static String tinyfd_response() {
        long l2 = TinyFileDialogs.ntinyfd_response();
        return MemoryUtil.memUTF8(l2);
    }

    public static native void tinyfd_beep();

    public static native int ntinyfd_notifyPopup(long var0, long var2, long var4);

    public static int tinyfd_notifyPopup(@NativeType(value="char const *") ByteBuffer byteBuffer, @NativeType(value="char const *") ByteBuffer byteBuffer2, @NativeType(value="char const *") ByteBuffer byteBuffer3) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(byteBuffer);
            Checks.checkNT1Safe(byteBuffer2);
            Checks.checkNT1(byteBuffer3);
        }
        return TinyFileDialogs.ntinyfd_notifyPopup(MemoryUtil.memAddressSafe(byteBuffer), MemoryUtil.memAddressSafe(byteBuffer2), MemoryUtil.memAddress(byteBuffer3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int tinyfd_notifyPopup(@NativeType(value="char const *") CharSequence charSequence, @NativeType(value="char const *") CharSequence charSequence2, @NativeType(value="char const *") CharSequence charSequence3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8Safe(charSequence, true);
            long l2 = charSequence == null ? 0L : memoryStack.getPointerAddress();
            memoryStack.nUTF8Safe(charSequence2, true);
            long l3 = charSequence2 == null ? 0L : memoryStack.getPointerAddress();
            memoryStack.nASCII(charSequence3, true);
            long l4 = memoryStack.getPointerAddress();
            int n3 = TinyFileDialogs.ntinyfd_notifyPopup(l2, l3, l4);
            return n3;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static native int ntinyfd_messageBox(long var0, long var2, long var4, long var6, int var8);

    @NativeType(value="int")
    public static boolean tinyfd_messageBox(@NativeType(value="char const *") ByteBuffer byteBuffer, @NativeType(value="char const *") ByteBuffer byteBuffer2, @NativeType(value="char const *") ByteBuffer byteBuffer3, @NativeType(value="char const *") ByteBuffer byteBuffer4, @NativeType(value="int") boolean bl2) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(byteBuffer);
            Checks.checkNT1Safe(byteBuffer2);
            Checks.checkNT1(byteBuffer3);
            Checks.checkNT1(byteBuffer4);
        }
        return TinyFileDialogs.ntinyfd_messageBox(MemoryUtil.memAddressSafe(byteBuffer), MemoryUtil.memAddressSafe(byteBuffer2), MemoryUtil.memAddress(byteBuffer3), MemoryUtil.memAddress(byteBuffer4), bl2 ? 1 : 0) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="int")
    public static boolean tinyfd_messageBox(@NativeType(value="char const *") CharSequence charSequence, @NativeType(value="char const *") CharSequence charSequence2, @NativeType(value="char const *") CharSequence charSequence3, @NativeType(value="char const *") CharSequence charSequence4, @NativeType(value="int") boolean bl2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8Safe(charSequence, true);
            long l2 = charSequence == null ? 0L : memoryStack.getPointerAddress();
            memoryStack.nUTF8Safe(charSequence2, true);
            long l3 = charSequence2 == null ? 0L : memoryStack.getPointerAddress();
            memoryStack.nASCII(charSequence3, true);
            long l4 = memoryStack.getPointerAddress();
            memoryStack.nASCII(charSequence4, true);
            long l5 = memoryStack.getPointerAddress();
            boolean bl3 = TinyFileDialogs.ntinyfd_messageBox(l2, l3, l4, l5, bl2 ? 1 : 0) != 0;
            return bl3;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static native long ntinyfd_inputBox(long var0, long var2, long var4);

    @NativeType(value="char const *")
    public static String tinyfd_inputBox(@NativeType(value="char const *") ByteBuffer byteBuffer, @NativeType(value="char const *") ByteBuffer byteBuffer2, @NativeType(value="char const *") ByteBuffer byteBuffer3) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(byteBuffer);
            Checks.checkNT1Safe(byteBuffer2);
            Checks.checkNT1Safe(byteBuffer3);
        }
        long l2 = TinyFileDialogs.ntinyfd_inputBox(MemoryUtil.memAddressSafe(byteBuffer), MemoryUtil.memAddressSafe(byteBuffer2), MemoryUtil.memAddressSafe(byteBuffer3));
        return MemoryUtil.memUTF8Safe(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char const *")
    public static String tinyfd_inputBox(@NativeType(value="char const *") CharSequence charSequence, @NativeType(value="char const *") CharSequence charSequence2, @NativeType(value="char const *") CharSequence charSequence3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8Safe(charSequence, true);
            long l2 = charSequence == null ? 0L : memoryStack.getPointerAddress();
            memoryStack.nUTF8Safe(charSequence2, true);
            long l3 = charSequence2 == null ? 0L : memoryStack.getPointerAddress();
            memoryStack.nUTF8Safe(charSequence3, true);
            long l4 = charSequence3 == null ? 0L : memoryStack.getPointerAddress();
            long l5 = TinyFileDialogs.ntinyfd_inputBox(l2, l3, l4);
            String string = MemoryUtil.memUTF8Safe(l5);
            return string;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static native long ntinyfd_saveFileDialog(long var0, long var2, int var4, long var5, long var7);

    @NativeType(value="char const *")
    public static String tinyfd_saveFileDialog(@NativeType(value="char const *") ByteBuffer byteBuffer, @NativeType(value="char const *") ByteBuffer byteBuffer2, @NativeType(value="char const * const *") PointerBuffer pointerBuffer, @NativeType(value="char const *") ByteBuffer byteBuffer3) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(byteBuffer);
            Checks.checkNT1Safe(byteBuffer2);
            Checks.checkNT1Safe(byteBuffer3);
        }
        long l2 = TinyFileDialogs.ntinyfd_saveFileDialog(MemoryUtil.memAddressSafe(byteBuffer), MemoryUtil.memAddressSafe(byteBuffer2), Checks.remainingSafe(pointerBuffer), MemoryUtil.memAddressSafe(pointerBuffer), MemoryUtil.memAddressSafe(byteBuffer3));
        return MemoryUtil.memUTF8Safe(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char const *")
    public static String tinyfd_saveFileDialog(@NativeType(value="char const *") CharSequence charSequence, @NativeType(value="char const *") CharSequence charSequence2, @NativeType(value="char const * const *") PointerBuffer pointerBuffer, @NativeType(value="char const *") CharSequence charSequence3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8Safe(charSequence, true);
            long l2 = charSequence == null ? 0L : memoryStack.getPointerAddress();
            memoryStack.nUTF8Safe(charSequence2, true);
            long l3 = charSequence2 == null ? 0L : memoryStack.getPointerAddress();
            memoryStack.nUTF8Safe(charSequence3, true);
            long l4 = charSequence3 == null ? 0L : memoryStack.getPointerAddress();
            long l5 = TinyFileDialogs.ntinyfd_saveFileDialog(l2, l3, Checks.remainingSafe(pointerBuffer), MemoryUtil.memAddressSafe(pointerBuffer), l4);
            String string = MemoryUtil.memUTF8Safe(l5);
            return string;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static native long ntinyfd_openFileDialog(long var0, long var2, int var4, long var5, long var7, int var9);

    @NativeType(value="char const *")
    public static String tinyfd_openFileDialog(@NativeType(value="char const *") ByteBuffer byteBuffer, @NativeType(value="char const *") ByteBuffer byteBuffer2, @NativeType(value="char const * const *") PointerBuffer pointerBuffer, @NativeType(value="char const *") ByteBuffer byteBuffer3, @NativeType(value="int") boolean bl2) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(byteBuffer);
            Checks.checkNT1Safe(byteBuffer2);
            Checks.checkNT1Safe(byteBuffer3);
        }
        long l2 = TinyFileDialogs.ntinyfd_openFileDialog(MemoryUtil.memAddressSafe(byteBuffer), MemoryUtil.memAddressSafe(byteBuffer2), Checks.remainingSafe(pointerBuffer), MemoryUtil.memAddressSafe(pointerBuffer), MemoryUtil.memAddressSafe(byteBuffer3), bl2 ? 1 : 0);
        return MemoryUtil.memUTF8Safe(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char const *")
    public static String tinyfd_openFileDialog(@NativeType(value="char const *") CharSequence charSequence, @NativeType(value="char const *") CharSequence charSequence2, @NativeType(value="char const * const *") PointerBuffer pointerBuffer, @NativeType(value="char const *") CharSequence charSequence3, @NativeType(value="int") boolean bl2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8Safe(charSequence, true);
            long l2 = charSequence == null ? 0L : memoryStack.getPointerAddress();
            memoryStack.nUTF8Safe(charSequence2, true);
            long l3 = charSequence2 == null ? 0L : memoryStack.getPointerAddress();
            memoryStack.nUTF8Safe(charSequence3, true);
            long l4 = charSequence3 == null ? 0L : memoryStack.getPointerAddress();
            long l5 = TinyFileDialogs.ntinyfd_openFileDialog(l2, l3, Checks.remainingSafe(pointerBuffer), MemoryUtil.memAddressSafe(pointerBuffer), l4, bl2 ? 1 : 0);
            String string = MemoryUtil.memUTF8Safe(l5);
            return string;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static native long ntinyfd_selectFolderDialog(long var0, long var2);

    @NativeType(value="char const *")
    public static String tinyfd_selectFolderDialog(@NativeType(value="char const *") ByteBuffer byteBuffer, @NativeType(value="char const *") ByteBuffer byteBuffer2) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(byteBuffer);
            Checks.checkNT1(byteBuffer2);
        }
        long l2 = TinyFileDialogs.ntinyfd_selectFolderDialog(MemoryUtil.memAddressSafe(byteBuffer), MemoryUtil.memAddress(byteBuffer2));
        return MemoryUtil.memUTF8Safe(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char const *")
    public static String tinyfd_selectFolderDialog(@NativeType(value="char const *") CharSequence charSequence, @NativeType(value="char const *") CharSequence charSequence2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8Safe(charSequence, true);
            long l2 = charSequence == null ? 0L : memoryStack.getPointerAddress();
            memoryStack.nUTF8(charSequence2, true);
            long l3 = memoryStack.getPointerAddress();
            long l4 = TinyFileDialogs.ntinyfd_selectFolderDialog(l2, l3);
            String string = MemoryUtil.memUTF8Safe(l4);
            return string;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static native long ntinyfd_colorChooser(long var0, long var2, long var4, long var6);

    @NativeType(value="char const *")
    public static String tinyfd_colorChooser(@NativeType(value="char const *") ByteBuffer byteBuffer, @NativeType(value="char const *") ByteBuffer byteBuffer2, @NativeType(value="unsigned char *") ByteBuffer byteBuffer3, @NativeType(value="unsigned char *") ByteBuffer byteBuffer4) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(byteBuffer);
            Checks.checkNT1Safe(byteBuffer2);
            Checks.checkSafe((Buffer)byteBuffer3, 3);
            Checks.check((Buffer)byteBuffer4, 3);
        }
        long l2 = TinyFileDialogs.ntinyfd_colorChooser(MemoryUtil.memAddressSafe(byteBuffer), MemoryUtil.memAddressSafe(byteBuffer2), MemoryUtil.memAddressSafe(byteBuffer3), MemoryUtil.memAddress(byteBuffer4));
        return MemoryUtil.memUTF8Safe(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char const *")
    public static String tinyfd_colorChooser(@NativeType(value="char const *") CharSequence charSequence, @NativeType(value="char const *") CharSequence charSequence2, @NativeType(value="unsigned char *") ByteBuffer byteBuffer, @NativeType(value="unsigned char *") ByteBuffer byteBuffer2) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)byteBuffer, 3);
            Checks.check((Buffer)byteBuffer2, 3);
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8Safe(charSequence, true);
            long l2 = charSequence == null ? 0L : memoryStack.getPointerAddress();
            memoryStack.nASCIISafe(charSequence2, true);
            long l3 = charSequence2 == null ? 0L : memoryStack.getPointerAddress();
            long l4 = TinyFileDialogs.ntinyfd_colorChooser(l2, l3, MemoryUtil.memAddressSafe(byteBuffer), MemoryUtil.memAddress(byteBuffer2));
            String string = MemoryUtil.memUTF8Safe(l4);
            return string;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    static {
        Library.loadSystem(System::load, System::loadLibrary, TinyFileDialogs.class, Platform.mapLibraryNameBundled("lwjgl_tinyfd"));
        TinyFileDialogs.tinyfd_winUtf8().put(0, 1);
        tinyfd_version = TinyFileDialogs.tinyfd_version();
        tinyfd_needs = TinyFileDialogs.tinyfd_needs();
        tinyfd_verbose = TinyFileDialogs.tinyfd_verbose();
        tinyfd_silent = TinyFileDialogs.tinyfd_silent();
        tinyfd_forceConsole = TinyFileDialogs.tinyfd_forceConsole();
    }
}

