/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.windows.SECURITY_ATTRIBUTES$Buffer;

public class SECURITY_ATTRIBUTES
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NLENGTH;
    public static final int LPSECURITYDESCRIPTOR;
    public static final int BINHERITHANDLE;

    public SECURITY_ATTRIBUTES(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), SECURITY_ATTRIBUTES.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="DWORD")
    public int nLength() {
        return SECURITY_ATTRIBUTES.nnLength(this.address());
    }

    @NativeType(value="LPVOID")
    public long lpSecurityDescriptor() {
        return SECURITY_ATTRIBUTES.nlpSecurityDescriptor(this.address());
    }

    @NativeType(value="BOOL")
    public boolean bInheritHandle() {
        return SECURITY_ATTRIBUTES.nbInheritHandle(this.address()) != 0;
    }

    public SECURITY_ATTRIBUTES nLength(@NativeType(value="DWORD") int n2) {
        SECURITY_ATTRIBUTES.nnLength(this.address(), n2);
        return this;
    }

    public SECURITY_ATTRIBUTES lpSecurityDescriptor(@NativeType(value="LPVOID") long l2) {
        SECURITY_ATTRIBUTES.nlpSecurityDescriptor(this.address(), l2);
        return this;
    }

    public SECURITY_ATTRIBUTES bInheritHandle(@NativeType(value="BOOL") boolean bl2) {
        SECURITY_ATTRIBUTES.nbInheritHandle(this.address(), bl2 ? 1 : 0);
        return this;
    }

    public SECURITY_ATTRIBUTES set(int n2, long l2, boolean bl2) {
        this.nLength(n2);
        this.lpSecurityDescriptor(l2);
        this.bInheritHandle(bl2);
        return this;
    }

    public SECURITY_ATTRIBUTES set(SECURITY_ATTRIBUTES sECURITY_ATTRIBUTES) {
        MemoryUtil.memCopy(sECURITY_ATTRIBUTES.address(), this.address(), SIZEOF);
        return this;
    }

    public static SECURITY_ATTRIBUTES malloc() {
        return SECURITY_ATTRIBUTES.wrap(SECURITY_ATTRIBUTES.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static SECURITY_ATTRIBUTES calloc() {
        return SECURITY_ATTRIBUTES.wrap(SECURITY_ATTRIBUTES.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static SECURITY_ATTRIBUTES create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return SECURITY_ATTRIBUTES.wrap(SECURITY_ATTRIBUTES.class, MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static SECURITY_ATTRIBUTES create(long l2) {
        return SECURITY_ATTRIBUTES.wrap(SECURITY_ATTRIBUTES.class, l2);
    }

    public static SECURITY_ATTRIBUTES createSafe(long l2) {
        return l2 == 0L ? null : SECURITY_ATTRIBUTES.wrap(SECURITY_ATTRIBUTES.class, l2);
    }

    public static SECURITY_ATTRIBUTES$Buffer malloc(int n2) {
        return SECURITY_ATTRIBUTES.wrap(SECURITY_ATTRIBUTES$Buffer.class, MemoryUtil.nmemAllocChecked(SECURITY_ATTRIBUTES.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static SECURITY_ATTRIBUTES$Buffer calloc(int n2) {
        return SECURITY_ATTRIBUTES.wrap(SECURITY_ATTRIBUTES$Buffer.class, MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static SECURITY_ATTRIBUTES$Buffer create(int n2) {
        ByteBuffer byteBuffer = SECURITY_ATTRIBUTES.__create(n2, SIZEOF);
        return SECURITY_ATTRIBUTES.wrap(SECURITY_ATTRIBUTES$Buffer.class, MemoryUtil.memAddress(byteBuffer), n2, byteBuffer);
    }

    public static SECURITY_ATTRIBUTES$Buffer create(long l2, int n2) {
        return SECURITY_ATTRIBUTES.wrap(SECURITY_ATTRIBUTES$Buffer.class, l2, n2);
    }

    public static SECURITY_ATTRIBUTES$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : SECURITY_ATTRIBUTES.wrap(SECURITY_ATTRIBUTES$Buffer.class, l2, n2);
    }

    public static SECURITY_ATTRIBUTES mallocStack() {
        return SECURITY_ATTRIBUTES.mallocStack(MemoryStack.stackGet());
    }

    public static SECURITY_ATTRIBUTES callocStack() {
        return SECURITY_ATTRIBUTES.callocStack(MemoryStack.stackGet());
    }

    public static SECURITY_ATTRIBUTES mallocStack(MemoryStack memoryStack) {
        return SECURITY_ATTRIBUTES.wrap(SECURITY_ATTRIBUTES.class, memoryStack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static SECURITY_ATTRIBUTES callocStack(MemoryStack memoryStack) {
        return SECURITY_ATTRIBUTES.wrap(SECURITY_ATTRIBUTES.class, memoryStack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static SECURITY_ATTRIBUTES$Buffer mallocStack(int n2) {
        return SECURITY_ATTRIBUTES.mallocStack(n2, MemoryStack.stackGet());
    }

    public static SECURITY_ATTRIBUTES$Buffer callocStack(int n2) {
        return SECURITY_ATTRIBUTES.callocStack(n2, MemoryStack.stackGet());
    }

    public static SECURITY_ATTRIBUTES$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return SECURITY_ATTRIBUTES.wrap(SECURITY_ATTRIBUTES$Buffer.class, memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static SECURITY_ATTRIBUTES$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return SECURITY_ATTRIBUTES.wrap(SECURITY_ATTRIBUTES$Buffer.class, memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int nnLength(long l2) {
        return UNSAFE.getInt(null, l2 + (long)NLENGTH);
    }

    public static long nlpSecurityDescriptor(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)LPSECURITYDESCRIPTOR);
    }

    public static int nbInheritHandle(long l2) {
        return UNSAFE.getInt(null, l2 + (long)BINHERITHANDLE);
    }

    public static void nnLength(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)NLENGTH, n2);
    }

    public static void nlpSecurityDescriptor(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)LPSECURITYDESCRIPTOR, Checks.check(l3));
    }

    public static void nbInheritHandle(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)BINHERITHANDLE, n2);
    }

    public static void validate(long l2) {
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)LPSECURITYDESCRIPTOR));
    }

    public static void validate(long l2, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            SECURITY_ATTRIBUTES.validate(l2 + Integer.toUnsignedLong(i2) * (long)SIZEOF);
        }
    }

    static {
        Struct$Layout struct$Layout = SECURITY_ATTRIBUTES.__struct(SECURITY_ATTRIBUTES.__member(4), SECURITY_ATTRIBUTES.__member(POINTER_SIZE), SECURITY_ATTRIBUTES.__member(4));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        NLENGTH = struct$Layout.offsetof(0);
        LPSECURITYDESCRIPTOR = struct$Layout.offsetof(1);
        BINHERITHANDLE = struct$Layout.offsetof(2);
    }
}

