/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.windows.RECT$Buffer;

public class RECT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LEFT;
    public static final int TOP;
    public static final int RIGHT;
    public static final int BOTTOM;

    public RECT(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), RECT.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LONG")
    public int left() {
        return RECT.nleft(this.address());
    }

    @NativeType(value="LONG")
    public int top() {
        return RECT.ntop(this.address());
    }

    @NativeType(value="LONG")
    public int right() {
        return RECT.nright(this.address());
    }

    @NativeType(value="LONG")
    public int bottom() {
        return RECT.nbottom(this.address());
    }

    public RECT left(@NativeType(value="LONG") int n2) {
        RECT.nleft(this.address(), n2);
        return this;
    }

    public RECT top(@NativeType(value="LONG") int n2) {
        RECT.ntop(this.address(), n2);
        return this;
    }

    public RECT right(@NativeType(value="LONG") int n2) {
        RECT.nright(this.address(), n2);
        return this;
    }

    public RECT bottom(@NativeType(value="LONG") int n2) {
        RECT.nbottom(this.address(), n2);
        return this;
    }

    public RECT set(int n2, int n3, int n4, int n5) {
        this.left(n2);
        this.top(n3);
        this.right(n4);
        this.bottom(n5);
        return this;
    }

    public RECT set(RECT rECT) {
        MemoryUtil.memCopy(rECT.address(), this.address(), SIZEOF);
        return this;
    }

    public static RECT malloc() {
        return RECT.wrap(RECT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static RECT calloc() {
        return RECT.wrap(RECT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static RECT create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return RECT.wrap(RECT.class, MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static RECT create(long l2) {
        return RECT.wrap(RECT.class, l2);
    }

    public static RECT createSafe(long l2) {
        return l2 == 0L ? null : RECT.wrap(RECT.class, l2);
    }

    public static RECT$Buffer malloc(int n2) {
        return RECT.wrap(RECT$Buffer.class, MemoryUtil.nmemAllocChecked(RECT.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static RECT$Buffer calloc(int n2) {
        return RECT.wrap(RECT$Buffer.class, MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static RECT$Buffer create(int n2) {
        ByteBuffer byteBuffer = RECT.__create(n2, SIZEOF);
        return RECT.wrap(RECT$Buffer.class, MemoryUtil.memAddress(byteBuffer), n2, byteBuffer);
    }

    public static RECT$Buffer create(long l2, int n2) {
        return RECT.wrap(RECT$Buffer.class, l2, n2);
    }

    public static RECT$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : RECT.wrap(RECT$Buffer.class, l2, n2);
    }

    public static RECT mallocStack() {
        return RECT.mallocStack(MemoryStack.stackGet());
    }

    public static RECT callocStack() {
        return RECT.callocStack(MemoryStack.stackGet());
    }

    public static RECT mallocStack(MemoryStack memoryStack) {
        return RECT.wrap(RECT.class, memoryStack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static RECT callocStack(MemoryStack memoryStack) {
        return RECT.wrap(RECT.class, memoryStack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static RECT$Buffer mallocStack(int n2) {
        return RECT.mallocStack(n2, MemoryStack.stackGet());
    }

    public static RECT$Buffer callocStack(int n2) {
        return RECT.callocStack(n2, MemoryStack.stackGet());
    }

    public static RECT$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return RECT.wrap(RECT$Buffer.class, memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static RECT$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return RECT.wrap(RECT$Buffer.class, memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int nleft(long l2) {
        return UNSAFE.getInt(null, l2 + (long)LEFT);
    }

    public static int ntop(long l2) {
        return UNSAFE.getInt(null, l2 + (long)TOP);
    }

    public static int nright(long l2) {
        return UNSAFE.getInt(null, l2 + (long)RIGHT);
    }

    public static int nbottom(long l2) {
        return UNSAFE.getInt(null, l2 + (long)BOTTOM);
    }

    public static void nleft(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)LEFT, n2);
    }

    public static void ntop(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)TOP, n2);
    }

    public static void nright(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)RIGHT, n2);
    }

    public static void nbottom(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)BOTTOM, n2);
    }

    static {
        Struct$Layout struct$Layout = RECT.__struct(RECT.__member(4), RECT.__member(4), RECT.__member(4), RECT.__member(4));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        LEFT = struct$Layout.offsetof(0);
        TOP = struct$Layout.offsetof(1);
        RIGHT = struct$Layout.offsetof(2);
        BOTTOM = struct$Layout.offsetof(3);
    }
}

