/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.windows.POINTL$Buffer;

public class POINTL
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;

    public POINTL(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), POINTL.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LONG")
    public int x() {
        return POINTL.nx(this.address());
    }

    @NativeType(value="LONG")
    public int y() {
        return POINTL.ny(this.address());
    }

    public POINTL x(@NativeType(value="LONG") int n2) {
        POINTL.nx(this.address(), n2);
        return this;
    }

    public POINTL y(@NativeType(value="LONG") int n2) {
        POINTL.ny(this.address(), n2);
        return this;
    }

    public POINTL set(int n2, int n3) {
        this.x(n2);
        this.y(n3);
        return this;
    }

    public POINTL set(POINTL pOINTL) {
        MemoryUtil.memCopy(pOINTL.address(), this.address(), SIZEOF);
        return this;
    }

    public static POINTL malloc() {
        return POINTL.wrap(POINTL.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static POINTL calloc() {
        return POINTL.wrap(POINTL.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static POINTL create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return POINTL.wrap(POINTL.class, MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static POINTL create(long l2) {
        return POINTL.wrap(POINTL.class, l2);
    }

    public static POINTL createSafe(long l2) {
        return l2 == 0L ? null : POINTL.wrap(POINTL.class, l2);
    }

    public static POINTL$Buffer malloc(int n2) {
        return POINTL.wrap(POINTL$Buffer.class, MemoryUtil.nmemAllocChecked(POINTL.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static POINTL$Buffer calloc(int n2) {
        return POINTL.wrap(POINTL$Buffer.class, MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static POINTL$Buffer create(int n2) {
        ByteBuffer byteBuffer = POINTL.__create(n2, SIZEOF);
        return POINTL.wrap(POINTL$Buffer.class, MemoryUtil.memAddress(byteBuffer), n2, byteBuffer);
    }

    public static POINTL$Buffer create(long l2, int n2) {
        return POINTL.wrap(POINTL$Buffer.class, l2, n2);
    }

    public static POINTL$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : POINTL.wrap(POINTL$Buffer.class, l2, n2);
    }

    public static POINTL mallocStack() {
        return POINTL.mallocStack(MemoryStack.stackGet());
    }

    public static POINTL callocStack() {
        return POINTL.callocStack(MemoryStack.stackGet());
    }

    public static POINTL mallocStack(MemoryStack memoryStack) {
        return POINTL.wrap(POINTL.class, memoryStack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static POINTL callocStack(MemoryStack memoryStack) {
        return POINTL.wrap(POINTL.class, memoryStack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static POINTL$Buffer mallocStack(int n2) {
        return POINTL.mallocStack(n2, MemoryStack.stackGet());
    }

    public static POINTL$Buffer callocStack(int n2) {
        return POINTL.callocStack(n2, MemoryStack.stackGet());
    }

    public static POINTL$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return POINTL.wrap(POINTL$Buffer.class, memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static POINTL$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return POINTL.wrap(POINTL$Buffer.class, memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int nx(long l2) {
        return UNSAFE.getInt(null, l2 + (long)X);
    }

    public static int ny(long l2) {
        return UNSAFE.getInt(null, l2 + (long)Y);
    }

    public static void nx(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)X, n2);
    }

    public static void ny(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)Y, n2);
    }

    static {
        Struct$Layout struct$Layout = POINTL.__struct(POINTL.__member(4), POINTL.__member(4));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        X = struct$Layout.offsetof(0);
        Y = struct$Layout.offsetof(1);
    }
}

