/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.windows.POINT$Buffer;

public class POINT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;

    public POINT(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), POINT.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LONG")
    public int x() {
        return POINT.nx(this.address());
    }

    @NativeType(value="LONG")
    public int y() {
        return POINT.ny(this.address());
    }

    public POINT x(@NativeType(value="LONG") int n2) {
        POINT.nx(this.address(), n2);
        return this;
    }

    public POINT y(@NativeType(value="LONG") int n2) {
        POINT.ny(this.address(), n2);
        return this;
    }

    public POINT set(int n2, int n3) {
        this.x(n2);
        this.y(n3);
        return this;
    }

    public POINT set(POINT pOINT) {
        MemoryUtil.memCopy(pOINT.address(), this.address(), SIZEOF);
        return this;
    }

    public static POINT malloc() {
        return POINT.wrap(POINT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static POINT calloc() {
        return POINT.wrap(POINT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static POINT create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return POINT.wrap(POINT.class, MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static POINT create(long l2) {
        return POINT.wrap(POINT.class, l2);
    }

    public static POINT createSafe(long l2) {
        return l2 == 0L ? null : POINT.wrap(POINT.class, l2);
    }

    public static POINT$Buffer malloc(int n2) {
        return POINT.wrap(POINT$Buffer.class, MemoryUtil.nmemAllocChecked(POINT.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static POINT$Buffer calloc(int n2) {
        return POINT.wrap(POINT$Buffer.class, MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static POINT$Buffer create(int n2) {
        ByteBuffer byteBuffer = POINT.__create(n2, SIZEOF);
        return POINT.wrap(POINT$Buffer.class, MemoryUtil.memAddress(byteBuffer), n2, byteBuffer);
    }

    public static POINT$Buffer create(long l2, int n2) {
        return POINT.wrap(POINT$Buffer.class, l2, n2);
    }

    public static POINT$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : POINT.wrap(POINT$Buffer.class, l2, n2);
    }

    public static POINT mallocStack() {
        return POINT.mallocStack(MemoryStack.stackGet());
    }

    public static POINT callocStack() {
        return POINT.callocStack(MemoryStack.stackGet());
    }

    public static POINT mallocStack(MemoryStack memoryStack) {
        return POINT.wrap(POINT.class, memoryStack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static POINT callocStack(MemoryStack memoryStack) {
        return POINT.wrap(POINT.class, memoryStack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static POINT$Buffer mallocStack(int n2) {
        return POINT.mallocStack(n2, MemoryStack.stackGet());
    }

    public static POINT$Buffer callocStack(int n2) {
        return POINT.callocStack(n2, MemoryStack.stackGet());
    }

    public static POINT$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return POINT.wrap(POINT$Buffer.class, memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static POINT$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return POINT.wrap(POINT$Buffer.class, memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int nx(long l2) {
        return UNSAFE.getInt(null, l2 + (long)X);
    }

    public static int ny(long l2) {
        return UNSAFE.getInt(null, l2 + (long)Y);
    }

    public static void nx(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)X, n2);
    }

    public static void ny(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)Y, n2);
    }

    static {
        Struct$Layout struct$Layout = POINT.__struct(POINT.__member(4), POINT.__member(4));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        X = struct$Layout.offsetof(0);
        Y = struct$Layout.offsetof(1);
    }
}

