/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.windows.MSG$Buffer;
import org.lwjgl.system.windows.POINT;

public class MSG
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HWND;
    public static final int MESSAGE;
    public static final int WPARAM;
    public static final int LPARAM;
    public static final int TIME;
    public static final int PT;

    public MSG(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), MSG.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="HWND")
    public long hwnd() {
        return MSG.nhwnd(this.address());
    }

    @NativeType(value="UINT")
    public int message() {
        return MSG.nmessage(this.address());
    }

    @NativeType(value="WPARAM")
    public long wParam() {
        return MSG.nwParam(this.address());
    }

    @NativeType(value="LPARAM")
    public long lParam() {
        return MSG.nlParam(this.address());
    }

    @NativeType(value="DWORD")
    public int time() {
        return MSG.ntime(this.address());
    }

    public POINT pt() {
        return MSG.npt(this.address());
    }

    public MSG pt(Consumer<POINT> consumer) {
        consumer.accept(this.pt());
        return this;
    }

    public MSG hwnd(@NativeType(value="HWND") long l2) {
        MSG.nhwnd(this.address(), l2);
        return this;
    }

    public MSG message(@NativeType(value="UINT") int n2) {
        MSG.nmessage(this.address(), n2);
        return this;
    }

    public MSG wParam(@NativeType(value="WPARAM") long l2) {
        MSG.nwParam(this.address(), l2);
        return this;
    }

    public MSG lParam(@NativeType(value="LPARAM") long l2) {
        MSG.nlParam(this.address(), l2);
        return this;
    }

    public MSG time(@NativeType(value="DWORD") int n2) {
        MSG.ntime(this.address(), n2);
        return this;
    }

    public MSG pt(POINT pOINT) {
        MSG.npt(this.address(), pOINT);
        return this;
    }

    public MSG set(long l2, int n2, long l3, long l4, int n3, POINT pOINT) {
        this.hwnd(l2);
        this.message(n2);
        this.wParam(l3);
        this.lParam(l4);
        this.time(n3);
        this.pt(pOINT);
        return this;
    }

    public MSG set(MSG mSG) {
        MemoryUtil.memCopy(mSG.address(), this.address(), SIZEOF);
        return this;
    }

    public static MSG malloc() {
        return MSG.wrap(MSG.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static MSG calloc() {
        return MSG.wrap(MSG.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static MSG create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return MSG.wrap(MSG.class, MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static MSG create(long l2) {
        return MSG.wrap(MSG.class, l2);
    }

    public static MSG createSafe(long l2) {
        return l2 == 0L ? null : MSG.wrap(MSG.class, l2);
    }

    public static MSG$Buffer malloc(int n2) {
        return MSG.wrap(MSG$Buffer.class, MemoryUtil.nmemAllocChecked(MSG.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static MSG$Buffer calloc(int n2) {
        return MSG.wrap(MSG$Buffer.class, MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static MSG$Buffer create(int n2) {
        ByteBuffer byteBuffer = MSG.__create(n2, SIZEOF);
        return MSG.wrap(MSG$Buffer.class, MemoryUtil.memAddress(byteBuffer), n2, byteBuffer);
    }

    public static MSG$Buffer create(long l2, int n2) {
        return MSG.wrap(MSG$Buffer.class, l2, n2);
    }

    public static MSG$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : MSG.wrap(MSG$Buffer.class, l2, n2);
    }

    public static MSG mallocStack() {
        return MSG.mallocStack(MemoryStack.stackGet());
    }

    public static MSG callocStack() {
        return MSG.callocStack(MemoryStack.stackGet());
    }

    public static MSG mallocStack(MemoryStack memoryStack) {
        return MSG.wrap(MSG.class, memoryStack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static MSG callocStack(MemoryStack memoryStack) {
        return MSG.wrap(MSG.class, memoryStack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static MSG$Buffer mallocStack(int n2) {
        return MSG.mallocStack(n2, MemoryStack.stackGet());
    }

    public static MSG$Buffer callocStack(int n2) {
        return MSG.callocStack(n2, MemoryStack.stackGet());
    }

    public static MSG$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return MSG.wrap(MSG$Buffer.class, memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static MSG$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return MSG.wrap(MSG$Buffer.class, memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static long nhwnd(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)HWND);
    }

    public static int nmessage(long l2) {
        return UNSAFE.getInt(null, l2 + (long)MESSAGE);
    }

    public static long nwParam(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)WPARAM);
    }

    public static long nlParam(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)LPARAM);
    }

    public static int ntime(long l2) {
        return UNSAFE.getInt(null, l2 + (long)TIME);
    }

    public static POINT npt(long l2) {
        return POINT.create(l2 + (long)PT);
    }

    public static void nhwnd(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)HWND, l3);
    }

    public static void nmessage(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)MESSAGE, n2);
    }

    public static void nwParam(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)WPARAM, l3);
    }

    public static void nlParam(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)LPARAM, l3);
    }

    public static void ntime(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)TIME, n2);
    }

    public static void npt(long l2, POINT pOINT) {
        MemoryUtil.memCopy(pOINT.address(), l2 + (long)PT, POINT.SIZEOF);
    }

    static {
        Struct$Layout struct$Layout = MSG.__struct(MSG.__member(POINTER_SIZE), MSG.__member(4), MSG.__member(POINTER_SIZE), MSG.__member(POINTER_SIZE), MSG.__member(4), MSG.__member(POINT.SIZEOF, POINT.ALIGNOF));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        HWND = struct$Layout.offsetof(0);
        MESSAGE = struct$Layout.offsetof(1);
        WPARAM = struct$Layout.offsetof(2);
        LPARAM = struct$Layout.offsetof(3);
        TIME = struct$Layout.offsetof(4);
        PT = struct$Layout.offsetof(5);
    }
}

