/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.macosx;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.macosx.ObjCPropertyAttribute$Buffer;

@NativeType(value="struct objc_property_attribute_t")
public class ObjCPropertyAttribute
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int VALUE;

    public ObjCPropertyAttribute(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), ObjCPropertyAttribute.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char *")
    public ByteBuffer name() {
        return ObjCPropertyAttribute.nname(this.address());
    }

    @NativeType(value="char *")
    public String nameString() {
        return ObjCPropertyAttribute.nnameString(this.address());
    }

    @NativeType(value="char *")
    public ByteBuffer value() {
        return ObjCPropertyAttribute.nvalue(this.address());
    }

    @NativeType(value="char *")
    public String valueString() {
        return ObjCPropertyAttribute.nvalueString(this.address());
    }

    public ObjCPropertyAttribute name(@NativeType(value="char *") ByteBuffer byteBuffer) {
        ObjCPropertyAttribute.nname(this.address(), byteBuffer);
        return this;
    }

    public ObjCPropertyAttribute value(@NativeType(value="char *") ByteBuffer byteBuffer) {
        ObjCPropertyAttribute.nvalue(this.address(), byteBuffer);
        return this;
    }

    public ObjCPropertyAttribute set(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        this.name(byteBuffer);
        this.value(byteBuffer2);
        return this;
    }

    public ObjCPropertyAttribute set(ObjCPropertyAttribute objCPropertyAttribute) {
        MemoryUtil.memCopy(objCPropertyAttribute.address(), this.address(), SIZEOF);
        return this;
    }

    public static ObjCPropertyAttribute malloc() {
        return ObjCPropertyAttribute.wrap(ObjCPropertyAttribute.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static ObjCPropertyAttribute calloc() {
        return ObjCPropertyAttribute.wrap(ObjCPropertyAttribute.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static ObjCPropertyAttribute create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return ObjCPropertyAttribute.wrap(ObjCPropertyAttribute.class, MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static ObjCPropertyAttribute create(long l2) {
        return ObjCPropertyAttribute.wrap(ObjCPropertyAttribute.class, l2);
    }

    public static ObjCPropertyAttribute createSafe(long l2) {
        return l2 == 0L ? null : ObjCPropertyAttribute.wrap(ObjCPropertyAttribute.class, l2);
    }

    public static ObjCPropertyAttribute$Buffer malloc(int n2) {
        return ObjCPropertyAttribute.wrap(ObjCPropertyAttribute$Buffer.class, MemoryUtil.nmemAllocChecked(ObjCPropertyAttribute.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static ObjCPropertyAttribute$Buffer calloc(int n2) {
        return ObjCPropertyAttribute.wrap(ObjCPropertyAttribute$Buffer.class, MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static ObjCPropertyAttribute$Buffer create(int n2) {
        ByteBuffer byteBuffer = ObjCPropertyAttribute.__create(n2, SIZEOF);
        return ObjCPropertyAttribute.wrap(ObjCPropertyAttribute$Buffer.class, MemoryUtil.memAddress(byteBuffer), n2, byteBuffer);
    }

    public static ObjCPropertyAttribute$Buffer create(long l2, int n2) {
        return ObjCPropertyAttribute.wrap(ObjCPropertyAttribute$Buffer.class, l2, n2);
    }

    public static ObjCPropertyAttribute$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : ObjCPropertyAttribute.wrap(ObjCPropertyAttribute$Buffer.class, l2, n2);
    }

    public static ObjCPropertyAttribute mallocStack() {
        return ObjCPropertyAttribute.mallocStack(MemoryStack.stackGet());
    }

    public static ObjCPropertyAttribute callocStack() {
        return ObjCPropertyAttribute.callocStack(MemoryStack.stackGet());
    }

    public static ObjCPropertyAttribute mallocStack(MemoryStack memoryStack) {
        return ObjCPropertyAttribute.wrap(ObjCPropertyAttribute.class, memoryStack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static ObjCPropertyAttribute callocStack(MemoryStack memoryStack) {
        return ObjCPropertyAttribute.wrap(ObjCPropertyAttribute.class, memoryStack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static ObjCPropertyAttribute$Buffer mallocStack(int n2) {
        return ObjCPropertyAttribute.mallocStack(n2, MemoryStack.stackGet());
    }

    public static ObjCPropertyAttribute$Buffer callocStack(int n2) {
        return ObjCPropertyAttribute.callocStack(n2, MemoryStack.stackGet());
    }

    public static ObjCPropertyAttribute$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return ObjCPropertyAttribute.wrap(ObjCPropertyAttribute$Buffer.class, memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static ObjCPropertyAttribute$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return ObjCPropertyAttribute.wrap(ObjCPropertyAttribute$Buffer.class, memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static ByteBuffer nname(long l2) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(l2 + (long)NAME));
    }

    public static String nnameString(long l2) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(l2 + (long)NAME));
    }

    public static ByteBuffer nvalue(long l2) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(l2 + (long)VALUE));
    }

    public static String nvalueString(long l2) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(l2 + (long)VALUE));
    }

    public static void nname(long l2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        MemoryUtil.memPutAddress(l2 + (long)NAME, MemoryUtil.memAddress(byteBuffer));
    }

    public static void nvalue(long l2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        MemoryUtil.memPutAddress(l2 + (long)VALUE, MemoryUtil.memAddress(byteBuffer));
    }

    public static void validate(long l2) {
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)NAME));
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)VALUE));
    }

    public static void validate(long l2, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            ObjCPropertyAttribute.validate(l2 + Integer.toUnsignedLong(i2) * (long)SIZEOF);
        }
    }

    static {
        Struct$Layout struct$Layout = ObjCPropertyAttribute.__struct(ObjCPropertyAttribute.__member(POINTER_SIZE), ObjCPropertyAttribute.__member(POINTER_SIZE));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        NAME = struct$Layout.offsetof(0);
        VALUE = struct$Layout.offsetof(1);
    }
}

