/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.macosx;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.macosx.ObjCMethodDescription$Buffer;

@NativeType(value="struct objc_method_description")
public class ObjCMethodDescription
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int TYPES;

    public ObjCMethodDescription(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), ObjCMethodDescription.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SEL")
    public long name() {
        return ObjCMethodDescription.nname(this.address());
    }

    @NativeType(value="char *")
    public ByteBuffer types() {
        return ObjCMethodDescription.ntypes(this.address());
    }

    @NativeType(value="char *")
    public String typesString() {
        return ObjCMethodDescription.ntypesString(this.address());
    }

    public static ObjCMethodDescription malloc() {
        return ObjCMethodDescription.wrap(ObjCMethodDescription.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static ObjCMethodDescription calloc() {
        return ObjCMethodDescription.wrap(ObjCMethodDescription.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static ObjCMethodDescription create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return ObjCMethodDescription.wrap(ObjCMethodDescription.class, MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static ObjCMethodDescription create(long l2) {
        return ObjCMethodDescription.wrap(ObjCMethodDescription.class, l2);
    }

    public static ObjCMethodDescription createSafe(long l2) {
        return l2 == 0L ? null : ObjCMethodDescription.wrap(ObjCMethodDescription.class, l2);
    }

    public static ObjCMethodDescription$Buffer malloc(int n2) {
        return ObjCMethodDescription.wrap(ObjCMethodDescription$Buffer.class, MemoryUtil.nmemAllocChecked(ObjCMethodDescription.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static ObjCMethodDescription$Buffer calloc(int n2) {
        return ObjCMethodDescription.wrap(ObjCMethodDescription$Buffer.class, MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static ObjCMethodDescription$Buffer create(int n2) {
        ByteBuffer byteBuffer = ObjCMethodDescription.__create(n2, SIZEOF);
        return ObjCMethodDescription.wrap(ObjCMethodDescription$Buffer.class, MemoryUtil.memAddress(byteBuffer), n2, byteBuffer);
    }

    public static ObjCMethodDescription$Buffer create(long l2, int n2) {
        return ObjCMethodDescription.wrap(ObjCMethodDescription$Buffer.class, l2, n2);
    }

    public static ObjCMethodDescription$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : ObjCMethodDescription.wrap(ObjCMethodDescription$Buffer.class, l2, n2);
    }

    public static ObjCMethodDescription mallocStack() {
        return ObjCMethodDescription.mallocStack(MemoryStack.stackGet());
    }

    public static ObjCMethodDescription callocStack() {
        return ObjCMethodDescription.callocStack(MemoryStack.stackGet());
    }

    public static ObjCMethodDescription mallocStack(MemoryStack memoryStack) {
        return ObjCMethodDescription.wrap(ObjCMethodDescription.class, memoryStack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static ObjCMethodDescription callocStack(MemoryStack memoryStack) {
        return ObjCMethodDescription.wrap(ObjCMethodDescription.class, memoryStack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static ObjCMethodDescription$Buffer mallocStack(int n2) {
        return ObjCMethodDescription.mallocStack(n2, MemoryStack.stackGet());
    }

    public static ObjCMethodDescription$Buffer callocStack(int n2) {
        return ObjCMethodDescription.callocStack(n2, MemoryStack.stackGet());
    }

    public static ObjCMethodDescription$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return ObjCMethodDescription.wrap(ObjCMethodDescription$Buffer.class, memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static ObjCMethodDescription$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return ObjCMethodDescription.wrap(ObjCMethodDescription$Buffer.class, memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static long nname(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)NAME);
    }

    public static ByteBuffer ntypes(long l2) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(l2 + (long)TYPES));
    }

    public static String ntypesString(long l2) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(l2 + (long)TYPES));
    }

    static {
        Struct$Layout struct$Layout = ObjCMethodDescription.__struct(ObjCMethodDescription.__member(POINTER_SIZE), ObjCMethodDescription.__member(POINTER_SIZE));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        NAME = struct$Layout.offsetof(0);
        TYPES = struct$Layout.offsetof(1);
    }
}

