/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.SharedLibrary$Default;
import org.lwjgl.system.linux.DynamicLinkLoader;

public class LinuxLibrary
extends SharedLibrary$Default {
    public LinuxLibrary(String string) {
        this(string, LinuxLibrary.loadLibrary(string));
    }

    public LinuxLibrary(String string, long l2) {
        super(string, l2);
    }

    private static long loadLibrary(String string) {
        long l2;
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            l2 = DynamicLinkLoader.dlopen(memoryStack.ASCII(string), 1);
        }
        if (l2 == 0L) {
            throw new UnsatisfiedLinkError("Failed to dynamically load library: " + string + "(error = " + DynamicLinkLoader.dlerror() + ")");
        }
        return l2;
    }

    @Override
    public long getFunctionAddress(ByteBuffer byteBuffer) {
        return DynamicLinkLoader.dlsym(this.address(), byteBuffer);
    }

    @Override
    public void free() {
        DynamicLinkLoader.dlclose(this.address());
    }
}

