/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.dyncall;

import java.nio.ByteBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class DynLoad {
    protected DynLoad() {
        throw new UnsupportedOperationException();
    }

    public static native long ndlLoadLibrary(long var0);

    @NativeType(value="DLLib *")
    public static long dlLoadLibrary(@NativeType(value="char const *") ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return DynLoad.ndlLoadLibrary(MemoryUtil.memAddress(byteBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="DLLib *")
    public static long dlLoadLibrary(@NativeType(value="char const *") CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nASCII(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            long l3 = DynLoad.ndlLoadLibrary(l2);
            return l3;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static native void ndlFreeLibrary(long var0);

    public static void dlFreeLibrary(@NativeType(value="DLLib *") long l2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        DynLoad.ndlFreeLibrary(l2);
    }

    public static native long ndlFindSymbol(long var0, long var2);

    @NativeType(value="void *")
    public static long dlFindSymbol(@NativeType(value="DLLib *") long l2, @NativeType(value="char const *") ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.checkNT1(byteBuffer);
        }
        return DynLoad.ndlFindSymbol(l2, MemoryUtil.memAddress(byteBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void *")
    public static long dlFindSymbol(@NativeType(value="DLLib *") long l2, @NativeType(value="char const *") CharSequence charSequence) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nASCII(charSequence, true);
            long l3 = memoryStack.getPointerAddress();
            long l4 = DynLoad.ndlFindSymbol(l2, l3);
            return l4;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static native int ndlGetLibraryPath(long var0, long var2, int var4);

    public static int dlGetLibraryPath(@NativeType(value="DLLib *") long l2, @NativeType(value="char *") ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return DynLoad.ndlGetLibraryPath(l2, MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="int")
    public static String dlGetLibraryPath(@NativeType(value="DLLib *") long l2, int n2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            ByteBuffer byteBuffer = memoryStack.malloc(n2);
            int n4 = DynLoad.ndlGetLibraryPath(l2, MemoryUtil.memAddress(byteBuffer), n2);
            String string = MemoryUtil.memASCII(byteBuffer, n4 - 1);
            return string;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native long ndlSymsInit(long var0);

    @NativeType(value="DLSyms *")
    public static long dlSymsInit(@NativeType(value="char const *") ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return DynLoad.ndlSymsInit(MemoryUtil.memAddress(byteBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="DLSyms *")
    public static long dlSymsInit(@NativeType(value="char const *") CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nASCII(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            long l3 = DynLoad.ndlSymsInit(l2);
            return l3;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static native void ndlSymsCleanup(long var0);

    public static void dlSymsCleanup(@NativeType(value="DLSyms *") long l2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        DynLoad.ndlSymsCleanup(l2);
    }

    public static native int ndlSymsCount(long var0);

    public static int dlSymsCount(@NativeType(value="DLSyms *") long l2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return DynLoad.ndlSymsCount(l2);
    }

    public static native long ndlSymsName(long var0, int var2);

    @NativeType(value="char const *")
    public static String dlSymsName(@NativeType(value="DLSyms *") long l2, int n2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        long l3 = DynLoad.ndlSymsName(l2, n2);
        return MemoryUtil.memASCIISafe(l3);
    }

    public static native long ndlSymsNameFromValue(long var0, long var2);

    @NativeType(value="char const *")
    public static String dlSymsNameFromValue(@NativeType(value="DLSyms *") long l2, @NativeType(value="void *") long l3) {
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        long l4 = DynLoad.ndlSymsNameFromValue(l2, l3);
        return MemoryUtil.memASCIISafe(l4);
    }

    static {
        Library.initialize();
    }
}

