/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.dyncall;

import java.nio.ByteBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class DynCallback {
    public static final char DCB_SIGCHAR_CC_PREFIX = '_';
    public static final char DCB_SIGCHAR_CC_ELLIPSIS = 'e';
    public static final char DCB_SIGCHAR_CC_STDCALL = 's';
    public static final char DCB_SIGCHAR_CC_FASTCALL_GNU = 'f';
    public static final char DCB_SIGCHAR_CC_FASTCALL_MS = 'F';
    public static final char DCB_SIGCHAR_CC_THISCALL_MS = '+';

    protected DynCallback() {
        throw new UnsupportedOperationException();
    }

    public static native long ndcbNewCallback(long var0, long var2, long var4);

    @NativeType(value="DCCallback *")
    public static long dcbNewCallback(@NativeType(value="char const *") ByteBuffer byteBuffer, @NativeType(value="DCCallbackHandler *") long l2, @NativeType(value="void *") long l3) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
            Checks.check(l2);
            Checks.check(l3);
        }
        return DynCallback.ndcbNewCallback(MemoryUtil.memAddress(byteBuffer), l2, l3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="DCCallback *")
    public static long dcbNewCallback(@NativeType(value="char const *") CharSequence charSequence, @NativeType(value="DCCallbackHandler *") long l2, @NativeType(value="void *") long l3) {
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nASCII(charSequence, true);
            long l4 = memoryStack.getPointerAddress();
            long l5 = DynCallback.ndcbNewCallback(l4, l2, l3);
            return l5;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static native void ndcbInitCallback(long var0, long var2, long var4, long var6);

    public static void dcbInitCallback(@NativeType(value="DCCallback *") long l2, @NativeType(value="char const *") ByteBuffer byteBuffer, @NativeType(value="DCCallbackHandler *") long l3, @NativeType(value="void *") long l4) {
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.checkNT1(byteBuffer);
            Checks.check(l3);
            Checks.check(l4);
        }
        DynCallback.ndcbInitCallback(l2, MemoryUtil.memAddress(byteBuffer), l3, l4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dcbInitCallback(@NativeType(value="DCCallback *") long l2, @NativeType(value="char const *") CharSequence charSequence, @NativeType(value="DCCallbackHandler *") long l3, @NativeType(value="void *") long l4) {
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
            Checks.check(l4);
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nASCII(charSequence, true);
            long l5 = memoryStack.getPointerAddress();
            DynCallback.ndcbInitCallback(l2, l5, l3, l4);
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static native void ndcbFreeCallback(long var0);

    public static void dcbFreeCallback(@NativeType(value="DCCallback *") long l2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        DynCallback.ndcbFreeCallback(l2);
    }

    public static native long ndcbGetUserData(long var0);

    @NativeType(value="void *")
    public static long dcbGetUserData(@NativeType(value="DCCallback *") long l2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return DynCallback.ndcbGetUserData(l2);
    }

    public static native int ndcbArgBool(long var0);

    @NativeType(value="DCbool")
    public static boolean dcbArgBool(@NativeType(value="DCArgs *") long l2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return DynCallback.ndcbArgBool(l2) != 0;
    }

    public static native byte ndcbArgChar(long var0);

    @NativeType(value="DCchar")
    public static byte dcbArgChar(@NativeType(value="DCArgs *") long l2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return DynCallback.ndcbArgChar(l2);
    }

    public static native short ndcbArgShort(long var0);

    @NativeType(value="DCshort")
    public static short dcbArgShort(@NativeType(value="DCArgs *") long l2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return DynCallback.ndcbArgShort(l2);
    }

    public static native int ndcbArgInt(long var0);

    @NativeType(value="DCint")
    public static int dcbArgInt(@NativeType(value="DCArgs *") long l2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return DynCallback.ndcbArgInt(l2);
    }

    public static native int ndcbArgLong(long var0);

    @NativeType(value="DClong")
    public static int dcbArgLong(@NativeType(value="DCArgs *") long l2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return DynCallback.ndcbArgLong(l2);
    }

    public static native long ndcbArgLongLong(long var0);

    @NativeType(value="DClonglong")
    public static long dcbArgLongLong(@NativeType(value="DCArgs *") long l2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return DynCallback.ndcbArgLongLong(l2);
    }

    public static native byte ndcbArgUChar(long var0);

    @NativeType(value="DCchar")
    public static byte dcbArgUChar(@NativeType(value="DCArgs *") long l2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return DynCallback.ndcbArgUChar(l2);
    }

    public static native short ndcbArgUShort(long var0);

    @NativeType(value="DCshort")
    public static short dcbArgUShort(@NativeType(value="DCArgs *") long l2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return DynCallback.ndcbArgUShort(l2);
    }

    public static native int ndcbArgUInt(long var0);

    @NativeType(value="DCint")
    public static int dcbArgUInt(@NativeType(value="DCArgs *") long l2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return DynCallback.ndcbArgUInt(l2);
    }

    public static native int ndcbArgULong(long var0);

    @NativeType(value="DClong")
    public static int dcbArgULong(@NativeType(value="DCArgs *") long l2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return DynCallback.ndcbArgULong(l2);
    }

    public static native long ndcbArgULongLong(long var0);

    @NativeType(value="DClonglong")
    public static long dcbArgULongLong(@NativeType(value="DCArgs *") long l2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return DynCallback.ndcbArgULongLong(l2);
    }

    public static native float ndcbArgFloat(long var0);

    @NativeType(value="DCfloat")
    public static float dcbArgFloat(@NativeType(value="DCArgs *") long l2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return DynCallback.ndcbArgFloat(l2);
    }

    public static native double ndcbArgDouble(long var0);

    @NativeType(value="DCdouble")
    public static double dcbArgDouble(@NativeType(value="DCArgs *") long l2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return DynCallback.ndcbArgDouble(l2);
    }

    public static native long ndcbArgPointer(long var0);

    @NativeType(value="DCpointer")
    public static long dcbArgPointer(@NativeType(value="DCArgs *") long l2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return DynCallback.ndcbArgPointer(l2);
    }

    static {
        Library.initialize();
    }
}

