/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.jni.JNINativeInterface;

public final class ThreadLocalUtil {
    private static final long JNI_NATIVE_INTERFACE;
    private static final long FUNCTION_MISSING_ABORT;
    private static final long SIZE_OF_JNI_NATIVE_INTERFACE;

    private ThreadLocalUtil() {
    }

    private static native long getThreadJNIEnv();

    private static native void setThreadJNIEnv(long var0);

    private static native long getFunctionMissingAbort();

    public static void setEnv(long l2, int n2) {
        if (n2 < 0 || 3 < n2) {
            throw new IndexOutOfBoundsException();
        }
        long l3 = ThreadLocalUtil.getThreadJNIEnv();
        if (l2 == 0L) {
            if (l3 != JNI_NATIVE_INTERFACE) {
                ThreadLocalUtil.setThreadJNIEnv(JNI_NATIVE_INTERFACE);
                MemoryUtil.nmemFree(l3);
            }
        } else {
            if (l3 == JNI_NATIVE_INTERFACE) {
                long l4 = MemoryUtil.nmemAllocChecked(SIZE_OF_JNI_NATIVE_INTERFACE);
                MemoryUtil.memCopy(l3, l4, SIZE_OF_JNI_NATIVE_INTERFACE);
                l3 = l4;
                ThreadLocalUtil.setThreadJNIEnv(l3);
            }
            MemoryUtil.memPutAddress(l3 + Integer.toUnsignedLong(n2) * (long)Pointer.POINTER_SIZE, l2);
        }
    }

    private static List<Field> getFieldsFromCapabilities(Class<?> clazz) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (Field field : clazz.getFields()) {
            if (field.getType() != Long.TYPE) continue;
            arrayList.add(field);
        }
        return arrayList;
    }

    public static void setFunctionMissingAddresses(Class<?> clazz, int n2) {
        if (clazz == null) {
            long l2 = MemoryUtil.memGetAddress(JNI_NATIVE_INTERFACE + Integer.toUnsignedLong(n2) * (long)Pointer.POINTER_SIZE);
            if (l2 != 0L) {
                MemoryUtil.getAllocator().free(l2);
                MemoryUtil.memPutAddress(JNI_NATIVE_INTERFACE + Integer.toUnsignedLong(n2) * (long)Pointer.POINTER_SIZE, 0L);
            }
        } else {
            int n3 = ThreadLocalUtil.getFieldsFromCapabilities(clazz).size();
            long l3 = MemoryUtil.getAllocator().malloc(Integer.toUnsignedLong(n3) * (long)Pointer.POINTER_SIZE);
            for (int i2 = 0; i2 < n3; ++i2) {
                MemoryUtil.memPutAddress(l3 + Integer.toUnsignedLong(i2) * (long)Pointer.POINTER_SIZE, FUNCTION_MISSING_ABORT);
            }
            MemoryUtil.memPutAddress(JNI_NATIVE_INTERFACE + Integer.toUnsignedLong(n2) * (long)Pointer.POINTER_SIZE, l3);
        }
    }

    public static PointerBuffer getAddressesFromCapabilities(Object object) {
        List<Field> list = ThreadLocalUtil.getFieldsFromCapabilities(object.getClass());
        PointerBuffer pointerBuffer = BufferUtils.createPointerBuffer(list.size());
        try {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                long l2 = list.get(i2).getLong(object);
                pointerBuffer.put(i2, l2 != 0L ? l2 : FUNCTION_MISSING_ABORT);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        return pointerBuffer;
    }

    public static boolean areCapabilitiesDifferent(PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2) {
        for (int i2 = 0; i2 < pointerBuffer.remaining(); ++i2) {
            if (pointerBuffer.get(i2) == pointerBuffer2.get(i2) || pointerBuffer2.get(i2) == 0L) continue;
            return true;
        }
        return false;
    }

    static {
        int n2;
        int n3;
        JNI_NATIVE_INTERFACE = ThreadLocalUtil.getThreadJNIEnv();
        FUNCTION_MISSING_ABORT = ThreadLocalUtil.getFunctionMissingAbort();
        int n4 = JNINativeInterface.GetVersion();
        switch (n4) {
            case 65537: {
                n3 = 12;
                break;
            }
            default: {
                n3 = 4;
            }
        }
        switch (n4) {
            case 65537: {
                n2 = 208;
                break;
            }
            case 65538: {
                n2 = 225;
                break;
            }
            case 65540: {
                n2 = 228;
                break;
            }
            case 65542: 
            case 65544: {
                n2 = 229;
                break;
            }
            case 589824: 
            case 655360: {
                n2 = 230;
                break;
            }
            default: {
                n2 = 230;
                APIUtil.DEBUG_STREAM.println("[LWJGL] [ThreadLocalUtil] Unsupported JNI version detected, this may result in a crash. Please inform LWJGL developers.");
            }
        }
        SIZE_OF_JNI_NATIVE_INTERFACE = Integer.toUnsignedLong(n3 + n2) * (long)Pointer.POINTER_SIZE;
    }
}

