/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

class StructBuffer$StructIterator<T extends Struct, SELF extends StructBuffer<T, SELF>>
implements Iterator<T> {
    private long address;
    private ByteBuffer container;
    private T factory;
    private int index;
    private int fence;

    StructBuffer$StructIterator(long l2, ByteBuffer byteBuffer, T t2, int n2, int n3) {
        this.address = l2;
        this.container = byteBuffer;
        this.factory = t2;
        this.index = n2;
        this.fence = n3;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.fence;
    }

    @Override
    public T next() {
        if (Checks.CHECKS && this.fence <= this.index) {
            throw new NoSuchElementException();
        }
        return ((Struct)this.factory).wrap(this.address, this.index++, this.container);
    }

    @Override
    public void forEachRemaining(Consumer<? super T> consumer) {
        int n2;
        Objects.requireNonNull(consumer);
        try {
            for (n2 = this.index; n2 < this.fence; ++n2) {
                consumer.accept(((Struct)this.factory).wrap(this.address, n2, this.container));
            }
        }
        finally {
            this.index = n2;
        }
    }
}

