/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Function;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.Library;
import org.lwjgl.system.MathUtil;
import org.lwjgl.system.MemoryManage$DebugAllocator;
import org.lwjgl.system.MemoryUtil$1;
import org.lwjgl.system.MemoryUtil$2;
import org.lwjgl.system.MemoryUtil$LazyInit;
import org.lwjgl.system.MemoryUtil$MemoryAllocationReport;
import org.lwjgl.system.MemoryUtil$MemoryAllocationReport$Aggregate;
import org.lwjgl.system.MemoryUtil$MemoryAllocator;
import org.lwjgl.system.MemoryUtil$NativeShift;
import org.lwjgl.system.MultiReleaseMemCopy;
import org.lwjgl.system.MultiReleaseTextDecoding;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Pointer$Default;
import org.lwjgl.system.Struct;
import org.lwjgl.system.jni.JNINativeInterface;
import org.lwjgl.system.libc.LibCString;
import sun.misc.Unsafe;

public final class MemoryUtil {
    public static final long NULL = 0L;
    public static final int PAGE_SIZE;
    public static final int CACHE_LINE_SIZE;
    static final int ARRAY_TLC_SIZE;
    static final ThreadLocal<byte[]> ARRAY_TLC_BYTE;
    static final ThreadLocal<char[]> ARRAY_TLC_CHAR;
    static final Unsafe UNSAFE;
    static final ByteOrder NATIVE_ORDER;
    private static final Charset UTF16;
    static final Class<? extends ByteBuffer> BUFFER_BYTE;
    static final Class<? extends ShortBuffer> BUFFER_SHORT;
    static final Class<? extends CharBuffer> BUFFER_CHAR;
    static final Class<? extends IntBuffer> BUFFER_INT;
    static final Class<? extends LongBuffer> BUFFER_LONG;
    static final Class<? extends FloatBuffer> BUFFER_FLOAT;
    static final Class<? extends DoubleBuffer> BUFFER_DOUBLE;
    private static final long MARK;
    private static final long POSITION;
    private static final long LIMIT;
    private static final long CAPACITY;
    private static final long ADDRESS;
    private static final long PARENT_BYTE;
    private static final long PARENT_SHORT;
    private static final long PARENT_CHAR;
    private static final long PARENT_INT;
    private static final long PARENT_LONG;
    private static final long PARENT_FLOAT;
    private static final long PARENT_DOUBLE;
    private static final MemoryUtil$NativeShift SHIFT;
    private static final long FILL_PATTERN;
    private static final int MAGIC_CAPACITY = 219540062;
    private static final int MAGIC_POSITION = 16435934;

    private MemoryUtil() {
    }

    public static MemoryUtil$MemoryAllocator getAllocator() {
        return MemoryUtil.getAllocator(false);
    }

    public static MemoryUtil$MemoryAllocator getAllocator(boolean bl2) {
        return bl2 ? MemoryUtil$LazyInit.ALLOCATOR : MemoryUtil$LazyInit.ALLOCATOR_IMPL;
    }

    public static long nmemAlloc(long l2) {
        return MemoryUtil$LazyInit.ALLOCATOR.malloc(l2);
    }

    public static long nmemAllocChecked(long l2) {
        long l3 = MemoryUtil.nmemAlloc(l2 != 0L ? l2 : 1L);
        if (Checks.CHECKS && l3 == 0L) {
            throw new OutOfMemoryError();
        }
        return l3;
    }

    private static long getAllocationSize(int n2, int n3) {
        return APIUtil.apiCheckAllocation(n2, Integer.toUnsignedLong(n2) << n3, Pointer.BITS64 ? Long.MAX_VALUE : 0xFFFFFFFFL);
    }

    public static ByteBuffer memAlloc(int n2) {
        return MemoryUtil.wrap(BUFFER_BYTE, MemoryUtil.nmemAllocChecked(n2), n2).order(NATIVE_ORDER);
    }

    public static ShortBuffer memAllocShort(int n2) {
        return MemoryUtil.wrap(BUFFER_SHORT, MemoryUtil.nmemAllocChecked(MemoryUtil.getAllocationSize(n2, 1)), n2);
    }

    public static IntBuffer memAllocInt(int n2) {
        return MemoryUtil.wrap(BUFFER_INT, MemoryUtil.nmemAllocChecked(MemoryUtil.getAllocationSize(n2, 2)), n2);
    }

    public static FloatBuffer memAllocFloat(int n2) {
        return MemoryUtil.wrap(BUFFER_FLOAT, MemoryUtil.nmemAllocChecked(MemoryUtil.getAllocationSize(n2, 2)), n2);
    }

    public static LongBuffer memAllocLong(int n2) {
        return MemoryUtil.wrap(BUFFER_LONG, MemoryUtil.nmemAllocChecked(MemoryUtil.getAllocationSize(n2, 3)), n2);
    }

    public static DoubleBuffer memAllocDouble(int n2) {
        return MemoryUtil.wrap(BUFFER_DOUBLE, MemoryUtil.nmemAllocChecked(MemoryUtil.getAllocationSize(n2, 3)), n2);
    }

    public static PointerBuffer memAllocPointer(int n2) {
        return Pointer$Default.wrap(PointerBuffer.class, MemoryUtil.nmemAllocChecked(MemoryUtil.getAllocationSize(n2, Pointer.POINTER_SHIFT)), n2);
    }

    public static void nmemFree(long l2) {
        MemoryUtil$LazyInit.ALLOCATOR.free(l2);
    }

    public static void memFree(Buffer buffer) {
        if (buffer != null) {
            MemoryUtil.nmemFree(UNSAFE.getLong(buffer, ADDRESS));
        }
    }

    public static void memFree(PointerBuffer pointerBuffer) {
        if (pointerBuffer != null) {
            MemoryUtil.nmemFree(pointerBuffer.address);
        }
    }

    public static long nmemCalloc(long l2, long l3) {
        return MemoryUtil$LazyInit.ALLOCATOR.calloc(l2, l3);
    }

    public static long nmemCallocChecked(long l2, long l3) {
        if (l2 == 0L || l3 == 0L) {
            l2 = 1L;
            l3 = 1L;
        }
        long l4 = MemoryUtil.nmemCalloc(l2, l3);
        if (Checks.CHECKS && l4 == 0L) {
            throw new OutOfMemoryError();
        }
        return l4;
    }

    public static ByteBuffer memCalloc(int n2, int n3) {
        return MemoryUtil.wrap(BUFFER_BYTE, MemoryUtil.nmemCallocChecked(n2, n3), n2 * n3).order(NATIVE_ORDER);
    }

    public static ByteBuffer memCalloc(int n2) {
        return MemoryUtil.wrap(BUFFER_BYTE, MemoryUtil.nmemCallocChecked(n2, 1L), n2).order(NATIVE_ORDER);
    }

    public static ShortBuffer memCallocShort(int n2) {
        return MemoryUtil.wrap(BUFFER_SHORT, MemoryUtil.nmemCallocChecked(n2, 2L), n2);
    }

    public static IntBuffer memCallocInt(int n2) {
        return MemoryUtil.wrap(BUFFER_INT, MemoryUtil.nmemCallocChecked(n2, 4L), n2);
    }

    public static FloatBuffer memCallocFloat(int n2) {
        return MemoryUtil.wrap(BUFFER_FLOAT, MemoryUtil.nmemCallocChecked(n2, 4L), n2);
    }

    public static LongBuffer memCallocLong(int n2) {
        return MemoryUtil.wrap(BUFFER_LONG, MemoryUtil.nmemCallocChecked(n2, 8L), n2);
    }

    public static DoubleBuffer memCallocDouble(int n2) {
        return MemoryUtil.wrap(BUFFER_DOUBLE, MemoryUtil.nmemCallocChecked(n2, 8L), n2);
    }

    public static PointerBuffer memCallocPointer(int n2) {
        return Pointer$Default.wrap(PointerBuffer.class, MemoryUtil.nmemCallocChecked(n2, Pointer.POINTER_SIZE), n2);
    }

    public static long nmemRealloc(long l2, long l3) {
        return MemoryUtil$LazyInit.ALLOCATOR.realloc(l2, l3);
    }

    public static long nmemReallocChecked(long l2, long l3) {
        long l4 = MemoryUtil.nmemRealloc(l2, l3 != 0L ? l3 : 1L);
        if (Checks.CHECKS && l4 == 0L) {
            throw new OutOfMemoryError();
        }
        return l4;
    }

    private static <T extends Buffer> T realloc(T t2, T t3, int n2) {
        if (t2 != null) {
            t3.position(Math.min(t2.position(), n2));
        }
        return t3;
    }

    public static ByteBuffer memRealloc(ByteBuffer byteBuffer, int n2) {
        return MemoryUtil.realloc(byteBuffer, MemoryUtil.memByteBuffer(MemoryUtil.nmemReallocChecked(byteBuffer == null ? 0L : UNSAFE.getLong(byteBuffer, ADDRESS), n2), n2), n2);
    }

    public static ShortBuffer memRealloc(ShortBuffer shortBuffer, int n2) {
        return MemoryUtil.realloc(shortBuffer, MemoryUtil.memShortBuffer(MemoryUtil.nmemReallocChecked(shortBuffer == null ? 0L : UNSAFE.getLong(shortBuffer, ADDRESS), MemoryUtil.getAllocationSize(n2, 1)), n2), n2);
    }

    public static IntBuffer memRealloc(IntBuffer intBuffer, int n2) {
        return MemoryUtil.realloc(intBuffer, MemoryUtil.memIntBuffer(MemoryUtil.nmemReallocChecked(intBuffer == null ? 0L : UNSAFE.getLong(intBuffer, ADDRESS), MemoryUtil.getAllocationSize(n2, 2)), n2), n2);
    }

    public static LongBuffer memRealloc(LongBuffer longBuffer, int n2) {
        return MemoryUtil.realloc(longBuffer, MemoryUtil.memLongBuffer(MemoryUtil.nmemReallocChecked(longBuffer == null ? 0L : UNSAFE.getLong(longBuffer, ADDRESS), MemoryUtil.getAllocationSize(n2, 3)), n2), n2);
    }

    public static FloatBuffer memRealloc(FloatBuffer floatBuffer, int n2) {
        return MemoryUtil.realloc(floatBuffer, MemoryUtil.memFloatBuffer(MemoryUtil.nmemReallocChecked(floatBuffer == null ? 0L : UNSAFE.getLong(floatBuffer, ADDRESS), MemoryUtil.getAllocationSize(n2, 2)), n2), n2);
    }

    public static DoubleBuffer memRealloc(DoubleBuffer doubleBuffer, int n2) {
        return MemoryUtil.realloc(doubleBuffer, MemoryUtil.memDoubleBuffer(MemoryUtil.nmemReallocChecked(doubleBuffer == null ? 0L : UNSAFE.getLong(doubleBuffer, ADDRESS), MemoryUtil.getAllocationSize(n2, 3)), n2), n2);
    }

    public static PointerBuffer memRealloc(PointerBuffer pointerBuffer, int n2) {
        PointerBuffer pointerBuffer2 = MemoryUtil.memPointerBuffer(MemoryUtil.nmemReallocChecked(pointerBuffer == null ? 0L : pointerBuffer.address, MemoryUtil.getAllocationSize(n2, Pointer.POINTER_SHIFT)), n2);
        if (pointerBuffer != null) {
            pointerBuffer2.position(Math.min(pointerBuffer.position(), n2));
        }
        return pointerBuffer2;
    }

    public static long nmemAlignedAlloc(long l2, long l3) {
        return MemoryUtil$LazyInit.ALLOCATOR.aligned_alloc(l2, l3);
    }

    public static long nmemAlignedAllocChecked(long l2, long l3) {
        long l4 = MemoryUtil.nmemAlignedAlloc(l2, l3 != 0L ? l3 : 1L);
        if (Checks.CHECKS && l4 == 0L) {
            throw new OutOfMemoryError();
        }
        return l4;
    }

    public static ByteBuffer memAlignedAlloc(int n2, int n3) {
        return MemoryUtil.wrap(BUFFER_BYTE, MemoryUtil.nmemAlignedAllocChecked(n2, n3), n3).order(NATIVE_ORDER);
    }

    public static void nmemAlignedFree(long l2) {
        MemoryUtil$LazyInit.ALLOCATOR.aligned_free(l2);
    }

    public static void memAlignedFree(ByteBuffer byteBuffer) {
        if (byteBuffer != null) {
            MemoryUtil.nmemAlignedFree(UNSAFE.getLong(byteBuffer, ADDRESS));
        }
    }

    public static void memReport(MemoryUtil$MemoryAllocationReport memoryUtil$MemoryAllocationReport) {
        MemoryManage$DebugAllocator.report(memoryUtil$MemoryAllocationReport);
    }

    public static void memReport(MemoryUtil$MemoryAllocationReport memoryUtil$MemoryAllocationReport, MemoryUtil$MemoryAllocationReport$Aggregate memoryUtil$MemoryAllocationReport$Aggregate, boolean bl2) {
        MemoryManage$DebugAllocator.report(memoryUtil$MemoryAllocationReport, memoryUtil$MemoryAllocationReport$Aggregate, bl2);
    }

    public static long memAddress0(Buffer buffer) {
        return UNSAFE.getLong(buffer, ADDRESS);
    }

    public static long memAddress(ByteBuffer byteBuffer) {
        return (long)byteBuffer.position() + MemoryUtil.memAddress0(byteBuffer);
    }

    public static long memAddress(ByteBuffer byteBuffer, int n2) {
        Objects.requireNonNull(byteBuffer);
        return MemoryUtil.memAddress0(byteBuffer) + Integer.toUnsignedLong(n2);
    }

    private static long address(int n2, int n3, long l2) {
        return l2 + (((long)n2 & 0xFFFFFFFFL) << n3);
    }

    public static long memAddress(ShortBuffer shortBuffer) {
        return MemoryUtil.address(shortBuffer.position(), 1, MemoryUtil.memAddress0(shortBuffer));
    }

    public static long memAddress(ShortBuffer shortBuffer, int n2) {
        Objects.requireNonNull(shortBuffer);
        return MemoryUtil.address(n2, 1, MemoryUtil.memAddress0(shortBuffer));
    }

    public static long memAddress(CharBuffer charBuffer) {
        return MemoryUtil.address(charBuffer.position(), 1, MemoryUtil.memAddress0(charBuffer));
    }

    public static long memAddress(CharBuffer charBuffer, int n2) {
        Objects.requireNonNull(charBuffer);
        return MemoryUtil.address(n2, 1, MemoryUtil.memAddress0(charBuffer));
    }

    public static long memAddress(IntBuffer intBuffer) {
        return MemoryUtil.address(intBuffer.position(), 2, MemoryUtil.memAddress0(intBuffer));
    }

    public static long memAddress(IntBuffer intBuffer, int n2) {
        Objects.requireNonNull(intBuffer);
        return MemoryUtil.address(n2, 2, MemoryUtil.memAddress0(intBuffer));
    }

    public static long memAddress(FloatBuffer floatBuffer) {
        return MemoryUtil.address(floatBuffer.position(), 2, MemoryUtil.memAddress0(floatBuffer));
    }

    public static long memAddress(FloatBuffer floatBuffer, int n2) {
        Objects.requireNonNull(floatBuffer);
        return MemoryUtil.address(n2, 2, MemoryUtil.memAddress0(floatBuffer));
    }

    public static long memAddress(LongBuffer longBuffer) {
        return MemoryUtil.address(longBuffer.position(), 3, MemoryUtil.memAddress0(longBuffer));
    }

    public static long memAddress(LongBuffer longBuffer, int n2) {
        Objects.requireNonNull(longBuffer);
        return MemoryUtil.address(n2, 3, MemoryUtil.memAddress0(longBuffer));
    }

    public static long memAddress(DoubleBuffer doubleBuffer) {
        return MemoryUtil.address(doubleBuffer.position(), 3, MemoryUtil.memAddress0(doubleBuffer));
    }

    public static long memAddress(DoubleBuffer doubleBuffer, int n2) {
        Objects.requireNonNull(doubleBuffer);
        return MemoryUtil.address(n2, 3, MemoryUtil.memAddress0(doubleBuffer));
    }

    public static long memAddress(Buffer buffer) {
        int n2 = buffer instanceof ByteBuffer ? 0 : (buffer instanceof ShortBuffer || buffer instanceof CharBuffer ? 1 : (buffer instanceof IntBuffer || buffer instanceof FloatBuffer ? 2 : 3));
        return MemoryUtil.address(buffer.position(), n2, MemoryUtil.memAddress0(buffer));
    }

    public static long memAddress(CustomBuffer<?> customBuffer) {
        return customBuffer.address();
    }

    public static long memAddress(CustomBuffer<?> customBuffer, int n2) {
        return customBuffer.address(n2);
    }

    public static long memAddressSafe(ByteBuffer byteBuffer) {
        return byteBuffer == null ? 0L : MemoryUtil.memAddress0(byteBuffer) + (long)byteBuffer.position();
    }

    public static long memAddressSafe(ShortBuffer shortBuffer) {
        return shortBuffer == null ? 0L : MemoryUtil.address(shortBuffer.position(), 1, MemoryUtil.memAddress0(shortBuffer));
    }

    public static long memAddressSafe(CharBuffer charBuffer) {
        return charBuffer == null ? 0L : MemoryUtil.address(charBuffer.position(), 1, MemoryUtil.memAddress0(charBuffer));
    }

    public static long memAddressSafe(IntBuffer intBuffer) {
        return intBuffer == null ? 0L : MemoryUtil.address(intBuffer.position(), 2, MemoryUtil.memAddress0(intBuffer));
    }

    public static long memAddressSafe(FloatBuffer floatBuffer) {
        return floatBuffer == null ? 0L : MemoryUtil.address(floatBuffer.position(), 2, MemoryUtil.memAddress0(floatBuffer));
    }

    public static long memAddressSafe(LongBuffer longBuffer) {
        return longBuffer == null ? 0L : MemoryUtil.address(longBuffer.position(), 3, MemoryUtil.memAddress0(longBuffer));
    }

    public static long memAddressSafe(DoubleBuffer doubleBuffer) {
        return doubleBuffer == null ? 0L : MemoryUtil.address(doubleBuffer.position(), 3, MemoryUtil.memAddress0(doubleBuffer));
    }

    public static long memAddressSafe(Pointer pointer) {
        return pointer == null ? 0L : pointer.address();
    }

    public static ByteBuffer memByteBuffer(long l2, int n2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return MemoryUtil.wrap(BUFFER_BYTE, l2, n2).order(NATIVE_ORDER);
    }

    public static ByteBuffer memByteBufferSafe(long l2, int n2) {
        return l2 == 0L ? null : MemoryUtil.wrap(BUFFER_BYTE, l2, n2).order(NATIVE_ORDER);
    }

    public static ShortBuffer memShortBuffer(long l2, int n2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return MemoryUtil.wrap(BUFFER_SHORT, l2, n2);
    }

    public static ShortBuffer memShortBufferSafe(long l2, int n2) {
        return l2 == 0L ? null : MemoryUtil.wrap(BUFFER_SHORT, l2, n2);
    }

    public static CharBuffer memCharBuffer(long l2, int n2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return MemoryUtil.wrap(BUFFER_CHAR, l2, n2);
    }

    public static CharBuffer memCharBufferSafe(long l2, int n2) {
        return l2 == 0L ? null : MemoryUtil.wrap(BUFFER_CHAR, l2, n2);
    }

    public static IntBuffer memIntBuffer(long l2, int n2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return MemoryUtil.wrap(BUFFER_INT, l2, n2);
    }

    public static IntBuffer memIntBufferSafe(long l2, int n2) {
        return l2 == 0L ? null : MemoryUtil.wrap(BUFFER_INT, l2, n2);
    }

    public static LongBuffer memLongBuffer(long l2, int n2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return MemoryUtil.wrap(BUFFER_LONG, l2, n2);
    }

    public static LongBuffer memLongBufferSafe(long l2, int n2) {
        return l2 == 0L ? null : MemoryUtil.wrap(BUFFER_LONG, l2, n2);
    }

    public static FloatBuffer memFloatBuffer(long l2, int n2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return MemoryUtil.wrap(BUFFER_FLOAT, l2, n2);
    }

    public static FloatBuffer memFloatBufferSafe(long l2, int n2) {
        return l2 == 0L ? null : MemoryUtil.wrap(BUFFER_FLOAT, l2, n2);
    }

    public static DoubleBuffer memDoubleBuffer(long l2, int n2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return MemoryUtil.wrap(BUFFER_DOUBLE, l2, n2);
    }

    public static DoubleBuffer memDoubleBufferSafe(long l2, int n2) {
        return l2 == 0L ? null : MemoryUtil.wrap(BUFFER_DOUBLE, l2, n2);
    }

    public static PointerBuffer memPointerBuffer(long l2, int n2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return Pointer$Default.wrap(PointerBuffer.class, l2, n2);
    }

    public static PointerBuffer memPointerBufferSafe(long l2, int n2) {
        return l2 == 0L ? null : Pointer$Default.wrap(PointerBuffer.class, l2, n2);
    }

    public static ByteBuffer memDuplicate(ByteBuffer byteBuffer) {
        return MemoryUtil.duplicate(BUFFER_BYTE, byteBuffer, PARENT_BYTE).order(byteBuffer.order());
    }

    public static ShortBuffer memDuplicate(ShortBuffer shortBuffer) {
        return MemoryUtil.duplicate(BUFFER_SHORT, shortBuffer, PARENT_SHORT);
    }

    public static CharBuffer memDuplicate(CharBuffer charBuffer) {
        return MemoryUtil.duplicate(BUFFER_CHAR, charBuffer, PARENT_CHAR);
    }

    public static IntBuffer memDuplicate(IntBuffer intBuffer) {
        return MemoryUtil.duplicate(BUFFER_INT, intBuffer, PARENT_INT);
    }

    public static LongBuffer memDuplicate(LongBuffer longBuffer) {
        return MemoryUtil.duplicate(BUFFER_LONG, longBuffer, PARENT_LONG);
    }

    public static FloatBuffer memDuplicate(FloatBuffer floatBuffer) {
        return MemoryUtil.duplicate(BUFFER_FLOAT, floatBuffer, PARENT_FLOAT);
    }

    public static DoubleBuffer memDuplicate(DoubleBuffer doubleBuffer) {
        return MemoryUtil.duplicate(BUFFER_DOUBLE, doubleBuffer, PARENT_DOUBLE);
    }

    public static ByteBuffer memSlice(ByteBuffer byteBuffer) {
        return MemoryUtil.slice(BUFFER_BYTE, byteBuffer, MemoryUtil.memAddress0(byteBuffer) + (long)byteBuffer.position(), byteBuffer.remaining(), PARENT_BYTE).order(byteBuffer.order());
    }

    public static ShortBuffer memSlice(ShortBuffer shortBuffer) {
        return MemoryUtil.slice(BUFFER_SHORT, shortBuffer, MemoryUtil.address(shortBuffer.position(), 1, MemoryUtil.memAddress0(shortBuffer)), shortBuffer.remaining(), PARENT_SHORT);
    }

    public static CharBuffer memSlice(CharBuffer charBuffer) {
        return MemoryUtil.slice(BUFFER_CHAR, charBuffer, MemoryUtil.address(charBuffer.position(), 1, MemoryUtil.memAddress0(charBuffer)), charBuffer.remaining(), PARENT_CHAR);
    }

    public static IntBuffer memSlice(IntBuffer intBuffer) {
        return MemoryUtil.slice(BUFFER_INT, intBuffer, MemoryUtil.address(intBuffer.position(), 2, MemoryUtil.memAddress0(intBuffer)), intBuffer.remaining(), PARENT_INT);
    }

    public static LongBuffer memSlice(LongBuffer longBuffer) {
        return MemoryUtil.slice(BUFFER_LONG, longBuffer, MemoryUtil.address(longBuffer.position(), 3, MemoryUtil.memAddress0(longBuffer)), longBuffer.remaining(), PARENT_LONG);
    }

    public static FloatBuffer memSlice(FloatBuffer floatBuffer) {
        return MemoryUtil.slice(BUFFER_FLOAT, floatBuffer, MemoryUtil.address(floatBuffer.position(), 2, MemoryUtil.memAddress0(floatBuffer)), floatBuffer.remaining(), PARENT_FLOAT);
    }

    public static DoubleBuffer memSlice(DoubleBuffer doubleBuffer) {
        return MemoryUtil.slice(BUFFER_DOUBLE, doubleBuffer, MemoryUtil.address(doubleBuffer.position(), 3, MemoryUtil.memAddress0(doubleBuffer)), doubleBuffer.remaining(), PARENT_DOUBLE);
    }

    public static ByteBuffer memSlice(ByteBuffer byteBuffer, int n2, int n3) {
        int n4 = byteBuffer.position() + n2;
        if (n2 < 0 || byteBuffer.limit() < n4) {
            throw new IllegalArgumentException();
        }
        if (n3 < 0 || byteBuffer.capacity() - n4 < n3) {
            throw new IllegalArgumentException();
        }
        return MemoryUtil.slice(BUFFER_BYTE, byteBuffer, MemoryUtil.memAddress0(byteBuffer) + (long)n4, n3, PARENT_BYTE).order(byteBuffer.order());
    }

    public static ShortBuffer memSlice(ShortBuffer shortBuffer, int n2, int n3) {
        int n4 = shortBuffer.position() + n2;
        if (n2 < 0 || shortBuffer.limit() < n4) {
            throw new IllegalArgumentException();
        }
        if (n3 < 0 || shortBuffer.capacity() - n4 < n3) {
            throw new IllegalArgumentException();
        }
        return MemoryUtil.slice(BUFFER_SHORT, shortBuffer, MemoryUtil.address(n4, 1, MemoryUtil.memAddress0(shortBuffer)), n3, PARENT_SHORT);
    }

    public static CharBuffer memSlice(CharBuffer charBuffer, int n2, int n3) {
        int n4 = charBuffer.position() + n2;
        if (n2 < 0 || charBuffer.limit() < n4) {
            throw new IllegalArgumentException();
        }
        if (n3 < 0 || charBuffer.capacity() - n4 < n3) {
            throw new IllegalArgumentException();
        }
        return MemoryUtil.slice(BUFFER_CHAR, charBuffer, MemoryUtil.address(n4, 1, MemoryUtil.memAddress0(charBuffer)), n3, PARENT_CHAR);
    }

    public static IntBuffer memSlice(IntBuffer intBuffer, int n2, int n3) {
        int n4 = intBuffer.position() + n2;
        if (n2 < 0 || intBuffer.limit() < n4) {
            throw new IllegalArgumentException();
        }
        if (n3 < 0 || intBuffer.capacity() - n4 < n3) {
            throw new IllegalArgumentException();
        }
        return MemoryUtil.slice(BUFFER_INT, intBuffer, MemoryUtil.address(n4, 2, MemoryUtil.memAddress0(intBuffer)), n3, PARENT_INT);
    }

    public static LongBuffer memSlice(LongBuffer longBuffer, int n2, int n3) {
        int n4 = longBuffer.position() + n2;
        if (n2 < 0 || longBuffer.limit() < n4) {
            throw new IllegalArgumentException();
        }
        if (n3 < 0 || longBuffer.capacity() - n4 < n3) {
            throw new IllegalArgumentException();
        }
        return MemoryUtil.slice(BUFFER_LONG, longBuffer, MemoryUtil.address(n4, 3, MemoryUtil.memAddress0(longBuffer)), n3, PARENT_LONG);
    }

    public static FloatBuffer memSlice(FloatBuffer floatBuffer, int n2, int n3) {
        int n4 = floatBuffer.position() + n2;
        if (n2 < 0 || floatBuffer.limit() < n4) {
            throw new IllegalArgumentException();
        }
        if (n3 < 0 || floatBuffer.capacity() - n4 < n3) {
            throw new IllegalArgumentException();
        }
        return MemoryUtil.slice(BUFFER_FLOAT, floatBuffer, MemoryUtil.address(n4, 2, MemoryUtil.memAddress0(floatBuffer)), n3, PARENT_FLOAT);
    }

    public static DoubleBuffer memSlice(DoubleBuffer doubleBuffer, int n2, int n3) {
        int n4 = doubleBuffer.position() + n2;
        if (n2 < 0 || doubleBuffer.limit() < n4) {
            throw new IllegalArgumentException();
        }
        if (n3 < 0 || doubleBuffer.capacity() - n4 < n3) {
            throw new IllegalArgumentException();
        }
        return MemoryUtil.slice(BUFFER_DOUBLE, doubleBuffer, MemoryUtil.address(n4, 3, MemoryUtil.memAddress0(doubleBuffer)), n3, PARENT_DOUBLE);
    }

    public static <T extends CustomBuffer<T>> T memSlice(T t2, int n2, int n3) {
        return t2.slice(n2, n3);
    }

    public static void memSet(ByteBuffer byteBuffer, int n2) {
        MemoryUtil.memSet(MemoryUtil.memAddress(byteBuffer), n2, byteBuffer.remaining());
    }

    public static void memSet(ShortBuffer shortBuffer, int n2) {
        MemoryUtil.memSet(MemoryUtil.memAddress(shortBuffer), n2, APIUtil.apiGetBytes(shortBuffer.remaining(), 1));
    }

    public static void memSet(CharBuffer charBuffer, int n2) {
        MemoryUtil.memSet(MemoryUtil.memAddress(charBuffer), n2, APIUtil.apiGetBytes(charBuffer.remaining(), 1));
    }

    public static void memSet(IntBuffer intBuffer, int n2) {
        MemoryUtil.memSet(MemoryUtil.memAddress(intBuffer), n2, APIUtil.apiGetBytes(intBuffer.remaining(), 2));
    }

    public static void memSet(LongBuffer longBuffer, int n2) {
        MemoryUtil.memSet(MemoryUtil.memAddress(longBuffer), n2, APIUtil.apiGetBytes(longBuffer.remaining(), 3));
    }

    public static void memSet(FloatBuffer floatBuffer, int n2) {
        MemoryUtil.memSet(MemoryUtil.memAddress(floatBuffer), n2, APIUtil.apiGetBytes(floatBuffer.remaining(), 2));
    }

    public static void memSet(DoubleBuffer doubleBuffer, int n2) {
        MemoryUtil.memSet(MemoryUtil.memAddress(doubleBuffer), n2, APIUtil.apiGetBytes(doubleBuffer.remaining(), 3));
    }

    public static <T extends CustomBuffer<T>> void memSet(T t2, int n2) {
        MemoryUtil.memSet(MemoryUtil.memAddress(t2), n2, Integer.toUnsignedLong(t2.remaining()) * (long)t2.sizeof());
    }

    public static <T extends Struct> void memSet(T t2, int n2) {
        MemoryUtil.memSet(t2.address, n2, t2.sizeof());
    }

    public static void memCopy(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)byteBuffer2, byteBuffer.remaining());
        }
        MultiReleaseMemCopy.copy(MemoryUtil.memAddress(byteBuffer), MemoryUtil.memAddress(byteBuffer2), byteBuffer.remaining());
    }

    public static void memCopy(ShortBuffer shortBuffer, ShortBuffer shortBuffer2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)shortBuffer2, shortBuffer.remaining());
        }
        MultiReleaseMemCopy.copy(MemoryUtil.memAddress(shortBuffer), MemoryUtil.memAddress(shortBuffer2), APIUtil.apiGetBytes(shortBuffer.remaining(), 1));
    }

    public static void memCopy(CharBuffer charBuffer, CharBuffer charBuffer2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)charBuffer2, charBuffer.remaining());
        }
        MultiReleaseMemCopy.copy(MemoryUtil.memAddress(charBuffer), MemoryUtil.memAddress(charBuffer2), APIUtil.apiGetBytes(charBuffer.remaining(), 1));
    }

    public static void memCopy(IntBuffer intBuffer, IntBuffer intBuffer2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer2, intBuffer.remaining());
        }
        MultiReleaseMemCopy.copy(MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(intBuffer2), APIUtil.apiGetBytes(intBuffer.remaining(), 2));
    }

    public static void memCopy(LongBuffer longBuffer, LongBuffer longBuffer2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)longBuffer2, longBuffer.remaining());
        }
        MultiReleaseMemCopy.copy(MemoryUtil.memAddress(longBuffer), MemoryUtil.memAddress(longBuffer2), APIUtil.apiGetBytes(longBuffer.remaining(), 3));
    }

    public static void memCopy(FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)floatBuffer2, floatBuffer.remaining());
        }
        MultiReleaseMemCopy.copy(MemoryUtil.memAddress(floatBuffer), MemoryUtil.memAddress(floatBuffer2), APIUtil.apiGetBytes(floatBuffer.remaining(), 2));
    }

    public static void memCopy(DoubleBuffer doubleBuffer, DoubleBuffer doubleBuffer2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)doubleBuffer2, doubleBuffer.remaining());
        }
        MultiReleaseMemCopy.copy(MemoryUtil.memAddress(doubleBuffer), MemoryUtil.memAddress(doubleBuffer2), APIUtil.apiGetBytes(doubleBuffer.remaining(), 3));
    }

    public static <T extends CustomBuffer<T>> void memCopy(T t2, T t3) {
        if (Checks.CHECKS) {
            Checks.check(t3, t2.remaining());
        }
        MultiReleaseMemCopy.copy(MemoryUtil.memAddress(t2), MemoryUtil.memAddress(t3), Integer.toUnsignedLong(t2.remaining()) * (long)t2.sizeof());
    }

    public static <T extends Struct> void memCopy(T t2, T t3) {
        MultiReleaseMemCopy.copy(t2.address, t3.address, t2.sizeof());
    }

    public static void memSet(long l2, int n2, long l3) {
        int n3;
        if (Checks.DEBUG && (l2 == 0L || l3 < 0L)) {
            throw new IllegalArgumentException();
        }
        if (256L <= l3) {
            LibCString.nmemset(l2, n2, l3);
            return;
        }
        long l4 = (long)(n2 & 0xFF) * FILL_PATTERN;
        int n4 = 0;
        int n5 = (int)l3 & 0xFF;
        if (n5 != 0 && (n3 = (int)l2 & 7) != 0) {
            long l5 = l2 - (long)n3;
            UNSAFE.putLong(null, l5, MemoryUtil.merge(UNSAFE.getLong(null, l5), l4, SHIFT.right(SHIFT.left(-1L, Math.max(0, 8 - n5)), n3)));
            n4 += 8 - n3;
        }
        while (n4 <= n5 - 8) {
            UNSAFE.putLong(null, l2 + (long)n4, l4);
            n4 += 8;
        }
        n3 = n5 - n4;
        if (0 < n3) {
            UNSAFE.putLong(null, l2 + (long)n4, MemoryUtil.merge(l4, UNSAFE.getLong(null, l2 + (long)n4), SHIFT.right(-1L, n3)));
        }
    }

    static long merge(long l2, long l3, long l4) {
        return l2 ^ (l2 ^ l3) & l4;
    }

    public static void memCopy(long l2, long l3, long l4) {
        if (Checks.DEBUG && (l2 == 0L || l3 == 0L || l4 < 0L)) {
            throw new IllegalArgumentException();
        }
        MultiReleaseMemCopy.copy(l2, l3, l4);
    }

    static void memCopyAligned(long l2, long l3, int n2) {
        int n3;
        for (n3 = 0; n3 <= n2 - 8; n3 += 8) {
            UNSAFE.putLong(null, l3 + (long)n3, UNSAFE.getLong(null, l2 + (long)n3));
        }
        if (n3 < n2) {
            UNSAFE.putLong(null, l3 + (long)n3, MemoryUtil.merge(UNSAFE.getLong(null, l2 + (long)n3), UNSAFE.getLong(null, l3 + (long)n3), SHIFT.right(-1L, n2 - n3)));
        }
    }

    public static boolean memGetBoolean(long l2) {
        return UNSAFE.getByte(null, l2) != 0;
    }

    public static byte memGetByte(long l2) {
        return UNSAFE.getByte(null, l2);
    }

    public static short memGetShort(long l2) {
        return UNSAFE.getShort(null, l2);
    }

    public static int memGetInt(long l2) {
        return UNSAFE.getInt(null, l2);
    }

    public static long memGetLong(long l2) {
        return UNSAFE.getLong(null, l2);
    }

    public static float memGetFloat(long l2) {
        return UNSAFE.getFloat(null, l2);
    }

    public static double memGetDouble(long l2) {
        return UNSAFE.getDouble(null, l2);
    }

    public static long memGetCLong(long l2) {
        return Pointer.CLONG_SIZE == 8 ? UNSAFE.getLong(null, l2) : (long)UNSAFE.getInt(null, l2);
    }

    public static long memGetAddress(long l2) {
        return Pointer.BITS64 ? UNSAFE.getLong(null, l2) : (long)UNSAFE.getInt(null, l2) & 0xFFFFFFFFL;
    }

    public static void memPutByte(long l2, byte by2) {
        UNSAFE.putByte(null, l2, by2);
    }

    public static void memPutShort(long l2, short s2) {
        UNSAFE.putShort(null, l2, s2);
    }

    public static void memPutInt(long l2, int n2) {
        UNSAFE.putInt(null, l2, n2);
    }

    public static void memPutLong(long l2, long l3) {
        UNSAFE.putLong(null, l2, l3);
    }

    public static void memPutFloat(long l2, float f2) {
        UNSAFE.putFloat(null, l2, f2);
    }

    public static void memPutDouble(long l2, double d2) {
        UNSAFE.putDouble(null, l2, d2);
    }

    public static void memPutCLong(long l2, long l3) {
        if (Pointer.CLONG_SIZE == 8) {
            UNSAFE.putLong(null, l2, l3);
        } else {
            UNSAFE.putInt(null, l2, (int)l3);
        }
    }

    public static void memPutAddress(long l2, long l3) {
        if (Pointer.BITS64) {
            UNSAFE.putLong(null, l2, l3);
        } else {
            UNSAFE.putInt(null, l2, (int)l3);
        }
    }

    public static native <T> T memGlobalRefToObject(long var0);

    @Deprecated
    public static long memNewGlobalRef(Object object) {
        return JNINativeInterface.NewGlobalRef(object);
    }

    @Deprecated
    public static void memDeleteGlobalRef(long l2) {
        JNINativeInterface.DeleteGlobalRef(l2);
    }

    @Deprecated
    public static long memNewWeakGlobalRef(Object object) {
        return JNINativeInterface.NewWeakGlobalRef(object);
    }

    @Deprecated
    public static void memDeleteWeakGlobalRef(long l2) {
        JNINativeInterface.DeleteWeakGlobalRef(l2);
    }

    public static ByteBuffer memASCII(CharSequence charSequence) {
        return MemoryUtil.memASCII(charSequence, true);
    }

    public static ByteBuffer memASCIISafe(CharSequence charSequence) {
        return charSequence == null ? null : MemoryUtil.memASCII(charSequence, true);
    }

    public static ByteBuffer memASCII(CharSequence charSequence, boolean bl2) {
        int n2 = MemoryUtil.memLengthASCII(charSequence, bl2);
        long l2 = MemoryUtil.nmemAlloc(n2);
        MemoryUtil.encodeASCII(charSequence, bl2, l2);
        return MemoryUtil.wrap(BUFFER_BYTE, l2, n2).order(NATIVE_ORDER);
    }

    public static ByteBuffer memASCIISafe(CharSequence charSequence, boolean bl2) {
        return charSequence == null ? null : MemoryUtil.memASCII(charSequence, bl2);
    }

    public static int memASCII(CharSequence charSequence, boolean bl2, ByteBuffer byteBuffer) {
        return MemoryUtil.encodeASCII(charSequence, bl2, MemoryUtil.memAddress(byteBuffer));
    }

    public static int memASCII(CharSequence charSequence, boolean bl2, ByteBuffer byteBuffer, int n2) {
        return MemoryUtil.encodeASCII(charSequence, bl2, MemoryUtil.memAddress(byteBuffer, n2));
    }

    static int encodeASCII(CharSequence charSequence, boolean bl2, long l2) {
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            UNSAFE.putByte(l2 + (long)i2, (byte)charSequence.charAt(i2));
        }
        if (bl2) {
            UNSAFE.putByte(l2 + (long)n2++, (byte)0);
        }
        return n2;
    }

    public static int memLengthASCII(CharSequence charSequence, boolean bl2) {
        return charSequence.length() + (bl2 ? 1 : 0);
    }

    public static ByteBuffer memUTF8(CharSequence charSequence) {
        return MemoryUtil.memUTF8(charSequence, true);
    }

    public static ByteBuffer memUTF8Safe(CharSequence charSequence) {
        return charSequence == null ? null : MemoryUtil.memUTF8(charSequence, true);
    }

    public static ByteBuffer memUTF8(CharSequence charSequence, boolean bl2) {
        int n2 = MemoryUtil.memLengthUTF8(charSequence, bl2);
        long l2 = MemoryUtil.nmemAlloc(n2);
        MemoryUtil.encodeUTF8(charSequence, bl2, l2);
        return MemoryUtil.wrap(BUFFER_BYTE, l2, n2).order(NATIVE_ORDER);
    }

    public static ByteBuffer memUTF8Safe(CharSequence charSequence, boolean bl2) {
        return charSequence == null ? null : MemoryUtil.memUTF8(charSequence, bl2);
    }

    public static int memUTF8(CharSequence charSequence, boolean bl2, ByteBuffer byteBuffer) {
        return MemoryUtil.encodeUTF8(charSequence, bl2, MemoryUtil.memAddress(byteBuffer));
    }

    public static int memUTF8(CharSequence charSequence, boolean bl2, ByteBuffer byteBuffer, int n2) {
        return MemoryUtil.encodeUTF8(charSequence, bl2, MemoryUtil.memAddress(byteBuffer, n2));
    }

    static int encodeUTF8(CharSequence charSequence, boolean bl2, long l2) {
        int n2;
        int n3;
        int n4 = charSequence.length();
        int n5 = 0;
        for (n3 = 0; n3 < n4 && (n2 = charSequence.charAt(n3)) < 128; ++n3) {
            UNSAFE.putByte(l2 + (long)n5++, (byte)n2);
        }
        while (n3 < n4) {
            if ((n2 = charSequence.charAt(n3++)) < 128) {
                UNSAFE.putByte(l2 + (long)n5++, (byte)n2);
                continue;
            }
            int n6 = n2;
            if (n2 < 2048) {
                UNSAFE.putByte(l2 + (long)n5++, (byte)(0xC0 | n6 >> 6));
            } else {
                if (!Character.isHighSurrogate((char)n2)) {
                    UNSAFE.putByte(l2 + (long)n5++, (byte)(0xE0 | n6 >> 12));
                } else {
                    n6 = Character.toCodePoint((char)n2, charSequence.charAt(n3++));
                    UNSAFE.putByte(l2 + (long)n5++, (byte)(0xF0 | n6 >> 18));
                    UNSAFE.putByte(l2 + (long)n5++, (byte)(0x80 | n6 >> 12 & 0x3F));
                }
                UNSAFE.putByte(l2 + (long)n5++, (byte)(0x80 | n6 >> 6 & 0x3F));
            }
            UNSAFE.putByte(l2 + (long)n5++, (byte)(0x80 | n6 & 0x3F));
        }
        if (bl2) {
            UNSAFE.putByte(l2 + (long)n5++, (byte)0);
        }
        return n5;
    }

    public static int memLengthUTF8(CharSequence charSequence, boolean bl2) {
        int n2;
        int n3;
        int n4 = n3 = charSequence.length();
        for (n2 = 0; n2 < n3 && '\u0080' > charSequence.charAt(n2); ++n2) {
        }
        while (n2 < n3) {
            char c2 = charSequence.charAt(n2);
            if ('\u0800' <= c2) {
                n4 += MemoryUtil.encodeUTF8LengthSlow(charSequence, n2, n3);
                break;
            }
            n4 += 127 - c2 >>> 31;
            ++n2;
        }
        return n4 + (bl2 ? 1 : 0);
    }

    private static int encodeUTF8LengthSlow(CharSequence charSequence, int n2, int n3) {
        int n4 = 0;
        for (int i2 = n2; i2 < n3; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 < '\u0800') {
                n4 += 127 - c2 >>> 31;
                continue;
            }
            if (c2 < '\ud800' || '\udfff' < c2) {
                n4 += 2;
                continue;
            }
            n4 += 2;
            ++i2;
        }
        return n4;
    }

    public static ByteBuffer memUTF16(CharSequence charSequence) {
        return MemoryUtil.memUTF16(charSequence, true);
    }

    public static ByteBuffer memUTF16Safe(CharSequence charSequence) {
        return charSequence == null ? null : MemoryUtil.memUTF16(charSequence, true);
    }

    public static ByteBuffer memUTF16(CharSequence charSequence, boolean bl2) {
        int n2 = MemoryUtil.memLengthUTF16(charSequence, bl2);
        long l2 = MemoryUtil.nmemAlloc(n2);
        MemoryUtil.encodeUTF16(charSequence, bl2, l2);
        return MemoryUtil.wrap(BUFFER_BYTE, l2, n2).order(NATIVE_ORDER);
    }

    public static ByteBuffer memUTF16Safe(CharSequence charSequence, boolean bl2) {
        return charSequence == null ? null : MemoryUtil.memUTF16(charSequence, bl2);
    }

    public static int memUTF16(CharSequence charSequence, boolean bl2, ByteBuffer byteBuffer) {
        return MemoryUtil.encodeUTF16(charSequence, bl2, MemoryUtil.memAddress(byteBuffer));
    }

    public static int memUTF16(CharSequence charSequence, boolean bl2, ByteBuffer byteBuffer, int n2) {
        return MemoryUtil.encodeUTF16(charSequence, bl2, MemoryUtil.memAddress(byteBuffer, n2));
    }

    static int encodeUTF16(CharSequence charSequence, boolean bl2, long l2) {
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            UNSAFE.putShort(l2 + Integer.toUnsignedLong(i2) * 2L, (short)charSequence.charAt(i2));
        }
        if (bl2) {
            UNSAFE.putShort(l2 + Integer.toUnsignedLong(n2++) * 2L, (short)0);
        }
        return 2 * n2;
    }

    public static int memLengthUTF16(CharSequence charSequence, boolean bl2) {
        return charSequence.length() + (bl2 ? 1 : 0) << 1;
    }

    private static int memLengthNT1(long l2, int n2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return Pointer.BITS64 ? MemoryUtil.strlen64NT1(l2, n2) : MemoryUtil.strlen32NT1(l2, n2);
    }

    private static int strlen64NT1(long l2, int n2) {
        int n3;
        if (8 <= n2) {
            int n4 = (int)l2 & 7;
            if (n4 != 0) {
                int n5 = 8 - n4;
                for (n3 = 0; n3 < n5; ++n3) {
                    if (UNSAFE.getByte(null, l2 + (long)n3) != 0) continue;
                    return n3;
                }
            }
            while (n3 <= n2 - 8 && !MathUtil.mathHasZeroByte(UNSAFE.getLong(null, l2 + (long)n3))) {
                n3 += 8;
            }
        }
        while (n3 < n2 && UNSAFE.getByte(null, l2 + (long)n3) != 0) {
            ++n3;
        }
        return n3;
    }

    private static int strlen32NT1(long l2, int n2) {
        int n3;
        if (4 <= n2) {
            int n4 = (int)l2 & 3;
            if (n4 != 0) {
                int n5 = 4 - n4;
                for (n3 = 0; n3 < n5; ++n3) {
                    if (UNSAFE.getByte(null, l2 + (long)n3) != 0) continue;
                    return n3;
                }
            }
            while (n3 <= n2 - 4 && !MathUtil.mathHasZeroByte(UNSAFE.getInt(null, l2 + (long)n3))) {
                n3 += 4;
            }
        }
        while (n3 < n2 && UNSAFE.getByte(null, l2 + (long)n3) != 0) {
            ++n3;
        }
        return n3;
    }

    public static int memLengthNT1(ByteBuffer byteBuffer) {
        return MemoryUtil.memLengthNT1(MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining());
    }

    private static int memLengthNT2(long l2, int n2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return Pointer.BITS64 ? MemoryUtil.strlen64NT2(l2, n2) : MemoryUtil.strlen32NT2(l2, n2);
    }

    private static int strlen64NT2(long l2, int n2) {
        int n3;
        if (8 <= n2) {
            int n4 = (int)l2 & 7;
            if (n4 != 0) {
                int n5 = 8 - n4;
                for (n3 = 0; n3 < n5; n3 += 2) {
                    if (UNSAFE.getShort(null, l2 + (long)n3) != 0) continue;
                    return n3;
                }
            }
            while (n3 <= n2 - 8 && !MathUtil.mathHasZeroShort(UNSAFE.getLong(null, l2 + (long)n3))) {
                n3 += 8;
            }
        }
        while (n3 < n2 && UNSAFE.getShort(null, l2 + (long)n3) != 0) {
            n3 += 2;
        }
        return n3;
    }

    private static int strlen32NT2(long l2, int n2) {
        int n3;
        if (4 <= n2) {
            int n4 = (int)l2 & 3;
            if (n4 != 0) {
                int n5 = 4 - n4;
                for (n3 = 0; n3 < n5; n3 += 2) {
                    if (UNSAFE.getShort(null, l2 + (long)n3) != 0) continue;
                    return n3;
                }
            }
            while (n3 <= n2 - 4 && !MathUtil.mathHasZeroShort(UNSAFE.getInt(null, l2 + (long)n3))) {
                n3 += 4;
            }
        }
        while (n3 < n2 && UNSAFE.getShort(null, l2 + (long)n3) != 0) {
            n3 += 2;
        }
        return n3;
    }

    public static int memLengthNT2(ByteBuffer byteBuffer) {
        return MemoryUtil.memLengthNT2(MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining());
    }

    public static ByteBuffer memByteBufferNT1(long l2) {
        return MemoryUtil.memByteBuffer(l2, MemoryUtil.memLengthNT1(l2, Integer.MAX_VALUE));
    }

    public static ByteBuffer memByteBufferNT1(long l2, int n2) {
        return MemoryUtil.memByteBuffer(l2, MemoryUtil.memLengthNT1(l2, n2));
    }

    public static ByteBuffer memByteBufferNT1Safe(long l2) {
        return l2 == 0L ? null : MemoryUtil.memByteBuffer(l2, MemoryUtil.memLengthNT1(l2, Integer.MAX_VALUE));
    }

    public static ByteBuffer memByteBufferNT1Safe(long l2, int n2) {
        return l2 == 0L ? null : MemoryUtil.memByteBuffer(l2, MemoryUtil.memLengthNT1(l2, n2));
    }

    public static ByteBuffer memByteBufferNT2(long l2) {
        return MemoryUtil.memByteBufferNT2(l2, 0x7FFFFFFE);
    }

    public static ByteBuffer memByteBufferNT2(long l2, int n2) {
        if (Checks.DEBUG && (n2 & 1) != 0) {
            throw new IllegalArgumentException("The maximum length must be an even number.");
        }
        return MemoryUtil.memByteBuffer(l2, MemoryUtil.memLengthNT2(l2, n2));
    }

    public static ByteBuffer memByteBufferNT2Safe(long l2) {
        return l2 == 0L ? null : MemoryUtil.memByteBufferNT2(l2, 0x7FFFFFFE);
    }

    public static ByteBuffer memByteBufferNT2Safe(long l2, int n2) {
        return l2 == 0L ? null : MemoryUtil.memByteBufferNT2(l2, n2);
    }

    public static String memASCII(long l2) {
        return MemoryUtil.memASCII(l2, MemoryUtil.memLengthNT1(l2, Integer.MAX_VALUE));
    }

    public static String memASCII(long l2, int n2) {
        if (n2 <= 0) {
            return "";
        }
        byte[] byArray = n2 <= ARRAY_TLC_SIZE ? ARRAY_TLC_BYTE.get() : new byte[n2];
        MemoryUtil.memByteBuffer(l2, n2).get(byArray, 0, n2);
        return new String(byArray, 0, 0, n2);
    }

    public static String memASCII(ByteBuffer byteBuffer) {
        return MemoryUtil.memASCII(MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining());
    }

    public static String memASCIISafe(long l2) {
        return l2 == 0L ? null : MemoryUtil.memASCII(l2, MemoryUtil.memLengthNT1(l2, Integer.MAX_VALUE));
    }

    public static String memASCIISafe(long l2, int n2) {
        return l2 == 0L ? null : MemoryUtil.memASCII(l2, n2);
    }

    public static String memASCIISafe(ByteBuffer byteBuffer) {
        return byteBuffer == null ? null : MemoryUtil.memASCII(MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining());
    }

    public static String memASCII(ByteBuffer byteBuffer, int n2) {
        return MemoryUtil.memASCII(MemoryUtil.memAddress(byteBuffer), n2);
    }

    public static String memASCII(ByteBuffer byteBuffer, int n2, int n3) {
        return MemoryUtil.memASCII(MemoryUtil.memAddress(byteBuffer, n3), n2);
    }

    public static String memUTF8(long l2) {
        return MultiReleaseTextDecoding.decodeUTF8(l2, MemoryUtil.memLengthNT1(l2, Integer.MAX_VALUE));
    }

    public static String memUTF8(long l2, int n2) {
        return MultiReleaseTextDecoding.decodeUTF8(l2, n2);
    }

    public static String memUTF8(ByteBuffer byteBuffer) {
        return MultiReleaseTextDecoding.decodeUTF8(MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining());
    }

    public static String memUTF8Safe(long l2) {
        return l2 == 0L ? null : MultiReleaseTextDecoding.decodeUTF8(l2, MemoryUtil.memLengthNT1(l2, Integer.MAX_VALUE));
    }

    public static String memUTF8Safe(long l2, int n2) {
        return l2 == 0L ? null : MultiReleaseTextDecoding.decodeUTF8(l2, n2);
    }

    public static String memUTF8Safe(ByteBuffer byteBuffer) {
        return byteBuffer == null ? null : MultiReleaseTextDecoding.decodeUTF8(MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining());
    }

    public static String memUTF8(ByteBuffer byteBuffer, int n2) {
        return MultiReleaseTextDecoding.decodeUTF8(MemoryUtil.memAddress(byteBuffer), n2);
    }

    public static String memUTF8(ByteBuffer byteBuffer, int n2, int n3) {
        return MultiReleaseTextDecoding.decodeUTF8(MemoryUtil.memAddress(byteBuffer, n3), n2);
    }

    public static String memUTF16(long l2) {
        return MemoryUtil.memUTF16(l2, MemoryUtil.memLengthNT2(l2, 0x7FFFFFFE) >> 1);
    }

    public static String memUTF16(long l2, int n2) {
        if (n2 <= 0) {
            return "";
        }
        if (Checks.DEBUG) {
            int n3 = n2 << 1;
            byte[] byArray = n3 <= ARRAY_TLC_SIZE ? ARRAY_TLC_BYTE.get() : new byte[n3];
            MemoryUtil.memByteBuffer(l2, n3).get(byArray, 0, n3);
            return new String(byArray, 0, n3, UTF16);
        }
        char[] cArray = n2 <= ARRAY_TLC_SIZE ? ARRAY_TLC_CHAR.get() : new char[n2];
        MemoryUtil.memCharBuffer(l2, n2).get(cArray, 0, n2);
        return new String(cArray, 0, n2);
    }

    public static String memUTF16(ByteBuffer byteBuffer) {
        return MemoryUtil.memUTF16(MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining() >> 1);
    }

    public static String memUTF16Safe(long l2) {
        return l2 == 0L ? null : MemoryUtil.memUTF16(l2, MemoryUtil.memLengthNT2(l2, 0x7FFFFFFE) >> 1);
    }

    public static String memUTF16Safe(long l2, int n2) {
        return l2 == 0L ? null : MemoryUtil.memUTF16(l2, n2);
    }

    public static String memUTF16Safe(ByteBuffer byteBuffer) {
        return byteBuffer == null ? null : MemoryUtil.memUTF16(MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining() >> 1);
    }

    public static String memUTF16(ByteBuffer byteBuffer, int n2) {
        return MemoryUtil.memUTF16(MemoryUtil.memAddress(byteBuffer), n2);
    }

    public static String memUTF16(ByteBuffer byteBuffer, int n2, int n3) {
        return MemoryUtil.memUTF16(MemoryUtil.memAddress(byteBuffer, n3), n2);
    }

    private static Unsafe getUnsafeInstance() {
        Field[] fieldArray;
        for (Field field : fieldArray = Unsafe.class.getDeclaredFields()) {
            int n2;
            if (!field.getType().equals(Unsafe.class) || !Modifier.isStatic(n2 = field.getModifiers()) || !Modifier.isFinal(n2)) continue;
            try {
                field.setAccessible(true);
                return (Unsafe)field.get(null);
            }
            catch (Exception exception) {
                break;
            }
        }
        throw new UnsupportedOperationException("LWJGL requires sun.misc.Unsafe to be available.");
    }

    private static long getAddressOffset() {
        long l2 = -2401053090268712947L;
        if (Pointer.BITS32) {
            l2 &= 0xFFFFFFFFL;
        }
        ByteBuffer byteBuffer = Objects.requireNonNull(JNINativeInterface.NewDirectByteBuffer(l2, 0L));
        long l3 = 8L;
        while (UNSAFE.getLong(byteBuffer, l3) != l2) {
            l3 += 8L;
        }
        return l3;
    }

    private static long getIntFieldOffset(ByteBuffer byteBuffer, int n2) {
        long l2 = 4L;
        while (UNSAFE.getInt(byteBuffer, l2) != n2) {
            l2 += 4L;
        }
        return l2;
    }

    private static long getMarkOffset() {
        ByteBuffer byteBuffer = Objects.requireNonNull(JNINativeInterface.NewDirectByteBuffer(1L, 0L));
        return MemoryUtil.getIntFieldOffset(byteBuffer, -1);
    }

    private static long getPositionOffset() {
        ByteBuffer byteBuffer = Objects.requireNonNull(JNINativeInterface.NewDirectByteBuffer(-1L, 219540062L));
        byteBuffer.position(16435934);
        return MemoryUtil.getIntFieldOffset(byteBuffer, 16435934);
    }

    private static long getLimitOffset() {
        ByteBuffer byteBuffer = Objects.requireNonNull(JNINativeInterface.NewDirectByteBuffer(-1L, 219540062L));
        byteBuffer.limit(16435934);
        return MemoryUtil.getIntFieldOffset(byteBuffer, 16435934);
    }

    private static long getCapacityOffset() {
        ByteBuffer byteBuffer = Objects.requireNonNull(JNINativeInterface.NewDirectByteBuffer(-1L, 219540062L));
        byteBuffer.limit(0);
        return MemoryUtil.getIntFieldOffset(byteBuffer, 219540062);
    }

    private static <T extends Buffer> long getParentOffset(int n2, T t2, Function<T, T> function) {
        Buffer buffer = (Buffer)function.apply(t2);
        long l2 = n2;
        switch (n2) {
            case 4: {
                while (true) {
                    if (UNSAFE.getInt(t2, l2) != UNSAFE.getInt(buffer, l2)) {
                        return l2;
                    }
                    l2 += (long)n2;
                }
            }
            case 8: {
                while (UNSAFE.getLong(t2, l2) == UNSAFE.getLong(buffer, l2)) {
                    l2 += (long)n2;
                }
                return l2;
            }
        }
        throw new IllegalStateException();
    }

    static <T extends Buffer> T wrap(Class<? extends T> clazz, long l2, int n2) {
        Buffer buffer;
        try {
            buffer = (Buffer)UNSAFE.allocateInstance(clazz);
        }
        catch (InstantiationException instantiationException) {
            throw new UnsupportedOperationException(instantiationException);
        }
        UNSAFE.putLong(buffer, ADDRESS, l2);
        UNSAFE.putInt(buffer, MARK, -1);
        UNSAFE.putInt(buffer, LIMIT, n2);
        UNSAFE.putInt(buffer, CAPACITY, n2);
        return (T)buffer;
    }

    static <T extends Buffer> T slice(Class<? extends T> clazz, T t2, long l2, int n2, long l3) {
        Buffer buffer;
        try {
            buffer = (Buffer)UNSAFE.allocateInstance(clazz);
        }
        catch (InstantiationException instantiationException) {
            throw new UnsupportedOperationException(instantiationException);
        }
        UNSAFE.putLong(buffer, ADDRESS, l2);
        UNSAFE.putInt(buffer, MARK, -1);
        UNSAFE.putInt(buffer, LIMIT, n2);
        UNSAFE.putInt(buffer, CAPACITY, n2);
        UNSAFE.putObject(buffer, l3, UNSAFE.getObject(t2, l3));
        return (T)buffer;
    }

    static <T extends Buffer> T duplicate(Class<? extends T> clazz, T t2, long l2) {
        Buffer buffer;
        try {
            buffer = (Buffer)UNSAFE.allocateInstance(clazz);
        }
        catch (InstantiationException instantiationException) {
            throw new UnsupportedOperationException(instantiationException);
        }
        UNSAFE.putLong(buffer, ADDRESS, UNSAFE.getLong(t2, ADDRESS));
        UNSAFE.putInt(buffer, MARK, UNSAFE.getInt(t2, MARK));
        UNSAFE.putInt(buffer, POSITION, UNSAFE.getInt(t2, POSITION));
        UNSAFE.putInt(buffer, LIMIT, UNSAFE.getInt(t2, LIMIT));
        UNSAFE.putInt(buffer, CAPACITY, UNSAFE.getInt(t2, CAPACITY));
        UNSAFE.putObject(buffer, l2, UNSAFE.getObject(t2, l2));
        return (T)buffer;
    }

    static {
        int n2;
        ARRAY_TLC_SIZE = Configuration.ARRAY_TLC_SIZE.get(8192);
        ARRAY_TLC_BYTE = ThreadLocal.withInitial(() -> new byte[ARRAY_TLC_SIZE]);
        ARRAY_TLC_CHAR = ThreadLocal.withInitial(() -> new char[ARRAY_TLC_SIZE]);
        NATIVE_ORDER = ByteOrder.nativeOrder();
        UTF16 = NATIVE_ORDER == ByteOrder.LITTLE_ENDIAN ? StandardCharsets.UTF_16LE : StandardCharsets.UTF_16BE;
        Library.initialize();
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(0).order(NATIVE_ORDER);
        BUFFER_BYTE = byteBuffer2.getClass();
        BUFFER_SHORT = byteBuffer2.asShortBuffer().getClass();
        BUFFER_CHAR = byteBuffer2.asCharBuffer().getClass();
        BUFFER_INT = byteBuffer2.asIntBuffer().getClass();
        BUFFER_LONG = byteBuffer2.asLongBuffer().getClass();
        BUFFER_FLOAT = byteBuffer2.asFloatBuffer().getClass();
        BUFFER_DOUBLE = byteBuffer2.asDoubleBuffer().getClass();
        UNSAFE = MemoryUtil.getUnsafeInstance();
        try {
            ADDRESS = MemoryUtil.getAddressOffset();
            MARK = MemoryUtil.getMarkOffset();
            POSITION = MemoryUtil.getPositionOffset();
            LIMIT = MemoryUtil.getLimitOffset();
            CAPACITY = MemoryUtil.getCapacityOffset();
            n2 = UNSAFE.arrayIndexScale(Object[].class);
            PARENT_BYTE = MemoryUtil.getParentOffset(n2, byteBuffer2, byteBuffer -> byteBuffer.duplicate().order(byteBuffer.order()));
            PARENT_SHORT = MemoryUtil.getParentOffset(n2, byteBuffer2.asShortBuffer(), ShortBuffer::duplicate);
            PARENT_CHAR = MemoryUtil.getParentOffset(n2, byteBuffer2.asCharBuffer(), CharBuffer::duplicate);
            PARENT_INT = MemoryUtil.getParentOffset(n2, byteBuffer2.asIntBuffer(), IntBuffer::duplicate);
            PARENT_LONG = MemoryUtil.getParentOffset(n2, byteBuffer2.asLongBuffer(), LongBuffer::duplicate);
            PARENT_FLOAT = MemoryUtil.getParentOffset(n2, byteBuffer2.asFloatBuffer(), FloatBuffer::duplicate);
            PARENT_DOUBLE = MemoryUtil.getParentOffset(n2, byteBuffer2.asDoubleBuffer(), DoubleBuffer::duplicate);
        }
        catch (Throwable throwable) {
            throw new UnsupportedOperationException(throwable);
        }
        for (n2 = 0; n2 < 10000; ++n2) {
            UNSAFE.putObject(byteBuffer2, PARENT_BYTE, UNSAFE.getObject(byteBuffer2, PARENT_BYTE));
        }
        PAGE_SIZE = UNSAFE.pageSize();
        CACHE_LINE_SIZE = 64;
        SHIFT = NATIVE_ORDER == ByteOrder.BIG_ENDIAN ? new MemoryUtil$1() : new MemoryUtil$2();
        FILL_PATTERN = Long.divideUnsigned(-1L, 255L);
    }
}

