/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Callback;
import org.lwjgl.system.MemoryManage$DebugAllocator$1;
import org.lwjgl.system.MemoryManage$DebugAllocator$2;
import org.lwjgl.system.MemoryManage$DebugAllocator$3;
import org.lwjgl.system.MemoryManage$DebugAllocator$4;
import org.lwjgl.system.MemoryManage$DebugAllocator$5;
import org.lwjgl.system.MemoryManage$DebugAllocator$6;
import org.lwjgl.system.MemoryManage$DebugAllocator$Allocation;
import org.lwjgl.system.MemoryUtil$MemoryAllocationReport;
import org.lwjgl.system.MemoryUtil$MemoryAllocationReport$Aggregate;
import org.lwjgl.system.MemoryUtil$MemoryAllocator;
import org.lwjgl.system.StackWalkUtil;

class MemoryManage$DebugAllocator
implements MemoryUtil$MemoryAllocator {
    private static final ConcurrentMap<Long, MemoryManage$DebugAllocator$Allocation> ALLOCATIONS = new ConcurrentHashMap<Long, MemoryManage$DebugAllocator$Allocation>();
    private static final ConcurrentMap<Long, String> THREADS = new ConcurrentHashMap<Long, String>();
    private final MemoryUtil$MemoryAllocator allocator;
    private final long[] callbacks;

    MemoryManage$DebugAllocator(MemoryUtil$MemoryAllocator memoryUtil$MemoryAllocator) {
        this.allocator = memoryUtil$MemoryAllocator;
        this.callbacks = new long[]{new MemoryManage$DebugAllocator$1(this).address(), new MemoryManage$DebugAllocator$2(this).address(), new MemoryManage$DebugAllocator$3(this).address(), new MemoryManage$DebugAllocator$4(this).address(), new MemoryManage$DebugAllocator$5(this).address(), new MemoryManage$DebugAllocator$6(this).address()};
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            for (long l2 : this.callbacks) {
                Callback.free(l2);
            }
            if (ALLOCATIONS.isEmpty()) {
                return;
            }
            Object object = ALLOCATIONS.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                Long l3 = (Long)entry.getKey();
                MemoryManage$DebugAllocator$Allocation memoryManage$DebugAllocator$Allocation = (MemoryManage$DebugAllocator$Allocation)entry.getValue();
                APIUtil.DEBUG_STREAM.format("[LWJGL] %d bytes leaked, thread %d (%s), address: 0x%s\n", memoryManage$DebugAllocator$Allocation.size, memoryManage$DebugAllocator$Allocation.threadId, THREADS.get(memoryManage$DebugAllocator$Allocation.threadId), Long.toHexString(l3).toUpperCase());
                for (Object object2 : MemoryManage$DebugAllocator$Allocation.access$200(memoryManage$DebugAllocator$Allocation)) {
                    APIUtil.DEBUG_STREAM.format("\tat %s\n", object2.toString());
                }
            }
        }));
    }

    @Override
    public long getMalloc() {
        return this.callbacks[0];
    }

    @Override
    public long getCalloc() {
        return this.callbacks[1];
    }

    @Override
    public long getRealloc() {
        return this.callbacks[2];
    }

    @Override
    public long getFree() {
        return this.callbacks[3];
    }

    @Override
    public long getAlignedAlloc() {
        return this.callbacks[4];
    }

    @Override
    public long getAlignedFree() {
        return this.callbacks[5];
    }

    @Override
    public long malloc(long l2) {
        return MemoryManage$DebugAllocator.track(this.allocator.malloc(l2), l2);
    }

    @Override
    public long calloc(long l2, long l3) {
        return MemoryManage$DebugAllocator.track(this.allocator.calloc(l2, l3), l2 * l3);
    }

    @Override
    public long realloc(long l2, long l3) {
        long l4 = MemoryManage$DebugAllocator.untrack(l2);
        long l5 = this.allocator.realloc(l2, l3);
        if (l5 != 0L) {
            MemoryManage$DebugAllocator.track(l5, l3);
        } else if (l3 != 0L) {
            MemoryManage$DebugAllocator.track(l2, l4);
        }
        return l5;
    }

    @Override
    public void free(long l2) {
        MemoryManage$DebugAllocator.untrack(l2);
        this.allocator.free(l2);
    }

    @Override
    public long aligned_alloc(long l2, long l3) {
        return MemoryManage$DebugAllocator.track(this.allocator.aligned_alloc(l2, l3), l3);
    }

    @Override
    public void aligned_free(long l2) {
        MemoryManage$DebugAllocator.untrack(l2);
        this.allocator.aligned_free(l2);
    }

    static long track(long l2, long l3) {
        if (l2 != 0L) {
            MemoryManage$DebugAllocator$Allocation memoryManage$DebugAllocator$Allocation;
            Thread thread = Thread.currentThread();
            Long l4 = thread.getId();
            if (!THREADS.containsKey(l4)) {
                THREADS.put(l4, thread.getName());
            }
            if ((memoryManage$DebugAllocator$Allocation = ALLOCATIONS.put(l2, new MemoryManage$DebugAllocator$Allocation(StackWalkUtil.stackWalkGetTrace(), l3))) != null) {
                throw new IllegalStateException("The memory address specified is already being tracked: 0x" + Long.toHexString(l2).toUpperCase());
            }
        }
        return l2;
    }

    static long untrack(long l2) {
        if (l2 == 0L) {
            return 0L;
        }
        MemoryManage$DebugAllocator$Allocation memoryManage$DebugAllocator$Allocation = (MemoryManage$DebugAllocator$Allocation)ALLOCATIONS.remove(l2);
        if (memoryManage$DebugAllocator$Allocation == null) {
            throw new IllegalStateException("The memory address specified is not being tracked: 0x" + Long.toHexString(l2).toUpperCase());
        }
        return memoryManage$DebugAllocator$Allocation.size;
    }

    static void report(MemoryUtil$MemoryAllocationReport memoryUtil$MemoryAllocationReport) {
        for (Map.Entry entry : ALLOCATIONS.entrySet()) {
            MemoryManage$DebugAllocator$Allocation memoryManage$DebugAllocator$Allocation = (MemoryManage$DebugAllocator$Allocation)entry.getValue();
            memoryUtil$MemoryAllocationReport.invoke((Long)entry.getKey(), memoryManage$DebugAllocator$Allocation.size, memoryManage$DebugAllocator$Allocation.threadId, (String)THREADS.get(memoryManage$DebugAllocator$Allocation.threadId), MemoryManage$DebugAllocator$Allocation.access$100(memoryManage$DebugAllocator$Allocation));
        }
    }

    private static <T> void aggregate(T t2, long l2, Map<T, AtomicLong> map) {
        AtomicLong atomicLong = map.computeIfAbsent(t2, object -> new AtomicLong());
        atomicLong.set(atomicLong.get() + l2);
    }

    static void report(MemoryUtil$MemoryAllocationReport memoryUtil$MemoryAllocationReport, MemoryUtil$MemoryAllocationReport$Aggregate memoryUtil$MemoryAllocationReport$Aggregate, boolean bl2) {
        switch (memoryUtil$MemoryAllocationReport$Aggregate) {
            case ALL: {
                if (bl2) {
                    HashMap hashMap = new HashMap();
                    for (MemoryManage$DebugAllocator$Allocation object : ALLOCATIONS.values()) {
                        MemoryManage$DebugAllocator.aggregate(object.threadId, object.size, hashMap);
                    }
                    for (Map.Entry object : hashMap.entrySet()) {
                        memoryUtil$MemoryAllocationReport.invoke(0L, ((AtomicLong)object.getValue()).get(), (Long)object.getKey(), (String)THREADS.get(object.getKey()), null);
                    }
                    break;
                }
                long l3 = 0L;
                for (MemoryManage$DebugAllocator$Allocation memoryManage$DebugAllocator$Allocation : ALLOCATIONS.values()) {
                    l3 += memoryManage$DebugAllocator$Allocation.size;
                }
                memoryUtil$MemoryAllocationReport.invoke(0L, l3, 0L, null, null);
                break;
            }
            case GROUP_BY_METHOD: {
                if (bl2) {
                    HashMap<Long, Map> hashMap = new HashMap<Long, Map>();
                    for (MemoryManage$DebugAllocator$Allocation object : ALLOCATIONS.values()) {
                        Map map = hashMap.computeIfAbsent(object.threadId, l2 -> new HashMap());
                        MemoryManage$DebugAllocator.aggregate(MemoryManage$DebugAllocator$Allocation.access$100(object)[0], object.size, map);
                    }
                    for (Map.Entry entry : hashMap.entrySet()) {
                        long l3 = (Long)entry.getKey();
                        Map map = (Map)entry.getValue();
                        for (Map.Entry entry2 : map.entrySet()) {
                            memoryUtil$MemoryAllocationReport.invoke(0L, ((AtomicLong)entry2.getValue()).get(), l3, (String)THREADS.get(l3), (StackTraceElement)entry2.getKey());
                        }
                    }
                } else {
                    HashMap hashMap = new HashMap();
                    for (MemoryManage$DebugAllocator$Allocation memoryManage$DebugAllocator$Allocation : ALLOCATIONS.values()) {
                        MemoryManage$DebugAllocator.aggregate(MemoryManage$DebugAllocator$Allocation.access$100(memoryManage$DebugAllocator$Allocation)[0], memoryManage$DebugAllocator$Allocation.size, hashMap);
                    }
                    for (Map.Entry entry : hashMap.entrySet()) {
                        memoryUtil$MemoryAllocationReport.invoke(0L, ((AtomicLong)entry.getValue()).get(), 0L, null, (StackTraceElement)entry.getKey());
                    }
                }
                break;
            }
            case GROUP_BY_STACKTRACE: {
                if (bl2) {
                    HashMap<Long, Map> hashMap = new HashMap<Long, Map>();
                    for (MemoryManage$DebugAllocator$Allocation memoryManage$DebugAllocator$Allocation : ALLOCATIONS.values()) {
                        Map map = hashMap.computeIfAbsent(memoryManage$DebugAllocator$Allocation.threadId, l2 -> new HashMap());
                        MemoryManage$DebugAllocator.aggregate(memoryManage$DebugAllocator$Allocation, memoryManage$DebugAllocator$Allocation.size, map);
                    }
                    for (Map.Entry entry : hashMap.entrySet()) {
                        long l4 = (Long)entry.getKey();
                        Map map = (Map)entry.getValue();
                        for (Map.Entry entry3 : map.entrySet()) {
                            memoryUtil$MemoryAllocationReport.invoke(0L, ((AtomicLong)entry3.getValue()).get(), l4, (String)THREADS.get(l4), MemoryManage$DebugAllocator$Allocation.access$100((MemoryManage$DebugAllocator$Allocation)entry3.getKey()));
                        }
                    }
                } else {
                    HashMap hashMap = new HashMap();
                    for (MemoryManage$DebugAllocator$Allocation memoryManage$DebugAllocator$Allocation : ALLOCATIONS.values()) {
                        MemoryManage$DebugAllocator.aggregate(memoryManage$DebugAllocator$Allocation, memoryManage$DebugAllocator$Allocation.size, hashMap);
                    }
                    for (Map.Entry entry : hashMap.entrySet()) {
                        memoryUtil$MemoryAllocationReport.invoke(0L, ((AtomicLong)entry.getValue()).get(), 0L, null, MemoryManage$DebugAllocator$Allocation.access$100((MemoryManage$DebugAllocator$Allocation)entry.getKey()));
                    }
                }
                break;
            }
        }
    }
}

