/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.lang.reflect.Method;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.CallbackI;
import org.lwjgl.system.CallbackI$I;
import org.lwjgl.system.CallbackI$V;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.MemoryManage$DebugAllocator;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Platform;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.dyncall.DynCallback;
import org.lwjgl.system.jni.JNINativeInterface;

public abstract class Callback
implements NativeResource,
Pointer {
    private static final boolean DEBUG_ALLOCATOR = Configuration.DEBUG_MEMORY_ALLOCATOR.get(false);
    private static final long VOID;
    private static final long BOOLEAN;
    private static final long BYTE;
    private static final long SHORT;
    private static final long INT;
    private static final long LONG;
    private static final long FLOAT;
    private static final long DOUBLE;
    private static final long PTR;
    private long address;

    protected Callback(String string) {
        this.address = Callback.create(string, this);
    }

    protected Callback(long l2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        this.address = l2;
    }

    @Override
    public long address() {
        return this.address;
    }

    @Override
    public void free() {
        Callback.free(this.address());
    }

    private static native long getNativeCallbacks(Method[] var0, long var1);

    public static String __stdcall(String string) {
        return Platform.get() == Platform.WINDOWS && Pointer.BITS32 ? "_s" + string : string;
    }

    static long create(String string, Object object) {
        long l2 = Callback.getNativeFunction(string.charAt(string.length() - 1));
        long l3 = DynCallback.dcbNewCallback(string, l2, JNINativeInterface.NewGlobalRef(object));
        if (l3 == 0L) {
            throw new IllegalStateException("Failed to create the DCCallback object");
        }
        if (DEBUG_ALLOCATOR) {
            MemoryManage$DebugAllocator.track(l3, 2L * (long)POINTER_SIZE);
        }
        return l3;
    }

    private static long getNativeFunction(char c2) {
        switch (c2) {
            case 'v': {
                return VOID;
            }
            case 'B': {
                return BOOLEAN;
            }
            case 'c': {
                return BYTE;
            }
            case 's': {
                return SHORT;
            }
            case 'i': {
                return INT;
            }
            case 'l': {
                return LONG;
            }
            case 'p': {
                return PTR;
            }
            case 'f': {
                return FLOAT;
            }
            case 'd': {
                return DOUBLE;
            }
        }
        throw new IllegalArgumentException();
    }

    public static <T extends CallbackI> T get(long l2) {
        return (T)((CallbackI)MemoryUtil.memGlobalRefToObject(DynCallback.dcbGetUserData(l2)));
    }

    public static <T extends CallbackI> T getSafe(long l2) {
        return l2 == 0L ? null : (T)Callback.get(l2);
    }

    public static void free(long l2) {
        JNINativeInterface.DeleteGlobalRef(DynCallback.dcbGetUserData(l2));
        if (DEBUG_ALLOCATOR) {
            MemoryManage$DebugAllocator.untrack(l2);
        }
        DynCallback.dcbFreeCallback(l2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Callback)) {
            return false;
        }
        Callback callback = (Callback)object;
        return this.address == callback.address();
    }

    public int hashCode() {
        return (int)(this.address ^ this.address >>> 32);
    }

    public String toString() {
        return String.format("%s pointer [0x%X]", this.getClass().getSimpleName(), this.address);
    }

    static {
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            Class[] classArray = new Class[]{Long.TYPE};
            Method[] methodArray = new Method[]{CallbackI$V.class.getDeclaredMethod("callback", classArray), CallbackI.Z.class.getDeclaredMethod("callback", classArray), CallbackI.B.class.getDeclaredMethod("callback", classArray), CallbackI.S.class.getDeclaredMethod("callback", classArray), CallbackI$I.class.getDeclaredMethod("callback", classArray), CallbackI.J.class.getDeclaredMethod("callback", classArray), CallbackI.F.class.getDeclaredMethod("callback", classArray), CallbackI.D.class.getDeclaredMethod("callback", classArray), CallbackI.P.class.getDeclaredMethod("callback", classArray)};
            PointerBuffer pointerBuffer = memoryStack.mallocPointer(methodArray.length);
            Callback.getNativeCallbacks(methodArray, MemoryUtil.memAddress(pointerBuffer));
            VOID = pointerBuffer.get();
            BOOLEAN = pointerBuffer.get();
            BYTE = pointerBuffer.get();
            SHORT = pointerBuffer.get();
            INT = pointerBuffer.get();
            LONG = pointerBuffer.get();
            FLOAT = pointerBuffer.get();
            DOUBLE = pointerBuffer.get();
            PTR = pointerBuffer.get();
        }
        catch (Exception exception) {
            throw new IllegalStateException("Failed to initialize native callbacks.", exception);
        }
        MemoryUtil.getAllocator();
    }
}

