/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIUtil$APIVersion;
import org.lwjgl.system.APIUtil$Encoder;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Platform;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.linux.LinuxLibrary;
import org.lwjgl.system.macosx.MacOSXLibrary;
import org.lwjgl.system.windows.WindowsLibrary;

public final class APIUtil {
    public static final PrintStream DEBUG_STREAM = APIUtil.getDebugStream();

    private static PrintStream getDebugStream() {
        PrintStream printStream = System.err;
        Object object = Configuration.DEBUG_STREAM.get();
        if (object instanceof String) {
            try {
                Supplier supplier = (Supplier)Class.forName((String)object).getConstructor(new Class[0]).newInstance(new Object[0]);
                printStream = (PrintStream)supplier.get();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (object instanceof Supplier) {
            printStream = (PrintStream)((Supplier)object).get();
        } else if (object instanceof PrintStream) {
            printStream = (PrintStream)object;
        }
        return printStream;
    }

    private APIUtil() {
    }

    public static void apiLog(CharSequence charSequence) {
        if (Checks.DEBUG) {
            DEBUG_STREAM.print("[LWJGL] ");
            DEBUG_STREAM.println(charSequence);
        }
    }

    public static Optional<String> apiGetManifestValue(String string) {
        String string2;
        URL uRL = APIUtil.class.getClassLoader().getResource("org/lwjgl/system/APIUtil.class");
        if (uRL != null && (string2 = uRL.toString()).startsWith("jar:")) {
            Optional<String> optional;
            block9: {
                InputStream inputStream = new URL(string2.substring(0, string2.lastIndexOf(33) + 1) + '/' + "META-INF/MANIFEST.MF").openStream();
                Throwable throwable = null;
                try {
                    optional = Optional.ofNullable(new Manifest(inputStream).getMainAttributes().getValue(string));
                    if (inputStream == null) break block9;
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (inputStream != null) {
                                APIUtil.$closeResource(throwable, inputStream);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(DEBUG_STREAM);
                    }
                }
                APIUtil.$closeResource(throwable, inputStream);
            }
            return optional;
        }
        return Optional.empty();
    }

    public static String apiFindLibrary(String string, String string2) {
        String string3;
        block8: {
            String string4 = Platform.get().mapLibraryName(string2);
            Stream<Path> stream = Files.find(Paths.get(string, new String[0]).toAbsolutePath(), Integer.MAX_VALUE, (path, basicFileAttributes) -> basicFileAttributes.isRegularFile() && path.getFileName().toString().equals(string4), new FileVisitOption[0]);
            Throwable throwable = null;
            try {
                string3 = stream.findFirst().map(Path::toString).orElse(string2);
                if (stream == null) break block8;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (stream != null) {
                            APIUtil.$closeResource(throwable, stream);
                        }
                        throw throwable3;
                    }
                }
                catch (IOException iOException) {
                    return string2;
                }
            }
            APIUtil.$closeResource(throwable, stream);
        }
        return string3;
    }

    public static SharedLibrary apiCreateLibrary(String string) {
        switch (Platform.get()) {
            case WINDOWS: {
                return new WindowsLibrary(string);
            }
            case LINUX: {
                return new LinuxLibrary(string);
            }
            case MACOSX: {
                return MacOSXLibrary.create(string);
            }
        }
        throw new IllegalStateException();
    }

    public static long apiGetFunctionAddress(FunctionProvider functionProvider, String string) {
        long l2 = functionProvider.getFunctionAddress(string);
        if (l2 == 0L) {
            APIUtil.requiredFunctionMissing(string);
        }
        return l2;
    }

    private static void requiredFunctionMissing(String string) {
        if (!Configuration.DISABLE_FUNCTION_CHECKS.get(false).booleanValue()) {
            throw new NullPointerException("A required function is missing: " + string);
        }
    }

    public static ByteBuffer apiGetMappedBuffer(ByteBuffer byteBuffer, long l2, int n2) {
        if (byteBuffer != null && MemoryUtil.memAddress(byteBuffer) == l2 && byteBuffer.capacity() == n2) {
            return byteBuffer;
        }
        return l2 == 0L ? null : MemoryUtil.wrap(MemoryUtil.BUFFER_BYTE, l2, n2).order(MemoryUtil.NATIVE_ORDER);
    }

    public static long apiGetBytes(int n2, int n3) {
        return ((long)n2 & 0xFFFFFFFFL) << n3;
    }

    public static long apiCheckAllocation(int n2, long l2, long l3) {
        if (Checks.DEBUG) {
            if (n2 < 0) {
                throw new IllegalArgumentException("Invalid number of elements");
            }
            if (l3 + Long.MIN_VALUE < l2 + Long.MIN_VALUE) {
                throw new IllegalArgumentException("The request allocation is too large");
            }
        }
        return l2;
    }

    public static APIUtil$APIVersion apiParseVersion(Configuration<?> configuration) {
        Object obj = configuration.get();
        APIUtil$APIVersion aPIUtil$APIVersion = obj instanceof String ? APIUtil.apiParseVersion((String)obj, null) : (obj instanceof APIUtil$APIVersion ? (APIUtil$APIVersion)obj : null);
        return aPIUtil$APIVersion;
    }

    public static APIUtil$APIVersion apiParseVersion(String string) {
        return APIUtil.apiParseVersion(string, null);
    }

    public static APIUtil$APIVersion apiParseVersion(String string, String string2) {
        Matcher matcher;
        String string3 = "([0-9]+)[.]([0-9]+)([.]\\S+)?\\s*(.+)?";
        if (string2 != null) {
            string3 = "(?:" + string2 + "\\s+)?" + string3;
        }
        if (!(matcher = Pattern.compile(string3).matcher(string)).matches()) {
            throw new IllegalArgumentException(String.format("Malformed API version string [%s]", string));
        }
        return new APIUtil$APIVersion(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), matcher.group(3), matcher.group(4));
    }

    public static String apiUnknownToken(int n2) {
        return APIUtil.apiUnknownToken("Unknown", n2);
    }

    public static String apiUnknownToken(String string, int n2) {
        return String.format("%s [0x%X]", string, n2);
    }

    public static Map<Integer, String> apiClassTokens(BiPredicate<Field, Integer> biPredicate, Map<Integer, String> map, Class<?> ... classArray) {
        if (map == null) {
            map = new HashMap<Integer, String>(64);
        }
        int n2 = 25;
        for (Class<?> clazz : classArray) {
            if (clazz == null) continue;
            for (Field field : clazz.getDeclaredFields()) {
                if ((field.getModifiers() & n2) != n2 || field.getType() != Integer.TYPE) continue;
                try {
                    Integer n3 = field.getInt(null);
                    if (biPredicate != null && !biPredicate.test(field, n3)) continue;
                    String string = map.get(n3);
                    map.put(n3, string == null ? field.getName() : string + "|" + field.getName());
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        return map;
    }

    public static long apiArray(MemoryStack memoryStack, long ... lArray) {
        PointerBuffer pointerBuffer = MemoryUtil.memPointerBuffer(memoryStack.nmalloc(Pointer.POINTER_SIZE, lArray.length << Pointer.POINTER_SHIFT), lArray.length);
        for (long l2 : lArray) {
            pointerBuffer.put(l2);
        }
        return pointerBuffer.address;
    }

    public static long apiArray(MemoryStack memoryStack, ByteBuffer ... byteBufferArray) {
        PointerBuffer pointerBuffer = MemoryUtil.memPointerBuffer(memoryStack.nmalloc(Pointer.POINTER_SIZE, byteBufferArray.length << Pointer.POINTER_SHIFT), byteBufferArray.length);
        for (ByteBuffer byteBuffer : byteBufferArray) {
            pointerBuffer.put(byteBuffer);
        }
        return pointerBuffer.address;
    }

    public static long apiArrayp(MemoryStack memoryStack, ByteBuffer ... byteBufferArray) {
        long l2 = APIUtil.apiArray(memoryStack, byteBufferArray);
        PointerBuffer pointerBuffer = memoryStack.mallocPointer(byteBufferArray.length);
        for (ByteBuffer byteBuffer : byteBufferArray) {
            pointerBuffer.put(byteBuffer.remaining());
        }
        return l2;
    }

    public static long apiArray(MemoryStack memoryStack, APIUtil$Encoder aPIUtil$Encoder, CharSequence ... charSequenceArray) {
        PointerBuffer pointerBuffer = memoryStack.mallocPointer(charSequenceArray.length);
        for (CharSequence charSequence : charSequenceArray) {
            pointerBuffer.put(aPIUtil$Encoder.encode(charSequence, true));
        }
        return pointerBuffer.address;
    }

    public static long apiArrayi(MemoryStack memoryStack, APIUtil$Encoder aPIUtil$Encoder, CharSequence ... charSequenceArray) {
        PointerBuffer pointerBuffer = memoryStack.mallocPointer(charSequenceArray.length);
        IntBuffer intBuffer = memoryStack.mallocInt(charSequenceArray.length);
        for (CharSequence charSequence : charSequenceArray) {
            ByteBuffer byteBuffer = aPIUtil$Encoder.encode(charSequence, false);
            pointerBuffer.put(byteBuffer);
            intBuffer.put(byteBuffer.capacity());
        }
        return pointerBuffer.address;
    }

    public static long apiArrayp(MemoryStack memoryStack, APIUtil$Encoder aPIUtil$Encoder, CharSequence ... charSequenceArray) {
        PointerBuffer pointerBuffer = memoryStack.mallocPointer(charSequenceArray.length);
        PointerBuffer pointerBuffer2 = memoryStack.mallocPointer(charSequenceArray.length);
        for (CharSequence charSequence : charSequenceArray) {
            ByteBuffer byteBuffer = aPIUtil$Encoder.encode(charSequence, false);
            pointerBuffer.put(byteBuffer);
            pointerBuffer2.put(byteBuffer.capacity());
        }
        return pointerBuffer.address;
    }

    public static void apiArrayFree(long l2, int n2) {
        int n3 = n2;
        while (--n3 >= 0) {
            MemoryUtil.nmemFree(MemoryUtil.memGetAddress(l2 + Integer.toUnsignedLong(n3) * (long)Pointer.POINTER_SIZE));
        }
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable throwable, AutoCloseable autoCloseable) {
        if (throwable != null) {
            try {
                autoCloseable.close();
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
        } else {
            autoCloseable.close();
        }
    }
}

