/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.stb.STBVorbisInfo$Buffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;

@NativeType(value="struct stb_vorbis_info")
public class STBVorbisInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SAMPLE_RATE;
    public static final int CHANNELS;
    public static final int SETUP_MEMORY_REQUIRED;
    public static final int SETUP_TEMP_MEMORY_REQUIRED;
    public static final int TEMP_MEMORY_REQUIRED;
    public static final int MAX_FRAME_SIZE;

    public STBVorbisInfo(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), STBVorbisInfo.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int sample_rate() {
        return STBVorbisInfo.nsample_rate(this.address());
    }

    public int channels() {
        return STBVorbisInfo.nchannels(this.address());
    }

    @NativeType(value="unsigned int")
    public int setup_memory_required() {
        return STBVorbisInfo.nsetup_memory_required(this.address());
    }

    @NativeType(value="unsigned int")
    public int setup_temp_memory_required() {
        return STBVorbisInfo.nsetup_temp_memory_required(this.address());
    }

    @NativeType(value="unsigned int")
    public int temp_memory_required() {
        return STBVorbisInfo.ntemp_memory_required(this.address());
    }

    public int max_frame_size() {
        return STBVorbisInfo.nmax_frame_size(this.address());
    }

    public static STBVorbisInfo malloc() {
        return STBVorbisInfo.wrap(STBVorbisInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static STBVorbisInfo calloc() {
        return STBVorbisInfo.wrap(STBVorbisInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static STBVorbisInfo create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return STBVorbisInfo.wrap(STBVorbisInfo.class, MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static STBVorbisInfo create(long l2) {
        return STBVorbisInfo.wrap(STBVorbisInfo.class, l2);
    }

    public static STBVorbisInfo createSafe(long l2) {
        return l2 == 0L ? null : STBVorbisInfo.wrap(STBVorbisInfo.class, l2);
    }

    public static STBVorbisInfo$Buffer malloc(int n2) {
        return STBVorbisInfo.wrap(STBVorbisInfo$Buffer.class, MemoryUtil.nmemAllocChecked(STBVorbisInfo.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static STBVorbisInfo$Buffer calloc(int n2) {
        return STBVorbisInfo.wrap(STBVorbisInfo$Buffer.class, MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static STBVorbisInfo$Buffer create(int n2) {
        ByteBuffer byteBuffer = STBVorbisInfo.__create(n2, SIZEOF);
        return STBVorbisInfo.wrap(STBVorbisInfo$Buffer.class, MemoryUtil.memAddress(byteBuffer), n2, byteBuffer);
    }

    public static STBVorbisInfo$Buffer create(long l2, int n2) {
        return STBVorbisInfo.wrap(STBVorbisInfo$Buffer.class, l2, n2);
    }

    public static STBVorbisInfo$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : STBVorbisInfo.wrap(STBVorbisInfo$Buffer.class, l2, n2);
    }

    public static STBVorbisInfo mallocStack() {
        return STBVorbisInfo.mallocStack(MemoryStack.stackGet());
    }

    public static STBVorbisInfo callocStack() {
        return STBVorbisInfo.callocStack(MemoryStack.stackGet());
    }

    public static STBVorbisInfo mallocStack(MemoryStack memoryStack) {
        return STBVorbisInfo.wrap(STBVorbisInfo.class, memoryStack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static STBVorbisInfo callocStack(MemoryStack memoryStack) {
        return STBVorbisInfo.wrap(STBVorbisInfo.class, memoryStack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static STBVorbisInfo$Buffer mallocStack(int n2) {
        return STBVorbisInfo.mallocStack(n2, MemoryStack.stackGet());
    }

    public static STBVorbisInfo$Buffer callocStack(int n2) {
        return STBVorbisInfo.callocStack(n2, MemoryStack.stackGet());
    }

    public static STBVorbisInfo$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return STBVorbisInfo.wrap(STBVorbisInfo$Buffer.class, memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static STBVorbisInfo$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return STBVorbisInfo.wrap(STBVorbisInfo$Buffer.class, memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int nsample_rate(long l2) {
        return UNSAFE.getInt(null, l2 + (long)SAMPLE_RATE);
    }

    public static int nchannels(long l2) {
        return UNSAFE.getInt(null, l2 + (long)CHANNELS);
    }

    public static int nsetup_memory_required(long l2) {
        return UNSAFE.getInt(null, l2 + (long)SETUP_MEMORY_REQUIRED);
    }

    public static int nsetup_temp_memory_required(long l2) {
        return UNSAFE.getInt(null, l2 + (long)SETUP_TEMP_MEMORY_REQUIRED);
    }

    public static int ntemp_memory_required(long l2) {
        return UNSAFE.getInt(null, l2 + (long)TEMP_MEMORY_REQUIRED);
    }

    public static int nmax_frame_size(long l2) {
        return UNSAFE.getInt(null, l2 + (long)MAX_FRAME_SIZE);
    }

    static {
        Struct$Layout struct$Layout = STBVorbisInfo.__struct(STBVorbisInfo.__member(4), STBVorbisInfo.__member(4), STBVorbisInfo.__member(4), STBVorbisInfo.__member(4), STBVorbisInfo.__member(4), STBVorbisInfo.__member(4));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        SAMPLE_RATE = struct$Layout.offsetof(0);
        CHANNELS = struct$Layout.offsetof(1);
        SETUP_MEMORY_REQUIRED = struct$Layout.offsetof(2);
        SETUP_TEMP_MEMORY_REQUIRED = struct$Layout.offsetof(3);
        TEMP_MEMORY_REQUIRED = struct$Layout.offsetof(4);
        MAX_FRAME_SIZE = struct$Layout.offsetof(5);
    }
}

