/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.stb.STBVorbisAlloc$Buffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;

@NativeType(value="struct stb_vorbis_alloc")
public class STBVorbisAlloc
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ALLOC_BUFFER;
    public static final int ALLOC_BUFFER_LENGTH_IN_BYTES;

    public STBVorbisAlloc(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), STBVorbisAlloc.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char *")
    public ByteBuffer alloc_buffer() {
        return STBVorbisAlloc.nalloc_buffer(this.address());
    }

    public int alloc_buffer_length_in_bytes() {
        return STBVorbisAlloc.nalloc_buffer_length_in_bytes(this.address());
    }

    public STBVorbisAlloc alloc_buffer(@NativeType(value="char *") ByteBuffer byteBuffer) {
        STBVorbisAlloc.nalloc_buffer(this.address(), byteBuffer);
        return this;
    }

    public STBVorbisAlloc set(STBVorbisAlloc sTBVorbisAlloc) {
        MemoryUtil.memCopy(sTBVorbisAlloc.address(), this.address(), SIZEOF);
        return this;
    }

    public static STBVorbisAlloc malloc() {
        return STBVorbisAlloc.wrap(STBVorbisAlloc.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static STBVorbisAlloc calloc() {
        return STBVorbisAlloc.wrap(STBVorbisAlloc.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static STBVorbisAlloc create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return STBVorbisAlloc.wrap(STBVorbisAlloc.class, MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static STBVorbisAlloc create(long l2) {
        return STBVorbisAlloc.wrap(STBVorbisAlloc.class, l2);
    }

    public static STBVorbisAlloc createSafe(long l2) {
        return l2 == 0L ? null : STBVorbisAlloc.wrap(STBVorbisAlloc.class, l2);
    }

    public static STBVorbisAlloc$Buffer malloc(int n2) {
        return STBVorbisAlloc.wrap(STBVorbisAlloc$Buffer.class, MemoryUtil.nmemAllocChecked(STBVorbisAlloc.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static STBVorbisAlloc$Buffer calloc(int n2) {
        return STBVorbisAlloc.wrap(STBVorbisAlloc$Buffer.class, MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static STBVorbisAlloc$Buffer create(int n2) {
        ByteBuffer byteBuffer = STBVorbisAlloc.__create(n2, SIZEOF);
        return STBVorbisAlloc.wrap(STBVorbisAlloc$Buffer.class, MemoryUtil.memAddress(byteBuffer), n2, byteBuffer);
    }

    public static STBVorbisAlloc$Buffer create(long l2, int n2) {
        return STBVorbisAlloc.wrap(STBVorbisAlloc$Buffer.class, l2, n2);
    }

    public static STBVorbisAlloc$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : STBVorbisAlloc.wrap(STBVorbisAlloc$Buffer.class, l2, n2);
    }

    public static STBVorbisAlloc mallocStack() {
        return STBVorbisAlloc.mallocStack(MemoryStack.stackGet());
    }

    public static STBVorbisAlloc callocStack() {
        return STBVorbisAlloc.callocStack(MemoryStack.stackGet());
    }

    public static STBVorbisAlloc mallocStack(MemoryStack memoryStack) {
        return STBVorbisAlloc.wrap(STBVorbisAlloc.class, memoryStack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static STBVorbisAlloc callocStack(MemoryStack memoryStack) {
        return STBVorbisAlloc.wrap(STBVorbisAlloc.class, memoryStack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static STBVorbisAlloc$Buffer mallocStack(int n2) {
        return STBVorbisAlloc.mallocStack(n2, MemoryStack.stackGet());
    }

    public static STBVorbisAlloc$Buffer callocStack(int n2) {
        return STBVorbisAlloc.callocStack(n2, MemoryStack.stackGet());
    }

    public static STBVorbisAlloc$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return STBVorbisAlloc.wrap(STBVorbisAlloc$Buffer.class, memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static STBVorbisAlloc$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return STBVorbisAlloc.wrap(STBVorbisAlloc$Buffer.class, memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static ByteBuffer nalloc_buffer(long l2) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(l2 + (long)ALLOC_BUFFER), STBVorbisAlloc.nalloc_buffer_length_in_bytes(l2));
    }

    public static int nalloc_buffer_length_in_bytes(long l2) {
        return UNSAFE.getInt(null, l2 + (long)ALLOC_BUFFER_LENGTH_IN_BYTES);
    }

    public static void nalloc_buffer(long l2, ByteBuffer byteBuffer) {
        MemoryUtil.memPutAddress(l2 + (long)ALLOC_BUFFER, MemoryUtil.memAddress(byteBuffer));
        STBVorbisAlloc.nalloc_buffer_length_in_bytes(l2, byteBuffer.remaining());
    }

    public static void nalloc_buffer_length_in_bytes(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)ALLOC_BUFFER_LENGTH_IN_BYTES, n2);
    }

    public static void validate(long l2) {
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)ALLOC_BUFFER));
    }

    public static void validate(long l2, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            STBVorbisAlloc.validate(l2 + Integer.toUnsignedLong(i2) * (long)SIZEOF);
        }
    }

    static {
        Struct$Layout struct$Layout = STBVorbisAlloc.__struct(STBVorbisAlloc.__member(POINTER_SIZE), STBVorbisAlloc.__member(4));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        ALLOC_BUFFER = struct$Layout.offsetof(0);
        ALLOC_BUFFER_LENGTH_IN_BYTES = struct$Layout.offsetof(1);
    }
}

