/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.stb.STBTTBitmap$Buffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;

@NativeType(value="struct stbtt__bitmap")
public class STBTTBitmap
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int W;
    public static final int H;
    public static final int STRIDE;
    public static final int PIXELS;

    public STBTTBitmap(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), STBTTBitmap.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int w() {
        return STBTTBitmap.nw(this.address());
    }

    public int h() {
        return STBTTBitmap.nh(this.address());
    }

    public int stride() {
        return STBTTBitmap.nstride(this.address());
    }

    @NativeType(value="unsigned char *")
    public ByteBuffer pixels(int n2) {
        return STBTTBitmap.npixels(this.address(), n2);
    }

    public STBTTBitmap w(int n2) {
        STBTTBitmap.nw(this.address(), n2);
        return this;
    }

    public STBTTBitmap h(int n2) {
        STBTTBitmap.nh(this.address(), n2);
        return this;
    }

    public STBTTBitmap stride(int n2) {
        STBTTBitmap.nstride(this.address(), n2);
        return this;
    }

    public STBTTBitmap pixels(@NativeType(value="unsigned char *") ByteBuffer byteBuffer) {
        STBTTBitmap.npixels(this.address(), byteBuffer);
        return this;
    }

    public STBTTBitmap set(int n2, int n3, int n4, ByteBuffer byteBuffer) {
        this.w(n2);
        this.h(n3);
        this.stride(n4);
        this.pixels(byteBuffer);
        return this;
    }

    public STBTTBitmap set(STBTTBitmap sTBTTBitmap) {
        MemoryUtil.memCopy(sTBTTBitmap.address(), this.address(), SIZEOF);
        return this;
    }

    public static STBTTBitmap malloc() {
        return STBTTBitmap.wrap(STBTTBitmap.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static STBTTBitmap calloc() {
        return STBTTBitmap.wrap(STBTTBitmap.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static STBTTBitmap create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return STBTTBitmap.wrap(STBTTBitmap.class, MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static STBTTBitmap create(long l2) {
        return STBTTBitmap.wrap(STBTTBitmap.class, l2);
    }

    public static STBTTBitmap createSafe(long l2) {
        return l2 == 0L ? null : STBTTBitmap.wrap(STBTTBitmap.class, l2);
    }

    public static STBTTBitmap$Buffer malloc(int n2) {
        return STBTTBitmap.wrap(STBTTBitmap$Buffer.class, MemoryUtil.nmemAllocChecked(STBTTBitmap.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static STBTTBitmap$Buffer calloc(int n2) {
        return STBTTBitmap.wrap(STBTTBitmap$Buffer.class, MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static STBTTBitmap$Buffer create(int n2) {
        ByteBuffer byteBuffer = STBTTBitmap.__create(n2, SIZEOF);
        return STBTTBitmap.wrap(STBTTBitmap$Buffer.class, MemoryUtil.memAddress(byteBuffer), n2, byteBuffer);
    }

    public static STBTTBitmap$Buffer create(long l2, int n2) {
        return STBTTBitmap.wrap(STBTTBitmap$Buffer.class, l2, n2);
    }

    public static STBTTBitmap$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : STBTTBitmap.wrap(STBTTBitmap$Buffer.class, l2, n2);
    }

    public static STBTTBitmap mallocStack() {
        return STBTTBitmap.mallocStack(MemoryStack.stackGet());
    }

    public static STBTTBitmap callocStack() {
        return STBTTBitmap.callocStack(MemoryStack.stackGet());
    }

    public static STBTTBitmap mallocStack(MemoryStack memoryStack) {
        return STBTTBitmap.wrap(STBTTBitmap.class, memoryStack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static STBTTBitmap callocStack(MemoryStack memoryStack) {
        return STBTTBitmap.wrap(STBTTBitmap.class, memoryStack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static STBTTBitmap$Buffer mallocStack(int n2) {
        return STBTTBitmap.mallocStack(n2, MemoryStack.stackGet());
    }

    public static STBTTBitmap$Buffer callocStack(int n2) {
        return STBTTBitmap.callocStack(n2, MemoryStack.stackGet());
    }

    public static STBTTBitmap$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return STBTTBitmap.wrap(STBTTBitmap$Buffer.class, memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static STBTTBitmap$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return STBTTBitmap.wrap(STBTTBitmap$Buffer.class, memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int nw(long l2) {
        return UNSAFE.getInt(null, l2 + (long)W);
    }

    public static int nh(long l2) {
        return UNSAFE.getInt(null, l2 + (long)H);
    }

    public static int nstride(long l2) {
        return UNSAFE.getInt(null, l2 + (long)STRIDE);
    }

    public static ByteBuffer npixels(long l2, int n2) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(l2 + (long)PIXELS), n2);
    }

    public static void nw(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)W, n2);
    }

    public static void nh(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)H, n2);
    }

    public static void nstride(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)STRIDE, n2);
    }

    public static void npixels(long l2, ByteBuffer byteBuffer) {
        MemoryUtil.memPutAddress(l2 + (long)PIXELS, MemoryUtil.memAddress(byteBuffer));
    }

    public static void validate(long l2) {
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)PIXELS));
    }

    public static void validate(long l2, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            STBTTBitmap.validate(l2 + Integer.toUnsignedLong(i2) * (long)SIZEOF);
        }
    }

    static {
        Struct$Layout struct$Layout = STBTTBitmap.__struct(STBTTBitmap.__member(4), STBTTBitmap.__member(4), STBTTBitmap.__member(4), STBTTBitmap.__member(POINTER_SIZE));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        W = struct$Layout.offsetof(0);
        H = struct$Layout.offsetof(1);
        STRIDE = struct$Layout.offsetof(2);
        PIXELS = struct$Layout.offsetof(3);
    }
}

