/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.stb.STBRPNode$Buffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;

@NativeType(value="struct stbrp_node")
public class STBRPNode
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int NEXT;

    public STBRPNode(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), STBRPNode.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="stbrp_coord")
    public short x() {
        return STBRPNode.nx(this.address());
    }

    @NativeType(value="stbrp_coord")
    public short y() {
        return STBRPNode.ny(this.address());
    }

    @NativeType(value="stbrp_node *")
    public STBRPNode next() {
        return STBRPNode.nnext(this.address());
    }

    public static STBRPNode malloc() {
        return STBRPNode.wrap(STBRPNode.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static STBRPNode calloc() {
        return STBRPNode.wrap(STBRPNode.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static STBRPNode create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return STBRPNode.wrap(STBRPNode.class, MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static STBRPNode create(long l2) {
        return STBRPNode.wrap(STBRPNode.class, l2);
    }

    public static STBRPNode createSafe(long l2) {
        return l2 == 0L ? null : STBRPNode.wrap(STBRPNode.class, l2);
    }

    public static STBRPNode$Buffer malloc(int n2) {
        return STBRPNode.wrap(STBRPNode$Buffer.class, MemoryUtil.nmemAllocChecked(STBRPNode.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static STBRPNode$Buffer calloc(int n2) {
        return STBRPNode.wrap(STBRPNode$Buffer.class, MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static STBRPNode$Buffer create(int n2) {
        ByteBuffer byteBuffer = STBRPNode.__create(n2, SIZEOF);
        return STBRPNode.wrap(STBRPNode$Buffer.class, MemoryUtil.memAddress(byteBuffer), n2, byteBuffer);
    }

    public static STBRPNode$Buffer create(long l2, int n2) {
        return STBRPNode.wrap(STBRPNode$Buffer.class, l2, n2);
    }

    public static STBRPNode$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : STBRPNode.wrap(STBRPNode$Buffer.class, l2, n2);
    }

    public static STBRPNode mallocStack() {
        return STBRPNode.mallocStack(MemoryStack.stackGet());
    }

    public static STBRPNode callocStack() {
        return STBRPNode.callocStack(MemoryStack.stackGet());
    }

    public static STBRPNode mallocStack(MemoryStack memoryStack) {
        return STBRPNode.wrap(STBRPNode.class, memoryStack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static STBRPNode callocStack(MemoryStack memoryStack) {
        return STBRPNode.wrap(STBRPNode.class, memoryStack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static STBRPNode$Buffer mallocStack(int n2) {
        return STBRPNode.mallocStack(n2, MemoryStack.stackGet());
    }

    public static STBRPNode$Buffer callocStack(int n2) {
        return STBRPNode.callocStack(n2, MemoryStack.stackGet());
    }

    public static STBRPNode$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return STBRPNode.wrap(STBRPNode$Buffer.class, memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static STBRPNode$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return STBRPNode.wrap(STBRPNode$Buffer.class, memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static short nx(long l2) {
        return UNSAFE.getShort(null, l2 + (long)X);
    }

    public static short ny(long l2) {
        return UNSAFE.getShort(null, l2 + (long)Y);
    }

    public static STBRPNode nnext(long l2) {
        return STBRPNode.createSafe(MemoryUtil.memGetAddress(l2 + (long)NEXT));
    }

    static {
        Struct$Layout struct$Layout = STBRPNode.__struct(STBRPNode.__member(2), STBRPNode.__member(2), STBRPNode.__member(POINTER_SIZE));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        X = struct$Layout.offsetof(0);
        Y = struct$Layout.offsetof(1);
        NEXT = struct$Layout.offsetof(2);
    }
}

