/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GPU_DEVICE$Buffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.windows.RECT;

public class GPU_DEVICE
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CB;
    public static final int DEVICENAME;
    public static final int DEVICESTRING;
    public static final int FLAGS;
    public static final int RCVIRTUALSCREEN;

    public GPU_DEVICE(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), GPU_DEVICE.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="DWORD")
    public int cb() {
        return GPU_DEVICE.ncb(this.address());
    }

    @NativeType(value="CHAR[32]")
    public ByteBuffer DeviceName() {
        return GPU_DEVICE.nDeviceName(this.address());
    }

    @NativeType(value="CHAR[32]")
    public String DeviceNameString() {
        return GPU_DEVICE.nDeviceNameString(this.address());
    }

    @NativeType(value="CHAR[128]")
    public ByteBuffer DeviceString() {
        return GPU_DEVICE.nDeviceString(this.address());
    }

    @NativeType(value="CHAR[128]")
    public String DeviceStringString() {
        return GPU_DEVICE.nDeviceStringString(this.address());
    }

    @NativeType(value="DWORD")
    public int Flags() {
        return GPU_DEVICE.nFlags(this.address());
    }

    public RECT rcVirtualScreen() {
        return GPU_DEVICE.nrcVirtualScreen(this.address());
    }

    public GPU_DEVICE rcVirtualScreen(Consumer<RECT> consumer) {
        consumer.accept(this.rcVirtualScreen());
        return this;
    }

    public static GPU_DEVICE malloc() {
        return GPU_DEVICE.wrap(GPU_DEVICE.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static GPU_DEVICE calloc() {
        return GPU_DEVICE.wrap(GPU_DEVICE.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static GPU_DEVICE create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return GPU_DEVICE.wrap(GPU_DEVICE.class, MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static GPU_DEVICE create(long l2) {
        return GPU_DEVICE.wrap(GPU_DEVICE.class, l2);
    }

    public static GPU_DEVICE createSafe(long l2) {
        return l2 == 0L ? null : GPU_DEVICE.wrap(GPU_DEVICE.class, l2);
    }

    public static GPU_DEVICE$Buffer malloc(int n2) {
        return GPU_DEVICE.wrap(GPU_DEVICE$Buffer.class, MemoryUtil.nmemAllocChecked(GPU_DEVICE.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static GPU_DEVICE$Buffer calloc(int n2) {
        return GPU_DEVICE.wrap(GPU_DEVICE$Buffer.class, MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static GPU_DEVICE$Buffer create(int n2) {
        ByteBuffer byteBuffer = GPU_DEVICE.__create(n2, SIZEOF);
        return GPU_DEVICE.wrap(GPU_DEVICE$Buffer.class, MemoryUtil.memAddress(byteBuffer), n2, byteBuffer);
    }

    public static GPU_DEVICE$Buffer create(long l2, int n2) {
        return GPU_DEVICE.wrap(GPU_DEVICE$Buffer.class, l2, n2);
    }

    public static GPU_DEVICE$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : GPU_DEVICE.wrap(GPU_DEVICE$Buffer.class, l2, n2);
    }

    public static GPU_DEVICE mallocStack() {
        return GPU_DEVICE.mallocStack(MemoryStack.stackGet());
    }

    public static GPU_DEVICE callocStack() {
        return GPU_DEVICE.callocStack(MemoryStack.stackGet());
    }

    public static GPU_DEVICE mallocStack(MemoryStack memoryStack) {
        return GPU_DEVICE.wrap(GPU_DEVICE.class, memoryStack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static GPU_DEVICE callocStack(MemoryStack memoryStack) {
        return GPU_DEVICE.wrap(GPU_DEVICE.class, memoryStack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static GPU_DEVICE$Buffer mallocStack(int n2) {
        return GPU_DEVICE.mallocStack(n2, MemoryStack.stackGet());
    }

    public static GPU_DEVICE$Buffer callocStack(int n2) {
        return GPU_DEVICE.callocStack(n2, MemoryStack.stackGet());
    }

    public static GPU_DEVICE$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return GPU_DEVICE.wrap(GPU_DEVICE$Buffer.class, memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static GPU_DEVICE$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return GPU_DEVICE.wrap(GPU_DEVICE$Buffer.class, memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int ncb(long l2) {
        return UNSAFE.getInt(null, l2 + (long)CB);
    }

    public static ByteBuffer nDeviceName(long l2) {
        return MemoryUtil.memByteBuffer(l2 + (long)DEVICENAME, 32);
    }

    public static String nDeviceNameString(long l2) {
        return MemoryUtil.memASCII(l2 + (long)DEVICENAME);
    }

    public static ByteBuffer nDeviceString(long l2) {
        return MemoryUtil.memByteBuffer(l2 + (long)DEVICESTRING, 128);
    }

    public static String nDeviceStringString(long l2) {
        return MemoryUtil.memASCII(l2 + (long)DEVICESTRING);
    }

    public static int nFlags(long l2) {
        return UNSAFE.getInt(null, l2 + (long)FLAGS);
    }

    public static RECT nrcVirtualScreen(long l2) {
        return RECT.create(l2 + (long)RCVIRTUALSCREEN);
    }

    static {
        Struct$Layout struct$Layout = GPU_DEVICE.__struct(GPU_DEVICE.__member(4), GPU_DEVICE.__array(1, 32), GPU_DEVICE.__array(1, 128), GPU_DEVICE.__member(4), GPU_DEVICE.__member(RECT.SIZEOF, RECT.ALIGNOF));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        CB = struct$Layout.offsetof(0);
        DEVICENAME = struct$Layout.offsetof(1);
        DEVICESTRING = struct$Layout.offsetof(2);
        FLAGS = struct$Layout.offsetof(3);
        RCVIRTUALSCREEN = struct$Layout.offsetof(4);
    }
}

