/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.io.Serializable;
import java.nio.IntBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.ALC$SharedLibraryAL;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.FunctionProviderLocal;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Platform;
import org.lwjgl.system.SharedLibrary;

public final class ALC {
    private static FunctionProviderLocal functionProvider;
    private static ALCCapabilities icd;

    private ALC() {
    }

    public static void create() {
        String string;
        switch (Platform.get()) {
            case LINUX: 
            case MACOSX: {
                string = "openal";
                break;
            }
            case WINDOWS: {
                string = "OpenAL";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        ALC.create(Configuration.OPENAL_LIBRARY_NAME.get(Platform.mapLibraryNameBundled(string)));
    }

    public static void create(String string) {
        SharedLibrary sharedLibrary = Library.loadNative(ALC.class, string, true);
        try {
            ALC.create(new ALC$SharedLibraryAL(sharedLibrary));
        }
        catch (RuntimeException runtimeException) {
            sharedLibrary.free();
            throw runtimeException;
        }
    }

    public static void create(FunctionProviderLocal functionProviderLocal) {
        if (functionProvider != null) {
            throw new IllegalStateException("ALC has already been created.");
        }
        functionProvider = functionProviderLocal;
        icd = new ALCCapabilities(functionProviderLocal, 0L, Collections.emptySet());
        AL.init();
    }

    public static void destroy() {
        if (functionProvider == null) {
            return;
        }
        AL.destroy();
        icd = null;
        if (functionProvider instanceof NativeResource) {
            ((NativeResource)((Object)functionProvider)).free();
        }
        functionProvider = null;
    }

    static <T> T check(T t2) {
        if (t2 == null) {
            throw new IllegalStateException("OpenAL library has not been loaded.");
        }
        return t2;
    }

    public static FunctionProviderLocal getFunctionProvider() {
        return ALC.check(functionProvider);
    }

    static ALCCapabilities getICD() {
        return ALC.check(icd);
    }

    public static ALCCapabilities createCapabilities(long l2) {
        String string;
        int n2;
        int n3;
        FunctionProviderLocal functionProviderLocal = ALC.getFunctionProvider();
        long l3 = functionProviderLocal.getFunctionAddress("alcGetIntegerv");
        long l4 = functionProviderLocal.getFunctionAddress("alcGetString");
        long l5 = functionProviderLocal.getFunctionAddress("alcIsExtensionPresent");
        if (l3 == 0L || l4 == 0L || l5 == 0L) {
            throw new IllegalStateException("Core ALC functions could not be found. Make sure that OpenAL has been loaded.");
        }
        Serializable serializable = null;
        try (Object object = MemoryStack.stackPush();){
            IntBuffer intBuffer = ((MemoryStack)object).mallocInt(1);
            JNI.invokePPV(l2, 4096, 1, MemoryUtil.memAddress(intBuffer), l3);
            n3 = intBuffer.get(0);
            JNI.invokePPV(l2, 4097, 1, MemoryUtil.memAddress(intBuffer), l3);
            n2 = intBuffer.get(0);
        }
        catch (Throwable throwable) {
            serializable = throwable;
            throw throwable;
        }
        object = new int[][]{{0, 1}};
        serializable = new HashSet(16);
        for (int i2 = 1; i2 <= ((Object)object).length; ++i2) {
            for (Object object : string = object[i2 - 1]) {
                if (i2 >= n3 && (i2 != n3 || object > n2)) continue;
                serializable.add("OpenALC" + i2 + (int)object);
            }
        }
        String string2 = MemoryUtil.memASCIISafe(JNI.invokePP(l2, 4102, l4));
        if (string2 != null) {
            string = new StringTokenizer(string2);
            while (((StringTokenizer)((Object)string)).hasMoreTokens()) {
                String string3 = ((StringTokenizer)((Object)string)).nextToken();
                try (MemoryStack memoryStack = MemoryStack.stackPush();){
                    if (!JNI.invokePPZ(l2, MemoryUtil.memAddress(memoryStack.ASCII(string3, true)), l5)) continue;
                    serializable.add(string3);
                }
            }
        }
        return new ALCCapabilities(functionProviderLocal, l2, (Set<String>)((Object)serializable));
    }

    static {
        if (!Configuration.OPENAL_EXPLICIT_INIT.get(false).booleanValue()) {
            ALC.create();
        }
    }
}

