/*
 * Decompiled with CFR 0.152.
 */
package org.joml.sampling;

import org.joml.Random;
import org.joml.sampling.Callback2d;

public class StratifiedSampling {
    private final Random rnd;

    public StratifiedSampling(long l2) {
        this.rnd = new Random(l2);
    }

    public void generateRandom(int n2, Callback2d callback2d) {
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                float f2 = (this.rnd.nextFloat() / (float)n2 + (float)i3 / (float)n2) * 2.0f - 1.0f;
                float f3 = (this.rnd.nextFloat() / (float)n2 + (float)i2 / (float)n2) * 2.0f - 1.0f;
                callback2d.onNewSample(f2, f3);
            }
        }
    }

    public void generateCentered(int n2, float f2, Callback2d callback2d) {
        float f3 = f2 * 0.5f;
        float f4 = 1.0f - f2;
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                float f5 = ((f3 + this.rnd.nextFloat() * f4) / (float)n2 + (float)i3 / (float)n2) * 2.0f - 1.0f;
                float f6 = ((f3 + this.rnd.nextFloat() * f4) / (float)n2 + (float)i2 / (float)n2) * 2.0f - 1.0f;
                callback2d.onNewSample(f5, f6);
            }
        }
    }
}

