/*
 * Decompiled with CFR 0.152.
 */
package org.joml.sampling;

import java.util.ArrayList;
import org.joml.Random;
import org.joml.Vector2f;
import org.joml.sampling.Callback2d;
import org.joml.sampling.Math;

public class PoissonSampling$Disk {
    private final Vector2f[] grid;
    private final float diskRadius;
    private final float diskRadiusSquared;
    private final float minDist;
    private final float minDistSquared;
    private final float cellSize;
    private final int numCells;
    private final Random rnd;
    private final ArrayList processList;

    public PoissonSampling$Disk(long l2, float f2, float f3, int n2, Callback2d callback2d) {
        this.diskRadius = f2;
        this.diskRadiusSquared = f2 * f2;
        this.minDist = f3;
        this.minDistSquared = f3 * f3;
        this.rnd = new Random(l2);
        this.cellSize = f3 / (float)Math.sqrt(2.0);
        this.numCells = (int)(f2 * 2.0f / this.cellSize) + 1;
        this.grid = new Vector2f[this.numCells * this.numCells];
        this.processList = new ArrayList();
        this.compute(n2, callback2d);
    }

    private void compute(int n2, Callback2d callback2d) {
        float f2;
        float f3;
        while ((f3 = this.rnd.nextFloat() * 2.0f - 1.0f) * f3 + (f2 = this.rnd.nextFloat() * 2.0f - 1.0f) * f2 > 1.0f) {
        }
        Vector2f vector2f = new Vector2f(f3, f2);
        this.processList.add(vector2f);
        callback2d.onNewSample(vector2f.x, vector2f.y);
        this.insert(vector2f);
        while (!this.processList.isEmpty()) {
            int n3 = this.rnd.nextInt(this.processList.size());
            Vector2f vector2f2 = (Vector2f)this.processList.get(n3);
            boolean bl2 = false;
            for (int i2 = 0; i2 < n2; ++i2) {
                float f4 = this.rnd.nextFloat() * ((float)java.lang.Math.PI * 2);
                float f5 = this.minDist * (this.rnd.nextFloat() + 1.0f);
                f3 = (float)((double)f5 * Math.sin_roquen_9((double)f4 + 1.5707963267948966));
                f2 = (float)((double)f5 * Math.sin_roquen_9(f4));
                if ((f3 += vector2f2.x) * f3 + (f2 += vector2f2.y) * f2 > this.diskRadiusSquared || this.searchNeighbors(f3, f2)) continue;
                bl2 = true;
                callback2d.onNewSample(f3, f2);
                Vector2f vector2f3 = new Vector2f(f3, f2);
                this.processList.add(vector2f3);
                this.insert(vector2f3);
                break;
            }
            if (bl2) continue;
            this.processList.remove(n3);
        }
    }

    private boolean searchNeighbors(float f2, float f3) {
        int n2 = (int)((f3 + this.diskRadius) / this.cellSize);
        int n3 = (int)((f2 + this.diskRadius) / this.cellSize);
        if (this.grid[n2 * this.numCells + n3] != null) {
            return true;
        }
        int n4 = Math.max(0, n3 - 1);
        int n5 = Math.max(0, n2 - 1);
        int n6 = Math.min(n3 + 1, this.numCells - 1);
        int n7 = Math.min(n2 + 1, this.numCells - 1);
        for (int i2 = n5; i2 <= n7; ++i2) {
            for (int i3 = n4; i3 <= n6; ++i3) {
                float f4;
                float f5;
                Vector2f vector2f = this.grid[i2 * this.numCells + i3];
                if (vector2f == null || !((f5 = vector2f.x - f2) * f5 + (f4 = vector2f.y - f3) * f4 < this.minDistSquared)) continue;
                return true;
            }
        }
        return false;
    }

    private void insert(Vector2f vector2f) {
        int n2 = (int)((vector2f.y + this.diskRadius) / this.cellSize);
        int n3 = (int)((vector2f.x + this.diskRadius) / this.cellSize);
        this.grid[n2 * this.numCells + n3] = vector2f;
    }
}

