/*
 * Decompiled with CFR 0.152.
 */
package org.joml.sampling;

import java.nio.FloatBuffer;
import org.joml.Random;
import org.joml.Vector3f;
import org.joml.sampling.BestCandidateSampling$IntHolder;
import org.joml.sampling.BestCandidateSampling$Sphere$1;
import org.joml.sampling.BestCandidateSampling$Sphere$2;
import org.joml.sampling.BestCandidateSampling$Sphere$Node;
import org.joml.sampling.Callback3d;
import org.joml.sampling.Math;

public class BestCandidateSampling$Sphere {
    private boolean onHemisphere;
    private int numSamples;
    private int numCandidates = 60;
    private long seed;

    public BestCandidateSampling$Sphere generate(float[] fArray) {
        BestCandidateSampling$IntHolder bestCandidateSampling$IntHolder = new BestCandidateSampling$IntHolder(null);
        return this.generate(new BestCandidateSampling$Sphere$1(this, fArray, bestCandidateSampling$IntHolder));
    }

    public BestCandidateSampling$Sphere generate(FloatBuffer floatBuffer) {
        BestCandidateSampling$IntHolder bestCandidateSampling$IntHolder = new BestCandidateSampling$IntHolder(null);
        int n2 = floatBuffer.position();
        return this.generate(new BestCandidateSampling$Sphere$2(this, floatBuffer, n2, bestCandidateSampling$IntHolder));
    }

    public BestCandidateSampling$Sphere seed(long l2) {
        this.seed = l2;
        return this;
    }

    public BestCandidateSampling$Sphere numSamples(int n2) {
        this.numSamples = n2;
        return this;
    }

    public BestCandidateSampling$Sphere numCandidates(int n2) {
        this.numCandidates = n2;
        return this;
    }

    public BestCandidateSampling$Sphere onHemisphere(boolean bl2) {
        this.onHemisphere = bl2;
        return this;
    }

    public BestCandidateSampling$Sphere generate(Callback3d callback3d) {
        Random random = new Random(this.seed);
        BestCandidateSampling$Sphere$Node bestCandidateSampling$Sphere$Node = new BestCandidateSampling$Sphere$Node();
        for (int i2 = 0; i2 < this.numSamples; ++i2) {
            float f2 = Float.NaN;
            float f3 = Float.NaN;
            float f4 = Float.NaN;
            float f5 = 0.0f;
            for (int i3 = 0; i3 < this.numCandidates; ++i3) {
                float f6;
                float f7;
                float f8;
                while ((f8 = random.nextFloat() * 2.0f - 1.0f) * f8 + (f7 = random.nextFloat() * 2.0f - 1.0f) * f7 > 1.0f) {
                }
                float f9 = (float)Math.sqrt(1.0 - (double)(f8 * f8) - (double)(f7 * f7));
                float f10 = 2.0f * f8 * f9;
                float f11 = 2.0f * f7 * f9;
                float f12 = 1.0f - 2.0f * (f8 * f8 + f7 * f7);
                if (this.onHemisphere) {
                    f12 = Math.abs(f12);
                }
                if (!((f6 = bestCandidateSampling$Sphere$Node.nearest(f10, f11, f12)) > f5)) continue;
                f5 = f6;
                f2 = f10;
                f3 = f11;
                f4 = f12;
            }
            callback3d.onNewSample(f2, f3, f4);
            bestCandidateSampling$Sphere$Node.insert(new Vector3f(f2, f3, f4));
        }
        return this;
    }
}

