/*
 * Decompiled with CFR 0.152.
 */
package org.joml.sampling;

import java.util.ArrayList;
import org.joml.Vector3f;
import org.joml.sampling.Math;

final class BestCandidateSampling$Sphere$Node {
    private static final int MAX_OBJECTS_PER_NODE = 32;
    private float v0x;
    private float v0y;
    private float v0z;
    private float v1x;
    private float v1y;
    private float v1z;
    private float v2x;
    private float v2y;
    private float v2z;
    private float cx;
    private float cy;
    private float cz;
    private float arc;
    private ArrayList objects;
    private BestCandidateSampling$Sphere$Node[] children;

    BestCandidateSampling$Sphere$Node() {
        this.children = new BestCandidateSampling$Sphere$Node[8];
        float f2 = 1.0f;
        this.arc = (float)java.lang.Math.PI * 2;
        this.children[0] = new BestCandidateSampling$Sphere$Node(-f2, 0.0f, 0.0f, 0.0f, 0.0f, f2, 0.0f, f2, 0.0f);
        this.children[1] = new BestCandidateSampling$Sphere$Node(0.0f, 0.0f, f2, f2, 0.0f, 0.0f, 0.0f, f2, 0.0f);
        this.children[2] = new BestCandidateSampling$Sphere$Node(f2, 0.0f, 0.0f, 0.0f, 0.0f, -f2, 0.0f, f2, 0.0f);
        this.children[3] = new BestCandidateSampling$Sphere$Node(0.0f, 0.0f, -f2, -f2, 0.0f, 0.0f, 0.0f, f2, 0.0f);
        this.children[4] = new BestCandidateSampling$Sphere$Node(-f2, 0.0f, 0.0f, 0.0f, -f2, 0.0f, 0.0f, 0.0f, f2);
        this.children[5] = new BestCandidateSampling$Sphere$Node(0.0f, 0.0f, f2, 0.0f, -f2, 0.0f, f2, 0.0f, 0.0f);
        this.children[6] = new BestCandidateSampling$Sphere$Node(f2, 0.0f, 0.0f, 0.0f, -f2, 0.0f, 0.0f, 0.0f, -f2);
        this.children[7] = new BestCandidateSampling$Sphere$Node(0.0f, 0.0f, -f2, 0.0f, -f2, 0.0f, -f2, 0.0f, 0.0f);
    }

    private BestCandidateSampling$Sphere$Node(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        this.v0x = f2;
        this.v0y = f3;
        this.v0z = f4;
        this.v1x = f5;
        this.v1y = f6;
        this.v1z = f7;
        this.v2x = f8;
        this.v2y = f9;
        this.v2z = f10;
        this.cx = (this.v0x + this.v1x + this.v2x) / 3.0f;
        this.cy = (this.v0y + this.v1y + this.v2y) / 3.0f;
        this.cz = (this.v0z + this.v1z + this.v2z) / 3.0f;
        float f11 = Math.invsqrt(this.cx * this.cx + this.cy * this.cy + this.cz * this.cz);
        this.cx *= f11;
        this.cy *= f11;
        this.cz *= f11;
        float f12 = this.greatCircleDist(this.cx, this.cy, this.cz, this.v0x, this.v0y, this.v0z);
        float f13 = this.greatCircleDist(this.cx, this.cy, this.cz, this.v1x, this.v1y, this.v1z);
        float f14 = this.greatCircleDist(this.cx, this.cy, this.cz, this.v2x, this.v2y, this.v2z);
        float f15 = Math.max(Math.max(f12, f13), f14);
        this.arc = f15 *= 1.7f;
    }

    private void split() {
        float f2 = this.v1x + this.v2x;
        float f3 = this.v1y + this.v2y;
        float f4 = this.v1z + this.v2z;
        float f5 = Math.invsqrt(f2 * f2 + f3 * f3 + f4 * f4);
        f2 *= f5;
        f3 *= f5;
        f4 *= f5;
        float f6 = this.v0x + this.v2x;
        float f7 = this.v0y + this.v2y;
        float f8 = this.v0z + this.v2z;
        float f9 = Math.invsqrt(f6 * f6 + f7 * f7 + f8 * f8);
        f6 *= f9;
        f7 *= f9;
        f8 *= f9;
        float f10 = this.v0x + this.v1x;
        float f11 = this.v0y + this.v1y;
        float f12 = this.v0z + this.v1z;
        float f13 = Math.invsqrt(f10 * f10 + f11 * f11 + f12 * f12);
        this.children = new BestCandidateSampling$Sphere$Node[4];
        this.children[0] = new BestCandidateSampling$Sphere$Node(this.v0x, this.v0y, this.v0z, f10 *= f13, f11 *= f13, f12 *= f13, f6, f7, f8);
        this.children[1] = new BestCandidateSampling$Sphere$Node(this.v1x, this.v1y, this.v1z, f2, f3, f4, f10, f11, f12);
        this.children[2] = new BestCandidateSampling$Sphere$Node(this.v2x, this.v2y, this.v2z, f6, f7, f8, f2, f3, f4);
        this.children[3] = new BestCandidateSampling$Sphere$Node(f2, f3, f4, f6, f7, f8, f10, f11, f12);
    }

    private void insertIntoChild(Vector3f vector3f) {
        for (int i2 = 0; i2 < this.children.length; ++i2) {
            BestCandidateSampling$Sphere$Node bestCandidateSampling$Sphere$Node = this.children[i2];
            if (!BestCandidateSampling$Sphere$Node.isPointOnSphericalTriangle(vector3f.x, vector3f.y, vector3f.z, bestCandidateSampling$Sphere$Node.v0x, bestCandidateSampling$Sphere$Node.v0y, bestCandidateSampling$Sphere$Node.v0z, bestCandidateSampling$Sphere$Node.v1x, bestCandidateSampling$Sphere$Node.v1y, bestCandidateSampling$Sphere$Node.v1z, bestCandidateSampling$Sphere$Node.v2x, bestCandidateSampling$Sphere$Node.v2y, bestCandidateSampling$Sphere$Node.v2z, 1.0E-6f)) continue;
            bestCandidateSampling$Sphere$Node.insert(vector3f);
            return;
        }
    }

    void insert(Vector3f vector3f) {
        if (this.children != null) {
            this.insertIntoChild(vector3f);
            return;
        }
        if (this.objects != null && this.objects.size() == 32) {
            this.split();
            for (int i2 = 0; i2 < 32; ++i2) {
                this.insertIntoChild((Vector3f)this.objects.get(i2));
            }
            this.objects = null;
            this.insertIntoChild(vector3f);
        } else {
            if (this.objects == null) {
                this.objects = new ArrayList(32);
            }
            this.objects.add(vector3f);
        }
    }

    private static boolean isPointOnSphericalTriangle(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14) {
        float f15 = f8 - f5;
        float f16 = f13 - f7;
        float f17 = f12 - f6;
        float f18 = f3 * f16 - f4 * f17;
        float f19 = f9 - f6;
        float f20 = f11 - f5;
        float f21 = f4 * f20 - f2 * f16;
        float f22 = f10 - f7;
        float f23 = f2 * f17 - f3 * f20;
        float f24 = f15 * f18 + f19 * f21 + f22 * f23;
        if (f24 > -f14 && f24 < f14) {
            return false;
        }
        float f25 = -f5;
        float f26 = -f6;
        float f27 = -f7;
        float f28 = 1.0f / f24;
        float f29 = (f25 * f18 + f26 * f21 + f27 * f23) * f28;
        if (f29 < 0.0f || f29 > 1.0f) {
            return false;
        }
        float f30 = f26 * f22 - f27 * f19;
        float f31 = f27 * f15 - f25 * f22;
        float f32 = f25 * f19 - f26 * f15;
        float f33 = (f2 * f30 + f3 * f31 + f4 * f32) * f28;
        if (f33 < 0.0f || f29 + f33 > 1.0f) {
            return false;
        }
        float f34 = (f20 * f30 + f17 * f31 + f16 * f32) * f28;
        return f34 >= f14;
    }

    private int child(float f2, float f3, float f4) {
        for (int i2 = 0; i2 < this.children.length; ++i2) {
            BestCandidateSampling$Sphere$Node bestCandidateSampling$Sphere$Node = this.children[i2];
            if (!BestCandidateSampling$Sphere$Node.isPointOnSphericalTriangle(f2, f3, f4, bestCandidateSampling$Sphere$Node.v0x, bestCandidateSampling$Sphere$Node.v0y, bestCandidateSampling$Sphere$Node.v0z, bestCandidateSampling$Sphere$Node.v1x, bestCandidateSampling$Sphere$Node.v1y, bestCandidateSampling$Sphere$Node.v1z, bestCandidateSampling$Sphere$Node.v2x, bestCandidateSampling$Sphere$Node.v2y, bestCandidateSampling$Sphere$Node.v2z, 1.0E-5f)) continue;
            return i2;
        }
        return 0;
    }

    private float greatCircleDist(float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8 = f2 * f5 + f3 * f6 + f4 * f7;
        return (float)(-1.5707963267948966 * (double)f8 + 1.5707963267948966);
    }

    float nearest(float f2, float f3, float f4) {
        return this.nearest(f2, f3, f4, Float.POSITIVE_INFINITY);
    }

    float nearest(float f2, float f3, float f4, float f5) {
        float f6 = this.greatCircleDist(f2, f3, f4, this.cx, this.cy, this.cz);
        if (f6 - this.arc > f5) {
            return f5;
        }
        float f7 = f5;
        if (this.children != null) {
            int n2 = this.children.length;
            int n3 = n2 - 1;
            int n4 = this.child(f2, f3, f4);
            for (int i2 = 0; i2 < n2; ++i2) {
                float f8 = this.children[n4].nearest(f2, f3, f4, f7);
                f7 = Math.min(f8, f7);
                n4 = n4 + 1 & n3;
            }
            return f7;
        }
        for (int i3 = 0; this.objects != null && i3 < this.objects.size(); ++i3) {
            Vector3f vector3f = (Vector3f)this.objects.get(i3);
            float f9 = this.greatCircleDist(vector3f.x, vector3f.y, vector3f.z, f2, f3, f4);
            if (!(f9 < f7)) continue;
            f7 = f9;
        }
        return f7;
    }
}

