/*
 * Decompiled with CFR 0.152.
 */
package org.joml.sampling;

import java.util.ArrayList;
import org.joml.Vector2f;
import org.joml.sampling.Math;

class BestCandidateSampling$QuadTree {
    private static final int MAX_OBJECTS_PER_NODE = 32;
    private static final int PXNY = 0;
    private static final int NXNY = 1;
    private static final int NXPY = 2;
    private static final int PXPY = 3;
    private float minX;
    private float minY;
    private float hs;
    private ArrayList objects;
    private BestCandidateSampling$QuadTree[] children;

    BestCandidateSampling$QuadTree(float f2, float f3, float f4) {
        this.minX = f2;
        this.minY = f3;
        this.hs = f4 * 0.5f;
    }

    private void split() {
        this.children = new BestCandidateSampling$QuadTree[4];
        this.children[1] = new BestCandidateSampling$QuadTree(this.minX, this.minY, this.hs);
        this.children[0] = new BestCandidateSampling$QuadTree(this.minX + this.hs, this.minY, this.hs);
        this.children[2] = new BestCandidateSampling$QuadTree(this.minX, this.minY + this.hs, this.hs);
        this.children[3] = new BestCandidateSampling$QuadTree(this.minX + this.hs, this.minY + this.hs, this.hs);
    }

    private void insertIntoChild(Vector2f vector2f) {
        this.children[this.quadrant(vector2f.x, vector2f.y)].insert(vector2f);
    }

    void insert(Vector2f vector2f) {
        if (this.children != null) {
            this.insertIntoChild(vector2f);
            return;
        }
        if (this.objects != null && this.objects.size() == 32) {
            this.split();
            for (int i2 = 0; i2 < this.objects.size(); ++i2) {
                this.insertIntoChild((Vector2f)this.objects.get(i2));
            }
            this.objects = null;
            this.insertIntoChild(vector2f);
        } else {
            if (this.objects == null) {
                this.objects = new ArrayList(32);
            }
            this.objects.add(vector2f);
        }
    }

    private int quadrant(float f2, float f3) {
        if (f2 < this.minX + this.hs) {
            if (f3 < this.minY + this.hs) {
                return 1;
            }
            return 2;
        }
        if (f3 < this.minY + this.hs) {
            return 0;
        }
        return 3;
    }

    float nearest(float f2, float f3, float f4, float f5) {
        float f6 = f5;
        if (f2 < this.minX - f5 || f2 > this.minX + this.hs * 2.0f + f5 || f3 < this.minY - f5 || f3 > this.minY + this.hs * 2.0f + f5) {
            return f6;
        }
        if (this.children != null) {
            int n2 = this.quadrant(f2, f3);
            for (int i2 = 0; i2 < 4; ++i2) {
                float f7 = this.children[n2].nearest(f2, f3, f4, f6);
                if ((f6 = Math.min(f7, f6)) <= f4) {
                    return f4;
                }
                n2 = n2 + 1 & 3;
            }
            return f6;
        }
        float f8 = f6 * f6;
        float f9 = f4 * f4;
        for (int i3 = 0; this.objects != null && i3 < this.objects.size(); ++i3) {
            Vector2f vector2f = (Vector2f)this.objects.get(i3);
            float f10 = vector2f.distanceSquared(f2, f3);
            if (f10 <= f9) {
                return f4;
            }
            if (!(f10 < f8)) continue;
            f8 = f10;
        }
        return Math.sqrt(f8);
    }
}

