/*
 * Decompiled with CFR 0.152.
 */
package org.joml.sampling;

import java.util.ArrayList;
import org.joml.Vector3f;
import org.joml.sampling.Math;

class BestCandidateSampling$Octree {
    private static final int MAX_OBJECTS_PER_NODE = 32;
    private static final int PXNYNZ = 0;
    private static final int NXNYNZ = 1;
    private static final int NXPYNZ = 2;
    private static final int PXPYNZ = 3;
    private static final int PXNYPZ = 4;
    private static final int NXNYPZ = 5;
    private static final int NXPYPZ = 6;
    private static final int PXPYPZ = 7;
    private float minX;
    private float minY;
    private float minZ;
    private float hs;
    private ArrayList objects;
    private BestCandidateSampling$Octree[] children;

    BestCandidateSampling$Octree(float f2, float f3, float f4, float f5) {
        this.minX = f2;
        this.minY = f3;
        this.minZ = f4;
        this.hs = f5 * 0.5f;
    }

    private void split() {
        this.children = new BestCandidateSampling$Octree[8];
        this.children[1] = new BestCandidateSampling$Octree(this.minX, this.minY, this.minZ, this.hs);
        this.children[0] = new BestCandidateSampling$Octree(this.minX + this.hs, this.minY, this.minZ, this.hs);
        this.children[2] = new BestCandidateSampling$Octree(this.minX, this.minY + this.hs, this.minZ, this.hs);
        this.children[3] = new BestCandidateSampling$Octree(this.minX + this.hs, this.minY + this.hs, this.minZ, this.hs);
        this.children[5] = new BestCandidateSampling$Octree(this.minX, this.minY, this.minZ + this.hs, this.hs);
        this.children[4] = new BestCandidateSampling$Octree(this.minX + this.hs, this.minY, this.minZ + this.hs, this.hs);
        this.children[6] = new BestCandidateSampling$Octree(this.minX, this.minY + this.hs, this.minZ + this.hs, this.hs);
        this.children[7] = new BestCandidateSampling$Octree(this.minX + this.hs, this.minY + this.hs, this.minZ + this.hs, this.hs);
    }

    private void insertIntoChild(Vector3f vector3f) {
        this.children[this.octant(vector3f.x, vector3f.y, vector3f.z)].insert(vector3f);
    }

    void insert(Vector3f vector3f) {
        if (this.children != null) {
            this.insertIntoChild(vector3f);
            return;
        }
        if (this.objects != null && this.objects.size() == 32) {
            this.split();
            for (int i2 = 0; i2 < this.objects.size(); ++i2) {
                this.insertIntoChild((Vector3f)this.objects.get(i2));
            }
            this.objects = null;
            this.insertIntoChild(vector3f);
        } else {
            if (this.objects == null) {
                this.objects = new ArrayList(32);
            }
            this.objects.add(vector3f);
        }
    }

    private int octant(float f2, float f3, float f4) {
        if (f2 < this.minX + this.hs) {
            if (f3 < this.minY + this.hs) {
                if (f4 < this.minZ + this.hs) {
                    return 1;
                }
                return 5;
            }
            if (f4 < this.minZ + this.hs) {
                return 2;
            }
            return 6;
        }
        if (f3 < this.minY + this.hs) {
            if (f4 < this.minZ + this.hs) {
                return 0;
            }
            return 4;
        }
        if (f4 < this.minZ + this.hs) {
            return 3;
        }
        return 7;
    }

    float nearest(float f2, float f3, float f4, float f5, float f6) {
        float f7 = f6;
        if (f2 < this.minX - f6 || f2 > this.minX + this.hs * 2.0f + f6 || f3 < this.minY - f6 || f3 > this.minY + this.hs * 2.0f + f6 || f4 < this.minZ - f6 || f4 > this.minZ + this.hs * 2.0f + f6) {
            return f7;
        }
        if (this.children != null) {
            int n2 = this.octant(f2, f3, f4);
            for (int i2 = 0; i2 < 8; ++i2) {
                float f8 = this.children[n2].nearest(f2, f3, f4, f5, f7);
                if ((f7 = Math.min(f8, f7)) <= f5) {
                    return f5;
                }
                n2 = n2 + 1 & 7;
            }
            return f7;
        }
        float f9 = f7 * f7;
        float f10 = f5 * f5;
        for (int i3 = 0; this.objects != null && i3 < this.objects.size(); ++i3) {
            Vector3f vector3f = (Vector3f)this.objects.get(i3);
            float f11 = vector3f.distanceSquared(f2, f3, f4);
            if (f11 <= f10) {
                return f5;
            }
            if (!(f11 < f9)) continue;
            f9 = f11;
        }
        return Math.sqrt(f9);
    }
}

