/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.text.NumberFormat;
import org.joml.Math;
import org.joml.Matrix4dc;
import org.joml.Matrix4fc;
import org.joml.Matrix4x3dc;
import org.joml.Matrix4x3fc;
import org.joml.MemUtil;
import org.joml.MemUtil$MemUtilUnsafe;
import org.joml.Options;
import org.joml.Quaterniondc;
import org.joml.Runtime;
import org.joml.Vector2dc;
import org.joml.Vector2fc;
import org.joml.Vector2ic;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3fc;
import org.joml.Vector3ic;
import org.joml.Vector4dc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.joml.Vector4i;
import org.joml.Vector4ic;

public class Vector4d
implements Externalizable,
Cloneable,
Vector4dc {
    private static final long serialVersionUID = 1L;
    public double x;
    public double y;
    public double z;
    public double w;

    public Vector4d() {
        this.w = 1.0;
    }

    public Vector4d(Vector4dc vector4dc) {
        this.x = vector4dc.x();
        this.y = vector4dc.y();
        this.z = vector4dc.z();
        this.w = vector4dc.w();
    }

    public Vector4d(Vector4ic vector4ic) {
        this.x = vector4ic.x();
        this.y = vector4ic.y();
        this.z = vector4ic.z();
        this.w = vector4ic.w();
    }

    public Vector4d(Vector3dc vector3dc, double d2) {
        this.x = vector3dc.x();
        this.y = vector3dc.y();
        this.z = vector3dc.z();
        this.w = d2;
    }

    public Vector4d(Vector3ic vector3ic, double d2) {
        this.x = vector3ic.x();
        this.y = vector3ic.y();
        this.z = vector3ic.z();
        this.w = d2;
    }

    public Vector4d(Vector2dc vector2dc, double d2, double d3) {
        this.x = vector2dc.x();
        this.y = vector2dc.y();
        this.z = d2;
        this.w = d3;
    }

    public Vector4d(Vector2ic vector2ic, double d2, double d3) {
        this.x = vector2ic.x();
        this.y = vector2ic.y();
        this.z = d2;
        this.w = d3;
    }

    public Vector4d(double d2) {
        this.x = d2;
        this.y = d2;
        this.z = d2;
        this.w = d2;
    }

    public Vector4d(Vector4fc vector4fc) {
        this.x = vector4fc.x();
        this.y = vector4fc.y();
        this.z = vector4fc.z();
        this.w = vector4fc.w();
    }

    public Vector4d(Vector3fc vector3fc, double d2) {
        this.x = vector3fc.x();
        this.y = vector3fc.y();
        this.z = vector3fc.z();
        this.w = d2;
    }

    public Vector4d(Vector2fc vector2fc, double d2, double d3) {
        this.x = vector2fc.x();
        this.y = vector2fc.y();
        this.z = d2;
        this.w = d3;
    }

    public Vector4d(double d2, double d3, double d4, double d5) {
        this.x = d2;
        this.y = d3;
        this.z = d4;
        this.w = d5;
    }

    public Vector4d(float[] fArray) {
        this.x = fArray[0];
        this.y = fArray[1];
        this.z = fArray[2];
        this.w = fArray[3];
    }

    public Vector4d(double[] dArray) {
        this.x = dArray[0];
        this.y = dArray[1];
        this.z = dArray[2];
        this.w = dArray[3];
    }

    public Vector4d(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
    }

    public Vector4d(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n2, byteBuffer);
    }

    public Vector4d(DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.get(this, doubleBuffer.position(), doubleBuffer);
    }

    public Vector4d(int n2, DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.get(this, n2, doubleBuffer);
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public double w() {
        return this.w;
    }

    public Vector4d set(Vector4dc vector4dc) {
        this.x = vector4dc.x();
        this.y = vector4dc.y();
        this.z = vector4dc.z();
        this.w = vector4dc.w();
        return this;
    }

    public Vector4d set(Vector4fc vector4fc) {
        this.x = vector4fc.x();
        this.y = vector4fc.y();
        this.z = vector4fc.z();
        this.w = vector4fc.w();
        return this;
    }

    public Vector4d set(Vector4ic vector4ic) {
        this.x = vector4ic.x();
        this.y = vector4ic.y();
        this.z = vector4ic.z();
        this.w = vector4ic.w();
        return this;
    }

    public Vector4d set(Vector3dc vector3dc, double d2) {
        this.x = vector3dc.x();
        this.y = vector3dc.y();
        this.z = vector3dc.z();
        this.w = d2;
        return this;
    }

    public Vector4d set(Vector3ic vector3ic, double d2) {
        this.x = vector3ic.x();
        this.y = vector3ic.y();
        this.z = vector3ic.z();
        this.w = d2;
        return this;
    }

    public Vector4d set(Vector3fc vector3fc, double d2) {
        this.x = vector3fc.x();
        this.y = vector3fc.y();
        this.z = vector3fc.z();
        this.w = d2;
        return this;
    }

    public Vector4d set(Vector2dc vector2dc, double d2, double d3) {
        this.x = vector2dc.x();
        this.y = vector2dc.y();
        this.z = d2;
        this.w = d3;
        return this;
    }

    public Vector4d set(Vector2ic vector2ic, double d2, double d3) {
        this.x = vector2ic.x();
        this.y = vector2ic.y();
        this.z = d2;
        this.w = d3;
        return this;
    }

    public Vector4d set(double d2) {
        this.x = d2;
        this.y = d2;
        this.z = d2;
        this.w = d2;
        return this;
    }

    public Vector4d set(Vector2fc vector2fc, double d2, double d3) {
        this.x = vector2fc.x();
        this.y = vector2fc.y();
        this.z = d2;
        this.w = d3;
        return this;
    }

    public Vector4d set(double d2, double d3, double d4, double d5) {
        this.x = d2;
        this.y = d3;
        this.z = d4;
        this.w = d5;
        return this;
    }

    public Vector4d set(double d2, double d3, double d4) {
        this.x = d2;
        this.y = d3;
        this.z = d4;
        return this;
    }

    public Vector4d set(double[] dArray) {
        this.x = dArray[0];
        this.y = dArray[1];
        this.z = dArray[2];
        this.w = dArray[3];
        return this;
    }

    public Vector4d set(float[] fArray) {
        this.x = fArray[0];
        this.y = fArray[1];
        this.z = fArray[2];
        this.w = fArray[3];
        return this;
    }

    public Vector4d set(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
        return this;
    }

    public Vector4d set(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n2, byteBuffer);
        return this;
    }

    public Vector4d set(DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.get(this, doubleBuffer.position(), doubleBuffer);
        return this;
    }

    public Vector4d set(int n2, DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.get(this, n2, doubleBuffer);
        return this;
    }

    public Vector4d setFromAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil$MemUtilUnsafe.get(this, l2);
        return this;
    }

    public Vector4d setComponent(int n2, double d2) {
        switch (n2) {
            case 0: {
                this.x = d2;
                break;
            }
            case 1: {
                this.y = d2;
                break;
            }
            case 2: {
                this.z = d2;
                break;
            }
            case 3: {
                this.w = d2;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    public ByteBuffer get(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, byteBuffer.position(), byteBuffer);
        return byteBuffer;
    }

    public ByteBuffer get(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, n2, byteBuffer);
        return byteBuffer;
    }

    public DoubleBuffer get(DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.put(this, doubleBuffer.position(), doubleBuffer);
        return doubleBuffer;
    }

    public DoubleBuffer get(int n2, DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.put(this, n2, doubleBuffer);
        return doubleBuffer;
    }

    public ByteBuffer getf(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.putf(this, byteBuffer.position(), byteBuffer);
        return byteBuffer;
    }

    public ByteBuffer getf(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.putf(this, n2, byteBuffer);
        return byteBuffer;
    }

    public FloatBuffer get(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put(this, floatBuffer.position(), floatBuffer);
        return floatBuffer;
    }

    public FloatBuffer get(int n2, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put(this, n2, floatBuffer);
        return floatBuffer;
    }

    public Vector4dc getToAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil$MemUtilUnsafe.put(this, l2);
        return this;
    }

    public Vector4d sub(Vector4dc vector4dc) {
        this.x -= vector4dc.x();
        this.y -= vector4dc.y();
        this.z -= vector4dc.z();
        this.w -= vector4dc.w();
        return this;
    }

    public Vector4d sub(Vector4dc vector4dc, Vector4d vector4d) {
        vector4d.x = this.x - vector4dc.x();
        vector4d.y = this.y - vector4dc.y();
        vector4d.z = this.z - vector4dc.z();
        vector4d.w = this.w - vector4dc.w();
        return vector4d;
    }

    public Vector4d sub(Vector4fc vector4fc) {
        this.x -= (double)vector4fc.x();
        this.y -= (double)vector4fc.y();
        this.z -= (double)vector4fc.z();
        this.w -= (double)vector4fc.w();
        return this;
    }

    public Vector4d sub(Vector4fc vector4fc, Vector4d vector4d) {
        vector4d.x = this.x - (double)vector4fc.x();
        vector4d.y = this.y - (double)vector4fc.y();
        vector4d.z = this.z - (double)vector4fc.z();
        vector4d.w = this.w - (double)vector4fc.w();
        return vector4d;
    }

    public Vector4d sub(double d2, double d3, double d4, double d5) {
        this.x -= d2;
        this.y -= d3;
        this.z -= d4;
        this.w -= d5;
        return this;
    }

    public Vector4d sub(double d2, double d3, double d4, double d5, Vector4d vector4d) {
        vector4d.x = this.x - d2;
        vector4d.y = this.y - d3;
        vector4d.z = this.z - d4;
        vector4d.w = this.w - d5;
        return vector4d;
    }

    public Vector4d add(Vector4dc vector4dc) {
        this.x += vector4dc.x();
        this.y += vector4dc.y();
        this.z += vector4dc.z();
        this.w += vector4dc.w();
        return this;
    }

    public Vector4d add(Vector4dc vector4dc, Vector4d vector4d) {
        vector4d.x = this.x + vector4dc.x();
        vector4d.y = this.y + vector4dc.y();
        vector4d.z = this.z + vector4dc.z();
        vector4d.w = this.w + vector4dc.w();
        return vector4d;
    }

    public Vector4d add(Vector4fc vector4fc, Vector4d vector4d) {
        vector4d.x = this.x + (double)vector4fc.x();
        vector4d.y = this.y + (double)vector4fc.y();
        vector4d.z = this.z + (double)vector4fc.z();
        vector4d.w = this.w + (double)vector4fc.w();
        return vector4d;
    }

    public Vector4d add(double d2, double d3, double d4, double d5) {
        this.x += d2;
        this.y += d3;
        this.z += d4;
        this.w += d5;
        return this;
    }

    public Vector4d add(double d2, double d3, double d4, double d5, Vector4d vector4d) {
        vector4d.x = this.x + d2;
        vector4d.y = this.y + d3;
        vector4d.z = this.z + d4;
        vector4d.w = this.w + d5;
        return vector4d;
    }

    public Vector4d add(Vector4fc vector4fc) {
        this.x += (double)vector4fc.x();
        this.y += (double)vector4fc.y();
        this.z += (double)vector4fc.z();
        this.w += (double)vector4fc.w();
        return this;
    }

    public Vector4d fma(Vector4dc vector4dc, Vector4dc vector4dc2) {
        this.x = Math.fma(vector4dc.x(), vector4dc2.x(), this.x);
        this.y = Math.fma(vector4dc.y(), vector4dc2.y(), this.y);
        this.z = Math.fma(vector4dc.z(), vector4dc2.z(), this.z);
        this.w = Math.fma(vector4dc.w(), vector4dc2.w(), this.w);
        return this;
    }

    public Vector4d fma(double d2, Vector4dc vector4dc) {
        this.x = Math.fma(d2, vector4dc.x(), this.x);
        this.y = Math.fma(d2, vector4dc.y(), this.y);
        this.z = Math.fma(d2, vector4dc.z(), this.z);
        this.w = Math.fma(d2, vector4dc.w(), this.w);
        return this;
    }

    public Vector4d fma(Vector4dc vector4dc, Vector4dc vector4dc2, Vector4d vector4d) {
        vector4d.x = Math.fma(vector4dc.x(), vector4dc2.x(), this.x);
        vector4d.y = Math.fma(vector4dc.y(), vector4dc2.y(), this.y);
        vector4d.z = Math.fma(vector4dc.z(), vector4dc2.z(), this.z);
        vector4d.w = Math.fma(vector4dc.w(), vector4dc2.w(), this.w);
        return vector4d;
    }

    public Vector4d fma(double d2, Vector4dc vector4dc, Vector4d vector4d) {
        vector4d.x = Math.fma(d2, vector4dc.x(), this.x);
        vector4d.y = Math.fma(d2, vector4dc.y(), this.y);
        vector4d.z = Math.fma(d2, vector4dc.z(), this.z);
        vector4d.w = Math.fma(d2, vector4dc.w(), this.w);
        return vector4d;
    }

    public Vector4d mulAdd(Vector4dc vector4dc, Vector4dc vector4dc2) {
        this.x = Math.fma(this.x, vector4dc.x(), vector4dc2.x());
        this.y = Math.fma(this.y, vector4dc.y(), vector4dc2.y());
        this.z = Math.fma(this.z, vector4dc.z(), vector4dc2.z());
        return this;
    }

    public Vector4d mulAdd(double d2, Vector4dc vector4dc) {
        this.x = Math.fma(this.x, d2, vector4dc.x());
        this.y = Math.fma(this.y, d2, vector4dc.y());
        this.z = Math.fma(this.z, d2, vector4dc.z());
        return this;
    }

    public Vector4d mulAdd(Vector4dc vector4dc, Vector4dc vector4dc2, Vector4d vector4d) {
        vector4d.x = Math.fma(this.x, vector4dc.x(), vector4dc2.x());
        vector4d.y = Math.fma(this.y, vector4dc.y(), vector4dc2.y());
        vector4d.z = Math.fma(this.z, vector4dc.z(), vector4dc2.z());
        return vector4d;
    }

    public Vector4d mulAdd(double d2, Vector4dc vector4dc, Vector4d vector4d) {
        vector4d.x = Math.fma(this.x, d2, vector4dc.x());
        vector4d.y = Math.fma(this.y, d2, vector4dc.y());
        vector4d.z = Math.fma(this.z, d2, vector4dc.z());
        return vector4d;
    }

    public Vector4d mul(Vector4dc vector4dc) {
        this.x *= vector4dc.x();
        this.y *= vector4dc.y();
        this.z *= vector4dc.z();
        this.w *= vector4dc.w();
        return this;
    }

    public Vector4d mul(Vector4dc vector4dc, Vector4d vector4d) {
        vector4d.x = this.x * vector4dc.x();
        vector4d.y = this.y * vector4dc.y();
        vector4d.z = this.z * vector4dc.z();
        vector4d.w = this.w * vector4dc.w();
        return vector4d;
    }

    public Vector4d div(Vector4dc vector4dc) {
        this.x /= vector4dc.x();
        this.y /= vector4dc.y();
        this.z /= vector4dc.z();
        this.w /= vector4dc.w();
        return this;
    }

    public Vector4d div(Vector4dc vector4dc, Vector4d vector4d) {
        vector4d.x = this.x / vector4dc.x();
        vector4d.y = this.y / vector4dc.y();
        vector4d.z = this.z / vector4dc.z();
        vector4d.w = this.w / vector4dc.w();
        return vector4d;
    }

    public Vector4d mul(Vector4fc vector4fc) {
        this.x *= (double)vector4fc.x();
        this.y *= (double)vector4fc.y();
        this.z *= (double)vector4fc.z();
        this.w *= (double)vector4fc.w();
        return this;
    }

    public Vector4d mul(Vector4fc vector4fc, Vector4d vector4d) {
        vector4d.x = this.x * (double)vector4fc.x();
        vector4d.y = this.y * (double)vector4fc.y();
        vector4d.z = this.z * (double)vector4fc.z();
        vector4d.w = this.w * (double)vector4fc.w();
        return vector4d;
    }

    public Vector4d mul(Matrix4dc matrix4dc) {
        if ((matrix4dc.properties() & 2) != 0) {
            return this.mulAffine(matrix4dc, this);
        }
        return this.mulGeneric(matrix4dc, this);
    }

    public Vector4d mul(Matrix4dc matrix4dc, Vector4d vector4d) {
        if ((matrix4dc.properties() & 2) != 0) {
            return this.mulAffine(matrix4dc, vector4d);
        }
        return this.mulGeneric(matrix4dc, vector4d);
    }

    public Vector4d mulTranspose(Matrix4dc matrix4dc) {
        if ((matrix4dc.properties() & 2) != 0) {
            return this.mulAffineTranspose(matrix4dc, this);
        }
        return this.mulGenericTranspose(matrix4dc, this);
    }

    public Vector4d mulTranspose(Matrix4dc matrix4dc, Vector4d vector4d) {
        if ((matrix4dc.properties() & 2) != 0) {
            return this.mulAffineTranspose(matrix4dc, vector4d);
        }
        return this.mulGenericTranspose(matrix4dc, vector4d);
    }

    public Vector4d mulAffine(Matrix4dc matrix4dc, Vector4d vector4d) {
        double d2 = Math.fma(matrix4dc.m00(), this.x, Math.fma(matrix4dc.m10(), this.y, Math.fma(matrix4dc.m20(), this.z, matrix4dc.m30() * this.w)));
        double d3 = Math.fma(matrix4dc.m01(), this.x, Math.fma(matrix4dc.m11(), this.y, Math.fma(matrix4dc.m21(), this.z, matrix4dc.m31() * this.w)));
        double d4 = Math.fma(matrix4dc.m02(), this.x, Math.fma(matrix4dc.m12(), this.y, Math.fma(matrix4dc.m22(), this.z, matrix4dc.m32() * this.w)));
        vector4d.x = d2;
        vector4d.y = d3;
        vector4d.z = d4;
        vector4d.w = this.w;
        return vector4d;
    }

    private Vector4d mulGeneric(Matrix4dc matrix4dc, Vector4d vector4d) {
        double d2 = Math.fma(matrix4dc.m00(), this.x, Math.fma(matrix4dc.m10(), this.y, Math.fma(matrix4dc.m20(), this.z, matrix4dc.m30() * this.w)));
        double d3 = Math.fma(matrix4dc.m01(), this.x, Math.fma(matrix4dc.m11(), this.y, Math.fma(matrix4dc.m21(), this.z, matrix4dc.m31() * this.w)));
        double d4 = Math.fma(matrix4dc.m02(), this.x, Math.fma(matrix4dc.m12(), this.y, Math.fma(matrix4dc.m22(), this.z, matrix4dc.m32() * this.w)));
        double d5 = Math.fma(matrix4dc.m03(), this.x, Math.fma(matrix4dc.m13(), this.y, Math.fma(matrix4dc.m23(), this.z, matrix4dc.m33() * this.w)));
        vector4d.x = d2;
        vector4d.y = d3;
        vector4d.z = d4;
        vector4d.w = d5;
        return vector4d;
    }

    public Vector4d mulAffineTranspose(Matrix4dc matrix4dc, Vector4d vector4d) {
        double d2 = this.x;
        double d3 = this.y;
        double d4 = this.z;
        double d5 = this.w;
        vector4d.x = Math.fma(matrix4dc.m00(), d2, Math.fma(matrix4dc.m01(), d3, matrix4dc.m02() * d4));
        vector4d.y = Math.fma(matrix4dc.m10(), d2, Math.fma(matrix4dc.m11(), d3, matrix4dc.m12() * d4));
        vector4d.z = Math.fma(matrix4dc.m20(), d2, Math.fma(matrix4dc.m21(), d3, matrix4dc.m22() * d4));
        vector4d.w = Math.fma(matrix4dc.m30(), d2, Math.fma(matrix4dc.m31(), d3, matrix4dc.m32() * d4 + d5));
        return vector4d;
    }

    private Vector4d mulGenericTranspose(Matrix4dc matrix4dc, Vector4d vector4d) {
        double d2 = this.x;
        double d3 = this.y;
        double d4 = this.z;
        double d5 = this.w;
        vector4d.x = Math.fma(matrix4dc.m00(), d2, Math.fma(matrix4dc.m01(), d3, Math.fma(matrix4dc.m02(), d4, matrix4dc.m03() * d5)));
        vector4d.y = Math.fma(matrix4dc.m10(), d2, Math.fma(matrix4dc.m11(), d3, Math.fma(matrix4dc.m12(), d4, matrix4dc.m13() * d5)));
        vector4d.z = Math.fma(matrix4dc.m20(), d2, Math.fma(matrix4dc.m21(), d3, Math.fma(matrix4dc.m22(), d4, matrix4dc.m23() * d5)));
        vector4d.w = Math.fma(matrix4dc.m30(), d2, Math.fma(matrix4dc.m31(), d3, Math.fma(matrix4dc.m32(), d4, matrix4dc.m33() * d5)));
        return vector4d;
    }

    public Vector4d mul(Matrix4x3dc matrix4x3dc) {
        double d2 = Math.fma(matrix4x3dc.m00(), this.x, Math.fma(matrix4x3dc.m10(), this.y, Math.fma(matrix4x3dc.m20(), this.z, matrix4x3dc.m30() * this.w)));
        double d3 = Math.fma(matrix4x3dc.m01(), this.x, Math.fma(matrix4x3dc.m11(), this.y, Math.fma(matrix4x3dc.m21(), this.z, matrix4x3dc.m31() * this.w)));
        double d4 = Math.fma(matrix4x3dc.m02(), this.x, Math.fma(matrix4x3dc.m12(), this.y, Math.fma(matrix4x3dc.m22(), this.z, matrix4x3dc.m32() * this.w)));
        this.x = d2;
        this.y = d3;
        this.z = d4;
        return this;
    }

    public Vector4d mul(Matrix4x3dc matrix4x3dc, Vector4d vector4d) {
        double d2 = Math.fma(matrix4x3dc.m00(), this.x, Math.fma(matrix4x3dc.m10(), this.y, Math.fma(matrix4x3dc.m20(), this.z, matrix4x3dc.m30() * this.w)));
        double d3 = Math.fma(matrix4x3dc.m01(), this.x, Math.fma(matrix4x3dc.m11(), this.y, Math.fma(matrix4x3dc.m21(), this.z, matrix4x3dc.m31() * this.w)));
        double d4 = Math.fma(matrix4x3dc.m02(), this.x, Math.fma(matrix4x3dc.m12(), this.y, Math.fma(matrix4x3dc.m22(), this.z, matrix4x3dc.m32() * this.w)));
        vector4d.x = d2;
        vector4d.y = d3;
        vector4d.z = d4;
        vector4d.w = this.w;
        return vector4d;
    }

    public Vector4d mul(Matrix4x3fc matrix4x3fc) {
        double d2 = Math.fma((double)matrix4x3fc.m00(), this.x, Math.fma((double)matrix4x3fc.m10(), this.y, Math.fma((double)matrix4x3fc.m20(), this.z, (double)matrix4x3fc.m30() * this.w)));
        double d3 = Math.fma((double)matrix4x3fc.m01(), this.x, Math.fma((double)matrix4x3fc.m11(), this.y, Math.fma((double)matrix4x3fc.m21(), this.z, (double)matrix4x3fc.m31() * this.w)));
        double d4 = Math.fma((double)matrix4x3fc.m02(), this.x, Math.fma((double)matrix4x3fc.m12(), this.y, Math.fma((double)matrix4x3fc.m22(), this.z, (double)matrix4x3fc.m32() * this.w)));
        this.x = d2;
        this.y = d3;
        this.z = d4;
        return this;
    }

    public Vector4d mul(Matrix4x3fc matrix4x3fc, Vector4d vector4d) {
        double d2 = Math.fma((double)matrix4x3fc.m00(), this.x, Math.fma((double)matrix4x3fc.m10(), this.y, Math.fma((double)matrix4x3fc.m20(), this.z, (double)matrix4x3fc.m30() * this.w)));
        double d3 = Math.fma((double)matrix4x3fc.m01(), this.x, Math.fma((double)matrix4x3fc.m11(), this.y, Math.fma((double)matrix4x3fc.m21(), this.z, (double)matrix4x3fc.m31() * this.w)));
        double d4 = Math.fma((double)matrix4x3fc.m02(), this.x, Math.fma((double)matrix4x3fc.m12(), this.y, Math.fma((double)matrix4x3fc.m22(), this.z, (double)matrix4x3fc.m32() * this.w)));
        vector4d.x = d2;
        vector4d.y = d3;
        vector4d.z = d4;
        vector4d.w = this.w;
        return vector4d;
    }

    public Vector4d mul(Matrix4fc matrix4fc) {
        if ((matrix4fc.properties() & 2) != 0) {
            return this.mulAffine(matrix4fc, this);
        }
        return this.mulGeneric(matrix4fc, this);
    }

    public Vector4d mul(Matrix4fc matrix4fc, Vector4d vector4d) {
        if ((matrix4fc.properties() & 2) != 0) {
            return this.mulAffine(matrix4fc, vector4d);
        }
        return this.mulGeneric(matrix4fc, vector4d);
    }

    private Vector4d mulAffine(Matrix4fc matrix4fc, Vector4d vector4d) {
        double d2 = Math.fma((double)matrix4fc.m00(), this.x, Math.fma((double)matrix4fc.m10(), this.y, Math.fma((double)matrix4fc.m20(), this.z, (double)matrix4fc.m30() * this.w)));
        double d3 = Math.fma((double)matrix4fc.m01(), this.x, Math.fma((double)matrix4fc.m11(), this.y, Math.fma((double)matrix4fc.m21(), this.z, (double)matrix4fc.m31() * this.w)));
        double d4 = Math.fma((double)matrix4fc.m02(), this.x, Math.fma((double)matrix4fc.m12(), this.y, Math.fma((double)matrix4fc.m22(), this.z, (double)matrix4fc.m32() * this.w)));
        vector4d.x = d2;
        vector4d.y = d3;
        vector4d.z = d4;
        vector4d.w = this.w;
        return vector4d;
    }

    private Vector4d mulGeneric(Matrix4fc matrix4fc, Vector4d vector4d) {
        double d2 = Math.fma((double)matrix4fc.m00(), this.x, Math.fma((double)matrix4fc.m10(), this.y, Math.fma((double)matrix4fc.m20(), this.z, (double)matrix4fc.m30() * this.w)));
        double d3 = Math.fma((double)matrix4fc.m01(), this.x, Math.fma((double)matrix4fc.m11(), this.y, Math.fma((double)matrix4fc.m21(), this.z, (double)matrix4fc.m31() * this.w)));
        double d4 = Math.fma((double)matrix4fc.m02(), this.x, Math.fma((double)matrix4fc.m12(), this.y, Math.fma((double)matrix4fc.m22(), this.z, (double)matrix4fc.m32() * this.w)));
        double d5 = Math.fma((double)matrix4fc.m03(), this.x, Math.fma((double)matrix4fc.m13(), this.y, Math.fma((double)matrix4fc.m23(), this.z, (double)matrix4fc.m33() * this.w)));
        vector4d.x = d2;
        vector4d.y = d3;
        vector4d.z = d4;
        vector4d.w = d5;
        return vector4d;
    }

    public Vector4d mulProject(Matrix4dc matrix4dc, Vector4d vector4d) {
        double d2 = 1.0 / Math.fma(matrix4dc.m03(), this.x, Math.fma(matrix4dc.m13(), this.y, Math.fma(matrix4dc.m23(), this.z, matrix4dc.m33() * this.w)));
        double d3 = Math.fma(matrix4dc.m00(), this.x, Math.fma(matrix4dc.m10(), this.y, Math.fma(matrix4dc.m20(), this.z, matrix4dc.m30() * this.w))) * d2;
        double d4 = Math.fma(matrix4dc.m01(), this.x, Math.fma(matrix4dc.m11(), this.y, Math.fma(matrix4dc.m21(), this.z, matrix4dc.m31() * this.w))) * d2;
        double d5 = Math.fma(matrix4dc.m02(), this.x, Math.fma(matrix4dc.m12(), this.y, Math.fma(matrix4dc.m22(), this.z, matrix4dc.m32() * this.w))) * d2;
        vector4d.x = d3;
        vector4d.y = d4;
        vector4d.z = d5;
        vector4d.w = 1.0;
        return vector4d;
    }

    public Vector4d mulProject(Matrix4dc matrix4dc) {
        double d2 = 1.0 / Math.fma(matrix4dc.m03(), this.x, Math.fma(matrix4dc.m13(), this.y, Math.fma(matrix4dc.m23(), this.z, matrix4dc.m33() * this.w)));
        double d3 = Math.fma(matrix4dc.m00(), this.x, Math.fma(matrix4dc.m10(), this.y, Math.fma(matrix4dc.m20(), this.z, matrix4dc.m30() * this.w))) * d2;
        double d4 = Math.fma(matrix4dc.m01(), this.x, Math.fma(matrix4dc.m11(), this.y, Math.fma(matrix4dc.m21(), this.z, matrix4dc.m31() * this.w))) * d2;
        double d5 = Math.fma(matrix4dc.m02(), this.x, Math.fma(matrix4dc.m12(), this.y, Math.fma(matrix4dc.m22(), this.z, matrix4dc.m32() * this.w))) * d2;
        this.x = d3;
        this.y = d4;
        this.z = d5;
        this.w = 1.0;
        return this;
    }

    public Vector3d mulProject(Matrix4dc matrix4dc, Vector3d vector3d) {
        double d2 = 1.0 / Math.fma(matrix4dc.m03(), this.x, Math.fma(matrix4dc.m13(), this.y, Math.fma(matrix4dc.m23(), this.z, matrix4dc.m33() * this.w)));
        double d3 = Math.fma(matrix4dc.m00(), this.x, Math.fma(matrix4dc.m10(), this.y, Math.fma(matrix4dc.m20(), this.z, matrix4dc.m30() * this.w))) * d2;
        double d4 = Math.fma(matrix4dc.m01(), this.x, Math.fma(matrix4dc.m11(), this.y, Math.fma(matrix4dc.m21(), this.z, matrix4dc.m31() * this.w))) * d2;
        double d5 = Math.fma(matrix4dc.m02(), this.x, Math.fma(matrix4dc.m12(), this.y, Math.fma(matrix4dc.m22(), this.z, matrix4dc.m32() * this.w))) * d2;
        vector3d.x = d3;
        vector3d.y = d4;
        vector3d.z = d5;
        return vector3d;
    }

    public Vector4d mul(double d2) {
        this.x *= d2;
        this.y *= d2;
        this.z *= d2;
        this.w *= d2;
        return this;
    }

    public Vector4d mul(double d2, Vector4d vector4d) {
        vector4d.x = this.x * d2;
        vector4d.y = this.y * d2;
        vector4d.z = this.z * d2;
        vector4d.w = this.w * d2;
        return vector4d;
    }

    public Vector4d div(double d2) {
        double d3 = 1.0 / d2;
        this.x *= d3;
        this.y *= d3;
        this.z *= d3;
        this.w *= d3;
        return this;
    }

    public Vector4d div(double d2, Vector4d vector4d) {
        double d3 = 1.0 / d2;
        vector4d.x = this.x * d3;
        vector4d.y = this.y * d3;
        vector4d.z = this.z * d3;
        vector4d.w = this.w * d3;
        return vector4d;
    }

    public Vector4d rotate(Quaterniondc quaterniondc) {
        quaterniondc.transform(this, this);
        return this;
    }

    public Vector4d rotate(Quaterniondc quaterniondc, Vector4d vector4d) {
        quaterniondc.transform(this, vector4d);
        return vector4d;
    }

    public Vector4d rotateAxis(double d2, double d3, double d4, double d5) {
        if (d4 == 0.0 && d5 == 0.0 && Math.absEqualsOne(d3)) {
            return this.rotateX(d3 * d2, this);
        }
        if (d3 == 0.0 && d5 == 0.0 && Math.absEqualsOne(d4)) {
            return this.rotateY(d4 * d2, this);
        }
        if (d3 == 0.0 && d4 == 0.0 && Math.absEqualsOne(d5)) {
            return this.rotateZ(d5 * d2, this);
        }
        return this.rotateAxisInternal(d2, d3, d4, d5, this);
    }

    public Vector4d rotateAxis(double d2, double d3, double d4, double d5, Vector4d vector4d) {
        if (d4 == 0.0 && d5 == 0.0 && Math.absEqualsOne(d3)) {
            return this.rotateX(d3 * d2, vector4d);
        }
        if (d3 == 0.0 && d5 == 0.0 && Math.absEqualsOne(d4)) {
            return this.rotateY(d4 * d2, vector4d);
        }
        if (d3 == 0.0 && d4 == 0.0 && Math.absEqualsOne(d5)) {
            return this.rotateZ(d5 * d2, vector4d);
        }
        return this.rotateAxisInternal(d2, d3, d4, d5, vector4d);
    }

    private Vector4d rotateAxisInternal(double d2, double d3, double d4, double d5, Vector4d vector4d) {
        double d6 = d2 * 0.5;
        double d7 = Math.sin(d6);
        double d8 = d3 * d7;
        double d9 = d4 * d7;
        double d10 = d5 * d7;
        double d11 = Math.cosFromSin(d7, d6);
        double d12 = d11 * d11;
        double d13 = d8 * d8;
        double d14 = d9 * d9;
        double d15 = d10 * d10;
        double d16 = d10 * d11;
        double d17 = d8 * d9;
        double d18 = d8 * d10;
        double d19 = d9 * d11;
        double d20 = d9 * d10;
        double d21 = d8 * d11;
        double d22 = (d12 + d13 - d15 - d14) * this.x + (-d16 + d17 - d16 + d17) * this.y + (d19 + d18 + d18 + d19) * this.z;
        double d23 = (d17 + d16 + d16 + d17) * this.x + (d14 - d15 + d12 - d13) * this.y + (d20 + d20 - d21 - d21) * this.z;
        double d24 = (d18 - d19 + d18 - d19) * this.x + (d20 + d20 + d21 + d21) * this.y + (d15 - d14 - d13 + d12) * this.z;
        vector4d.x = d22;
        vector4d.y = d23;
        vector4d.z = d24;
        return vector4d;
    }

    public Vector4d rotateX(double d2) {
        double d3 = Math.sin(d2);
        double d4 = Math.cosFromSin(d3, d2);
        double d5 = this.y * d4 - this.z * d3;
        double d6 = this.y * d3 + this.z * d4;
        this.y = d5;
        this.z = d6;
        return this;
    }

    public Vector4d rotateX(double d2, Vector4d vector4d) {
        double d3 = Math.sin(d2);
        double d4 = Math.cosFromSin(d3, d2);
        double d5 = this.y * d4 - this.z * d3;
        double d6 = this.y * d3 + this.z * d4;
        vector4d.x = this.x;
        vector4d.y = d5;
        vector4d.z = d6;
        vector4d.w = this.w;
        return vector4d;
    }

    public Vector4d rotateY(double d2) {
        double d3 = Math.sin(d2);
        double d4 = Math.cosFromSin(d3, d2);
        double d5 = this.x * d4 + this.z * d3;
        double d6 = -this.x * d3 + this.z * d4;
        this.x = d5;
        this.z = d6;
        return this;
    }

    public Vector4d rotateY(double d2, Vector4d vector4d) {
        double d3 = Math.sin(d2);
        double d4 = Math.cosFromSin(d3, d2);
        double d5 = this.x * d4 + this.z * d3;
        double d6 = -this.x * d3 + this.z * d4;
        vector4d.x = d5;
        vector4d.y = this.y;
        vector4d.z = d6;
        vector4d.w = this.w;
        return vector4d;
    }

    public Vector4d rotateZ(double d2) {
        double d3 = Math.sin(d2);
        double d4 = Math.cosFromSin(d3, d2);
        double d5 = this.x * d4 - this.y * d3;
        double d6 = this.x * d3 + this.y * d4;
        this.x = d5;
        this.y = d6;
        return this;
    }

    public Vector4d rotateZ(double d2, Vector4d vector4d) {
        double d3 = Math.sin(d2);
        double d4 = Math.cosFromSin(d3, d2);
        double d5 = this.x * d4 - this.y * d3;
        double d6 = this.x * d3 + this.y * d4;
        vector4d.x = d5;
        vector4d.y = d6;
        vector4d.z = this.z;
        vector4d.w = this.w;
        return vector4d;
    }

    public double lengthSquared() {
        return Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
    }

    public static double lengthSquared(double d2, double d3, double d4, double d5) {
        return Math.fma(d2, d2, Math.fma(d3, d3, Math.fma(d4, d4, d5 * d5)));
    }

    public double length() {
        return Math.sqrt(Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w))));
    }

    public static double length(double d2, double d3, double d4, double d5) {
        return Math.sqrt(Math.fma(d2, d2, Math.fma(d3, d3, Math.fma(d4, d4, d5 * d5))));
    }

    public Vector4d normalize() {
        double d2 = 1.0 / this.length();
        this.x *= d2;
        this.y *= d2;
        this.z *= d2;
        this.w *= d2;
        return this;
    }

    public Vector4d normalize(Vector4d vector4d) {
        double d2 = 1.0 / this.length();
        vector4d.x = this.x * d2;
        vector4d.y = this.y * d2;
        vector4d.z = this.z * d2;
        vector4d.w = this.w * d2;
        return vector4d;
    }

    public Vector4d normalize(double d2) {
        double d3 = 1.0 / this.length() * d2;
        this.x *= d3;
        this.y *= d3;
        this.z *= d3;
        this.w *= d3;
        return this;
    }

    public Vector4d normalize(double d2, Vector4d vector4d) {
        double d3 = 1.0 / this.length() * d2;
        vector4d.x = this.x * d3;
        vector4d.y = this.y * d3;
        vector4d.z = this.z * d3;
        vector4d.w = this.w * d3;
        return vector4d;
    }

    public Vector4d normalize3() {
        double d2 = Math.invsqrt(Math.fma(this.x, this.x, Math.fma(this.y, this.y, this.z * this.z)));
        this.x *= d2;
        this.y *= d2;
        this.z *= d2;
        this.w *= d2;
        return this;
    }

    public Vector4d normalize3(Vector4d vector4d) {
        double d2 = Math.invsqrt(Math.fma(this.x, this.x, Math.fma(this.y, this.y, this.z * this.z)));
        vector4d.x = this.x * d2;
        vector4d.y = this.y * d2;
        vector4d.z = this.z * d2;
        vector4d.w = this.w * d2;
        return vector4d;
    }

    public double distance(Vector4dc vector4dc) {
        double d2 = this.x - vector4dc.x();
        double d3 = this.y - vector4dc.y();
        double d4 = this.z - vector4dc.z();
        double d5 = this.w - vector4dc.w();
        return Math.sqrt(Math.fma(d2, d2, Math.fma(d3, d3, Math.fma(d4, d4, d5 * d5))));
    }

    public double distance(double d2, double d3, double d4, double d5) {
        double d6 = this.x - d2;
        double d7 = this.y - d3;
        double d8 = this.z - d4;
        double d9 = this.w - d5;
        return Math.sqrt(Math.fma(d6, d6, Math.fma(d7, d7, Math.fma(d8, d8, d9 * d9))));
    }

    public double distanceSquared(Vector4dc vector4dc) {
        double d2 = this.x - vector4dc.x();
        double d3 = this.y - vector4dc.y();
        double d4 = this.z - vector4dc.z();
        double d5 = this.w - vector4dc.w();
        return Math.fma(d2, d2, Math.fma(d3, d3, Math.fma(d4, d4, d5 * d5)));
    }

    public double distanceSquared(double d2, double d3, double d4, double d5) {
        double d6 = this.x - d2;
        double d7 = this.y - d3;
        double d8 = this.z - d4;
        double d9 = this.w - d5;
        return Math.fma(d6, d6, Math.fma(d7, d7, Math.fma(d8, d8, d9 * d9)));
    }

    public static double distance(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = d2 - d6;
        double d11 = d3 - d7;
        double d12 = d4 - d8;
        double d13 = d5 - d9;
        return Math.sqrt(Math.fma(d10, d10, Math.fma(d11, d11, Math.fma(d12, d12, d13 * d13))));
    }

    public static double distanceSquared(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = d2 - d6;
        double d11 = d3 - d7;
        double d12 = d4 - d8;
        double d13 = d5 - d9;
        return Math.fma(d10, d10, Math.fma(d11, d11, Math.fma(d12, d12, d13 * d13)));
    }

    public double dot(Vector4dc vector4dc) {
        return Math.fma(this.x, vector4dc.x(), Math.fma(this.y, vector4dc.y(), Math.fma(this.z, vector4dc.z(), this.w * vector4dc.w())));
    }

    public double dot(double d2, double d3, double d4, double d5) {
        return Math.fma(this.x, d2, Math.fma(this.y, d3, Math.fma(this.z, d4, this.w * d5)));
    }

    public double angleCos(Vector4dc vector4dc) {
        double d2 = Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
        double d3 = Math.fma(vector4dc.x(), vector4dc.x(), Math.fma(vector4dc.y(), vector4dc.y(), Math.fma(vector4dc.z(), vector4dc.z(), vector4dc.w() * vector4dc.w())));
        double d4 = Math.fma(this.x, vector4dc.x(), Math.fma(this.y, vector4dc.y(), Math.fma(this.z, vector4dc.z(), this.w * vector4dc.w())));
        return d4 / Math.sqrt(d2 * d3);
    }

    public double angle(Vector4dc vector4dc) {
        double d2 = this.angleCos(vector4dc);
        d2 = d2 < 1.0 ? d2 : 1.0;
        d2 = d2 > -1.0 ? d2 : -1.0;
        return Math.acos(d2);
    }

    public Vector4d zero() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        this.w = 0.0;
        return this;
    }

    public Vector4d negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        this.w = -this.w;
        return this;
    }

    public Vector4d negate(Vector4d vector4d) {
        vector4d.x = -this.x;
        vector4d.y = -this.y;
        vector4d.z = -this.z;
        vector4d.w = -this.w;
        return vector4d;
    }

    public Vector4d min(Vector4dc vector4dc) {
        this.x = this.x < vector4dc.x() ? this.x : vector4dc.x();
        this.y = this.y < vector4dc.y() ? this.y : vector4dc.y();
        this.z = this.z < vector4dc.z() ? this.z : vector4dc.z();
        this.w = this.w < vector4dc.w() ? this.w : vector4dc.w();
        return this;
    }

    public Vector4d min(Vector4dc vector4dc, Vector4d vector4d) {
        vector4d.x = this.x < vector4dc.x() ? this.x : vector4dc.x();
        vector4d.y = this.y < vector4dc.y() ? this.y : vector4dc.y();
        vector4d.z = this.z < vector4dc.z() ? this.z : vector4dc.z();
        vector4d.w = this.w < vector4dc.w() ? this.w : vector4dc.w();
        return vector4d;
    }

    public Vector4d max(Vector4dc vector4dc) {
        this.x = this.x > vector4dc.x() ? this.x : vector4dc.x();
        this.y = this.y > vector4dc.y() ? this.y : vector4dc.y();
        this.z = this.z > vector4dc.z() ? this.z : vector4dc.z();
        this.w = this.w > vector4dc.w() ? this.w : vector4dc.w();
        return this;
    }

    public Vector4d max(Vector4dc vector4dc, Vector4d vector4d) {
        vector4d.x = this.x > vector4dc.x() ? this.x : vector4dc.x();
        vector4d.y = this.y > vector4dc.y() ? this.y : vector4dc.y();
        vector4d.z = this.z > vector4dc.z() ? this.z : vector4dc.z();
        vector4d.w = this.w > vector4dc.w() ? this.w : vector4dc.w();
        return vector4d;
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat numberFormat) {
        return "(" + Runtime.format(this.x, numberFormat) + " " + Runtime.format(this.y, numberFormat) + " " + Runtime.format(this.z, numberFormat) + " " + Runtime.format(this.w, numberFormat) + ")";
    }

    public void writeExternal(ObjectOutput objectOutput) {
        objectOutput.writeDouble(this.x);
        objectOutput.writeDouble(this.y);
        objectOutput.writeDouble(this.z);
        objectOutput.writeDouble(this.w);
    }

    public void readExternal(ObjectInput objectInput) {
        this.x = objectInput.readDouble();
        this.y = objectInput.readDouble();
        this.z = objectInput.readDouble();
        this.w = objectInput.readDouble();
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        long l2 = Double.doubleToLongBits(this.w);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.x);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.y);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.z);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Vector4d vector4d = (Vector4d)object;
        if (Double.doubleToLongBits(this.w) != Double.doubleToLongBits(vector4d.w)) {
            return false;
        }
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(vector4d.x)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(vector4d.y)) {
            return false;
        }
        return Double.doubleToLongBits(this.z) == Double.doubleToLongBits(vector4d.z);
    }

    public boolean equals(Vector4dc vector4dc, double d2) {
        if (this == vector4dc) {
            return true;
        }
        if (vector4dc == null) {
            return false;
        }
        if (!(vector4dc instanceof Vector4dc)) {
            return false;
        }
        if (!Runtime.equals(this.x, vector4dc.x(), d2)) {
            return false;
        }
        if (!Runtime.equals(this.y, vector4dc.y(), d2)) {
            return false;
        }
        if (!Runtime.equals(this.z, vector4dc.z(), d2)) {
            return false;
        }
        return Runtime.equals(this.w, vector4dc.w(), d2);
    }

    public boolean equals(double d2, double d3, double d4, double d5) {
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(d2)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(d3)) {
            return false;
        }
        if (Double.doubleToLongBits(this.z) != Double.doubleToLongBits(d4)) {
            return false;
        }
        return Double.doubleToLongBits(this.w) == Double.doubleToLongBits(d5);
    }

    public Vector4d smoothStep(Vector4dc vector4dc, double d2, Vector4d vector4d) {
        double d3 = d2 * d2;
        double d4 = d3 * d2;
        vector4d.x = (this.x + this.x - vector4dc.x() - vector4dc.x()) * d4 + (3.0 * vector4dc.x() - 3.0 * this.x) * d3 + this.x * d2 + this.x;
        vector4d.y = (this.y + this.y - vector4dc.y() - vector4dc.y()) * d4 + (3.0 * vector4dc.y() - 3.0 * this.y) * d3 + this.y * d2 + this.y;
        vector4d.z = (this.z + this.z - vector4dc.z() - vector4dc.z()) * d4 + (3.0 * vector4dc.z() - 3.0 * this.z) * d3 + this.z * d2 + this.z;
        vector4d.w = (this.w + this.w - vector4dc.w() - vector4dc.w()) * d4 + (3.0 * vector4dc.w() - 3.0 * this.w) * d3 + this.w * d2 + this.w;
        return vector4d;
    }

    public Vector4d hermite(Vector4dc vector4dc, Vector4dc vector4dc2, Vector4dc vector4dc3, double d2, Vector4d vector4d) {
        double d3 = d2 * d2;
        double d4 = d3 * d2;
        vector4d.x = (this.x + this.x - vector4dc2.x() - vector4dc2.x() + vector4dc3.x() + vector4dc.x()) * d4 + (3.0 * vector4dc2.x() - 3.0 * this.x - vector4dc.x() - vector4dc.x() - vector4dc3.x()) * d3 + this.x * d2 + this.x;
        vector4d.y = (this.y + this.y - vector4dc2.y() - vector4dc2.y() + vector4dc3.y() + vector4dc.y()) * d4 + (3.0 * vector4dc2.y() - 3.0 * this.y - vector4dc.y() - vector4dc.y() - vector4dc3.y()) * d3 + this.y * d2 + this.y;
        vector4d.z = (this.z + this.z - vector4dc2.z() - vector4dc2.z() + vector4dc3.z() + vector4dc.z()) * d4 + (3.0 * vector4dc2.z() - 3.0 * this.z - vector4dc.z() - vector4dc.z() - vector4dc3.z()) * d3 + this.z * d2 + this.z;
        vector4d.w = (this.w + this.w - vector4dc2.w() - vector4dc2.w() + vector4dc3.w() + vector4dc.w()) * d4 + (3.0 * vector4dc2.w() - 3.0 * this.w - vector4dc.w() - vector4dc.w() - vector4dc3.w()) * d3 + this.w * d2 + this.w;
        return vector4d;
    }

    public Vector4d lerp(Vector4dc vector4dc, double d2) {
        this.x = Math.fma(vector4dc.x() - this.x, d2, this.x);
        this.y = Math.fma(vector4dc.y() - this.y, d2, this.y);
        this.z = Math.fma(vector4dc.z() - this.z, d2, this.z);
        this.w = Math.fma(vector4dc.w() - this.w, d2, this.w);
        return this;
    }

    public Vector4d lerp(Vector4dc vector4dc, double d2, Vector4d vector4d) {
        vector4d.x = Math.fma(vector4dc.x() - this.x, d2, this.x);
        vector4d.y = Math.fma(vector4dc.y() - this.y, d2, this.y);
        vector4d.z = Math.fma(vector4dc.z() - this.z, d2, this.z);
        vector4d.w = Math.fma(vector4dc.w() - this.w, d2, this.w);
        return vector4d;
    }

    public double get(int n2) {
        switch (n2) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
            case 3: {
                return this.w;
            }
        }
        throw new IllegalArgumentException();
    }

    public Vector4i get(int n2, Vector4i vector4i) {
        vector4i.x = Math.roundUsing(this.x(), n2);
        vector4i.y = Math.roundUsing(this.y(), n2);
        vector4i.z = Math.roundUsing(this.z(), n2);
        vector4i.w = Math.roundUsing(this.w(), n2);
        return vector4i;
    }

    public Vector4f get(Vector4f vector4f) {
        vector4f.x = (float)this.x();
        vector4f.y = (float)this.y();
        vector4f.z = (float)this.z();
        vector4f.w = (float)this.w();
        return vector4f;
    }

    public Vector4d get(Vector4d vector4d) {
        vector4d.x = this.x();
        vector4d.y = this.y();
        vector4d.z = this.z();
        vector4d.w = this.w();
        return vector4d;
    }

    public int maxComponent() {
        double d2 = Math.abs(this.x);
        double d3 = Math.abs(this.y);
        double d4 = Math.abs(this.z);
        double d5 = Math.abs(this.w);
        if (d2 >= d3 && d2 >= d4 && d2 >= d5) {
            return 0;
        }
        if (d3 >= d4 && d3 >= d5) {
            return 1;
        }
        if (d4 >= d5) {
            return 2;
        }
        return 3;
    }

    public int minComponent() {
        double d2 = Math.abs(this.x);
        double d3 = Math.abs(this.y);
        double d4 = Math.abs(this.z);
        double d5 = Math.abs(this.w);
        if (d2 < d3 && d2 < d4 && d2 < d5) {
            return 0;
        }
        if (d3 < d4 && d3 < d5) {
            return 1;
        }
        if (d4 < d5) {
            return 2;
        }
        return 3;
    }

    public Vector4d floor() {
        this.x = Math.floor(this.x);
        this.y = Math.floor(this.y);
        this.z = Math.floor(this.z);
        this.w = Math.floor(this.w);
        return this;
    }

    public Vector4d floor(Vector4d vector4d) {
        vector4d.x = Math.floor(this.x);
        vector4d.y = Math.floor(this.y);
        vector4d.z = Math.floor(this.z);
        vector4d.w = Math.floor(this.w);
        return vector4d;
    }

    public Vector4d ceil() {
        this.x = Math.ceil(this.x);
        this.y = Math.ceil(this.y);
        this.z = Math.ceil(this.z);
        this.w = Math.ceil(this.w);
        return this;
    }

    public Vector4d ceil(Vector4d vector4d) {
        vector4d.x = Math.ceil(this.x);
        vector4d.y = Math.ceil(this.y);
        vector4d.z = Math.ceil(this.z);
        vector4d.w = Math.ceil(this.w);
        return vector4d;
    }

    public Vector4d round() {
        this.x = Math.round(this.x);
        this.y = Math.round(this.y);
        this.z = Math.round(this.z);
        this.w = Math.round(this.w);
        return this;
    }

    public Vector4d round(Vector4d vector4d) {
        vector4d.x = Math.round(this.x);
        vector4d.y = Math.round(this.y);
        vector4d.z = Math.round(this.z);
        vector4d.w = Math.round(this.w);
        return vector4d;
    }

    public boolean isFinite() {
        return Math.isFinite(this.x) && Math.isFinite(this.y) && Math.isFinite(this.z) && Math.isFinite(this.w);
    }

    public Vector4d absolute() {
        this.x = Math.abs(this.x);
        this.y = Math.abs(this.y);
        this.z = Math.abs(this.z);
        this.w = Math.abs(this.w);
        return this;
    }

    public Vector4d absolute(Vector4d vector4d) {
        vector4d.x = Math.abs(this.x);
        vector4d.y = Math.abs(this.y);
        vector4d.z = Math.abs(this.z);
        vector4d.w = Math.abs(this.w);
        return vector4d;
    }

    public Object clone() {
        return super.clone();
    }
}

