/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.text.NumberFormat;
import org.joml.Math;
import org.joml.MemUtil;
import org.joml.MemUtil$MemUtilUnsafe;
import org.joml.Options;
import org.joml.Runtime;
import org.joml.Vector2dc;
import org.joml.Vector2fc;
import org.joml.Vector2ic;
import org.joml.Vector3dc;
import org.joml.Vector3fc;
import org.joml.Vector3ic;

public class Vector3i
implements Externalizable,
Cloneable,
Vector3ic {
    private static final long serialVersionUID = 1L;
    public int x;
    public int y;
    public int z;

    public Vector3i() {
    }

    public Vector3i(int n2) {
        this.x = n2;
        this.y = n2;
        this.z = n2;
    }

    public Vector3i(int n2, int n3, int n4) {
        this.x = n2;
        this.y = n3;
        this.z = n4;
    }

    public Vector3i(Vector3ic vector3ic) {
        this.x = vector3ic.x();
        this.y = vector3ic.y();
        this.z = vector3ic.z();
    }

    public Vector3i(Vector2ic vector2ic, int n2) {
        this.x = vector2ic.x();
        this.y = vector2ic.y();
        this.z = n2;
    }

    public Vector3i(float f2, float f3, float f4, int n2) {
        this.x = Math.roundUsing(f2, n2);
        this.y = Math.roundUsing(f3, n2);
        this.z = Math.roundUsing(f4, n2);
    }

    public Vector3i(double d2, double d3, double d4, int n2) {
        this.x = Math.roundUsing(d2, n2);
        this.y = Math.roundUsing(d3, n2);
        this.z = Math.roundUsing(d4, n2);
    }

    public Vector3i(Vector2fc vector2fc, float f2, int n2) {
        this.x = Math.roundUsing(vector2fc.x(), n2);
        this.y = Math.roundUsing(vector2fc.y(), n2);
        this.z = Math.roundUsing(f2, n2);
    }

    public Vector3i(Vector3fc vector3fc, int n2) {
        this.x = Math.roundUsing(vector3fc.x(), n2);
        this.y = Math.roundUsing(vector3fc.y(), n2);
        this.z = Math.roundUsing(vector3fc.z(), n2);
    }

    public Vector3i(Vector2dc vector2dc, float f2, int n2) {
        this.x = Math.roundUsing(vector2dc.x(), n2);
        this.y = Math.roundUsing(vector2dc.y(), n2);
        this.z = Math.roundUsing(f2, n2);
    }

    public Vector3i(Vector3dc vector3dc, int n2) {
        this.x = Math.roundUsing(vector3dc.x(), n2);
        this.y = Math.roundUsing(vector3dc.y(), n2);
        this.z = Math.roundUsing(vector3dc.z(), n2);
    }

    public Vector3i(int[] nArray) {
        this.x = nArray[0];
        this.y = nArray[1];
        this.z = nArray[2];
    }

    public Vector3i(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
    }

    public Vector3i(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n2, byteBuffer);
    }

    public Vector3i(IntBuffer intBuffer) {
        MemUtil.INSTANCE.get(this, intBuffer.position(), intBuffer);
    }

    public Vector3i(int n2, IntBuffer intBuffer) {
        MemUtil.INSTANCE.get(this, n2, intBuffer);
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public int z() {
        return this.z;
    }

    public Vector3i set(Vector3ic vector3ic) {
        this.x = vector3ic.x();
        this.y = vector3ic.y();
        this.z = vector3ic.z();
        return this;
    }

    public Vector3i set(Vector3dc vector3dc) {
        this.x = (int)vector3dc.x();
        this.y = (int)vector3dc.y();
        this.z = (int)vector3dc.z();
        return this;
    }

    public Vector3i set(Vector3dc vector3dc, int n2) {
        this.x = Math.roundUsing(vector3dc.x(), n2);
        this.y = Math.roundUsing(vector3dc.y(), n2);
        this.z = Math.roundUsing(vector3dc.z(), n2);
        return this;
    }

    public Vector3i set(Vector3fc vector3fc, int n2) {
        this.x = Math.roundUsing(vector3fc.x(), n2);
        this.y = Math.roundUsing(vector3fc.y(), n2);
        this.z = Math.roundUsing(vector3fc.z(), n2);
        return this;
    }

    public Vector3i set(Vector2ic vector2ic, int n2) {
        this.x = vector2ic.x();
        this.y = vector2ic.y();
        this.z = n2;
        return this;
    }

    public Vector3i set(int n2) {
        this.x = n2;
        this.y = n2;
        this.z = n2;
        return this;
    }

    public Vector3i set(int n2, int n3, int n4) {
        this.x = n2;
        this.y = n3;
        this.z = n4;
        return this;
    }

    public Vector3i set(int[] nArray) {
        this.x = nArray[0];
        this.y = nArray[1];
        this.z = nArray[2];
        return this;
    }

    public Vector3i set(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
        return this;
    }

    public Vector3i set(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n2, byteBuffer);
        return this;
    }

    public Vector3i set(IntBuffer intBuffer) {
        MemUtil.INSTANCE.get(this, intBuffer.position(), intBuffer);
        return this;
    }

    public Vector3i set(int n2, IntBuffer intBuffer) {
        MemUtil.INSTANCE.get(this, n2, intBuffer);
        return this;
    }

    public Vector3i setFromAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil$MemUtilUnsafe.get(this, l2);
        return this;
    }

    public int get(int n2) {
        switch (n2) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IllegalArgumentException();
    }

    public Vector3i setComponent(int n2, int n3) {
        switch (n2) {
            case 0: {
                this.x = n3;
                break;
            }
            case 1: {
                this.y = n3;
                break;
            }
            case 2: {
                this.z = n3;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    public IntBuffer get(IntBuffer intBuffer) {
        MemUtil.INSTANCE.put(this, intBuffer.position(), intBuffer);
        return intBuffer;
    }

    public IntBuffer get(int n2, IntBuffer intBuffer) {
        MemUtil.INSTANCE.put(this, n2, intBuffer);
        return intBuffer;
    }

    public ByteBuffer get(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, byteBuffer.position(), byteBuffer);
        return byteBuffer;
    }

    public ByteBuffer get(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, n2, byteBuffer);
        return byteBuffer;
    }

    public Vector3ic getToAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil$MemUtilUnsafe.put(this, l2);
        return this;
    }

    public Vector3i sub(Vector3ic vector3ic) {
        this.x -= vector3ic.x();
        this.y -= vector3ic.y();
        this.z -= vector3ic.z();
        return this;
    }

    public Vector3i sub(Vector3ic vector3ic, Vector3i vector3i) {
        vector3i.x = this.x - vector3ic.x();
        vector3i.y = this.y - vector3ic.y();
        vector3i.z = this.z - vector3ic.z();
        return vector3i;
    }

    public Vector3i sub(int n2, int n3, int n4) {
        this.x -= n2;
        this.y -= n3;
        this.z -= n4;
        return this;
    }

    public Vector3i sub(int n2, int n3, int n4, Vector3i vector3i) {
        vector3i.x = this.x - n2;
        vector3i.y = this.y - n3;
        vector3i.z = this.z - n4;
        return vector3i;
    }

    public Vector3i add(Vector3ic vector3ic) {
        this.x += vector3ic.x();
        this.y += vector3ic.y();
        this.z += vector3ic.z();
        return this;
    }

    public Vector3i add(Vector3ic vector3ic, Vector3i vector3i) {
        vector3i.x = this.x + vector3ic.x();
        vector3i.y = this.y + vector3ic.y();
        vector3i.z = this.z + vector3ic.z();
        return vector3i;
    }

    public Vector3i add(int n2, int n3, int n4) {
        this.x += n2;
        this.y += n3;
        this.z += n4;
        return this;
    }

    public Vector3i add(int n2, int n3, int n4, Vector3i vector3i) {
        vector3i.x = this.x + n2;
        vector3i.y = this.y + n3;
        vector3i.z = this.z + n4;
        return vector3i;
    }

    public Vector3i mul(int n2) {
        this.x *= n2;
        this.y *= n2;
        this.z *= n2;
        return this;
    }

    public Vector3i mul(int n2, Vector3i vector3i) {
        vector3i.x = this.x * n2;
        vector3i.y = this.y * n2;
        vector3i.z = this.z * n2;
        return vector3i;
    }

    public Vector3i mul(Vector3ic vector3ic) {
        this.x *= vector3ic.x();
        this.y *= vector3ic.y();
        this.z *= vector3ic.z();
        return this;
    }

    public Vector3i mul(Vector3ic vector3ic, Vector3i vector3i) {
        vector3i.x = this.x * vector3ic.x();
        vector3i.y = this.y * vector3ic.y();
        vector3i.z = this.z * vector3ic.z();
        return vector3i;
    }

    public Vector3i mul(int n2, int n3, int n4) {
        this.x *= n2;
        this.y *= n3;
        this.z *= n4;
        return this;
    }

    public Vector3i mul(int n2, int n3, int n4, Vector3i vector3i) {
        vector3i.x = this.x * n2;
        vector3i.y = this.y * n3;
        vector3i.z = this.z * n4;
        return vector3i;
    }

    public Vector3i div(float f2) {
        float f3 = 1.0f / f2;
        this.x = (int)((float)this.x * f3);
        this.y = (int)((float)this.y * f3);
        this.z = (int)((float)this.z * f3);
        return this;
    }

    public Vector3i div(float f2, Vector3i vector3i) {
        float f3 = 1.0f / f2;
        vector3i.x = (int)((float)this.x * f3);
        vector3i.y = (int)((float)this.y * f3);
        vector3i.z = (int)((float)this.z * f3);
        return vector3i;
    }

    public Vector3i div(int n2) {
        this.x /= n2;
        this.y /= n2;
        this.z /= n2;
        return this;
    }

    public Vector3i div(int n2, Vector3i vector3i) {
        vector3i.x = this.x / n2;
        vector3i.y = this.y / n2;
        vector3i.z = this.z / n2;
        return vector3i;
    }

    public long lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public static long lengthSquared(int n2, int n3, int n4) {
        return n2 * n2 + n3 * n3 + n4 * n4;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public static double length(int n2, int n3, int n4) {
        return Math.sqrt(n2 * n2 + n3 * n3 + n4 * n4);
    }

    public double distance(Vector3ic vector3ic) {
        int n2 = this.x - vector3ic.x();
        int n3 = this.y - vector3ic.y();
        int n4 = this.z - vector3ic.z();
        return Math.sqrt(n2 * n2 + n3 * n3 + n4 * n4);
    }

    public double distance(int n2, int n3, int n4) {
        int n5 = this.x - n2;
        int n6 = this.y - n3;
        int n7 = this.z - n4;
        return Math.sqrt(n5 * n5 + n6 * n6 + n7 * n7);
    }

    public long gridDistance(Vector3ic vector3ic) {
        return Math.abs(vector3ic.x() - this.x()) + Math.abs(vector3ic.y() - this.y()) + Math.abs(vector3ic.z() - this.z());
    }

    public long gridDistance(int n2, int n3, int n4) {
        return Math.abs(n2 - this.x()) + Math.abs(n3 - this.y()) + Math.abs(n4 - this.z());
    }

    public long distanceSquared(Vector3ic vector3ic) {
        int n2 = this.x - vector3ic.x();
        int n3 = this.y - vector3ic.y();
        int n4 = this.z - vector3ic.z();
        return n2 * n2 + n3 * n3 + n4 * n4;
    }

    public long distanceSquared(int n2, int n3, int n4) {
        int n5 = this.x - n2;
        int n6 = this.y - n3;
        int n7 = this.z - n4;
        return n5 * n5 + n6 * n6 + n7 * n7;
    }

    public static double distance(int n2, int n3, int n4, int n5, int n6, int n7) {
        return Math.sqrt(Vector3i.distanceSquared(n2, n3, n4, n5, n6, n7));
    }

    public static long distanceSquared(int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n2 - n5;
        int n9 = n3 - n6;
        int n10 = n4 - n7;
        return n8 * n8 + n9 * n9 + n10 * n10;
    }

    public Vector3i zero() {
        this.x = 0;
        this.y = 0;
        this.z = 0;
        return this;
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat numberFormat) {
        return "(" + numberFormat.format(this.x) + " " + numberFormat.format(this.y) + " " + numberFormat.format(this.z) + ")";
    }

    public void writeExternal(ObjectOutput objectOutput) {
        objectOutput.writeInt(this.x);
        objectOutput.writeInt(this.y);
        objectOutput.writeInt(this.z);
    }

    public void readExternal(ObjectInput objectInput) {
        this.x = objectInput.readInt();
        this.y = objectInput.readInt();
        this.z = objectInput.readInt();
    }

    public Vector3i negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3i negate(Vector3i vector3i) {
        vector3i.x = -this.x;
        vector3i.y = -this.y;
        vector3i.z = -this.z;
        return vector3i;
    }

    public Vector3i min(Vector3ic vector3ic) {
        this.x = this.x < vector3ic.x() ? this.x : vector3ic.x();
        this.y = this.y < vector3ic.y() ? this.y : vector3ic.y();
        this.z = this.z < vector3ic.z() ? this.z : vector3ic.z();
        return this;
    }

    public Vector3i min(Vector3ic vector3ic, Vector3i vector3i) {
        vector3i.x = this.x < vector3ic.x() ? this.x : vector3ic.x();
        vector3i.y = this.y < vector3ic.y() ? this.y : vector3ic.y();
        vector3i.z = this.z < vector3ic.z() ? this.z : vector3ic.z();
        return vector3i;
    }

    public Vector3i max(Vector3ic vector3ic) {
        this.x = this.x > vector3ic.x() ? this.x : vector3ic.x();
        this.y = this.y > vector3ic.y() ? this.y : vector3ic.y();
        this.z = this.z > vector3ic.z() ? this.z : vector3ic.z();
        return this;
    }

    public Vector3i max(Vector3ic vector3ic, Vector3i vector3i) {
        vector3i.x = this.x > vector3ic.x() ? this.x : vector3ic.x();
        vector3i.y = this.y > vector3ic.y() ? this.y : vector3ic.y();
        vector3i.z = this.z > vector3ic.z() ? this.z : vector3ic.z();
        return vector3i;
    }

    public int maxComponent() {
        float f2 = Math.abs(this.x);
        float f3 = Math.abs(this.y);
        float f4 = Math.abs(this.z);
        if (f2 >= f3 && f2 >= f4) {
            return 0;
        }
        if (f3 >= f4) {
            return 1;
        }
        return 2;
    }

    public int minComponent() {
        float f2 = Math.abs(this.x);
        float f3 = Math.abs(this.y);
        float f4 = Math.abs(this.z);
        if (f2 < f3 && f2 < f4) {
            return 0;
        }
        if (f3 < f4) {
            return 1;
        }
        return 2;
    }

    public Vector3i absolute() {
        this.x = Math.abs(this.x);
        this.y = Math.abs(this.y);
        this.z = Math.abs(this.z);
        return this;
    }

    public Vector3i absolute(Vector3i vector3i) {
        vector3i.x = Math.abs(this.x);
        vector3i.y = Math.abs(this.y);
        vector3i.z = Math.abs(this.z);
        return vector3i;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + this.x;
        n3 = 31 * n3 + this.y;
        n3 = 31 * n3 + this.z;
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Vector3i vector3i = (Vector3i)object;
        if (this.x != vector3i.x) {
            return false;
        }
        if (this.y != vector3i.y) {
            return false;
        }
        return this.z == vector3i.z;
    }

    public boolean equals(int n2, int n3, int n4) {
        if (this.x != n2) {
            return false;
        }
        if (this.y != n3) {
            return false;
        }
        return this.z == n4;
    }

    public Object clone() {
        return super.clone();
    }
}

