/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.text.NumberFormat;
import org.joml.Math;
import org.joml.Matrix3dc;
import org.joml.Matrix3fc;
import org.joml.Matrix3x2fc;
import org.joml.Matrix4dc;
import org.joml.Matrix4fc;
import org.joml.Matrix4x3fc;
import org.joml.MemUtil;
import org.joml.MemUtil$MemUtilUnsafe;
import org.joml.Options;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Runtime;
import org.joml.Vector2dc;
import org.joml.Vector2fc;
import org.joml.Vector2ic;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3fc;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public class Vector3f
implements Externalizable,
Cloneable,
Vector3fc {
    private static final long serialVersionUID = 1L;
    public float x;
    public float y;
    public float z;

    public Vector3f() {
    }

    public Vector3f(float f2) {
        this.x = f2;
        this.y = f2;
        this.z = f2;
    }

    public Vector3f(float f2, float f3, float f4) {
        this.x = f2;
        this.y = f3;
        this.z = f4;
    }

    public Vector3f(Vector3fc vector3fc) {
        this.x = vector3fc.x();
        this.y = vector3fc.y();
        this.z = vector3fc.z();
    }

    public Vector3f(Vector3ic vector3ic) {
        this.x = vector3ic.x();
        this.y = vector3ic.y();
        this.z = vector3ic.z();
    }

    public Vector3f(Vector2fc vector2fc, float f2) {
        this.x = vector2fc.x();
        this.y = vector2fc.y();
        this.z = f2;
    }

    public Vector3f(Vector2ic vector2ic, float f2) {
        this.x = vector2ic.x();
        this.y = vector2ic.y();
        this.z = f2;
    }

    public Vector3f(float[] fArray) {
        this.x = fArray[0];
        this.y = fArray[1];
        this.z = fArray[2];
    }

    public Vector3f(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
    }

    public Vector3f(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n2, byteBuffer);
    }

    public Vector3f(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, floatBuffer.position(), floatBuffer);
    }

    public Vector3f(int n2, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, n2, floatBuffer);
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public float z() {
        return this.z;
    }

    public Vector3f set(Vector3fc vector3fc) {
        this.x = vector3fc.x();
        this.y = vector3fc.y();
        this.z = vector3fc.z();
        return this;
    }

    public Vector3f set(Vector3dc vector3dc) {
        this.x = (float)vector3dc.x();
        this.y = (float)vector3dc.y();
        this.z = (float)vector3dc.z();
        return this;
    }

    public Vector3f set(Vector3ic vector3ic) {
        this.x = vector3ic.x();
        this.y = vector3ic.y();
        this.z = vector3ic.z();
        return this;
    }

    public Vector3f set(Vector2fc vector2fc, float f2) {
        this.x = vector2fc.x();
        this.y = vector2fc.y();
        this.z = f2;
        return this;
    }

    public Vector3f set(Vector2dc vector2dc, float f2) {
        this.x = (float)vector2dc.x();
        this.y = (float)vector2dc.y();
        this.z = f2;
        return this;
    }

    public Vector3f set(Vector2ic vector2ic, float f2) {
        this.x = vector2ic.x();
        this.y = vector2ic.y();
        this.z = f2;
        return this;
    }

    public Vector3f set(float f2) {
        this.x = f2;
        this.y = f2;
        this.z = f2;
        return this;
    }

    public Vector3f set(float f2, float f3, float f4) {
        this.x = f2;
        this.y = f3;
        this.z = f4;
        return this;
    }

    public Vector3f set(double d2) {
        this.x = (float)d2;
        this.y = (float)d2;
        this.z = (float)d2;
        return this;
    }

    public Vector3f set(double d2, double d3, double d4) {
        this.x = (float)d2;
        this.y = (float)d3;
        this.z = (float)d4;
        return this;
    }

    public Vector3f set(float[] fArray) {
        this.x = fArray[0];
        this.y = fArray[1];
        this.z = fArray[2];
        return this;
    }

    public Vector3f set(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
        return this;
    }

    public Vector3f set(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n2, byteBuffer);
        return this;
    }

    public Vector3f set(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, floatBuffer.position(), floatBuffer);
        return this;
    }

    public Vector3f set(int n2, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, n2, floatBuffer);
        return this;
    }

    public Vector3f setFromAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil$MemUtilUnsafe.get(this, l2);
        return this;
    }

    public Vector3f setComponent(int n2, float f2) {
        switch (n2) {
            case 0: {
                this.x = f2;
                break;
            }
            case 1: {
                this.y = f2;
                break;
            }
            case 2: {
                this.z = f2;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    public FloatBuffer get(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put(this, floatBuffer.position(), floatBuffer);
        return floatBuffer;
    }

    public FloatBuffer get(int n2, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put(this, n2, floatBuffer);
        return floatBuffer;
    }

    public ByteBuffer get(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, byteBuffer.position(), byteBuffer);
        return byteBuffer;
    }

    public ByteBuffer get(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, n2, byteBuffer);
        return byteBuffer;
    }

    public Vector3fc getToAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil$MemUtilUnsafe.put(this, l2);
        return this;
    }

    public Vector3f sub(Vector3fc vector3fc) {
        this.x -= vector3fc.x();
        this.y -= vector3fc.y();
        this.z -= vector3fc.z();
        return this;
    }

    public Vector3f sub(Vector3fc vector3fc, Vector3f vector3f) {
        vector3f.x = this.x - vector3fc.x();
        vector3f.y = this.y - vector3fc.y();
        vector3f.z = this.z - vector3fc.z();
        return vector3f;
    }

    public Vector3f sub(float f2, float f3, float f4) {
        this.x -= f2;
        this.y -= f3;
        this.z -= f4;
        return this;
    }

    public Vector3f sub(float f2, float f3, float f4, Vector3f vector3f) {
        vector3f.x = this.x - f2;
        vector3f.y = this.y - f3;
        vector3f.z = this.z - f4;
        return vector3f;
    }

    public Vector3f add(Vector3fc vector3fc) {
        this.x += vector3fc.x();
        this.y += vector3fc.y();
        this.z += vector3fc.z();
        return this;
    }

    public Vector3f add(Vector3fc vector3fc, Vector3f vector3f) {
        vector3f.x = this.x + vector3fc.x();
        vector3f.y = this.y + vector3fc.y();
        vector3f.z = this.z + vector3fc.z();
        return vector3f;
    }

    public Vector3f add(float f2, float f3, float f4) {
        this.x += f2;
        this.y += f3;
        this.z += f4;
        return this;
    }

    public Vector3f add(float f2, float f3, float f4, Vector3f vector3f) {
        vector3f.x = this.x + f2;
        vector3f.y = this.y + f3;
        vector3f.z = this.z + f4;
        return vector3f;
    }

    public Vector3f fma(Vector3fc vector3fc, Vector3fc vector3fc2) {
        this.x = Math.fma(vector3fc.x(), vector3fc2.x(), this.x);
        this.y = Math.fma(vector3fc.y(), vector3fc2.y(), this.y);
        this.z = Math.fma(vector3fc.z(), vector3fc2.z(), this.z);
        return this;
    }

    public Vector3f fma(float f2, Vector3fc vector3fc) {
        this.x = Math.fma(f2, vector3fc.x(), this.x);
        this.y = Math.fma(f2, vector3fc.y(), this.y);
        this.z = Math.fma(f2, vector3fc.z(), this.z);
        return this;
    }

    public Vector3f fma(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3f vector3f) {
        vector3f.x = Math.fma(vector3fc.x(), vector3fc2.x(), this.x);
        vector3f.y = Math.fma(vector3fc.y(), vector3fc2.y(), this.y);
        vector3f.z = Math.fma(vector3fc.z(), vector3fc2.z(), this.z);
        return vector3f;
    }

    public Vector3f fma(float f2, Vector3fc vector3fc, Vector3f vector3f) {
        vector3f.x = Math.fma(f2, vector3fc.x(), this.x);
        vector3f.y = Math.fma(f2, vector3fc.y(), this.y);
        vector3f.z = Math.fma(f2, vector3fc.z(), this.z);
        return vector3f;
    }

    public Vector3f mulAdd(Vector3fc vector3fc, Vector3fc vector3fc2) {
        this.x = Math.fma(this.x, vector3fc.x(), vector3fc2.x());
        this.y = Math.fma(this.y, vector3fc.y(), vector3fc2.y());
        this.z = Math.fma(this.z, vector3fc.z(), vector3fc2.z());
        return this;
    }

    public Vector3f mulAdd(float f2, Vector3fc vector3fc) {
        this.x = Math.fma(this.x, f2, vector3fc.x());
        this.y = Math.fma(this.y, f2, vector3fc.y());
        this.z = Math.fma(this.z, f2, vector3fc.z());
        return this;
    }

    public Vector3f mulAdd(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3f vector3f) {
        vector3f.x = Math.fma(this.x, vector3fc.x(), vector3fc2.x());
        vector3f.y = Math.fma(this.y, vector3fc.y(), vector3fc2.y());
        vector3f.z = Math.fma(this.z, vector3fc.z(), vector3fc2.z());
        return vector3f;
    }

    public Vector3f mulAdd(float f2, Vector3fc vector3fc, Vector3f vector3f) {
        vector3f.x = Math.fma(this.x, f2, vector3fc.x());
        vector3f.y = Math.fma(this.y, f2, vector3fc.y());
        vector3f.z = Math.fma(this.z, f2, vector3fc.z());
        return vector3f;
    }

    public Vector3f mul(Vector3fc vector3fc) {
        this.x *= vector3fc.x();
        this.y *= vector3fc.y();
        this.z *= vector3fc.z();
        return this;
    }

    public Vector3f mul(Vector3fc vector3fc, Vector3f vector3f) {
        vector3f.x = this.x * vector3fc.x();
        vector3f.y = this.y * vector3fc.y();
        vector3f.z = this.z * vector3fc.z();
        return vector3f;
    }

    public Vector3f div(Vector3fc vector3fc) {
        this.x /= vector3fc.x();
        this.y /= vector3fc.y();
        this.z /= vector3fc.z();
        return this;
    }

    public Vector3f div(Vector3fc vector3fc, Vector3f vector3f) {
        vector3f.x = this.x / vector3fc.x();
        vector3f.y = this.y / vector3fc.y();
        vector3f.z = this.z / vector3fc.z();
        return vector3f;
    }

    public Vector3f mulProject(Matrix4fc matrix4fc, Vector3f vector3f) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        float f5 = 1.0f / Math.fma(matrix4fc.m03(), f2, Math.fma(matrix4fc.m13(), f3, Math.fma(matrix4fc.m23(), f4, matrix4fc.m33())));
        vector3f.x = Math.fma(matrix4fc.m00(), f2, Math.fma(matrix4fc.m10(), f3, Math.fma(matrix4fc.m20(), f4, matrix4fc.m30()))) * f5;
        vector3f.y = Math.fma(matrix4fc.m01(), f2, Math.fma(matrix4fc.m11(), f3, Math.fma(matrix4fc.m21(), f4, matrix4fc.m31()))) * f5;
        vector3f.z = Math.fma(matrix4fc.m02(), f2, Math.fma(matrix4fc.m12(), f3, Math.fma(matrix4fc.m22(), f4, matrix4fc.m32()))) * f5;
        return vector3f;
    }

    public Vector3f mulProject(Matrix4fc matrix4fc, float f2, Vector3f vector3f) {
        float f3 = this.x;
        float f4 = this.y;
        float f5 = this.z;
        float f6 = 1.0f / Math.fma(matrix4fc.m03(), f3, Math.fma(matrix4fc.m13(), f4, Math.fma(matrix4fc.m23(), f5, matrix4fc.m33() * f2)));
        vector3f.x = Math.fma(matrix4fc.m00(), f3, Math.fma(matrix4fc.m10(), f4, Math.fma(matrix4fc.m20(), f5, matrix4fc.m30() * f2))) * f6;
        vector3f.y = Math.fma(matrix4fc.m01(), f3, Math.fma(matrix4fc.m11(), f4, Math.fma(matrix4fc.m21(), f5, matrix4fc.m31() * f2))) * f6;
        vector3f.z = Math.fma(matrix4fc.m02(), f3, Math.fma(matrix4fc.m12(), f4, Math.fma(matrix4fc.m22(), f5, matrix4fc.m32() * f2))) * f6;
        return vector3f;
    }

    public Vector3f mulProject(Matrix4fc matrix4fc) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        float f5 = 1.0f / Math.fma(matrix4fc.m03(), f2, Math.fma(matrix4fc.m13(), f3, Math.fma(matrix4fc.m23(), f4, matrix4fc.m33())));
        this.x = Math.fma(matrix4fc.m00(), f2, Math.fma(matrix4fc.m10(), f3, Math.fma(matrix4fc.m20(), f4, matrix4fc.m30()))) * f5;
        this.y = Math.fma(matrix4fc.m01(), f2, Math.fma(matrix4fc.m11(), f3, Math.fma(matrix4fc.m21(), f4, matrix4fc.m31()))) * f5;
        this.z = Math.fma(matrix4fc.m02(), f2, Math.fma(matrix4fc.m12(), f3, Math.fma(matrix4fc.m22(), f4, matrix4fc.m32()))) * f5;
        return this;
    }

    public Vector3f mul(Matrix3fc matrix3fc) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        this.x = Math.fma(matrix3fc.m00(), f2, Math.fma(matrix3fc.m10(), f3, matrix3fc.m20() * f4));
        this.y = Math.fma(matrix3fc.m01(), f2, Math.fma(matrix3fc.m11(), f3, matrix3fc.m21() * f4));
        this.z = Math.fma(matrix3fc.m02(), f2, Math.fma(matrix3fc.m12(), f3, matrix3fc.m22() * f4));
        return this;
    }

    public Vector3f mul(Matrix3fc matrix3fc, Vector3f vector3f) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        vector3f.x = Math.fma(matrix3fc.m00(), f2, Math.fma(matrix3fc.m10(), f3, matrix3fc.m20() * f4));
        vector3f.y = Math.fma(matrix3fc.m01(), f2, Math.fma(matrix3fc.m11(), f3, matrix3fc.m21() * f4));
        vector3f.z = Math.fma(matrix3fc.m02(), f2, Math.fma(matrix3fc.m12(), f3, matrix3fc.m22() * f4));
        return vector3f;
    }

    public Vector3f mul(Matrix3dc matrix3dc) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        this.x = (float)Math.fma(matrix3dc.m00(), (double)f2, Math.fma(matrix3dc.m10(), (double)f3, matrix3dc.m20() * (double)f4));
        this.y = (float)Math.fma(matrix3dc.m01(), (double)f2, Math.fma(matrix3dc.m11(), (double)f3, matrix3dc.m21() * (double)f4));
        this.z = (float)Math.fma(matrix3dc.m02(), (double)f2, Math.fma(matrix3dc.m12(), (double)f3, matrix3dc.m22() * (double)f4));
        return this;
    }

    public Vector3f mul(Matrix3dc matrix3dc, Vector3f vector3f) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        vector3f.x = (float)Math.fma(matrix3dc.m00(), (double)f2, Math.fma(matrix3dc.m10(), (double)f3, matrix3dc.m20() * (double)f4));
        vector3f.y = (float)Math.fma(matrix3dc.m01(), (double)f2, Math.fma(matrix3dc.m11(), (double)f3, matrix3dc.m21() * (double)f4));
        vector3f.z = (float)Math.fma(matrix3dc.m02(), (double)f2, Math.fma(matrix3dc.m12(), (double)f3, matrix3dc.m22() * (double)f4));
        return vector3f;
    }

    public Vector3f mul(Matrix3x2fc matrix3x2fc) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        this.x = Math.fma(matrix3x2fc.m00(), f2, Math.fma(matrix3x2fc.m10(), f3, matrix3x2fc.m20() * f4));
        this.y = Math.fma(matrix3x2fc.m01(), f2, Math.fma(matrix3x2fc.m11(), f3, matrix3x2fc.m21() * f4));
        this.z = f4;
        return this;
    }

    public Vector3f mul(Matrix3x2fc matrix3x2fc, Vector3f vector3f) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        vector3f.x = Math.fma(matrix3x2fc.m00(), f2, Math.fma(matrix3x2fc.m10(), f3, matrix3x2fc.m20() * f4));
        vector3f.y = Math.fma(matrix3x2fc.m01(), f2, Math.fma(matrix3x2fc.m11(), f3, matrix3x2fc.m21() * f4));
        vector3f.z = f4;
        return vector3f;
    }

    public Vector3f mulTranspose(Matrix3fc matrix3fc) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        this.x = Math.fma(matrix3fc.m00(), f2, Math.fma(matrix3fc.m01(), f3, matrix3fc.m02() * f4));
        this.y = Math.fma(matrix3fc.m10(), f2, Math.fma(matrix3fc.m11(), f3, matrix3fc.m12() * f4));
        this.z = Math.fma(matrix3fc.m20(), f2, Math.fma(matrix3fc.m21(), f3, matrix3fc.m22() * f4));
        return this;
    }

    public Vector3f mulTranspose(Matrix3fc matrix3fc, Vector3f vector3f) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        vector3f.x = Math.fma(matrix3fc.m00(), f2, Math.fma(matrix3fc.m01(), f3, matrix3fc.m02() * f4));
        vector3f.y = Math.fma(matrix3fc.m10(), f2, Math.fma(matrix3fc.m11(), f3, matrix3fc.m12() * f4));
        vector3f.z = Math.fma(matrix3fc.m20(), f2, Math.fma(matrix3fc.m21(), f3, matrix3fc.m22() * f4));
        return vector3f;
    }

    public Vector3f mulPosition(Matrix4fc matrix4fc) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        this.x = Math.fma(matrix4fc.m00(), f2, Math.fma(matrix4fc.m10(), f3, Math.fma(matrix4fc.m20(), f4, matrix4fc.m30())));
        this.y = Math.fma(matrix4fc.m01(), f2, Math.fma(matrix4fc.m11(), f3, Math.fma(matrix4fc.m21(), f4, matrix4fc.m31())));
        this.z = Math.fma(matrix4fc.m02(), f2, Math.fma(matrix4fc.m12(), f3, Math.fma(matrix4fc.m22(), f4, matrix4fc.m32())));
        return this;
    }

    public Vector3f mulPosition(Matrix4x3fc matrix4x3fc) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        this.x = Math.fma(matrix4x3fc.m00(), f2, Math.fma(matrix4x3fc.m10(), f3, Math.fma(matrix4x3fc.m20(), f4, matrix4x3fc.m30())));
        this.y = Math.fma(matrix4x3fc.m01(), f2, Math.fma(matrix4x3fc.m11(), f3, Math.fma(matrix4x3fc.m21(), f4, matrix4x3fc.m31())));
        this.z = Math.fma(matrix4x3fc.m02(), f2, Math.fma(matrix4x3fc.m12(), f3, Math.fma(matrix4x3fc.m22(), f4, matrix4x3fc.m32())));
        return this;
    }

    public Vector3f mulPosition(Matrix4fc matrix4fc, Vector3f vector3f) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        vector3f.x = Math.fma(matrix4fc.m00(), f2, Math.fma(matrix4fc.m10(), f3, Math.fma(matrix4fc.m20(), f4, matrix4fc.m30())));
        vector3f.y = Math.fma(matrix4fc.m01(), f2, Math.fma(matrix4fc.m11(), f3, Math.fma(matrix4fc.m21(), f4, matrix4fc.m31())));
        vector3f.z = Math.fma(matrix4fc.m02(), f2, Math.fma(matrix4fc.m12(), f3, Math.fma(matrix4fc.m22(), f4, matrix4fc.m32())));
        return vector3f;
    }

    public Vector3f mulPosition(Matrix4x3fc matrix4x3fc, Vector3f vector3f) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        vector3f.x = Math.fma(matrix4x3fc.m00(), f2, Math.fma(matrix4x3fc.m10(), f3, Math.fma(matrix4x3fc.m20(), f4, matrix4x3fc.m30())));
        vector3f.y = Math.fma(matrix4x3fc.m01(), f2, Math.fma(matrix4x3fc.m11(), f3, Math.fma(matrix4x3fc.m21(), f4, matrix4x3fc.m31())));
        vector3f.z = Math.fma(matrix4x3fc.m02(), f2, Math.fma(matrix4x3fc.m12(), f3, Math.fma(matrix4x3fc.m22(), f4, matrix4x3fc.m32())));
        return vector3f;
    }

    public Vector3f mulTransposePosition(Matrix4fc matrix4fc) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        this.x = Math.fma(matrix4fc.m00(), f2, Math.fma(matrix4fc.m01(), f3, Math.fma(matrix4fc.m02(), f4, matrix4fc.m03())));
        this.y = Math.fma(matrix4fc.m10(), f2, Math.fma(matrix4fc.m11(), f3, Math.fma(matrix4fc.m12(), f4, matrix4fc.m13())));
        this.z = Math.fma(matrix4fc.m20(), f2, Math.fma(matrix4fc.m21(), f3, Math.fma(matrix4fc.m22(), f4, matrix4fc.m23())));
        return this;
    }

    public Vector3f mulTransposePosition(Matrix4fc matrix4fc, Vector3f vector3f) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        vector3f.x = Math.fma(matrix4fc.m00(), f2, Math.fma(matrix4fc.m01(), f3, Math.fma(matrix4fc.m02(), f4, matrix4fc.m03())));
        vector3f.y = Math.fma(matrix4fc.m10(), f2, Math.fma(matrix4fc.m11(), f3, Math.fma(matrix4fc.m12(), f4, matrix4fc.m13())));
        vector3f.z = Math.fma(matrix4fc.m20(), f2, Math.fma(matrix4fc.m21(), f3, Math.fma(matrix4fc.m22(), f4, matrix4fc.m23())));
        return vector3f;
    }

    public float mulPositionW(Matrix4fc matrix4fc) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        float f5 = Math.fma(matrix4fc.m03(), f2, Math.fma(matrix4fc.m13(), f3, Math.fma(matrix4fc.m23(), f4, matrix4fc.m33())));
        this.x = Math.fma(matrix4fc.m00(), f2, Math.fma(matrix4fc.m10(), f3, Math.fma(matrix4fc.m20(), f4, matrix4fc.m30())));
        this.y = Math.fma(matrix4fc.m01(), f2, Math.fma(matrix4fc.m11(), f3, Math.fma(matrix4fc.m21(), f4, matrix4fc.m31())));
        this.z = Math.fma(matrix4fc.m02(), f2, Math.fma(matrix4fc.m12(), f3, Math.fma(matrix4fc.m22(), f4, matrix4fc.m32())));
        return f5;
    }

    public float mulPositionW(Matrix4fc matrix4fc, Vector3f vector3f) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        float f5 = Math.fma(matrix4fc.m03(), f2, Math.fma(matrix4fc.m13(), f3, Math.fma(matrix4fc.m23(), f4, matrix4fc.m33())));
        vector3f.x = Math.fma(matrix4fc.m00(), f2, Math.fma(matrix4fc.m10(), f3, Math.fma(matrix4fc.m20(), f4, matrix4fc.m30())));
        vector3f.y = Math.fma(matrix4fc.m01(), f2, Math.fma(matrix4fc.m11(), f3, Math.fma(matrix4fc.m21(), f4, matrix4fc.m31())));
        vector3f.z = Math.fma(matrix4fc.m02(), f2, Math.fma(matrix4fc.m12(), f3, Math.fma(matrix4fc.m22(), f4, matrix4fc.m32())));
        return f5;
    }

    public Vector3f mulDirection(Matrix4dc matrix4dc) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        this.x = (float)Math.fma(matrix4dc.m00(), (double)f2, Math.fma(matrix4dc.m10(), (double)f3, matrix4dc.m20() * (double)f4));
        this.y = (float)Math.fma(matrix4dc.m01(), (double)f2, Math.fma(matrix4dc.m11(), (double)f3, matrix4dc.m21() * (double)f4));
        this.z = (float)Math.fma(matrix4dc.m02(), (double)f2, Math.fma(matrix4dc.m12(), (double)f3, matrix4dc.m22() * (double)f4));
        return this;
    }

    public Vector3f mulDirection(Matrix4fc matrix4fc) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        this.x = Math.fma(matrix4fc.m00(), f2, Math.fma(matrix4fc.m10(), f3, matrix4fc.m20() * f4));
        this.y = Math.fma(matrix4fc.m01(), f2, Math.fma(matrix4fc.m11(), f3, matrix4fc.m21() * f4));
        this.z = Math.fma(matrix4fc.m02(), f2, Math.fma(matrix4fc.m12(), f3, matrix4fc.m22() * f4));
        return this;
    }

    public Vector3f mulDirection(Matrix4x3fc matrix4x3fc) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        this.x = Math.fma(matrix4x3fc.m00(), f2, Math.fma(matrix4x3fc.m10(), f3, matrix4x3fc.m20() * f4));
        this.y = Math.fma(matrix4x3fc.m01(), f2, Math.fma(matrix4x3fc.m11(), f3, matrix4x3fc.m21() * f4));
        this.z = Math.fma(matrix4x3fc.m02(), f2, Math.fma(matrix4x3fc.m12(), f3, matrix4x3fc.m22() * f4));
        return this;
    }

    public Vector3f mulDirection(Matrix4dc matrix4dc, Vector3f vector3f) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        vector3f.x = (float)Math.fma(matrix4dc.m00(), (double)f2, Math.fma(matrix4dc.m10(), (double)f3, matrix4dc.m20() * (double)f4));
        vector3f.y = (float)Math.fma(matrix4dc.m01(), (double)f2, Math.fma(matrix4dc.m11(), (double)f3, matrix4dc.m21() * (double)f4));
        vector3f.z = (float)Math.fma(matrix4dc.m02(), (double)f2, Math.fma(matrix4dc.m12(), (double)f3, matrix4dc.m22() * (double)f4));
        return vector3f;
    }

    public Vector3f mulDirection(Matrix4fc matrix4fc, Vector3f vector3f) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        vector3f.x = Math.fma(matrix4fc.m00(), f2, Math.fma(matrix4fc.m10(), f3, matrix4fc.m20() * f4));
        vector3f.y = Math.fma(matrix4fc.m01(), f2, Math.fma(matrix4fc.m11(), f3, matrix4fc.m21() * f4));
        vector3f.z = Math.fma(matrix4fc.m02(), f2, Math.fma(matrix4fc.m12(), f3, matrix4fc.m22() * f4));
        return vector3f;
    }

    public Vector3f mulDirection(Matrix4x3fc matrix4x3fc, Vector3f vector3f) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        vector3f.x = Math.fma(matrix4x3fc.m00(), f2, Math.fma(matrix4x3fc.m10(), f3, matrix4x3fc.m20() * f4));
        vector3f.y = Math.fma(matrix4x3fc.m01(), f2, Math.fma(matrix4x3fc.m11(), f3, matrix4x3fc.m21() * f4));
        vector3f.z = Math.fma(matrix4x3fc.m02(), f2, Math.fma(matrix4x3fc.m12(), f3, matrix4x3fc.m22() * f4));
        return vector3f;
    }

    public Vector3f mulTransposeDirection(Matrix4fc matrix4fc) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        this.x = Math.fma(matrix4fc.m00(), f2, Math.fma(matrix4fc.m01(), f3, matrix4fc.m02() * f4));
        this.y = Math.fma(matrix4fc.m10(), f2, Math.fma(matrix4fc.m11(), f3, matrix4fc.m12() * f4));
        this.z = Math.fma(matrix4fc.m20(), f2, Math.fma(matrix4fc.m21(), f3, matrix4fc.m22() * f4));
        return this;
    }

    public Vector3f mulTransposeDirection(Matrix4fc matrix4fc, Vector3f vector3f) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        vector3f.x = Math.fma(matrix4fc.m00(), f2, Math.fma(matrix4fc.m01(), f3, matrix4fc.m02() * f4));
        vector3f.y = Math.fma(matrix4fc.m10(), f2, Math.fma(matrix4fc.m11(), f3, matrix4fc.m12() * f4));
        vector3f.z = Math.fma(matrix4fc.m20(), f2, Math.fma(matrix4fc.m21(), f3, matrix4fc.m22() * f4));
        return vector3f;
    }

    public Vector3f mul(float f2) {
        this.x *= f2;
        this.y *= f2;
        this.z *= f2;
        return this;
    }

    public Vector3f mul(float f2, Vector3f vector3f) {
        vector3f.x = this.x * f2;
        vector3f.y = this.y * f2;
        vector3f.z = this.z * f2;
        return vector3f;
    }

    public Vector3f mul(float f2, float f3, float f4) {
        this.x *= f2;
        this.y *= f3;
        this.z *= f4;
        return this;
    }

    public Vector3f mul(float f2, float f3, float f4, Vector3f vector3f) {
        vector3f.x = this.x * f2;
        vector3f.y = this.y * f3;
        vector3f.z = this.z * f4;
        return vector3f;
    }

    public Vector3f div(float f2) {
        float f3 = 1.0f / f2;
        this.x *= f3;
        this.y *= f3;
        this.z *= f3;
        return this;
    }

    public Vector3f div(float f2, Vector3f vector3f) {
        float f3 = 1.0f / f2;
        vector3f.x = this.x * f3;
        vector3f.y = this.y * f3;
        vector3f.z = this.z * f3;
        return vector3f;
    }

    public Vector3f div(float f2, float f3, float f4) {
        this.x /= f2;
        this.y /= f3;
        this.z /= f4;
        return this;
    }

    public Vector3f div(float f2, float f3, float f4, Vector3f vector3f) {
        vector3f.x = this.x / f2;
        vector3f.y = this.y / f3;
        vector3f.z = this.z / f4;
        return vector3f;
    }

    public Vector3f rotate(Quaternionfc quaternionfc) {
        return quaternionfc.transform(this, this);
    }

    public Vector3f rotate(Quaternionfc quaternionfc, Vector3f vector3f) {
        return quaternionfc.transform(this, vector3f);
    }

    public Quaternionf rotationTo(Vector3fc vector3fc, Quaternionf quaternionf) {
        return quaternionf.rotationTo(this, vector3fc);
    }

    public Quaternionf rotationTo(float f2, float f3, float f4, Quaternionf quaternionf) {
        return quaternionf.rotationTo(this.x, this.y, this.z, f2, f3, f4);
    }

    public Vector3f rotateAxis(float f2, float f3, float f4, float f5) {
        if (f4 == 0.0f && f5 == 0.0f && Math.absEqualsOne(f3)) {
            return this.rotateX(f3 * f2, this);
        }
        if (f3 == 0.0f && f5 == 0.0f && Math.absEqualsOne(f4)) {
            return this.rotateY(f4 * f2, this);
        }
        if (f3 == 0.0f && f4 == 0.0f && Math.absEqualsOne(f5)) {
            return this.rotateZ(f5 * f2, this);
        }
        return this.rotateAxisInternal(f2, f3, f4, f5, this);
    }

    public Vector3f rotateAxis(float f2, float f3, float f4, float f5, Vector3f vector3f) {
        if (f4 == 0.0f && f5 == 0.0f && Math.absEqualsOne(f3)) {
            return this.rotateX(f3 * f2, vector3f);
        }
        if (f3 == 0.0f && f5 == 0.0f && Math.absEqualsOne(f4)) {
            return this.rotateY(f4 * f2, vector3f);
        }
        if (f3 == 0.0f && f4 == 0.0f && Math.absEqualsOne(f5)) {
            return this.rotateZ(f5 * f2, vector3f);
        }
        return this.rotateAxisInternal(f2, f3, f4, f5, vector3f);
    }

    private Vector3f rotateAxisInternal(float f2, float f3, float f4, float f5, Vector3f vector3f) {
        float f6 = f2 * 0.5f;
        float f7 = Math.sin(f6);
        float f8 = f3 * f7;
        float f9 = f4 * f7;
        float f10 = f5 * f7;
        float f11 = Math.cosFromSin(f7, f6);
        float f12 = f11 * f11;
        float f13 = f8 * f8;
        float f14 = f9 * f9;
        float f15 = f10 * f10;
        float f16 = f10 * f11;
        float f17 = f8 * f9;
        float f18 = f8 * f10;
        float f19 = f9 * f11;
        float f20 = f9 * f10;
        float f21 = f8 * f11;
        float f22 = this.x;
        float f23 = this.y;
        float f24 = this.z;
        vector3f.x = (f12 + f13 - f15 - f14) * f22 + (-f16 + f17 - f16 + f17) * f23 + (f19 + f18 + f18 + f19) * f24;
        vector3f.y = (f17 + f16 + f16 + f17) * f22 + (f14 - f15 + f12 - f13) * f23 + (f20 + f20 - f21 - f21) * f24;
        vector3f.z = (f18 - f19 + f18 - f19) * f22 + (f20 + f20 + f21 + f21) * f23 + (f15 - f14 - f13 + f12) * f24;
        return vector3f;
    }

    public Vector3f rotateX(float f2) {
        float f3 = Math.sin(f2);
        float f4 = Math.cosFromSin(f3, f2);
        float f5 = this.y * f4 - this.z * f3;
        float f6 = this.y * f3 + this.z * f4;
        this.y = f5;
        this.z = f6;
        return this;
    }

    public Vector3f rotateX(float f2, Vector3f vector3f) {
        float f3 = Math.sin(f2);
        float f4 = Math.cosFromSin(f3, f2);
        float f5 = this.y * f4 - this.z * f3;
        float f6 = this.y * f3 + this.z * f4;
        vector3f.x = this.x;
        vector3f.y = f5;
        vector3f.z = f6;
        return vector3f;
    }

    public Vector3f rotateY(float f2) {
        float f3 = Math.sin(f2);
        float f4 = Math.cosFromSin(f3, f2);
        float f5 = this.x * f4 + this.z * f3;
        float f6 = -this.x * f3 + this.z * f4;
        this.x = f5;
        this.z = f6;
        return this;
    }

    public Vector3f rotateY(float f2, Vector3f vector3f) {
        float f3 = Math.sin(f2);
        float f4 = Math.cosFromSin(f3, f2);
        float f5 = this.x * f4 + this.z * f3;
        float f6 = -this.x * f3 + this.z * f4;
        vector3f.x = f5;
        vector3f.y = this.y;
        vector3f.z = f6;
        return vector3f;
    }

    public Vector3f rotateZ(float f2) {
        float f3 = Math.sin(f2);
        float f4 = Math.cosFromSin(f3, f2);
        float f5 = this.x * f4 - this.y * f3;
        float f6 = this.x * f3 + this.y * f4;
        this.x = f5;
        this.y = f6;
        return this;
    }

    public Vector3f rotateZ(float f2, Vector3f vector3f) {
        float f3 = Math.sin(f2);
        float f4 = Math.cosFromSin(f3, f2);
        float f5 = this.x * f4 - this.y * f3;
        float f6 = this.x * f3 + this.y * f4;
        vector3f.x = f5;
        vector3f.y = f6;
        vector3f.z = this.z;
        return vector3f;
    }

    public float lengthSquared() {
        return Math.fma(this.x, this.x, Math.fma(this.y, this.y, this.z * this.z));
    }

    public static float lengthSquared(float f2, float f3, float f4) {
        return Math.fma(f2, f2, Math.fma(f3, f3, f4 * f4));
    }

    public float length() {
        return Math.sqrt(Math.fma(this.x, this.x, Math.fma(this.y, this.y, this.z * this.z)));
    }

    public static float length(float f2, float f3, float f4) {
        return Math.sqrt(Math.fma(f2, f2, Math.fma(f3, f3, f4 * f4)));
    }

    public Vector3f normalize() {
        float f2 = Math.invsqrt(Math.fma(this.x, this.x, Math.fma(this.y, this.y, this.z * this.z)));
        this.x *= f2;
        this.y *= f2;
        this.z *= f2;
        return this;
    }

    public Vector3f normalize(Vector3f vector3f) {
        float f2 = Math.invsqrt(Math.fma(this.x, this.x, Math.fma(this.y, this.y, this.z * this.z)));
        vector3f.x = this.x * f2;
        vector3f.y = this.y * f2;
        vector3f.z = this.z * f2;
        return vector3f;
    }

    public Vector3f normalize(float f2) {
        float f3 = Math.invsqrt(Math.fma(this.x, this.x, Math.fma(this.y, this.y, this.z * this.z))) * f2;
        this.x *= f3;
        this.y *= f3;
        this.z *= f3;
        return this;
    }

    public Vector3f normalize(float f2, Vector3f vector3f) {
        float f3 = Math.invsqrt(Math.fma(this.x, this.x, Math.fma(this.y, this.y, this.z * this.z))) * f2;
        vector3f.x = this.x * f3;
        vector3f.y = this.y * f3;
        vector3f.z = this.z * f3;
        return vector3f;
    }

    public Vector3f cross(Vector3fc vector3fc) {
        float f2 = Math.fma(this.y, vector3fc.z(), -this.z * vector3fc.y());
        float f3 = Math.fma(this.z, vector3fc.x(), -this.x * vector3fc.z());
        float f4 = Math.fma(this.x, vector3fc.y(), -this.y * vector3fc.x());
        this.x = f2;
        this.y = f3;
        this.z = f4;
        return this;
    }

    public Vector3f cross(float f2, float f3, float f4) {
        float f5 = Math.fma(this.y, f4, -this.z * f3);
        float f6 = Math.fma(this.z, f2, -this.x * f4);
        float f7 = Math.fma(this.x, f3, -this.y * f2);
        this.x = f5;
        this.y = f6;
        this.z = f7;
        return this;
    }

    public Vector3f cross(Vector3fc vector3fc, Vector3f vector3f) {
        float f2 = Math.fma(this.y, vector3fc.z(), -this.z * vector3fc.y());
        float f3 = Math.fma(this.z, vector3fc.x(), -this.x * vector3fc.z());
        float f4 = Math.fma(this.x, vector3fc.y(), -this.y * vector3fc.x());
        vector3f.x = f2;
        vector3f.y = f3;
        vector3f.z = f4;
        return vector3f;
    }

    public Vector3f cross(float f2, float f3, float f4, Vector3f vector3f) {
        float f5 = Math.fma(this.y, f4, -this.z * f3);
        float f6 = Math.fma(this.z, f2, -this.x * f4);
        float f7 = Math.fma(this.x, f3, -this.y * f2);
        vector3f.x = f5;
        vector3f.y = f6;
        vector3f.z = f7;
        return vector3f;
    }

    public float distance(Vector3fc vector3fc) {
        float f2 = this.x - vector3fc.x();
        float f3 = this.y - vector3fc.y();
        float f4 = this.z - vector3fc.z();
        return Math.sqrt(Math.fma(f2, f2, Math.fma(f3, f3, f4 * f4)));
    }

    public float distance(float f2, float f3, float f4) {
        float f5 = this.x - f2;
        float f6 = this.y - f3;
        float f7 = this.z - f4;
        return Math.sqrt(Math.fma(f5, f5, Math.fma(f6, f6, f7 * f7)));
    }

    public float distanceSquared(Vector3fc vector3fc) {
        float f2 = this.x - vector3fc.x();
        float f3 = this.y - vector3fc.y();
        float f4 = this.z - vector3fc.z();
        return Math.fma(f2, f2, Math.fma(f3, f3, f4 * f4));
    }

    public float distanceSquared(float f2, float f3, float f4) {
        float f5 = this.x - f2;
        float f6 = this.y - f3;
        float f7 = this.z - f4;
        return Math.fma(f5, f5, Math.fma(f6, f6, f7 * f7));
    }

    public static float distance(float f2, float f3, float f4, float f5, float f6, float f7) {
        return Math.sqrt(Vector3f.distanceSquared(f2, f3, f4, f5, f6, f7));
    }

    public static float distanceSquared(float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8 = f2 - f5;
        float f9 = f3 - f6;
        float f10 = f4 - f7;
        return Math.fma(f8, f8, Math.fma(f9, f9, f10 * f10));
    }

    public float dot(Vector3fc vector3fc) {
        return Math.fma(this.x, vector3fc.x(), Math.fma(this.y, vector3fc.y(), this.z * vector3fc.z()));
    }

    public float dot(float f2, float f3, float f4) {
        return Math.fma(this.x, f2, Math.fma(this.y, f3, this.z * f4));
    }

    public float angleCos(Vector3fc vector3fc) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        float f5 = Math.fma(f2, f2, Math.fma(f3, f3, f4 * f4));
        float f6 = Math.fma(vector3fc.x(), vector3fc.x(), Math.fma(vector3fc.y(), vector3fc.y(), vector3fc.z() * vector3fc.z()));
        float f7 = Math.fma(f2, vector3fc.x(), Math.fma(f3, vector3fc.y(), f4 * vector3fc.z()));
        return f7 / Math.sqrt(f5 * f6);
    }

    public float angle(Vector3fc vector3fc) {
        float f2 = this.angleCos(vector3fc);
        f2 = f2 < 1.0f ? f2 : 1.0f;
        f2 = f2 > -1.0f ? f2 : -1.0f;
        return Math.acos(f2);
    }

    public float angleSigned(Vector3fc vector3fc, Vector3fc vector3fc2) {
        return this.angleSigned(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z());
    }

    public float angleSigned(float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8 = this.x;
        float f9 = this.y;
        float f10 = this.z;
        return Math.atan2((f9 * f4 - f10 * f3) * f5 + (f10 * f2 - f8 * f4) * f6 + (f8 * f3 - f9 * f2) * f7, f8 * f2 + f9 * f3 + f10 * f4);
    }

    public Vector3f min(Vector3fc vector3fc) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        this.x = f2 < vector3fc.x() ? f2 : vector3fc.x();
        this.y = f3 < vector3fc.y() ? f3 : vector3fc.y();
        this.z = f4 < vector3fc.z() ? f4 : vector3fc.z();
        return this;
    }

    public Vector3f min(Vector3fc vector3fc, Vector3f vector3f) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        vector3f.x = f2 < vector3fc.x() ? f2 : vector3fc.x();
        vector3f.y = f3 < vector3fc.y() ? f3 : vector3fc.y();
        vector3f.z = f4 < vector3fc.z() ? f4 : vector3fc.z();
        return vector3f;
    }

    public Vector3f max(Vector3fc vector3fc) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        this.x = f2 > vector3fc.x() ? f2 : vector3fc.x();
        this.y = f3 > vector3fc.y() ? f3 : vector3fc.y();
        this.z = f4 > vector3fc.z() ? f4 : vector3fc.z();
        return this;
    }

    public Vector3f max(Vector3fc vector3fc, Vector3f vector3f) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        vector3f.x = f2 > vector3fc.x() ? f2 : vector3fc.x();
        vector3f.y = f3 > vector3fc.y() ? f3 : vector3fc.y();
        vector3f.z = f4 > vector3fc.z() ? f4 : vector3fc.z();
        return vector3f;
    }

    public Vector3f zero() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        return this;
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat numberFormat) {
        return "(" + Runtime.format(this.x, numberFormat) + " " + Runtime.format(this.y, numberFormat) + " " + Runtime.format(this.z, numberFormat) + ")";
    }

    public void writeExternal(ObjectOutput objectOutput) {
        objectOutput.writeFloat(this.x);
        objectOutput.writeFloat(this.y);
        objectOutput.writeFloat(this.z);
    }

    public void readExternal(ObjectInput objectInput) {
        this.set(objectInput.readFloat(), objectInput.readFloat(), objectInput.readFloat());
    }

    public Vector3f negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3f negate(Vector3f vector3f) {
        vector3f.x = -this.x;
        vector3f.y = -this.y;
        vector3f.z = -this.z;
        return vector3f;
    }

    public Vector3f absolute() {
        this.x = Math.abs(this.x);
        this.y = Math.abs(this.y);
        this.z = Math.abs(this.z);
        return this;
    }

    public Vector3f absolute(Vector3f vector3f) {
        vector3f.x = Math.abs(this.x);
        vector3f.y = Math.abs(this.y);
        vector3f.z = Math.abs(this.z);
        return vector3f;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + Float.floatToIntBits(this.x);
        n3 = 31 * n3 + Float.floatToIntBits(this.y);
        n3 = 31 * n3 + Float.floatToIntBits(this.z);
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Vector3f vector3f = (Vector3f)object;
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(vector3f.x)) {
            return false;
        }
        if (Float.floatToIntBits(this.y) != Float.floatToIntBits(vector3f.y)) {
            return false;
        }
        return Float.floatToIntBits(this.z) == Float.floatToIntBits(vector3f.z);
    }

    public boolean equals(Vector3fc vector3fc, float f2) {
        if (this == vector3fc) {
            return true;
        }
        if (vector3fc == null) {
            return false;
        }
        if (!(vector3fc instanceof Vector3fc)) {
            return false;
        }
        if (!Runtime.equals(this.x, vector3fc.x(), f2)) {
            return false;
        }
        if (!Runtime.equals(this.y, vector3fc.y(), f2)) {
            return false;
        }
        return Runtime.equals(this.z, vector3fc.z(), f2);
    }

    public boolean equals(float f2, float f3, float f4) {
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(f2)) {
            return false;
        }
        if (Float.floatToIntBits(this.y) != Float.floatToIntBits(f3)) {
            return false;
        }
        return Float.floatToIntBits(this.z) == Float.floatToIntBits(f4);
    }

    public Vector3f reflect(Vector3fc vector3fc) {
        float f2 = vector3fc.x();
        float f3 = vector3fc.y();
        float f4 = vector3fc.z();
        float f5 = Math.fma(this.x, f2, Math.fma(this.y, f3, this.z * f4));
        this.x -= (f5 + f5) * f2;
        this.y -= (f5 + f5) * f3;
        this.z -= (f5 + f5) * f4;
        return this;
    }

    public Vector3f reflect(float f2, float f3, float f4) {
        float f5 = Math.fma(this.x, f2, Math.fma(this.y, f3, this.z * f4));
        this.x -= (f5 + f5) * f2;
        this.y -= (f5 + f5) * f3;
        this.z -= (f5 + f5) * f4;
        return this;
    }

    public Vector3f reflect(Vector3fc vector3fc, Vector3f vector3f) {
        return this.reflect(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3f);
    }

    public Vector3f reflect(float f2, float f3, float f4, Vector3f vector3f) {
        float f5 = this.dot(f2, f3, f4);
        vector3f.x = this.x - (f5 + f5) * f2;
        vector3f.y = this.y - (f5 + f5) * f3;
        vector3f.z = this.z - (f5 + f5) * f4;
        return vector3f;
    }

    public Vector3f half(Vector3fc vector3fc) {
        return this.set(this).add(vector3fc.x(), vector3fc.y(), vector3fc.z()).normalize();
    }

    public Vector3f half(float f2, float f3, float f4) {
        return this.half(f2, f3, f4, this);
    }

    public Vector3f half(Vector3fc vector3fc, Vector3f vector3f) {
        return this.half(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3f);
    }

    public Vector3f half(float f2, float f3, float f4, Vector3f vector3f) {
        return vector3f.set(this).add(f2, f3, f4).normalize();
    }

    public Vector3f smoothStep(Vector3fc vector3fc, float f2, Vector3f vector3f) {
        float f3 = this.x;
        float f4 = this.y;
        float f5 = this.z;
        float f6 = f2 * f2;
        float f7 = f6 * f2;
        vector3f.x = (f3 + f3 - vector3fc.x() - vector3fc.x()) * f7 + (3.0f * vector3fc.x() - 3.0f * f3) * f6 + f3 * f2 + f3;
        vector3f.y = (f4 + f4 - vector3fc.y() - vector3fc.y()) * f7 + (3.0f * vector3fc.y() - 3.0f * f4) * f6 + f4 * f2 + f4;
        vector3f.z = (f5 + f5 - vector3fc.z() - vector3fc.z()) * f7 + (3.0f * vector3fc.z() - 3.0f * f5) * f6 + f5 * f2 + f5;
        return vector3f;
    }

    public Vector3f hermite(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3, float f2, Vector3f vector3f) {
        float f3 = this.x;
        float f4 = this.y;
        float f5 = this.z;
        float f6 = f2 * f2;
        float f7 = f6 * f2;
        vector3f.x = (f3 + f3 - vector3fc2.x() - vector3fc2.x() + vector3fc3.x() + vector3fc.x()) * f7 + (3.0f * vector3fc2.x() - 3.0f * f3 - vector3fc.x() - vector3fc.x() - vector3fc3.x()) * f6 + f3 * f2 + f3;
        vector3f.y = (f4 + f4 - vector3fc2.y() - vector3fc2.y() + vector3fc3.y() + vector3fc.y()) * f7 + (3.0f * vector3fc2.y() - 3.0f * f4 - vector3fc.y() - vector3fc.y() - vector3fc3.y()) * f6 + f4 * f2 + f4;
        vector3f.z = (f5 + f5 - vector3fc2.z() - vector3fc2.z() + vector3fc3.z() + vector3fc.z()) * f7 + (3.0f * vector3fc2.z() - 3.0f * f5 - vector3fc.z() - vector3fc.z() - vector3fc3.z()) * f6 + f5 * f2 + f5;
        return vector3f;
    }

    public Vector3f lerp(Vector3fc vector3fc, float f2) {
        return this.lerp(vector3fc, f2, this);
    }

    public Vector3f lerp(Vector3fc vector3fc, float f2, Vector3f vector3f) {
        vector3f.x = Math.fma(vector3fc.x() - this.x, f2, this.x);
        vector3f.y = Math.fma(vector3fc.y() - this.y, f2, this.y);
        vector3f.z = Math.fma(vector3fc.z() - this.z, f2, this.z);
        return vector3f;
    }

    public float get(int n2) {
        switch (n2) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IllegalArgumentException();
    }

    public Vector3i get(int n2, Vector3i vector3i) {
        vector3i.x = Math.roundUsing(this.x(), n2);
        vector3i.y = Math.roundUsing(this.y(), n2);
        vector3i.z = Math.roundUsing(this.z(), n2);
        return vector3i;
    }

    public Vector3f get(Vector3f vector3f) {
        vector3f.x = this.x();
        vector3f.y = this.y();
        vector3f.z = this.z();
        return vector3f;
    }

    public Vector3d get(Vector3d vector3d) {
        vector3d.x = this.x();
        vector3d.y = this.y();
        vector3d.z = this.z();
        return vector3d;
    }

    public int maxComponent() {
        float f2 = Math.abs(this.x);
        float f3 = Math.abs(this.y);
        float f4 = Math.abs(this.z);
        if (f2 >= f3 && f2 >= f4) {
            return 0;
        }
        if (f3 >= f4) {
            return 1;
        }
        return 2;
    }

    public int minComponent() {
        float f2 = Math.abs(this.x);
        float f3 = Math.abs(this.y);
        float f4 = Math.abs(this.z);
        if (f2 < f3 && f2 < f4) {
            return 0;
        }
        if (f3 < f4) {
            return 1;
        }
        return 2;
    }

    public Vector3f orthogonalize(Vector3fc vector3fc, Vector3f vector3f) {
        float f2;
        float f3;
        float f4;
        if (Math.abs(vector3fc.x()) > Math.abs(vector3fc.z())) {
            f4 = -vector3fc.y();
            f3 = vector3fc.x();
            f2 = 0.0f;
        } else {
            f4 = 0.0f;
            f3 = -vector3fc.z();
            f2 = vector3fc.y();
        }
        float f5 = Math.invsqrt(f4 * f4 + f3 * f3 + f2 * f2);
        vector3f.x = f4 * f5;
        vector3f.y = f3 * f5;
        vector3f.z = f2 * f5;
        return vector3f;
    }

    public Vector3f orthogonalize(Vector3fc vector3fc) {
        return this.orthogonalize(vector3fc, this);
    }

    public Vector3f orthogonalizeUnit(Vector3fc vector3fc, Vector3f vector3f) {
        return this.orthogonalize(vector3fc, vector3f);
    }

    public Vector3f orthogonalizeUnit(Vector3fc vector3fc) {
        return this.orthogonalizeUnit(vector3fc, this);
    }

    public Vector3f floor() {
        return this.floor(this);
    }

    public Vector3f floor(Vector3f vector3f) {
        vector3f.x = Math.floor(this.x);
        vector3f.y = Math.floor(this.y);
        vector3f.z = Math.floor(this.z);
        return vector3f;
    }

    public Vector3f ceil() {
        return this.ceil(this);
    }

    public Vector3f ceil(Vector3f vector3f) {
        vector3f.x = Math.ceil(this.x);
        vector3f.y = Math.ceil(this.y);
        vector3f.z = Math.ceil(this.z);
        return vector3f;
    }

    public Vector3f round() {
        return this.round(this);
    }

    public Vector3f round(Vector3f vector3f) {
        vector3f.x = Math.round(this.x);
        vector3f.y = Math.round(this.y);
        vector3f.z = Math.round(this.z);
        return vector3f;
    }

    public boolean isFinite() {
        return Math.isFinite(this.x) && Math.isFinite(this.y) && Math.isFinite(this.z);
    }

    public Object clone() {
        return super.clone();
    }
}

