/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.text.NumberFormat;
import org.joml.AxisAngle4d;
import org.joml.AxisAngle4f;
import org.joml.Math;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Matrix4x3d;
import org.joml.Matrix4x3dc;
import org.joml.Matrix4x3f;
import org.joml.Matrix4x3fc;
import org.joml.MemUtil;
import org.joml.Options;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionfc;
import org.joml.Runtime;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4d;
import org.joml.Vector4dc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class Quaternionf
implements Externalizable,
Cloneable,
Quaternionfc {
    private static final long serialVersionUID = 1L;
    public float x;
    public float y;
    public float z;
    public float w;

    public Quaternionf() {
        this.w = 1.0f;
    }

    public Quaternionf(double d2, double d3, double d4, double d5) {
        this.x = (float)d2;
        this.y = (float)d3;
        this.z = (float)d4;
        this.w = (float)d5;
    }

    public Quaternionf(float f2, float f3, float f4, float f5) {
        this.x = f2;
        this.y = f3;
        this.z = f4;
        this.w = f5;
    }

    public Quaternionf(Quaternionfc quaternionfc) {
        this.set(quaternionfc);
    }

    public Quaternionf(Quaterniondc quaterniondc) {
        this.set(quaterniondc);
    }

    public Quaternionf(AxisAngle4f axisAngle4f) {
        float f2 = Math.sin(axisAngle4f.angle * 0.5f);
        float f3 = Math.cosFromSin(f2, axisAngle4f.angle * 0.5f);
        this.x = axisAngle4f.x * f2;
        this.y = axisAngle4f.y * f2;
        this.z = axisAngle4f.z * f2;
        this.w = f3;
    }

    public Quaternionf(AxisAngle4d axisAngle4d) {
        double d2 = Math.sin(axisAngle4d.angle * 0.5);
        double d3 = Math.cosFromSin(d2, axisAngle4d.angle * 0.5);
        this.x = (float)(axisAngle4d.x * d2);
        this.y = (float)(axisAngle4d.y * d2);
        this.z = (float)(axisAngle4d.z * d2);
        this.w = (float)d3;
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public float z() {
        return this.z;
    }

    public float w() {
        return this.w;
    }

    public Quaternionf normalize() {
        return this.normalize(this);
    }

    public Quaternionf normalize(Quaternionf quaternionf) {
        float f2 = Math.invsqrt(Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w))));
        quaternionf.x = this.x * f2;
        quaternionf.y = this.y * f2;
        quaternionf.z = this.z * f2;
        quaternionf.w = this.w * f2;
        return quaternionf;
    }

    public Quaternionf add(float f2, float f3, float f4, float f5) {
        return this.add(f2, f3, f4, f5, this);
    }

    public Quaternionf add(float f2, float f3, float f4, float f5, Quaternionf quaternionf) {
        quaternionf.x = this.x + f2;
        quaternionf.y = this.y + f3;
        quaternionf.z = this.z + f4;
        quaternionf.w = this.w + f5;
        return quaternionf;
    }

    public Quaternionf add(Quaternionfc quaternionfc) {
        return this.add(quaternionfc, this);
    }

    public Quaternionf add(Quaternionfc quaternionfc, Quaternionf quaternionf) {
        quaternionf.x = this.x + quaternionfc.x();
        quaternionf.y = this.y + quaternionfc.y();
        quaternionf.z = this.z + quaternionfc.z();
        quaternionf.w = this.w + quaternionfc.w();
        return quaternionf;
    }

    public float dot(Quaternionf quaternionf) {
        return this.x * quaternionf.x + this.y * quaternionf.y + this.z * quaternionf.z + this.w * quaternionf.w;
    }

    public float angle() {
        return (float)(2.0 * (double)Math.safeAcos(this.w));
    }

    public Matrix3f get(Matrix3f matrix3f) {
        return matrix3f.set(this);
    }

    public Matrix3d get(Matrix3d matrix3d) {
        return matrix3d.set(this);
    }

    public Matrix4f get(Matrix4f matrix4f) {
        return matrix4f.set(this);
    }

    public Matrix4d get(Matrix4d matrix4d) {
        return matrix4d.set(this);
    }

    public Matrix4x3f get(Matrix4x3f matrix4x3f) {
        return matrix4x3f.set(this);
    }

    public Matrix4x3d get(Matrix4x3d matrix4x3d) {
        return matrix4x3d.set(this);
    }

    public AxisAngle4f get(AxisAngle4f axisAngle4f) {
        float f2;
        float f3 = this.x;
        float f4 = this.y;
        float f5 = this.z;
        float f6 = this.w;
        if (f6 > 1.0f) {
            f2 = Math.invsqrt(Math.fma(f3, f3, Math.fma(f4, f4, Math.fma(f5, f5, f6 * f6))));
            f3 *= f2;
            f4 *= f2;
            f5 *= f2;
            f6 *= f2;
        }
        axisAngle4f.angle = 2.0f * Math.acos(f6);
        f2 = Math.sqrt(1.0f - f6 * f6);
        if (f2 < 0.001f) {
            axisAngle4f.x = f3;
            axisAngle4f.y = f4;
            axisAngle4f.z = f5;
        } else {
            f2 = 1.0f / f2;
            axisAngle4f.x = f3 * f2;
            axisAngle4f.y = f4 * f2;
            axisAngle4f.z = f5 * f2;
        }
        return axisAngle4f;
    }

    public AxisAngle4d get(AxisAngle4d axisAngle4d) {
        float f2;
        float f3 = this.x;
        float f4 = this.y;
        float f5 = this.z;
        float f6 = this.w;
        if (f6 > 1.0f) {
            f2 = Math.invsqrt(Math.fma(f3, f3, Math.fma(f4, f4, Math.fma(f5, f5, f6 * f6))));
            f3 *= f2;
            f4 *= f2;
            f5 *= f2;
            f6 *= f2;
        }
        axisAngle4d.angle = 2.0f * Math.acos(f6);
        f2 = Math.sqrt(1.0f - f6 * f6);
        if (f2 < 0.001f) {
            axisAngle4d.x = f3;
            axisAngle4d.y = f4;
            axisAngle4d.z = f5;
        } else {
            f2 = 1.0f / f2;
            axisAngle4d.x = f3 * f2;
            axisAngle4d.y = f4 * f2;
            axisAngle4d.z = f5 * f2;
        }
        return axisAngle4d;
    }

    public Quaterniond get(Quaterniond quaterniond) {
        return quaterniond.set(this);
    }

    public Quaternionf get(Quaternionf quaternionf) {
        return quaternionf.set(this);
    }

    public ByteBuffer getAsMatrix3f(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.putMatrix3f(this, byteBuffer.position(), byteBuffer);
        return byteBuffer;
    }

    public FloatBuffer getAsMatrix3f(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.putMatrix3f(this, floatBuffer.position(), floatBuffer);
        return floatBuffer;
    }

    public ByteBuffer getAsMatrix4f(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.putMatrix4f(this, byteBuffer.position(), byteBuffer);
        return byteBuffer;
    }

    public FloatBuffer getAsMatrix4f(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.putMatrix4f(this, floatBuffer.position(), floatBuffer);
        return floatBuffer;
    }

    public ByteBuffer getAsMatrix4x3f(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.putMatrix4x3f(this, byteBuffer.position(), byteBuffer);
        return byteBuffer;
    }

    public FloatBuffer getAsMatrix4x3f(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.putMatrix4x3f(this, floatBuffer.position(), floatBuffer);
        return floatBuffer;
    }

    public Quaternionf set(float f2, float f3, float f4, float f5) {
        this.x = f2;
        this.y = f3;
        this.z = f4;
        this.w = f5;
        return this;
    }

    public Quaternionf set(Quaternionfc quaternionfc) {
        this.x = quaternionfc.x();
        this.y = quaternionfc.y();
        this.z = quaternionfc.z();
        this.w = quaternionfc.w();
        return this;
    }

    public Quaternionf set(Quaterniondc quaterniondc) {
        this.x = (float)quaterniondc.x();
        this.y = (float)quaterniondc.y();
        this.z = (float)quaterniondc.z();
        this.w = (float)quaterniondc.w();
        return this;
    }

    public Quaternionf set(AxisAngle4f axisAngle4f) {
        return this.setAngleAxis(axisAngle4f.angle, axisAngle4f.x, axisAngle4f.y, axisAngle4f.z);
    }

    public Quaternionf set(AxisAngle4d axisAngle4d) {
        return this.setAngleAxis(axisAngle4d.angle, axisAngle4d.x, axisAngle4d.y, axisAngle4d.z);
    }

    public Quaternionf setAngleAxis(float f2, float f3, float f4, float f5) {
        float f6 = Math.sin(f2 * 0.5f);
        this.x = f3 * f6;
        this.y = f4 * f6;
        this.z = f5 * f6;
        this.w = Math.cosFromSin(f6, f2 * 0.5f);
        return this;
    }

    public Quaternionf setAngleAxis(double d2, double d3, double d4, double d5) {
        double d6 = Math.sin(d2 * 0.5);
        this.x = (float)(d3 * d6);
        this.y = (float)(d4 * d6);
        this.z = (float)(d5 * d6);
        this.w = (float)Math.cosFromSin(d6, d2 * 0.5);
        return this;
    }

    public Quaternionf rotationAxis(AxisAngle4f axisAngle4f) {
        return this.rotationAxis(axisAngle4f.angle, axisAngle4f.x, axisAngle4f.y, axisAngle4f.z);
    }

    public Quaternionf rotationAxis(float f2, float f3, float f4, float f5) {
        float f6 = f2 / 2.0f;
        float f7 = Math.sin(f6);
        float f8 = Math.invsqrt(f3 * f3 + f4 * f4 + f5 * f5);
        return this.set(f3 * f8 * f7, f4 * f8 * f7, f5 * f8 * f7, Math.cosFromSin(f7, f6));
    }

    public Quaternionf rotationAxis(float f2, Vector3fc vector3fc) {
        return this.rotationAxis(f2, vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Quaternionf rotationX(float f2) {
        float f3 = Math.sin(f2 * 0.5f);
        float f4 = Math.cosFromSin(f3, f2 * 0.5f);
        return this.set(f3, 0.0f, 0.0f, f4);
    }

    public Quaternionf rotationY(float f2) {
        float f3 = Math.sin(f2 * 0.5f);
        float f4 = Math.cosFromSin(f3, f2 * 0.5f);
        return this.set(0.0f, f3, 0.0f, f4);
    }

    public Quaternionf rotationZ(float f2) {
        float f3 = Math.sin(f2 * 0.5f);
        float f4 = Math.cosFromSin(f3, f2 * 0.5f);
        return this.set(0.0f, 0.0f, f3, f4);
    }

    private void setFromUnnormalized(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        float f11 = f2;
        float f12 = f3;
        float f13 = f4;
        float f14 = f5;
        float f15 = f6;
        float f16 = f7;
        float f17 = f8;
        float f18 = f9;
        float f19 = f10;
        float f20 = Math.invsqrt(f2 * f2 + f3 * f3 + f4 * f4);
        float f21 = Math.invsqrt(f5 * f5 + f6 * f6 + f7 * f7);
        float f22 = Math.invsqrt(f8 * f8 + f9 * f9 + f10 * f10);
        this.setFromNormalized(f11 *= f20, f12 *= f20, f13 *= f20, f14 *= f21, f15 *= f21, f16 *= f21, f17 *= f22, f18 *= f22, f19 *= f22);
    }

    private void setFromNormalized(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        float f11 = f2 + f6 + f10;
        if (f11 >= 0.0f) {
            float f12 = Math.sqrt(f11 + 1.0f);
            this.w = f12 * 0.5f;
            f12 = 0.5f / f12;
            this.x = (f7 - f9) * f12;
            this.y = (f8 - f4) * f12;
            this.z = (f3 - f5) * f12;
        } else if (f2 >= f6 && f2 >= f10) {
            float f13 = Math.sqrt(f2 - (f6 + f10) + 1.0f);
            this.x = f13 * 0.5f;
            f13 = 0.5f / f13;
            this.y = (f5 + f3) * f13;
            this.z = (f4 + f8) * f13;
            this.w = (f7 - f9) * f13;
        } else if (f6 > f10) {
            float f14 = Math.sqrt(f6 - (f10 + f2) + 1.0f);
            this.y = f14 * 0.5f;
            f14 = 0.5f / f14;
            this.z = (f9 + f7) * f14;
            this.x = (f5 + f3) * f14;
            this.w = (f8 - f4) * f14;
        } else {
            float f15 = Math.sqrt(f10 - (f2 + f6) + 1.0f);
            this.z = f15 * 0.5f;
            f15 = 0.5f / f15;
            this.x = (f4 + f8) * f15;
            this.y = (f9 + f7) * f15;
            this.w = (f3 - f5) * f15;
        }
    }

    private void setFromUnnormalized(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        double d11 = d2;
        double d12 = d3;
        double d13 = d4;
        double d14 = d5;
        double d15 = d6;
        double d16 = d7;
        double d17 = d8;
        double d18 = d9;
        double d19 = d10;
        double d20 = Math.invsqrt(d2 * d2 + d3 * d3 + d4 * d4);
        double d21 = Math.invsqrt(d5 * d5 + d6 * d6 + d7 * d7);
        double d22 = Math.invsqrt(d8 * d8 + d9 * d9 + d10 * d10);
        this.setFromNormalized(d11 *= d20, d12 *= d20, d13 *= d20, d14 *= d21, d15 *= d21, d16 *= d21, d17 *= d22, d18 *= d22, d19 *= d22);
    }

    private void setFromNormalized(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        double d11 = d2 + d6 + d10;
        if (d11 >= 0.0) {
            double d12 = Math.sqrt(d11 + 1.0);
            this.w = (float)(d12 * 0.5);
            d12 = 0.5 / d12;
            this.x = (float)((d7 - d9) * d12);
            this.y = (float)((d8 - d4) * d12);
            this.z = (float)((d3 - d5) * d12);
        } else if (d2 >= d6 && d2 >= d10) {
            double d13 = Math.sqrt(d2 - (d6 + d10) + 1.0);
            this.x = (float)(d13 * 0.5);
            d13 = 0.5 / d13;
            this.y = (float)((d5 + d3) * d13);
            this.z = (float)((d4 + d8) * d13);
            this.w = (float)((d7 - d9) * d13);
        } else if (d6 > d10) {
            double d14 = Math.sqrt(d6 - (d10 + d2) + 1.0);
            this.y = (float)(d14 * 0.5);
            d14 = 0.5 / d14;
            this.z = (float)((d9 + d7) * d14);
            this.x = (float)((d5 + d3) * d14);
            this.w = (float)((d8 - d4) * d14);
        } else {
            double d15 = Math.sqrt(d10 - (d2 + d6) + 1.0);
            this.z = (float)(d15 * 0.5);
            d15 = 0.5 / d15;
            this.x = (float)((d4 + d8) * d15);
            this.y = (float)((d9 + d7) * d15);
            this.w = (float)((d3 - d5) * d15);
        }
    }

    public Quaternionf setFromUnnormalized(Matrix4fc matrix4fc) {
        this.setFromUnnormalized(matrix4fc.m00(), matrix4fc.m01(), matrix4fc.m02(), matrix4fc.m10(), matrix4fc.m11(), matrix4fc.m12(), matrix4fc.m20(), matrix4fc.m21(), matrix4fc.m22());
        return this;
    }

    public Quaternionf setFromUnnormalized(Matrix4x3fc matrix4x3fc) {
        this.setFromUnnormalized(matrix4x3fc.m00(), matrix4x3fc.m01(), matrix4x3fc.m02(), matrix4x3fc.m10(), matrix4x3fc.m11(), matrix4x3fc.m12(), matrix4x3fc.m20(), matrix4x3fc.m21(), matrix4x3fc.m22());
        return this;
    }

    public Quaternionf setFromUnnormalized(Matrix4x3dc matrix4x3dc) {
        this.setFromUnnormalized(matrix4x3dc.m00(), matrix4x3dc.m01(), matrix4x3dc.m02(), matrix4x3dc.m10(), matrix4x3dc.m11(), matrix4x3dc.m12(), matrix4x3dc.m20(), matrix4x3dc.m21(), matrix4x3dc.m22());
        return this;
    }

    public Quaternionf setFromNormalized(Matrix4fc matrix4fc) {
        this.setFromNormalized(matrix4fc.m00(), matrix4fc.m01(), matrix4fc.m02(), matrix4fc.m10(), matrix4fc.m11(), matrix4fc.m12(), matrix4fc.m20(), matrix4fc.m21(), matrix4fc.m22());
        return this;
    }

    public Quaternionf setFromNormalized(Matrix4x3fc matrix4x3fc) {
        this.setFromNormalized(matrix4x3fc.m00(), matrix4x3fc.m01(), matrix4x3fc.m02(), matrix4x3fc.m10(), matrix4x3fc.m11(), matrix4x3fc.m12(), matrix4x3fc.m20(), matrix4x3fc.m21(), matrix4x3fc.m22());
        return this;
    }

    public Quaternionf setFromNormalized(Matrix4x3dc matrix4x3dc) {
        this.setFromNormalized(matrix4x3dc.m00(), matrix4x3dc.m01(), matrix4x3dc.m02(), matrix4x3dc.m10(), matrix4x3dc.m11(), matrix4x3dc.m12(), matrix4x3dc.m20(), matrix4x3dc.m21(), matrix4x3dc.m22());
        return this;
    }

    public Quaternionf setFromUnnormalized(Matrix4dc matrix4dc) {
        this.setFromUnnormalized(matrix4dc.m00(), matrix4dc.m01(), matrix4dc.m02(), matrix4dc.m10(), matrix4dc.m11(), matrix4dc.m12(), matrix4dc.m20(), matrix4dc.m21(), matrix4dc.m22());
        return this;
    }

    public Quaternionf setFromNormalized(Matrix4dc matrix4dc) {
        this.setFromNormalized(matrix4dc.m00(), matrix4dc.m01(), matrix4dc.m02(), matrix4dc.m10(), matrix4dc.m11(), matrix4dc.m12(), matrix4dc.m20(), matrix4dc.m21(), matrix4dc.m22());
        return this;
    }

    public Quaternionf setFromUnnormalized(Matrix3fc matrix3fc) {
        this.setFromUnnormalized(matrix3fc.m00(), matrix3fc.m01(), matrix3fc.m02(), matrix3fc.m10(), matrix3fc.m11(), matrix3fc.m12(), matrix3fc.m20(), matrix3fc.m21(), matrix3fc.m22());
        return this;
    }

    public Quaternionf setFromNormalized(Matrix3fc matrix3fc) {
        this.setFromNormalized(matrix3fc.m00(), matrix3fc.m01(), matrix3fc.m02(), matrix3fc.m10(), matrix3fc.m11(), matrix3fc.m12(), matrix3fc.m20(), matrix3fc.m21(), matrix3fc.m22());
        return this;
    }

    public Quaternionf setFromUnnormalized(Matrix3dc matrix3dc) {
        this.setFromUnnormalized(matrix3dc.m00(), matrix3dc.m01(), matrix3dc.m02(), matrix3dc.m10(), matrix3dc.m11(), matrix3dc.m12(), matrix3dc.m20(), matrix3dc.m21(), matrix3dc.m22());
        return this;
    }

    public Quaternionf setFromNormalized(Matrix3dc matrix3dc) {
        this.setFromNormalized(matrix3dc.m00(), matrix3dc.m01(), matrix3dc.m02(), matrix3dc.m10(), matrix3dc.m11(), matrix3dc.m12(), matrix3dc.m20(), matrix3dc.m21(), matrix3dc.m22());
        return this;
    }

    public Quaternionf fromAxisAngleRad(Vector3fc vector3fc, float f2) {
        return this.fromAxisAngleRad(vector3fc.x(), vector3fc.y(), vector3fc.z(), f2);
    }

    public Quaternionf fromAxisAngleRad(float f2, float f3, float f4, float f5) {
        float f6 = f5 / 2.0f;
        float f7 = Math.sin(f6);
        float f8 = Math.sqrt(f2 * f2 + f3 * f3 + f4 * f4);
        this.x = f2 / f8 * f7;
        this.y = f3 / f8 * f7;
        this.z = f4 / f8 * f7;
        this.w = Math.cosFromSin(f7, f6);
        return this;
    }

    public Quaternionf fromAxisAngleDeg(Vector3fc vector3fc, float f2) {
        return this.fromAxisAngleRad(vector3fc.x(), vector3fc.y(), vector3fc.z(), Math.toRadians(f2));
    }

    public Quaternionf fromAxisAngleDeg(float f2, float f3, float f4, float f5) {
        return this.fromAxisAngleRad(f2, f3, f4, Math.toRadians(f5));
    }

    public Quaternionf mul(Quaternionfc quaternionfc) {
        return this.mul(quaternionfc, this);
    }

    public Quaternionf mul(Quaternionfc quaternionfc, Quaternionf quaternionf) {
        return quaternionf.set(Math.fma(this.w, quaternionfc.x(), Math.fma(this.x, quaternionfc.w(), Math.fma(this.y, quaternionfc.z(), -this.z * quaternionfc.y()))), Math.fma(this.w, quaternionfc.y(), Math.fma(-this.x, quaternionfc.z(), Math.fma(this.y, quaternionfc.w(), this.z * quaternionfc.x()))), Math.fma(this.w, quaternionfc.z(), Math.fma(this.x, quaternionfc.y(), Math.fma(-this.y, quaternionfc.x(), this.z * quaternionfc.w()))), Math.fma(this.w, quaternionfc.w(), Math.fma(-this.x, quaternionfc.x(), Math.fma(-this.y, quaternionfc.y(), -this.z * quaternionfc.z()))));
    }

    public Quaternionf mul(float f2, float f3, float f4, float f5) {
        return this.mul(f2, f3, f4, f5, this);
    }

    public Quaternionf mul(float f2, float f3, float f4, float f5, Quaternionf quaternionf) {
        return quaternionf.set(Math.fma(this.w, f2, Math.fma(this.x, f5, Math.fma(this.y, f4, -this.z * f3))), Math.fma(this.w, f3, Math.fma(-this.x, f4, Math.fma(this.y, f5, this.z * f2))), Math.fma(this.w, f4, Math.fma(this.x, f3, Math.fma(-this.y, f2, this.z * f5))), Math.fma(this.w, f5, Math.fma(-this.x, f2, Math.fma(-this.y, f3, -this.z * f4))));
    }

    public Quaternionf mul(float f2) {
        return this.mul(f2, this);
    }

    public Quaternionf mul(float f2, Quaternionf quaternionf) {
        quaternionf.x = this.x * f2;
        quaternionf.y = this.y * f2;
        quaternionf.z = this.z * f2;
        quaternionf.w = this.w * f2;
        return quaternionf;
    }

    public Quaternionf premul(Quaternionfc quaternionfc) {
        return this.premul(quaternionfc, this);
    }

    public Quaternionf premul(Quaternionfc quaternionfc, Quaternionf quaternionf) {
        return quaternionf.set(Math.fma(quaternionfc.w(), this.x, Math.fma(quaternionfc.x(), this.w, Math.fma(quaternionfc.y(), this.z, -quaternionfc.z() * this.y))), Math.fma(quaternionfc.w(), this.y, Math.fma(-quaternionfc.x(), this.z, Math.fma(quaternionfc.y(), this.w, quaternionfc.z() * this.x))), Math.fma(quaternionfc.w(), this.z, Math.fma(quaternionfc.x(), this.y, Math.fma(-quaternionfc.y(), this.x, quaternionfc.z() * this.w))), Math.fma(quaternionfc.w(), this.w, Math.fma(-quaternionfc.x(), this.x, Math.fma(-quaternionfc.y(), this.y, -quaternionfc.z() * this.z))));
    }

    public Quaternionf premul(float f2, float f3, float f4, float f5) {
        return this.premul(f2, f3, f4, f5, this);
    }

    public Quaternionf premul(float f2, float f3, float f4, float f5, Quaternionf quaternionf) {
        return quaternionf.set(Math.fma(f5, this.x, Math.fma(f2, this.w, Math.fma(f3, this.z, -f4 * this.y))), Math.fma(f5, this.y, Math.fma(-f2, this.z, Math.fma(f3, this.w, f4 * this.x))), Math.fma(f5, this.z, Math.fma(f2, this.y, Math.fma(-f3, this.x, f4 * this.w))), Math.fma(f5, this.w, Math.fma(-f2, this.x, Math.fma(-f3, this.y, -f4 * this.z))));
    }

    public Vector3f transform(Vector3f vector3f) {
        return this.transform(vector3f.x, vector3f.y, vector3f.z, vector3f);
    }

    public Vector3f transformInverse(Vector3f vector3f) {
        return this.transformInverse(vector3f.x, vector3f.y, vector3f.z, vector3f);
    }

    public Vector3f transformPositiveX(Vector3f vector3f) {
        float f2 = this.w * this.w;
        float f3 = this.x * this.x;
        float f4 = this.y * this.y;
        float f5 = this.z * this.z;
        float f6 = this.z * this.w;
        float f7 = this.x * this.y;
        float f8 = this.x * this.z;
        float f9 = this.y * this.w;
        vector3f.x = f2 + f3 - f5 - f4;
        vector3f.y = f7 + f6 + f6 + f7;
        vector3f.z = f8 - f9 + f8 - f9;
        return vector3f;
    }

    public Vector4f transformPositiveX(Vector4f vector4f) {
        float f2 = this.w * this.w;
        float f3 = this.x * this.x;
        float f4 = this.y * this.y;
        float f5 = this.z * this.z;
        float f6 = this.z * this.w;
        float f7 = this.x * this.y;
        float f8 = this.x * this.z;
        float f9 = this.y * this.w;
        vector4f.x = f2 + f3 - f5 - f4;
        vector4f.y = f7 + f6 + f6 + f7;
        vector4f.z = f8 - f9 + f8 - f9;
        return vector4f;
    }

    public Vector3f transformUnitPositiveX(Vector3f vector3f) {
        float f2 = this.x * this.y;
        float f3 = this.x * this.z;
        float f4 = this.y * this.y;
        float f5 = this.y * this.w;
        float f6 = this.z * this.z;
        float f7 = this.z * this.w;
        vector3f.x = 1.0f - f4 - f6 - f4 - f6;
        vector3f.y = f2 + f7 + f2 + f7;
        vector3f.z = f3 - f5 + f3 - f5;
        return vector3f;
    }

    public Vector4f transformUnitPositiveX(Vector4f vector4f) {
        float f2 = this.y * this.y;
        float f3 = this.z * this.z;
        float f4 = this.x * this.y;
        float f5 = this.x * this.z;
        float f6 = this.y * this.w;
        float f7 = this.z * this.w;
        vector4f.x = 1.0f - f2 - f2 - f3 - f3;
        vector4f.y = f4 + f7 + f4 + f7;
        vector4f.z = f5 - f6 + f5 - f6;
        return vector4f;
    }

    public Vector3f transformPositiveY(Vector3f vector3f) {
        float f2 = this.w * this.w;
        float f3 = this.x * this.x;
        float f4 = this.y * this.y;
        float f5 = this.z * this.z;
        float f6 = this.z * this.w;
        float f7 = this.x * this.y;
        float f8 = this.y * this.z;
        float f9 = this.x * this.w;
        vector3f.x = -f6 + f7 - f6 + f7;
        vector3f.y = f4 - f5 + f2 - f3;
        vector3f.z = f8 + f8 + f9 + f9;
        return vector3f;
    }

    public Vector4f transformPositiveY(Vector4f vector4f) {
        float f2 = this.w * this.w;
        float f3 = this.x * this.x;
        float f4 = this.y * this.y;
        float f5 = this.z * this.z;
        float f6 = this.z * this.w;
        float f7 = this.x * this.y;
        float f8 = this.y * this.z;
        float f9 = this.x * this.w;
        vector4f.x = -f6 + f7 - f6 + f7;
        vector4f.y = f4 - f5 + f2 - f3;
        vector4f.z = f8 + f8 + f9 + f9;
        return vector4f;
    }

    public Vector4f transformUnitPositiveY(Vector4f vector4f) {
        float f2 = this.x * this.x;
        float f3 = this.z * this.z;
        float f4 = this.x * this.y;
        float f5 = this.y * this.z;
        float f6 = this.x * this.w;
        float f7 = this.z * this.w;
        vector4f.x = f4 - f7 + f4 - f7;
        vector4f.y = 1.0f - f2 - f2 - f3 - f3;
        vector4f.z = f5 + f5 + f6 + f6;
        return vector4f;
    }

    public Vector3f transformUnitPositiveY(Vector3f vector3f) {
        float f2 = this.x * this.x;
        float f3 = this.z * this.z;
        float f4 = this.x * this.y;
        float f5 = this.y * this.z;
        float f6 = this.x * this.w;
        float f7 = this.z * this.w;
        vector3f.x = f4 - f7 + f4 - f7;
        vector3f.y = 1.0f - f2 - f2 - f3 - f3;
        vector3f.z = f5 + f5 + f6 + f6;
        return vector3f;
    }

    public Vector3f transformPositiveZ(Vector3f vector3f) {
        float f2 = this.w * this.w;
        float f3 = this.x * this.x;
        float f4 = this.y * this.y;
        float f5 = this.z * this.z;
        float f6 = this.x * this.z;
        float f7 = this.y * this.w;
        float f8 = this.y * this.z;
        float f9 = this.x * this.w;
        vector3f.x = f7 + f6 + f6 + f7;
        vector3f.y = f8 + f8 - f9 - f9;
        vector3f.z = f5 - f4 - f3 + f2;
        return vector3f;
    }

    public Vector4f transformPositiveZ(Vector4f vector4f) {
        float f2 = this.w * this.w;
        float f3 = this.x * this.x;
        float f4 = this.y * this.y;
        float f5 = this.z * this.z;
        float f6 = this.x * this.z;
        float f7 = this.y * this.w;
        float f8 = this.y * this.z;
        float f9 = this.x * this.w;
        vector4f.x = f7 + f6 + f6 + f7;
        vector4f.y = f8 + f8 - f9 - f9;
        vector4f.z = f5 - f4 - f3 + f2;
        return vector4f;
    }

    public Vector4f transformUnitPositiveZ(Vector4f vector4f) {
        float f2 = this.x * this.x;
        float f3 = this.y * this.y;
        float f4 = this.x * this.z;
        float f5 = this.y * this.z;
        float f6 = this.x * this.w;
        float f7 = this.y * this.w;
        vector4f.x = f4 + f7 + f4 + f7;
        vector4f.y = f5 + f5 - f6 - f6;
        vector4f.z = 1.0f - f2 - f2 - f3 - f3;
        return vector4f;
    }

    public Vector3f transformUnitPositiveZ(Vector3f vector3f) {
        float f2 = this.x * this.x;
        float f3 = this.y * this.y;
        float f4 = this.x * this.z;
        float f5 = this.y * this.z;
        float f6 = this.x * this.w;
        float f7 = this.y * this.w;
        vector3f.x = f4 + f7 + f4 + f7;
        vector3f.y = f5 + f5 - f6 - f6;
        vector3f.z = 1.0f - f2 - f2 - f3 - f3;
        return vector3f;
    }

    public Vector4f transform(Vector4f vector4f) {
        return this.transform(vector4f, vector4f);
    }

    public Vector4f transformInverse(Vector4f vector4f) {
        return this.transformInverse(vector4f, vector4f);
    }

    public Vector3f transform(Vector3fc vector3fc, Vector3f vector3f) {
        return this.transform(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3f);
    }

    public Vector3f transformInverse(Vector3fc vector3fc, Vector3f vector3f) {
        return this.transformInverse(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3f);
    }

    public Vector3f transform(float f2, float f3, float f4, Vector3f vector3f) {
        float f5 = this.x * this.x;
        float f6 = this.y * this.y;
        float f7 = this.z * this.z;
        float f8 = this.w * this.w;
        float f9 = this.x * this.y;
        float f10 = this.x * this.z;
        float f11 = this.y * this.z;
        float f12 = this.x * this.w;
        float f13 = this.z * this.w;
        float f14 = this.y * this.w;
        float f15 = 1.0f / (f5 + f6 + f7 + f8);
        return vector3f.set(Math.fma((f5 - f6 - f7 + f8) * f15, f2, Math.fma(2.0f * (f9 - f13) * f15, f3, 2.0f * (f10 + f14) * f15 * f4)), Math.fma(2.0f * (f9 + f13) * f15, f2, Math.fma((f6 - f5 - f7 + f8) * f15, f3, 2.0f * (f11 - f12) * f15 * f4)), Math.fma(2.0f * (f10 - f14) * f15, f2, Math.fma(2.0f * (f11 + f12) * f15, f3, (f7 - f5 - f6 + f8) * f15 * f4)));
    }

    public Vector3f transformInverse(float f2, float f3, float f4, Vector3f vector3f) {
        float f5 = 1.0f / Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
        float f6 = this.x * f5;
        float f7 = this.y * f5;
        float f8 = this.z * f5;
        float f9 = this.w * f5;
        float f10 = f6 * f6;
        float f11 = f7 * f7;
        float f12 = f8 * f8;
        float f13 = f9 * f9;
        float f14 = f6 * f7;
        float f15 = f6 * f8;
        float f16 = f7 * f8;
        float f17 = f6 * f9;
        float f18 = f8 * f9;
        float f19 = f7 * f9;
        float f20 = 1.0f / (f10 + f11 + f12 + f13);
        return vector3f.set(Math.fma((f10 - f11 - f12 + f13) * f20, f2, Math.fma(2.0f * (f14 + f18) * f20, f3, 2.0f * (f15 - f19) * f20 * f4)), Math.fma(2.0f * (f14 - f18) * f20, f2, Math.fma((f11 - f10 - f12 + f13) * f20, f3, 2.0f * (f16 + f17) * f20 * f4)), Math.fma(2.0f * (f15 + f19) * f20, f2, Math.fma(2.0f * (f16 - f17) * f20, f3, (f12 - f10 - f11 + f13) * f20 * f4)));
    }

    public Vector3f transformUnit(Vector3f vector3f) {
        return this.transformUnit(vector3f.x, vector3f.y, vector3f.z, vector3f);
    }

    public Vector3f transformInverseUnit(Vector3f vector3f) {
        return this.transformInverseUnit(vector3f.x, vector3f.y, vector3f.z, vector3f);
    }

    public Vector3f transformUnit(Vector3fc vector3fc, Vector3f vector3f) {
        return this.transformUnit(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3f);
    }

    public Vector3f transformInverseUnit(Vector3fc vector3fc, Vector3f vector3f) {
        return this.transformInverseUnit(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3f);
    }

    public Vector3f transformUnit(float f2, float f3, float f4, Vector3f vector3f) {
        float f5 = this.x * this.x;
        float f6 = this.x * this.y;
        float f7 = this.x * this.z;
        float f8 = this.x * this.w;
        float f9 = this.y * this.y;
        float f10 = this.y * this.z;
        float f11 = this.y * this.w;
        float f12 = this.z * this.z;
        float f13 = this.z * this.w;
        return vector3f.set(Math.fma(Math.fma(-2.0f, f9 + f12, 1.0f), f2, Math.fma(2.0f * (f6 - f13), f3, 2.0f * (f7 + f11) * f4)), Math.fma(2.0f * (f6 + f13), f2, Math.fma(Math.fma(-2.0f, f5 + f12, 1.0f), f3, 2.0f * (f10 - f8) * f4)), Math.fma(2.0f * (f7 - f11), f2, Math.fma(2.0f * (f10 + f8), f3, Math.fma(-2.0f, f5 + f9, 1.0f) * f4)));
    }

    public Vector3f transformInverseUnit(float f2, float f3, float f4, Vector3f vector3f) {
        float f5 = this.x * this.x;
        float f6 = this.x * this.y;
        float f7 = this.x * this.z;
        float f8 = this.x * this.w;
        float f9 = this.y * this.y;
        float f10 = this.y * this.z;
        float f11 = this.y * this.w;
        float f12 = this.z * this.z;
        float f13 = this.z * this.w;
        return vector3f.set(Math.fma(Math.fma(-2.0f, f9 + f12, 1.0f), f2, Math.fma(2.0f * (f6 + f13), f3, 2.0f * (f7 - f11) * f4)), Math.fma(2.0f * (f6 - f13), f2, Math.fma(Math.fma(-2.0f, f5 + f12, 1.0f), f3, 2.0f * (f10 + f8) * f4)), Math.fma(2.0f * (f7 + f11), f2, Math.fma(2.0f * (f10 - f8), f3, Math.fma(-2.0f, f5 + f9, 1.0f) * f4)));
    }

    public Vector4f transform(Vector4fc vector4fc, Vector4f vector4f) {
        return this.transform(vector4fc.x(), vector4fc.y(), vector4fc.z(), vector4f);
    }

    public Vector4f transformInverse(Vector4fc vector4fc, Vector4f vector4f) {
        return this.transformInverse(vector4fc.x(), vector4fc.y(), vector4fc.z(), vector4f);
    }

    public Vector4f transform(float f2, float f3, float f4, Vector4f vector4f) {
        float f5 = this.x * this.x;
        float f6 = this.y * this.y;
        float f7 = this.z * this.z;
        float f8 = this.w * this.w;
        float f9 = this.x * this.y;
        float f10 = this.x * this.z;
        float f11 = this.y * this.z;
        float f12 = this.x * this.w;
        float f13 = this.z * this.w;
        float f14 = this.y * this.w;
        float f15 = 1.0f / (f5 + f6 + f7 + f8);
        return vector4f.set(Math.fma((f5 - f6 - f7 + f8) * f15, f2, Math.fma(2.0f * (f9 - f13) * f15, f3, 2.0f * (f10 + f14) * f15 * f4)), Math.fma(2.0f * (f9 + f13) * f15, f2, Math.fma((f6 - f5 - f7 + f8) * f15, f3, 2.0f * (f11 - f12) * f15 * f4)), Math.fma(2.0f * (f10 - f14) * f15, f2, Math.fma(2.0f * (f11 + f12) * f15, f3, (f7 - f5 - f6 + f8) * f15 * f4)));
    }

    public Vector4f transformInverse(float f2, float f3, float f4, Vector4f vector4f) {
        float f5 = 1.0f / Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
        float f6 = this.x * f5;
        float f7 = this.y * f5;
        float f8 = this.z * f5;
        float f9 = this.w * f5;
        float f10 = f6 * f6;
        float f11 = f7 * f7;
        float f12 = f8 * f8;
        float f13 = f9 * f9;
        float f14 = f6 * f7;
        float f15 = f6 * f8;
        float f16 = f7 * f8;
        float f17 = f6 * f9;
        float f18 = f8 * f9;
        float f19 = f7 * f9;
        float f20 = 1.0f / (f10 + f11 + f12 + f13);
        return vector4f.set(Math.fma((f10 - f11 - f12 + f13) * f20, f2, Math.fma(2.0f * (f14 + f18) * f20, f3, 2.0f * (f15 - f19) * f20 * f4)), Math.fma(2.0f * (f14 - f18) * f20, f2, Math.fma((f11 - f10 - f12 + f13) * f20, f3, 2.0f * (f16 + f17) * f20 * f4)), Math.fma(2.0f * (f15 + f19) * f20, f2, Math.fma(2.0f * (f16 - f17) * f20, f3, (f12 - f10 - f11 + f13) * f20 * f4)));
    }

    public Vector3d transform(Vector3d vector3d) {
        return this.transform(vector3d.x, vector3d.y, vector3d.z, vector3d);
    }

    public Vector3d transformInverse(Vector3d vector3d) {
        return this.transformInverse(vector3d.x, vector3d.y, vector3d.z, vector3d);
    }

    public Vector4f transformUnit(Vector4f vector4f) {
        return this.transformUnit(vector4f.x, vector4f.y, vector4f.z, vector4f);
    }

    public Vector4f transformInverseUnit(Vector4f vector4f) {
        return this.transformInverseUnit(vector4f.x, vector4f.y, vector4f.z, vector4f);
    }

    public Vector4f transformUnit(Vector4fc vector4fc, Vector4f vector4f) {
        return this.transformUnit(vector4fc.x(), vector4fc.y(), vector4fc.z(), vector4f);
    }

    public Vector4f transformInverseUnit(Vector4fc vector4fc, Vector4f vector4f) {
        return this.transformInverseUnit(vector4fc.x(), vector4fc.y(), vector4fc.z(), vector4f);
    }

    public Vector4f transformUnit(float f2, float f3, float f4, Vector4f vector4f) {
        float f5 = this.x * this.x;
        float f6 = this.x * this.y;
        float f7 = this.x * this.z;
        float f8 = this.x * this.w;
        float f9 = this.y * this.y;
        float f10 = this.y * this.z;
        float f11 = this.y * this.w;
        float f12 = this.z * this.z;
        float f13 = this.z * this.w;
        return vector4f.set(Math.fma(Math.fma(-2.0f, f9 + f12, 1.0f), f2, Math.fma(2.0f * (f6 - f13), f3, 2.0f * (f7 + f11) * f4)), Math.fma(2.0f * (f6 + f13), f2, Math.fma(Math.fma(-2.0f, f5 + f12, 1.0f), f3, 2.0f * (f10 - f8) * f4)), Math.fma(2.0f * (f7 - f11), f2, Math.fma(2.0f * (f10 + f8), f3, Math.fma(-2.0f, f5 + f9, 1.0f) * f4)));
    }

    public Vector4f transformInverseUnit(float f2, float f3, float f4, Vector4f vector4f) {
        float f5 = this.x * this.x;
        float f6 = this.x * this.y;
        float f7 = this.x * this.z;
        float f8 = this.x * this.w;
        float f9 = this.y * this.y;
        float f10 = this.y * this.z;
        float f11 = this.y * this.w;
        float f12 = this.z * this.z;
        float f13 = this.z * this.w;
        return vector4f.set(Math.fma(Math.fma(-2.0f, f9 + f12, 1.0f), f2, Math.fma(2.0f * (f6 + f13), f3, 2.0f * (f7 - f11) * f4)), Math.fma(2.0f * (f6 - f13), f2, Math.fma(Math.fma(-2.0f, f5 + f12, 1.0f), f3, 2.0f * (f10 + f8) * f4)), Math.fma(2.0f * (f7 + f11), f2, Math.fma(2.0f * (f10 - f8), f3, Math.fma(-2.0f, f5 + f9, 1.0f) * f4)));
    }

    public Vector3d transformPositiveX(Vector3d vector3d) {
        float f2 = this.w * this.w;
        float f3 = this.x * this.x;
        float f4 = this.y * this.y;
        float f5 = this.z * this.z;
        float f6 = this.z * this.w;
        float f7 = this.x * this.y;
        float f8 = this.x * this.z;
        float f9 = this.y * this.w;
        vector3d.x = f2 + f3 - f5 - f4;
        vector3d.y = f7 + f6 + f6 + f7;
        vector3d.z = f8 - f9 + f8 - f9;
        return vector3d;
    }

    public Vector4d transformPositiveX(Vector4d vector4d) {
        float f2 = this.w * this.w;
        float f3 = this.x * this.x;
        float f4 = this.y * this.y;
        float f5 = this.z * this.z;
        float f6 = this.z * this.w;
        float f7 = this.x * this.y;
        float f8 = this.x * this.z;
        float f9 = this.y * this.w;
        vector4d.x = f2 + f3 - f5 - f4;
        vector4d.y = f7 + f6 + f6 + f7;
        vector4d.z = f8 - f9 + f8 - f9;
        return vector4d;
    }

    public Vector3d transformUnitPositiveX(Vector3d vector3d) {
        float f2 = this.y * this.y;
        float f3 = this.z * this.z;
        float f4 = this.x * this.y;
        float f5 = this.x * this.z;
        float f6 = this.y * this.w;
        float f7 = this.z * this.w;
        vector3d.x = 1.0f - f2 - f2 - f3 - f3;
        vector3d.y = f4 + f7 + f4 + f7;
        vector3d.z = f5 - f6 + f5 - f6;
        return vector3d;
    }

    public Vector4d transformUnitPositiveX(Vector4d vector4d) {
        float f2 = this.y * this.y;
        float f3 = this.z * this.z;
        float f4 = this.x * this.y;
        float f5 = this.x * this.z;
        float f6 = this.y * this.w;
        float f7 = this.z * this.w;
        vector4d.x = 1.0f - f2 - f2 - f3 - f3;
        vector4d.y = f4 + f7 + f4 + f7;
        vector4d.z = f5 - f6 + f5 - f6;
        return vector4d;
    }

    public Vector3d transformPositiveY(Vector3d vector3d) {
        float f2 = this.w * this.w;
        float f3 = this.x * this.x;
        float f4 = this.y * this.y;
        float f5 = this.z * this.z;
        float f6 = this.z * this.w;
        float f7 = this.x * this.y;
        float f8 = this.y * this.z;
        float f9 = this.x * this.w;
        vector3d.x = -f6 + f7 - f6 + f7;
        vector3d.y = f4 - f5 + f2 - f3;
        vector3d.z = f8 + f8 + f9 + f9;
        return vector3d;
    }

    public Vector4d transformPositiveY(Vector4d vector4d) {
        float f2 = this.w * this.w;
        float f3 = this.x * this.x;
        float f4 = this.y * this.y;
        float f5 = this.z * this.z;
        float f6 = this.z * this.w;
        float f7 = this.x * this.y;
        float f8 = this.y * this.z;
        float f9 = this.x * this.w;
        vector4d.x = -f6 + f7 - f6 + f7;
        vector4d.y = f4 - f5 + f2 - f3;
        vector4d.z = f8 + f8 + f9 + f9;
        return vector4d;
    }

    public Vector4d transformUnitPositiveY(Vector4d vector4d) {
        float f2 = this.x * this.x;
        float f3 = this.z * this.z;
        float f4 = this.x * this.y;
        float f5 = this.y * this.z;
        float f6 = this.x * this.w;
        float f7 = this.z * this.w;
        vector4d.x = f4 - f7 + f4 - f7;
        vector4d.y = 1.0f - f2 - f2 - f3 - f3;
        vector4d.z = f5 + f5 + f6 + f6;
        return vector4d;
    }

    public Vector3d transformUnitPositiveY(Vector3d vector3d) {
        float f2 = this.x * this.x;
        float f3 = this.z * this.z;
        float f4 = this.x * this.y;
        float f5 = this.y * this.z;
        float f6 = this.x * this.w;
        float f7 = this.z * this.w;
        vector3d.x = f4 - f7 + f4 - f7;
        vector3d.y = 1.0f - f2 - f2 - f3 - f3;
        vector3d.z = f5 + f5 + f6 + f6;
        return vector3d;
    }

    public Vector3d transformPositiveZ(Vector3d vector3d) {
        float f2 = this.w * this.w;
        float f3 = this.x * this.x;
        float f4 = this.y * this.y;
        float f5 = this.z * this.z;
        float f6 = this.x * this.z;
        float f7 = this.y * this.w;
        float f8 = this.y * this.z;
        float f9 = this.x * this.w;
        vector3d.x = f7 + f6 + f6 + f7;
        vector3d.y = f8 + f8 - f9 - f9;
        vector3d.z = f5 - f4 - f3 + f2;
        return vector3d;
    }

    public Vector4d transformPositiveZ(Vector4d vector4d) {
        float f2 = this.w * this.w;
        float f3 = this.x * this.x;
        float f4 = this.y * this.y;
        float f5 = this.z * this.z;
        float f6 = this.x * this.z;
        float f7 = this.y * this.w;
        float f8 = this.y * this.z;
        float f9 = this.x * this.w;
        vector4d.x = f7 + f6 + f6 + f7;
        vector4d.y = f8 + f8 - f9 - f9;
        vector4d.z = f5 - f4 - f3 + f2;
        return vector4d;
    }

    public Vector4d transformUnitPositiveZ(Vector4d vector4d) {
        float f2 = this.x * this.x;
        float f3 = this.y * this.y;
        float f4 = this.x * this.z;
        float f5 = this.y * this.z;
        float f6 = this.x * this.w;
        float f7 = this.y * this.w;
        vector4d.x = f4 + f7 + f4 + f7;
        vector4d.y = f5 + f5 - f6 - f6;
        vector4d.z = 1.0f - f2 - f2 - f3 - f3;
        return vector4d;
    }

    public Vector3d transformUnitPositiveZ(Vector3d vector3d) {
        float f2 = this.x * this.x;
        float f3 = this.y * this.y;
        float f4 = this.x * this.z;
        float f5 = this.y * this.z;
        float f6 = this.x * this.w;
        float f7 = this.y * this.w;
        vector3d.x = f4 + f7 + f4 + f7;
        vector3d.y = f5 + f5 - f6 - f6;
        vector3d.z = 1.0f - f2 - f2 - f3 - f3;
        return vector3d;
    }

    public Vector4d transform(Vector4d vector4d) {
        return this.transform(vector4d, vector4d);
    }

    public Vector4d transformInverse(Vector4d vector4d) {
        return this.transformInverse(vector4d, vector4d);
    }

    public Vector3d transform(Vector3dc vector3dc, Vector3d vector3d) {
        return this.transform(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3d);
    }

    public Vector3d transformInverse(Vector3dc vector3dc, Vector3d vector3d) {
        return this.transformInverse(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3d);
    }

    public Vector3d transform(float f2, float f3, float f4, Vector3d vector3d) {
        return this.transform((double)f2, (double)f3, (double)f4, vector3d);
    }

    public Vector3d transformInverse(float f2, float f3, float f4, Vector3d vector3d) {
        return this.transformInverse((double)f2, (double)f3, (double)f4, vector3d);
    }

    public Vector3d transform(double d2, double d3, double d4, Vector3d vector3d) {
        float f2 = this.x * this.x;
        float f3 = this.y * this.y;
        float f4 = this.z * this.z;
        float f5 = this.w * this.w;
        float f6 = this.x * this.y;
        float f7 = this.x * this.z;
        float f8 = this.y * this.z;
        float f9 = this.x * this.w;
        float f10 = this.z * this.w;
        float f11 = this.y * this.w;
        float f12 = 1.0f / (f2 + f3 + f4 + f5);
        return vector3d.set(Math.fma((double)((f2 - f3 - f4 + f5) * f12), d2, Math.fma((double)(2.0f * (f6 - f10) * f12), d3, (double)(2.0f * (f7 + f11) * f12) * d4)), Math.fma((double)(2.0f * (f6 + f10) * f12), d2, Math.fma((double)((f3 - f2 - f4 + f5) * f12), d3, (double)(2.0f * (f8 - f9) * f12) * d4)), Math.fma((double)(2.0f * (f7 - f11) * f12), d2, Math.fma((double)(2.0f * (f8 + f9) * f12), d3, (double)((f4 - f2 - f3 + f5) * f12) * d4)));
    }

    public Vector3d transformInverse(double d2, double d3, double d4, Vector3d vector3d) {
        float f2 = 1.0f / Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
        float f3 = this.x * f2;
        float f4 = this.y * f2;
        float f5 = this.z * f2;
        float f6 = this.w * f2;
        float f7 = f3 * f3;
        float f8 = f4 * f4;
        float f9 = f5 * f5;
        float f10 = f6 * f6;
        float f11 = f3 * f4;
        float f12 = f3 * f5;
        float f13 = f4 * f5;
        float f14 = f3 * f6;
        float f15 = f5 * f6;
        float f16 = f4 * f6;
        float f17 = 1.0f / (f7 + f8 + f9 + f10);
        return vector3d.set(Math.fma((double)((f7 - f8 - f9 + f10) * f17), d2, Math.fma((double)(2.0f * (f11 + f15) * f17), d3, (double)(2.0f * (f12 - f16) * f17) * d4)), Math.fma((double)(2.0f * (f11 - f15) * f17), d2, Math.fma((double)((f8 - f7 - f9 + f10) * f17), d3, (double)(2.0f * (f13 + f14) * f17) * d4)), Math.fma((double)(2.0f * (f12 + f16) * f17), d2, Math.fma((double)(2.0f * (f13 - f14) * f17), d3, (double)((f9 - f7 - f8 + f10) * f17) * d4)));
    }

    public Vector4d transform(Vector4dc vector4dc, Vector4d vector4d) {
        return this.transform(vector4dc.x(), vector4dc.y(), vector4dc.z(), vector4d);
    }

    public Vector4d transformInverse(Vector4dc vector4dc, Vector4d vector4d) {
        return this.transformInverse(vector4dc.x(), vector4dc.y(), vector4dc.z(), vector4d);
    }

    public Vector4d transform(double d2, double d3, double d4, Vector4d vector4d) {
        float f2 = this.x * this.x;
        float f3 = this.y * this.y;
        float f4 = this.z * this.z;
        float f5 = this.w * this.w;
        float f6 = this.x * this.y;
        float f7 = this.x * this.z;
        float f8 = this.y * this.z;
        float f9 = this.x * this.w;
        float f10 = this.z * this.w;
        float f11 = this.y * this.w;
        float f12 = 1.0f / (f2 + f3 + f4 + f5);
        return vector4d.set(Math.fma((double)((f2 - f3 - f4 + f5) * f12), d2, Math.fma((double)(2.0f * (f6 - f10) * f12), d3, (double)(2.0f * (f7 + f11) * f12) * d4)), Math.fma((double)(2.0f * (f6 + f10) * f12), d2, Math.fma((double)((f3 - f2 - f4 + f5) * f12), d3, (double)(2.0f * (f8 - f9) * f12) * d4)), Math.fma((double)(2.0f * (f7 - f11) * f12), d2, Math.fma((double)(2.0f * (f8 + f9) * f12), d3, (double)((f4 - f2 - f3 + f5) * f12) * d4)));
    }

    public Vector4d transformInverse(double d2, double d3, double d4, Vector4d vector4d) {
        float f2 = 1.0f / Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
        float f3 = this.x * f2;
        float f4 = this.y * f2;
        float f5 = this.z * f2;
        float f6 = this.w * f2;
        float f7 = f3 * f3;
        float f8 = f4 * f4;
        float f9 = f5 * f5;
        float f10 = f6 * f6;
        float f11 = f3 * f4;
        float f12 = f3 * f5;
        float f13 = f4 * f5;
        float f14 = f3 * f6;
        float f15 = f5 * f6;
        float f16 = f4 * f6;
        float f17 = 1.0f / (f7 + f8 + f9 + f10);
        return vector4d.set(Math.fma((double)((f7 - f8 - f9 + f10) * f17), d2, Math.fma((double)(2.0f * (f11 + f15) * f17), d3, (double)(2.0f * (f12 - f16) * f17) * d4)), Math.fma((double)(2.0f * (f11 - f15) * f17), d2, Math.fma((double)((f8 - f7 - f9 + f10) * f17), d3, (double)(2.0f * (f13 + f14) * f17) * d4)), Math.fma((double)(2.0f * (f12 + f16) * f17), d2, Math.fma((double)(2.0f * (f13 - f14) * f17), d3, (double)((f9 - f7 - f8 + f10) * f17) * d4)));
    }

    public Vector4d transformUnit(Vector4d vector4d) {
        return this.transformUnit(vector4d, vector4d);
    }

    public Vector4d transformInverseUnit(Vector4d vector4d) {
        return this.transformInverseUnit(vector4d, vector4d);
    }

    public Vector3d transformUnit(Vector3dc vector3dc, Vector3d vector3d) {
        return this.transformUnit(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3d);
    }

    public Vector3d transformInverseUnit(Vector3dc vector3dc, Vector3d vector3d) {
        return this.transformInverseUnit(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3d);
    }

    public Vector3d transformUnit(float f2, float f3, float f4, Vector3d vector3d) {
        return this.transformUnit((double)f2, (double)f3, (double)f4, vector3d);
    }

    public Vector3d transformInverseUnit(float f2, float f3, float f4, Vector3d vector3d) {
        return this.transformInverseUnit((double)f2, (double)f3, (double)f4, vector3d);
    }

    public Vector3d transformUnit(double d2, double d3, double d4, Vector3d vector3d) {
        float f2 = this.x * this.x;
        float f3 = this.x * this.y;
        float f4 = this.x * this.z;
        float f5 = this.x * this.w;
        float f6 = this.y * this.y;
        float f7 = this.y * this.z;
        float f8 = this.y * this.w;
        float f9 = this.z * this.z;
        float f10 = this.z * this.w;
        return vector3d.set(Math.fma((double)Math.fma(-2.0f, f6 + f9, 1.0f), d2, Math.fma((double)(2.0f * (f3 - f10)), d3, (double)(2.0f * (f4 + f8)) * d4)), Math.fma((double)(2.0f * (f3 + f10)), d2, Math.fma((double)Math.fma(-2.0f, f2 + f9, 1.0f), d3, (double)(2.0f * (f7 - f5)) * d4)), Math.fma((double)(2.0f * (f4 - f8)), d2, Math.fma((double)(2.0f * (f7 + f5)), d3, (double)Math.fma(-2.0f, f2 + f6, 1.0f) * d4)));
    }

    public Vector3d transformInverseUnit(double d2, double d3, double d4, Vector3d vector3d) {
        float f2 = this.x * this.x;
        float f3 = this.x * this.y;
        float f4 = this.x * this.z;
        float f5 = this.x * this.w;
        float f6 = this.y * this.y;
        float f7 = this.y * this.z;
        float f8 = this.y * this.w;
        float f9 = this.z * this.z;
        float f10 = this.z * this.w;
        return vector3d.set(Math.fma((double)Math.fma(-2.0f, f6 + f9, 1.0f), d2, Math.fma((double)(2.0f * (f3 + f10)), d3, (double)(2.0f * (f4 - f8)) * d4)), Math.fma((double)(2.0f * (f3 - f10)), d2, Math.fma((double)Math.fma(-2.0f, f2 + f9, 1.0f), d3, (double)(2.0f * (f7 + f5)) * d4)), Math.fma((double)(2.0f * (f4 + f8)), d2, Math.fma((double)(2.0f * (f7 - f5)), d3, (double)Math.fma(-2.0f, f2 + f6, 1.0f) * d4)));
    }

    public Vector4d transformUnit(Vector4dc vector4dc, Vector4d vector4d) {
        return this.transformUnit(vector4dc.x(), vector4dc.y(), vector4dc.z(), vector4d);
    }

    public Vector4d transformInverseUnit(Vector4dc vector4dc, Vector4d vector4d) {
        return this.transformInverseUnit(vector4dc.x(), vector4dc.y(), vector4dc.z(), vector4d);
    }

    public Vector4d transformUnit(double d2, double d3, double d4, Vector4d vector4d) {
        float f2 = this.x * this.x;
        float f3 = this.x * this.y;
        float f4 = this.x * this.z;
        float f5 = this.x * this.w;
        float f6 = this.y * this.y;
        float f7 = this.y * this.z;
        float f8 = this.y * this.w;
        float f9 = this.z * this.z;
        float f10 = this.z * this.w;
        return vector4d.set(Math.fma((double)Math.fma(-2.0f, f6 + f9, 1.0f), d2, Math.fma((double)(2.0f * (f3 - f10)), d3, (double)(2.0f * (f4 + f8)) * d4)), Math.fma((double)(2.0f * (f3 + f10)), d2, Math.fma((double)Math.fma(-2.0f, f2 + f9, 1.0f), d3, (double)(2.0f * (f7 - f5)) * d4)), Math.fma((double)(2.0f * (f4 - f8)), d2, Math.fma((double)(2.0f * (f7 + f5)), d3, (double)Math.fma(-2.0f, f2 + f6, 1.0f) * d4)));
    }

    public Vector4d transformInverseUnit(double d2, double d3, double d4, Vector4d vector4d) {
        float f2 = this.x * this.x;
        float f3 = this.x * this.y;
        float f4 = this.x * this.z;
        float f5 = this.x * this.w;
        float f6 = this.y * this.y;
        float f7 = this.y * this.z;
        float f8 = this.y * this.w;
        float f9 = this.z * this.z;
        float f10 = this.z * this.w;
        return vector4d.set(Math.fma((double)Math.fma(-2.0f, f6 + f9, 1.0f), d2, Math.fma((double)(2.0f * (f3 + f10)), d3, (double)(2.0f * (f4 - f8)) * d4)), Math.fma((double)(2.0f * (f3 - f10)), d2, Math.fma((double)Math.fma(-2.0f, f2 + f9, 1.0f), d3, (double)(2.0f * (f7 + f5)) * d4)), Math.fma((double)(2.0f * (f4 + f8)), d2, Math.fma((double)(2.0f * (f7 - f5)), d3, (double)Math.fma(-2.0f, f2 + f6, 1.0f) * d4)));
    }

    public Quaternionf invert(Quaternionf quaternionf) {
        float f2 = 1.0f / Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
        quaternionf.x = -this.x * f2;
        quaternionf.y = -this.y * f2;
        quaternionf.z = -this.z * f2;
        quaternionf.w = this.w * f2;
        return quaternionf;
    }

    public Quaternionf invert() {
        return this.invert(this);
    }

    public Quaternionf div(Quaternionfc quaternionfc, Quaternionf quaternionf) {
        float f2 = 1.0f / Math.fma(quaternionfc.x(), quaternionfc.x(), Math.fma(quaternionfc.y(), quaternionfc.y(), Math.fma(quaternionfc.z(), quaternionfc.z(), quaternionfc.w() * quaternionfc.w())));
        float f3 = -quaternionfc.x() * f2;
        float f4 = -quaternionfc.y() * f2;
        float f5 = -quaternionfc.z() * f2;
        float f6 = quaternionfc.w() * f2;
        return quaternionf.set(Math.fma(this.w, f3, Math.fma(this.x, f6, Math.fma(this.y, f5, -this.z * f4))), Math.fma(this.w, f4, Math.fma(-this.x, f5, Math.fma(this.y, f6, this.z * f3))), Math.fma(this.w, f5, Math.fma(this.x, f4, Math.fma(-this.y, f3, this.z * f6))), Math.fma(this.w, f6, Math.fma(-this.x, f3, Math.fma(-this.y, f4, -this.z * f5))));
    }

    public Quaternionf div(Quaternionfc quaternionfc) {
        return this.div(quaternionfc, this);
    }

    public Quaternionf conjugate() {
        return this.conjugate(this);
    }

    public Quaternionf conjugate(Quaternionf quaternionf) {
        quaternionf.x = -this.x;
        quaternionf.y = -this.y;
        quaternionf.z = -this.z;
        quaternionf.w = this.w;
        return quaternionf;
    }

    public Quaternionf identity() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.w = 1.0f;
        return this;
    }

    public Quaternionf rotateXYZ(float f2, float f3, float f4) {
        return this.rotateXYZ(f2, f3, f4, this);
    }

    public Quaternionf rotateXYZ(float f2, float f3, float f4, Quaternionf quaternionf) {
        float f5 = Math.sin(f2 * 0.5f);
        float f6 = Math.cosFromSin(f5, f2 * 0.5f);
        float f7 = Math.sin(f3 * 0.5f);
        float f8 = Math.cosFromSin(f7, f3 * 0.5f);
        float f9 = Math.sin(f4 * 0.5f);
        float f10 = Math.cosFromSin(f9, f4 * 0.5f);
        float f11 = f8 * f10;
        float f12 = f7 * f9;
        float f13 = f7 * f10;
        float f14 = f8 * f9;
        float f15 = f6 * f11 - f5 * f12;
        float f16 = f5 * f11 + f6 * f12;
        float f17 = f6 * f13 - f5 * f14;
        float f18 = f6 * f14 + f5 * f13;
        return quaternionf.set(Math.fma(this.w, f16, Math.fma(this.x, f15, Math.fma(this.y, f18, -this.z * f17))), Math.fma(this.w, f17, Math.fma(-this.x, f18, Math.fma(this.y, f15, this.z * f16))), Math.fma(this.w, f18, Math.fma(this.x, f17, Math.fma(-this.y, f16, this.z * f15))), Math.fma(this.w, f15, Math.fma(-this.x, f16, Math.fma(-this.y, f17, -this.z * f18))));
    }

    public Quaternionf rotateZYX(float f2, float f3, float f4) {
        return this.rotateZYX(f2, f3, f4, this);
    }

    public Quaternionf rotateZYX(float f2, float f3, float f4, Quaternionf quaternionf) {
        float f5 = Math.sin(f4 * 0.5f);
        float f6 = Math.cosFromSin(f5, f4 * 0.5f);
        float f7 = Math.sin(f3 * 0.5f);
        float f8 = Math.cosFromSin(f7, f3 * 0.5f);
        float f9 = Math.sin(f2 * 0.5f);
        float f10 = Math.cosFromSin(f9, f2 * 0.5f);
        float f11 = f8 * f10;
        float f12 = f7 * f9;
        float f13 = f7 * f10;
        float f14 = f8 * f9;
        float f15 = f6 * f11 + f5 * f12;
        float f16 = f5 * f11 - f6 * f12;
        float f17 = f6 * f13 + f5 * f14;
        float f18 = f6 * f14 - f5 * f13;
        return quaternionf.set(Math.fma(this.w, f16, Math.fma(this.x, f15, Math.fma(this.y, f18, -this.z * f17))), Math.fma(this.w, f17, Math.fma(-this.x, f18, Math.fma(this.y, f15, this.z * f16))), Math.fma(this.w, f18, Math.fma(this.x, f17, Math.fma(-this.y, f16, this.z * f15))), Math.fma(this.w, f15, Math.fma(-this.x, f16, Math.fma(-this.y, f17, -this.z * f18))));
    }

    public Quaternionf rotateYXZ(float f2, float f3, float f4) {
        return this.rotateYXZ(f2, f3, f4, this);
    }

    public Quaternionf rotateYXZ(float f2, float f3, float f4, Quaternionf quaternionf) {
        float f5 = Math.sin(f3 * 0.5f);
        float f6 = Math.cosFromSin(f5, f3 * 0.5f);
        float f7 = Math.sin(f2 * 0.5f);
        float f8 = Math.cosFromSin(f7, f2 * 0.5f);
        float f9 = Math.sin(f4 * 0.5f);
        float f10 = Math.cosFromSin(f9, f4 * 0.5f);
        float f11 = f8 * f5;
        float f12 = f7 * f6;
        float f13 = f7 * f5;
        float f14 = f8 * f6;
        float f15 = f11 * f10 + f12 * f9;
        float f16 = f12 * f10 - f11 * f9;
        float f17 = f14 * f9 - f13 * f10;
        float f18 = f14 * f10 + f13 * f9;
        return quaternionf.set(Math.fma(this.w, f15, Math.fma(this.x, f18, Math.fma(this.y, f17, -this.z * f16))), Math.fma(this.w, f16, Math.fma(-this.x, f17, Math.fma(this.y, f18, this.z * f15))), Math.fma(this.w, f17, Math.fma(this.x, f16, Math.fma(-this.y, f15, this.z * f18))), Math.fma(this.w, f18, Math.fma(-this.x, f15, Math.fma(-this.y, f16, -this.z * f17))));
    }

    public Vector3f getEulerAnglesXYZ(Vector3f vector3f) {
        vector3f.x = Math.atan2(this.x * this.w - this.y * this.z, 0.5f - this.x * this.x - this.y * this.y);
        vector3f.y = Math.safeAsin(2.0f * (this.x * this.z + this.y * this.w));
        vector3f.z = Math.atan2(this.z * this.w - this.x * this.y, 0.5f - this.y * this.y - this.z * this.z);
        return vector3f;
    }

    public Vector3f getEulerAnglesZYX(Vector3f vector3f) {
        vector3f.x = Math.atan2(this.y * this.z + this.w * this.x, 0.5f - this.x * this.x + this.y * this.y);
        vector3f.y = Math.safeAsin(-2.0f * (this.x * this.z - this.w * this.y));
        vector3f.z = Math.atan2(this.x * this.y + this.w * this.z, 0.5f - this.y * this.y - this.z * this.z);
        return vector3f;
    }

    public Vector3f getEulerAnglesZXY(Vector3f vector3f) {
        vector3f.x = Math.safeAsin(2.0f * (this.w * this.x + this.y * this.z));
        vector3f.y = Math.atan2(this.w * this.y - this.x * this.z, 0.5f - this.y * this.y - this.x * this.x);
        vector3f.z = Math.atan2(this.w * this.z - this.x * this.y, 0.5f - this.z * this.z - this.x * this.x);
        return vector3f;
    }

    public Vector3f getEulerAnglesYXZ(Vector3f vector3f) {
        vector3f.x = Math.safeAsin(-2.0f * (this.y * this.z - this.w * this.x));
        vector3f.y = Math.atan2(this.x * this.z + this.y * this.w, 0.5f - this.y * this.y - this.x * this.x);
        vector3f.z = Math.atan2(this.y * this.x + this.w * this.z, 0.5f - this.x * this.x - this.z * this.z);
        return vector3f;
    }

    public float lengthSquared() {
        return Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
    }

    public Quaternionf rotationXYZ(float f2, float f3, float f4) {
        float f5 = Math.sin(f2 * 0.5f);
        float f6 = Math.cosFromSin(f5, f2 * 0.5f);
        float f7 = Math.sin(f3 * 0.5f);
        float f8 = Math.cosFromSin(f7, f3 * 0.5f);
        float f9 = Math.sin(f4 * 0.5f);
        float f10 = Math.cosFromSin(f9, f4 * 0.5f);
        float f11 = f8 * f10;
        float f12 = f7 * f9;
        float f13 = f7 * f10;
        float f14 = f8 * f9;
        this.w = f6 * f11 - f5 * f12;
        this.x = f5 * f11 + f6 * f12;
        this.y = f6 * f13 - f5 * f14;
        this.z = f6 * f14 + f5 * f13;
        return this;
    }

    public Quaternionf rotationZYX(float f2, float f3, float f4) {
        float f5 = Math.sin(f4 * 0.5f);
        float f6 = Math.cosFromSin(f5, f4 * 0.5f);
        float f7 = Math.sin(f3 * 0.5f);
        float f8 = Math.cosFromSin(f7, f3 * 0.5f);
        float f9 = Math.sin(f2 * 0.5f);
        float f10 = Math.cosFromSin(f9, f2 * 0.5f);
        float f11 = f8 * f10;
        float f12 = f7 * f9;
        float f13 = f7 * f10;
        float f14 = f8 * f9;
        this.w = f6 * f11 + f5 * f12;
        this.x = f5 * f11 - f6 * f12;
        this.y = f6 * f13 + f5 * f14;
        this.z = f6 * f14 - f5 * f13;
        return this;
    }

    public Quaternionf rotationYXZ(float f2, float f3, float f4) {
        float f5 = Math.sin(f3 * 0.5f);
        float f6 = Math.cosFromSin(f5, f3 * 0.5f);
        float f7 = Math.sin(f2 * 0.5f);
        float f8 = Math.cosFromSin(f7, f2 * 0.5f);
        float f9 = Math.sin(f4 * 0.5f);
        float f10 = Math.cosFromSin(f9, f4 * 0.5f);
        float f11 = f8 * f5;
        float f12 = f7 * f6;
        float f13 = f7 * f5;
        float f14 = f8 * f6;
        this.x = f11 * f10 + f12 * f9;
        this.y = f12 * f10 - f11 * f9;
        this.z = f14 * f9 - f13 * f10;
        this.w = f14 * f10 + f13 * f9;
        return this;
    }

    public Quaternionf slerp(Quaternionfc quaternionfc, float f2) {
        return this.slerp(quaternionfc, f2, this);
    }

    public Quaternionf slerp(Quaternionfc quaternionfc, float f2, Quaternionf quaternionf) {
        float f3;
        float f4;
        float f5 = Math.fma(this.x, quaternionfc.x(), Math.fma(this.y, quaternionfc.y(), Math.fma(this.z, quaternionfc.z(), this.w * quaternionfc.w())));
        float f6 = Math.abs(f5);
        if (1.0f - f6 > 1.0E-6f) {
            float f7 = 1.0f - f6 * f6;
            float f8 = Math.invsqrt(f7);
            float f9 = Math.atan2(f7 * f8, f6);
            f4 = (float)(Math.sin((1.0 - (double)f2) * (double)f9) * (double)f8);
            f3 = Math.sin(f2 * f9) * f8;
        } else {
            f4 = 1.0f - f2;
            f3 = f2;
        }
        f3 = f5 >= 0.0f ? f3 : -f3;
        quaternionf.x = Math.fma(f4, this.x, f3 * quaternionfc.x());
        quaternionf.y = Math.fma(f4, this.y, f3 * quaternionfc.y());
        quaternionf.z = Math.fma(f4, this.z, f3 * quaternionfc.z());
        quaternionf.w = Math.fma(f4, this.w, f3 * quaternionfc.w());
        return quaternionf;
    }

    public static Quaternionfc slerp(Quaternionf[] quaternionfArray, float[] fArray, Quaternionf quaternionf) {
        quaternionf.set(quaternionfArray[0]);
        float f2 = fArray[0];
        for (int i2 = 1; i2 < quaternionfArray.length; ++i2) {
            float f3 = f2;
            float f4 = fArray[i2];
            float f5 = f4 / (f3 + f4);
            f2 += f4;
            quaternionf.slerp(quaternionfArray[i2], f5);
        }
        return quaternionf;
    }

    public Quaternionf scale(float f2) {
        return this.scale(f2, this);
    }

    public Quaternionf scale(float f2, Quaternionf quaternionf) {
        float f3 = Math.sqrt(f2);
        quaternionf.x = f3 * this.x;
        quaternionf.y = f3 * this.y;
        quaternionf.z = f3 * this.z;
        quaternionf.w = f3 * this.w;
        return quaternionf;
    }

    public Quaternionf scaling(float f2) {
        float f3 = Math.sqrt(f2);
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.w = f3;
        return this;
    }

    public Quaternionf integrate(float f2, float f3, float f4, float f5) {
        return this.integrate(f2, f3, f4, f5, this);
    }

    public Quaternionf integrate(float f2, float f3, float f4, float f5, Quaternionf quaternionf) {
        float f6;
        float f7;
        float f8 = f2 * f3 * 0.5f;
        float f9 = f2 * f4 * 0.5f;
        float f10 = f2 * f5 * 0.5f;
        float f11 = f8 * f8 + f9 * f9 + f10 * f10;
        if (f11 * f11 / 24.0f < 1.0E-8f) {
            f7 = 1.0f - f11 * 0.5f;
            f6 = 1.0f - f11 / 6.0f;
        } else {
            float f12 = Math.sqrt(f11);
            float f13 = Math.sin(f12);
            f6 = f13 / f12;
            f7 = Math.cosFromSin(f13, f12);
        }
        float f14 = f8 * f6;
        float f15 = f9 * f6;
        float f16 = f10 * f6;
        return quaternionf.set(Math.fma(f7, this.x, Math.fma(f14, this.w, Math.fma(f15, this.z, -f16 * this.y))), Math.fma(f7, this.y, Math.fma(-f14, this.z, Math.fma(f15, this.w, f16 * this.x))), Math.fma(f7, this.z, Math.fma(f14, this.y, Math.fma(-f15, this.x, f16 * this.w))), Math.fma(f7, this.w, Math.fma(-f14, this.x, Math.fma(-f15, this.y, -f16 * this.z))));
    }

    public Quaternionf nlerp(Quaternionfc quaternionfc, float f2) {
        return this.nlerp(quaternionfc, f2, this);
    }

    public Quaternionf nlerp(Quaternionfc quaternionfc, float f2, Quaternionf quaternionf) {
        float f3 = Math.fma(this.x, quaternionfc.x(), Math.fma(this.y, quaternionfc.y(), Math.fma(this.z, quaternionfc.z(), this.w * quaternionfc.w())));
        float f4 = 1.0f - f2;
        float f5 = f3 >= 0.0f ? f2 : -f2;
        quaternionf.x = Math.fma(f4, this.x, f5 * quaternionfc.x());
        quaternionf.y = Math.fma(f4, this.y, f5 * quaternionfc.y());
        quaternionf.z = Math.fma(f4, this.z, f5 * quaternionfc.z());
        quaternionf.w = Math.fma(f4, this.w, f5 * quaternionfc.w());
        float f6 = Math.invsqrt(Math.fma(quaternionf.x, quaternionf.x, Math.fma(quaternionf.y, quaternionf.y, Math.fma(quaternionf.z, quaternionf.z, quaternionf.w * quaternionf.w))));
        quaternionf.x *= f6;
        quaternionf.y *= f6;
        quaternionf.z *= f6;
        quaternionf.w *= f6;
        return quaternionf;
    }

    public static Quaternionfc nlerp(Quaternionfc[] quaternionfcArray, float[] fArray, Quaternionf quaternionf) {
        quaternionf.set(quaternionfcArray[0]);
        float f2 = fArray[0];
        for (int i2 = 1; i2 < quaternionfcArray.length; ++i2) {
            float f3 = f2;
            float f4 = fArray[i2];
            float f5 = f4 / (f3 + f4);
            f2 += f4;
            quaternionf.nlerp(quaternionfcArray[i2], f5);
        }
        return quaternionf;
    }

    public Quaternionf nlerpIterative(Quaternionfc quaternionfc, float f2, float f3, Quaternionf quaternionf) {
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9;
        float f10 = this.x;
        float f11 = this.y;
        float f12 = this.z;
        float f13 = this.w;
        float f14 = quaternionfc.x();
        float f15 = Math.fma(f10, f14, Math.fma(f11, f9 = quaternionfc.y(), Math.fma(f12, f8 = quaternionfc.z(), f13 * (f7 = quaternionfc.w()))));
        float f16 = Math.abs(f15);
        if (0.999999f < f16) {
            return quaternionf.set(this);
        }
        float f17 = f2;
        while (f16 < f3) {
            f6 = 0.5f;
            float f18 = f5 = f15 >= 0.0f ? 0.5f : -0.5f;
            if (f17 < 0.5f) {
                f14 = Math.fma(f6, f14, f5 * f10);
                f9 = Math.fma(f6, f9, f5 * f11);
                f8 = Math.fma(f6, f8, f5 * f12);
                f7 = Math.fma(f6, f7, f5 * f13);
                f4 = Math.invsqrt(Math.fma(f14, f14, Math.fma(f9, f9, Math.fma(f8, f8, f7 * f7))));
                f14 *= f4;
                f9 *= f4;
                f8 *= f4;
                f7 *= f4;
                f17 += f17;
            } else {
                f10 = Math.fma(f6, f10, f5 * f14);
                f11 = Math.fma(f6, f11, f5 * f9);
                f12 = Math.fma(f6, f12, f5 * f8);
                f13 = Math.fma(f6, f13, f5 * f7);
                f4 = Math.invsqrt(Math.fma(f10, f10, Math.fma(f11, f11, Math.fma(f12, f12, f13 * f13))));
                f10 *= f4;
                f11 *= f4;
                f12 *= f4;
                f13 *= f4;
                f17 = f17 + f17 - 1.0f;
            }
            f15 = Math.fma(f10, f14, Math.fma(f11, f9, Math.fma(f12, f8, f13 * f7)));
            f16 = Math.abs(f15);
        }
        f6 = 1.0f - f17;
        f5 = f15 >= 0.0f ? f17 : -f17;
        f4 = Math.fma(f6, f10, f5 * f14);
        float f19 = Math.fma(f6, f11, f5 * f9);
        float f20 = Math.fma(f6, f12, f5 * f8);
        float f21 = Math.fma(f6, f13, f5 * f7);
        float f22 = Math.invsqrt(Math.fma(f4, f4, Math.fma(f19, f19, Math.fma(f20, f20, f21 * f21))));
        quaternionf.x = f4 * f22;
        quaternionf.y = f19 * f22;
        quaternionf.z = f20 * f22;
        quaternionf.w = f21 * f22;
        return quaternionf;
    }

    public Quaternionf nlerpIterative(Quaternionfc quaternionfc, float f2, float f3) {
        return this.nlerpIterative(quaternionfc, f2, f3, this);
    }

    public static Quaternionfc nlerpIterative(Quaternionf[] quaternionfArray, float[] fArray, float f2, Quaternionf quaternionf) {
        quaternionf.set(quaternionfArray[0]);
        float f3 = fArray[0];
        for (int i2 = 1; i2 < quaternionfArray.length; ++i2) {
            float f4 = f3;
            float f5 = fArray[i2];
            float f6 = f5 / (f4 + f5);
            f3 += f5;
            quaternionf.nlerpIterative(quaternionfArray[i2], f6, f2);
        }
        return quaternionf;
    }

    public Quaternionf lookAlong(Vector3fc vector3fc, Vector3fc vector3fc2) {
        return this.lookAlong(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), this);
    }

    public Quaternionf lookAlong(Vector3fc vector3fc, Vector3fc vector3fc2, Quaternionf quaternionf) {
        return this.lookAlong(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), quaternionf);
    }

    public Quaternionf lookAlong(float f2, float f3, float f4, float f5, float f6, float f7) {
        return this.lookAlong(f2, f3, f4, f5, f6, f7, this);
    }

    public Quaternionf lookAlong(float f2, float f3, float f4, float f5, float f6, float f7, Quaternionf quaternionf) {
        float f8;
        float f9;
        float f10;
        float f11;
        float f12 = Math.invsqrt(f2 * f2 + f3 * f3 + f4 * f4);
        float f13 = -f2 * f12;
        float f14 = -f3 * f12;
        float f15 = -f4 * f12;
        float f16 = f6 * f15 - f7 * f14;
        float f17 = f7 * f13 - f5 * f15;
        float f18 = f5 * f14 - f6 * f13;
        float f19 = Math.invsqrt(f16 * f16 + f17 * f17 + f18 * f18);
        float f20 = f14 * (f18 *= f19) - f15 * (f17 *= f19);
        float f21 = f15 * (f16 *= f19) - f13 * f18;
        float f22 = f13 * f17 - f14 * f16;
        double d2 = f16 + f21 + f15;
        if (d2 >= 0.0) {
            double d3 = Math.sqrt(d2 + 1.0);
            f11 = (float)(d3 * 0.5);
            d3 = 0.5 / d3;
            f10 = (float)((double)(f14 - f22) * d3);
            f9 = (float)((double)(f18 - f13) * d3);
            f8 = (float)((double)(f20 - f17) * d3);
        } else if (f16 > f21 && f16 > f15) {
            double d4 = Math.sqrt(1.0 + (double)f16 - (double)f21 - (double)f15);
            f10 = (float)(d4 * 0.5);
            d4 = 0.5 / d4;
            f9 = (float)((double)(f17 + f20) * d4);
            f8 = (float)((double)(f13 + f18) * d4);
            f11 = (float)((double)(f14 - f22) * d4);
        } else if (f21 > f15) {
            double d5 = Math.sqrt(1.0 + (double)f21 - (double)f16 - (double)f15);
            f9 = (float)(d5 * 0.5);
            d5 = 0.5 / d5;
            f10 = (float)((double)(f17 + f20) * d5);
            f8 = (float)((double)(f22 + f14) * d5);
            f11 = (float)((double)(f18 - f13) * d5);
        } else {
            double d6 = Math.sqrt(1.0 + (double)f15 - (double)f16 - (double)f21);
            f8 = (float)(d6 * 0.5);
            d6 = 0.5 / d6;
            f10 = (float)((double)(f13 + f18) * d6);
            f9 = (float)((double)(f22 + f14) * d6);
            f11 = (float)((double)(f20 - f17) * d6);
        }
        return quaternionf.set(Math.fma(this.w, f10, Math.fma(this.x, f11, Math.fma(this.y, f8, -this.z * f9))), Math.fma(this.w, f9, Math.fma(-this.x, f8, Math.fma(this.y, f11, this.z * f10))), Math.fma(this.w, f8, Math.fma(this.x, f9, Math.fma(-this.y, f10, this.z * f11))), Math.fma(this.w, f11, Math.fma(-this.x, f10, Math.fma(-this.y, f9, -this.z * f8))));
    }

    public Quaternionf rotationTo(float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8;
        float f9;
        float f10;
        float f11;
        float f12;
        float f13;
        float f14 = Math.invsqrt(Math.fma(f2, f2, Math.fma(f3, f3, f4 * f4)));
        float f15 = f2 * f14;
        float f16 = f15 * (f13 = f5 * (f12 = Math.invsqrt(Math.fma(f5, f5, Math.fma(f6, f6, f7 * f7))))) + (f11 = f3 * f14) * (f10 = f6 * f12) + (f9 = f4 * f14) * (f8 = f7 * f12);
        if (f16 < -0.999999f) {
            float f17 = f11;
            float f18 = -f15;
            float f19 = 0.0f;
            float f20 = 0.0f;
            if (f17 * f17 + f18 * f18 == 0.0f) {
                f17 = 0.0f;
                f18 = f9;
                f19 = -f11;
                f20 = 0.0f;
            }
            this.x = f17;
            this.y = f18;
            this.z = f19;
            this.w = 0.0f;
        } else {
            float f21 = Math.sqrt((1.0f + f16) * 2.0f);
            float f22 = 1.0f / f21;
            float f23 = f11 * f8 - f9 * f10;
            float f24 = f9 * f13 - f15 * f8;
            float f25 = f15 * f10 - f11 * f13;
            float f26 = f23 * f22;
            float f27 = f24 * f22;
            float f28 = f25 * f22;
            float f29 = f21 * 0.5f;
            float f30 = Math.invsqrt(Math.fma(f26, f26, Math.fma(f27, f27, Math.fma(f28, f28, f29 * f29))));
            this.x = f26 * f30;
            this.y = f27 * f30;
            this.z = f28 * f30;
            this.w = f29 * f30;
        }
        return this;
    }

    public Quaternionf rotationTo(Vector3fc vector3fc, Vector3fc vector3fc2) {
        return this.rotationTo(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z());
    }

    public Quaternionf rotateTo(float f2, float f3, float f4, float f5, float f6, float f7, Quaternionf quaternionf) {
        float f8;
        float f9;
        float f10;
        float f11;
        float f12;
        float f13;
        float f14;
        float f15;
        float f16;
        float f17;
        float f18 = Math.invsqrt(Math.fma(f2, f2, Math.fma(f3, f3, f4 * f4)));
        float f19 = f2 * f18;
        float f20 = f19 * (f17 = f5 * (f16 = Math.invsqrt(Math.fma(f5, f5, Math.fma(f6, f6, f7 * f7))))) + (f15 = f3 * f18) * (f14 = f6 * f16) + (f13 = f4 * f18) * (f12 = f7 * f16);
        if (f20 < -0.999999f) {
            f11 = f15;
            f10 = -f19;
            f9 = 0.0f;
            f8 = 0.0f;
            if (f11 * f11 + f10 * f10 == 0.0f) {
                f11 = 0.0f;
                f10 = f13;
                f9 = -f15;
                f8 = 0.0f;
            }
        } else {
            float f21 = Math.sqrt((1.0f + f20) * 2.0f);
            float f22 = 1.0f / f21;
            float f23 = f15 * f12 - f13 * f14;
            float f24 = f13 * f17 - f19 * f12;
            float f25 = f19 * f14 - f15 * f17;
            f11 = f23 * f22;
            f10 = f24 * f22;
            f9 = f25 * f22;
            f8 = f21 * 0.5f;
            float f26 = Math.invsqrt(Math.fma(f11, f11, Math.fma(f10, f10, Math.fma(f9, f9, f8 * f8))));
            f11 *= f26;
            f10 *= f26;
            f9 *= f26;
            f8 *= f26;
        }
        return quaternionf.set(Math.fma(this.w, f11, Math.fma(this.x, f8, Math.fma(this.y, f9, -this.z * f10))), Math.fma(this.w, f10, Math.fma(-this.x, f9, Math.fma(this.y, f8, this.z * f11))), Math.fma(this.w, f9, Math.fma(this.x, f10, Math.fma(-this.y, f11, this.z * f8))), Math.fma(this.w, f8, Math.fma(-this.x, f11, Math.fma(-this.y, f10, -this.z * f9))));
    }

    public Quaternionf rotateTo(float f2, float f3, float f4, float f5, float f6, float f7) {
        return this.rotateTo(f2, f3, f4, f5, f6, f7, this);
    }

    public Quaternionf rotateTo(Vector3fc vector3fc, Vector3fc vector3fc2, Quaternionf quaternionf) {
        return this.rotateTo(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), quaternionf);
    }

    public Quaternionf rotateTo(Vector3fc vector3fc, Vector3fc vector3fc2) {
        return this.rotateTo(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), this);
    }

    public Quaternionf rotateX(float f2) {
        return this.rotateX(f2, this);
    }

    public Quaternionf rotateX(float f2, Quaternionf quaternionf) {
        float f3 = Math.sin(f2 * 0.5f);
        float f4 = Math.cosFromSin(f3, f2 * 0.5f);
        return quaternionf.set(this.w * f3 + this.x * f4, this.y * f4 + this.z * f3, this.z * f4 - this.y * f3, this.w * f4 - this.x * f3);
    }

    public Quaternionf rotateY(float f2) {
        return this.rotateY(f2, this);
    }

    public Quaternionf rotateY(float f2, Quaternionf quaternionf) {
        float f3 = Math.sin(f2 * 0.5f);
        float f4 = Math.cosFromSin(f3, f2 * 0.5f);
        return quaternionf.set(this.x * f4 - this.z * f3, this.w * f3 + this.y * f4, this.x * f3 + this.z * f4, this.w * f4 - this.y * f3);
    }

    public Quaternionf rotateZ(float f2) {
        return this.rotateZ(f2, this);
    }

    public Quaternionf rotateZ(float f2, Quaternionf quaternionf) {
        float f3 = Math.sin(f2 * 0.5f);
        float f4 = Math.cosFromSin(f3, f2 * 0.5f);
        return quaternionf.set(this.x * f4 + this.y * f3, this.y * f4 - this.x * f3, this.w * f3 + this.z * f4, this.w * f4 - this.z * f3);
    }

    public Quaternionf rotateLocalX(float f2) {
        return this.rotateLocalX(f2, this);
    }

    public Quaternionf rotateLocalX(float f2, Quaternionf quaternionf) {
        float f3 = f2 * 0.5f;
        float f4 = Math.sin(f3);
        float f5 = Math.cosFromSin(f4, f3);
        quaternionf.set(f5 * this.x + f4 * this.w, f5 * this.y - f4 * this.z, f5 * this.z + f4 * this.y, f5 * this.w - f4 * this.x);
        return quaternionf;
    }

    public Quaternionf rotateLocalY(float f2) {
        return this.rotateLocalY(f2, this);
    }

    public Quaternionf rotateLocalY(float f2, Quaternionf quaternionf) {
        float f3 = f2 * 0.5f;
        float f4 = Math.sin(f3);
        float f5 = Math.cosFromSin(f4, f3);
        quaternionf.set(f5 * this.x + f4 * this.z, f5 * this.y + f4 * this.w, f5 * this.z - f4 * this.x, f5 * this.w - f4 * this.y);
        return quaternionf;
    }

    public Quaternionf rotateLocalZ(float f2) {
        return this.rotateLocalZ(f2, this);
    }

    public Quaternionf rotateLocalZ(float f2, Quaternionf quaternionf) {
        float f3 = f2 * 0.5f;
        float f4 = Math.sin(f3);
        float f5 = Math.cosFromSin(f4, f3);
        quaternionf.set(f5 * this.x - f4 * this.y, f5 * this.y + f4 * this.x, f5 * this.z + f4 * this.w, f5 * this.w - f4 * this.z);
        return quaternionf;
    }

    public Quaternionf rotateAxis(float f2, float f3, float f4, float f5, Quaternionf quaternionf) {
        float f6 = f2 / 2.0f;
        float f7 = Math.sin(f6);
        float f8 = Math.invsqrt(Math.fma(f3, f3, Math.fma(f4, f4, f5 * f5)));
        float f9 = f3 * f8 * f7;
        float f10 = f4 * f8 * f7;
        float f11 = f5 * f8 * f7;
        float f12 = Math.cosFromSin(f7, f6);
        return quaternionf.set(Math.fma(this.w, f9, Math.fma(this.x, f12, Math.fma(this.y, f11, -this.z * f10))), Math.fma(this.w, f10, Math.fma(-this.x, f11, Math.fma(this.y, f12, this.z * f9))), Math.fma(this.w, f11, Math.fma(this.x, f10, Math.fma(-this.y, f9, this.z * f12))), Math.fma(this.w, f12, Math.fma(-this.x, f9, Math.fma(-this.y, f10, -this.z * f11))));
    }

    public Quaternionf rotateAxis(float f2, Vector3fc vector3fc, Quaternionf quaternionf) {
        return this.rotateAxis(f2, vector3fc.x(), vector3fc.y(), vector3fc.z(), quaternionf);
    }

    public Quaternionf rotateAxis(float f2, Vector3fc vector3fc) {
        return this.rotateAxis(f2, vector3fc.x(), vector3fc.y(), vector3fc.z(), this);
    }

    public Quaternionf rotateAxis(float f2, float f3, float f4, float f5) {
        return this.rotateAxis(f2, f3, f4, f5, this);
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat numberFormat) {
        return "(" + Runtime.format(this.x, numberFormat) + " " + Runtime.format(this.y, numberFormat) + " " + Runtime.format(this.z, numberFormat) + " " + Runtime.format(this.w, numberFormat) + ")";
    }

    public void writeExternal(ObjectOutput objectOutput) {
        objectOutput.writeFloat(this.x);
        objectOutput.writeFloat(this.y);
        objectOutput.writeFloat(this.z);
        objectOutput.writeFloat(this.w);
    }

    public void readExternal(ObjectInput objectInput) {
        this.x = objectInput.readFloat();
        this.y = objectInput.readFloat();
        this.z = objectInput.readFloat();
        this.w = objectInput.readFloat();
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + Float.floatToIntBits(this.w);
        n3 = 31 * n3 + Float.floatToIntBits(this.x);
        n3 = 31 * n3 + Float.floatToIntBits(this.y);
        n3 = 31 * n3 + Float.floatToIntBits(this.z);
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Quaternionf quaternionf = (Quaternionf)object;
        if (Float.floatToIntBits(this.w) != Float.floatToIntBits(quaternionf.w)) {
            return false;
        }
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(quaternionf.x)) {
            return false;
        }
        if (Float.floatToIntBits(this.y) != Float.floatToIntBits(quaternionf.y)) {
            return false;
        }
        return Float.floatToIntBits(this.z) == Float.floatToIntBits(quaternionf.z);
    }

    public Quaternionf difference(Quaternionf quaternionf) {
        return this.difference(quaternionf, this);
    }

    public Quaternionf difference(Quaternionfc quaternionfc, Quaternionf quaternionf) {
        float f2 = 1.0f / this.lengthSquared();
        float f3 = -this.x * f2;
        float f4 = -this.y * f2;
        float f5 = -this.z * f2;
        float f6 = this.w * f2;
        quaternionf.set(Math.fma(f6, quaternionfc.x(), Math.fma(f3, quaternionfc.w(), Math.fma(f4, quaternionfc.z(), -f5 * quaternionfc.y()))), Math.fma(f6, quaternionfc.y(), Math.fma(-f3, quaternionfc.z(), Math.fma(f4, quaternionfc.w(), f5 * quaternionfc.x()))), Math.fma(f6, quaternionfc.z(), Math.fma(f3, quaternionfc.y(), Math.fma(-f4, quaternionfc.x(), f5 * quaternionfc.w()))), Math.fma(f6, quaternionfc.w(), Math.fma(-f3, quaternionfc.x(), Math.fma(-f4, quaternionfc.y(), -f5 * quaternionfc.z()))));
        return quaternionf;
    }

    public Vector3f positiveX(Vector3f vector3f) {
        float f2 = 1.0f / this.lengthSquared();
        float f3 = -this.x * f2;
        float f4 = -this.y * f2;
        float f5 = -this.z * f2;
        float f6 = this.w * f2;
        float f7 = f4 + f4;
        float f8 = f5 + f5;
        vector3f.x = -f4 * f7 - f5 * f8 + 1.0f;
        vector3f.y = f3 * f7 + f6 * f8;
        vector3f.z = f3 * f8 - f6 * f7;
        return vector3f;
    }

    public Vector3f normalizedPositiveX(Vector3f vector3f) {
        float f2 = this.y + this.y;
        float f3 = this.z + this.z;
        vector3f.x = -this.y * f2 - this.z * f3 + 1.0f;
        vector3f.y = this.x * f2 - this.w * f3;
        vector3f.z = this.x * f3 + this.w * f2;
        return vector3f;
    }

    public Vector3f positiveY(Vector3f vector3f) {
        float f2 = 1.0f / this.lengthSquared();
        float f3 = -this.x * f2;
        float f4 = -this.y * f2;
        float f5 = -this.z * f2;
        float f6 = this.w * f2;
        float f7 = f3 + f3;
        float f8 = f4 + f4;
        float f9 = f5 + f5;
        vector3f.x = f3 * f8 - f6 * f9;
        vector3f.y = -f3 * f7 - f5 * f9 + 1.0f;
        vector3f.z = f4 * f9 + f6 * f7;
        return vector3f;
    }

    public Vector3f normalizedPositiveY(Vector3f vector3f) {
        float f2 = this.x + this.x;
        float f3 = this.y + this.y;
        float f4 = this.z + this.z;
        vector3f.x = this.x * f3 + this.w * f4;
        vector3f.y = -this.x * f2 - this.z * f4 + 1.0f;
        vector3f.z = this.y * f4 - this.w * f2;
        return vector3f;
    }

    public Vector3f positiveZ(Vector3f vector3f) {
        float f2 = 1.0f / this.lengthSquared();
        float f3 = -this.x * f2;
        float f4 = -this.y * f2;
        float f5 = -this.z * f2;
        float f6 = this.w * f2;
        float f7 = f3 + f3;
        float f8 = f4 + f4;
        float f9 = f5 + f5;
        vector3f.x = f3 * f9 + f6 * f8;
        vector3f.y = f4 * f9 - f6 * f7;
        vector3f.z = -f3 * f7 - f4 * f8 + 1.0f;
        return vector3f;
    }

    public Vector3f normalizedPositiveZ(Vector3f vector3f) {
        float f2 = this.x + this.x;
        float f3 = this.y + this.y;
        float f4 = this.z + this.z;
        vector3f.x = this.x * f4 - this.w * f3;
        vector3f.y = this.y * f4 + this.w * f2;
        vector3f.z = -this.x * f2 - this.y * f3 + 1.0f;
        return vector3f;
    }

    public Quaternionf conjugateBy(Quaternionfc quaternionfc) {
        return this.conjugateBy(quaternionfc, this);
    }

    public Quaternionf conjugateBy(Quaternionfc quaternionfc, Quaternionf quaternionf) {
        float f2 = 1.0f / quaternionfc.lengthSquared();
        float f3 = -quaternionfc.x() * f2;
        float f4 = -quaternionfc.y() * f2;
        float f5 = -quaternionfc.z() * f2;
        float f6 = quaternionfc.w() * f2;
        float f7 = Math.fma(quaternionfc.w(), this.x, Math.fma(quaternionfc.x(), this.w, Math.fma(quaternionfc.y(), this.z, -quaternionfc.z() * this.y)));
        float f8 = Math.fma(quaternionfc.w(), this.y, Math.fma(-quaternionfc.x(), this.z, Math.fma(quaternionfc.y(), this.w, quaternionfc.z() * this.x)));
        float f9 = Math.fma(quaternionfc.w(), this.z, Math.fma(quaternionfc.x(), this.y, Math.fma(-quaternionfc.y(), this.x, quaternionfc.z() * this.w)));
        float f10 = Math.fma(quaternionfc.w(), this.w, Math.fma(-quaternionfc.x(), this.x, Math.fma(-quaternionfc.y(), this.y, -quaternionfc.z() * this.z)));
        return quaternionf.set(Math.fma(f10, f3, Math.fma(f7, f6, Math.fma(f8, f5, -f9 * f4))), Math.fma(f10, f4, Math.fma(-f7, f5, Math.fma(f8, f6, f9 * f3))), Math.fma(f10, f5, Math.fma(f7, f4, Math.fma(-f8, f3, f9 * f6))), Math.fma(f10, f6, Math.fma(-f7, f3, Math.fma(-f8, f4, -f9 * f5))));
    }

    public boolean isFinite() {
        return Math.isFinite(this.x) && Math.isFinite(this.y) && Math.isFinite(this.z) && Math.isFinite(this.w);
    }

    public boolean equals(Quaternionfc quaternionfc, float f2) {
        if (this == quaternionfc) {
            return true;
        }
        if (quaternionfc == null) {
            return false;
        }
        if (!(quaternionfc instanceof Quaternionfc)) {
            return false;
        }
        if (!Runtime.equals(this.x, quaternionfc.x(), f2)) {
            return false;
        }
        if (!Runtime.equals(this.y, quaternionfc.y(), f2)) {
            return false;
        }
        if (!Runtime.equals(this.z, quaternionfc.z(), f2)) {
            return false;
        }
        return Runtime.equals(this.w, quaternionfc.w(), f2);
    }

    public boolean equals(float f2, float f3, float f4, float f5) {
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(f2)) {
            return false;
        }
        if (Float.floatToIntBits(this.y) != Float.floatToIntBits(f3)) {
            return false;
        }
        if (Float.floatToIntBits(this.z) != Float.floatToIntBits(f4)) {
            return false;
        }
        return Float.floatToIntBits(this.w) == Float.floatToIntBits(f5);
    }

    public Object clone() {
        return super.clone();
    }
}

