/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.NumberFormat;
import org.joml.AxisAngle4d;
import org.joml.AxisAngle4f;
import org.joml.Math;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Matrix4x3dc;
import org.joml.Matrix4x3fc;
import org.joml.Options;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Runtime;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4d;
import org.joml.Vector4dc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class Quaterniond
implements Externalizable,
Cloneable,
Quaterniondc {
    private static final long serialVersionUID = 1L;
    public double x;
    public double y;
    public double z;
    public double w;

    public Quaterniond() {
        this.w = 1.0;
    }

    public Quaterniond(double d2, double d3, double d4, double d5) {
        this.x = d2;
        this.y = d3;
        this.z = d4;
        this.w = d5;
    }

    public Quaterniond(Quaterniondc quaterniondc) {
        this.x = quaterniondc.x();
        this.y = quaterniondc.y();
        this.z = quaterniondc.z();
        this.w = quaterniondc.w();
    }

    public Quaterniond(Quaternionfc quaternionfc) {
        this.x = quaternionfc.x();
        this.y = quaternionfc.y();
        this.z = quaternionfc.z();
        this.w = quaternionfc.w();
    }

    public Quaterniond(AxisAngle4f axisAngle4f) {
        double d2 = Math.sin((double)axisAngle4f.angle * 0.5);
        this.x = (double)axisAngle4f.x * d2;
        this.y = (double)axisAngle4f.y * d2;
        this.z = (double)axisAngle4f.z * d2;
        this.w = Math.cosFromSin(d2, (double)axisAngle4f.angle * 0.5);
    }

    public Quaterniond(AxisAngle4d axisAngle4d) {
        double d2 = Math.sin(axisAngle4d.angle * 0.5);
        this.x = axisAngle4d.x * d2;
        this.y = axisAngle4d.y * d2;
        this.z = axisAngle4d.z * d2;
        this.w = Math.cosFromSin(d2, axisAngle4d.angle * 0.5);
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public double w() {
        return this.w;
    }

    public Quaterniond normalize() {
        double d2 = Math.invsqrt(this.lengthSquared());
        this.x *= d2;
        this.y *= d2;
        this.z *= d2;
        this.w *= d2;
        return this;
    }

    public Quaterniond normalize(Quaterniond quaterniond) {
        double d2 = Math.invsqrt(this.lengthSquared());
        quaterniond.x = this.x * d2;
        quaterniond.y = this.y * d2;
        quaterniond.z = this.z * d2;
        quaterniond.w = this.w * d2;
        return quaterniond;
    }

    public Quaterniond add(double d2, double d3, double d4, double d5) {
        return this.add(d2, d3, d4, d5, this);
    }

    public Quaterniond add(double d2, double d3, double d4, double d5, Quaterniond quaterniond) {
        quaterniond.x = this.x + d2;
        quaterniond.y = this.y + d3;
        quaterniond.z = this.z + d4;
        quaterniond.w = this.w + d5;
        return quaterniond;
    }

    public Quaterniond add(Quaterniondc quaterniondc) {
        this.x += quaterniondc.x();
        this.y += quaterniondc.y();
        this.z += quaterniondc.z();
        this.w += quaterniondc.w();
        return this;
    }

    public Quaterniond add(Quaterniondc quaterniondc, Quaterniond quaterniond) {
        quaterniond.x = this.x + quaterniondc.x();
        quaterniond.y = this.y + quaterniondc.y();
        quaterniond.z = this.z + quaterniondc.z();
        quaterniond.w = this.w + quaterniondc.w();
        return quaterniond;
    }

    public double dot(Quaterniondc quaterniondc) {
        return this.x * quaterniondc.x() + this.y * quaterniondc.y() + this.z * quaterniondc.z() + this.w * quaterniondc.w();
    }

    public double angle() {
        return 2.0 * Math.safeAcos(this.w);
    }

    public Matrix3d get(Matrix3d matrix3d) {
        return matrix3d.set(this);
    }

    public Matrix3f get(Matrix3f matrix3f) {
        return matrix3f.set(this);
    }

    public Matrix4d get(Matrix4d matrix4d) {
        return matrix4d.set(this);
    }

    public Matrix4f get(Matrix4f matrix4f) {
        return matrix4f.set(this);
    }

    public AxisAngle4f get(AxisAngle4f axisAngle4f) {
        double d2;
        double d3 = this.x;
        double d4 = this.y;
        double d5 = this.z;
        double d6 = this.w;
        if (d6 > 1.0) {
            d2 = Math.invsqrt(this.lengthSquared());
            d3 *= d2;
            d4 *= d2;
            d5 *= d2;
            d6 *= d2;
        }
        axisAngle4f.angle = (float)(2.0 * Math.acos(d6));
        d2 = Math.sqrt(1.0 - d6 * d6);
        if (d2 < 0.001) {
            axisAngle4f.x = (float)d3;
            axisAngle4f.y = (float)d4;
            axisAngle4f.z = (float)d5;
        } else {
            d2 = 1.0 / d2;
            axisAngle4f.x = (float)(d3 * d2);
            axisAngle4f.y = (float)(d4 * d2);
            axisAngle4f.z = (float)(d5 * d2);
        }
        return axisAngle4f;
    }

    public AxisAngle4d get(AxisAngle4d axisAngle4d) {
        double d2;
        double d3 = this.x;
        double d4 = this.y;
        double d5 = this.z;
        double d6 = this.w;
        if (d6 > 1.0) {
            d2 = Math.invsqrt(this.lengthSquared());
            d3 *= d2;
            d4 *= d2;
            d5 *= d2;
            d6 *= d2;
        }
        axisAngle4d.angle = 2.0 * Math.acos(d6);
        d2 = Math.sqrt(1.0 - d6 * d6);
        if (d2 < 0.001) {
            axisAngle4d.x = d3;
            axisAngle4d.y = d4;
            axisAngle4d.z = d5;
        } else {
            d2 = 1.0 / d2;
            axisAngle4d.x = d3 * d2;
            axisAngle4d.y = d4 * d2;
            axisAngle4d.z = d5 * d2;
        }
        return axisAngle4d;
    }

    public Quaterniond get(Quaterniond quaterniond) {
        return quaterniond.set(this);
    }

    public Quaternionf get(Quaternionf quaternionf) {
        return quaternionf.set(this);
    }

    public Quaterniond set(double d2, double d3, double d4, double d5) {
        this.x = d2;
        this.y = d3;
        this.z = d4;
        this.w = d5;
        return this;
    }

    public Quaterniond set(Quaterniondc quaterniondc) {
        this.x = quaterniondc.x();
        this.y = quaterniondc.y();
        this.z = quaterniondc.z();
        this.w = quaterniondc.w();
        return this;
    }

    public Quaterniond set(Quaternionfc quaternionfc) {
        this.x = quaternionfc.x();
        this.y = quaternionfc.y();
        this.z = quaternionfc.z();
        this.w = quaternionfc.w();
        return this;
    }

    public Quaterniond set(AxisAngle4f axisAngle4f) {
        return this.setAngleAxis(axisAngle4f.angle, axisAngle4f.x, axisAngle4f.y, axisAngle4f.z);
    }

    public Quaterniond set(AxisAngle4d axisAngle4d) {
        return this.setAngleAxis(axisAngle4d.angle, axisAngle4d.x, axisAngle4d.y, axisAngle4d.z);
    }

    public Quaterniond setAngleAxis(double d2, double d3, double d4, double d5) {
        double d6 = Math.sin(d2 * 0.5);
        this.x = d3 * d6;
        this.y = d4 * d6;
        this.z = d5 * d6;
        this.w = Math.cosFromSin(d6, d2 * 0.5);
        return this;
    }

    public Quaterniond setAngleAxis(double d2, Vector3dc vector3dc) {
        return this.setAngleAxis(d2, vector3dc.x(), vector3dc.y(), vector3dc.z());
    }

    private void setFromUnnormalized(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        double d11 = d2;
        double d12 = d3;
        double d13 = d4;
        double d14 = d5;
        double d15 = d6;
        double d16 = d7;
        double d17 = d8;
        double d18 = d9;
        double d19 = d10;
        double d20 = Math.invsqrt(d2 * d2 + d3 * d3 + d4 * d4);
        double d21 = Math.invsqrt(d5 * d5 + d6 * d6 + d7 * d7);
        double d22 = Math.invsqrt(d8 * d8 + d9 * d9 + d10 * d10);
        this.setFromNormalized(d11 *= d20, d12 *= d20, d13 *= d20, d14 *= d21, d15 *= d21, d16 *= d21, d17 *= d22, d18 *= d22, d19 *= d22);
    }

    private void setFromNormalized(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        double d11 = d2 + d6 + d10;
        if (d11 >= 0.0) {
            double d12 = Math.sqrt(d11 + 1.0);
            this.w = d12 * 0.5;
            d12 = 0.5 / d12;
            this.x = (d7 - d9) * d12;
            this.y = (d8 - d4) * d12;
            this.z = (d3 - d5) * d12;
        } else if (d2 >= d6 && d2 >= d10) {
            double d13 = Math.sqrt(d2 - (d6 + d10) + 1.0);
            this.x = d13 * 0.5;
            d13 = 0.5 / d13;
            this.y = (d5 + d3) * d13;
            this.z = (d4 + d8) * d13;
            this.w = (d7 - d9) * d13;
        } else if (d6 > d10) {
            double d14 = Math.sqrt(d6 - (d10 + d2) + 1.0);
            this.y = d14 * 0.5;
            d14 = 0.5 / d14;
            this.z = (d9 + d7) * d14;
            this.x = (d5 + d3) * d14;
            this.w = (d8 - d4) * d14;
        } else {
            double d15 = Math.sqrt(d10 - (d2 + d6) + 1.0);
            this.z = d15 * 0.5;
            d15 = 0.5 / d15;
            this.x = (d4 + d8) * d15;
            this.y = (d9 + d7) * d15;
            this.w = (d3 - d5) * d15;
        }
    }

    public Quaterniond setFromUnnormalized(Matrix4fc matrix4fc) {
        this.setFromUnnormalized(matrix4fc.m00(), matrix4fc.m01(), matrix4fc.m02(), matrix4fc.m10(), matrix4fc.m11(), matrix4fc.m12(), matrix4fc.m20(), matrix4fc.m21(), matrix4fc.m22());
        return this;
    }

    public Quaterniond setFromUnnormalized(Matrix4x3fc matrix4x3fc) {
        this.setFromUnnormalized(matrix4x3fc.m00(), matrix4x3fc.m01(), matrix4x3fc.m02(), matrix4x3fc.m10(), matrix4x3fc.m11(), matrix4x3fc.m12(), matrix4x3fc.m20(), matrix4x3fc.m21(), matrix4x3fc.m22());
        return this;
    }

    public Quaterniond setFromUnnormalized(Matrix4x3dc matrix4x3dc) {
        this.setFromUnnormalized(matrix4x3dc.m00(), matrix4x3dc.m01(), matrix4x3dc.m02(), matrix4x3dc.m10(), matrix4x3dc.m11(), matrix4x3dc.m12(), matrix4x3dc.m20(), matrix4x3dc.m21(), matrix4x3dc.m22());
        return this;
    }

    public Quaterniond setFromNormalized(Matrix4fc matrix4fc) {
        this.setFromNormalized(matrix4fc.m00(), matrix4fc.m01(), matrix4fc.m02(), matrix4fc.m10(), matrix4fc.m11(), matrix4fc.m12(), matrix4fc.m20(), matrix4fc.m21(), matrix4fc.m22());
        return this;
    }

    public Quaterniond setFromNormalized(Matrix4x3fc matrix4x3fc) {
        this.setFromNormalized(matrix4x3fc.m00(), matrix4x3fc.m01(), matrix4x3fc.m02(), matrix4x3fc.m10(), matrix4x3fc.m11(), matrix4x3fc.m12(), matrix4x3fc.m20(), matrix4x3fc.m21(), matrix4x3fc.m22());
        return this;
    }

    public Quaterniond setFromNormalized(Matrix4x3dc matrix4x3dc) {
        this.setFromNormalized(matrix4x3dc.m00(), matrix4x3dc.m01(), matrix4x3dc.m02(), matrix4x3dc.m10(), matrix4x3dc.m11(), matrix4x3dc.m12(), matrix4x3dc.m20(), matrix4x3dc.m21(), matrix4x3dc.m22());
        return this;
    }

    public Quaterniond setFromUnnormalized(Matrix4dc matrix4dc) {
        this.setFromUnnormalized(matrix4dc.m00(), matrix4dc.m01(), matrix4dc.m02(), matrix4dc.m10(), matrix4dc.m11(), matrix4dc.m12(), matrix4dc.m20(), matrix4dc.m21(), matrix4dc.m22());
        return this;
    }

    public Quaterniond setFromNormalized(Matrix4dc matrix4dc) {
        this.setFromNormalized(matrix4dc.m00(), matrix4dc.m01(), matrix4dc.m02(), matrix4dc.m10(), matrix4dc.m11(), matrix4dc.m12(), matrix4dc.m20(), matrix4dc.m21(), matrix4dc.m22());
        return this;
    }

    public Quaterniond setFromUnnormalized(Matrix3fc matrix3fc) {
        this.setFromUnnormalized(matrix3fc.m00(), matrix3fc.m01(), matrix3fc.m02(), matrix3fc.m10(), matrix3fc.m11(), matrix3fc.m12(), matrix3fc.m20(), matrix3fc.m21(), matrix3fc.m22());
        return this;
    }

    public Quaterniond setFromNormalized(Matrix3fc matrix3fc) {
        this.setFromNormalized(matrix3fc.m00(), matrix3fc.m01(), matrix3fc.m02(), matrix3fc.m10(), matrix3fc.m11(), matrix3fc.m12(), matrix3fc.m20(), matrix3fc.m21(), matrix3fc.m22());
        return this;
    }

    public Quaterniond setFromUnnormalized(Matrix3dc matrix3dc) {
        this.setFromUnnormalized(matrix3dc.m00(), matrix3dc.m01(), matrix3dc.m02(), matrix3dc.m10(), matrix3dc.m11(), matrix3dc.m12(), matrix3dc.m20(), matrix3dc.m21(), matrix3dc.m22());
        return this;
    }

    public Quaterniond setFromNormalized(Matrix3dc matrix3dc) {
        this.setFromNormalized(matrix3dc.m00(), matrix3dc.m01(), matrix3dc.m02(), matrix3dc.m10(), matrix3dc.m11(), matrix3dc.m12(), matrix3dc.m20(), matrix3dc.m21(), matrix3dc.m22());
        return this;
    }

    public Quaterniond fromAxisAngleRad(Vector3dc vector3dc, double d2) {
        return this.fromAxisAngleRad(vector3dc.x(), vector3dc.y(), vector3dc.z(), d2);
    }

    public Quaterniond fromAxisAngleRad(double d2, double d3, double d4, double d5) {
        double d6 = d5 / 2.0;
        double d7 = Math.sin(d6);
        double d8 = Math.sqrt(d2 * d2 + d3 * d3 + d4 * d4);
        this.x = d2 / d8 * d7;
        this.y = d3 / d8 * d7;
        this.z = d4 / d8 * d7;
        this.w = Math.cosFromSin(d7, d6);
        return this;
    }

    public Quaterniond fromAxisAngleDeg(Vector3dc vector3dc, double d2) {
        return this.fromAxisAngleRad(vector3dc.x(), vector3dc.y(), vector3dc.z(), Math.toRadians(d2));
    }

    public Quaterniond fromAxisAngleDeg(double d2, double d3, double d4, double d5) {
        return this.fromAxisAngleRad(d2, d3, d4, Math.toRadians(d5));
    }

    public Quaterniond mul(Quaterniondc quaterniondc) {
        return this.mul(quaterniondc, this);
    }

    public Quaterniond mul(Quaterniondc quaterniondc, Quaterniond quaterniond) {
        return this.mul(quaterniondc.x(), quaterniondc.y(), quaterniondc.z(), quaterniondc.w(), quaterniond);
    }

    public Quaterniond mul(double d2, double d3, double d4, double d5) {
        return this.mul(d2, d3, d4, d5, this);
    }

    public Quaterniond mul(double d2, double d3, double d4, double d5, Quaterniond quaterniond) {
        return quaterniond.set(Math.fma(this.w, d2, Math.fma(this.x, d5, Math.fma(this.y, d4, -this.z * d3))), Math.fma(this.w, d3, Math.fma(-this.x, d4, Math.fma(this.y, d5, this.z * d2))), Math.fma(this.w, d4, Math.fma(this.x, d3, Math.fma(-this.y, d2, this.z * d5))), Math.fma(this.w, d5, Math.fma(-this.x, d2, Math.fma(-this.y, d3, -this.z * d4))));
    }

    public Quaterniond mul(double d2) {
        return this.mul(d2, this);
    }

    public Quaterniond mul(double d2, Quaterniond quaterniond) {
        quaterniond.x = this.x * d2;
        quaterniond.y = this.y * d2;
        quaterniond.z = this.z * d2;
        quaterniond.w = this.w * d2;
        return quaterniond;
    }

    public Quaterniond premul(Quaterniondc quaterniondc) {
        return this.premul(quaterniondc, this);
    }

    public Quaterniond premul(Quaterniondc quaterniondc, Quaterniond quaterniond) {
        return this.premul(quaterniondc.x(), quaterniondc.y(), quaterniondc.z(), quaterniondc.w(), quaterniond);
    }

    public Quaterniond premul(double d2, double d3, double d4, double d5) {
        return this.premul(d2, d3, d4, d5, this);
    }

    public Quaterniond premul(double d2, double d3, double d4, double d5, Quaterniond quaterniond) {
        return quaterniond.set(Math.fma(d5, this.x, Math.fma(d2, this.w, Math.fma(d3, this.z, -d4 * this.y))), Math.fma(d5, this.y, Math.fma(-d2, this.z, Math.fma(d3, this.w, d4 * this.x))), Math.fma(d5, this.z, Math.fma(d2, this.y, Math.fma(-d3, this.x, d4 * this.w))), Math.fma(d5, this.w, Math.fma(-d2, this.x, Math.fma(-d3, this.y, -d4 * this.z))));
    }

    public Vector3d transform(Vector3d vector3d) {
        return this.transform(vector3d.x, vector3d.y, vector3d.z, vector3d);
    }

    public Vector3d transformInverse(Vector3d vector3d) {
        return this.transformInverse(vector3d.x, vector3d.y, vector3d.z, vector3d);
    }

    public Vector3d transformUnit(Vector3d vector3d) {
        return this.transformUnit(vector3d.x, vector3d.y, vector3d.z, vector3d);
    }

    public Vector3d transformInverseUnit(Vector3d vector3d) {
        return this.transformInverseUnit(vector3d.x, vector3d.y, vector3d.z, vector3d);
    }

    public Vector3d transformPositiveX(Vector3d vector3d) {
        double d2 = this.w * this.w;
        double d3 = this.x * this.x;
        double d4 = this.y * this.y;
        double d5 = this.z * this.z;
        double d6 = this.z * this.w;
        double d7 = this.x * this.y;
        double d8 = this.x * this.z;
        double d9 = this.y * this.w;
        vector3d.x = d2 + d3 - d5 - d4;
        vector3d.y = d7 + d6 + d6 + d7;
        vector3d.z = d8 - d9 + d8 - d9;
        return vector3d;
    }

    public Vector4d transformPositiveX(Vector4d vector4d) {
        double d2 = this.w * this.w;
        double d3 = this.x * this.x;
        double d4 = this.y * this.y;
        double d5 = this.z * this.z;
        double d6 = this.z * this.w;
        double d7 = this.x * this.y;
        double d8 = this.x * this.z;
        double d9 = this.y * this.w;
        vector4d.x = d2 + d3 - d5 - d4;
        vector4d.y = d7 + d6 + d6 + d7;
        vector4d.z = d8 - d9 + d8 - d9;
        return vector4d;
    }

    public Vector3d transformUnitPositiveX(Vector3d vector3d) {
        double d2 = this.y * this.y;
        double d3 = this.z * this.z;
        double d4 = this.x * this.y;
        double d5 = this.x * this.z;
        double d6 = this.y * this.w;
        double d7 = this.z * this.w;
        vector3d.x = 1.0 - d2 - d2 - d3 - d3;
        vector3d.y = d4 + d7 + d4 + d7;
        vector3d.z = d5 - d6 + d5 - d6;
        return vector3d;
    }

    public Vector4d transformUnitPositiveX(Vector4d vector4d) {
        double d2 = this.y * this.y;
        double d3 = this.z * this.z;
        double d4 = this.x * this.y;
        double d5 = this.x * this.z;
        double d6 = this.y * this.w;
        double d7 = this.z * this.w;
        vector4d.x = 1.0 - d2 - d2 - d3 - d3;
        vector4d.y = d4 + d7 + d4 + d7;
        vector4d.z = d5 - d6 + d5 - d6;
        return vector4d;
    }

    public Vector3d transformPositiveY(Vector3d vector3d) {
        double d2 = this.w * this.w;
        double d3 = this.x * this.x;
        double d4 = this.y * this.y;
        double d5 = this.z * this.z;
        double d6 = this.z * this.w;
        double d7 = this.x * this.y;
        double d8 = this.y * this.z;
        double d9 = this.x * this.w;
        vector3d.x = -d6 + d7 - d6 + d7;
        vector3d.y = d4 - d5 + d2 - d3;
        vector3d.z = d8 + d8 + d9 + d9;
        return vector3d;
    }

    public Vector4d transformPositiveY(Vector4d vector4d) {
        double d2 = this.w * this.w;
        double d3 = this.x * this.x;
        double d4 = this.y * this.y;
        double d5 = this.z * this.z;
        double d6 = this.z * this.w;
        double d7 = this.x * this.y;
        double d8 = this.y * this.z;
        double d9 = this.x * this.w;
        vector4d.x = -d6 + d7 - d6 + d7;
        vector4d.y = d4 - d5 + d2 - d3;
        vector4d.z = d8 + d8 + d9 + d9;
        return vector4d;
    }

    public Vector4d transformUnitPositiveY(Vector4d vector4d) {
        double d2 = this.x * this.x;
        double d3 = this.z * this.z;
        double d4 = this.x * this.y;
        double d5 = this.y * this.z;
        double d6 = this.x * this.w;
        double d7 = this.z * this.w;
        vector4d.x = d4 - d7 + d4 - d7;
        vector4d.y = 1.0 - d2 - d2 - d3 - d3;
        vector4d.z = d5 + d5 + d6 + d6;
        return vector4d;
    }

    public Vector3d transformUnitPositiveY(Vector3d vector3d) {
        double d2 = this.x * this.x;
        double d3 = this.z * this.z;
        double d4 = this.x * this.y;
        double d5 = this.y * this.z;
        double d6 = this.x * this.w;
        double d7 = this.z * this.w;
        vector3d.x = d4 - d7 + d4 - d7;
        vector3d.y = 1.0 - d2 - d2 - d3 - d3;
        vector3d.z = d5 + d5 + d6 + d6;
        return vector3d;
    }

    public Vector3d transformPositiveZ(Vector3d vector3d) {
        double d2 = this.w * this.w;
        double d3 = this.x * this.x;
        double d4 = this.y * this.y;
        double d5 = this.z * this.z;
        double d6 = this.x * this.z;
        double d7 = this.y * this.w;
        double d8 = this.y * this.z;
        double d9 = this.x * this.w;
        vector3d.x = d7 + d6 + d6 + d7;
        vector3d.y = d8 + d8 - d9 - d9;
        vector3d.z = d5 - d4 - d3 + d2;
        return vector3d;
    }

    public Vector4d transformPositiveZ(Vector4d vector4d) {
        double d2 = this.w * this.w;
        double d3 = this.x * this.x;
        double d4 = this.y * this.y;
        double d5 = this.z * this.z;
        double d6 = this.x * this.z;
        double d7 = this.y * this.w;
        double d8 = this.y * this.z;
        double d9 = this.x * this.w;
        vector4d.x = d7 + d6 + d6 + d7;
        vector4d.y = d8 + d8 - d9 - d9;
        vector4d.z = d5 - d4 - d3 + d2;
        return vector4d;
    }

    public Vector4d transformUnitPositiveZ(Vector4d vector4d) {
        double d2 = this.x * this.x;
        double d3 = this.y * this.y;
        double d4 = this.x * this.z;
        double d5 = this.y * this.z;
        double d6 = this.x * this.w;
        double d7 = this.y * this.w;
        vector4d.x = d4 + d7 + d4 + d7;
        vector4d.y = d5 + d5 - d6 - d6;
        vector4d.z = 1.0 - d2 - d2 - d3 - d3;
        return vector4d;
    }

    public Vector3d transformUnitPositiveZ(Vector3d vector3d) {
        double d2 = this.x * this.x;
        double d3 = this.y * this.y;
        double d4 = this.x * this.z;
        double d5 = this.y * this.z;
        double d6 = this.x * this.w;
        double d7 = this.y * this.w;
        vector3d.x = d4 + d7 + d4 + d7;
        vector3d.y = d5 + d5 - d6 - d6;
        vector3d.z = 1.0 - d2 - d2 - d3 - d3;
        return vector3d;
    }

    public Vector4d transform(Vector4d vector4d) {
        return this.transform(vector4d, vector4d);
    }

    public Vector4d transformInverse(Vector4d vector4d) {
        return this.transformInverse(vector4d, vector4d);
    }

    public Vector3d transform(Vector3dc vector3dc, Vector3d vector3d) {
        return this.transform(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3d);
    }

    public Vector3d transformInverse(Vector3dc vector3dc, Vector3d vector3d) {
        return this.transformInverse(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3d);
    }

    public Vector3d transform(double d2, double d3, double d4, Vector3d vector3d) {
        double d5 = this.x * this.x;
        double d6 = this.y * this.y;
        double d7 = this.z * this.z;
        double d8 = this.w * this.w;
        double d9 = this.x * this.y;
        double d10 = this.x * this.z;
        double d11 = this.y * this.z;
        double d12 = this.x * this.w;
        double d13 = this.z * this.w;
        double d14 = this.y * this.w;
        double d15 = 1.0 / (d5 + d6 + d7 + d8);
        return vector3d.set(Math.fma((d5 - d6 - d7 + d8) * d15, d2, Math.fma(2.0 * (d9 - d13) * d15, d3, 2.0 * (d10 + d14) * d15 * d4)), Math.fma(2.0 * (d9 + d13) * d15, d2, Math.fma((d6 - d5 - d7 + d8) * d15, d3, 2.0 * (d11 - d12) * d15 * d4)), Math.fma(2.0 * (d10 - d14) * d15, d2, Math.fma(2.0 * (d11 + d12) * d15, d3, (d7 - d5 - d6 + d8) * d15 * d4)));
    }

    public Vector3d transformInverse(double d2, double d3, double d4, Vector3d vector3d) {
        double d5 = 1.0 / Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
        double d6 = this.x * d5;
        double d7 = this.y * d5;
        double d8 = this.z * d5;
        double d9 = this.w * d5;
        double d10 = d6 * d6;
        double d11 = d7 * d7;
        double d12 = d8 * d8;
        double d13 = d9 * d9;
        double d14 = d6 * d7;
        double d15 = d6 * d8;
        double d16 = d7 * d8;
        double d17 = d6 * d9;
        double d18 = d8 * d9;
        double d19 = d7 * d9;
        double d20 = 1.0 / (d10 + d11 + d12 + d13);
        return vector3d.set(Math.fma((d10 - d11 - d12 + d13) * d20, d2, Math.fma(2.0 * (d14 + d18) * d20, d3, 2.0 * (d15 - d19) * d20 * d4)), Math.fma(2.0 * (d14 - d18) * d20, d2, Math.fma((d11 - d10 - d12 + d13) * d20, d3, 2.0 * (d16 + d17) * d20 * d4)), Math.fma(2.0 * (d15 + d19) * d20, d2, Math.fma(2.0 * (d16 - d17) * d20, d3, (d12 - d10 - d11 + d13) * d20 * d4)));
    }

    public Vector4d transform(Vector4dc vector4dc, Vector4d vector4d) {
        return this.transform(vector4dc.x(), vector4dc.y(), vector4dc.z(), vector4d);
    }

    public Vector4d transformInverse(Vector4dc vector4dc, Vector4d vector4d) {
        return this.transformInverse(vector4dc.x(), vector4dc.y(), vector4dc.z(), vector4d);
    }

    public Vector4d transform(double d2, double d3, double d4, Vector4d vector4d) {
        double d5 = this.x * this.x;
        double d6 = this.y * this.y;
        double d7 = this.z * this.z;
        double d8 = this.w * this.w;
        double d9 = this.x * this.y;
        double d10 = this.x * this.z;
        double d11 = this.y * this.z;
        double d12 = this.x * this.w;
        double d13 = this.z * this.w;
        double d14 = this.y * this.w;
        double d15 = 1.0 / (d5 + d6 + d7 + d8);
        return vector4d.set(Math.fma((d5 - d6 - d7 + d8) * d15, d2, Math.fma(2.0 * (d9 - d13) * d15, d3, 2.0 * (d10 + d14) * d15 * d4)), Math.fma(2.0 * (d9 + d13) * d15, d2, Math.fma((d6 - d5 - d7 + d8) * d15, d3, 2.0 * (d11 - d12) * d15 * d4)), Math.fma(2.0 * (d10 - d14) * d15, d2, Math.fma(2.0 * (d11 + d12) * d15, d3, (d7 - d5 - d6 + d8) * d15 * d4)), vector4d.w);
    }

    public Vector4d transformInverse(double d2, double d3, double d4, Vector4d vector4d) {
        double d5 = 1.0 / Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
        double d6 = this.x * d5;
        double d7 = this.y * d5;
        double d8 = this.z * d5;
        double d9 = this.w * d5;
        double d10 = d6 * d6;
        double d11 = d7 * d7;
        double d12 = d8 * d8;
        double d13 = d9 * d9;
        double d14 = d6 * d7;
        double d15 = d6 * d8;
        double d16 = d7 * d8;
        double d17 = d6 * d9;
        double d18 = d8 * d9;
        double d19 = d7 * d9;
        double d20 = 1.0 / (d10 + d11 + d12 + d13);
        return vector4d.set(Math.fma((d10 - d11 - d12 + d13) * d20, d2, Math.fma(2.0 * (d14 + d18) * d20, d3, 2.0 * (d15 - d19) * d20 * d4)), Math.fma(2.0 * (d14 - d18) * d20, d2, Math.fma((d11 - d10 - d12 + d13) * d20, d3, 2.0 * (d16 + d17) * d20 * d4)), Math.fma(2.0 * (d15 + d19) * d20, d2, Math.fma(2.0 * (d16 - d17) * d20, d3, (d12 - d10 - d11 + d13) * d20 * d4)));
    }

    public Vector3f transform(Vector3f vector3f) {
        return this.transform((double)vector3f.x, (double)vector3f.y, (double)vector3f.z, vector3f);
    }

    public Vector3f transformInverse(Vector3f vector3f) {
        return this.transformInverse((double)vector3f.x, (double)vector3f.y, (double)vector3f.z, vector3f);
    }

    public Vector4d transformUnit(Vector4d vector4d) {
        return this.transformUnit(vector4d, vector4d);
    }

    public Vector4d transformInverseUnit(Vector4d vector4d) {
        return this.transformInverseUnit(vector4d, vector4d);
    }

    public Vector3d transformUnit(Vector3dc vector3dc, Vector3d vector3d) {
        return this.transformUnit(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3d);
    }

    public Vector3d transformInverseUnit(Vector3dc vector3dc, Vector3d vector3d) {
        return this.transformInverseUnit(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3d);
    }

    public Vector3d transformUnit(double d2, double d3, double d4, Vector3d vector3d) {
        double d5 = this.x * this.x;
        double d6 = this.x * this.y;
        double d7 = this.x * this.z;
        double d8 = this.x * this.w;
        double d9 = this.y * this.y;
        double d10 = this.y * this.z;
        double d11 = this.y * this.w;
        double d12 = this.z * this.z;
        double d13 = this.z * this.w;
        return vector3d.set(Math.fma(Math.fma(-2.0, d9 + d12, 1.0), d2, Math.fma(2.0 * (d6 - d13), d3, 2.0 * (d7 + d11) * d4)), Math.fma(2.0 * (d6 + d13), d2, Math.fma(Math.fma(-2.0, d5 + d12, 1.0), d3, 2.0 * (d10 - d8) * d4)), Math.fma(2.0 * (d7 - d11), d2, Math.fma(2.0 * (d10 + d8), d3, Math.fma(-2.0, d5 + d9, 1.0) * d4)));
    }

    public Vector3d transformInverseUnit(double d2, double d3, double d4, Vector3d vector3d) {
        double d5 = this.x * this.x;
        double d6 = this.x * this.y;
        double d7 = this.x * this.z;
        double d8 = this.x * this.w;
        double d9 = this.y * this.y;
        double d10 = this.y * this.z;
        double d11 = this.y * this.w;
        double d12 = this.z * this.z;
        double d13 = this.z * this.w;
        return vector3d.set(Math.fma(Math.fma(-2.0, d9 + d12, 1.0), d2, Math.fma(2.0 * (d6 + d13), d3, 2.0 * (d7 - d11) * d4)), Math.fma(2.0 * (d6 - d13), d2, Math.fma(Math.fma(-2.0, d5 + d12, 1.0), d3, 2.0 * (d10 + d8) * d4)), Math.fma(2.0 * (d7 + d11), d2, Math.fma(2.0 * (d10 - d8), d3, Math.fma(-2.0, d5 + d9, 1.0) * d4)));
    }

    public Vector4d transformUnit(Vector4dc vector4dc, Vector4d vector4d) {
        return this.transformUnit(vector4dc.x(), vector4dc.y(), vector4dc.z(), vector4d);
    }

    public Vector4d transformInverseUnit(Vector4dc vector4dc, Vector4d vector4d) {
        return this.transformInverseUnit(vector4dc.x(), vector4dc.y(), vector4dc.z(), vector4d);
    }

    public Vector4d transformUnit(double d2, double d3, double d4, Vector4d vector4d) {
        double d5 = this.x * this.x;
        double d6 = this.x * this.y;
        double d7 = this.x * this.z;
        double d8 = this.x * this.w;
        double d9 = this.y * this.y;
        double d10 = this.y * this.z;
        double d11 = this.y * this.w;
        double d12 = this.z * this.z;
        double d13 = this.z * this.w;
        return vector4d.set(Math.fma(Math.fma(-2.0, d9 + d12, 1.0), d2, Math.fma(2.0 * (d6 - d13), d3, 2.0 * (d7 + d11) * d4)), Math.fma(2.0 * (d6 + d13), d2, Math.fma(Math.fma(-2.0, d5 + d12, 1.0), d3, 2.0 * (d10 - d8) * d4)), Math.fma(2.0 * (d7 - d11), d2, Math.fma(2.0 * (d10 + d8), d3, Math.fma(-2.0, d5 + d9, 1.0) * d4)), vector4d.w);
    }

    public Vector4d transformInverseUnit(double d2, double d3, double d4, Vector4d vector4d) {
        double d5 = this.x * this.x;
        double d6 = this.x * this.y;
        double d7 = this.x * this.z;
        double d8 = this.x * this.w;
        double d9 = this.y * this.y;
        double d10 = this.y * this.z;
        double d11 = this.y * this.w;
        double d12 = this.z * this.z;
        double d13 = this.z * this.w;
        return vector4d.set(Math.fma(Math.fma(-2.0, d9 + d12, 1.0), d2, Math.fma(2.0 * (d6 + d13), d3, 2.0 * (d7 - d11) * d4)), Math.fma(2.0 * (d6 - d13), d2, Math.fma(Math.fma(-2.0, d5 + d12, 1.0), d3, 2.0 * (d10 + d8) * d4)), Math.fma(2.0 * (d7 + d11), d2, Math.fma(2.0 * (d10 - d8), d3, Math.fma(-2.0, d5 + d9, 1.0) * d4)), vector4d.w);
    }

    public Vector3f transformUnit(Vector3f vector3f) {
        return this.transformUnit((double)vector3f.x, (double)vector3f.y, (double)vector3f.z, vector3f);
    }

    public Vector3f transformInverseUnit(Vector3f vector3f) {
        return this.transformInverseUnit((double)vector3f.x, (double)vector3f.y, (double)vector3f.z, vector3f);
    }

    public Vector3f transformPositiveX(Vector3f vector3f) {
        double d2 = this.w * this.w;
        double d3 = this.x * this.x;
        double d4 = this.y * this.y;
        double d5 = this.z * this.z;
        double d6 = this.z * this.w;
        double d7 = this.x * this.y;
        double d8 = this.x * this.z;
        double d9 = this.y * this.w;
        vector3f.x = (float)(d2 + d3 - d5 - d4);
        vector3f.y = (float)(d7 + d6 + d6 + d7);
        vector3f.z = (float)(d8 - d9 + d8 - d9);
        return vector3f;
    }

    public Vector4f transformPositiveX(Vector4f vector4f) {
        double d2 = this.w * this.w;
        double d3 = this.x * this.x;
        double d4 = this.y * this.y;
        double d5 = this.z * this.z;
        double d6 = this.z * this.w;
        double d7 = this.x * this.y;
        double d8 = this.x * this.z;
        double d9 = this.y * this.w;
        vector4f.x = (float)(d2 + d3 - d5 - d4);
        vector4f.y = (float)(d7 + d6 + d6 + d7);
        vector4f.z = (float)(d8 - d9 + d8 - d9);
        return vector4f;
    }

    public Vector3f transformUnitPositiveX(Vector3f vector3f) {
        double d2 = this.y * this.y;
        double d3 = this.z * this.z;
        double d4 = this.x * this.y;
        double d5 = this.x * this.z;
        double d6 = this.y * this.w;
        double d7 = this.z * this.w;
        vector3f.x = (float)(1.0 - d2 - d2 - d3 - d3);
        vector3f.y = (float)(d4 + d7 + d4 + d7);
        vector3f.z = (float)(d5 - d6 + d5 - d6);
        return vector3f;
    }

    public Vector4f transformUnitPositiveX(Vector4f vector4f) {
        double d2 = this.y * this.y;
        double d3 = this.z * this.z;
        double d4 = this.x * this.y;
        double d5 = this.x * this.z;
        double d6 = this.y * this.w;
        double d7 = this.z * this.w;
        vector4f.x = (float)(1.0 - d2 - d2 - d3 - d3);
        vector4f.y = (float)(d4 + d7 + d4 + d7);
        vector4f.z = (float)(d5 - d6 + d5 - d6);
        return vector4f;
    }

    public Vector3f transformPositiveY(Vector3f vector3f) {
        double d2 = this.w * this.w;
        double d3 = this.x * this.x;
        double d4 = this.y * this.y;
        double d5 = this.z * this.z;
        double d6 = this.z * this.w;
        double d7 = this.x * this.y;
        double d8 = this.y * this.z;
        double d9 = this.x * this.w;
        vector3f.x = (float)(-d6 + d7 - d6 + d7);
        vector3f.y = (float)(d4 - d5 + d2 - d3);
        vector3f.z = (float)(d8 + d8 + d9 + d9);
        return vector3f;
    }

    public Vector4f transformPositiveY(Vector4f vector4f) {
        double d2 = this.w * this.w;
        double d3 = this.x * this.x;
        double d4 = this.y * this.y;
        double d5 = this.z * this.z;
        double d6 = this.z * this.w;
        double d7 = this.x * this.y;
        double d8 = this.y * this.z;
        double d9 = this.x * this.w;
        vector4f.x = (float)(-d6 + d7 - d6 + d7);
        vector4f.y = (float)(d4 - d5 + d2 - d3);
        vector4f.z = (float)(d8 + d8 + d9 + d9);
        return vector4f;
    }

    public Vector4f transformUnitPositiveY(Vector4f vector4f) {
        double d2 = this.x * this.x;
        double d3 = this.z * this.z;
        double d4 = this.x * this.y;
        double d5 = this.y * this.z;
        double d6 = this.x * this.w;
        double d7 = this.z * this.w;
        vector4f.x = (float)(d4 - d7 + d4 - d7);
        vector4f.y = (float)(1.0 - d2 - d2 - d3 - d3);
        vector4f.z = (float)(d5 + d5 + d6 + d6);
        return vector4f;
    }

    public Vector3f transformUnitPositiveY(Vector3f vector3f) {
        double d2 = this.x * this.x;
        double d3 = this.z * this.z;
        double d4 = this.x * this.y;
        double d5 = this.y * this.z;
        double d6 = this.x * this.w;
        double d7 = this.z * this.w;
        vector3f.x = (float)(d4 - d7 + d4 - d7);
        vector3f.y = (float)(1.0 - d2 - d2 - d3 - d3);
        vector3f.z = (float)(d5 + d5 + d6 + d6);
        return vector3f;
    }

    public Vector3f transformPositiveZ(Vector3f vector3f) {
        double d2 = this.w * this.w;
        double d3 = this.x * this.x;
        double d4 = this.y * this.y;
        double d5 = this.z * this.z;
        double d6 = this.x * this.z;
        double d7 = this.y * this.w;
        double d8 = this.y * this.z;
        double d9 = this.x * this.w;
        vector3f.x = (float)(d7 + d6 + d6 + d7);
        vector3f.y = (float)(d8 + d8 - d9 - d9);
        vector3f.z = (float)(d5 - d4 - d3 + d2);
        return vector3f;
    }

    public Vector4f transformPositiveZ(Vector4f vector4f) {
        double d2 = this.w * this.w;
        double d3 = this.x * this.x;
        double d4 = this.y * this.y;
        double d5 = this.z * this.z;
        double d6 = this.x * this.z;
        double d7 = this.y * this.w;
        double d8 = this.y * this.z;
        double d9 = this.x * this.w;
        vector4f.x = (float)(d7 + d6 + d6 + d7);
        vector4f.y = (float)(d8 + d8 - d9 - d9);
        vector4f.z = (float)(d5 - d4 - d3 + d2);
        return vector4f;
    }

    public Vector4f transformUnitPositiveZ(Vector4f vector4f) {
        double d2 = this.x * this.x;
        double d3 = this.y * this.y;
        double d4 = this.x * this.z;
        double d5 = this.y * this.z;
        double d6 = this.x * this.w;
        double d7 = this.y * this.w;
        vector4f.x = (float)(d4 + d7 + d4 + d7);
        vector4f.y = (float)(d5 + d5 - d6 - d6);
        vector4f.z = (float)(1.0 - d2 - d2 - d3 - d3);
        return vector4f;
    }

    public Vector3f transformUnitPositiveZ(Vector3f vector3f) {
        double d2 = this.x * this.x;
        double d3 = this.y * this.y;
        double d4 = this.x * this.z;
        double d5 = this.y * this.z;
        double d6 = this.x * this.w;
        double d7 = this.y * this.w;
        vector3f.x = (float)(d4 + d7 + d4 + d7);
        vector3f.y = (float)(d5 + d5 - d6 - d6);
        vector3f.z = (float)(1.0 - d2 - d2 - d3 - d3);
        return vector3f;
    }

    public Vector4f transform(Vector4f vector4f) {
        return this.transform(vector4f, vector4f);
    }

    public Vector4f transformInverse(Vector4f vector4f) {
        return this.transformInverse(vector4f, vector4f);
    }

    public Vector3f transform(Vector3fc vector3fc, Vector3f vector3f) {
        return this.transform((double)vector3fc.x(), (double)vector3fc.y(), (double)vector3fc.z(), vector3f);
    }

    public Vector3f transformInverse(Vector3fc vector3fc, Vector3f vector3f) {
        return this.transformInverse((double)vector3fc.x(), (double)vector3fc.y(), (double)vector3fc.z(), vector3f);
    }

    public Vector3f transform(double d2, double d3, double d4, Vector3f vector3f) {
        double d5 = this.x * this.x;
        double d6 = this.y * this.y;
        double d7 = this.z * this.z;
        double d8 = this.w * this.w;
        double d9 = this.x * this.y;
        double d10 = this.x * this.z;
        double d11 = this.y * this.z;
        double d12 = this.x * this.w;
        double d13 = this.z * this.w;
        double d14 = this.y * this.w;
        double d15 = 1.0 / (d5 + d6 + d7 + d8);
        return vector3f.set(Math.fma((d5 - d6 - d7 + d8) * d15, d2, Math.fma(2.0 * (d9 - d13) * d15, d3, 2.0 * (d10 + d14) * d15 * d4)), Math.fma(2.0 * (d9 + d13) * d15, d2, Math.fma((d6 - d5 - d7 + d8) * d15, d3, 2.0 * (d11 - d12) * d15 * d4)), Math.fma(2.0 * (d10 - d14) * d15, d2, Math.fma(2.0 * (d11 + d12) * d15, d3, (d7 - d5 - d6 + d8) * d15 * d4)));
    }

    public Vector3f transformInverse(double d2, double d3, double d4, Vector3f vector3f) {
        double d5 = 1.0 / Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
        double d6 = this.x * d5;
        double d7 = this.y * d5;
        double d8 = this.z * d5;
        double d9 = this.w * d5;
        double d10 = d6 * d6;
        double d11 = d7 * d7;
        double d12 = d8 * d8;
        double d13 = d9 * d9;
        double d14 = d6 * d7;
        double d15 = d6 * d8;
        double d16 = d7 * d8;
        double d17 = d6 * d9;
        double d18 = d8 * d9;
        double d19 = d7 * d9;
        double d20 = 1.0 / (d10 + d11 + d12 + d13);
        return vector3f.set(Math.fma((d10 - d11 - d12 + d13) * d20, d2, Math.fma(2.0 * (d14 + d18) * d20, d3, 2.0 * (d15 - d19) * d20 * d4)), Math.fma(2.0 * (d14 - d18) * d20, d2, Math.fma((d11 - d10 - d12 + d13) * d20, d3, 2.0 * (d16 + d17) * d20 * d4)), Math.fma(2.0 * (d15 + d19) * d20, d2, Math.fma(2.0 * (d16 - d17) * d20, d3, (d12 - d10 - d11 + d13) * d20 * d4)));
    }

    public Vector4f transform(Vector4fc vector4fc, Vector4f vector4f) {
        return this.transform((double)vector4fc.x(), (double)vector4fc.y(), (double)vector4fc.z(), vector4f);
    }

    public Vector4f transformInverse(Vector4fc vector4fc, Vector4f vector4f) {
        return this.transformInverse((double)vector4fc.x(), (double)vector4fc.y(), (double)vector4fc.z(), vector4f);
    }

    public Vector4f transform(double d2, double d3, double d4, Vector4f vector4f) {
        double d5 = this.x * this.x;
        double d6 = this.y * this.y;
        double d7 = this.z * this.z;
        double d8 = this.w * this.w;
        double d9 = this.x * this.y;
        double d10 = this.x * this.z;
        double d11 = this.y * this.z;
        double d12 = this.x * this.w;
        double d13 = this.z * this.w;
        double d14 = this.y * this.w;
        double d15 = 1.0 / (d5 + d6 + d7 + d8);
        return vector4f.set((float)Math.fma((d5 - d6 - d7 + d8) * d15, d2, Math.fma(2.0 * (d9 - d13) * d15, d3, 2.0 * (d10 + d14) * d15 * d4)), (float)Math.fma(2.0 * (d9 + d13) * d15, d2, Math.fma((d6 - d5 - d7 + d8) * d15, d3, 2.0 * (d11 - d12) * d15 * d4)), (float)Math.fma(2.0 * (d10 - d14) * d15, d2, Math.fma(2.0 * (d11 + d12) * d15, d3, (d7 - d5 - d6 + d8) * d15 * d4)), vector4f.w);
    }

    public Vector4f transformInverse(double d2, double d3, double d4, Vector4f vector4f) {
        double d5 = 1.0 / Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
        double d6 = this.x * d5;
        double d7 = this.y * d5;
        double d8 = this.z * d5;
        double d9 = this.w * d5;
        double d10 = d6 * d6;
        double d11 = d7 * d7;
        double d12 = d8 * d8;
        double d13 = d9 * d9;
        double d14 = d6 * d7;
        double d15 = d6 * d8;
        double d16 = d7 * d8;
        double d17 = d6 * d9;
        double d18 = d8 * d9;
        double d19 = d7 * d9;
        double d20 = 1.0 / (d10 + d11 + d12 + d13);
        return vector4f.set(Math.fma((d10 - d11 - d12 + d13) * d20, d2, Math.fma(2.0 * (d14 + d18) * d20, d3, 2.0 * (d15 - d19) * d20 * d4)), Math.fma(2.0 * (d14 - d18) * d20, d2, Math.fma((d11 - d10 - d12 + d13) * d20, d3, 2.0 * (d16 + d17) * d20 * d4)), Math.fma(2.0 * (d15 + d19) * d20, d2, Math.fma(2.0 * (d16 - d17) * d20, d3, (d12 - d10 - d11 + d13) * d20 * d4)), (double)vector4f.w);
    }

    public Vector4f transformUnit(Vector4f vector4f) {
        return this.transformUnit(vector4f, vector4f);
    }

    public Vector4f transformInverseUnit(Vector4f vector4f) {
        return this.transformInverseUnit(vector4f, vector4f);
    }

    public Vector3f transformUnit(Vector3fc vector3fc, Vector3f vector3f) {
        return this.transformUnit((double)vector3fc.x(), (double)vector3fc.y(), (double)vector3fc.z(), vector3f);
    }

    public Vector3f transformInverseUnit(Vector3fc vector3fc, Vector3f vector3f) {
        return this.transformInverseUnit((double)vector3fc.x(), (double)vector3fc.y(), (double)vector3fc.z(), vector3f);
    }

    public Vector3f transformUnit(double d2, double d3, double d4, Vector3f vector3f) {
        double d5 = this.x * this.x;
        double d6 = this.x * this.y;
        double d7 = this.x * this.z;
        double d8 = this.x * this.w;
        double d9 = this.y * this.y;
        double d10 = this.y * this.z;
        double d11 = this.y * this.w;
        double d12 = this.z * this.z;
        double d13 = this.z * this.w;
        return vector3f.set((float)Math.fma(Math.fma(-2.0, d9 + d12, 1.0), d2, Math.fma(2.0 * (d6 - d13), d3, 2.0 * (d7 + d11) * d4)), (float)Math.fma(2.0 * (d6 + d13), d2, Math.fma(Math.fma(-2.0, d5 + d12, 1.0), d3, 2.0 * (d10 - d8) * d4)), (float)Math.fma(2.0 * (d7 - d11), d2, Math.fma(2.0 * (d10 + d8), d3, Math.fma(-2.0, d5 + d9, 1.0) * d4)));
    }

    public Vector3f transformInverseUnit(double d2, double d3, double d4, Vector3f vector3f) {
        double d5 = this.x * this.x;
        double d6 = this.x * this.y;
        double d7 = this.x * this.z;
        double d8 = this.x * this.w;
        double d9 = this.y * this.y;
        double d10 = this.y * this.z;
        double d11 = this.y * this.w;
        double d12 = this.z * this.z;
        double d13 = this.z * this.w;
        return vector3f.set((float)Math.fma(Math.fma(-2.0, d9 + d12, 1.0), d2, Math.fma(2.0 * (d6 + d13), d3, 2.0 * (d7 - d11) * d4)), (float)Math.fma(2.0 * (d6 - d13), d2, Math.fma(Math.fma(-2.0, d5 + d12, 1.0), d3, 2.0 * (d10 + d8) * d4)), (float)Math.fma(2.0 * (d7 + d11), d2, Math.fma(2.0 * (d10 - d8), d3, Math.fma(-2.0, d5 + d9, 1.0) * d4)));
    }

    public Vector4f transformUnit(Vector4fc vector4fc, Vector4f vector4f) {
        return this.transformUnit((double)vector4fc.x(), (double)vector4fc.y(), (double)vector4fc.z(), vector4f);
    }

    public Vector4f transformInverseUnit(Vector4fc vector4fc, Vector4f vector4f) {
        return this.transformInverseUnit((double)vector4fc.x(), (double)vector4fc.y(), (double)vector4fc.z(), vector4f);
    }

    public Vector4f transformUnit(double d2, double d3, double d4, Vector4f vector4f) {
        double d5 = this.x * this.x;
        double d6 = this.x * this.y;
        double d7 = this.x * this.z;
        double d8 = this.x * this.w;
        double d9 = this.y * this.y;
        double d10 = this.y * this.z;
        double d11 = this.y * this.w;
        double d12 = this.z * this.z;
        double d13 = this.z * this.w;
        return vector4f.set((float)Math.fma(Math.fma(-2.0, d9 + d12, 1.0), d2, Math.fma(2.0 * (d6 - d13), d3, 2.0 * (d7 + d11) * d4)), (float)Math.fma(2.0 * (d6 + d13), d2, Math.fma(Math.fma(-2.0, d5 + d12, 1.0), d3, 2.0 * (d10 - d8) * d4)), (float)Math.fma(2.0 * (d7 - d11), d2, Math.fma(2.0 * (d10 + d8), d3, Math.fma(-2.0, d5 + d9, 1.0) * d4)));
    }

    public Vector4f transformInverseUnit(double d2, double d3, double d4, Vector4f vector4f) {
        double d5 = this.x * this.x;
        double d6 = this.x * this.y;
        double d7 = this.x * this.z;
        double d8 = this.x * this.w;
        double d9 = this.y * this.y;
        double d10 = this.y * this.z;
        double d11 = this.y * this.w;
        double d12 = this.z * this.z;
        double d13 = this.z * this.w;
        return vector4f.set((float)Math.fma(Math.fma(-2.0, d9 + d12, 1.0), d2, Math.fma(2.0 * (d6 + d13), d3, 2.0 * (d7 - d11) * d4)), (float)Math.fma(2.0 * (d6 - d13), d2, Math.fma(Math.fma(-2.0, d5 + d12, 1.0), d3, 2.0 * (d10 + d8) * d4)), (float)Math.fma(2.0 * (d7 + d11), d2, Math.fma(2.0 * (d10 - d8), d3, Math.fma(-2.0, d5 + d9, 1.0) * d4)));
    }

    public Quaterniond invert(Quaterniond quaterniond) {
        double d2 = 1.0 / this.lengthSquared();
        quaterniond.x = -this.x * d2;
        quaterniond.y = -this.y * d2;
        quaterniond.z = -this.z * d2;
        quaterniond.w = this.w * d2;
        return quaterniond;
    }

    public Quaterniond invert() {
        return this.invert(this);
    }

    public Quaterniond div(Quaterniondc quaterniondc, Quaterniond quaterniond) {
        double d2 = 1.0 / Math.fma(quaterniondc.x(), quaterniondc.x(), Math.fma(quaterniondc.y(), quaterniondc.y(), Math.fma(quaterniondc.z(), quaterniondc.z(), quaterniondc.w() * quaterniondc.w())));
        double d3 = -quaterniondc.x() * d2;
        double d4 = -quaterniondc.y() * d2;
        double d5 = -quaterniondc.z() * d2;
        double d6 = quaterniondc.w() * d2;
        return quaterniond.set(Math.fma(this.w, d3, Math.fma(this.x, d6, Math.fma(this.y, d5, -this.z * d4))), Math.fma(this.w, d4, Math.fma(-this.x, d5, Math.fma(this.y, d6, this.z * d3))), Math.fma(this.w, d5, Math.fma(this.x, d4, Math.fma(-this.y, d3, this.z * d6))), Math.fma(this.w, d6, Math.fma(-this.x, d3, Math.fma(-this.y, d4, -this.z * d5))));
    }

    public Quaterniond div(Quaterniondc quaterniondc) {
        return this.div(quaterniondc, this);
    }

    public Quaterniond conjugate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Quaterniond conjugate(Quaterniond quaterniond) {
        quaterniond.x = -this.x;
        quaterniond.y = -this.y;
        quaterniond.z = -this.z;
        quaterniond.w = this.w;
        return quaterniond;
    }

    public Quaterniond identity() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        this.w = 1.0;
        return this;
    }

    public double lengthSquared() {
        return Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
    }

    public Quaterniond rotationXYZ(double d2, double d3, double d4) {
        double d5 = Math.sin(d2 * 0.5);
        double d6 = Math.cosFromSin(d5, d2 * 0.5);
        double d7 = Math.sin(d3 * 0.5);
        double d8 = Math.cosFromSin(d7, d3 * 0.5);
        double d9 = Math.sin(d4 * 0.5);
        double d10 = Math.cosFromSin(d9, d4 * 0.5);
        double d11 = d8 * d10;
        double d12 = d7 * d9;
        double d13 = d7 * d10;
        double d14 = d8 * d9;
        this.w = d6 * d11 - d5 * d12;
        this.x = d5 * d11 + d6 * d12;
        this.y = d6 * d13 - d5 * d14;
        this.z = d6 * d14 + d5 * d13;
        return this;
    }

    public Quaterniond rotationZYX(double d2, double d3, double d4) {
        double d5 = Math.sin(d4 * 0.5);
        double d6 = Math.cosFromSin(d5, d4 * 0.5);
        double d7 = Math.sin(d3 * 0.5);
        double d8 = Math.cosFromSin(d7, d3 * 0.5);
        double d9 = Math.sin(d2 * 0.5);
        double d10 = Math.cosFromSin(d9, d2 * 0.5);
        double d11 = d8 * d10;
        double d12 = d7 * d9;
        double d13 = d7 * d10;
        double d14 = d8 * d9;
        this.w = d6 * d11 + d5 * d12;
        this.x = d5 * d11 - d6 * d12;
        this.y = d6 * d13 + d5 * d14;
        this.z = d6 * d14 - d5 * d13;
        return this;
    }

    public Quaterniond rotationYXZ(double d2, double d3, double d4) {
        double d5 = Math.sin(d3 * 0.5);
        double d6 = Math.cosFromSin(d5, d3 * 0.5);
        double d7 = Math.sin(d2 * 0.5);
        double d8 = Math.cosFromSin(d7, d2 * 0.5);
        double d9 = Math.sin(d4 * 0.5);
        double d10 = Math.cosFromSin(d9, d4 * 0.5);
        double d11 = d8 * d5;
        double d12 = d7 * d6;
        double d13 = d7 * d5;
        double d14 = d8 * d6;
        this.x = d11 * d10 + d12 * d9;
        this.y = d12 * d10 - d11 * d9;
        this.z = d14 * d9 - d13 * d10;
        this.w = d14 * d10 + d13 * d9;
        return this;
    }

    public Quaterniond slerp(Quaterniondc quaterniondc, double d2) {
        return this.slerp(quaterniondc, d2, this);
    }

    public Quaterniond slerp(Quaterniondc quaterniondc, double d2, Quaterniond quaterniond) {
        double d3;
        double d4;
        double d5 = Math.fma(this.x, quaterniondc.x(), Math.fma(this.y, quaterniondc.y(), Math.fma(this.z, quaterniondc.z(), this.w * quaterniondc.w())));
        double d6 = Math.abs(d5);
        if (1.0 - d6 > 1.0E-6) {
            double d7 = 1.0 - d6 * d6;
            double d8 = Math.invsqrt(d7);
            double d9 = Math.atan2(d7 * d8, d6);
            d4 = Math.sin((1.0 - d2) * d9) * d8;
            d3 = Math.sin(d2 * d9) * d8;
        } else {
            d4 = 1.0 - d2;
            d3 = d2;
        }
        d3 = d5 >= 0.0 ? d3 : -d3;
        quaterniond.x = Math.fma(d4, this.x, d3 * quaterniondc.x());
        quaterniond.y = Math.fma(d4, this.y, d3 * quaterniondc.y());
        quaterniond.z = Math.fma(d4, this.z, d3 * quaterniondc.z());
        quaterniond.w = Math.fma(d4, this.w, d3 * quaterniondc.w());
        return quaterniond;
    }

    public static Quaterniondc slerp(Quaterniond[] quaterniondArray, double[] dArray, Quaterniond quaterniond) {
        quaterniond.set(quaterniondArray[0]);
        double d2 = dArray[0];
        for (int i2 = 1; i2 < quaterniondArray.length; ++i2) {
            double d3 = d2;
            double d4 = dArray[i2];
            double d5 = d4 / (d3 + d4);
            d2 += d4;
            quaterniond.slerp(quaterniondArray[i2], d5);
        }
        return quaterniond;
    }

    public Quaterniond scale(double d2) {
        return this.scale(d2, this);
    }

    public Quaterniond scale(double d2, Quaterniond quaterniond) {
        double d3 = Math.sqrt(d2);
        quaterniond.x = d3 * this.x;
        quaterniond.y = d3 * this.y;
        quaterniond.z = d3 * this.z;
        quaterniond.w = d3 * this.w;
        return quaterniond;
    }

    public Quaterniond scaling(double d2) {
        double d3 = Math.sqrt(d2);
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        this.w = d3;
        return this;
    }

    public Quaterniond integrate(double d2, double d3, double d4, double d5) {
        return this.integrate(d2, d3, d4, d5, this);
    }

    public Quaterniond integrate(double d2, double d3, double d4, double d5, Quaterniond quaterniond) {
        double d6;
        double d7;
        double d8 = d2 * d3 * 0.5;
        double d9 = d2 * d4 * 0.5;
        double d10 = d2 * d5 * 0.5;
        double d11 = d8 * d8 + d9 * d9 + d10 * d10;
        if (d11 * d11 / 24.0 < 1.0E-8) {
            d7 = 1.0 - d11 * 0.5;
            d6 = 1.0 - d11 / 6.0;
        } else {
            double d12 = Math.sqrt(d11);
            double d13 = Math.sin(d12);
            d6 = d13 / d12;
            d7 = Math.cosFromSin(d13, d12);
        }
        double d14 = d8 * d6;
        double d15 = d9 * d6;
        double d16 = d10 * d6;
        return quaterniond.set(Math.fma(d7, this.x, Math.fma(d14, this.w, Math.fma(d15, this.z, -d16 * this.y))), Math.fma(d7, this.y, Math.fma(-d14, this.z, Math.fma(d15, this.w, d16 * this.x))), Math.fma(d7, this.z, Math.fma(d14, this.y, Math.fma(-d15, this.x, d16 * this.w))), Math.fma(d7, this.w, Math.fma(-d14, this.x, Math.fma(-d15, this.y, -d16 * this.z))));
    }

    public Quaterniond nlerp(Quaterniondc quaterniondc, double d2) {
        return this.nlerp(quaterniondc, d2, this);
    }

    public Quaterniond nlerp(Quaterniondc quaterniondc, double d2, Quaterniond quaterniond) {
        double d3 = Math.fma(this.x, quaterniondc.x(), Math.fma(this.y, quaterniondc.y(), Math.fma(this.z, quaterniondc.z(), this.w * quaterniondc.w())));
        double d4 = 1.0 - d2;
        double d5 = d3 >= 0.0 ? d2 : -d2;
        quaterniond.x = Math.fma(d4, this.x, d5 * quaterniondc.x());
        quaterniond.y = Math.fma(d4, this.y, d5 * quaterniondc.y());
        quaterniond.z = Math.fma(d4, this.z, d5 * quaterniondc.z());
        quaterniond.w = Math.fma(d4, this.w, d5 * quaterniondc.w());
        double d6 = Math.invsqrt(Math.fma(quaterniond.x, quaterniond.x, Math.fma(quaterniond.y, quaterniond.y, Math.fma(quaterniond.z, quaterniond.z, quaterniond.w * quaterniond.w))));
        quaterniond.x *= d6;
        quaterniond.y *= d6;
        quaterniond.z *= d6;
        quaterniond.w *= d6;
        return quaterniond;
    }

    public static Quaterniondc nlerp(Quaterniond[] quaterniondArray, double[] dArray, Quaterniond quaterniond) {
        quaterniond.set(quaterniondArray[0]);
        double d2 = dArray[0];
        for (int i2 = 1; i2 < quaterniondArray.length; ++i2) {
            double d3 = d2;
            double d4 = dArray[i2];
            double d5 = d4 / (d3 + d4);
            d2 += d4;
            quaterniond.nlerp(quaterniondArray[i2], d5);
        }
        return quaterniond;
    }

    public Quaterniond nlerpIterative(Quaterniondc quaterniondc, double d2, double d3, Quaterniond quaterniond) {
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9 = this.x;
        double d10 = this.y;
        double d11 = this.z;
        double d12 = this.w;
        double d13 = quaterniondc.x();
        double d14 = Math.fma(d9, d13, Math.fma(d10, d8 = quaterniondc.y(), Math.fma(d11, d7 = quaterniondc.z(), d12 * (d6 = quaterniondc.w()))));
        double d15 = Math.abs(d14);
        if (0.999999 < d15) {
            return quaterniond.set(this);
        }
        double d16 = d2;
        while (d15 < d3) {
            float f2;
            d5 = 0.5;
            double d17 = d4 = d14 >= 0.0 ? 0.5 : -0.5;
            if (d16 < 0.5) {
                d13 = Math.fma(d5, d13, d4 * d9);
                d8 = Math.fma(d5, d8, d4 * d10);
                d7 = Math.fma(d5, d7, d4 * d11);
                d6 = Math.fma(d5, d6, d4 * d12);
                f2 = (float)Math.invsqrt(Math.fma(d13, d13, Math.fma(d8, d8, Math.fma(d7, d7, d6 * d6))));
                d13 *= (double)f2;
                d8 *= (double)f2;
                d7 *= (double)f2;
                d6 *= (double)f2;
                d16 += d16;
            } else {
                d9 = Math.fma(d5, d9, d4 * d13);
                d10 = Math.fma(d5, d10, d4 * d8);
                d11 = Math.fma(d5, d11, d4 * d7);
                d12 = Math.fma(d5, d12, d4 * d6);
                f2 = (float)Math.invsqrt(Math.fma(d9, d9, Math.fma(d10, d10, Math.fma(d11, d11, d12 * d12))));
                d9 *= (double)f2;
                d10 *= (double)f2;
                d11 *= (double)f2;
                d12 *= (double)f2;
                d16 = d16 + d16 - 1.0;
            }
            d14 = Math.fma(d9, d13, Math.fma(d10, d8, Math.fma(d11, d7, d12 * d6)));
            d15 = Math.abs(d14);
        }
        d5 = 1.0 - d16;
        d4 = d14 >= 0.0 ? d16 : -d16;
        double d18 = Math.fma(d5, d9, d4 * d13);
        double d19 = Math.fma(d5, d10, d4 * d8);
        double d20 = Math.fma(d5, d11, d4 * d7);
        double d21 = Math.fma(d5, d12, d4 * d6);
        double d22 = Math.invsqrt(Math.fma(d18, d18, Math.fma(d19, d19, Math.fma(d20, d20, d21 * d21))));
        quaterniond.x = d18 * d22;
        quaterniond.y = d19 * d22;
        quaterniond.z = d20 * d22;
        quaterniond.w = d21 * d22;
        return quaterniond;
    }

    public Quaterniond nlerpIterative(Quaterniondc quaterniondc, double d2, double d3) {
        return this.nlerpIterative(quaterniondc, d2, d3, this);
    }

    public static Quaterniond nlerpIterative(Quaterniondc[] quaterniondcArray, double[] dArray, double d2, Quaterniond quaterniond) {
        quaterniond.set(quaterniondcArray[0]);
        double d3 = dArray[0];
        for (int i2 = 1; i2 < quaterniondcArray.length; ++i2) {
            double d4 = d3;
            double d5 = dArray[i2];
            double d6 = d5 / (d4 + d5);
            d3 += d5;
            quaterniond.nlerpIterative(quaterniondcArray[i2], d6, d2);
        }
        return quaterniond;
    }

    public Quaterniond lookAlong(Vector3dc vector3dc, Vector3dc vector3dc2) {
        return this.lookAlong(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), this);
    }

    public Quaterniond lookAlong(Vector3dc vector3dc, Vector3dc vector3dc2, Quaterniond quaterniond) {
        return this.lookAlong(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), quaterniond);
    }

    public Quaterniond lookAlong(double d2, double d3, double d4, double d5, double d6, double d7) {
        return this.lookAlong(d2, d3, d4, d5, d6, d7, this);
    }

    public Quaterniond lookAlong(double d2, double d3, double d4, double d5, double d6, double d7, Quaterniond quaterniond) {
        double d8;
        double d9;
        double d10;
        double d11;
        double d12 = Math.invsqrt(d2 * d2 + d3 * d3 + d4 * d4);
        double d13 = -d2 * d12;
        double d14 = -d3 * d12;
        double d15 = -d4 * d12;
        double d16 = d6 * d15 - d7 * d14;
        double d17 = d7 * d13 - d5 * d15;
        double d18 = d5 * d14 - d6 * d13;
        double d19 = Math.invsqrt(d16 * d16 + d17 * d17 + d18 * d18);
        double d20 = d14 * (d18 *= d19) - d15 * (d17 *= d19);
        double d21 = d15 * (d16 *= d19) - d13 * d18;
        double d22 = d13 * d17 - d14 * d16;
        double d23 = d16 + d21 + d15;
        if (d23 >= 0.0) {
            double d24 = Math.sqrt(d23 + 1.0);
            d11 = d24 * 0.5;
            d24 = 0.5 / d24;
            d10 = (d14 - d22) * d24;
            d9 = (d18 - d13) * d24;
            d8 = (d20 - d17) * d24;
        } else if (d16 > d21 && d16 > d15) {
            double d25 = Math.sqrt(1.0 + d16 - d21 - d15);
            d10 = d25 * 0.5;
            d25 = 0.5 / d25;
            d9 = (d17 + d20) * d25;
            d8 = (d13 + d18) * d25;
            d11 = (d14 - d22) * d25;
        } else if (d21 > d15) {
            double d26 = Math.sqrt(1.0 + d21 - d16 - d15);
            d9 = d26 * 0.5;
            d26 = 0.5 / d26;
            d10 = (d17 + d20) * d26;
            d8 = (d22 + d14) * d26;
            d11 = (d18 - d13) * d26;
        } else {
            double d27 = Math.sqrt(1.0 + d15 - d16 - d21);
            d8 = d27 * 0.5;
            d27 = 0.5 / d27;
            d10 = (d13 + d18) * d27;
            d9 = (d22 + d14) * d27;
            d11 = (d20 - d17) * d27;
        }
        return quaterniond.set(Math.fma(this.w, d10, Math.fma(this.x, d11, Math.fma(this.y, d8, -this.z * d9))), Math.fma(this.w, d9, Math.fma(-this.x, d8, Math.fma(this.y, d11, this.z * d10))), Math.fma(this.w, d8, Math.fma(this.x, d9, Math.fma(-this.y, d10, this.z * d11))), Math.fma(this.w, d11, Math.fma(-this.x, d10, Math.fma(-this.y, d9, -this.z * d8))));
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat numberFormat) {
        return "(" + Runtime.format(this.x, numberFormat) + " " + Runtime.format(this.y, numberFormat) + " " + Runtime.format(this.z, numberFormat) + " " + Runtime.format(this.w, numberFormat) + ")";
    }

    public void writeExternal(ObjectOutput objectOutput) {
        objectOutput.writeDouble(this.x);
        objectOutput.writeDouble(this.y);
        objectOutput.writeDouble(this.z);
        objectOutput.writeDouble(this.w);
    }

    public void readExternal(ObjectInput objectInput) {
        this.x = objectInput.readDouble();
        this.y = objectInput.readDouble();
        this.z = objectInput.readDouble();
        this.w = objectInput.readDouble();
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        long l2 = Double.doubleToLongBits(this.w);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.x);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.y);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.z);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Quaterniond quaterniond = (Quaterniond)object;
        if (Double.doubleToLongBits(this.w) != Double.doubleToLongBits(quaterniond.w)) {
            return false;
        }
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(quaterniond.x)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(quaterniond.y)) {
            return false;
        }
        return Double.doubleToLongBits(this.z) == Double.doubleToLongBits(quaterniond.z);
    }

    public Quaterniond difference(Quaterniondc quaterniondc) {
        return this.difference(quaterniondc, this);
    }

    public Quaterniond difference(Quaterniondc quaterniondc, Quaterniond quaterniond) {
        double d2 = 1.0 / this.lengthSquared();
        double d3 = -this.x * d2;
        double d4 = -this.y * d2;
        double d5 = -this.z * d2;
        double d6 = this.w * d2;
        quaterniond.set(Math.fma(d6, quaterniondc.x(), Math.fma(d3, quaterniondc.w(), Math.fma(d4, quaterniondc.z(), -d5 * quaterniondc.y()))), Math.fma(d6, quaterniondc.y(), Math.fma(-d3, quaterniondc.z(), Math.fma(d4, quaterniondc.w(), d5 * quaterniondc.x()))), Math.fma(d6, quaterniondc.z(), Math.fma(d3, quaterniondc.y(), Math.fma(-d4, quaterniondc.x(), d5 * quaterniondc.w()))), Math.fma(d6, quaterniondc.w(), Math.fma(-d3, quaterniondc.x(), Math.fma(-d4, quaterniondc.y(), -d5 * quaterniondc.z()))));
        return quaterniond;
    }

    public Quaterniond rotationTo(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13;
        double d14 = Math.invsqrt(Math.fma(d2, d2, Math.fma(d3, d3, d4 * d4)));
        double d15 = d2 * d14;
        double d16 = d15 * (d13 = d5 * (d12 = Math.invsqrt(Math.fma(d5, d5, Math.fma(d6, d6, d7 * d7))))) + (d11 = d3 * d14) * (d10 = d6 * d12) + (d9 = d4 * d14) * (d8 = d7 * d12);
        if (d16 < -0.999999) {
            double d17 = d11;
            double d18 = -d15;
            double d19 = 0.0;
            double d20 = 0.0;
            if (d17 * d17 + d18 * d18 == 0.0) {
                d17 = 0.0;
                d18 = d9;
                d19 = -d11;
                d20 = 0.0;
            }
            this.x = d17;
            this.y = d18;
            this.z = d19;
            this.w = 0.0;
        } else {
            double d21 = Math.sqrt((1.0 + d16) * 2.0);
            double d22 = 1.0 / d21;
            double d23 = d11 * d8 - d9 * d10;
            double d24 = d9 * d13 - d15 * d8;
            double d25 = d15 * d10 - d11 * d13;
            double d26 = d23 * d22;
            double d27 = d24 * d22;
            double d28 = d25 * d22;
            double d29 = d21 * 0.5;
            double d30 = Math.invsqrt(Math.fma(d26, d26, Math.fma(d27, d27, Math.fma(d28, d28, d29 * d29))));
            this.x = d26 * d30;
            this.y = d27 * d30;
            this.z = d28 * d30;
            this.w = d29 * d30;
        }
        return this;
    }

    public Quaterniond rotationTo(Vector3dc vector3dc, Vector3dc vector3dc2) {
        return this.rotationTo(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z());
    }

    public Quaterniond rotateTo(double d2, double d3, double d4, double d5, double d6, double d7, Quaterniond quaterniond) {
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13;
        double d14;
        double d15;
        double d16;
        double d17;
        double d18 = Math.invsqrt(Math.fma(d2, d2, Math.fma(d3, d3, d4 * d4)));
        double d19 = d2 * d18;
        double d20 = d19 * (d17 = d5 * (d16 = Math.invsqrt(Math.fma(d5, d5, Math.fma(d6, d6, d7 * d7))))) + (d15 = d3 * d18) * (d14 = d6 * d16) + (d13 = d4 * d18) * (d12 = d7 * d16);
        if (d20 < -0.999999) {
            d11 = d15;
            d10 = -d19;
            d9 = 0.0;
            d8 = 0.0;
            if (d11 * d11 + d10 * d10 == 0.0) {
                d11 = 0.0;
                d10 = d13;
                d9 = -d15;
                d8 = 0.0;
            }
        } else {
            double d21 = Math.sqrt((1.0 + d20) * 2.0);
            double d22 = 1.0 / d21;
            double d23 = d15 * d12 - d13 * d14;
            double d24 = d13 * d17 - d19 * d12;
            double d25 = d19 * d14 - d15 * d17;
            d11 = d23 * d22;
            d10 = d24 * d22;
            d9 = d25 * d22;
            d8 = d21 * 0.5;
            double d26 = Math.invsqrt(Math.fma(d11, d11, Math.fma(d10, d10, Math.fma(d9, d9, d8 * d8))));
            d11 *= d26;
            d10 *= d26;
            d9 *= d26;
            d8 *= d26;
        }
        return quaterniond.set(Math.fma(this.w, d11, Math.fma(this.x, d8, Math.fma(this.y, d9, -this.z * d10))), Math.fma(this.w, d10, Math.fma(-this.x, d9, Math.fma(this.y, d8, this.z * d11))), Math.fma(this.w, d9, Math.fma(this.x, d10, Math.fma(-this.y, d11, this.z * d8))), Math.fma(this.w, d8, Math.fma(-this.x, d11, Math.fma(-this.y, d10, -this.z * d9))));
    }

    public Quaterniond rotationAxis(AxisAngle4f axisAngle4f) {
        return this.rotationAxis(axisAngle4f.angle, axisAngle4f.x, axisAngle4f.y, axisAngle4f.z);
    }

    public Quaterniond rotationAxis(double d2, double d3, double d4, double d5) {
        double d6 = d2 / 2.0;
        double d7 = Math.sin(d6);
        double d8 = Math.invsqrt(d3 * d3 + d4 * d4 + d5 * d5);
        return this.set(d3 * d8 * d7, d4 * d8 * d7, d5 * d8 * d7, Math.cosFromSin(d7, d6));
    }

    public Quaterniond rotationX(double d2) {
        double d3 = Math.sin(d2 * 0.5);
        double d4 = Math.cosFromSin(d3, d2 * 0.5);
        return this.set(d3, 0.0, d4, 0.0);
    }

    public Quaterniond rotationY(double d2) {
        double d3 = Math.sin(d2 * 0.5);
        double d4 = Math.cosFromSin(d3, d2 * 0.5);
        return this.set(0.0, d3, 0.0, d4);
    }

    public Quaterniond rotationZ(double d2) {
        double d3 = Math.sin(d2 * 0.5);
        double d4 = Math.cosFromSin(d3, d2 * 0.5);
        return this.set(0.0, 0.0, d3, d4);
    }

    public Quaterniond rotateTo(double d2, double d3, double d4, double d5, double d6, double d7) {
        return this.rotateTo(d2, d3, d4, d5, d6, d7, this);
    }

    public Quaterniond rotateTo(Vector3dc vector3dc, Vector3dc vector3dc2, Quaterniond quaterniond) {
        return this.rotateTo(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), quaterniond);
    }

    public Quaterniond rotateTo(Vector3dc vector3dc, Vector3dc vector3dc2) {
        return this.rotateTo(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), this);
    }

    public Quaterniond rotateX(double d2) {
        return this.rotateX(d2, this);
    }

    public Quaterniond rotateX(double d2, Quaterniond quaterniond) {
        double d3 = Math.sin(d2 * 0.5);
        double d4 = Math.cosFromSin(d3, d2 * 0.5);
        return quaterniond.set(this.w * d3 + this.x * d4, this.y * d4 + this.z * d3, this.z * d4 - this.y * d3, this.w * d4 - this.x * d3);
    }

    public Quaterniond rotateY(double d2) {
        return this.rotateY(d2, this);
    }

    public Quaterniond rotateY(double d2, Quaterniond quaterniond) {
        double d3 = Math.sin(d2 * 0.5);
        double d4 = Math.cosFromSin(d3, d2 * 0.5);
        return quaterniond.set(this.x * d4 - this.z * d3, this.w * d3 + this.y * d4, this.x * d3 + this.z * d4, this.w * d4 - this.y * d3);
    }

    public Quaterniond rotateZ(double d2) {
        return this.rotateZ(d2, this);
    }

    public Quaterniond rotateZ(double d2, Quaterniond quaterniond) {
        double d3 = Math.sin(d2 * 0.5);
        double d4 = Math.cosFromSin(d3, d2 * 0.5);
        return quaterniond.set(this.x * d4 + this.y * d3, this.y * d4 - this.x * d3, this.w * d3 + this.z * d4, this.w * d4 - this.z * d3);
    }

    public Quaterniond rotateLocalX(double d2) {
        return this.rotateLocalX(d2, this);
    }

    public Quaterniond rotateLocalX(double d2, Quaterniond quaterniond) {
        double d3 = d2 * 0.5;
        double d4 = Math.sin(d3);
        double d5 = Math.cosFromSin(d4, d3);
        quaterniond.set(d5 * this.x + d4 * this.w, d5 * this.y - d4 * this.z, d5 * this.z + d4 * this.y, d5 * this.w - d4 * this.x);
        return quaterniond;
    }

    public Quaterniond rotateLocalY(double d2) {
        return this.rotateLocalY(d2, this);
    }

    public Quaterniond rotateLocalY(double d2, Quaterniond quaterniond) {
        double d3 = d2 * 0.5;
        double d4 = Math.sin(d3);
        double d5 = Math.cosFromSin(d4, d3);
        quaterniond.set(d5 * this.x + d4 * this.z, d5 * this.y + d4 * this.w, d5 * this.z - d4 * this.x, d5 * this.w - d4 * this.y);
        return quaterniond;
    }

    public Quaterniond rotateLocalZ(double d2) {
        return this.rotateLocalZ(d2, this);
    }

    public Quaterniond rotateLocalZ(double d2, Quaterniond quaterniond) {
        double d3 = d2 * 0.5;
        double d4 = Math.sin(d3);
        double d5 = Math.cosFromSin(d4, d3);
        quaterniond.set(d5 * this.x - d4 * this.y, d5 * this.y + d4 * this.x, d5 * this.z + d4 * this.w, d5 * this.w - d4 * this.z);
        return quaterniond;
    }

    public Quaterniond rotateXYZ(double d2, double d3, double d4) {
        return this.rotateXYZ(d2, d3, d4, this);
    }

    public Quaterniond rotateXYZ(double d2, double d3, double d4, Quaterniond quaterniond) {
        double d5 = Math.sin(d2 * 0.5);
        double d6 = Math.cosFromSin(d5, d2 * 0.5);
        double d7 = Math.sin(d3 * 0.5);
        double d8 = Math.cosFromSin(d7, d3 * 0.5);
        double d9 = Math.sin(d4 * 0.5);
        double d10 = Math.cosFromSin(d9, d4 * 0.5);
        double d11 = d8 * d10;
        double d12 = d7 * d9;
        double d13 = d7 * d10;
        double d14 = d8 * d9;
        double d15 = d6 * d11 - d5 * d12;
        double d16 = d5 * d11 + d6 * d12;
        double d17 = d6 * d13 - d5 * d14;
        double d18 = d6 * d14 + d5 * d13;
        return quaterniond.set(Math.fma(this.w, d16, Math.fma(this.x, d15, Math.fma(this.y, d18, -this.z * d17))), Math.fma(this.w, d17, Math.fma(-this.x, d18, Math.fma(this.y, d15, this.z * d16))), Math.fma(this.w, d18, Math.fma(this.x, d17, Math.fma(-this.y, d16, this.z * d15))), Math.fma(this.w, d15, Math.fma(-this.x, d16, Math.fma(-this.y, d17, -this.z * d18))));
    }

    public Quaterniond rotateZYX(double d2, double d3, double d4) {
        return this.rotateZYX(d2, d3, d4, this);
    }

    public Quaterniond rotateZYX(double d2, double d3, double d4, Quaterniond quaterniond) {
        double d5 = Math.sin(d4 * 0.5);
        double d6 = Math.cosFromSin(d5, d4 * 0.5);
        double d7 = Math.sin(d3 * 0.5);
        double d8 = Math.cosFromSin(d7, d3 * 0.5);
        double d9 = Math.sin(d2 * 0.5);
        double d10 = Math.cosFromSin(d9, d2 * 0.5);
        double d11 = d8 * d10;
        double d12 = d7 * d9;
        double d13 = d7 * d10;
        double d14 = d8 * d9;
        double d15 = d6 * d11 + d5 * d12;
        double d16 = d5 * d11 - d6 * d12;
        double d17 = d6 * d13 + d5 * d14;
        double d18 = d6 * d14 - d5 * d13;
        return quaterniond.set(Math.fma(this.w, d16, Math.fma(this.x, d15, Math.fma(this.y, d18, -this.z * d17))), Math.fma(this.w, d17, Math.fma(-this.x, d18, Math.fma(this.y, d15, this.z * d16))), Math.fma(this.w, d18, Math.fma(this.x, d17, Math.fma(-this.y, d16, this.z * d15))), Math.fma(this.w, d15, Math.fma(-this.x, d16, Math.fma(-this.y, d17, -this.z * d18))));
    }

    public Quaterniond rotateYXZ(double d2, double d3, double d4) {
        return this.rotateYXZ(d2, d3, d4, this);
    }

    public Quaterniond rotateYXZ(double d2, double d3, double d4, Quaterniond quaterniond) {
        double d5 = Math.sin(d3 * 0.5);
        double d6 = Math.cosFromSin(d5, d3 * 0.5);
        double d7 = Math.sin(d2 * 0.5);
        double d8 = Math.cosFromSin(d7, d2 * 0.5);
        double d9 = Math.sin(d4 * 0.5);
        double d10 = Math.cosFromSin(d9, d4 * 0.5);
        double d11 = d8 * d5;
        double d12 = d7 * d6;
        double d13 = d7 * d5;
        double d14 = d8 * d6;
        double d15 = d11 * d10 + d12 * d9;
        double d16 = d12 * d10 - d11 * d9;
        double d17 = d14 * d9 - d13 * d10;
        double d18 = d14 * d10 + d13 * d9;
        return quaterniond.set(Math.fma(this.w, d15, Math.fma(this.x, d18, Math.fma(this.y, d17, -this.z * d16))), Math.fma(this.w, d16, Math.fma(-this.x, d17, Math.fma(this.y, d18, this.z * d15))), Math.fma(this.w, d17, Math.fma(this.x, d16, Math.fma(-this.y, d15, this.z * d18))), Math.fma(this.w, d18, Math.fma(-this.x, d15, Math.fma(-this.y, d16, -this.z * d17))));
    }

    public Vector3d getEulerAnglesXYZ(Vector3d vector3d) {
        vector3d.x = Math.atan2(this.x * this.w - this.y * this.z, 0.5 - this.x * this.x - this.y * this.y);
        vector3d.y = Math.safeAsin(2.0 * (this.x * this.z + this.y * this.w));
        vector3d.z = Math.atan2(this.z * this.w - this.x * this.y, 0.5 - this.y * this.y - this.z * this.z);
        return vector3d;
    }

    public Vector3d getEulerAnglesZYX(Vector3d vector3d) {
        vector3d.x = Math.atan2(this.y * this.z + this.w * this.x, 0.5 - this.x * this.x + this.y * this.y);
        vector3d.y = Math.safeAsin(-2.0 * (this.x * this.z - this.w * this.y));
        vector3d.z = Math.atan2(this.x * this.y + this.w * this.z, 0.5 - this.y * this.y - this.z * this.z);
        return vector3d;
    }

    public Vector3d getEulerAnglesZXY(Vector3d vector3d) {
        vector3d.x = Math.safeAsin(2.0 * (this.w * this.x + this.y * this.z));
        vector3d.y = Math.atan2(this.w * this.y - this.x * this.z, 0.5 - this.y * this.y - this.x * this.x);
        vector3d.z = Math.atan2(this.w * this.z - this.x * this.y, 0.5 - this.z * this.z - this.x * this.x);
        return vector3d;
    }

    public Vector3d getEulerAnglesYXZ(Vector3d vector3d) {
        vector3d.x = Math.safeAsin(-2.0 * (this.y * this.z - this.w * this.x));
        vector3d.y = Math.atan2(this.x * this.z + this.y * this.w, 0.5 - this.y * this.y - this.x * this.x);
        vector3d.z = Math.atan2(this.y * this.x + this.w * this.z, 0.5 - this.x * this.x - this.z * this.z);
        return vector3d;
    }

    public Quaterniond rotateAxis(double d2, double d3, double d4, double d5, Quaterniond quaterniond) {
        double d6 = d2 / 2.0;
        double d7 = Math.sin(d6);
        double d8 = Math.invsqrt(Math.fma(d3, d3, Math.fma(d4, d4, d5 * d5)));
        double d9 = d3 * d8 * d7;
        double d10 = d4 * d8 * d7;
        double d11 = d5 * d8 * d7;
        double d12 = Math.cosFromSin(d7, d6);
        return quaterniond.set(Math.fma(this.w, d9, Math.fma(this.x, d12, Math.fma(this.y, d11, -this.z * d10))), Math.fma(this.w, d10, Math.fma(-this.x, d11, Math.fma(this.y, d12, this.z * d9))), Math.fma(this.w, d11, Math.fma(this.x, d10, Math.fma(-this.y, d9, this.z * d12))), Math.fma(this.w, d12, Math.fma(-this.x, d9, Math.fma(-this.y, d10, -this.z * d11))));
    }

    public Quaterniond rotateAxis(double d2, Vector3dc vector3dc, Quaterniond quaterniond) {
        return this.rotateAxis(d2, vector3dc.x(), vector3dc.y(), vector3dc.z(), quaterniond);
    }

    public Quaterniond rotateAxis(double d2, Vector3dc vector3dc) {
        return this.rotateAxis(d2, vector3dc.x(), vector3dc.y(), vector3dc.z(), this);
    }

    public Quaterniond rotateAxis(double d2, double d3, double d4, double d5) {
        return this.rotateAxis(d2, d3, d4, d5, this);
    }

    public Vector3d positiveX(Vector3d vector3d) {
        double d2 = 1.0 / this.lengthSquared();
        double d3 = -this.x * d2;
        double d4 = -this.y * d2;
        double d5 = -this.z * d2;
        double d6 = this.w * d2;
        double d7 = d4 + d4;
        double d8 = d5 + d5;
        vector3d.x = -d4 * d7 - d5 * d8 + 1.0;
        vector3d.y = d3 * d7 + d6 * d8;
        vector3d.z = d3 * d8 - d6 * d7;
        return vector3d;
    }

    public Vector3d normalizedPositiveX(Vector3d vector3d) {
        double d2 = this.y + this.y;
        double d3 = this.z + this.z;
        vector3d.x = -this.y * d2 - this.z * d3 + 1.0;
        vector3d.y = this.x * d2 - this.w * d3;
        vector3d.z = this.x * d3 + this.w * d2;
        return vector3d;
    }

    public Vector3d positiveY(Vector3d vector3d) {
        double d2 = 1.0 / this.lengthSquared();
        double d3 = -this.x * d2;
        double d4 = -this.y * d2;
        double d5 = -this.z * d2;
        double d6 = this.w * d2;
        double d7 = d3 + d3;
        double d8 = d4 + d4;
        double d9 = d5 + d5;
        vector3d.x = d3 * d8 - d6 * d9;
        vector3d.y = -d3 * d7 - d5 * d9 + 1.0;
        vector3d.z = d4 * d9 + d6 * d7;
        return vector3d;
    }

    public Vector3d normalizedPositiveY(Vector3d vector3d) {
        double d2 = this.x + this.x;
        double d3 = this.y + this.y;
        double d4 = this.z + this.z;
        vector3d.x = this.x * d3 + this.w * d4;
        vector3d.y = -this.x * d2 - this.z * d4 + 1.0;
        vector3d.z = this.y * d4 - this.w * d2;
        return vector3d;
    }

    public Vector3d positiveZ(Vector3d vector3d) {
        double d2 = 1.0 / this.lengthSquared();
        double d3 = -this.x * d2;
        double d4 = -this.y * d2;
        double d5 = -this.z * d2;
        double d6 = this.w * d2;
        double d7 = d3 + d3;
        double d8 = d4 + d4;
        double d9 = d5 + d5;
        vector3d.x = d3 * d9 + d6 * d8;
        vector3d.y = d4 * d9 - d6 * d7;
        vector3d.z = -d3 * d7 - d4 * d8 + 1.0;
        return vector3d;
    }

    public Vector3d normalizedPositiveZ(Vector3d vector3d) {
        double d2 = this.x + this.x;
        double d3 = this.y + this.y;
        double d4 = this.z + this.z;
        vector3d.x = this.x * d4 - this.w * d3;
        vector3d.y = this.y * d4 + this.w * d2;
        vector3d.z = -this.x * d2 - this.y * d3 + 1.0;
        return vector3d;
    }

    public Quaterniond conjugateBy(Quaterniondc quaterniondc) {
        return this.conjugateBy(quaterniondc, this);
    }

    public Quaterniond conjugateBy(Quaterniondc quaterniondc, Quaterniond quaterniond) {
        double d2 = 1.0 / quaterniondc.lengthSquared();
        double d3 = -quaterniondc.x() * d2;
        double d4 = -quaterniondc.y() * d2;
        double d5 = -quaterniondc.z() * d2;
        double d6 = quaterniondc.w() * d2;
        double d7 = Math.fma(quaterniondc.w(), this.x, Math.fma(quaterniondc.x(), this.w, Math.fma(quaterniondc.y(), this.z, -quaterniondc.z() * this.y)));
        double d8 = Math.fma(quaterniondc.w(), this.y, Math.fma(-quaterniondc.x(), this.z, Math.fma(quaterniondc.y(), this.w, quaterniondc.z() * this.x)));
        double d9 = Math.fma(quaterniondc.w(), this.z, Math.fma(quaterniondc.x(), this.y, Math.fma(-quaterniondc.y(), this.x, quaterniondc.z() * this.w)));
        double d10 = Math.fma(quaterniondc.w(), this.w, Math.fma(-quaterniondc.x(), this.x, Math.fma(-quaterniondc.y(), this.y, -quaterniondc.z() * this.z)));
        return quaterniond.set(Math.fma(d10, d3, Math.fma(d7, d6, Math.fma(d8, d5, -d9 * d4))), Math.fma(d10, d4, Math.fma(-d7, d5, Math.fma(d8, d6, d9 * d3))), Math.fma(d10, d5, Math.fma(d7, d4, Math.fma(-d8, d3, d9 * d6))), Math.fma(d10, d6, Math.fma(-d7, d3, Math.fma(-d8, d4, -d9 * d5))));
    }

    public boolean isFinite() {
        return Math.isFinite(this.x) && Math.isFinite(this.y) && Math.isFinite(this.z) && Math.isFinite(this.w);
    }

    public boolean equals(Quaterniondc quaterniondc, double d2) {
        if (this == quaterniondc) {
            return true;
        }
        if (quaterniondc == null) {
            return false;
        }
        if (!(quaterniondc instanceof Quaterniondc)) {
            return false;
        }
        if (!Runtime.equals(this.x, quaterniondc.x(), d2)) {
            return false;
        }
        if (!Runtime.equals(this.y, quaterniondc.y(), d2)) {
            return false;
        }
        if (!Runtime.equals(this.z, quaterniondc.z(), d2)) {
            return false;
        }
        return Runtime.equals(this.w, quaterniondc.w(), d2);
    }

    public boolean equals(double d2, double d3, double d4, double d5) {
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(d2)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(d3)) {
            return false;
        }
        if (Double.doubleToLongBits(this.z) != Double.doubleToLongBits(d4)) {
            return false;
        }
        return Double.doubleToLongBits(this.w) == Double.doubleToLongBits(d5);
    }

    public Object clone() {
        return super.clone();
    }
}

