/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.joml.Matrix4x3f;

public class Matrix4x3fStack
extends Matrix4x3f {
    private static final long serialVersionUID = 1L;
    private Matrix4x3f[] mats;
    private int curr;

    public Matrix4x3fStack(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("stackSize must be >= 1");
        }
        this.mats = new Matrix4x3f[n2 - 1];
        for (int i2 = 0; i2 < this.mats.length; ++i2) {
            this.mats[i2] = new Matrix4x3f();
        }
    }

    public Matrix4x3fStack() {
    }

    public Matrix4x3fStack clear() {
        this.curr = 0;
        this.identity();
        return this;
    }

    public Matrix4x3fStack pushMatrix() {
        if (this.curr == this.mats.length) {
            throw new IllegalStateException("max stack size of " + (this.curr + 1) + " reached");
        }
        this.mats[this.curr++].set(this);
        return this;
    }

    public Matrix4x3fStack popMatrix() {
        if (this.curr == 0) {
            throw new IllegalStateException("already at the bottom of the stack");
        }
        this.set(this.mats[--this.curr]);
        return this;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = super.hashCode();
        n3 = 31 * n3 + this.curr;
        for (int i2 = 0; i2 < this.curr; ++i2) {
            n3 = 31 * n3 + this.mats[i2].hashCode();
        }
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (object instanceof Matrix4x3fStack) {
            Matrix4x3fStack matrix4x3fStack = (Matrix4x3fStack)object;
            if (this.curr != matrix4x3fStack.curr) {
                return false;
            }
            for (int i2 = 0; i2 < this.curr; ++i2) {
                if (this.mats[i2].equals(matrix4x3fStack.mats[i2])) continue;
                return false;
            }
        }
        return true;
    }

    public void writeExternal(ObjectOutput objectOutput) {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(this.curr);
        for (int i2 = 0; i2 < this.curr; ++i2) {
            objectOutput.writeObject(this.mats[i2]);
        }
    }

    public void readExternal(ObjectInput objectInput) {
        super.readExternal(objectInput);
        this.curr = objectInput.readInt();
        this.mats = new Matrix4x3fStack[this.curr];
        for (int i2 = 0; i2 < this.curr; ++i2) {
            Matrix4x3f matrix4x3f = new Matrix4x3f();
            matrix4x3f.readExternal(objectInput);
            this.mats[i2] = matrix4x3f;
        }
    }

    public Object clone() {
        Matrix4x3fStack matrix4x3fStack = (Matrix4x3fStack)super.clone();
        Matrix4x3f[] matrix4x3fArray = new Matrix4x3f[this.mats.length];
        for (int i2 = 0; i2 < this.mats.length; ++i2) {
            matrix4x3fArray[i2] = (Matrix4x3f)this.mats[i2].clone();
        }
        matrix4x3fStack.mats = matrix4x3fArray;
        return matrix4x3fStack;
    }
}

