/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.text.NumberFormat;
import org.joml.AxisAngle4d;
import org.joml.AxisAngle4f;
import org.joml.Math;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4d;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Matrix4x3d;
import org.joml.Matrix4x3fc;
import org.joml.MemUtil;
import org.joml.MemUtil$MemUtilUnsafe;
import org.joml.Options;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Runtime;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class Matrix4x3f
implements Externalizable,
Cloneable,
Matrix4x3fc {
    private static final long serialVersionUID = 1L;
    float m00;
    float m01;
    float m02;
    float m10;
    float m11;
    float m12;
    float m20;
    float m21;
    float m22;
    float m30;
    float m31;
    float m32;
    int properties;

    public Matrix4x3f() {
        this.m00 = 1.0f;
        this.m11 = 1.0f;
        this.m22 = 1.0f;
        this.properties = 28;
    }

    public Matrix4x3f(Matrix3fc matrix3fc) {
        this.set(matrix3fc);
    }

    public Matrix4x3f(Matrix4x3fc matrix4x3fc) {
        this.set(matrix4x3fc);
    }

    public Matrix4x3f(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13) {
        this.m00 = f2;
        this.m01 = f3;
        this.m02 = f4;
        this.m10 = f5;
        this.m11 = f6;
        this.m12 = f7;
        this.m20 = f8;
        this.m21 = f9;
        this.m22 = f10;
        this.m30 = f11;
        this.m31 = f12;
        this.m32 = f13;
        this.determineProperties();
    }

    public Matrix4x3f(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, floatBuffer.position(), floatBuffer);
        this.determineProperties();
    }

    public Matrix4x3f(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3, Vector3fc vector3fc4) {
        this.set(vector3fc, vector3fc2, vector3fc3, vector3fc4).determineProperties();
    }

    public Matrix4x3f assume(int n2) {
        this.properties = n2;
        return this;
    }

    public Matrix4x3f determineProperties() {
        int n2 = 0;
        if (this.m00 == 1.0f && this.m01 == 0.0f && this.m02 == 0.0f && this.m10 == 0.0f && this.m11 == 1.0f && this.m12 == 0.0f && this.m20 == 0.0f && this.m21 == 0.0f && this.m22 == 1.0f) {
            n2 |= 0x18;
            if (this.m30 == 0.0f && this.m31 == 0.0f && this.m32 == 0.0f) {
                n2 |= 4;
            }
        }
        this.properties = n2;
        return this;
    }

    public int properties() {
        return this.properties;
    }

    public float m00() {
        return this.m00;
    }

    public float m01() {
        return this.m01;
    }

    public float m02() {
        return this.m02;
    }

    public float m10() {
        return this.m10;
    }

    public float m11() {
        return this.m11;
    }

    public float m12() {
        return this.m12;
    }

    public float m20() {
        return this.m20;
    }

    public float m21() {
        return this.m21;
    }

    public float m22() {
        return this.m22;
    }

    public float m30() {
        return this.m30;
    }

    public float m31() {
        return this.m31;
    }

    public float m32() {
        return this.m32;
    }

    public Matrix4x3f m00(float f2) {
        this.m00 = f2;
        this.properties &= 0xFFFFFFEF;
        if (f2 != 1.0f) {
            this.properties &= 0xFFFFFFF3;
        }
        return this;
    }

    public Matrix4x3f m01(float f2) {
        this.m01 = f2;
        this.properties &= 0xFFFFFFEF;
        if (f2 != 0.0f) {
            this.properties &= 0xFFFFFFF3;
        }
        return this;
    }

    public Matrix4x3f m02(float f2) {
        this.m02 = f2;
        this.properties &= 0xFFFFFFEF;
        if (f2 != 0.0f) {
            this.properties &= 0xFFFFFFF3;
        }
        return this;
    }

    public Matrix4x3f m10(float f2) {
        this.m10 = f2;
        this.properties &= 0xFFFFFFEF;
        if (f2 != 0.0f) {
            this.properties &= 0xFFFFFFF3;
        }
        return this;
    }

    public Matrix4x3f m11(float f2) {
        this.m11 = f2;
        this.properties &= 0xFFFFFFEF;
        if (f2 != 1.0f) {
            this.properties &= 0xFFFFFFF3;
        }
        return this;
    }

    public Matrix4x3f m12(float f2) {
        this.m12 = f2;
        this.properties &= 0xFFFFFFEF;
        if (f2 != 0.0f) {
            this.properties &= 0xFFFFFFF3;
        }
        return this;
    }

    public Matrix4x3f m20(float f2) {
        this.m20 = f2;
        this.properties &= 0xFFFFFFEF;
        if (f2 != 0.0f) {
            this.properties &= 0xFFFFFFF3;
        }
        return this;
    }

    public Matrix4x3f m21(float f2) {
        this.m21 = f2;
        this.properties &= 0xFFFFFFEF;
        if (f2 != 0.0f) {
            this.properties &= 0xFFFFFFF3;
        }
        return this;
    }

    public Matrix4x3f m22(float f2) {
        this.m22 = f2;
        this.properties &= 0xFFFFFFEF;
        if (f2 != 1.0f) {
            this.properties &= 0xFFFFFFF3;
        }
        return this;
    }

    public Matrix4x3f m30(float f2) {
        this.m30 = f2;
        if (f2 != 0.0f) {
            this.properties &= 0xFFFFFFFB;
        }
        return this;
    }

    public Matrix4x3f m31(float f2) {
        this.m31 = f2;
        if (f2 != 0.0f) {
            this.properties &= 0xFFFFFFFB;
        }
        return this;
    }

    public Matrix4x3f m32(float f2) {
        this.m32 = f2;
        if (f2 != 0.0f) {
            this.properties &= 0xFFFFFFFB;
        }
        return this;
    }

    Matrix4x3f _properties(int n2) {
        this.properties = n2;
        return this;
    }

    Matrix4x3f _m00(float f2) {
        this.m00 = f2;
        return this;
    }

    Matrix4x3f _m01(float f2) {
        this.m01 = f2;
        return this;
    }

    Matrix4x3f _m02(float f2) {
        this.m02 = f2;
        return this;
    }

    Matrix4x3f _m10(float f2) {
        this.m10 = f2;
        return this;
    }

    Matrix4x3f _m11(float f2) {
        this.m11 = f2;
        return this;
    }

    Matrix4x3f _m12(float f2) {
        this.m12 = f2;
        return this;
    }

    Matrix4x3f _m20(float f2) {
        this.m20 = f2;
        return this;
    }

    Matrix4x3f _m21(float f2) {
        this.m21 = f2;
        return this;
    }

    Matrix4x3f _m22(float f2) {
        this.m22 = f2;
        return this;
    }

    Matrix4x3f _m30(float f2) {
        this.m30 = f2;
        return this;
    }

    Matrix4x3f _m31(float f2) {
        this.m31 = f2;
        return this;
    }

    Matrix4x3f _m32(float f2) {
        this.m32 = f2;
        return this;
    }

    public Matrix4x3f identity() {
        if ((this.properties & 4) != 0) {
            return this;
        }
        MemUtil.INSTANCE.identity(this);
        this.properties = 28;
        return this;
    }

    public Matrix4x3f set(Matrix4x3fc matrix4x3fc) {
        this.m00 = matrix4x3fc.m00();
        this.m01 = matrix4x3fc.m01();
        this.m02 = matrix4x3fc.m02();
        this.m10 = matrix4x3fc.m10();
        this.m11 = matrix4x3fc.m11();
        this.m12 = matrix4x3fc.m12();
        this.m20 = matrix4x3fc.m20();
        this.m21 = matrix4x3fc.m21();
        this.m22 = matrix4x3fc.m22();
        this.m30 = matrix4x3fc.m30();
        this.m31 = matrix4x3fc.m31();
        this.m32 = matrix4x3fc.m32();
        this.properties = matrix4x3fc.properties();
        return this;
    }

    public Matrix4x3f set(Matrix4fc matrix4fc) {
        this.m00 = matrix4fc.m00();
        this.m01 = matrix4fc.m01();
        this.m02 = matrix4fc.m02();
        this.m10 = matrix4fc.m10();
        this.m11 = matrix4fc.m11();
        this.m12 = matrix4fc.m12();
        this.m20 = matrix4fc.m20();
        this.m21 = matrix4fc.m21();
        this.m22 = matrix4fc.m22();
        this.m30 = matrix4fc.m30();
        this.m31 = matrix4fc.m31();
        this.m32 = matrix4fc.m32();
        this.properties = matrix4fc.properties() & 0x1C;
        return this;
    }

    public Matrix4f get(Matrix4f matrix4f) {
        return matrix4f.set4x3(this);
    }

    public Matrix4d get(Matrix4d matrix4d) {
        return matrix4d.set4x3(this);
    }

    public Matrix4x3f set(Matrix3fc matrix3fc) {
        this.m00 = matrix3fc.m00();
        this.m01 = matrix3fc.m01();
        this.m02 = matrix3fc.m02();
        this.m10 = matrix3fc.m10();
        this.m11 = matrix3fc.m11();
        this.m12 = matrix3fc.m12();
        this.m20 = matrix3fc.m20();
        this.m21 = matrix3fc.m21();
        this.m22 = matrix3fc.m22();
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        return this.determineProperties();
    }

    public Matrix4x3f set(AxisAngle4f axisAngle4f) {
        float f2 = axisAngle4f.x;
        float f3 = axisAngle4f.y;
        float f4 = axisAngle4f.z;
        float f5 = axisAngle4f.angle;
        float f6 = Math.sqrt(f2 * f2 + f3 * f3 + f4 * f4);
        f6 = 1.0f / f6;
        f2 *= f6;
        f3 *= f6;
        f4 *= f6;
        float f7 = Math.sin(f5);
        float f8 = Math.cosFromSin(f7, f5);
        float f9 = 1.0f - f8;
        this.m00 = f8 + f2 * f2 * f9;
        this.m11 = f8 + f3 * f3 * f9;
        this.m22 = f8 + f4 * f4 * f9;
        float f10 = f2 * f3 * f9;
        float f11 = f4 * f7;
        this.m10 = f10 - f11;
        this.m01 = f10 + f11;
        f10 = f2 * f4 * f9;
        f11 = f3 * f7;
        this.m20 = f10 + f11;
        this.m02 = f10 - f11;
        f10 = f3 * f4 * f9;
        f11 = f2 * f7;
        this.m21 = f10 - f11;
        this.m12 = f10 + f11;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.properties = 16;
        return this;
    }

    public Matrix4x3f set(AxisAngle4d axisAngle4d) {
        double d2 = axisAngle4d.x;
        double d3 = axisAngle4d.y;
        double d4 = axisAngle4d.z;
        double d5 = axisAngle4d.angle;
        double d6 = Math.sqrt(d2 * d2 + d3 * d3 + d4 * d4);
        d6 = 1.0 / d6;
        d2 *= d6;
        d3 *= d6;
        d4 *= d6;
        double d7 = Math.sin(d5);
        double d8 = Math.cosFromSin(d7, d5);
        double d9 = 1.0 - d8;
        this.m00 = (float)(d8 + d2 * d2 * d9);
        this.m11 = (float)(d8 + d3 * d3 * d9);
        this.m22 = (float)(d8 + d4 * d4 * d9);
        double d10 = d2 * d3 * d9;
        double d11 = d4 * d7;
        this.m10 = (float)(d10 - d11);
        this.m01 = (float)(d10 + d11);
        d10 = d2 * d4 * d9;
        d11 = d3 * d7;
        this.m20 = (float)(d10 + d11);
        this.m02 = (float)(d10 - d11);
        d10 = d3 * d4 * d9;
        d11 = d2 * d7;
        this.m21 = (float)(d10 - d11);
        this.m12 = (float)(d10 + d11);
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.properties = 16;
        return this;
    }

    public Matrix4x3f set(Quaternionfc quaternionfc) {
        return this.rotation(quaternionfc);
    }

    public Matrix4x3f set(Quaterniondc quaterniondc) {
        double d2 = quaterniondc.w() * quaterniondc.w();
        double d3 = quaterniondc.x() * quaterniondc.x();
        double d4 = quaterniondc.y() * quaterniondc.y();
        double d5 = quaterniondc.z() * quaterniondc.z();
        double d6 = quaterniondc.z() * quaterniondc.w();
        double d7 = quaterniondc.x() * quaterniondc.y();
        double d8 = quaterniondc.x() * quaterniondc.z();
        double d9 = quaterniondc.y() * quaterniondc.w();
        double d10 = quaterniondc.y() * quaterniondc.z();
        double d11 = quaterniondc.x() * quaterniondc.w();
        this.m00 = (float)(d2 + d3 - d5 - d4);
        this.m01 = (float)(d7 + d6 + d6 + d7);
        this.m02 = (float)(d8 - d9 + d8 - d9);
        this.m10 = (float)(-d6 + d7 - d6 + d7);
        this.m11 = (float)(d4 - d5 + d2 - d3);
        this.m12 = (float)(d10 + d10 + d11 + d11);
        this.m20 = (float)(d9 + d8 + d8 + d9);
        this.m21 = (float)(d10 + d10 - d11 - d11);
        this.m22 = (float)(d5 - d4 - d3 + d2);
        this.properties = 16;
        return this;
    }

    public Matrix4x3f set(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3, Vector3fc vector3fc4) {
        this.m00 = vector3fc.x();
        this.m01 = vector3fc.y();
        this.m02 = vector3fc.z();
        this.m10 = vector3fc2.x();
        this.m11 = vector3fc2.y();
        this.m12 = vector3fc2.z();
        this.m20 = vector3fc3.x();
        this.m21 = vector3fc3.y();
        this.m22 = vector3fc3.z();
        this.m30 = vector3fc4.x();
        this.m31 = vector3fc4.y();
        this.m32 = vector3fc4.z();
        return this.determineProperties();
    }

    public Matrix4x3f set3x3(Matrix4x3fc matrix4x3fc) {
        this.m00 = matrix4x3fc.m00();
        this.m01 = matrix4x3fc.m01();
        this.m02 = matrix4x3fc.m02();
        this.m10 = matrix4x3fc.m10();
        this.m11 = matrix4x3fc.m11();
        this.m12 = matrix4x3fc.m12();
        this.m20 = matrix4x3fc.m20();
        this.m21 = matrix4x3fc.m21();
        this.m22 = matrix4x3fc.m22();
        this.properties &= matrix4x3fc.properties();
        return this;
    }

    public Matrix4x3f mul(Matrix4x3fc matrix4x3fc) {
        return this.mul(matrix4x3fc, this);
    }

    public Matrix4x3f mul(Matrix4x3fc matrix4x3fc, Matrix4x3f matrix4x3f) {
        if ((this.properties & 4) != 0) {
            return matrix4x3f.set(matrix4x3fc);
        }
        if ((matrix4x3fc.properties() & 4) != 0) {
            return matrix4x3f.set(this);
        }
        if ((this.properties & 8) != 0) {
            return this.mulTranslation(matrix4x3fc, matrix4x3f);
        }
        return this.mulGeneric(matrix4x3fc, matrix4x3f);
    }

    private Matrix4x3f mulGeneric(Matrix4x3fc matrix4x3fc, Matrix4x3f matrix4x3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        float f5 = this.m10;
        float f6 = this.m11;
        float f7 = this.m12;
        float f8 = this.m20;
        float f9 = this.m21;
        float f10 = this.m22;
        float f11 = matrix4x3fc.m00();
        float f12 = matrix4x3fc.m01();
        float f13 = matrix4x3fc.m02();
        float f14 = matrix4x3fc.m10();
        float f15 = matrix4x3fc.m11();
        float f16 = matrix4x3fc.m12();
        float f17 = matrix4x3fc.m20();
        float f18 = matrix4x3fc.m21();
        float f19 = matrix4x3fc.m22();
        float f20 = matrix4x3fc.m30();
        float f21 = matrix4x3fc.m31();
        float f22 = matrix4x3fc.m32();
        return matrix4x3f._m00(Math.fma(f2, f11, Math.fma(f5, f12, f8 * f13)))._m01(Math.fma(f3, f11, Math.fma(f6, f12, f9 * f13)))._m02(Math.fma(f4, f11, Math.fma(f7, f12, f10 * f13)))._m10(Math.fma(f2, f14, Math.fma(f5, f15, f8 * f16)))._m11(Math.fma(f3, f14, Math.fma(f6, f15, f9 * f16)))._m12(Math.fma(f4, f14, Math.fma(f7, f15, f10 * f16)))._m20(Math.fma(f2, f17, Math.fma(f5, f18, f8 * f19)))._m21(Math.fma(f3, f17, Math.fma(f6, f18, f9 * f19)))._m22(Math.fma(f4, f17, Math.fma(f7, f18, f10 * f19)))._m30(Math.fma(f2, f20, Math.fma(f5, f21, Math.fma(f8, f22, this.m30))))._m31(Math.fma(f3, f20, Math.fma(f6, f21, Math.fma(f9, f22, this.m31))))._m32(Math.fma(f4, f20, Math.fma(f7, f21, Math.fma(f10, f22, this.m32))))._properties(this.properties & matrix4x3fc.properties() & 0x10);
    }

    public Matrix4x3f mulTranslation(Matrix4x3fc matrix4x3fc, Matrix4x3f matrix4x3f) {
        return matrix4x3f._m00(matrix4x3fc.m00())._m01(matrix4x3fc.m01())._m02(matrix4x3fc.m02())._m10(matrix4x3fc.m10())._m11(matrix4x3fc.m11())._m12(matrix4x3fc.m12())._m20(matrix4x3fc.m20())._m21(matrix4x3fc.m21())._m22(matrix4x3fc.m22())._m30(matrix4x3fc.m30() + this.m30)._m31(matrix4x3fc.m31() + this.m31)._m32(matrix4x3fc.m32() + this.m32)._properties(matrix4x3fc.properties() & 0x10);
    }

    public Matrix4x3f mulOrtho(Matrix4x3fc matrix4x3fc) {
        return this.mulOrtho(matrix4x3fc, this);
    }

    public Matrix4x3f mulOrtho(Matrix4x3fc matrix4x3fc, Matrix4x3f matrix4x3f) {
        float f2 = this.m00 * matrix4x3fc.m00();
        float f3 = this.m11 * matrix4x3fc.m01();
        float f4 = this.m22 * matrix4x3fc.m02();
        float f5 = this.m00 * matrix4x3fc.m10();
        float f6 = this.m11 * matrix4x3fc.m11();
        float f7 = this.m22 * matrix4x3fc.m12();
        float f8 = this.m00 * matrix4x3fc.m20();
        float f9 = this.m11 * matrix4x3fc.m21();
        float f10 = this.m22 * matrix4x3fc.m22();
        float f11 = this.m00 * matrix4x3fc.m30() + this.m30;
        float f12 = this.m11 * matrix4x3fc.m31() + this.m31;
        float f13 = this.m22 * matrix4x3fc.m32() + this.m32;
        matrix4x3f.m00 = f2;
        matrix4x3f.m01 = f3;
        matrix4x3f.m02 = f4;
        matrix4x3f.m10 = f5;
        matrix4x3f.m11 = f6;
        matrix4x3f.m12 = f7;
        matrix4x3f.m20 = f8;
        matrix4x3f.m21 = f9;
        matrix4x3f.m22 = f10;
        matrix4x3f.m30 = f11;
        matrix4x3f.m31 = f12;
        matrix4x3f.m32 = f13;
        matrix4x3f.properties = this.properties & matrix4x3fc.properties() & 0x10;
        return matrix4x3f;
    }

    public Matrix4x3f mul3x3(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        return this.mul3x3(f2, f3, f4, f5, f6, f7, f8, f9, f10, this);
    }

    public Matrix4x3f mul3x3(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, Matrix4x3f matrix4x3f) {
        float f11 = this.m00;
        float f12 = this.m01;
        float f13 = this.m02;
        float f14 = this.m10;
        float f15 = this.m11;
        float f16 = this.m12;
        float f17 = this.m20;
        float f18 = this.m21;
        float f19 = this.m22;
        return matrix4x3f._m00(Math.fma(f11, f2, Math.fma(f14, f3, f17 * f4)))._m01(Math.fma(f12, f2, Math.fma(f15, f3, f18 * f4)))._m02(Math.fma(f13, f2, Math.fma(f16, f3, f19 * f4)))._m10(Math.fma(f11, f5, Math.fma(f14, f6, f17 * f7)))._m11(Math.fma(f12, f5, Math.fma(f15, f6, f18 * f7)))._m12(Math.fma(f13, f5, Math.fma(f16, f6, f19 * f7)))._m20(Math.fma(f11, f8, Math.fma(f14, f9, f17 * f10)))._m21(Math.fma(f12, f8, Math.fma(f15, f9, f18 * f10)))._m22(Math.fma(f13, f8, Math.fma(f16, f9, f19 * f10)))._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(0);
    }

    public Matrix4x3f fma(Matrix4x3fc matrix4x3fc, float f2) {
        return this.fma(matrix4x3fc, f2, this);
    }

    public Matrix4x3f fma(Matrix4x3fc matrix4x3fc, float f2, Matrix4x3f matrix4x3f) {
        matrix4x3f._m00(Math.fma(matrix4x3fc.m00(), f2, this.m00))._m01(Math.fma(matrix4x3fc.m01(), f2, this.m01))._m02(Math.fma(matrix4x3fc.m02(), f2, this.m02))._m10(Math.fma(matrix4x3fc.m10(), f2, this.m10))._m11(Math.fma(matrix4x3fc.m11(), f2, this.m11))._m12(Math.fma(matrix4x3fc.m12(), f2, this.m12))._m20(Math.fma(matrix4x3fc.m20(), f2, this.m20))._m21(Math.fma(matrix4x3fc.m21(), f2, this.m21))._m22(Math.fma(matrix4x3fc.m22(), f2, this.m22))._m30(Math.fma(matrix4x3fc.m30(), f2, this.m30))._m31(Math.fma(matrix4x3fc.m31(), f2, this.m31))._m32(Math.fma(matrix4x3fc.m32(), f2, this.m32))._properties(0);
        return matrix4x3f;
    }

    public Matrix4x3f add(Matrix4x3fc matrix4x3fc) {
        return this.add(matrix4x3fc, this);
    }

    public Matrix4x3f add(Matrix4x3fc matrix4x3fc, Matrix4x3f matrix4x3f) {
        matrix4x3f.m00 = this.m00 + matrix4x3fc.m00();
        matrix4x3f.m01 = this.m01 + matrix4x3fc.m01();
        matrix4x3f.m02 = this.m02 + matrix4x3fc.m02();
        matrix4x3f.m10 = this.m10 + matrix4x3fc.m10();
        matrix4x3f.m11 = this.m11 + matrix4x3fc.m11();
        matrix4x3f.m12 = this.m12 + matrix4x3fc.m12();
        matrix4x3f.m20 = this.m20 + matrix4x3fc.m20();
        matrix4x3f.m21 = this.m21 + matrix4x3fc.m21();
        matrix4x3f.m22 = this.m22 + matrix4x3fc.m22();
        matrix4x3f.m30 = this.m30 + matrix4x3fc.m30();
        matrix4x3f.m31 = this.m31 + matrix4x3fc.m31();
        matrix4x3f.m32 = this.m32 + matrix4x3fc.m32();
        matrix4x3f.properties = 0;
        return matrix4x3f;
    }

    public Matrix4x3f sub(Matrix4x3fc matrix4x3fc) {
        return this.sub(matrix4x3fc, this);
    }

    public Matrix4x3f sub(Matrix4x3fc matrix4x3fc, Matrix4x3f matrix4x3f) {
        matrix4x3f.m00 = this.m00 - matrix4x3fc.m00();
        matrix4x3f.m01 = this.m01 - matrix4x3fc.m01();
        matrix4x3f.m02 = this.m02 - matrix4x3fc.m02();
        matrix4x3f.m10 = this.m10 - matrix4x3fc.m10();
        matrix4x3f.m11 = this.m11 - matrix4x3fc.m11();
        matrix4x3f.m12 = this.m12 - matrix4x3fc.m12();
        matrix4x3f.m20 = this.m20 - matrix4x3fc.m20();
        matrix4x3f.m21 = this.m21 - matrix4x3fc.m21();
        matrix4x3f.m22 = this.m22 - matrix4x3fc.m22();
        matrix4x3f.m30 = this.m30 - matrix4x3fc.m30();
        matrix4x3f.m31 = this.m31 - matrix4x3fc.m31();
        matrix4x3f.m32 = this.m32 - matrix4x3fc.m32();
        matrix4x3f.properties = 0;
        return matrix4x3f;
    }

    public Matrix4x3f mulComponentWise(Matrix4x3fc matrix4x3fc) {
        return this.mulComponentWise(matrix4x3fc, this);
    }

    public Matrix4x3f mulComponentWise(Matrix4x3fc matrix4x3fc, Matrix4x3f matrix4x3f) {
        matrix4x3f.m00 = this.m00 * matrix4x3fc.m00();
        matrix4x3f.m01 = this.m01 * matrix4x3fc.m01();
        matrix4x3f.m02 = this.m02 * matrix4x3fc.m02();
        matrix4x3f.m10 = this.m10 * matrix4x3fc.m10();
        matrix4x3f.m11 = this.m11 * matrix4x3fc.m11();
        matrix4x3f.m12 = this.m12 * matrix4x3fc.m12();
        matrix4x3f.m20 = this.m20 * matrix4x3fc.m20();
        matrix4x3f.m21 = this.m21 * matrix4x3fc.m21();
        matrix4x3f.m22 = this.m22 * matrix4x3fc.m22();
        matrix4x3f.m30 = this.m30 * matrix4x3fc.m30();
        matrix4x3f.m31 = this.m31 * matrix4x3fc.m31();
        matrix4x3f.m32 = this.m32 * matrix4x3fc.m32();
        matrix4x3f.properties = 0;
        return matrix4x3f;
    }

    public Matrix4x3f set(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13) {
        this.m00 = f2;
        this.m01 = f3;
        this.m02 = f4;
        this.m10 = f5;
        this.m11 = f6;
        this.m12 = f7;
        this.m20 = f8;
        this.m21 = f9;
        this.m22 = f10;
        this.m30 = f11;
        this.m31 = f12;
        this.m32 = f13;
        return this.determineProperties();
    }

    public Matrix4x3f set(float[] fArray, int n2) {
        MemUtil.INSTANCE.copy(fArray, n2, this);
        return this.determineProperties();
    }

    public Matrix4x3f set(float[] fArray) {
        return this.set(fArray, 0);
    }

    public Matrix4x3f set(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, floatBuffer.position(), floatBuffer);
        return this.determineProperties();
    }

    public Matrix4x3f set(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
        return this.determineProperties();
    }

    public Matrix4x3f set(int n2, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, n2, floatBuffer);
        return this.determineProperties();
    }

    public Matrix4x3f set(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n2, byteBuffer);
        return this.determineProperties();
    }

    public Matrix4x3f setFromAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil$MemUtilUnsafe.get(this, l2);
        return this.determineProperties();
    }

    public float determinant() {
        return (this.m00 * this.m11 - this.m01 * this.m10) * this.m22 + (this.m02 * this.m10 - this.m00 * this.m12) * this.m21 + (this.m01 * this.m12 - this.m02 * this.m11) * this.m20;
    }

    public Matrix4x3f invert(Matrix4x3f matrix4x3f) {
        if ((this.properties & 4) != 0) {
            return matrix4x3f.identity();
        }
        if ((this.properties & 0x10) != 0) {
            return this.invertOrthonormal(matrix4x3f);
        }
        return this.invertGeneric(matrix4x3f);
    }

    private Matrix4x3f invertGeneric(Matrix4x3f matrix4x3f) {
        float f2 = this.m00 * this.m11;
        float f3 = this.m01 * this.m10;
        float f4 = this.m02 * this.m10;
        float f5 = this.m00 * this.m12;
        float f6 = this.m01 * this.m12;
        float f7 = this.m02 * this.m11;
        float f8 = 1.0f / ((f2 - f3) * this.m22 + (f4 - f5) * this.m21 + (f6 - f7) * this.m20);
        float f9 = this.m10 * this.m22;
        float f10 = this.m10 * this.m21;
        float f11 = this.m11 * this.m22;
        float f12 = this.m11 * this.m20;
        float f13 = this.m12 * this.m21;
        float f14 = this.m12 * this.m20;
        float f15 = this.m20 * this.m02;
        float f16 = this.m20 * this.m01;
        float f17 = this.m21 * this.m02;
        float f18 = this.m21 * this.m00;
        float f19 = this.m22 * this.m01;
        float f20 = this.m22 * this.m00;
        float f21 = (f11 - f13) * f8;
        float f22 = (f17 - f19) * f8;
        float f23 = (f6 - f7) * f8;
        float f24 = (f14 - f9) * f8;
        float f25 = (f20 - f15) * f8;
        float f26 = (f4 - f5) * f8;
        float f27 = (f10 - f12) * f8;
        float f28 = (f16 - f18) * f8;
        float f29 = (f2 - f3) * f8;
        float f30 = (f9 * this.m31 - f10 * this.m32 + f12 * this.m32 - f11 * this.m30 + f13 * this.m30 - f14 * this.m31) * f8;
        float f31 = (f15 * this.m31 - f16 * this.m32 + f18 * this.m32 - f17 * this.m30 + f19 * this.m30 - f20 * this.m31) * f8;
        float f32 = (f7 * this.m30 - f6 * this.m30 + f5 * this.m31 - f4 * this.m31 + f3 * this.m32 - f2 * this.m32) * f8;
        matrix4x3f.m00 = f21;
        matrix4x3f.m01 = f22;
        matrix4x3f.m02 = f23;
        matrix4x3f.m10 = f24;
        matrix4x3f.m11 = f25;
        matrix4x3f.m12 = f26;
        matrix4x3f.m20 = f27;
        matrix4x3f.m21 = f28;
        matrix4x3f.m22 = f29;
        matrix4x3f.m30 = f30;
        matrix4x3f.m31 = f31;
        matrix4x3f.m32 = f32;
        matrix4x3f.properties = 0;
        return matrix4x3f;
    }

    private Matrix4x3f invertOrthonormal(Matrix4x3f matrix4x3f) {
        float f2 = -(this.m00 * this.m30 + this.m01 * this.m31 + this.m02 * this.m32);
        float f3 = -(this.m10 * this.m30 + this.m11 * this.m31 + this.m12 * this.m32);
        float f4 = -(this.m20 * this.m30 + this.m21 * this.m31 + this.m22 * this.m32);
        float f5 = this.m01;
        float f6 = this.m02;
        float f7 = this.m12;
        matrix4x3f.m00 = this.m00;
        matrix4x3f.m01 = this.m10;
        matrix4x3f.m02 = this.m20;
        matrix4x3f.m10 = f5;
        matrix4x3f.m11 = this.m11;
        matrix4x3f.m12 = this.m21;
        matrix4x3f.m20 = f6;
        matrix4x3f.m21 = f7;
        matrix4x3f.m22 = this.m22;
        matrix4x3f.m30 = f2;
        matrix4x3f.m31 = f3;
        matrix4x3f.m32 = f4;
        matrix4x3f.properties = 16;
        return matrix4x3f;
    }

    public Matrix4f invert(Matrix4f matrix4f) {
        if ((this.properties & 4) != 0) {
            return matrix4f.identity();
        }
        if ((this.properties & 0x10) != 0) {
            return this.invertOrthonormal(matrix4f);
        }
        return this.invertGeneric(matrix4f);
    }

    private Matrix4f invertGeneric(Matrix4f matrix4f) {
        float f2 = this.m00 * this.m11;
        float f3 = this.m01 * this.m10;
        float f4 = this.m02 * this.m10;
        float f5 = this.m00 * this.m12;
        float f6 = this.m01 * this.m12;
        float f7 = this.m02 * this.m11;
        float f8 = 1.0f / ((f2 - f3) * this.m22 + (f4 - f5) * this.m21 + (f6 - f7) * this.m20);
        float f9 = this.m10 * this.m22;
        float f10 = this.m10 * this.m21;
        float f11 = this.m11 * this.m22;
        float f12 = this.m11 * this.m20;
        float f13 = this.m12 * this.m21;
        float f14 = this.m12 * this.m20;
        float f15 = this.m20 * this.m02;
        float f16 = this.m20 * this.m01;
        float f17 = this.m21 * this.m02;
        float f18 = this.m21 * this.m00;
        float f19 = this.m22 * this.m01;
        float f20 = this.m22 * this.m00;
        float f21 = (f11 - f13) * f8;
        float f22 = (f17 - f19) * f8;
        float f23 = (f6 - f7) * f8;
        float f24 = (f14 - f9) * f8;
        float f25 = (f20 - f15) * f8;
        float f26 = (f4 - f5) * f8;
        float f27 = (f10 - f12) * f8;
        float f28 = (f16 - f18) * f8;
        float f29 = (f2 - f3) * f8;
        float f30 = (f9 * this.m31 - f10 * this.m32 + f12 * this.m32 - f11 * this.m30 + f13 * this.m30 - f14 * this.m31) * f8;
        float f31 = (f15 * this.m31 - f16 * this.m32 + f18 * this.m32 - f17 * this.m30 + f19 * this.m30 - f20 * this.m31) * f8;
        float f32 = (f7 * this.m30 - f6 * this.m30 + f5 * this.m31 - f4 * this.m31 + f3 * this.m32 - f2 * this.m32) * f8;
        return matrix4f._m00(f21)._m01(f22)._m02(f23)._m03(0.0f)._m10(f24)._m11(f25)._m12(f26)._m13(0.0f)._m20(f27)._m21(f28)._m22(f29)._m23(0.0f)._m30(f30)._m31(f31)._m32(f32)._m33(1.0f)._properties(0);
    }

    private Matrix4f invertOrthonormal(Matrix4f matrix4f) {
        float f2 = -(this.m00 * this.m30 + this.m01 * this.m31 + this.m02 * this.m32);
        float f3 = -(this.m10 * this.m30 + this.m11 * this.m31 + this.m12 * this.m32);
        float f4 = -(this.m20 * this.m30 + this.m21 * this.m31 + this.m22 * this.m32);
        float f5 = this.m01;
        float f6 = this.m02;
        float f7 = this.m12;
        return matrix4f._m00(this.m00)._m01(this.m10)._m02(this.m20)._m03(0.0f)._m10(f5)._m11(this.m11)._m12(this.m21)._m13(0.0f)._m20(f6)._m21(f7)._m22(this.m22)._m23(0.0f)._m30(f2)._m31(f3)._m32(f4)._m33(1.0f)._properties(16);
    }

    public Matrix4x3f invert() {
        return this.invert(this);
    }

    public Matrix4x3f invertOrtho(Matrix4x3f matrix4x3f) {
        float f2 = 1.0f / this.m00;
        float f3 = 1.0f / this.m11;
        float f4 = 1.0f / this.m22;
        matrix4x3f.set(f2, 0.0f, 0.0f, 0.0f, f3, 0.0f, 0.0f, 0.0f, f4, -this.m30 * f2, -this.m31 * f3, -this.m32 * f4);
        matrix4x3f.properties = 0;
        return matrix4x3f;
    }

    public Matrix4x3f invertOrtho() {
        return this.invertOrtho(this);
    }

    public Matrix4x3f transpose3x3() {
        return this.transpose3x3(this);
    }

    public Matrix4x3f transpose3x3(Matrix4x3f matrix4x3f) {
        float f2 = this.m00;
        float f3 = this.m10;
        float f4 = this.m20;
        float f5 = this.m01;
        float f6 = this.m11;
        float f7 = this.m21;
        float f8 = this.m02;
        float f9 = this.m12;
        float f10 = this.m22;
        matrix4x3f.m00 = f2;
        matrix4x3f.m01 = f3;
        matrix4x3f.m02 = f4;
        matrix4x3f.m10 = f5;
        matrix4x3f.m11 = f6;
        matrix4x3f.m12 = f7;
        matrix4x3f.m20 = f8;
        matrix4x3f.m21 = f9;
        matrix4x3f.m22 = f10;
        matrix4x3f.properties = this.properties;
        return matrix4x3f;
    }

    public Matrix3f transpose3x3(Matrix3f matrix3f) {
        matrix3f.m00(this.m00);
        matrix3f.m01(this.m10);
        matrix3f.m02(this.m20);
        matrix3f.m10(this.m01);
        matrix3f.m11(this.m11);
        matrix3f.m12(this.m21);
        matrix3f.m20(this.m02);
        matrix3f.m21(this.m12);
        matrix3f.m22(this.m22);
        return matrix3f;
    }

    public Matrix4x3f translation(float f2, float f3, float f4) {
        if ((this.properties & 4) == 0) {
            MemUtil.INSTANCE.identity(this);
        }
        this.m30 = f2;
        this.m31 = f3;
        this.m32 = f4;
        this.properties = 24;
        return this;
    }

    public Matrix4x3f translation(Vector3fc vector3fc) {
        return this.translation(vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Matrix4x3f setTranslation(float f2, float f3, float f4) {
        this.m30 = f2;
        this.m31 = f3;
        this.m32 = f4;
        this.properties &= 0xFFFFFFFB;
        return this;
    }

    public Matrix4x3f setTranslation(Vector3fc vector3fc) {
        return this.setTranslation(vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Vector3f getTranslation(Vector3f vector3f) {
        vector3f.x = this.m30;
        vector3f.y = this.m31;
        vector3f.z = this.m32;
        return vector3f;
    }

    public Vector3f getScale(Vector3f vector3f) {
        vector3f.x = Math.sqrt(this.m00 * this.m00 + this.m01 * this.m01 + this.m02 * this.m02);
        vector3f.y = Math.sqrt(this.m10 * this.m10 + this.m11 * this.m11 + this.m12 * this.m12);
        vector3f.z = Math.sqrt(this.m20 * this.m20 + this.m21 * this.m21 + this.m22 * this.m22);
        return vector3f;
    }

    public String toString() {
        String string = this.toString(Options.NUMBER_FORMAT);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = Integer.MIN_VALUE;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == 'E') {
                n2 = i2;
            } else {
                if (c2 == ' ' && n2 == i2 - 1) {
                    stringBuffer.append('+');
                    continue;
                }
                if (Character.isDigit(c2) && n2 == i2 - 1) {
                    stringBuffer.append('+');
                }
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public String toString(NumberFormat numberFormat) {
        return Runtime.format(this.m00, numberFormat) + " " + Runtime.format(this.m10, numberFormat) + " " + Runtime.format(this.m20, numberFormat) + " " + Runtime.format(this.m30, numberFormat) + "\n" + Runtime.format(this.m01, numberFormat) + " " + Runtime.format(this.m11, numberFormat) + " " + Runtime.format(this.m21, numberFormat) + " " + Runtime.format(this.m31, numberFormat) + "\n" + Runtime.format(this.m02, numberFormat) + " " + Runtime.format(this.m12, numberFormat) + " " + Runtime.format(this.m22, numberFormat) + " " + Runtime.format(this.m32, numberFormat) + "\n";
    }

    public Matrix4x3f get(Matrix4x3f matrix4x3f) {
        return matrix4x3f.set(this);
    }

    public Matrix4x3d get(Matrix4x3d matrix4x3d) {
        return matrix4x3d.set(this);
    }

    public AxisAngle4f getRotation(AxisAngle4f axisAngle4f) {
        return axisAngle4f.set(this);
    }

    public AxisAngle4d getRotation(AxisAngle4d axisAngle4d) {
        return axisAngle4d.set(this);
    }

    public Quaternionf getUnnormalizedRotation(Quaternionf quaternionf) {
        return quaternionf.setFromUnnormalized(this);
    }

    public Quaternionf getNormalizedRotation(Quaternionf quaternionf) {
        return quaternionf.setFromNormalized(this);
    }

    public Quaterniond getUnnormalizedRotation(Quaterniond quaterniond) {
        return quaterniond.setFromUnnormalized(this);
    }

    public Quaterniond getNormalizedRotation(Quaterniond quaterniond) {
        return quaterniond.setFromNormalized(this);
    }

    public FloatBuffer get(FloatBuffer floatBuffer) {
        return this.get(floatBuffer.position(), floatBuffer);
    }

    public FloatBuffer get(int n2, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put(this, n2, floatBuffer);
        return floatBuffer;
    }

    public ByteBuffer get(ByteBuffer byteBuffer) {
        return this.get(byteBuffer.position(), byteBuffer);
    }

    public ByteBuffer get(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, n2, byteBuffer);
        return byteBuffer;
    }

    public Matrix4x3fc getToAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil$MemUtilUnsafe.put(this, l2);
        return this;
    }

    public float[] get(float[] fArray, int n2) {
        MemUtil.INSTANCE.copy(this, fArray, n2);
        return fArray;
    }

    public float[] get(float[] fArray) {
        return this.get(fArray, 0);
    }

    public float[] get4x4(float[] fArray, int n2) {
        MemUtil.INSTANCE.copy4x4(this, fArray, n2);
        return fArray;
    }

    public float[] get4x4(float[] fArray) {
        return this.get4x4(fArray, 0);
    }

    public FloatBuffer get4x4(FloatBuffer floatBuffer) {
        return this.get4x4(floatBuffer.position(), floatBuffer);
    }

    public FloatBuffer get4x4(int n2, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put4x4(this, n2, floatBuffer);
        return floatBuffer;
    }

    public ByteBuffer get4x4(ByteBuffer byteBuffer) {
        return this.get4x4(byteBuffer.position(), byteBuffer);
    }

    public ByteBuffer get4x4(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put4x4(this, n2, byteBuffer);
        return byteBuffer;
    }

    public FloatBuffer get3x4(FloatBuffer floatBuffer) {
        return this.get3x4(floatBuffer.position(), floatBuffer);
    }

    public FloatBuffer get3x4(int n2, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put3x4(this, n2, floatBuffer);
        return floatBuffer;
    }

    public ByteBuffer get3x4(ByteBuffer byteBuffer) {
        return this.get3x4(byteBuffer.position(), byteBuffer);
    }

    public ByteBuffer get3x4(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put3x4(this, n2, byteBuffer);
        return byteBuffer;
    }

    public FloatBuffer getTransposed(FloatBuffer floatBuffer) {
        return this.getTransposed(floatBuffer.position(), floatBuffer);
    }

    public FloatBuffer getTransposed(int n2, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.putTransposed(this, n2, floatBuffer);
        return floatBuffer;
    }

    public ByteBuffer getTransposed(ByteBuffer byteBuffer) {
        return this.getTransposed(byteBuffer.position(), byteBuffer);
    }

    public ByteBuffer getTransposed(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.putTransposed(this, n2, byteBuffer);
        return byteBuffer;
    }

    public float[] getTransposed(float[] fArray, int n2) {
        fArray[n2 + 0] = this.m00;
        fArray[n2 + 1] = this.m10;
        fArray[n2 + 2] = this.m20;
        fArray[n2 + 3] = this.m30;
        fArray[n2 + 4] = this.m01;
        fArray[n2 + 5] = this.m11;
        fArray[n2 + 6] = this.m21;
        fArray[n2 + 7] = this.m31;
        fArray[n2 + 8] = this.m02;
        fArray[n2 + 9] = this.m12;
        fArray[n2 + 10] = this.m22;
        fArray[n2 + 11] = this.m32;
        return fArray;
    }

    public float[] getTransposed(float[] fArray) {
        return this.getTransposed(fArray, 0);
    }

    public Matrix4x3f zero() {
        MemUtil.INSTANCE.zero(this);
        this.properties = 0;
        return this;
    }

    public Matrix4x3f scaling(float f2) {
        return this.scaling(f2, f2, f2);
    }

    public Matrix4x3f scaling(float f2, float f3, float f4) {
        if ((this.properties & 4) == 0) {
            MemUtil.INSTANCE.identity(this);
        }
        this.m00 = f2;
        this.m11 = f3;
        this.m22 = f4;
        boolean bl2 = Math.absEqualsOne(f2) && Math.absEqualsOne(f3) && Math.absEqualsOne(f4);
        this.properties = bl2 ? 16 : 0;
        return this;
    }

    public Matrix4x3f scaling(Vector3fc vector3fc) {
        return this.scaling(vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Matrix4x3f rotation(float f2, Vector3fc vector3fc) {
        return this.rotation(f2, vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Matrix4x3f rotation(AxisAngle4f axisAngle4f) {
        return this.rotation(axisAngle4f.angle, axisAngle4f.x, axisAngle4f.y, axisAngle4f.z);
    }

    public Matrix4x3f rotation(float f2, float f3, float f4, float f5) {
        if (f4 == 0.0f && f5 == 0.0f && Math.absEqualsOne(f3)) {
            return this.rotationX(f3 * f2);
        }
        if (f3 == 0.0f && f5 == 0.0f && Math.absEqualsOne(f4)) {
            return this.rotationY(f4 * f2);
        }
        if (f3 == 0.0f && f4 == 0.0f && Math.absEqualsOne(f5)) {
            return this.rotationZ(f5 * f2);
        }
        return this.rotationInternal(f2, f3, f4, f5);
    }

    private Matrix4x3f rotationInternal(float f2, float f3, float f4, float f5) {
        float f6 = Math.sin(f2);
        float f7 = Math.cosFromSin(f6, f2);
        float f8 = 1.0f - f7;
        float f9 = f3 * f4;
        float f10 = f3 * f5;
        float f11 = f4 * f5;
        this.m00 = f7 + f3 * f3 * f8;
        this.m01 = f9 * f8 + f5 * f6;
        this.m02 = f10 * f8 - f4 * f6;
        this.m10 = f9 * f8 - f5 * f6;
        this.m11 = f7 + f4 * f4 * f8;
        this.m12 = f11 * f8 + f3 * f6;
        this.m20 = f10 * f8 + f4 * f6;
        this.m21 = f11 * f8 - f3 * f6;
        this.m22 = f7 + f5 * f5 * f8;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.properties = 16;
        return this;
    }

    public Matrix4x3f rotationX(float f2) {
        float f3 = Math.sin(f2);
        float f4 = Math.cosFromSin(f3, f2);
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = f4;
        this.m12 = f3;
        this.m20 = 0.0f;
        this.m21 = -f3;
        this.m22 = f4;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.properties = 16;
        return this;
    }

    public Matrix4x3f rotationY(float f2) {
        float f3;
        float f4 = Math.sin(f2);
        this.m00 = f3 = Math.cosFromSin(f4, f2);
        this.m01 = 0.0f;
        this.m02 = -f4;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m20 = f4;
        this.m21 = 0.0f;
        this.m22 = f3;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.properties = 16;
        return this;
    }

    public Matrix4x3f rotationZ(float f2) {
        float f3;
        float f4 = Math.sin(f2);
        this.m00 = f3 = Math.cosFromSin(f4, f2);
        this.m01 = f4;
        this.m02 = 0.0f;
        this.m10 = -f4;
        this.m11 = f3;
        this.m12 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.properties = 16;
        return this;
    }

    public Matrix4x3f rotationXYZ(float f2, float f3, float f4) {
        float f5 = Math.sin(f2);
        float f6 = Math.cosFromSin(f5, f2);
        float f7 = Math.sin(f3);
        float f8 = Math.cosFromSin(f7, f3);
        float f9 = Math.sin(f4);
        float f10 = Math.cosFromSin(f9, f4);
        float f11 = -f5;
        float f12 = -f7;
        float f13 = -f9;
        float f14 = f6;
        float f15 = f5;
        float f16 = f11;
        float f17 = f6;
        float f18 = f8;
        float f19 = f16 * f12;
        float f20 = f17 * f12;
        this.m20 = f7;
        this.m21 = f16 * f8;
        this.m22 = f17 * f8;
        this.m00 = f18 * f10;
        this.m01 = f19 * f10 + f14 * f9;
        this.m02 = f20 * f10 + f15 * f9;
        this.m10 = f18 * f13;
        this.m11 = f19 * f13 + f14 * f10;
        this.m12 = f20 * f13 + f15 * f10;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.properties = 16;
        return this;
    }

    public Matrix4x3f rotationZYX(float f2, float f3, float f4) {
        float f5 = Math.sin(f4);
        float f6 = Math.cosFromSin(f5, f4);
        float f7 = Math.sin(f3);
        float f8 = Math.cosFromSin(f7, f3);
        float f9 = Math.sin(f2);
        float f10 = Math.cosFromSin(f9, f2);
        float f11 = -f9;
        float f12 = -f7;
        float f13 = -f5;
        float f14 = f10;
        float f15 = f9;
        float f16 = f11;
        float f17 = f10;
        float f18 = f14 * f7;
        float f19 = f15 * f7;
        float f20 = f8;
        this.m00 = f14 * f8;
        this.m01 = f15 * f8;
        this.m02 = f12;
        this.m10 = f16 * f6 + f18 * f5;
        this.m11 = f17 * f6 + f19 * f5;
        this.m12 = f20 * f5;
        this.m20 = f16 * f13 + f18 * f6;
        this.m21 = f17 * f13 + f19 * f6;
        this.m22 = f20 * f6;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.properties = 16;
        return this;
    }

    public Matrix4x3f rotationYXZ(float f2, float f3, float f4) {
        float f5 = Math.sin(f3);
        float f6 = Math.cosFromSin(f5, f3);
        float f7 = Math.sin(f2);
        float f8 = Math.cosFromSin(f7, f2);
        float f9 = Math.sin(f4);
        float f10 = Math.cosFromSin(f9, f4);
        float f11 = -f7;
        float f12 = -f5;
        float f13 = -f9;
        float f14 = f8;
        float f15 = f11;
        float f16 = f7;
        float f17 = f8;
        float f18 = f16 * f5;
        float f19 = f6;
        float f20 = f17 * f5;
        this.m20 = f16 * f6;
        this.m21 = f12;
        this.m22 = f17 * f6;
        this.m00 = f14 * f10 + f18 * f9;
        this.m01 = f19 * f9;
        this.m02 = f15 * f10 + f20 * f9;
        this.m10 = f14 * f13 + f18 * f10;
        this.m11 = f19 * f10;
        this.m12 = f15 * f13 + f20 * f10;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.properties = 16;
        return this;
    }

    public Matrix4x3f setRotationXYZ(float f2, float f3, float f4) {
        float f5 = Math.sin(f2);
        float f6 = Math.cosFromSin(f5, f2);
        float f7 = Math.sin(f3);
        float f8 = Math.cosFromSin(f7, f3);
        float f9 = Math.sin(f4);
        float f10 = Math.cosFromSin(f9, f4);
        float f11 = -f5;
        float f12 = -f7;
        float f13 = -f9;
        float f14 = f6;
        float f15 = f5;
        float f16 = f11;
        float f17 = f6;
        float f18 = f8;
        float f19 = f16 * f12;
        float f20 = f17 * f12;
        this.m20 = f7;
        this.m21 = f16 * f8;
        this.m22 = f17 * f8;
        this.m00 = f18 * f10;
        this.m01 = f19 * f10 + f14 * f9;
        this.m02 = f20 * f10 + f15 * f9;
        this.m10 = f18 * f13;
        this.m11 = f19 * f13 + f14 * f10;
        this.m12 = f20 * f13 + f15 * f10;
        this.properties &= 0xFFFFFFF3;
        return this;
    }

    public Matrix4x3f setRotationZYX(float f2, float f3, float f4) {
        float f5 = Math.sin(f4);
        float f6 = Math.cosFromSin(f5, f4);
        float f7 = Math.sin(f3);
        float f8 = Math.cosFromSin(f7, f3);
        float f9 = Math.sin(f2);
        float f10 = Math.cosFromSin(f9, f2);
        float f11 = -f9;
        float f12 = -f7;
        float f13 = -f5;
        float f14 = f10;
        float f15 = f9;
        float f16 = f11;
        float f17 = f10;
        float f18 = f14 * f7;
        float f19 = f15 * f7;
        float f20 = f8;
        this.m00 = f14 * f8;
        this.m01 = f15 * f8;
        this.m02 = f12;
        this.m10 = f16 * f6 + f18 * f5;
        this.m11 = f17 * f6 + f19 * f5;
        this.m12 = f20 * f5;
        this.m20 = f16 * f13 + f18 * f6;
        this.m21 = f17 * f13 + f19 * f6;
        this.m22 = f20 * f6;
        this.properties &= 0xFFFFFFF3;
        return this;
    }

    public Matrix4x3f setRotationYXZ(float f2, float f3, float f4) {
        float f5 = Math.sin(f3);
        float f6 = Math.cosFromSin(f5, f3);
        float f7 = Math.sin(f2);
        float f8 = Math.cosFromSin(f7, f2);
        float f9 = Math.sin(f4);
        float f10 = Math.cosFromSin(f9, f4);
        float f11 = -f7;
        float f12 = -f5;
        float f13 = -f9;
        float f14 = f8;
        float f15 = f11;
        float f16 = f7;
        float f17 = f8;
        float f18 = f16 * f5;
        float f19 = f6;
        float f20 = f17 * f5;
        this.m20 = f16 * f6;
        this.m21 = f12;
        this.m22 = f17 * f6;
        this.m00 = f14 * f10 + f18 * f9;
        this.m01 = f19 * f9;
        this.m02 = f15 * f10 + f20 * f9;
        this.m10 = f14 * f13 + f18 * f10;
        this.m11 = f19 * f10;
        this.m12 = f15 * f13 + f20 * f10;
        this.properties &= 0xFFFFFFF3;
        return this;
    }

    public Matrix4x3f rotation(Quaternionfc quaternionfc) {
        float f2 = quaternionfc.w() * quaternionfc.w();
        float f3 = quaternionfc.x() * quaternionfc.x();
        float f4 = quaternionfc.y() * quaternionfc.y();
        float f5 = quaternionfc.z() * quaternionfc.z();
        float f6 = quaternionfc.z() * quaternionfc.w();
        float f7 = f6 + f6;
        float f8 = quaternionfc.x() * quaternionfc.y();
        float f9 = f8 + f8;
        float f10 = quaternionfc.x() * quaternionfc.z();
        float f11 = f10 + f10;
        float f12 = quaternionfc.y() * quaternionfc.w();
        float f13 = f12 + f12;
        float f14 = quaternionfc.y() * quaternionfc.z();
        float f15 = f14 + f14;
        float f16 = quaternionfc.x() * quaternionfc.w();
        float f17 = f16 + f16;
        this._m00(f2 + f3 - f5 - f4);
        this._m01(f9 + f7);
        this._m02(f11 - f13);
        this._m10(f9 - f7);
        this._m11(f4 - f5 + f2 - f3);
        this._m12(f15 + f17);
        this._m20(f13 + f11);
        this._m21(f15 - f17);
        this._m22(f5 - f4 - f3 + f2);
        this._m30(0.0f);
        this._m31(0.0f);
        this._m32(0.0f);
        this.properties = 16;
        return this;
    }

    public Matrix4x3f translationRotateScale(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11) {
        float f12 = f5 + f5;
        float f13 = f6 + f6;
        float f14 = f7 + f7;
        float f15 = f12 * f5;
        float f16 = f13 * f6;
        float f17 = f14 * f7;
        float f18 = f12 * f6;
        float f19 = f12 * f7;
        float f20 = f12 * f8;
        float f21 = f13 * f7;
        float f22 = f13 * f8;
        float f23 = f14 * f8;
        this.m00 = f9 - (f16 + f17) * f9;
        this.m01 = (f18 + f23) * f9;
        this.m02 = (f19 - f22) * f9;
        this.m10 = (f18 - f23) * f10;
        this.m11 = f10 - (f17 + f15) * f10;
        this.m12 = (f21 + f20) * f10;
        this.m20 = (f19 + f22) * f11;
        this.m21 = (f21 - f20) * f11;
        this.m22 = f11 - (f16 + f15) * f11;
        this.m30 = f2;
        this.m31 = f3;
        this.m32 = f4;
        this.properties = 0;
        return this;
    }

    public Matrix4x3f translationRotateScale(Vector3fc vector3fc, Quaternionfc quaternionfc, Vector3fc vector3fc2) {
        return this.translationRotateScale(vector3fc.x(), vector3fc.y(), vector3fc.z(), quaternionfc.x(), quaternionfc.y(), quaternionfc.z(), quaternionfc.w(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z());
    }

    public Matrix4x3f translationRotateScaleMul(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, Matrix4x3f matrix4x3f) {
        float f12 = f5 + f5;
        float f13 = f6 + f6;
        float f14 = f7 + f7;
        float f15 = f12 * f5;
        float f16 = f13 * f6;
        float f17 = f14 * f7;
        float f18 = f12 * f6;
        float f19 = f12 * f7;
        float f20 = f12 * f8;
        float f21 = f13 * f7;
        float f22 = f13 * f8;
        float f23 = f14 * f8;
        float f24 = f9 - (f16 + f17) * f9;
        float f25 = (f18 + f23) * f9;
        float f26 = (f19 - f22) * f9;
        float f27 = (f18 - f23) * f10;
        float f28 = f10 - (f17 + f15) * f10;
        float f29 = (f21 + f20) * f10;
        float f30 = (f19 + f22) * f11;
        float f31 = (f21 - f20) * f11;
        float f32 = f11 - (f16 + f15) * f11;
        float f33 = f24 * matrix4x3f.m00 + f27 * matrix4x3f.m01 + f30 * matrix4x3f.m02;
        float f34 = f25 * matrix4x3f.m00 + f28 * matrix4x3f.m01 + f31 * matrix4x3f.m02;
        this.m02 = f26 * matrix4x3f.m00 + f29 * matrix4x3f.m01 + f32 * matrix4x3f.m02;
        this.m00 = f33;
        this.m01 = f34;
        float f35 = f24 * matrix4x3f.m10 + f27 * matrix4x3f.m11 + f30 * matrix4x3f.m12;
        float f36 = f25 * matrix4x3f.m10 + f28 * matrix4x3f.m11 + f31 * matrix4x3f.m12;
        this.m12 = f26 * matrix4x3f.m10 + f29 * matrix4x3f.m11 + f32 * matrix4x3f.m12;
        this.m10 = f35;
        this.m11 = f36;
        float f37 = f24 * matrix4x3f.m20 + f27 * matrix4x3f.m21 + f30 * matrix4x3f.m22;
        float f38 = f25 * matrix4x3f.m20 + f28 * matrix4x3f.m21 + f31 * matrix4x3f.m22;
        this.m22 = f26 * matrix4x3f.m20 + f29 * matrix4x3f.m21 + f32 * matrix4x3f.m22;
        this.m20 = f37;
        this.m21 = f38;
        float f39 = f24 * matrix4x3f.m30 + f27 * matrix4x3f.m31 + f30 * matrix4x3f.m32 + f2;
        float f40 = f25 * matrix4x3f.m30 + f28 * matrix4x3f.m31 + f31 * matrix4x3f.m32 + f3;
        this.m32 = f26 * matrix4x3f.m30 + f29 * matrix4x3f.m31 + f32 * matrix4x3f.m32 + f4;
        this.m30 = f39;
        this.m31 = f40;
        this.properties = 0;
        return this;
    }

    public Matrix4x3f translationRotateScaleMul(Vector3fc vector3fc, Quaternionfc quaternionfc, Vector3fc vector3fc2, Matrix4x3f matrix4x3f) {
        return this.translationRotateScaleMul(vector3fc.x(), vector3fc.y(), vector3fc.z(), quaternionfc.x(), quaternionfc.y(), quaternionfc.z(), quaternionfc.w(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), matrix4x3f);
    }

    public Matrix4x3f translationRotate(float f2, float f3, float f4, Quaternionfc quaternionfc) {
        float f5 = quaternionfc.x() + quaternionfc.x();
        float f6 = quaternionfc.y() + quaternionfc.y();
        float f7 = quaternionfc.z() + quaternionfc.z();
        float f8 = f5 * quaternionfc.x();
        float f9 = f6 * quaternionfc.y();
        float f10 = f7 * quaternionfc.z();
        float f11 = f5 * quaternionfc.y();
        float f12 = f5 * quaternionfc.z();
        float f13 = f5 * quaternionfc.w();
        float f14 = f6 * quaternionfc.z();
        float f15 = f6 * quaternionfc.w();
        float f16 = f7 * quaternionfc.w();
        this.m00 = 1.0f - (f9 + f10);
        this.m01 = f11 + f16;
        this.m02 = f12 - f15;
        this.m10 = f11 - f16;
        this.m11 = 1.0f - (f10 + f8);
        this.m12 = f14 + f13;
        this.m20 = f12 + f15;
        this.m21 = f14 - f13;
        this.m22 = 1.0f - (f9 + f8);
        this.m30 = f2;
        this.m31 = f3;
        this.m32 = f4;
        this.properties = 16;
        return this;
    }

    public Matrix4x3f translationRotate(float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9 = f8 * f8;
        float f10 = f5 * f5;
        float f11 = f6 * f6;
        float f12 = f7 * f7;
        float f13 = f7 * f8;
        float f14 = f5 * f6;
        float f15 = f5 * f7;
        float f16 = f6 * f8;
        float f17 = f6 * f7;
        float f18 = f5 * f8;
        this.m00 = f9 + f10 - f12 - f11;
        this.m01 = f14 + f13 + f13 + f14;
        this.m02 = f15 - f16 + f15 - f16;
        this.m10 = -f13 + f14 - f13 + f14;
        this.m11 = f11 - f12 + f9 - f10;
        this.m12 = f17 + f17 + f18 + f18;
        this.m20 = f16 + f15 + f15 + f16;
        this.m21 = f17 + f17 - f18 - f18;
        this.m22 = f12 - f11 - f10 + f9;
        this.m30 = f2;
        this.m31 = f3;
        this.m32 = f4;
        this.properties = 16;
        return this;
    }

    public Matrix4x3f translationRotate(Vector3fc vector3fc, Quaternionfc quaternionfc) {
        return this.translationRotate(vector3fc.x(), vector3fc.y(), vector3fc.z(), quaternionfc.x(), quaternionfc.y(), quaternionfc.z(), quaternionfc.w());
    }

    public Matrix4x3f translationRotateMul(float f2, float f3, float f4, Quaternionfc quaternionfc, Matrix4x3fc matrix4x3fc) {
        return this.translationRotateMul(f2, f3, f4, quaternionfc.x(), quaternionfc.y(), quaternionfc.z(), quaternionfc.w(), matrix4x3fc);
    }

    public Matrix4x3f translationRotateMul(float f2, float f3, float f4, float f5, float f6, float f7, float f8, Matrix4x3fc matrix4x3fc) {
        float f9 = f8 * f8;
        float f10 = f5 * f5;
        float f11 = f6 * f6;
        float f12 = f7 * f7;
        float f13 = f7 * f8;
        float f14 = f5 * f6;
        float f15 = f5 * f7;
        float f16 = f6 * f8;
        float f17 = f6 * f7;
        float f18 = f5 * f8;
        float f19 = f9 + f10 - f12 - f11;
        float f20 = f14 + f13 + f13 + f14;
        float f21 = f15 - f16 + f15 - f16;
        float f22 = -f13 + f14 - f13 + f14;
        float f23 = f11 - f12 + f9 - f10;
        float f24 = f17 + f17 + f18 + f18;
        float f25 = f16 + f15 + f15 + f16;
        float f26 = f17 + f17 - f18 - f18;
        float f27 = f12 - f11 - f10 + f9;
        this.m00 = f19 * matrix4x3fc.m00() + f22 * matrix4x3fc.m01() + f25 * matrix4x3fc.m02();
        this.m01 = f20 * matrix4x3fc.m00() + f23 * matrix4x3fc.m01() + f26 * matrix4x3fc.m02();
        this.m02 = f21 * matrix4x3fc.m00() + f24 * matrix4x3fc.m01() + f27 * matrix4x3fc.m02();
        this.m10 = f19 * matrix4x3fc.m10() + f22 * matrix4x3fc.m11() + f25 * matrix4x3fc.m12();
        this.m11 = f20 * matrix4x3fc.m10() + f23 * matrix4x3fc.m11() + f26 * matrix4x3fc.m12();
        this.m12 = f21 * matrix4x3fc.m10() + f24 * matrix4x3fc.m11() + f27 * matrix4x3fc.m12();
        this.m20 = f19 * matrix4x3fc.m20() + f22 * matrix4x3fc.m21() + f25 * matrix4x3fc.m22();
        this.m21 = f20 * matrix4x3fc.m20() + f23 * matrix4x3fc.m21() + f26 * matrix4x3fc.m22();
        this.m22 = f21 * matrix4x3fc.m20() + f24 * matrix4x3fc.m21() + f27 * matrix4x3fc.m22();
        this.m30 = f19 * matrix4x3fc.m30() + f22 * matrix4x3fc.m31() + f25 * matrix4x3fc.m32() + f2;
        this.m31 = f20 * matrix4x3fc.m30() + f23 * matrix4x3fc.m31() + f26 * matrix4x3fc.m32() + f3;
        this.m32 = f21 * matrix4x3fc.m30() + f24 * matrix4x3fc.m31() + f27 * matrix4x3fc.m32() + f4;
        this.properties = 0;
        return this;
    }

    public Matrix4x3f translationRotateInvert(float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9 = -f5;
        float f10 = -f6;
        float f11 = -f7;
        float f12 = f9 + f9;
        float f13 = f10 + f10;
        float f14 = f11 + f11;
        float f15 = f12 * f9;
        float f16 = f13 * f10;
        float f17 = f14 * f11;
        float f18 = f12 * f10;
        float f19 = f12 * f11;
        float f20 = f12 * f8;
        float f21 = f13 * f11;
        float f22 = f13 * f8;
        float f23 = f14 * f8;
        return this._m00(1.0f - f16 - f17)._m01(f18 + f23)._m02(f19 - f22)._m10(f18 - f23)._m11(1.0f - f17 - f15)._m12(f21 + f20)._m20(f19 + f22)._m21(f21 - f20)._m22(1.0f - f16 - f15)._m30(-this.m00 * f2 - this.m10 * f3 - this.m20 * f4)._m31(-this.m01 * f2 - this.m11 * f3 - this.m21 * f4)._m32(-this.m02 * f2 - this.m12 * f3 - this.m22 * f4)._properties(16);
    }

    public Matrix4x3f translationRotateInvert(Vector3fc vector3fc, Quaternionfc quaternionfc) {
        return this.translationRotateInvert(vector3fc.x(), vector3fc.y(), vector3fc.z(), quaternionfc.x(), quaternionfc.y(), quaternionfc.z(), quaternionfc.w());
    }

    public Matrix4x3f set3x3(Matrix3fc matrix3fc) {
        if (matrix3fc instanceof Matrix3f) {
            MemUtil.INSTANCE.copy3x3((Matrix3f)matrix3fc, this);
        } else {
            this.set3x3Matrix3fc(matrix3fc);
        }
        this.properties = 0;
        return this;
    }

    private void set3x3Matrix3fc(Matrix3fc matrix3fc) {
        this.m00 = matrix3fc.m00();
        this.m01 = matrix3fc.m01();
        this.m02 = matrix3fc.m02();
        this.m10 = matrix3fc.m10();
        this.m11 = matrix3fc.m11();
        this.m12 = matrix3fc.m12();
        this.m20 = matrix3fc.m20();
        this.m21 = matrix3fc.m21();
        this.m22 = matrix3fc.m22();
    }

    public Vector4f transform(Vector4f vector4f) {
        return vector4f.mul(this);
    }

    public Vector4f transform(Vector4fc vector4fc, Vector4f vector4f) {
        return vector4fc.mul(this, vector4f);
    }

    public Vector3f transformPosition(Vector3f vector3f) {
        vector3f.set(this.m00 * vector3f.x + this.m10 * vector3f.y + this.m20 * vector3f.z + this.m30, this.m01 * vector3f.x + this.m11 * vector3f.y + this.m21 * vector3f.z + this.m31, this.m02 * vector3f.x + this.m12 * vector3f.y + this.m22 * vector3f.z + this.m32);
        return vector3f;
    }

    public Vector3f transformPosition(Vector3fc vector3fc, Vector3f vector3f) {
        vector3f.set(this.m00 * vector3fc.x() + this.m10 * vector3fc.y() + this.m20 * vector3fc.z() + this.m30, this.m01 * vector3fc.x() + this.m11 * vector3fc.y() + this.m21 * vector3fc.z() + this.m31, this.m02 * vector3fc.x() + this.m12 * vector3fc.y() + this.m22 * vector3fc.z() + this.m32);
        return vector3f;
    }

    public Vector3f transformDirection(Vector3f vector3f) {
        vector3f.set(this.m00 * vector3f.x + this.m10 * vector3f.y + this.m20 * vector3f.z, this.m01 * vector3f.x + this.m11 * vector3f.y + this.m21 * vector3f.z, this.m02 * vector3f.x + this.m12 * vector3f.y + this.m22 * vector3f.z);
        return vector3f;
    }

    public Vector3f transformDirection(Vector3fc vector3fc, Vector3f vector3f) {
        vector3f.set(this.m00 * vector3fc.x() + this.m10 * vector3fc.y() + this.m20 * vector3fc.z(), this.m01 * vector3fc.x() + this.m11 * vector3fc.y() + this.m21 * vector3fc.z(), this.m02 * vector3fc.x() + this.m12 * vector3fc.y() + this.m22 * vector3fc.z());
        return vector3f;
    }

    public Matrix4x3f scale(Vector3fc vector3fc, Matrix4x3f matrix4x3f) {
        return this.scale(vector3fc.x(), vector3fc.y(), vector3fc.z(), matrix4x3f);
    }

    public Matrix4x3f scale(Vector3fc vector3fc) {
        return this.scale(vector3fc.x(), vector3fc.y(), vector3fc.z(), this);
    }

    public Matrix4x3f scale(float f2, Matrix4x3f matrix4x3f) {
        return this.scale(f2, f2, f2, matrix4x3f);
    }

    public Matrix4x3f scale(float f2) {
        return this.scale(f2, f2, f2);
    }

    public Matrix4x3f scaleXY(float f2, float f3, Matrix4x3f matrix4x3f) {
        return this.scale(f2, f3, 1.0f, matrix4x3f);
    }

    public Matrix4x3f scaleXY(float f2, float f3) {
        return this.scale(f2, f3, 1.0f);
    }

    public Matrix4x3f scale(float f2, float f3, float f4, Matrix4x3f matrix4x3f) {
        if ((this.properties & 4) != 0) {
            return matrix4x3f.scaling(f2, f3, f4);
        }
        return this.scaleGeneric(f2, f3, f4, matrix4x3f);
    }

    private Matrix4x3f scaleGeneric(float f2, float f3, float f4, Matrix4x3f matrix4x3f) {
        matrix4x3f.m00 = this.m00 * f2;
        matrix4x3f.m01 = this.m01 * f2;
        matrix4x3f.m02 = this.m02 * f2;
        matrix4x3f.m10 = this.m10 * f3;
        matrix4x3f.m11 = this.m11 * f3;
        matrix4x3f.m12 = this.m12 * f3;
        matrix4x3f.m20 = this.m20 * f4;
        matrix4x3f.m21 = this.m21 * f4;
        matrix4x3f.m22 = this.m22 * f4;
        matrix4x3f.m30 = this.m30;
        matrix4x3f.m31 = this.m31;
        matrix4x3f.m32 = this.m32;
        matrix4x3f.properties = this.properties & 0xFFFFFFE3;
        return matrix4x3f;
    }

    public Matrix4x3f scale(float f2, float f3, float f4) {
        return this.scale(f2, f3, f4, this);
    }

    public Matrix4x3f scaleLocal(float f2, float f3, float f4, Matrix4x3f matrix4x3f) {
        if ((this.properties & 4) != 0) {
            return matrix4x3f.scaling(f2, f3, f4);
        }
        float f5 = f2 * this.m00;
        float f6 = f3 * this.m01;
        float f7 = f4 * this.m02;
        float f8 = f2 * this.m10;
        float f9 = f3 * this.m11;
        float f10 = f4 * this.m12;
        float f11 = f2 * this.m20;
        float f12 = f3 * this.m21;
        float f13 = f4 * this.m22;
        float f14 = f2 * this.m30;
        float f15 = f3 * this.m31;
        float f16 = f4 * this.m32;
        matrix4x3f.m00 = f5;
        matrix4x3f.m01 = f6;
        matrix4x3f.m02 = f7;
        matrix4x3f.m10 = f8;
        matrix4x3f.m11 = f9;
        matrix4x3f.m12 = f10;
        matrix4x3f.m20 = f11;
        matrix4x3f.m21 = f12;
        matrix4x3f.m22 = f13;
        matrix4x3f.m30 = f14;
        matrix4x3f.m31 = f15;
        matrix4x3f.m32 = f16;
        matrix4x3f.properties = this.properties & 0xFFFFFFE3;
        return matrix4x3f;
    }

    public Matrix4x3f scaleAround(float f2, float f3, float f4, float f5, float f6, float f7, Matrix4x3f matrix4x3f) {
        float f8 = this.m00 * f5 + this.m10 * f6 + this.m20 * f7 + this.m30;
        float f9 = this.m01 * f5 + this.m11 * f6 + this.m21 * f7 + this.m31;
        float f10 = this.m02 * f5 + this.m12 * f6 + this.m22 * f7 + this.m32;
        boolean bl2 = Math.absEqualsOne(f2) && Math.absEqualsOne(f3) && Math.absEqualsOne(f4);
        return matrix4x3f._m00(this.m00 * f2)._m01(this.m01 * f2)._m02(this.m02 * f2)._m10(this.m10 * f3)._m11(this.m11 * f3)._m12(this.m12 * f3)._m20(this.m20 * f4)._m21(this.m21 * f4)._m22(this.m22 * f4)._m30(-matrix4x3f.m00 * f5 - matrix4x3f.m10 * f6 - matrix4x3f.m20 * f7 + f8)._m31(-matrix4x3f.m01 * f5 - matrix4x3f.m11 * f6 - matrix4x3f.m21 * f7 + f9)._m32(-matrix4x3f.m02 * f5 - matrix4x3f.m12 * f6 - matrix4x3f.m22 * f7 + f10)._properties(this.properties & ~(0xC | (bl2 ? 0 : 16)));
    }

    public Matrix4x3f scaleAround(float f2, float f3, float f4, float f5, float f6, float f7) {
        return this.scaleAround(f2, f3, f4, f5, f6, f7, this);
    }

    public Matrix4x3f scaleAround(float f2, float f3, float f4, float f5) {
        return this.scaleAround(f2, f2, f2, f3, f4, f5, this);
    }

    public Matrix4x3f scaleAround(float f2, float f3, float f4, float f5, Matrix4x3f matrix4x3f) {
        return this.scaleAround(f2, f2, f2, f3, f4, f5, matrix4x3f);
    }

    public Matrix4x3f scaleLocal(float f2, float f3, float f4) {
        return this.scaleLocal(f2, f3, f4, this);
    }

    public Matrix4x3f rotateX(float f2, Matrix4x3f matrix4x3f) {
        if ((this.properties & 4) != 0) {
            return matrix4x3f.rotationX(f2);
        }
        if ((this.properties & 8) != 0) {
            float f3 = this.m30;
            float f4 = this.m31;
            float f5 = this.m32;
            return matrix4x3f.rotationX(f2).setTranslation(f3, f4, f5);
        }
        return this.rotateXInternal(f2, matrix4x3f);
    }

    private Matrix4x3f rotateXInternal(float f2, Matrix4x3f matrix4x3f) {
        float f3;
        float f4 = Math.sin(f2);
        float f5 = f3 = Math.cosFromSin(f4, f2);
        float f6 = f4;
        float f7 = -f4;
        float f8 = f3;
        float f9 = this.m10 * f5 + this.m20 * f6;
        float f10 = this.m11 * f5 + this.m21 * f6;
        float f11 = this.m12 * f5 + this.m22 * f6;
        matrix4x3f.m20 = this.m10 * f7 + this.m20 * f8;
        matrix4x3f.m21 = this.m11 * f7 + this.m21 * f8;
        matrix4x3f.m22 = this.m12 * f7 + this.m22 * f8;
        matrix4x3f.m10 = f9;
        matrix4x3f.m11 = f10;
        matrix4x3f.m12 = f11;
        matrix4x3f.m00 = this.m00;
        matrix4x3f.m01 = this.m01;
        matrix4x3f.m02 = this.m02;
        matrix4x3f.m30 = this.m30;
        matrix4x3f.m31 = this.m31;
        matrix4x3f.m32 = this.m32;
        matrix4x3f.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3f;
    }

    public Matrix4x3f rotateX(float f2) {
        return this.rotateX(f2, this);
    }

    public Matrix4x3f rotateY(float f2, Matrix4x3f matrix4x3f) {
        if ((this.properties & 4) != 0) {
            return matrix4x3f.rotationY(f2);
        }
        if ((this.properties & 8) != 0) {
            float f3 = this.m30;
            float f4 = this.m31;
            float f5 = this.m32;
            return matrix4x3f.rotationY(f2).setTranslation(f3, f4, f5);
        }
        return this.rotateYInternal(f2, matrix4x3f);
    }

    private Matrix4x3f rotateYInternal(float f2, Matrix4x3f matrix4x3f) {
        float f3;
        float f4 = Math.sin(f2);
        float f5 = f3 = Math.cosFromSin(f4, f2);
        float f6 = -f4;
        float f7 = f4;
        float f8 = f3;
        float f9 = this.m00 * f5 + this.m20 * f6;
        float f10 = this.m01 * f5 + this.m21 * f6;
        float f11 = this.m02 * f5 + this.m22 * f6;
        matrix4x3f.m20 = this.m00 * f7 + this.m20 * f8;
        matrix4x3f.m21 = this.m01 * f7 + this.m21 * f8;
        matrix4x3f.m22 = this.m02 * f7 + this.m22 * f8;
        matrix4x3f.m00 = f9;
        matrix4x3f.m01 = f10;
        matrix4x3f.m02 = f11;
        matrix4x3f.m10 = this.m10;
        matrix4x3f.m11 = this.m11;
        matrix4x3f.m12 = this.m12;
        matrix4x3f.m30 = this.m30;
        matrix4x3f.m31 = this.m31;
        matrix4x3f.m32 = this.m32;
        matrix4x3f.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3f;
    }

    public Matrix4x3f rotateY(float f2) {
        return this.rotateY(f2, this);
    }

    public Matrix4x3f rotateZ(float f2, Matrix4x3f matrix4x3f) {
        if ((this.properties & 4) != 0) {
            return matrix4x3f.rotationZ(f2);
        }
        if ((this.properties & 8) != 0) {
            float f3 = this.m30;
            float f4 = this.m31;
            float f5 = this.m32;
            return matrix4x3f.rotationZ(f2).setTranslation(f3, f4, f5);
        }
        return this.rotateZInternal(f2, matrix4x3f);
    }

    private Matrix4x3f rotateZInternal(float f2, Matrix4x3f matrix4x3f) {
        float f3;
        float f4 = Math.sin(f2);
        float f5 = f3 = Math.cosFromSin(f4, f2);
        float f6 = f4;
        float f7 = -f4;
        float f8 = f3;
        float f9 = this.m00 * f5 + this.m10 * f6;
        float f10 = this.m01 * f5 + this.m11 * f6;
        float f11 = this.m02 * f5 + this.m12 * f6;
        matrix4x3f.m10 = this.m00 * f7 + this.m10 * f8;
        matrix4x3f.m11 = this.m01 * f7 + this.m11 * f8;
        matrix4x3f.m12 = this.m02 * f7 + this.m12 * f8;
        matrix4x3f.m00 = f9;
        matrix4x3f.m01 = f10;
        matrix4x3f.m02 = f11;
        matrix4x3f.m20 = this.m20;
        matrix4x3f.m21 = this.m21;
        matrix4x3f.m22 = this.m22;
        matrix4x3f.m30 = this.m30;
        matrix4x3f.m31 = this.m31;
        matrix4x3f.m32 = this.m32;
        matrix4x3f.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3f;
    }

    public Matrix4x3f rotateZ(float f2) {
        return this.rotateZ(f2, this);
    }

    public Matrix4x3f rotateXYZ(Vector3f vector3f) {
        return this.rotateXYZ(vector3f.x, vector3f.y, vector3f.z);
    }

    public Matrix4x3f rotateXYZ(float f2, float f3, float f4) {
        return this.rotateXYZ(f2, f3, f4, this);
    }

    public Matrix4x3f rotateXYZ(float f2, float f3, float f4, Matrix4x3f matrix4x3f) {
        if ((this.properties & 4) != 0) {
            return matrix4x3f.rotationXYZ(f2, f3, f4);
        }
        if ((this.properties & 8) != 0) {
            float f5 = this.m30;
            float f6 = this.m31;
            float f7 = this.m32;
            return matrix4x3f.rotationXYZ(f2, f3, f4).setTranslation(f5, f6, f7);
        }
        return this.rotateXYZInternal(f2, f3, f4, matrix4x3f);
    }

    private Matrix4x3f rotateXYZInternal(float f2, float f3, float f4, Matrix4x3f matrix4x3f) {
        float f5 = Math.sin(f2);
        float f6 = Math.cosFromSin(f5, f2);
        float f7 = Math.sin(f3);
        float f8 = Math.cosFromSin(f7, f3);
        float f9 = Math.sin(f4);
        float f10 = Math.cosFromSin(f9, f4);
        float f11 = -f5;
        float f12 = -f7;
        float f13 = -f9;
        float f14 = this.m10 * f6 + this.m20 * f5;
        float f15 = this.m11 * f6 + this.m21 * f5;
        float f16 = this.m12 * f6 + this.m22 * f5;
        float f17 = this.m10 * f11 + this.m20 * f6;
        float f18 = this.m11 * f11 + this.m21 * f6;
        float f19 = this.m12 * f11 + this.m22 * f6;
        float f20 = this.m00 * f8 + f17 * f12;
        float f21 = this.m01 * f8 + f18 * f12;
        float f22 = this.m02 * f8 + f19 * f12;
        matrix4x3f.m20 = this.m00 * f7 + f17 * f8;
        matrix4x3f.m21 = this.m01 * f7 + f18 * f8;
        matrix4x3f.m22 = this.m02 * f7 + f19 * f8;
        matrix4x3f.m00 = f20 * f10 + f14 * f9;
        matrix4x3f.m01 = f21 * f10 + f15 * f9;
        matrix4x3f.m02 = f22 * f10 + f16 * f9;
        matrix4x3f.m10 = f20 * f13 + f14 * f10;
        matrix4x3f.m11 = f21 * f13 + f15 * f10;
        matrix4x3f.m12 = f22 * f13 + f16 * f10;
        matrix4x3f.m30 = this.m30;
        matrix4x3f.m31 = this.m31;
        matrix4x3f.m32 = this.m32;
        matrix4x3f.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3f;
    }

    public Matrix4x3f rotateZYX(Vector3f vector3f) {
        return this.rotateZYX(vector3f.z, vector3f.y, vector3f.x);
    }

    public Matrix4x3f rotateZYX(float f2, float f3, float f4) {
        return this.rotateZYX(f2, f3, f4, this);
    }

    public Matrix4x3f rotateZYX(float f2, float f3, float f4, Matrix4x3f matrix4x3f) {
        if ((this.properties & 4) != 0) {
            return matrix4x3f.rotationZYX(f2, f3, f4);
        }
        if ((this.properties & 8) != 0) {
            float f5 = this.m30;
            float f6 = this.m31;
            float f7 = this.m32;
            return matrix4x3f.rotationZYX(f2, f3, f4).setTranslation(f5, f6, f7);
        }
        return this.rotateZYXInternal(f2, f3, f4, matrix4x3f);
    }

    private Matrix4x3f rotateZYXInternal(float f2, float f3, float f4, Matrix4x3f matrix4x3f) {
        float f5 = Math.sin(f4);
        float f6 = Math.cosFromSin(f5, f4);
        float f7 = Math.sin(f3);
        float f8 = Math.cosFromSin(f7, f3);
        float f9 = Math.sin(f2);
        float f10 = Math.cosFromSin(f9, f2);
        float f11 = -f9;
        float f12 = -f7;
        float f13 = -f5;
        float f14 = this.m00 * f10 + this.m10 * f9;
        float f15 = this.m01 * f10 + this.m11 * f9;
        float f16 = this.m02 * f10 + this.m12 * f9;
        float f17 = this.m00 * f11 + this.m10 * f10;
        float f18 = this.m01 * f11 + this.m11 * f10;
        float f19 = this.m02 * f11 + this.m12 * f10;
        float f20 = f14 * f7 + this.m20 * f8;
        float f21 = f15 * f7 + this.m21 * f8;
        float f22 = f16 * f7 + this.m22 * f8;
        matrix4x3f.m00 = f14 * f8 + this.m20 * f12;
        matrix4x3f.m01 = f15 * f8 + this.m21 * f12;
        matrix4x3f.m02 = f16 * f8 + this.m22 * f12;
        matrix4x3f.m10 = f17 * f6 + f20 * f5;
        matrix4x3f.m11 = f18 * f6 + f21 * f5;
        matrix4x3f.m12 = f19 * f6 + f22 * f5;
        matrix4x3f.m20 = f17 * f13 + f20 * f6;
        matrix4x3f.m21 = f18 * f13 + f21 * f6;
        matrix4x3f.m22 = f19 * f13 + f22 * f6;
        matrix4x3f.m30 = this.m30;
        matrix4x3f.m31 = this.m31;
        matrix4x3f.m32 = this.m32;
        matrix4x3f.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3f;
    }

    public Matrix4x3f rotateYXZ(Vector3f vector3f) {
        return this.rotateYXZ(vector3f.y, vector3f.x, vector3f.z);
    }

    public Matrix4x3f rotateYXZ(float f2, float f3, float f4) {
        return this.rotateYXZ(f2, f3, f4, this);
    }

    public Matrix4x3f rotateYXZ(float f2, float f3, float f4, Matrix4x3f matrix4x3f) {
        if ((this.properties & 4) != 0) {
            return matrix4x3f.rotationYXZ(f2, f3, f4);
        }
        if ((this.properties & 8) != 0) {
            float f5 = this.m30;
            float f6 = this.m31;
            float f7 = this.m32;
            return matrix4x3f.rotationYXZ(f2, f3, f4).setTranslation(f5, f6, f7);
        }
        return this.rotateYXZInternal(f2, f3, f4, matrix4x3f);
    }

    private Matrix4x3f rotateYXZInternal(float f2, float f3, float f4, Matrix4x3f matrix4x3f) {
        float f5 = Math.sin(f3);
        float f6 = Math.cosFromSin(f5, f3);
        float f7 = Math.sin(f2);
        float f8 = Math.cosFromSin(f7, f2);
        float f9 = Math.sin(f4);
        float f10 = Math.cosFromSin(f9, f4);
        float f11 = -f7;
        float f12 = -f5;
        float f13 = -f9;
        float f14 = this.m00 * f7 + this.m20 * f8;
        float f15 = this.m01 * f7 + this.m21 * f8;
        float f16 = this.m02 * f7 + this.m22 * f8;
        float f17 = this.m00 * f8 + this.m20 * f11;
        float f18 = this.m01 * f8 + this.m21 * f11;
        float f19 = this.m02 * f8 + this.m22 * f11;
        float f20 = this.m10 * f6 + f14 * f5;
        float f21 = this.m11 * f6 + f15 * f5;
        float f22 = this.m12 * f6 + f16 * f5;
        matrix4x3f.m20 = this.m10 * f12 + f14 * f6;
        matrix4x3f.m21 = this.m11 * f12 + f15 * f6;
        matrix4x3f.m22 = this.m12 * f12 + f16 * f6;
        matrix4x3f.m00 = f17 * f10 + f20 * f9;
        matrix4x3f.m01 = f18 * f10 + f21 * f9;
        matrix4x3f.m02 = f19 * f10 + f22 * f9;
        matrix4x3f.m10 = f17 * f13 + f20 * f10;
        matrix4x3f.m11 = f18 * f13 + f21 * f10;
        matrix4x3f.m12 = f19 * f13 + f22 * f10;
        matrix4x3f.m30 = this.m30;
        matrix4x3f.m31 = this.m31;
        matrix4x3f.m32 = this.m32;
        matrix4x3f.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3f;
    }

    public Matrix4x3f rotate(float f2, float f3, float f4, float f5, Matrix4x3f matrix4x3f) {
        if ((this.properties & 4) != 0) {
            return matrix4x3f.rotation(f2, f3, f4, f5);
        }
        if ((this.properties & 8) != 0) {
            return this.rotateTranslation(f2, f3, f4, f5, matrix4x3f);
        }
        return this.rotateGeneric(f2, f3, f4, f5, matrix4x3f);
    }

    private Matrix4x3f rotateGeneric(float f2, float f3, float f4, float f5, Matrix4x3f matrix4x3f) {
        if (f4 == 0.0f && f5 == 0.0f && Math.absEqualsOne(f3)) {
            return this.rotateX(f3 * f2, matrix4x3f);
        }
        if (f3 == 0.0f && f5 == 0.0f && Math.absEqualsOne(f4)) {
            return this.rotateY(f4 * f2, matrix4x3f);
        }
        if (f3 == 0.0f && f4 == 0.0f && Math.absEqualsOne(f5)) {
            return this.rotateZ(f5 * f2, matrix4x3f);
        }
        return this.rotateGenericInternal(f2, f3, f4, f5, matrix4x3f);
    }

    private Matrix4x3f rotateGenericInternal(float f2, float f3, float f4, float f5, Matrix4x3f matrix4x3f) {
        float f6 = Math.sin(f2);
        float f7 = Math.cosFromSin(f6, f2);
        float f8 = 1.0f - f7;
        float f9 = f3 * f3;
        float f10 = f3 * f4;
        float f11 = f3 * f5;
        float f12 = f4 * f4;
        float f13 = f4 * f5;
        float f14 = f5 * f5;
        float f15 = f9 * f8 + f7;
        float f16 = f10 * f8 + f5 * f6;
        float f17 = f11 * f8 - f4 * f6;
        float f18 = f10 * f8 - f5 * f6;
        float f19 = f12 * f8 + f7;
        float f20 = f13 * f8 + f3 * f6;
        float f21 = f11 * f8 + f4 * f6;
        float f22 = f13 * f8 - f3 * f6;
        float f23 = f14 * f8 + f7;
        float f24 = this.m00 * f15 + this.m10 * f16 + this.m20 * f17;
        float f25 = this.m01 * f15 + this.m11 * f16 + this.m21 * f17;
        float f26 = this.m02 * f15 + this.m12 * f16 + this.m22 * f17;
        float f27 = this.m00 * f18 + this.m10 * f19 + this.m20 * f20;
        float f28 = this.m01 * f18 + this.m11 * f19 + this.m21 * f20;
        float f29 = this.m02 * f18 + this.m12 * f19 + this.m22 * f20;
        matrix4x3f.m20 = this.m00 * f21 + this.m10 * f22 + this.m20 * f23;
        matrix4x3f.m21 = this.m01 * f21 + this.m11 * f22 + this.m21 * f23;
        matrix4x3f.m22 = this.m02 * f21 + this.m12 * f22 + this.m22 * f23;
        matrix4x3f.m00 = f24;
        matrix4x3f.m01 = f25;
        matrix4x3f.m02 = f26;
        matrix4x3f.m10 = f27;
        matrix4x3f.m11 = f28;
        matrix4x3f.m12 = f29;
        matrix4x3f.m30 = this.m30;
        matrix4x3f.m31 = this.m31;
        matrix4x3f.m32 = this.m32;
        matrix4x3f.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3f;
    }

    public Matrix4x3f rotate(float f2, float f3, float f4, float f5) {
        return this.rotate(f2, f3, f4, f5, this);
    }

    public Matrix4x3f rotateTranslation(float f2, float f3, float f4, float f5, Matrix4x3f matrix4x3f) {
        float f6 = this.m30;
        float f7 = this.m31;
        float f8 = this.m32;
        if (f4 == 0.0f && f5 == 0.0f && Math.absEqualsOne(f3)) {
            return matrix4x3f.rotationX(f3 * f2).setTranslation(f6, f7, f8);
        }
        if (f3 == 0.0f && f5 == 0.0f && Math.absEqualsOne(f4)) {
            return matrix4x3f.rotationY(f4 * f2).setTranslation(f6, f7, f8);
        }
        if (f3 == 0.0f && f4 == 0.0f && Math.absEqualsOne(f5)) {
            return matrix4x3f.rotationZ(f5 * f2).setTranslation(f6, f7, f8);
        }
        return this.rotateTranslationInternal(f2, f3, f4, f5, matrix4x3f);
    }

    private Matrix4x3f rotateTranslationInternal(float f2, float f3, float f4, float f5, Matrix4x3f matrix4x3f) {
        float f6 = Math.sin(f2);
        float f7 = Math.cosFromSin(f6, f2);
        float f8 = 1.0f - f7;
        float f9 = f3 * f3;
        float f10 = f3 * f4;
        float f11 = f3 * f5;
        float f12 = f4 * f4;
        float f13 = f4 * f5;
        float f14 = f5 * f5;
        float f15 = f9 * f8 + f7;
        float f16 = f10 * f8 + f5 * f6;
        float f17 = f11 * f8 - f4 * f6;
        float f18 = f10 * f8 - f5 * f6;
        float f19 = f12 * f8 + f7;
        float f20 = f13 * f8 + f3 * f6;
        float f21 = f11 * f8 + f4 * f6;
        float f22 = f13 * f8 - f3 * f6;
        float f23 = f14 * f8 + f7;
        matrix4x3f.m20 = f21;
        matrix4x3f.m21 = f22;
        matrix4x3f.m22 = f23;
        matrix4x3f.m00 = f15;
        matrix4x3f.m01 = f16;
        matrix4x3f.m02 = f17;
        matrix4x3f.m10 = f18;
        matrix4x3f.m11 = f19;
        matrix4x3f.m12 = f20;
        matrix4x3f.m30 = this.m30;
        matrix4x3f.m31 = this.m31;
        matrix4x3f.m32 = this.m32;
        matrix4x3f.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3f;
    }

    public Matrix4x3f rotateAround(Quaternionfc quaternionfc, float f2, float f3, float f4) {
        return this.rotateAround(quaternionfc, f2, f3, f4, this);
    }

    private Matrix4x3f rotateAroundAffine(Quaternionfc quaternionfc, float f2, float f3, float f4, Matrix4x3f matrix4x3f) {
        float f5 = quaternionfc.w() * quaternionfc.w();
        float f6 = quaternionfc.x() * quaternionfc.x();
        float f7 = quaternionfc.y() * quaternionfc.y();
        float f8 = quaternionfc.z() * quaternionfc.z();
        float f9 = quaternionfc.z() * quaternionfc.w();
        float f10 = f9 + f9;
        float f11 = quaternionfc.x() * quaternionfc.y();
        float f12 = f11 + f11;
        float f13 = quaternionfc.x() * quaternionfc.z();
        float f14 = f13 + f13;
        float f15 = quaternionfc.y() * quaternionfc.w();
        float f16 = f15 + f15;
        float f17 = quaternionfc.y() * quaternionfc.z();
        float f18 = f17 + f17;
        float f19 = quaternionfc.x() * quaternionfc.w();
        float f20 = f19 + f19;
        float f21 = f5 + f6 - f8 - f7;
        float f22 = f12 + f10;
        float f23 = f14 - f16;
        float f24 = f12 - f10;
        float f25 = f7 - f8 + f5 - f6;
        float f26 = f18 + f20;
        float f27 = f16 + f14;
        float f28 = f18 - f20;
        float f29 = f8 - f7 - f6 + f5;
        float f30 = this.m00 * f2 + this.m10 * f3 + this.m20 * f4 + this.m30;
        float f31 = this.m01 * f2 + this.m11 * f3 + this.m21 * f4 + this.m31;
        float f32 = this.m02 * f2 + this.m12 * f3 + this.m22 * f4 + this.m32;
        float f33 = this.m00 * f21 + this.m10 * f22 + this.m20 * f23;
        float f34 = this.m01 * f21 + this.m11 * f22 + this.m21 * f23;
        float f35 = this.m02 * f21 + this.m12 * f22 + this.m22 * f23;
        float f36 = this.m00 * f24 + this.m10 * f25 + this.m20 * f26;
        float f37 = this.m01 * f24 + this.m11 * f25 + this.m21 * f26;
        float f38 = this.m02 * f24 + this.m12 * f25 + this.m22 * f26;
        matrix4x3f._m20(this.m00 * f27 + this.m10 * f28 + this.m20 * f29)._m21(this.m01 * f27 + this.m11 * f28 + this.m21 * f29)._m22(this.m02 * f27 + this.m12 * f28 + this.m22 * f29)._m00(f33)._m01(f34)._m02(f35)._m10(f36)._m11(f37)._m12(f38)._m30(-f33 * f2 - f36 * f3 - this.m20 * f4 + f30)._m31(-f34 * f2 - f37 * f3 - this.m21 * f4 + f31)._m32(-f35 * f2 - f38 * f3 - this.m22 * f4 + f32)._properties(this.properties & 0xFFFFFFF3);
        return matrix4x3f;
    }

    public Matrix4x3f rotateAround(Quaternionfc quaternionfc, float f2, float f3, float f4, Matrix4x3f matrix4x3f) {
        if ((this.properties & 4) != 0) {
            return this.rotationAround(quaternionfc, f2, f3, f4);
        }
        return this.rotateAroundAffine(quaternionfc, f2, f3, f4, matrix4x3f);
    }

    public Matrix4x3f rotationAround(Quaternionfc quaternionfc, float f2, float f3, float f4) {
        float f5 = quaternionfc.w() * quaternionfc.w();
        float f6 = quaternionfc.x() * quaternionfc.x();
        float f7 = quaternionfc.y() * quaternionfc.y();
        float f8 = quaternionfc.z() * quaternionfc.z();
        float f9 = quaternionfc.z() * quaternionfc.w();
        float f10 = f9 + f9;
        float f11 = quaternionfc.x() * quaternionfc.y();
        float f12 = f11 + f11;
        float f13 = quaternionfc.x() * quaternionfc.z();
        float f14 = f13 + f13;
        float f15 = quaternionfc.y() * quaternionfc.w();
        float f16 = f15 + f15;
        float f17 = quaternionfc.y() * quaternionfc.z();
        float f18 = f17 + f17;
        float f19 = quaternionfc.x() * quaternionfc.w();
        float f20 = f19 + f19;
        this._m20(f16 + f14);
        this._m21(f18 - f20);
        this._m22(f8 - f7 - f6 + f5);
        this._m00(f5 + f6 - f8 - f7);
        this._m01(f12 + f10);
        this._m02(f14 - f16);
        this._m10(f12 - f10);
        this._m11(f7 - f8 + f5 - f6);
        this._m12(f18 + f20);
        this._m30(-this.m00 * f2 - this.m10 * f3 - this.m20 * f4 + f2);
        this._m31(-this.m01 * f2 - this.m11 * f3 - this.m21 * f4 + f3);
        this._m32(-this.m02 * f2 - this.m12 * f3 - this.m22 * f4 + f4);
        this.properties = 16;
        return this;
    }

    public Matrix4x3f rotateLocal(float f2, float f3, float f4, float f5, Matrix4x3f matrix4x3f) {
        if (f4 == 0.0f && f5 == 0.0f && Math.absEqualsOne(f3)) {
            return this.rotateLocalX(f3 * f2, matrix4x3f);
        }
        if (f3 == 0.0f && f5 == 0.0f && Math.absEqualsOne(f4)) {
            return this.rotateLocalY(f4 * f2, matrix4x3f);
        }
        if (f3 == 0.0f && f4 == 0.0f && Math.absEqualsOne(f5)) {
            return this.rotateLocalZ(f5 * f2, matrix4x3f);
        }
        return this.rotateLocalInternal(f2, f3, f4, f5, matrix4x3f);
    }

    private Matrix4x3f rotateLocalInternal(float f2, float f3, float f4, float f5, Matrix4x3f matrix4x3f) {
        float f6 = Math.sin(f2);
        float f7 = Math.cosFromSin(f6, f2);
        float f8 = 1.0f - f7;
        float f9 = f3 * f3;
        float f10 = f3 * f4;
        float f11 = f3 * f5;
        float f12 = f4 * f4;
        float f13 = f4 * f5;
        float f14 = f5 * f5;
        float f15 = f9 * f8 + f7;
        float f16 = f10 * f8 + f5 * f6;
        float f17 = f11 * f8 - f4 * f6;
        float f18 = f10 * f8 - f5 * f6;
        float f19 = f12 * f8 + f7;
        float f20 = f13 * f8 + f3 * f6;
        float f21 = f11 * f8 + f4 * f6;
        float f22 = f13 * f8 - f3 * f6;
        float f23 = f14 * f8 + f7;
        float f24 = f15 * this.m00 + f18 * this.m01 + f21 * this.m02;
        float f25 = f16 * this.m00 + f19 * this.m01 + f22 * this.m02;
        float f26 = f17 * this.m00 + f20 * this.m01 + f23 * this.m02;
        float f27 = f15 * this.m10 + f18 * this.m11 + f21 * this.m12;
        float f28 = f16 * this.m10 + f19 * this.m11 + f22 * this.m12;
        float f29 = f17 * this.m10 + f20 * this.m11 + f23 * this.m12;
        float f30 = f15 * this.m20 + f18 * this.m21 + f21 * this.m22;
        float f31 = f16 * this.m20 + f19 * this.m21 + f22 * this.m22;
        float f32 = f17 * this.m20 + f20 * this.m21 + f23 * this.m22;
        float f33 = f15 * this.m30 + f18 * this.m31 + f21 * this.m32;
        float f34 = f16 * this.m30 + f19 * this.m31 + f22 * this.m32;
        float f35 = f17 * this.m30 + f20 * this.m31 + f23 * this.m32;
        matrix4x3f.m00 = f24;
        matrix4x3f.m01 = f25;
        matrix4x3f.m02 = f26;
        matrix4x3f.m10 = f27;
        matrix4x3f.m11 = f28;
        matrix4x3f.m12 = f29;
        matrix4x3f.m20 = f30;
        matrix4x3f.m21 = f31;
        matrix4x3f.m22 = f32;
        matrix4x3f.m30 = f33;
        matrix4x3f.m31 = f34;
        matrix4x3f.m32 = f35;
        matrix4x3f.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3f;
    }

    public Matrix4x3f rotateLocal(float f2, float f3, float f4, float f5) {
        return this.rotateLocal(f2, f3, f4, f5, this);
    }

    public Matrix4x3f rotateLocalX(float f2, Matrix4x3f matrix4x3f) {
        float f3 = Math.sin(f2);
        float f4 = Math.cosFromSin(f3, f2);
        float f5 = f4 * this.m01 - f3 * this.m02;
        float f6 = f3 * this.m01 + f4 * this.m02;
        float f7 = f4 * this.m11 - f3 * this.m12;
        float f8 = f3 * this.m11 + f4 * this.m12;
        float f9 = f4 * this.m21 - f3 * this.m22;
        float f10 = f3 * this.m21 + f4 * this.m22;
        float f11 = f4 * this.m31 - f3 * this.m32;
        float f12 = f3 * this.m31 + f4 * this.m32;
        matrix4x3f._m00(this.m00)._m01(f5)._m02(f6)._m10(this.m10)._m11(f7)._m12(f8)._m20(this.m20)._m21(f9)._m22(f10)._m30(this.m30)._m31(f11)._m32(f12)._properties(this.properties & 0xFFFFFFF3);
        return matrix4x3f;
    }

    public Matrix4x3f rotateLocalX(float f2) {
        return this.rotateLocalX(f2, this);
    }

    public Matrix4x3f rotateLocalY(float f2, Matrix4x3f matrix4x3f) {
        float f3 = Math.sin(f2);
        float f4 = Math.cosFromSin(f3, f2);
        float f5 = f4 * this.m00 + f3 * this.m02;
        float f6 = -f3 * this.m00 + f4 * this.m02;
        float f7 = f4 * this.m10 + f3 * this.m12;
        float f8 = -f3 * this.m10 + f4 * this.m12;
        float f9 = f4 * this.m20 + f3 * this.m22;
        float f10 = -f3 * this.m20 + f4 * this.m22;
        float f11 = f4 * this.m30 + f3 * this.m32;
        float f12 = -f3 * this.m30 + f4 * this.m32;
        matrix4x3f._m00(f5)._m01(this.m01)._m02(f6)._m10(f7)._m11(this.m11)._m12(f8)._m20(f9)._m21(this.m21)._m22(f10)._m30(f11)._m31(this.m31)._m32(f12)._properties(this.properties & 0xFFFFFFF3);
        return matrix4x3f;
    }

    public Matrix4x3f rotateLocalY(float f2) {
        return this.rotateLocalY(f2, this);
    }

    public Matrix4x3f rotateLocalZ(float f2, Matrix4x3f matrix4x3f) {
        float f3 = Math.sin(f2);
        float f4 = Math.cosFromSin(f3, f2);
        float f5 = f4 * this.m00 - f3 * this.m01;
        float f6 = f3 * this.m00 + f4 * this.m01;
        float f7 = f4 * this.m10 - f3 * this.m11;
        float f8 = f3 * this.m10 + f4 * this.m11;
        float f9 = f4 * this.m20 - f3 * this.m21;
        float f10 = f3 * this.m20 + f4 * this.m21;
        float f11 = f4 * this.m30 - f3 * this.m31;
        float f12 = f3 * this.m30 + f4 * this.m31;
        matrix4x3f._m00(f5)._m01(f6)._m02(this.m02)._m10(f7)._m11(f8)._m12(this.m12)._m20(f9)._m21(f10)._m22(this.m22)._m30(f11)._m31(f12)._m32(this.m32)._properties(this.properties & 0xFFFFFFF3);
        return matrix4x3f;
    }

    public Matrix4x3f rotateLocalZ(float f2) {
        return this.rotateLocalZ(f2, this);
    }

    public Matrix4x3f translate(Vector3fc vector3fc) {
        return this.translate(vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Matrix4x3f translate(Vector3fc vector3fc, Matrix4x3f matrix4x3f) {
        return this.translate(vector3fc.x(), vector3fc.y(), vector3fc.z(), matrix4x3f);
    }

    public Matrix4x3f translate(float f2, float f3, float f4, Matrix4x3f matrix4x3f) {
        if ((this.properties & 4) != 0) {
            return matrix4x3f.translation(f2, f3, f4);
        }
        return this.translateGeneric(f2, f3, f4, matrix4x3f);
    }

    private Matrix4x3f translateGeneric(float f2, float f3, float f4, Matrix4x3f matrix4x3f) {
        MemUtil.INSTANCE.copy(this, matrix4x3f);
        matrix4x3f.m30 = this.m00 * f2 + this.m10 * f3 + this.m20 * f4 + this.m30;
        matrix4x3f.m31 = this.m01 * f2 + this.m11 * f3 + this.m21 * f4 + this.m31;
        matrix4x3f.m32 = this.m02 * f2 + this.m12 * f3 + this.m22 * f4 + this.m32;
        matrix4x3f.properties = this.properties & 0xFFFFFFFB;
        return matrix4x3f;
    }

    public Matrix4x3f translate(float f2, float f3, float f4) {
        if ((this.properties & 4) != 0) {
            return this.translation(f2, f3, f4);
        }
        Matrix4x3f matrix4x3f = this;
        matrix4x3f.m30 = matrix4x3f.m00 * f2 + matrix4x3f.m10 * f3 + matrix4x3f.m20 * f4 + matrix4x3f.m30;
        matrix4x3f.m31 = matrix4x3f.m01 * f2 + matrix4x3f.m11 * f3 + matrix4x3f.m21 * f4 + matrix4x3f.m31;
        matrix4x3f.m32 = matrix4x3f.m02 * f2 + matrix4x3f.m12 * f3 + matrix4x3f.m22 * f4 + matrix4x3f.m32;
        matrix4x3f.properties &= 0xFFFFFFFB;
        return this;
    }

    public Matrix4x3f translateLocal(Vector3fc vector3fc) {
        return this.translateLocal(vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Matrix4x3f translateLocal(Vector3fc vector3fc, Matrix4x3f matrix4x3f) {
        return this.translateLocal(vector3fc.x(), vector3fc.y(), vector3fc.z(), matrix4x3f);
    }

    public Matrix4x3f translateLocal(float f2, float f3, float f4, Matrix4x3f matrix4x3f) {
        matrix4x3f.m00 = this.m00;
        matrix4x3f.m01 = this.m01;
        matrix4x3f.m02 = this.m02;
        matrix4x3f.m10 = this.m10;
        matrix4x3f.m11 = this.m11;
        matrix4x3f.m12 = this.m12;
        matrix4x3f.m20 = this.m20;
        matrix4x3f.m21 = this.m21;
        matrix4x3f.m22 = this.m22;
        matrix4x3f.m30 = this.m30 + f2;
        matrix4x3f.m31 = this.m31 + f3;
        matrix4x3f.m32 = this.m32 + f4;
        matrix4x3f.properties = this.properties & 0xFFFFFFFB;
        return matrix4x3f;
    }

    public Matrix4x3f translateLocal(float f2, float f3, float f4) {
        return this.translateLocal(f2, f3, f4, this);
    }

    public void writeExternal(ObjectOutput objectOutput) {
        objectOutput.writeFloat(this.m00);
        objectOutput.writeFloat(this.m01);
        objectOutput.writeFloat(this.m02);
        objectOutput.writeFloat(this.m10);
        objectOutput.writeFloat(this.m11);
        objectOutput.writeFloat(this.m12);
        objectOutput.writeFloat(this.m20);
        objectOutput.writeFloat(this.m21);
        objectOutput.writeFloat(this.m22);
        objectOutput.writeFloat(this.m30);
        objectOutput.writeFloat(this.m31);
        objectOutput.writeFloat(this.m32);
    }

    public void readExternal(ObjectInput objectInput) {
        this.m00 = objectInput.readFloat();
        this.m01 = objectInput.readFloat();
        this.m02 = objectInput.readFloat();
        this.m10 = objectInput.readFloat();
        this.m11 = objectInput.readFloat();
        this.m12 = objectInput.readFloat();
        this.m20 = objectInput.readFloat();
        this.m21 = objectInput.readFloat();
        this.m22 = objectInput.readFloat();
        this.m30 = objectInput.readFloat();
        this.m31 = objectInput.readFloat();
        this.m32 = objectInput.readFloat();
        this.determineProperties();
    }

    public Matrix4x3f ortho(float f2, float f3, float f4, float f5, float f6, float f7, boolean bl2, Matrix4x3f matrix4x3f) {
        float f8 = 2.0f / (f3 - f2);
        float f9 = 2.0f / (f5 - f4);
        float f10 = (bl2 ? 1.0f : 2.0f) / (f6 - f7);
        float f11 = (f2 + f3) / (f2 - f3);
        float f12 = (f5 + f4) / (f4 - f5);
        float f13 = (bl2 ? f6 : f7 + f6) / (f6 - f7);
        matrix4x3f.m30 = this.m00 * f11 + this.m10 * f12 + this.m20 * f13 + this.m30;
        matrix4x3f.m31 = this.m01 * f11 + this.m11 * f12 + this.m21 * f13 + this.m31;
        matrix4x3f.m32 = this.m02 * f11 + this.m12 * f12 + this.m22 * f13 + this.m32;
        matrix4x3f.m00 = this.m00 * f8;
        matrix4x3f.m01 = this.m01 * f8;
        matrix4x3f.m02 = this.m02 * f8;
        matrix4x3f.m10 = this.m10 * f9;
        matrix4x3f.m11 = this.m11 * f9;
        matrix4x3f.m12 = this.m12 * f9;
        matrix4x3f.m20 = this.m20 * f10;
        matrix4x3f.m21 = this.m21 * f10;
        matrix4x3f.m22 = this.m22 * f10;
        matrix4x3f.properties = this.properties & 0xFFFFFFE3;
        return matrix4x3f;
    }

    public Matrix4x3f ortho(float f2, float f3, float f4, float f5, float f6, float f7, Matrix4x3f matrix4x3f) {
        return this.ortho(f2, f3, f4, f5, f6, f7, false, matrix4x3f);
    }

    public Matrix4x3f ortho(float f2, float f3, float f4, float f5, float f6, float f7, boolean bl2) {
        return this.ortho(f2, f3, f4, f5, f6, f7, bl2, this);
    }

    public Matrix4x3f ortho(float f2, float f3, float f4, float f5, float f6, float f7) {
        return this.ortho(f2, f3, f4, f5, f6, f7, false);
    }

    public Matrix4x3f orthoLH(float f2, float f3, float f4, float f5, float f6, float f7, boolean bl2, Matrix4x3f matrix4x3f) {
        float f8 = 2.0f / (f3 - f2);
        float f9 = 2.0f / (f5 - f4);
        float f10 = (bl2 ? 1.0f : 2.0f) / (f7 - f6);
        float f11 = (f2 + f3) / (f2 - f3);
        float f12 = (f5 + f4) / (f4 - f5);
        float f13 = (bl2 ? f6 : f7 + f6) / (f6 - f7);
        matrix4x3f.m30 = this.m00 * f11 + this.m10 * f12 + this.m20 * f13 + this.m30;
        matrix4x3f.m31 = this.m01 * f11 + this.m11 * f12 + this.m21 * f13 + this.m31;
        matrix4x3f.m32 = this.m02 * f11 + this.m12 * f12 + this.m22 * f13 + this.m32;
        matrix4x3f.m00 = this.m00 * f8;
        matrix4x3f.m01 = this.m01 * f8;
        matrix4x3f.m02 = this.m02 * f8;
        matrix4x3f.m10 = this.m10 * f9;
        matrix4x3f.m11 = this.m11 * f9;
        matrix4x3f.m12 = this.m12 * f9;
        matrix4x3f.m20 = this.m20 * f10;
        matrix4x3f.m21 = this.m21 * f10;
        matrix4x3f.m22 = this.m22 * f10;
        matrix4x3f.properties = this.properties & 0xFFFFFFE3;
        return matrix4x3f;
    }

    public Matrix4x3f orthoLH(float f2, float f3, float f4, float f5, float f6, float f7, Matrix4x3f matrix4x3f) {
        return this.orthoLH(f2, f3, f4, f5, f6, f7, false, matrix4x3f);
    }

    public Matrix4x3f orthoLH(float f2, float f3, float f4, float f5, float f6, float f7, boolean bl2) {
        return this.orthoLH(f2, f3, f4, f5, f6, f7, bl2, this);
    }

    public Matrix4x3f orthoLH(float f2, float f3, float f4, float f5, float f6, float f7) {
        return this.orthoLH(f2, f3, f4, f5, f6, f7, false);
    }

    public Matrix4x3f setOrtho(float f2, float f3, float f4, float f5, float f6, float f7, boolean bl2) {
        MemUtil.INSTANCE.identity(this);
        this.m00 = 2.0f / (f3 - f2);
        this.m11 = 2.0f / (f5 - f4);
        this.m22 = (bl2 ? 1.0f : 2.0f) / (f6 - f7);
        this.m30 = (f3 + f2) / (f2 - f3);
        this.m31 = (f5 + f4) / (f4 - f5);
        this.m32 = (bl2 ? f6 : f7 + f6) / (f6 - f7);
        this.properties = 0;
        return this;
    }

    public Matrix4x3f setOrtho(float f2, float f3, float f4, float f5, float f6, float f7) {
        return this.setOrtho(f2, f3, f4, f5, f6, f7, false);
    }

    public Matrix4x3f setOrthoLH(float f2, float f3, float f4, float f5, float f6, float f7, boolean bl2) {
        MemUtil.INSTANCE.identity(this);
        this.m00 = 2.0f / (f3 - f2);
        this.m11 = 2.0f / (f5 - f4);
        this.m22 = (bl2 ? 1.0f : 2.0f) / (f7 - f6);
        this.m30 = (f3 + f2) / (f2 - f3);
        this.m31 = (f5 + f4) / (f4 - f5);
        this.m32 = (bl2 ? f6 : f7 + f6) / (f6 - f7);
        this.properties = 0;
        return this;
    }

    public Matrix4x3f setOrthoLH(float f2, float f3, float f4, float f5, float f6, float f7) {
        return this.setOrthoLH(f2, f3, f4, f5, f6, f7, false);
    }

    public Matrix4x3f orthoSymmetric(float f2, float f3, float f4, float f5, boolean bl2, Matrix4x3f matrix4x3f) {
        float f6 = 2.0f / f2;
        float f7 = 2.0f / f3;
        float f8 = (bl2 ? 1.0f : 2.0f) / (f4 - f5);
        float f9 = (bl2 ? f4 : f5 + f4) / (f4 - f5);
        matrix4x3f.m30 = this.m20 * f9 + this.m30;
        matrix4x3f.m31 = this.m21 * f9 + this.m31;
        matrix4x3f.m32 = this.m22 * f9 + this.m32;
        matrix4x3f.m00 = this.m00 * f6;
        matrix4x3f.m01 = this.m01 * f6;
        matrix4x3f.m02 = this.m02 * f6;
        matrix4x3f.m10 = this.m10 * f7;
        matrix4x3f.m11 = this.m11 * f7;
        matrix4x3f.m12 = this.m12 * f7;
        matrix4x3f.m20 = this.m20 * f8;
        matrix4x3f.m21 = this.m21 * f8;
        matrix4x3f.m22 = this.m22 * f8;
        matrix4x3f.properties = this.properties & 0xFFFFFFE3;
        return matrix4x3f;
    }

    public Matrix4x3f orthoSymmetric(float f2, float f3, float f4, float f5, Matrix4x3f matrix4x3f) {
        return this.orthoSymmetric(f2, f3, f4, f5, false, matrix4x3f);
    }

    public Matrix4x3f orthoSymmetric(float f2, float f3, float f4, float f5, boolean bl2) {
        return this.orthoSymmetric(f2, f3, f4, f5, bl2, this);
    }

    public Matrix4x3f orthoSymmetric(float f2, float f3, float f4, float f5) {
        return this.orthoSymmetric(f2, f3, f4, f5, false, this);
    }

    public Matrix4x3f orthoSymmetricLH(float f2, float f3, float f4, float f5, boolean bl2, Matrix4x3f matrix4x3f) {
        float f6 = 2.0f / f2;
        float f7 = 2.0f / f3;
        float f8 = (bl2 ? 1.0f : 2.0f) / (f5 - f4);
        float f9 = (bl2 ? f4 : f5 + f4) / (f4 - f5);
        matrix4x3f.m30 = this.m20 * f9 + this.m30;
        matrix4x3f.m31 = this.m21 * f9 + this.m31;
        matrix4x3f.m32 = this.m22 * f9 + this.m32;
        matrix4x3f.m00 = this.m00 * f6;
        matrix4x3f.m01 = this.m01 * f6;
        matrix4x3f.m02 = this.m02 * f6;
        matrix4x3f.m10 = this.m10 * f7;
        matrix4x3f.m11 = this.m11 * f7;
        matrix4x3f.m12 = this.m12 * f7;
        matrix4x3f.m20 = this.m20 * f8;
        matrix4x3f.m21 = this.m21 * f8;
        matrix4x3f.m22 = this.m22 * f8;
        matrix4x3f.properties = this.properties & 0xFFFFFFE3;
        return matrix4x3f;
    }

    public Matrix4x3f orthoSymmetricLH(float f2, float f3, float f4, float f5, Matrix4x3f matrix4x3f) {
        return this.orthoSymmetricLH(f2, f3, f4, f5, false, matrix4x3f);
    }

    public Matrix4x3f orthoSymmetricLH(float f2, float f3, float f4, float f5, boolean bl2) {
        return this.orthoSymmetricLH(f2, f3, f4, f5, bl2, this);
    }

    public Matrix4x3f orthoSymmetricLH(float f2, float f3, float f4, float f5) {
        return this.orthoSymmetricLH(f2, f3, f4, f5, false, this);
    }

    public Matrix4x3f setOrthoSymmetric(float f2, float f3, float f4, float f5, boolean bl2) {
        MemUtil.INSTANCE.identity(this);
        this.m00 = 2.0f / f2;
        this.m11 = 2.0f / f3;
        this.m22 = (bl2 ? 1.0f : 2.0f) / (f4 - f5);
        this.m32 = (bl2 ? f4 : f5 + f4) / (f4 - f5);
        this.properties = 0;
        return this;
    }

    public Matrix4x3f setOrthoSymmetric(float f2, float f3, float f4, float f5) {
        return this.setOrthoSymmetric(f2, f3, f4, f5, false);
    }

    public Matrix4x3f setOrthoSymmetricLH(float f2, float f3, float f4, float f5, boolean bl2) {
        MemUtil.INSTANCE.identity(this);
        this.m00 = 2.0f / f2;
        this.m11 = 2.0f / f3;
        this.m22 = (bl2 ? 1.0f : 2.0f) / (f5 - f4);
        this.m32 = (bl2 ? f4 : f5 + f4) / (f4 - f5);
        this.properties = 0;
        return this;
    }

    public Matrix4x3f setOrthoSymmetricLH(float f2, float f3, float f4, float f5) {
        return this.setOrthoSymmetricLH(f2, f3, f4, f5, false);
    }

    public Matrix4x3f ortho2D(float f2, float f3, float f4, float f5, Matrix4x3f matrix4x3f) {
        float f6 = 2.0f / (f3 - f2);
        float f7 = 2.0f / (f5 - f4);
        float f8 = -(f3 + f2) / (f3 - f2);
        float f9 = -(f5 + f4) / (f5 - f4);
        matrix4x3f.m30 = this.m00 * f8 + this.m10 * f9 + this.m30;
        matrix4x3f.m31 = this.m01 * f8 + this.m11 * f9 + this.m31;
        matrix4x3f.m32 = this.m02 * f8 + this.m12 * f9 + this.m32;
        matrix4x3f.m00 = this.m00 * f6;
        matrix4x3f.m01 = this.m01 * f6;
        matrix4x3f.m02 = this.m02 * f6;
        matrix4x3f.m10 = this.m10 * f7;
        matrix4x3f.m11 = this.m11 * f7;
        matrix4x3f.m12 = this.m12 * f7;
        matrix4x3f.m20 = -this.m20;
        matrix4x3f.m21 = -this.m21;
        matrix4x3f.m22 = -this.m22;
        matrix4x3f.properties = this.properties & 0xFFFFFFE3;
        return matrix4x3f;
    }

    public Matrix4x3f ortho2D(float f2, float f3, float f4, float f5) {
        return this.ortho2D(f2, f3, f4, f5, this);
    }

    public Matrix4x3f ortho2DLH(float f2, float f3, float f4, float f5, Matrix4x3f matrix4x3f) {
        float f6 = 2.0f / (f3 - f2);
        float f7 = 2.0f / (f5 - f4);
        float f8 = -(f3 + f2) / (f3 - f2);
        float f9 = -(f5 + f4) / (f5 - f4);
        matrix4x3f.m30 = this.m00 * f8 + this.m10 * f9 + this.m30;
        matrix4x3f.m31 = this.m01 * f8 + this.m11 * f9 + this.m31;
        matrix4x3f.m32 = this.m02 * f8 + this.m12 * f9 + this.m32;
        matrix4x3f.m00 = this.m00 * f6;
        matrix4x3f.m01 = this.m01 * f6;
        matrix4x3f.m02 = this.m02 * f6;
        matrix4x3f.m10 = this.m10 * f7;
        matrix4x3f.m11 = this.m11 * f7;
        matrix4x3f.m12 = this.m12 * f7;
        matrix4x3f.m20 = this.m20;
        matrix4x3f.m21 = this.m21;
        matrix4x3f.m22 = this.m22;
        matrix4x3f.properties = this.properties & 0xFFFFFFE3;
        return matrix4x3f;
    }

    public Matrix4x3f ortho2DLH(float f2, float f3, float f4, float f5) {
        return this.ortho2DLH(f2, f3, f4, f5, this);
    }

    public Matrix4x3f setOrtho2D(float f2, float f3, float f4, float f5) {
        MemUtil.INSTANCE.identity(this);
        this.m00 = 2.0f / (f3 - f2);
        this.m11 = 2.0f / (f5 - f4);
        this.m22 = -1.0f;
        this.m30 = -(f3 + f2) / (f3 - f2);
        this.m31 = -(f5 + f4) / (f5 - f4);
        this.properties = 0;
        return this;
    }

    public Matrix4x3f setOrtho2DLH(float f2, float f3, float f4, float f5) {
        MemUtil.INSTANCE.identity(this);
        this.m00 = 2.0f / (f3 - f2);
        this.m11 = 2.0f / (f5 - f4);
        this.m22 = 1.0f;
        this.m30 = -(f3 + f2) / (f3 - f2);
        this.m31 = -(f5 + f4) / (f5 - f4);
        this.properties = 0;
        return this;
    }

    public Matrix4x3f lookAlong(Vector3fc vector3fc, Vector3fc vector3fc2) {
        return this.lookAlong(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), this);
    }

    public Matrix4x3f lookAlong(Vector3fc vector3fc, Vector3fc vector3fc2, Matrix4x3f matrix4x3f) {
        return this.lookAlong(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), matrix4x3f);
    }

    public Matrix4x3f lookAlong(float f2, float f3, float f4, float f5, float f6, float f7, Matrix4x3f matrix4x3f) {
        if ((this.properties & 4) != 0) {
            return this.setLookAlong(f2, f3, f4, f5, f6, f7);
        }
        float f8 = Math.invsqrt(f2 * f2 + f3 * f3 + f4 * f4);
        float f9 = f6 * (f4 *= -f8) - f7 * (f3 *= -f8);
        float f10 = f7 * (f2 *= -f8) - f5 * f4;
        float f11 = f5 * f3 - f6 * f2;
        float f12 = Math.invsqrt(f9 * f9 + f10 * f10 + f11 * f11);
        float f13 = f3 * (f11 *= f12) - f4 * (f10 *= f12);
        float f14 = f4 * (f9 *= f12) - f2 * f11;
        float f15 = f2 * f10 - f3 * f9;
        float f16 = f9;
        float f17 = f13;
        float f18 = f2;
        float f19 = f10;
        float f20 = f14;
        float f21 = f3;
        float f22 = f11;
        float f23 = f15;
        float f24 = f4;
        float f25 = this.m00 * f16 + this.m10 * f17 + this.m20 * f18;
        float f26 = this.m01 * f16 + this.m11 * f17 + this.m21 * f18;
        float f27 = this.m02 * f16 + this.m12 * f17 + this.m22 * f18;
        float f28 = this.m00 * f19 + this.m10 * f20 + this.m20 * f21;
        float f29 = this.m01 * f19 + this.m11 * f20 + this.m21 * f21;
        float f30 = this.m02 * f19 + this.m12 * f20 + this.m22 * f21;
        matrix4x3f.m20 = this.m00 * f22 + this.m10 * f23 + this.m20 * f24;
        matrix4x3f.m21 = this.m01 * f22 + this.m11 * f23 + this.m21 * f24;
        matrix4x3f.m22 = this.m02 * f22 + this.m12 * f23 + this.m22 * f24;
        matrix4x3f.m00 = f25;
        matrix4x3f.m01 = f26;
        matrix4x3f.m02 = f27;
        matrix4x3f.m10 = f28;
        matrix4x3f.m11 = f29;
        matrix4x3f.m12 = f30;
        matrix4x3f.m30 = this.m30;
        matrix4x3f.m31 = this.m31;
        matrix4x3f.m32 = this.m32;
        matrix4x3f.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3f;
    }

    public Matrix4x3f lookAlong(float f2, float f3, float f4, float f5, float f6, float f7) {
        return this.lookAlong(f2, f3, f4, f5, f6, f7, this);
    }

    public Matrix4x3f setLookAlong(Vector3fc vector3fc, Vector3fc vector3fc2) {
        return this.setLookAlong(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z());
    }

    public Matrix4x3f setLookAlong(float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8 = Math.invsqrt(f2 * f2 + f3 * f3 + f4 * f4);
        float f9 = f6 * (f4 *= -f8) - f7 * (f3 *= -f8);
        float f10 = f7 * (f2 *= -f8) - f5 * f4;
        float f11 = f5 * f3 - f6 * f2;
        float f12 = Math.invsqrt(f9 * f9 + f10 * f10 + f11 * f11);
        float f13 = f3 * (f11 *= f12) - f4 * (f10 *= f12);
        float f14 = f4 * (f9 *= f12) - f2 * f11;
        float f15 = f2 * f10 - f3 * f9;
        this.m00 = f9;
        this.m01 = f13;
        this.m02 = f2;
        this.m10 = f10;
        this.m11 = f14;
        this.m12 = f3;
        this.m20 = f11;
        this.m21 = f15;
        this.m22 = f4;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.properties = 16;
        return this;
    }

    public Matrix4x3f setLookAt(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3) {
        return this.setLookAt(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), vector3fc3.x(), vector3fc3.y(), vector3fc3.z());
    }

    public Matrix4x3f setLookAt(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        float f11 = f2 - f5;
        float f12 = f3 - f6;
        float f13 = f4 - f7;
        float f14 = Math.invsqrt(f11 * f11 + f12 * f12 + f13 * f13);
        float f15 = f9 * (f13 *= f14) - f10 * (f12 *= f14);
        float f16 = f10 * (f11 *= f14) - f8 * f13;
        float f17 = f8 * f12 - f9 * f11;
        float f18 = Math.invsqrt(f15 * f15 + f16 * f16 + f17 * f17);
        float f19 = f12 * (f17 *= f18) - f13 * (f16 *= f18);
        float f20 = f13 * (f15 *= f18) - f11 * f17;
        float f21 = f11 * f16 - f12 * f15;
        this.m00 = f15;
        this.m01 = f19;
        this.m02 = f11;
        this.m10 = f16;
        this.m11 = f20;
        this.m12 = f12;
        this.m20 = f17;
        this.m21 = f21;
        this.m22 = f13;
        this.m30 = -(f15 * f2 + f16 * f3 + f17 * f4);
        this.m31 = -(f19 * f2 + f20 * f3 + f21 * f4);
        this.m32 = -(f11 * f2 + f12 * f3 + f13 * f4);
        this.properties = 16;
        return this;
    }

    public Matrix4x3f lookAt(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3, Matrix4x3f matrix4x3f) {
        return this.lookAt(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), vector3fc3.x(), vector3fc3.y(), vector3fc3.z(), matrix4x3f);
    }

    public Matrix4x3f lookAt(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3) {
        return this.lookAt(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), vector3fc3.x(), vector3fc3.y(), vector3fc3.z(), this);
    }

    public Matrix4x3f lookAt(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, Matrix4x3f matrix4x3f) {
        if ((this.properties & 4) != 0) {
            return matrix4x3f.setLookAt(f2, f3, f4, f5, f6, f7, f8, f9, f10);
        }
        return this.lookAtGeneric(f2, f3, f4, f5, f6, f7, f8, f9, f10, matrix4x3f);
    }

    private Matrix4x3f lookAtGeneric(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, Matrix4x3f matrix4x3f) {
        float f11 = f2 - f5;
        float f12 = f3 - f6;
        float f13 = f4 - f7;
        float f14 = Math.invsqrt(f11 * f11 + f12 * f12 + f13 * f13);
        float f15 = f9 * (f13 *= f14) - f10 * (f12 *= f14);
        float f16 = f10 * (f11 *= f14) - f8 * f13;
        float f17 = f8 * f12 - f9 * f11;
        float f18 = Math.invsqrt(f15 * f15 + f16 * f16 + f17 * f17);
        float f19 = f12 * (f17 *= f18) - f13 * (f16 *= f18);
        float f20 = f13 * (f15 *= f18) - f11 * f17;
        float f21 = f11 * f16 - f12 * f15;
        float f22 = f15;
        float f23 = f19;
        float f24 = f11;
        float f25 = f16;
        float f26 = f20;
        float f27 = f12;
        float f28 = f17;
        float f29 = f21;
        float f30 = f13;
        float f31 = -(f15 * f2 + f16 * f3 + f17 * f4);
        float f32 = -(f19 * f2 + f20 * f3 + f21 * f4);
        float f33 = -(f11 * f2 + f12 * f3 + f13 * f4);
        matrix4x3f.m30 = this.m00 * f31 + this.m10 * f32 + this.m20 * f33 + this.m30;
        matrix4x3f.m31 = this.m01 * f31 + this.m11 * f32 + this.m21 * f33 + this.m31;
        matrix4x3f.m32 = this.m02 * f31 + this.m12 * f32 + this.m22 * f33 + this.m32;
        float f34 = this.m00 * f22 + this.m10 * f23 + this.m20 * f24;
        float f35 = this.m01 * f22 + this.m11 * f23 + this.m21 * f24;
        float f36 = this.m02 * f22 + this.m12 * f23 + this.m22 * f24;
        float f37 = this.m00 * f25 + this.m10 * f26 + this.m20 * f27;
        float f38 = this.m01 * f25 + this.m11 * f26 + this.m21 * f27;
        float f39 = this.m02 * f25 + this.m12 * f26 + this.m22 * f27;
        matrix4x3f.m20 = this.m00 * f28 + this.m10 * f29 + this.m20 * f30;
        matrix4x3f.m21 = this.m01 * f28 + this.m11 * f29 + this.m21 * f30;
        matrix4x3f.m22 = this.m02 * f28 + this.m12 * f29 + this.m22 * f30;
        matrix4x3f.m00 = f34;
        matrix4x3f.m01 = f35;
        matrix4x3f.m02 = f36;
        matrix4x3f.m10 = f37;
        matrix4x3f.m11 = f38;
        matrix4x3f.m12 = f39;
        matrix4x3f.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3f;
    }

    public Matrix4x3f lookAt(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        return this.lookAt(f2, f3, f4, f5, f6, f7, f8, f9, f10, this);
    }

    public Matrix4x3f setLookAtLH(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3) {
        return this.setLookAtLH(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), vector3fc3.x(), vector3fc3.y(), vector3fc3.z());
    }

    public Matrix4x3f setLookAtLH(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        float f11 = f5 - f2;
        float f12 = f6 - f3;
        float f13 = f7 - f4;
        float f14 = Math.invsqrt(f11 * f11 + f12 * f12 + f13 * f13);
        float f15 = f9 * (f13 *= f14) - f10 * (f12 *= f14);
        float f16 = f10 * (f11 *= f14) - f8 * f13;
        float f17 = f8 * f12 - f9 * f11;
        float f18 = Math.invsqrt(f15 * f15 + f16 * f16 + f17 * f17);
        float f19 = f12 * (f17 *= f18) - f13 * (f16 *= f18);
        float f20 = f13 * (f15 *= f18) - f11 * f17;
        float f21 = f11 * f16 - f12 * f15;
        this.m00 = f15;
        this.m01 = f19;
        this.m02 = f11;
        this.m10 = f16;
        this.m11 = f20;
        this.m12 = f12;
        this.m20 = f17;
        this.m21 = f21;
        this.m22 = f13;
        this.m30 = -(f15 * f2 + f16 * f3 + f17 * f4);
        this.m31 = -(f19 * f2 + f20 * f3 + f21 * f4);
        this.m32 = -(f11 * f2 + f12 * f3 + f13 * f4);
        this.properties = 16;
        return this;
    }

    public Matrix4x3f lookAtLH(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3, Matrix4x3f matrix4x3f) {
        return this.lookAtLH(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), vector3fc3.x(), vector3fc3.y(), vector3fc3.z(), matrix4x3f);
    }

    public Matrix4x3f lookAtLH(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3) {
        return this.lookAtLH(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), vector3fc3.x(), vector3fc3.y(), vector3fc3.z(), this);
    }

    public Matrix4x3f lookAtLH(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, Matrix4x3f matrix4x3f) {
        if ((this.properties & 4) != 0) {
            return matrix4x3f.setLookAtLH(f2, f3, f4, f5, f6, f7, f8, f9, f10);
        }
        return this.lookAtLHGeneric(f2, f3, f4, f5, f6, f7, f8, f9, f10, matrix4x3f);
    }

    private Matrix4x3f lookAtLHGeneric(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, Matrix4x3f matrix4x3f) {
        float f11 = f5 - f2;
        float f12 = f6 - f3;
        float f13 = f7 - f4;
        float f14 = Math.invsqrt(f11 * f11 + f12 * f12 + f13 * f13);
        float f15 = f9 * (f13 *= f14) - f10 * (f12 *= f14);
        float f16 = f10 * (f11 *= f14) - f8 * f13;
        float f17 = f8 * f12 - f9 * f11;
        float f18 = Math.invsqrt(f15 * f15 + f16 * f16 + f17 * f17);
        float f19 = f12 * (f17 *= f18) - f13 * (f16 *= f18);
        float f20 = f13 * (f15 *= f18) - f11 * f17;
        float f21 = f11 * f16 - f12 * f15;
        float f22 = f15;
        float f23 = f19;
        float f24 = f11;
        float f25 = f16;
        float f26 = f20;
        float f27 = f12;
        float f28 = f17;
        float f29 = f21;
        float f30 = f13;
        float f31 = -(f15 * f2 + f16 * f3 + f17 * f4);
        float f32 = -(f19 * f2 + f20 * f3 + f21 * f4);
        float f33 = -(f11 * f2 + f12 * f3 + f13 * f4);
        matrix4x3f.m30 = this.m00 * f31 + this.m10 * f32 + this.m20 * f33 + this.m30;
        matrix4x3f.m31 = this.m01 * f31 + this.m11 * f32 + this.m21 * f33 + this.m31;
        matrix4x3f.m32 = this.m02 * f31 + this.m12 * f32 + this.m22 * f33 + this.m32;
        float f34 = this.m00 * f22 + this.m10 * f23 + this.m20 * f24;
        float f35 = this.m01 * f22 + this.m11 * f23 + this.m21 * f24;
        float f36 = this.m02 * f22 + this.m12 * f23 + this.m22 * f24;
        float f37 = this.m00 * f25 + this.m10 * f26 + this.m20 * f27;
        float f38 = this.m01 * f25 + this.m11 * f26 + this.m21 * f27;
        float f39 = this.m02 * f25 + this.m12 * f26 + this.m22 * f27;
        matrix4x3f.m20 = this.m00 * f28 + this.m10 * f29 + this.m20 * f30;
        matrix4x3f.m21 = this.m01 * f28 + this.m11 * f29 + this.m21 * f30;
        matrix4x3f.m22 = this.m02 * f28 + this.m12 * f29 + this.m22 * f30;
        matrix4x3f.m00 = f34;
        matrix4x3f.m01 = f35;
        matrix4x3f.m02 = f36;
        matrix4x3f.m10 = f37;
        matrix4x3f.m11 = f38;
        matrix4x3f.m12 = f39;
        matrix4x3f.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3f;
    }

    public Matrix4x3f lookAtLH(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        return this.lookAtLH(f2, f3, f4, f5, f6, f7, f8, f9, f10, this);
    }

    public Matrix4x3f rotate(Quaternionfc quaternionfc, Matrix4x3f matrix4x3f) {
        if ((this.properties & 4) != 0) {
            return matrix4x3f.rotation(quaternionfc);
        }
        if ((this.properties & 8) != 0) {
            return this.rotateTranslation(quaternionfc, matrix4x3f);
        }
        return this.rotateGeneric(quaternionfc, matrix4x3f);
    }

    private Matrix4x3f rotateGeneric(Quaternionfc quaternionfc, Matrix4x3f matrix4x3f) {
        float f2 = quaternionfc.w() * quaternionfc.w();
        float f3 = quaternionfc.x() * quaternionfc.x();
        float f4 = quaternionfc.y() * quaternionfc.y();
        float f5 = quaternionfc.z() * quaternionfc.z();
        float f6 = quaternionfc.z() * quaternionfc.w();
        float f7 = f6 + f6;
        float f8 = quaternionfc.x() * quaternionfc.y();
        float f9 = f8 + f8;
        float f10 = quaternionfc.x() * quaternionfc.z();
        float f11 = f10 + f10;
        float f12 = quaternionfc.y() * quaternionfc.w();
        float f13 = f12 + f12;
        float f14 = quaternionfc.y() * quaternionfc.z();
        float f15 = f14 + f14;
        float f16 = quaternionfc.x() * quaternionfc.w();
        float f17 = f16 + f16;
        float f18 = f2 + f3 - f5 - f4;
        float f19 = f9 + f7;
        float f20 = f11 - f13;
        float f21 = f9 - f7;
        float f22 = f4 - f5 + f2 - f3;
        float f23 = f15 + f17;
        float f24 = f13 + f11;
        float f25 = f15 - f17;
        float f26 = f5 - f4 - f3 + f2;
        float f27 = this.m00 * f18 + this.m10 * f19 + this.m20 * f20;
        float f28 = this.m01 * f18 + this.m11 * f19 + this.m21 * f20;
        float f29 = this.m02 * f18 + this.m12 * f19 + this.m22 * f20;
        float f30 = this.m00 * f21 + this.m10 * f22 + this.m20 * f23;
        float f31 = this.m01 * f21 + this.m11 * f22 + this.m21 * f23;
        float f32 = this.m02 * f21 + this.m12 * f22 + this.m22 * f23;
        matrix4x3f.m20 = this.m00 * f24 + this.m10 * f25 + this.m20 * f26;
        matrix4x3f.m21 = this.m01 * f24 + this.m11 * f25 + this.m21 * f26;
        matrix4x3f.m22 = this.m02 * f24 + this.m12 * f25 + this.m22 * f26;
        matrix4x3f.m00 = f27;
        matrix4x3f.m01 = f28;
        matrix4x3f.m02 = f29;
        matrix4x3f.m10 = f30;
        matrix4x3f.m11 = f31;
        matrix4x3f.m12 = f32;
        matrix4x3f.m30 = this.m30;
        matrix4x3f.m31 = this.m31;
        matrix4x3f.m32 = this.m32;
        matrix4x3f.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3f;
    }

    public Matrix4x3f rotate(Quaternionfc quaternionfc) {
        return this.rotate(quaternionfc, this);
    }

    public Matrix4x3f rotateTranslation(Quaternionfc quaternionfc, Matrix4x3f matrix4x3f) {
        float f2 = quaternionfc.w() * quaternionfc.w();
        float f3 = quaternionfc.x() * quaternionfc.x();
        float f4 = quaternionfc.y() * quaternionfc.y();
        float f5 = quaternionfc.z() * quaternionfc.z();
        float f6 = quaternionfc.z() * quaternionfc.w();
        float f7 = f6 + f6;
        float f8 = quaternionfc.x() * quaternionfc.y();
        float f9 = f8 + f8;
        float f10 = quaternionfc.x() * quaternionfc.z();
        float f11 = f10 + f10;
        float f12 = quaternionfc.y() * quaternionfc.w();
        float f13 = f12 + f12;
        float f14 = quaternionfc.y() * quaternionfc.z();
        float f15 = f14 + f14;
        float f16 = quaternionfc.x() * quaternionfc.w();
        float f17 = f16 + f16;
        float f18 = f2 + f3 - f5 - f4;
        float f19 = f9 + f7;
        float f20 = f11 - f13;
        float f21 = f9 - f7;
        float f22 = f4 - f5 + f2 - f3;
        float f23 = f15 + f17;
        float f24 = f13 + f11;
        float f25 = f15 - f17;
        float f26 = f5 - f4 - f3 + f2;
        matrix4x3f.m20 = f24;
        matrix4x3f.m21 = f25;
        matrix4x3f.m22 = f26;
        matrix4x3f.m00 = f18;
        matrix4x3f.m01 = f19;
        matrix4x3f.m02 = f20;
        matrix4x3f.m10 = f21;
        matrix4x3f.m11 = f22;
        matrix4x3f.m12 = f23;
        matrix4x3f.m30 = this.m30;
        matrix4x3f.m31 = this.m31;
        matrix4x3f.m32 = this.m32;
        matrix4x3f.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3f;
    }

    public Matrix4x3f rotateLocal(Quaternionfc quaternionfc, Matrix4x3f matrix4x3f) {
        float f2 = quaternionfc.w() * quaternionfc.w();
        float f3 = quaternionfc.x() * quaternionfc.x();
        float f4 = quaternionfc.y() * quaternionfc.y();
        float f5 = quaternionfc.z() * quaternionfc.z();
        float f6 = quaternionfc.z() * quaternionfc.w();
        float f7 = quaternionfc.x() * quaternionfc.y();
        float f8 = quaternionfc.x() * quaternionfc.z();
        float f9 = quaternionfc.y() * quaternionfc.w();
        float f10 = quaternionfc.y() * quaternionfc.z();
        float f11 = quaternionfc.x() * quaternionfc.w();
        float f12 = f2 + f3 - f5 - f4;
        float f13 = f7 + f6 + f6 + f7;
        float f14 = f8 - f9 + f8 - f9;
        float f15 = -f6 + f7 - f6 + f7;
        float f16 = f4 - f5 + f2 - f3;
        float f17 = f10 + f10 + f11 + f11;
        float f18 = f9 + f8 + f8 + f9;
        float f19 = f10 + f10 - f11 - f11;
        float f20 = f5 - f4 - f3 + f2;
        float f21 = f12 * this.m00 + f15 * this.m01 + f18 * this.m02;
        float f22 = f13 * this.m00 + f16 * this.m01 + f19 * this.m02;
        float f23 = f14 * this.m00 + f17 * this.m01 + f20 * this.m02;
        float f24 = f12 * this.m10 + f15 * this.m11 + f18 * this.m12;
        float f25 = f13 * this.m10 + f16 * this.m11 + f19 * this.m12;
        float f26 = f14 * this.m10 + f17 * this.m11 + f20 * this.m12;
        float f27 = f12 * this.m20 + f15 * this.m21 + f18 * this.m22;
        float f28 = f13 * this.m20 + f16 * this.m21 + f19 * this.m22;
        float f29 = f14 * this.m20 + f17 * this.m21 + f20 * this.m22;
        float f30 = f12 * this.m30 + f15 * this.m31 + f18 * this.m32;
        float f31 = f13 * this.m30 + f16 * this.m31 + f19 * this.m32;
        float f32 = f14 * this.m30 + f17 * this.m31 + f20 * this.m32;
        matrix4x3f.m00 = f21;
        matrix4x3f.m01 = f22;
        matrix4x3f.m02 = f23;
        matrix4x3f.m10 = f24;
        matrix4x3f.m11 = f25;
        matrix4x3f.m12 = f26;
        matrix4x3f.m20 = f27;
        matrix4x3f.m21 = f28;
        matrix4x3f.m22 = f29;
        matrix4x3f.m30 = f30;
        matrix4x3f.m31 = f31;
        matrix4x3f.m32 = f32;
        matrix4x3f.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3f;
    }

    public Matrix4x3f rotateLocal(Quaternionfc quaternionfc) {
        return this.rotateLocal(quaternionfc, this);
    }

    public Matrix4x3f rotate(AxisAngle4f axisAngle4f) {
        return this.rotate(axisAngle4f.angle, axisAngle4f.x, axisAngle4f.y, axisAngle4f.z);
    }

    public Matrix4x3f rotate(AxisAngle4f axisAngle4f, Matrix4x3f matrix4x3f) {
        return this.rotate(axisAngle4f.angle, axisAngle4f.x, axisAngle4f.y, axisAngle4f.z, matrix4x3f);
    }

    public Matrix4x3f rotate(float f2, Vector3fc vector3fc) {
        return this.rotate(f2, vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Matrix4x3f rotate(float f2, Vector3fc vector3fc, Matrix4x3f matrix4x3f) {
        return this.rotate(f2, vector3fc.x(), vector3fc.y(), vector3fc.z(), matrix4x3f);
    }

    public Matrix4x3f reflect(float f2, float f3, float f4, float f5, Matrix4x3f matrix4x3f) {
        if ((this.properties & 4) != 0) {
            return matrix4x3f.reflection(f2, f3, f4, f5);
        }
        float f6 = f2 + f2;
        float f7 = f3 + f3;
        float f8 = f4 + f4;
        float f9 = f5 + f5;
        float f10 = 1.0f - f6 * f2;
        float f11 = -f6 * f3;
        float f12 = -f6 * f4;
        float f13 = -f7 * f2;
        float f14 = 1.0f - f7 * f3;
        float f15 = -f7 * f4;
        float f16 = -f8 * f2;
        float f17 = -f8 * f3;
        float f18 = 1.0f - f8 * f4;
        float f19 = -f9 * f2;
        float f20 = -f9 * f3;
        float f21 = -f9 * f4;
        matrix4x3f.m30 = this.m00 * f19 + this.m10 * f20 + this.m20 * f21 + this.m30;
        matrix4x3f.m31 = this.m01 * f19 + this.m11 * f20 + this.m21 * f21 + this.m31;
        matrix4x3f.m32 = this.m02 * f19 + this.m12 * f20 + this.m22 * f21 + this.m32;
        float f22 = this.m00 * f10 + this.m10 * f11 + this.m20 * f12;
        float f23 = this.m01 * f10 + this.m11 * f11 + this.m21 * f12;
        float f24 = this.m02 * f10 + this.m12 * f11 + this.m22 * f12;
        float f25 = this.m00 * f13 + this.m10 * f14 + this.m20 * f15;
        float f26 = this.m01 * f13 + this.m11 * f14 + this.m21 * f15;
        float f27 = this.m02 * f13 + this.m12 * f14 + this.m22 * f15;
        matrix4x3f.m20 = this.m00 * f16 + this.m10 * f17 + this.m20 * f18;
        matrix4x3f.m21 = this.m01 * f16 + this.m11 * f17 + this.m21 * f18;
        matrix4x3f.m22 = this.m02 * f16 + this.m12 * f17 + this.m22 * f18;
        matrix4x3f.m00 = f22;
        matrix4x3f.m01 = f23;
        matrix4x3f.m02 = f24;
        matrix4x3f.m10 = f25;
        matrix4x3f.m11 = f26;
        matrix4x3f.m12 = f27;
        matrix4x3f.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3f;
    }

    public Matrix4x3f reflect(float f2, float f3, float f4, float f5) {
        return this.reflect(f2, f3, f4, f5, this);
    }

    public Matrix4x3f reflect(float f2, float f3, float f4, float f5, float f6, float f7) {
        return this.reflect(f2, f3, f4, f5, f6, f7, this);
    }

    public Matrix4x3f reflect(float f2, float f3, float f4, float f5, float f6, float f7, Matrix4x3f matrix4x3f) {
        float f8 = Math.invsqrt(f2 * f2 + f3 * f3 + f4 * f4);
        float f9 = f2 * f8;
        float f10 = f3 * f8;
        float f11 = f4 * f8;
        return this.reflect(f9, f10, f11, -f9 * f5 - f10 * f6 - f11 * f7, matrix4x3f);
    }

    public Matrix4x3f reflect(Vector3fc vector3fc, Vector3fc vector3fc2) {
        return this.reflect(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z());
    }

    public Matrix4x3f reflect(Quaternionfc quaternionfc, Vector3fc vector3fc) {
        return this.reflect(quaternionfc, vector3fc, this);
    }

    public Matrix4x3f reflect(Quaternionfc quaternionfc, Vector3fc vector3fc, Matrix4x3f matrix4x3f) {
        double d2 = quaternionfc.x() + quaternionfc.x();
        double d3 = quaternionfc.y() + quaternionfc.y();
        double d4 = quaternionfc.z() + quaternionfc.z();
        float f2 = (float)((double)quaternionfc.x() * d4 + (double)quaternionfc.w() * d3);
        float f3 = (float)((double)quaternionfc.y() * d4 - (double)quaternionfc.w() * d2);
        float f4 = (float)(1.0 - ((double)quaternionfc.x() * d2 + (double)quaternionfc.y() * d3));
        return this.reflect(f2, f3, f4, vector3fc.x(), vector3fc.y(), vector3fc.z(), matrix4x3f);
    }

    public Matrix4x3f reflect(Vector3fc vector3fc, Vector3fc vector3fc2, Matrix4x3f matrix4x3f) {
        return this.reflect(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), matrix4x3f);
    }

    public Matrix4x3f reflection(float f2, float f3, float f4, float f5) {
        float f6 = f2 + f2;
        float f7 = f3 + f3;
        float f8 = f4 + f4;
        float f9 = f5 + f5;
        this.m00 = 1.0f - f6 * f2;
        this.m01 = -f6 * f3;
        this.m02 = -f6 * f4;
        this.m10 = -f7 * f2;
        this.m11 = 1.0f - f7 * f3;
        this.m12 = -f7 * f4;
        this.m20 = -f8 * f2;
        this.m21 = -f8 * f3;
        this.m22 = 1.0f - f8 * f4;
        this.m30 = -f9 * f2;
        this.m31 = -f9 * f3;
        this.m32 = -f9 * f4;
        this.properties = 16;
        return this;
    }

    public Matrix4x3f reflection(float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8 = Math.invsqrt(f2 * f2 + f3 * f3 + f4 * f4);
        float f9 = f2 * f8;
        float f10 = f3 * f8;
        float f11 = f4 * f8;
        return this.reflection(f9, f10, f11, -f9 * f5 - f10 * f6 - f11 * f7);
    }

    public Matrix4x3f reflection(Vector3fc vector3fc, Vector3fc vector3fc2) {
        return this.reflection(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z());
    }

    public Matrix4x3f reflection(Quaternionfc quaternionfc, Vector3fc vector3fc) {
        double d2 = quaternionfc.x() + quaternionfc.x();
        double d3 = quaternionfc.y() + quaternionfc.y();
        double d4 = quaternionfc.z() + quaternionfc.z();
        float f2 = (float)((double)quaternionfc.x() * d4 + (double)quaternionfc.w() * d3);
        float f3 = (float)((double)quaternionfc.y() * d4 - (double)quaternionfc.w() * d2);
        float f4 = (float)(1.0 - ((double)quaternionfc.x() * d2 + (double)quaternionfc.y() * d3));
        return this.reflection(f2, f3, f4, vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Vector4f getRow(int n2, Vector4f vector4f) {
        switch (n2) {
            case 0: {
                vector4f.x = this.m00;
                vector4f.y = this.m10;
                vector4f.z = this.m20;
                vector4f.w = this.m30;
                break;
            }
            case 1: {
                vector4f.x = this.m01;
                vector4f.y = this.m11;
                vector4f.z = this.m21;
                vector4f.w = this.m31;
                break;
            }
            case 2: {
                vector4f.x = this.m02;
                vector4f.y = this.m12;
                vector4f.z = this.m22;
                vector4f.w = this.m32;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return vector4f;
    }

    public Matrix4x3f setRow(int n2, Vector4fc vector4fc) {
        switch (n2) {
            case 0: {
                this.m00 = vector4fc.x();
                this.m10 = vector4fc.y();
                this.m20 = vector4fc.z();
                this.m30 = vector4fc.w();
                break;
            }
            case 1: {
                this.m01 = vector4fc.x();
                this.m11 = vector4fc.y();
                this.m21 = vector4fc.z();
                this.m31 = vector4fc.w();
                break;
            }
            case 2: {
                this.m02 = vector4fc.x();
                this.m12 = vector4fc.y();
                this.m22 = vector4fc.z();
                this.m32 = vector4fc.w();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        this.properties = 0;
        return this;
    }

    public Vector3f getColumn(int n2, Vector3f vector3f) {
        switch (n2) {
            case 0: {
                vector3f.x = this.m00;
                vector3f.y = this.m01;
                vector3f.z = this.m02;
                break;
            }
            case 1: {
                vector3f.x = this.m10;
                vector3f.y = this.m11;
                vector3f.z = this.m12;
                break;
            }
            case 2: {
                vector3f.x = this.m20;
                vector3f.y = this.m21;
                vector3f.z = this.m22;
                break;
            }
            case 3: {
                vector3f.x = this.m30;
                vector3f.y = this.m31;
                vector3f.z = this.m32;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return vector3f;
    }

    public Matrix4x3f setColumn(int n2, Vector3fc vector3fc) {
        switch (n2) {
            case 0: {
                this.m00 = vector3fc.x();
                this.m01 = vector3fc.y();
                this.m02 = vector3fc.z();
                break;
            }
            case 1: {
                this.m10 = vector3fc.x();
                this.m11 = vector3fc.y();
                this.m12 = vector3fc.z();
                break;
            }
            case 2: {
                this.m20 = vector3fc.x();
                this.m21 = vector3fc.y();
                this.m22 = vector3fc.z();
                break;
            }
            case 3: {
                this.m30 = vector3fc.x();
                this.m31 = vector3fc.y();
                this.m32 = vector3fc.z();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        this.properties = 0;
        return this;
    }

    public Matrix4x3f normal() {
        return this.normal(this);
    }

    public Matrix4x3f normal(Matrix4x3f matrix4x3f) {
        if ((this.properties & 4) != 0) {
            return matrix4x3f.identity();
        }
        if ((this.properties & 0x10) != 0) {
            return this.normalOrthonormal(matrix4x3f);
        }
        return this.normalGeneric(matrix4x3f);
    }

    private Matrix4x3f normalOrthonormal(Matrix4x3f matrix4x3f) {
        if (matrix4x3f != this) {
            matrix4x3f.set(this);
        }
        return matrix4x3f._properties(16);
    }

    private Matrix4x3f normalGeneric(Matrix4x3f matrix4x3f) {
        float f2 = this.m00 * this.m11;
        float f3 = this.m01 * this.m10;
        float f4 = this.m02 * this.m10;
        float f5 = this.m00 * this.m12;
        float f6 = this.m01 * this.m12;
        float f7 = this.m02 * this.m11;
        float f8 = (f2 - f3) * this.m22 + (f4 - f5) * this.m21 + (f6 - f7) * this.m20;
        float f9 = 1.0f / f8;
        float f10 = (this.m11 * this.m22 - this.m21 * this.m12) * f9;
        float f11 = (this.m20 * this.m12 - this.m10 * this.m22) * f9;
        float f12 = (this.m10 * this.m21 - this.m20 * this.m11) * f9;
        float f13 = (this.m21 * this.m02 - this.m01 * this.m22) * f9;
        float f14 = (this.m00 * this.m22 - this.m20 * this.m02) * f9;
        float f15 = (this.m20 * this.m01 - this.m00 * this.m21) * f9;
        float f16 = (f6 - f7) * f9;
        float f17 = (f4 - f5) * f9;
        float f18 = (f2 - f3) * f9;
        matrix4x3f.m00 = f10;
        matrix4x3f.m01 = f11;
        matrix4x3f.m02 = f12;
        matrix4x3f.m10 = f13;
        matrix4x3f.m11 = f14;
        matrix4x3f.m12 = f15;
        matrix4x3f.m20 = f16;
        matrix4x3f.m21 = f17;
        matrix4x3f.m22 = f18;
        matrix4x3f.m30 = 0.0f;
        matrix4x3f.m31 = 0.0f;
        matrix4x3f.m32 = 0.0f;
        matrix4x3f.properties = this.properties & 0xFFFFFFF7;
        return matrix4x3f;
    }

    public Matrix3f normal(Matrix3f matrix3f) {
        if ((this.properties & 0x10) != 0) {
            return this.normalOrthonormal(matrix3f);
        }
        return this.normalGeneric(matrix3f);
    }

    private Matrix3f normalOrthonormal(Matrix3f matrix3f) {
        return matrix3f.set(this);
    }

    private Matrix3f normalGeneric(Matrix3f matrix3f) {
        float f2 = this.m00 * this.m11;
        float f3 = this.m01 * this.m10;
        float f4 = this.m02 * this.m10;
        float f5 = this.m00 * this.m12;
        float f6 = this.m01 * this.m12;
        float f7 = this.m02 * this.m11;
        float f8 = (f2 - f3) * this.m22 + (f4 - f5) * this.m21 + (f6 - f7) * this.m20;
        float f9 = 1.0f / f8;
        matrix3f.m00((this.m11 * this.m22 - this.m21 * this.m12) * f9);
        matrix3f.m01((this.m20 * this.m12 - this.m10 * this.m22) * f9);
        matrix3f.m02((this.m10 * this.m21 - this.m20 * this.m11) * f9);
        matrix3f.m10((this.m21 * this.m02 - this.m01 * this.m22) * f9);
        matrix3f.m11((this.m00 * this.m22 - this.m20 * this.m02) * f9);
        matrix3f.m12((this.m20 * this.m01 - this.m00 * this.m21) * f9);
        matrix3f.m20((f6 - f7) * f9);
        matrix3f.m21((f4 - f5) * f9);
        matrix3f.m22((f2 - f3) * f9);
        return matrix3f;
    }

    public Matrix4x3f cofactor3x3() {
        return this.cofactor3x3(this);
    }

    public Matrix3f cofactor3x3(Matrix3f matrix3f) {
        matrix3f.m00 = this.m11 * this.m22 - this.m21 * this.m12;
        matrix3f.m01 = this.m20 * this.m12 - this.m10 * this.m22;
        matrix3f.m02 = this.m10 * this.m21 - this.m20 * this.m11;
        matrix3f.m10 = this.m21 * this.m02 - this.m01 * this.m22;
        matrix3f.m11 = this.m00 * this.m22 - this.m20 * this.m02;
        matrix3f.m12 = this.m20 * this.m01 - this.m00 * this.m21;
        matrix3f.m20 = this.m01 * this.m12 - this.m02 * this.m11;
        matrix3f.m21 = this.m02 * this.m10 - this.m00 * this.m12;
        matrix3f.m22 = this.m00 * this.m11 - this.m01 * this.m10;
        return matrix3f;
    }

    public Matrix4x3f cofactor3x3(Matrix4x3f matrix4x3f) {
        float f2 = this.m11 * this.m22 - this.m21 * this.m12;
        float f3 = this.m20 * this.m12 - this.m10 * this.m22;
        float f4 = this.m10 * this.m21 - this.m20 * this.m11;
        float f5 = this.m21 * this.m02 - this.m01 * this.m22;
        float f6 = this.m00 * this.m22 - this.m20 * this.m02;
        float f7 = this.m20 * this.m01 - this.m00 * this.m21;
        float f8 = this.m01 * this.m12 - this.m11 * this.m02;
        float f9 = this.m02 * this.m10 - this.m12 * this.m00;
        float f10 = this.m00 * this.m11 - this.m10 * this.m01;
        matrix4x3f.m00 = f2;
        matrix4x3f.m01 = f3;
        matrix4x3f.m02 = f4;
        matrix4x3f.m10 = f5;
        matrix4x3f.m11 = f6;
        matrix4x3f.m12 = f7;
        matrix4x3f.m20 = f8;
        matrix4x3f.m21 = f9;
        matrix4x3f.m22 = f10;
        matrix4x3f.m30 = 0.0f;
        matrix4x3f.m31 = 0.0f;
        matrix4x3f.m32 = 0.0f;
        matrix4x3f.properties = this.properties & 0xFFFFFFF7;
        return matrix4x3f;
    }

    public Matrix4x3f normalize3x3() {
        return this.normalize3x3(this);
    }

    public Matrix4x3f normalize3x3(Matrix4x3f matrix4x3f) {
        float f2 = Math.invsqrt(this.m00 * this.m00 + this.m01 * this.m01 + this.m02 * this.m02);
        float f3 = Math.invsqrt(this.m10 * this.m10 + this.m11 * this.m11 + this.m12 * this.m12);
        float f4 = Math.invsqrt(this.m20 * this.m20 + this.m21 * this.m21 + this.m22 * this.m22);
        matrix4x3f.m00 = this.m00 * f2;
        matrix4x3f.m01 = this.m01 * f2;
        matrix4x3f.m02 = this.m02 * f2;
        matrix4x3f.m10 = this.m10 * f3;
        matrix4x3f.m11 = this.m11 * f3;
        matrix4x3f.m12 = this.m12 * f3;
        matrix4x3f.m20 = this.m20 * f4;
        matrix4x3f.m21 = this.m21 * f4;
        matrix4x3f.m22 = this.m22 * f4;
        matrix4x3f.properties = this.properties;
        return matrix4x3f;
    }

    public Matrix3f normalize3x3(Matrix3f matrix3f) {
        float f2 = Math.invsqrt(this.m00 * this.m00 + this.m01 * this.m01 + this.m02 * this.m02);
        float f3 = Math.invsqrt(this.m10 * this.m10 + this.m11 * this.m11 + this.m12 * this.m12);
        float f4 = Math.invsqrt(this.m20 * this.m20 + this.m21 * this.m21 + this.m22 * this.m22);
        matrix3f.m00(this.m00 * f2);
        matrix3f.m01(this.m01 * f2);
        matrix3f.m02(this.m02 * f2);
        matrix3f.m10(this.m10 * f3);
        matrix3f.m11(this.m11 * f3);
        matrix3f.m12(this.m12 * f3);
        matrix3f.m20(this.m20 * f4);
        matrix3f.m21(this.m21 * f4);
        matrix3f.m22(this.m22 * f4);
        return matrix3f;
    }

    public Vector4f frustumPlane(int n2, Vector4f vector4f) {
        switch (n2) {
            case 0: {
                vector4f.set(this.m00, this.m10, this.m20, 1.0f + this.m30).normalize();
                break;
            }
            case 1: {
                vector4f.set(-this.m00, -this.m10, -this.m20, 1.0f - this.m30).normalize();
                break;
            }
            case 2: {
                vector4f.set(this.m01, this.m11, this.m21, 1.0f + this.m31).normalize();
                break;
            }
            case 3: {
                vector4f.set(-this.m01, -this.m11, -this.m21, 1.0f - this.m31).normalize();
                break;
            }
            case 4: {
                vector4f.set(this.m02, this.m12, this.m22, 1.0f + this.m32).normalize();
                break;
            }
            case 5: {
                vector4f.set(-this.m02, -this.m12, -this.m22, 1.0f - this.m32).normalize();
                break;
            }
            default: {
                throw new IllegalArgumentException("which");
            }
        }
        return vector4f;
    }

    public Vector3f positiveZ(Vector3f vector3f) {
        vector3f.x = this.m10 * this.m21 - this.m11 * this.m20;
        vector3f.y = this.m20 * this.m01 - this.m21 * this.m00;
        vector3f.z = this.m00 * this.m11 - this.m01 * this.m10;
        return vector3f.normalize(vector3f);
    }

    public Vector3f normalizedPositiveZ(Vector3f vector3f) {
        vector3f.x = this.m02;
        vector3f.y = this.m12;
        vector3f.z = this.m22;
        return vector3f;
    }

    public Vector3f positiveX(Vector3f vector3f) {
        vector3f.x = this.m11 * this.m22 - this.m12 * this.m21;
        vector3f.y = this.m02 * this.m21 - this.m01 * this.m22;
        vector3f.z = this.m01 * this.m12 - this.m02 * this.m11;
        return vector3f.normalize(vector3f);
    }

    public Vector3f normalizedPositiveX(Vector3f vector3f) {
        vector3f.x = this.m00;
        vector3f.y = this.m10;
        vector3f.z = this.m20;
        return vector3f;
    }

    public Vector3f positiveY(Vector3f vector3f) {
        vector3f.x = this.m12 * this.m20 - this.m10 * this.m22;
        vector3f.y = this.m00 * this.m22 - this.m02 * this.m20;
        vector3f.z = this.m02 * this.m10 - this.m00 * this.m12;
        return vector3f.normalize(vector3f);
    }

    public Vector3f normalizedPositiveY(Vector3f vector3f) {
        vector3f.x = this.m01;
        vector3f.y = this.m11;
        vector3f.z = this.m21;
        return vector3f;
    }

    public Vector3f origin(Vector3f vector3f) {
        float f2 = this.m00 * this.m11 - this.m01 * this.m10;
        float f3 = this.m00 * this.m12 - this.m02 * this.m10;
        float f4 = this.m01 * this.m12 - this.m02 * this.m11;
        float f5 = this.m20 * this.m31 - this.m21 * this.m30;
        float f6 = this.m20 * this.m32 - this.m22 * this.m30;
        float f7 = this.m21 * this.m32 - this.m22 * this.m31;
        vector3f.x = -this.m10 * f7 + this.m11 * f6 - this.m12 * f5;
        vector3f.y = this.m00 * f7 - this.m01 * f6 + this.m02 * f5;
        vector3f.z = -this.m30 * f4 + this.m31 * f3 - this.m32 * f2;
        return vector3f;
    }

    public Matrix4x3f shadow(Vector4fc vector4fc, float f2, float f3, float f4, float f5) {
        return this.shadow(vector4fc.x(), vector4fc.y(), vector4fc.z(), vector4fc.w(), f2, f3, f4, f5, this);
    }

    public Matrix4x3f shadow(Vector4fc vector4fc, float f2, float f3, float f4, float f5, Matrix4x3f matrix4x3f) {
        return this.shadow(vector4fc.x(), vector4fc.y(), vector4fc.z(), vector4fc.w(), f2, f3, f4, f5, matrix4x3f);
    }

    public Matrix4x3f shadow(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        return this.shadow(f2, f3, f4, f5, f6, f7, f8, f9, this);
    }

    public Matrix4x3f shadow(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, Matrix4x3f matrix4x3f) {
        float f10 = Math.invsqrt(f6 * f6 + f7 * f7 + f8 * f8);
        float f11 = f6 * f10;
        float f12 = f7 * f10;
        float f13 = f8 * f10;
        float f14 = f9 * f10;
        float f15 = f11 * f2 + f12 * f3 + f13 * f4 + f14 * f5;
        float f16 = f15 - f11 * f2;
        float f17 = -f11 * f3;
        float f18 = -f11 * f4;
        float f19 = -f11 * f5;
        float f20 = -f12 * f2;
        float f21 = f15 - f12 * f3;
        float f22 = -f12 * f4;
        float f23 = -f12 * f5;
        float f24 = -f13 * f2;
        float f25 = -f13 * f3;
        float f26 = f15 - f13 * f4;
        float f27 = -f13 * f5;
        float f28 = -f14 * f2;
        float f29 = -f14 * f3;
        float f30 = -f14 * f4;
        float f31 = f15 - f14 * f5;
        float f32 = this.m00 * f16 + this.m10 * f17 + this.m20 * f18 + this.m30 * f19;
        float f33 = this.m01 * f16 + this.m11 * f17 + this.m21 * f18 + this.m31 * f19;
        float f34 = this.m02 * f16 + this.m12 * f17 + this.m22 * f18 + this.m32 * f19;
        float f35 = this.m00 * f20 + this.m10 * f21 + this.m20 * f22 + this.m30 * f23;
        float f36 = this.m01 * f20 + this.m11 * f21 + this.m21 * f22 + this.m31 * f23;
        float f37 = this.m02 * f20 + this.m12 * f21 + this.m22 * f22 + this.m32 * f23;
        float f38 = this.m00 * f24 + this.m10 * f25 + this.m20 * f26 + this.m30 * f27;
        float f39 = this.m01 * f24 + this.m11 * f25 + this.m21 * f26 + this.m31 * f27;
        float f40 = this.m02 * f24 + this.m12 * f25 + this.m22 * f26 + this.m32 * f27;
        matrix4x3f.m30 = this.m00 * f28 + this.m10 * f29 + this.m20 * f30 + this.m30 * f31;
        matrix4x3f.m31 = this.m01 * f28 + this.m11 * f29 + this.m21 * f30 + this.m31 * f31;
        matrix4x3f.m32 = this.m02 * f28 + this.m12 * f29 + this.m22 * f30 + this.m32 * f31;
        matrix4x3f.m00 = f32;
        matrix4x3f.m01 = f33;
        matrix4x3f.m02 = f34;
        matrix4x3f.m10 = f35;
        matrix4x3f.m11 = f36;
        matrix4x3f.m12 = f37;
        matrix4x3f.m20 = f38;
        matrix4x3f.m21 = f39;
        matrix4x3f.m22 = f40;
        matrix4x3f.properties = this.properties & 0xFFFFFFE3;
        return matrix4x3f;
    }

    public Matrix4x3f shadow(Vector4fc vector4fc, Matrix4x3fc matrix4x3fc, Matrix4x3f matrix4x3f) {
        float f2 = matrix4x3fc.m10();
        float f3 = matrix4x3fc.m11();
        float f4 = matrix4x3fc.m12();
        float f5 = -f2 * matrix4x3fc.m30() - f3 * matrix4x3fc.m31() - f4 * matrix4x3fc.m32();
        return this.shadow(vector4fc.x(), vector4fc.y(), vector4fc.z(), vector4fc.w(), f2, f3, f4, f5, matrix4x3f);
    }

    public Matrix4x3f shadow(Vector4fc vector4fc, Matrix4x3fc matrix4x3fc) {
        return this.shadow(vector4fc, matrix4x3fc, this);
    }

    public Matrix4x3f shadow(float f2, float f3, float f4, float f5, Matrix4x3fc matrix4x3fc, Matrix4x3f matrix4x3f) {
        float f6 = matrix4x3fc.m10();
        float f7 = matrix4x3fc.m11();
        float f8 = matrix4x3fc.m12();
        float f9 = -f6 * matrix4x3fc.m30() - f7 * matrix4x3fc.m31() - f8 * matrix4x3fc.m32();
        return this.shadow(f2, f3, f4, f5, f6, f7, f8, f9, matrix4x3f);
    }

    public Matrix4x3f shadow(float f2, float f3, float f4, float f5, Matrix4x3f matrix4x3f) {
        return this.shadow(f2, f3, f4, f5, matrix4x3f, this);
    }

    public Matrix4x3f billboardCylindrical(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3) {
        float f2 = vector3fc2.x() - vector3fc.x();
        float f3 = vector3fc2.y() - vector3fc.y();
        float f4 = vector3fc2.z() - vector3fc.z();
        float f5 = vector3fc3.y() * f4 - vector3fc3.z() * f3;
        float f6 = vector3fc3.z() * f2 - vector3fc3.x() * f4;
        float f7 = vector3fc3.x() * f3 - vector3fc3.y() * f2;
        float f8 = Math.invsqrt(f5 * f5 + f6 * f6 + f7 * f7);
        f2 = (f6 *= f8) * vector3fc3.z() - (f7 *= f8) * vector3fc3.y();
        f3 = f7 * vector3fc3.x() - (f5 *= f8) * vector3fc3.z();
        f4 = f5 * vector3fc3.y() - f6 * vector3fc3.x();
        float f9 = Math.invsqrt(f2 * f2 + f3 * f3 + f4 * f4);
        f2 *= f9;
        f3 *= f9;
        f4 *= f9;
        this.m00 = f5;
        this.m01 = f6;
        this.m02 = f7;
        this.m10 = vector3fc3.x();
        this.m11 = vector3fc3.y();
        this.m12 = vector3fc3.z();
        this.m20 = f2;
        this.m21 = f3;
        this.m22 = f4;
        this.m30 = vector3fc.x();
        this.m31 = vector3fc.y();
        this.m32 = vector3fc.z();
        this.properties = 16;
        return this;
    }

    public Matrix4x3f billboardSpherical(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3) {
        float f2 = vector3fc2.x() - vector3fc.x();
        float f3 = vector3fc2.y() - vector3fc.y();
        float f4 = vector3fc2.z() - vector3fc.z();
        float f5 = Math.invsqrt(f2 * f2 + f3 * f3 + f4 * f4);
        float f6 = vector3fc3.y() * (f4 *= f5) - vector3fc3.z() * (f3 *= f5);
        float f7 = vector3fc3.z() * (f2 *= f5) - vector3fc3.x() * f4;
        float f8 = vector3fc3.x() * f3 - vector3fc3.y() * f2;
        float f9 = Math.invsqrt(f6 * f6 + f7 * f7 + f8 * f8);
        float f10 = f3 * (f8 *= f9) - f4 * (f7 *= f9);
        float f11 = f4 * (f6 *= f9) - f2 * f8;
        float f12 = f2 * f7 - f3 * f6;
        this.m00 = f6;
        this.m01 = f7;
        this.m02 = f8;
        this.m10 = f10;
        this.m11 = f11;
        this.m12 = f12;
        this.m20 = f2;
        this.m21 = f3;
        this.m22 = f4;
        this.m30 = vector3fc.x();
        this.m31 = vector3fc.y();
        this.m32 = vector3fc.z();
        this.properties = 16;
        return this;
    }

    public Matrix4x3f billboardSpherical(Vector3fc vector3fc, Vector3fc vector3fc2) {
        float f2 = vector3fc2.x() - vector3fc.x();
        float f3 = vector3fc2.y() - vector3fc.y();
        float f4 = vector3fc2.z() - vector3fc.z();
        float f5 = -f3;
        float f6 = f2;
        float f7 = Math.sqrt(f2 * f2 + f3 * f3 + f4 * f4) + f4;
        float f8 = Math.invsqrt(f5 * f5 + f6 * f6 + f7 * f7);
        float f9 = ((f5 *= f8) + f5) * f5;
        float f10 = ((f6 *= f8) + f6) * f6;
        float f11 = (f5 + f5) * f6;
        float f12 = (f5 + f5) * (f7 *= f8);
        float f13 = (f6 + f6) * f7;
        this.m00 = 1.0f - f10;
        this.m01 = f11;
        this.m02 = -f13;
        this.m10 = f11;
        this.m11 = 1.0f - f9;
        this.m12 = f12;
        this.m20 = f13;
        this.m21 = -f12;
        this.m22 = 1.0f - f10 - f9;
        this.m30 = vector3fc.x();
        this.m31 = vector3fc.y();
        this.m32 = vector3fc.z();
        this.properties = 16;
        return this;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + Float.floatToIntBits(this.m00);
        n3 = 31 * n3 + Float.floatToIntBits(this.m01);
        n3 = 31 * n3 + Float.floatToIntBits(this.m02);
        n3 = 31 * n3 + Float.floatToIntBits(this.m10);
        n3 = 31 * n3 + Float.floatToIntBits(this.m11);
        n3 = 31 * n3 + Float.floatToIntBits(this.m12);
        n3 = 31 * n3 + Float.floatToIntBits(this.m20);
        n3 = 31 * n3 + Float.floatToIntBits(this.m21);
        n3 = 31 * n3 + Float.floatToIntBits(this.m22);
        n3 = 31 * n3 + Float.floatToIntBits(this.m30);
        n3 = 31 * n3 + Float.floatToIntBits(this.m31);
        n3 = 31 * n3 + Float.floatToIntBits(this.m32);
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Matrix4x3f)) {
            return false;
        }
        Matrix4x3f matrix4x3f = (Matrix4x3f)object;
        if (Float.floatToIntBits(this.m00) != Float.floatToIntBits(matrix4x3f.m00)) {
            return false;
        }
        if (Float.floatToIntBits(this.m01) != Float.floatToIntBits(matrix4x3f.m01)) {
            return false;
        }
        if (Float.floatToIntBits(this.m02) != Float.floatToIntBits(matrix4x3f.m02)) {
            return false;
        }
        if (Float.floatToIntBits(this.m10) != Float.floatToIntBits(matrix4x3f.m10)) {
            return false;
        }
        if (Float.floatToIntBits(this.m11) != Float.floatToIntBits(matrix4x3f.m11)) {
            return false;
        }
        if (Float.floatToIntBits(this.m12) != Float.floatToIntBits(matrix4x3f.m12)) {
            return false;
        }
        if (Float.floatToIntBits(this.m20) != Float.floatToIntBits(matrix4x3f.m20)) {
            return false;
        }
        if (Float.floatToIntBits(this.m21) != Float.floatToIntBits(matrix4x3f.m21)) {
            return false;
        }
        if (Float.floatToIntBits(this.m22) != Float.floatToIntBits(matrix4x3f.m22)) {
            return false;
        }
        if (Float.floatToIntBits(this.m30) != Float.floatToIntBits(matrix4x3f.m30)) {
            return false;
        }
        if (Float.floatToIntBits(this.m31) != Float.floatToIntBits(matrix4x3f.m31)) {
            return false;
        }
        return Float.floatToIntBits(this.m32) == Float.floatToIntBits(matrix4x3f.m32);
    }

    public boolean equals(Matrix4x3fc matrix4x3fc, float f2) {
        if (this == matrix4x3fc) {
            return true;
        }
        if (matrix4x3fc == null) {
            return false;
        }
        if (!(matrix4x3fc instanceof Matrix4x3f)) {
            return false;
        }
        if (!Runtime.equals(this.m00, matrix4x3fc.m00(), f2)) {
            return false;
        }
        if (!Runtime.equals(this.m01, matrix4x3fc.m01(), f2)) {
            return false;
        }
        if (!Runtime.equals(this.m02, matrix4x3fc.m02(), f2)) {
            return false;
        }
        if (!Runtime.equals(this.m10, matrix4x3fc.m10(), f2)) {
            return false;
        }
        if (!Runtime.equals(this.m11, matrix4x3fc.m11(), f2)) {
            return false;
        }
        if (!Runtime.equals(this.m12, matrix4x3fc.m12(), f2)) {
            return false;
        }
        if (!Runtime.equals(this.m20, matrix4x3fc.m20(), f2)) {
            return false;
        }
        if (!Runtime.equals(this.m21, matrix4x3fc.m21(), f2)) {
            return false;
        }
        if (!Runtime.equals(this.m22, matrix4x3fc.m22(), f2)) {
            return false;
        }
        if (!Runtime.equals(this.m30, matrix4x3fc.m30(), f2)) {
            return false;
        }
        if (!Runtime.equals(this.m31, matrix4x3fc.m31(), f2)) {
            return false;
        }
        return Runtime.equals(this.m32, matrix4x3fc.m32(), f2);
    }

    public Matrix4x3f pick(float f2, float f3, float f4, float f5, int[] nArray, Matrix4x3f matrix4x3f) {
        float f6 = (float)nArray[2] / f4;
        float f7 = (float)nArray[3] / f5;
        float f8 = ((float)nArray[2] + 2.0f * ((float)nArray[0] - f2)) / f4;
        float f9 = ((float)nArray[3] + 2.0f * ((float)nArray[1] - f3)) / f5;
        matrix4x3f.m30 = this.m00 * f8 + this.m10 * f9 + this.m30;
        matrix4x3f.m31 = this.m01 * f8 + this.m11 * f9 + this.m31;
        matrix4x3f.m32 = this.m02 * f8 + this.m12 * f9 + this.m32;
        matrix4x3f.m00 = this.m00 * f6;
        matrix4x3f.m01 = this.m01 * f6;
        matrix4x3f.m02 = this.m02 * f6;
        matrix4x3f.m10 = this.m10 * f7;
        matrix4x3f.m11 = this.m11 * f7;
        matrix4x3f.m12 = this.m12 * f7;
        matrix4x3f.properties = 0;
        return matrix4x3f;
    }

    public Matrix4x3f pick(float f2, float f3, float f4, float f5, int[] nArray) {
        return this.pick(f2, f3, f4, f5, nArray, this);
    }

    public Matrix4x3f swap(Matrix4x3f matrix4x3f) {
        MemUtil.INSTANCE.swap(this, matrix4x3f);
        int n2 = this.properties;
        this.properties = matrix4x3f.properties;
        matrix4x3f.properties = n2;
        return this;
    }

    public Matrix4x3f arcball(float f2, float f3, float f4, float f5, float f6, float f7, Matrix4x3f matrix4x3f) {
        float f8 = this.m20 * -f2 + this.m30;
        float f9 = this.m21 * -f2 + this.m31;
        float f10 = this.m22 * -f2 + this.m32;
        float f11 = Math.sin(f6);
        float f12 = Math.cosFromSin(f11, f6);
        float f13 = this.m10 * f12 + this.m20 * f11;
        float f14 = this.m11 * f12 + this.m21 * f11;
        float f15 = this.m12 * f12 + this.m22 * f11;
        float f16 = this.m20 * f12 - this.m10 * f11;
        float f17 = this.m21 * f12 - this.m11 * f11;
        float f18 = this.m22 * f12 - this.m12 * f11;
        f11 = Math.sin(f7);
        f12 = Math.cosFromSin(f11, f7);
        float f19 = this.m00 * f12 - f16 * f11;
        float f20 = this.m01 * f12 - f17 * f11;
        float f21 = this.m02 * f12 - f18 * f11;
        float f22 = this.m00 * f11 + f16 * f12;
        float f23 = this.m01 * f11 + f17 * f12;
        float f24 = this.m02 * f11 + f18 * f12;
        matrix4x3f.m30 = -f19 * f3 - f13 * f4 - f22 * f5 + f8;
        matrix4x3f.m31 = -f20 * f3 - f14 * f4 - f23 * f5 + f9;
        matrix4x3f.m32 = -f21 * f3 - f15 * f4 - f24 * f5 + f10;
        matrix4x3f.m20 = f22;
        matrix4x3f.m21 = f23;
        matrix4x3f.m22 = f24;
        matrix4x3f.m10 = f13;
        matrix4x3f.m11 = f14;
        matrix4x3f.m12 = f15;
        matrix4x3f.m00 = f19;
        matrix4x3f.m01 = f20;
        matrix4x3f.m02 = f21;
        matrix4x3f.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3f;
    }

    public Matrix4x3f arcball(float f2, Vector3fc vector3fc, float f3, float f4, Matrix4x3f matrix4x3f) {
        return this.arcball(f2, vector3fc.x(), vector3fc.y(), vector3fc.z(), f3, f4, matrix4x3f);
    }

    public Matrix4x3f arcball(float f2, float f3, float f4, float f5, float f6, float f7) {
        return this.arcball(f2, f3, f4, f5, f6, f7, this);
    }

    public Matrix4x3f arcball(float f2, Vector3fc vector3fc, float f3, float f4) {
        return this.arcball(f2, vector3fc.x(), vector3fc.y(), vector3fc.z(), f3, f4, this);
    }

    public Matrix4x3f transformAab(float f2, float f3, float f4, float f5, float f6, float f7, Vector3f vector3f, Vector3f vector3f2) {
        float f8;
        float f9;
        float f10;
        float f11;
        float f12;
        float f13;
        float f14;
        float f15;
        float f16;
        float f17;
        float f18;
        float f19;
        float f20;
        float f21;
        float f22;
        float f23;
        float f24;
        float f25;
        float f26 = this.m00 * f2;
        float f27 = this.m01 * f2;
        float f28 = this.m02 * f2;
        float f29 = this.m00 * f5;
        float f30 = this.m01 * f5;
        float f31 = this.m02 * f5;
        float f32 = this.m10 * f3;
        float f33 = this.m11 * f3;
        float f34 = this.m12 * f3;
        float f35 = this.m10 * f6;
        float f36 = this.m11 * f6;
        float f37 = this.m12 * f6;
        float f38 = this.m20 * f4;
        float f39 = this.m21 * f4;
        float f40 = this.m22 * f4;
        float f41 = this.m20 * f7;
        float f42 = this.m21 * f7;
        float f43 = this.m22 * f7;
        if (f26 < f29) {
            f25 = f26;
            f24 = f29;
        } else {
            f25 = f29;
            f24 = f26;
        }
        if (f27 < f30) {
            f23 = f27;
            f22 = f30;
        } else {
            f23 = f30;
            f22 = f27;
        }
        if (f28 < f31) {
            f21 = f28;
            f20 = f31;
        } else {
            f21 = f31;
            f20 = f28;
        }
        if (f32 < f35) {
            f19 = f32;
            f18 = f35;
        } else {
            f19 = f35;
            f18 = f32;
        }
        if (f33 < f36) {
            f17 = f33;
            f16 = f36;
        } else {
            f17 = f36;
            f16 = f33;
        }
        if (f34 < f37) {
            f15 = f34;
            f14 = f37;
        } else {
            f15 = f37;
            f14 = f34;
        }
        if (f38 < f41) {
            f13 = f38;
            f12 = f41;
        } else {
            f13 = f41;
            f12 = f38;
        }
        if (f39 < f42) {
            f11 = f39;
            f10 = f42;
        } else {
            f11 = f42;
            f10 = f39;
        }
        if (f40 < f43) {
            f9 = f40;
            f8 = f43;
        } else {
            f9 = f43;
            f8 = f40;
        }
        vector3f.x = f25 + f19 + f13 + this.m30;
        vector3f.y = f23 + f17 + f11 + this.m31;
        vector3f.z = f21 + f15 + f9 + this.m32;
        vector3f2.x = f24 + f18 + f12 + this.m30;
        vector3f2.y = f22 + f16 + f10 + this.m31;
        vector3f2.z = f20 + f14 + f8 + this.m32;
        return this;
    }

    public Matrix4x3f transformAab(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3f vector3f, Vector3f vector3f2) {
        return this.transformAab(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), vector3f, vector3f2);
    }

    public Matrix4x3f lerp(Matrix4x3fc matrix4x3fc, float f2) {
        return this.lerp(matrix4x3fc, f2, this);
    }

    public Matrix4x3f lerp(Matrix4x3fc matrix4x3fc, float f2, Matrix4x3f matrix4x3f) {
        matrix4x3f.m00 = Math.fma(matrix4x3fc.m00() - this.m00, f2, this.m00);
        matrix4x3f.m01 = Math.fma(matrix4x3fc.m01() - this.m01, f2, this.m01);
        matrix4x3f.m02 = Math.fma(matrix4x3fc.m02() - this.m02, f2, this.m02);
        matrix4x3f.m10 = Math.fma(matrix4x3fc.m10() - this.m10, f2, this.m10);
        matrix4x3f.m11 = Math.fma(matrix4x3fc.m11() - this.m11, f2, this.m11);
        matrix4x3f.m12 = Math.fma(matrix4x3fc.m12() - this.m12, f2, this.m12);
        matrix4x3f.m20 = Math.fma(matrix4x3fc.m20() - this.m20, f2, this.m20);
        matrix4x3f.m21 = Math.fma(matrix4x3fc.m21() - this.m21, f2, this.m21);
        matrix4x3f.m22 = Math.fma(matrix4x3fc.m22() - this.m22, f2, this.m22);
        matrix4x3f.m30 = Math.fma(matrix4x3fc.m30() - this.m30, f2, this.m30);
        matrix4x3f.m31 = Math.fma(matrix4x3fc.m31() - this.m31, f2, this.m31);
        matrix4x3f.m32 = Math.fma(matrix4x3fc.m32() - this.m32, f2, this.m32);
        matrix4x3f.properties = this.properties & matrix4x3fc.properties();
        return matrix4x3f;
    }

    public Matrix4x3f rotateTowards(Vector3fc vector3fc, Vector3fc vector3fc2, Matrix4x3f matrix4x3f) {
        return this.rotateTowards(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), matrix4x3f);
    }

    public Matrix4x3f rotateTowards(Vector3fc vector3fc, Vector3fc vector3fc2) {
        return this.rotateTowards(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), this);
    }

    public Matrix4x3f rotateTowards(float f2, float f3, float f4, float f5, float f6, float f7) {
        return this.rotateTowards(f2, f3, f4, f5, f6, f7, this);
    }

    public Matrix4x3f rotateTowards(float f2, float f3, float f4, float f5, float f6, float f7, Matrix4x3f matrix4x3f) {
        float f8 = Math.invsqrt(f2 * f2 + f3 * f3 + f4 * f4);
        float f9 = f2 * f8;
        float f10 = f3 * f8;
        float f11 = f4 * f8;
        float f12 = f6 * f11 - f7 * f10;
        float f13 = f7 * f9 - f5 * f11;
        float f14 = f5 * f10 - f6 * f9;
        float f15 = Math.invsqrt(f12 * f12 + f13 * f13 + f14 * f14);
        float f16 = f10 * (f14 *= f15) - f11 * (f13 *= f15);
        float f17 = f11 * (f12 *= f15) - f9 * f14;
        float f18 = f9 * f13 - f10 * f12;
        float f19 = f12;
        float f20 = f13;
        float f21 = f14;
        float f22 = f16;
        float f23 = f17;
        float f24 = f18;
        float f25 = f9;
        float f26 = f10;
        float f27 = f11;
        matrix4x3f.m30 = this.m30;
        matrix4x3f.m31 = this.m31;
        matrix4x3f.m32 = this.m32;
        float f28 = this.m00 * f19 + this.m10 * f20 + this.m20 * f21;
        float f29 = this.m01 * f19 + this.m11 * f20 + this.m21 * f21;
        float f30 = this.m02 * f19 + this.m12 * f20 + this.m22 * f21;
        float f31 = this.m00 * f22 + this.m10 * f23 + this.m20 * f24;
        float f32 = this.m01 * f22 + this.m11 * f23 + this.m21 * f24;
        float f33 = this.m02 * f22 + this.m12 * f23 + this.m22 * f24;
        matrix4x3f.m20 = this.m00 * f25 + this.m10 * f26 + this.m20 * f27;
        matrix4x3f.m21 = this.m01 * f25 + this.m11 * f26 + this.m21 * f27;
        matrix4x3f.m22 = this.m02 * f25 + this.m12 * f26 + this.m22 * f27;
        matrix4x3f.m00 = f28;
        matrix4x3f.m01 = f29;
        matrix4x3f.m02 = f30;
        matrix4x3f.m10 = f31;
        matrix4x3f.m11 = f32;
        matrix4x3f.m12 = f33;
        matrix4x3f.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3f;
    }

    public Matrix4x3f rotationTowards(Vector3fc vector3fc, Vector3fc vector3fc2) {
        return this.rotationTowards(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z());
    }

    public Matrix4x3f rotationTowards(float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8 = Math.invsqrt(f2 * f2 + f3 * f3 + f4 * f4);
        float f9 = f2 * f8;
        float f10 = f3 * f8;
        float f11 = f4 * f8;
        float f12 = f6 * f11 - f7 * f10;
        float f13 = f7 * f9 - f5 * f11;
        float f14 = f5 * f10 - f6 * f9;
        float f15 = Math.invsqrt(f12 * f12 + f13 * f13 + f14 * f14);
        float f16 = f10 * (f14 *= f15) - f11 * (f13 *= f15);
        float f17 = f11 * (f12 *= f15) - f9 * f14;
        float f18 = f9 * f13 - f10 * f12;
        this.m00 = f12;
        this.m01 = f13;
        this.m02 = f14;
        this.m10 = f16;
        this.m11 = f17;
        this.m12 = f18;
        this.m20 = f9;
        this.m21 = f10;
        this.m22 = f11;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.properties = 16;
        return this;
    }

    public Matrix4x3f translationRotateTowards(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3) {
        return this.translationRotateTowards(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), vector3fc3.x(), vector3fc3.y(), vector3fc3.z());
    }

    public Matrix4x3f translationRotateTowards(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        float f11 = Math.invsqrt(f5 * f5 + f6 * f6 + f7 * f7);
        float f12 = f5 * f11;
        float f13 = f6 * f11;
        float f14 = f7 * f11;
        float f15 = f9 * f14 - f10 * f13;
        float f16 = f10 * f12 - f8 * f14;
        float f17 = f8 * f13 - f9 * f12;
        float f18 = Math.invsqrt(f15 * f15 + f16 * f16 + f17 * f17);
        float f19 = f13 * (f17 *= f18) - f14 * (f16 *= f18);
        float f20 = f14 * (f15 *= f18) - f12 * f17;
        float f21 = f12 * f16 - f13 * f15;
        this.m00 = f15;
        this.m01 = f16;
        this.m02 = f17;
        this.m10 = f19;
        this.m11 = f20;
        this.m12 = f21;
        this.m20 = f12;
        this.m21 = f13;
        this.m22 = f14;
        this.m30 = f2;
        this.m31 = f3;
        this.m32 = f4;
        this.properties = 16;
        return this;
    }

    public Vector3f getEulerAnglesZYX(Vector3f vector3f) {
        vector3f.x = Math.atan2(this.m12, this.m22);
        vector3f.y = Math.atan2(-this.m02, Math.sqrt(1.0f - this.m02 * this.m02));
        vector3f.z = Math.atan2(this.m01, this.m00);
        return vector3f;
    }

    public Vector3f getEulerAnglesXYZ(Vector3f vector3f) {
        vector3f.x = Math.atan2(-this.m21, this.m22);
        vector3f.y = Math.atan2(this.m20, Math.sqrt(1.0f - this.m20 * this.m20));
        vector3f.z = Math.atan2(-this.m10, this.m00);
        return vector3f;
    }

    public Matrix4x3f obliqueZ(float f2, float f3) {
        this.m20 = this.m00 * f2 + this.m10 * f3 + this.m20;
        this.m21 = this.m01 * f2 + this.m11 * f3 + this.m21;
        this.m22 = this.m02 * f2 + this.m12 * f3 + this.m22;
        this.properties = 0;
        return this;
    }

    public Matrix4x3f obliqueZ(float f2, float f3, Matrix4x3f matrix4x3f) {
        matrix4x3f.m00 = this.m00;
        matrix4x3f.m01 = this.m01;
        matrix4x3f.m02 = this.m02;
        matrix4x3f.m10 = this.m10;
        matrix4x3f.m11 = this.m11;
        matrix4x3f.m12 = this.m12;
        matrix4x3f.m20 = this.m00 * f2 + this.m10 * f3 + this.m20;
        matrix4x3f.m21 = this.m01 * f2 + this.m11 * f3 + this.m21;
        matrix4x3f.m22 = this.m02 * f2 + this.m12 * f3 + this.m22;
        matrix4x3f.m30 = this.m30;
        matrix4x3f.m31 = this.m31;
        matrix4x3f.m32 = this.m32;
        matrix4x3f.properties = 0;
        return matrix4x3f;
    }

    public Matrix4x3f withLookAtUp(Vector3fc vector3fc) {
        return this.withLookAtUp(vector3fc.x(), vector3fc.y(), vector3fc.z(), this);
    }

    public Matrix4x3f withLookAtUp(Vector3fc vector3fc, Matrix4x3f matrix4x3f) {
        return this.withLookAtUp(vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Matrix4x3f withLookAtUp(float f2, float f3, float f4) {
        return this.withLookAtUp(f2, f3, f4, this);
    }

    public Matrix4x3f withLookAtUp(float f2, float f3, float f4, Matrix4x3f matrix4x3f) {
        float f5 = (f3 * this.m21 - f4 * this.m11) * this.m02 + (f4 * this.m01 - f2 * this.m21) * this.m12 + (f2 * this.m11 - f3 * this.m01) * this.m22;
        float f6 = f2 * this.m01 + f3 * this.m11 + f4 * this.m21;
        if ((this.properties & 0x10) == 0) {
            f6 *= Math.sqrt(this.m01 * this.m01 + this.m11 * this.m11 + this.m21 * this.m21);
        }
        float f7 = Math.invsqrt(f5 * f5 + f6 * f6);
        float f8 = f6 * f7;
        float f9 = f5 * f7;
        float f10 = f8 * this.m00 - f9 * this.m01;
        float f11 = f8 * this.m10 - f9 * this.m11;
        float f12 = f8 * this.m20 - f9 * this.m21;
        float f13 = f9 * this.m30 + f8 * this.m31;
        float f14 = f9 * this.m00 + f8 * this.m01;
        float f15 = f9 * this.m10 + f8 * this.m11;
        float f16 = f9 * this.m20 + f8 * this.m21;
        float f17 = f8 * this.m30 - f9 * this.m31;
        matrix4x3f._m00(f10)._m10(f11)._m20(f12)._m30(f17)._m01(f14)._m11(f15)._m21(f16)._m31(f13);
        if (matrix4x3f != this) {
            matrix4x3f._m02(this.m02)._m12(this.m12)._m22(this.m22)._m32(this.m32);
        }
        matrix4x3f.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3f;
    }

    public Matrix4x3f mapXZY() {
        return this.mapXZY(this);
    }

    public Matrix4x3f mapXZY(Matrix4x3f matrix4x3f) {
        float f2 = this.m10;
        float f3 = this.m11;
        float f4 = this.m12;
        return matrix4x3f._m00(this.m00)._m01(this.m01)._m02(this.m02)._m10(this.m20)._m11(this.m21)._m12(this.m22)._m20(f2)._m21(f3)._m22(f4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapXZnY() {
        return this.mapXZnY(this);
    }

    public Matrix4x3f mapXZnY(Matrix4x3f matrix4x3f) {
        float f2 = this.m10;
        float f3 = this.m11;
        float f4 = this.m12;
        return matrix4x3f._m00(this.m00)._m01(this.m01)._m02(this.m02)._m10(this.m20)._m11(this.m21)._m12(this.m22)._m20(-f2)._m21(-f3)._m22(-f4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapXnYnZ() {
        return this.mapXnYnZ(this);
    }

    public Matrix4x3f mapXnYnZ(Matrix4x3f matrix4x3f) {
        return matrix4x3f._m00(this.m00)._m01(this.m01)._m02(this.m02)._m10(-this.m10)._m11(-this.m11)._m12(-this.m12)._m20(-this.m20)._m21(-this.m21)._m22(-this.m22)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapXnZY() {
        return this.mapXnZY(this);
    }

    public Matrix4x3f mapXnZY(Matrix4x3f matrix4x3f) {
        float f2 = this.m10;
        float f3 = this.m11;
        float f4 = this.m12;
        return matrix4x3f._m00(this.m00)._m01(this.m01)._m02(this.m02)._m10(-this.m20)._m11(-this.m21)._m12(-this.m22)._m20(f2)._m21(f3)._m22(f4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapXnZnY() {
        return this.mapXnZnY(this);
    }

    public Matrix4x3f mapXnZnY(Matrix4x3f matrix4x3f) {
        float f2 = this.m10;
        float f3 = this.m11;
        float f4 = this.m12;
        return matrix4x3f._m00(this.m00)._m01(this.m01)._m02(this.m02)._m10(-this.m20)._m11(-this.m21)._m12(-this.m22)._m20(-f2)._m21(-f3)._m22(-f4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapYXZ() {
        return this.mapYXZ(this);
    }

    public Matrix4x3f mapYXZ(Matrix4x3f matrix4x3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix4x3f._m00(this.m10)._m01(this.m11)._m02(this.m12)._m10(f2)._m11(f3)._m12(f4)._m20(this.m20)._m21(this.m21)._m22(this.m22)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapYXnZ() {
        return this.mapYXnZ(this);
    }

    public Matrix4x3f mapYXnZ(Matrix4x3f matrix4x3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix4x3f._m00(this.m10)._m01(this.m11)._m02(this.m12)._m10(f2)._m11(f3)._m12(f4)._m20(-this.m20)._m21(-this.m21)._m22(-this.m22)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapYZX() {
        return this.mapYZX(this);
    }

    public Matrix4x3f mapYZX(Matrix4x3f matrix4x3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix4x3f._m00(this.m10)._m01(this.m11)._m02(this.m12)._m10(this.m20)._m11(this.m21)._m12(this.m22)._m20(f2)._m21(f3)._m22(f4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapYZnX() {
        return this.mapYZnX(this);
    }

    public Matrix4x3f mapYZnX(Matrix4x3f matrix4x3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix4x3f._m00(this.m10)._m01(this.m11)._m02(this.m12)._m10(this.m20)._m11(this.m21)._m12(this.m22)._m20(-f2)._m21(-f3)._m22(-f4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapYnXZ() {
        return this.mapYnXZ(this);
    }

    public Matrix4x3f mapYnXZ(Matrix4x3f matrix4x3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix4x3f._m00(this.m10)._m01(this.m11)._m02(this.m12)._m10(-f2)._m11(-f3)._m12(-f4)._m20(this.m20)._m21(this.m21)._m22(this.m22)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapYnXnZ() {
        return this.mapYnXnZ(this);
    }

    public Matrix4x3f mapYnXnZ(Matrix4x3f matrix4x3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix4x3f._m00(this.m10)._m01(this.m11)._m02(this.m12)._m10(-f2)._m11(-f3)._m12(-f4)._m20(-this.m20)._m21(-this.m21)._m22(-this.m22)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapYnZX() {
        return this.mapYnZX(this);
    }

    public Matrix4x3f mapYnZX(Matrix4x3f matrix4x3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix4x3f._m00(this.m10)._m01(this.m11)._m02(this.m12)._m10(-this.m20)._m11(-this.m21)._m12(-this.m22)._m20(f2)._m21(f3)._m22(f4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapYnZnX() {
        return this.mapYnZnX(this);
    }

    public Matrix4x3f mapYnZnX(Matrix4x3f matrix4x3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix4x3f._m00(this.m10)._m01(this.m11)._m02(this.m12)._m10(-this.m20)._m11(-this.m21)._m12(-this.m22)._m20(-f2)._m21(-f3)._m22(-f4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapZXY() {
        return this.mapZXY(this);
    }

    public Matrix4x3f mapZXY(Matrix4x3f matrix4x3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        float f5 = this.m10;
        float f6 = this.m11;
        float f7 = this.m12;
        return matrix4x3f._m00(this.m20)._m01(this.m21)._m02(this.m22)._m10(f2)._m11(f3)._m12(f4)._m20(f5)._m21(f6)._m22(f7)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapZXnY() {
        return this.mapZXnY(this);
    }

    public Matrix4x3f mapZXnY(Matrix4x3f matrix4x3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        float f5 = this.m10;
        float f6 = this.m11;
        float f7 = this.m12;
        return matrix4x3f._m00(this.m20)._m01(this.m21)._m02(this.m22)._m10(f2)._m11(f3)._m12(f4)._m20(-f5)._m21(-f6)._m22(-f7)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapZYX() {
        return this.mapZYX(this);
    }

    public Matrix4x3f mapZYX(Matrix4x3f matrix4x3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix4x3f._m00(this.m20)._m01(this.m21)._m02(this.m22)._m10(this.m10)._m11(this.m11)._m12(this.m12)._m20(f2)._m21(f3)._m22(f4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapZYnX() {
        return this.mapZYnX(this);
    }

    public Matrix4x3f mapZYnX(Matrix4x3f matrix4x3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix4x3f._m00(this.m20)._m01(this.m21)._m02(this.m22)._m10(this.m10)._m11(this.m11)._m12(this.m12)._m20(-f2)._m21(-f3)._m22(-f4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapZnXY() {
        return this.mapZnXY(this);
    }

    public Matrix4x3f mapZnXY(Matrix4x3f matrix4x3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        float f5 = this.m10;
        float f6 = this.m11;
        float f7 = this.m12;
        return matrix4x3f._m00(this.m20)._m01(this.m21)._m02(this.m22)._m10(-f2)._m11(-f3)._m12(-f4)._m20(f5)._m21(f6)._m22(f7)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapZnXnY() {
        return this.mapZnXnY(this);
    }

    public Matrix4x3f mapZnXnY(Matrix4x3f matrix4x3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        float f5 = this.m10;
        float f6 = this.m11;
        float f7 = this.m12;
        return matrix4x3f._m00(this.m20)._m01(this.m21)._m02(this.m22)._m10(-f2)._m11(-f3)._m12(-f4)._m20(-f5)._m21(-f6)._m22(-f7)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapZnYX() {
        return this.mapZnYX(this);
    }

    public Matrix4x3f mapZnYX(Matrix4x3f matrix4x3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix4x3f._m00(this.m20)._m01(this.m21)._m02(this.m22)._m10(-this.m10)._m11(-this.m11)._m12(-this.m12)._m20(f2)._m21(f3)._m22(f4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapZnYnX() {
        return this.mapZnYnX(this);
    }

    public Matrix4x3f mapZnYnX(Matrix4x3f matrix4x3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix4x3f._m00(this.m20)._m01(this.m21)._m02(this.m22)._m10(-this.m10)._m11(-this.m11)._m12(-this.m12)._m20(-f2)._m21(-f3)._m22(-f4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapnXYnZ() {
        return this.mapnXYnZ(this);
    }

    public Matrix4x3f mapnXYnZ(Matrix4x3f matrix4x3f) {
        return matrix4x3f._m00(-this.m00)._m01(-this.m01)._m02(-this.m02)._m10(this.m10)._m11(this.m11)._m12(this.m12)._m20(-this.m20)._m21(-this.m21)._m22(-this.m22)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapnXZY() {
        return this.mapnXZY(this);
    }

    public Matrix4x3f mapnXZY(Matrix4x3f matrix4x3f) {
        float f2 = this.m10;
        float f3 = this.m11;
        float f4 = this.m12;
        return matrix4x3f._m00(-this.m00)._m01(-this.m01)._m02(-this.m02)._m10(this.m20)._m11(this.m21)._m12(this.m22)._m20(f2)._m21(f3)._m22(f4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapnXZnY() {
        return this.mapnXZnY(this);
    }

    public Matrix4x3f mapnXZnY(Matrix4x3f matrix4x3f) {
        float f2 = this.m10;
        float f3 = this.m11;
        float f4 = this.m12;
        return matrix4x3f._m00(-this.m00)._m01(-this.m01)._m02(-this.m02)._m10(this.m20)._m11(this.m21)._m12(this.m22)._m20(-f2)._m21(-f3)._m22(-f4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapnXnYZ() {
        return this.mapnXnYZ(this);
    }

    public Matrix4x3f mapnXnYZ(Matrix4x3f matrix4x3f) {
        return matrix4x3f._m00(-this.m00)._m01(-this.m01)._m02(-this.m02)._m10(-this.m10)._m11(-this.m11)._m12(-this.m12)._m20(this.m20)._m21(this.m21)._m22(this.m22)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapnXnYnZ() {
        return this.mapnXnYnZ(this);
    }

    public Matrix4x3f mapnXnYnZ(Matrix4x3f matrix4x3f) {
        return matrix4x3f._m00(-this.m00)._m01(-this.m01)._m02(-this.m02)._m10(-this.m10)._m11(-this.m11)._m12(-this.m12)._m20(-this.m20)._m21(-this.m21)._m22(-this.m22)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapnXnZY() {
        return this.mapnXnZY(this);
    }

    public Matrix4x3f mapnXnZY(Matrix4x3f matrix4x3f) {
        float f2 = this.m10;
        float f3 = this.m11;
        float f4 = this.m12;
        return matrix4x3f._m00(-this.m00)._m01(-this.m01)._m02(-this.m02)._m10(-this.m20)._m11(-this.m21)._m12(-this.m22)._m20(f2)._m21(f3)._m22(f4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapnXnZnY() {
        return this.mapnXnZnY(this);
    }

    public Matrix4x3f mapnXnZnY(Matrix4x3f matrix4x3f) {
        float f2 = this.m10;
        float f3 = this.m11;
        float f4 = this.m12;
        return matrix4x3f._m00(-this.m00)._m01(-this.m01)._m02(-this.m02)._m10(-this.m20)._m11(-this.m21)._m12(-this.m22)._m20(-f2)._m21(-f3)._m22(-f4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapnYXZ() {
        return this.mapnYXZ(this);
    }

    public Matrix4x3f mapnYXZ(Matrix4x3f matrix4x3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix4x3f._m00(-this.m10)._m01(-this.m11)._m02(-this.m12)._m10(f2)._m11(f3)._m12(f4)._m20(this.m20)._m21(this.m21)._m22(this.m22)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapnYXnZ() {
        return this.mapnYXnZ(this);
    }

    public Matrix4x3f mapnYXnZ(Matrix4x3f matrix4x3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix4x3f._m00(-this.m10)._m01(-this.m11)._m02(-this.m12)._m10(f2)._m11(f3)._m12(f4)._m20(-this.m20)._m21(-this.m21)._m22(-this.m22)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapnYZX() {
        return this.mapnYZX(this);
    }

    public Matrix4x3f mapnYZX(Matrix4x3f matrix4x3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix4x3f._m00(-this.m10)._m01(-this.m11)._m02(-this.m12)._m10(this.m20)._m11(this.m21)._m12(this.m22)._m20(f2)._m21(f3)._m22(f4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapnYZnX() {
        return this.mapnYZnX(this);
    }

    public Matrix4x3f mapnYZnX(Matrix4x3f matrix4x3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix4x3f._m00(-this.m10)._m01(-this.m11)._m02(-this.m12)._m10(this.m20)._m11(this.m21)._m12(this.m22)._m20(-f2)._m21(-f3)._m22(-f4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapnYnXZ() {
        return this.mapnYnXZ(this);
    }

    public Matrix4x3f mapnYnXZ(Matrix4x3f matrix4x3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix4x3f._m00(-this.m10)._m01(-this.m11)._m02(-this.m12)._m10(-f2)._m11(-f3)._m12(-f4)._m20(this.m20)._m21(this.m21)._m22(this.m22)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapnYnXnZ() {
        return this.mapnYnXnZ(this);
    }

    public Matrix4x3f mapnYnXnZ(Matrix4x3f matrix4x3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix4x3f._m00(-this.m10)._m01(-this.m11)._m02(-this.m12)._m10(-f2)._m11(-f3)._m12(-f4)._m20(-this.m20)._m21(-this.m21)._m22(-this.m22)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapnYnZX() {
        return this.mapnYnZX(this);
    }

    public Matrix4x3f mapnYnZX(Matrix4x3f matrix4x3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix4x3f._m00(-this.m10)._m01(-this.m11)._m02(-this.m12)._m10(-this.m20)._m11(-this.m21)._m12(-this.m22)._m20(f2)._m21(f3)._m22(f4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapnYnZnX() {
        return this.mapnYnZnX(this);
    }

    public Matrix4x3f mapnYnZnX(Matrix4x3f matrix4x3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix4x3f._m00(-this.m10)._m01(-this.m11)._m02(-this.m12)._m10(-this.m20)._m11(-this.m21)._m12(-this.m22)._m20(-f2)._m21(-f3)._m22(-f4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapnZXY() {
        return this.mapnZXY(this);
    }

    public Matrix4x3f mapnZXY(Matrix4x3f matrix4x3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        float f5 = this.m10;
        float f6 = this.m11;
        float f7 = this.m12;
        return matrix4x3f._m00(-this.m20)._m01(-this.m21)._m02(-this.m22)._m10(f2)._m11(f3)._m12(f4)._m20(f5)._m21(f6)._m22(f7)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapnZXnY() {
        return this.mapnZXnY(this);
    }

    public Matrix4x3f mapnZXnY(Matrix4x3f matrix4x3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        float f5 = this.m10;
        float f6 = this.m11;
        float f7 = this.m12;
        return matrix4x3f._m00(-this.m20)._m01(-this.m21)._m02(-this.m22)._m10(f2)._m11(f3)._m12(f4)._m20(-f5)._m21(-f6)._m22(-f7)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapnZYX() {
        return this.mapnZYX(this);
    }

    public Matrix4x3f mapnZYX(Matrix4x3f matrix4x3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix4x3f._m00(-this.m20)._m01(-this.m21)._m02(-this.m22)._m10(this.m10)._m11(this.m11)._m12(this.m12)._m20(f2)._m21(f3)._m22(f4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapnZYnX() {
        return this.mapnZYnX(this);
    }

    public Matrix4x3f mapnZYnX(Matrix4x3f matrix4x3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix4x3f._m00(-this.m20)._m01(-this.m21)._m02(-this.m22)._m10(this.m10)._m11(this.m11)._m12(this.m12)._m20(-f2)._m21(-f3)._m22(-f4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapnZnXY() {
        return this.mapnZnXY(this);
    }

    public Matrix4x3f mapnZnXY(Matrix4x3f matrix4x3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        float f5 = this.m10;
        float f6 = this.m11;
        float f7 = this.m12;
        return matrix4x3f._m00(-this.m20)._m01(-this.m21)._m02(-this.m22)._m10(-f2)._m11(-f3)._m12(-f4)._m20(f5)._m21(f6)._m22(f7)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapnZnXnY() {
        return this.mapnZnXnY(this);
    }

    public Matrix4x3f mapnZnXnY(Matrix4x3f matrix4x3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        float f5 = this.m10;
        float f6 = this.m11;
        float f7 = this.m12;
        return matrix4x3f._m00(-this.m20)._m01(-this.m21)._m02(-this.m22)._m10(-f2)._m11(-f3)._m12(-f4)._m20(-f5)._m21(-f6)._m22(-f7)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapnZnYX() {
        return this.mapnZnYX(this);
    }

    public Matrix4x3f mapnZnYX(Matrix4x3f matrix4x3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix4x3f._m00(-this.m20)._m01(-this.m21)._m02(-this.m22)._m10(-this.m10)._m11(-this.m11)._m12(-this.m12)._m20(f2)._m21(f3)._m22(f4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f mapnZnYnX() {
        return this.mapnZnYnX(this);
    }

    public Matrix4x3f mapnZnYnX(Matrix4x3f matrix4x3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix4x3f._m00(-this.m20)._m01(-this.m21)._m02(-this.m22)._m10(-this.m10)._m11(-this.m11)._m12(-this.m12)._m20(-f2)._m21(-f3)._m22(-f4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f negateX() {
        return this._m00(-this.m00)._m01(-this.m01)._m02(-this.m02)._properties(this.properties & 0x10);
    }

    public Matrix4x3f negateX(Matrix4x3f matrix4x3f) {
        return matrix4x3f._m00(-this.m00)._m01(-this.m01)._m02(-this.m02)._m10(this.m10)._m11(this.m11)._m12(this.m12)._m20(this.m20)._m21(this.m21)._m22(this.m22)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f negateY() {
        return this._m10(-this.m10)._m11(-this.m11)._m12(-this.m12)._properties(this.properties & 0x10);
    }

    public Matrix4x3f negateY(Matrix4x3f matrix4x3f) {
        return matrix4x3f._m00(this.m00)._m01(this.m01)._m02(this.m02)._m10(-this.m10)._m11(-this.m11)._m12(-this.m12)._m20(this.m20)._m21(this.m21)._m22(this.m22)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3f negateZ() {
        return this._m20(-this.m20)._m21(-this.m21)._m22(-this.m22)._properties(this.properties & 0x10);
    }

    public Matrix4x3f negateZ(Matrix4x3f matrix4x3f) {
        return matrix4x3f._m00(this.m00)._m01(this.m01)._m02(this.m02)._m10(this.m10)._m11(this.m11)._m12(this.m12)._m20(-this.m20)._m21(-this.m21)._m22(-this.m22)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public boolean isFinite() {
        return Math.isFinite(this.m00) && Math.isFinite(this.m01) && Math.isFinite(this.m02) && Math.isFinite(this.m10) && Math.isFinite(this.m11) && Math.isFinite(this.m12) && Math.isFinite(this.m20) && Math.isFinite(this.m21) && Math.isFinite(this.m22) && Math.isFinite(this.m30) && Math.isFinite(this.m31) && Math.isFinite(this.m32);
    }

    public Object clone() {
        return super.clone();
    }
}

