/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.joml.Matrix4f;

public class Matrix4fStack
extends Matrix4f {
    private static final long serialVersionUID = 1L;
    private Matrix4f[] mats;
    private int curr;

    public Matrix4fStack(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("stackSize must be >= 1");
        }
        this.mats = new Matrix4f[n2 - 1];
        for (int i2 = 0; i2 < this.mats.length; ++i2) {
            this.mats[i2] = new Matrix4f();
        }
    }

    public Matrix4fStack() {
    }

    public Matrix4fStack clear() {
        this.curr = 0;
        this.identity();
        return this;
    }

    public Matrix4fStack pushMatrix() {
        if (this.curr == this.mats.length) {
            throw new IllegalStateException("max stack size of " + (this.curr + 1) + " reached");
        }
        this.mats[this.curr++].set(this);
        return this;
    }

    public Matrix4fStack popMatrix() {
        if (this.curr == 0) {
            throw new IllegalStateException("already at the bottom of the stack");
        }
        this.set(this.mats[--this.curr]);
        return this;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = super.hashCode();
        n3 = 31 * n3 + this.curr;
        for (int i2 = 0; i2 < this.curr; ++i2) {
            n3 = 31 * n3 + this.mats[i2].hashCode();
        }
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (object instanceof Matrix4fStack) {
            Matrix4fStack matrix4fStack = (Matrix4fStack)object;
            if (this.curr != matrix4fStack.curr) {
                return false;
            }
            for (int i2 = 0; i2 < this.curr; ++i2) {
                if (this.mats[i2].equals(matrix4fStack.mats[i2])) continue;
                return false;
            }
        }
        return true;
    }

    public void writeExternal(ObjectOutput objectOutput) {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(this.curr);
        for (int i2 = 0; i2 < this.curr; ++i2) {
            objectOutput.writeObject(this.mats[i2]);
        }
    }

    public void readExternal(ObjectInput objectInput) {
        super.readExternal(objectInput);
        this.curr = objectInput.readInt();
        this.mats = new Matrix4fStack[this.curr];
        for (int i2 = 0; i2 < this.curr; ++i2) {
            Matrix4f matrix4f = new Matrix4f();
            matrix4f.readExternal(objectInput);
            this.mats[i2] = matrix4f;
        }
    }

    public Object clone() {
        Matrix4fStack matrix4fStack = (Matrix4fStack)super.clone();
        Matrix4f[] matrix4fArray = new Matrix4f[this.mats.length];
        for (int i2 = 0; i2 < this.mats.length; ++i2) {
            matrix4fArray[i2] = (Matrix4f)this.mats[i2].clone();
        }
        matrix4fStack.mats = matrix4fArray;
        return matrix4fStack;
    }
}

