/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.text.NumberFormat;
import org.joml.Math;
import org.joml.Matrix2f;
import org.joml.Matrix2fc;
import org.joml.Matrix3x2fc;
import org.joml.MemUtil;
import org.joml.MemUtil$MemUtilUnsafe;
import org.joml.Options;
import org.joml.Runtime;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;

public class Matrix3x2f
implements Externalizable,
Cloneable,
Matrix3x2fc {
    private static final long serialVersionUID = 1L;
    public float m00;
    public float m01;
    public float m10;
    public float m11;
    public float m20;
    public float m21;

    public Matrix3x2f() {
        this.m00 = 1.0f;
        this.m11 = 1.0f;
    }

    public Matrix3x2f(Matrix3x2fc matrix3x2fc) {
        if (matrix3x2fc instanceof Matrix3x2f) {
            MemUtil.INSTANCE.copy((Matrix3x2f)matrix3x2fc, this);
        } else {
            this.setMatrix3x2fc(matrix3x2fc);
        }
    }

    public Matrix3x2f(Matrix2fc matrix2fc) {
        if (matrix2fc instanceof Matrix2f) {
            MemUtil.INSTANCE.copy((Matrix2f)matrix2fc, this);
        } else {
            this.setMatrix2fc(matrix2fc);
        }
    }

    public Matrix3x2f(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.m00 = f2;
        this.m01 = f3;
        this.m10 = f4;
        this.m11 = f5;
        this.m20 = f6;
        this.m21 = f7;
    }

    public Matrix3x2f(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, floatBuffer.position(), floatBuffer);
    }

    public float m00() {
        return this.m00;
    }

    public float m01() {
        return this.m01;
    }

    public float m10() {
        return this.m10;
    }

    public float m11() {
        return this.m11;
    }

    public float m20() {
        return this.m20;
    }

    public float m21() {
        return this.m21;
    }

    Matrix3x2f _m00(float f2) {
        this.m00 = f2;
        return this;
    }

    Matrix3x2f _m01(float f2) {
        this.m01 = f2;
        return this;
    }

    Matrix3x2f _m10(float f2) {
        this.m10 = f2;
        return this;
    }

    Matrix3x2f _m11(float f2) {
        this.m11 = f2;
        return this;
    }

    Matrix3x2f _m20(float f2) {
        this.m20 = f2;
        return this;
    }

    Matrix3x2f _m21(float f2) {
        this.m21 = f2;
        return this;
    }

    public Matrix3x2f set(Matrix3x2fc matrix3x2fc) {
        if (matrix3x2fc instanceof Matrix3x2f) {
            MemUtil.INSTANCE.copy((Matrix3x2f)matrix3x2fc, this);
        } else {
            this.setMatrix3x2fc(matrix3x2fc);
        }
        return this;
    }

    private void setMatrix3x2fc(Matrix3x2fc matrix3x2fc) {
        this.m00 = matrix3x2fc.m00();
        this.m01 = matrix3x2fc.m01();
        this.m10 = matrix3x2fc.m10();
        this.m11 = matrix3x2fc.m11();
        this.m20 = matrix3x2fc.m20();
        this.m21 = matrix3x2fc.m21();
    }

    public Matrix3x2f set(Matrix2fc matrix2fc) {
        if (matrix2fc instanceof Matrix2f) {
            MemUtil.INSTANCE.copy((Matrix2f)matrix2fc, this);
        } else {
            this.setMatrix2fc(matrix2fc);
        }
        return this;
    }

    private void setMatrix2fc(Matrix2fc matrix2fc) {
        this.m00 = matrix2fc.m00();
        this.m01 = matrix2fc.m01();
        this.m10 = matrix2fc.m10();
        this.m11 = matrix2fc.m11();
    }

    public Matrix3x2f mul(Matrix3x2fc matrix3x2fc) {
        return this.mul(matrix3x2fc, this);
    }

    public Matrix3x2f mul(Matrix3x2fc matrix3x2fc, Matrix3x2f matrix3x2f) {
        float f2 = this.m00 * matrix3x2fc.m00() + this.m10 * matrix3x2fc.m01();
        float f3 = this.m01 * matrix3x2fc.m00() + this.m11 * matrix3x2fc.m01();
        float f4 = this.m00 * matrix3x2fc.m10() + this.m10 * matrix3x2fc.m11();
        float f5 = this.m01 * matrix3x2fc.m10() + this.m11 * matrix3x2fc.m11();
        float f6 = this.m00 * matrix3x2fc.m20() + this.m10 * matrix3x2fc.m21() + this.m20;
        float f7 = this.m01 * matrix3x2fc.m20() + this.m11 * matrix3x2fc.m21() + this.m21;
        matrix3x2f.m00 = f2;
        matrix3x2f.m01 = f3;
        matrix3x2f.m10 = f4;
        matrix3x2f.m11 = f5;
        matrix3x2f.m20 = f6;
        matrix3x2f.m21 = f7;
        return matrix3x2f;
    }

    public Matrix3x2f mulLocal(Matrix3x2fc matrix3x2fc) {
        return this.mulLocal(matrix3x2fc, this);
    }

    public Matrix3x2f mulLocal(Matrix3x2fc matrix3x2fc, Matrix3x2f matrix3x2f) {
        float f2 = matrix3x2fc.m00() * this.m00 + matrix3x2fc.m10() * this.m01;
        float f3 = matrix3x2fc.m01() * this.m00 + matrix3x2fc.m11() * this.m01;
        float f4 = matrix3x2fc.m00() * this.m10 + matrix3x2fc.m10() * this.m11;
        float f5 = matrix3x2fc.m01() * this.m10 + matrix3x2fc.m11() * this.m11;
        float f6 = matrix3x2fc.m00() * this.m20 + matrix3x2fc.m10() * this.m21 + matrix3x2fc.m20();
        float f7 = matrix3x2fc.m01() * this.m20 + matrix3x2fc.m11() * this.m21 + matrix3x2fc.m21();
        matrix3x2f.m00 = f2;
        matrix3x2f.m01 = f3;
        matrix3x2f.m10 = f4;
        matrix3x2f.m11 = f5;
        matrix3x2f.m20 = f6;
        matrix3x2f.m21 = f7;
        return matrix3x2f;
    }

    public Matrix3x2f set(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.m00 = f2;
        this.m01 = f3;
        this.m10 = f4;
        this.m11 = f5;
        this.m20 = f6;
        this.m21 = f7;
        return this;
    }

    public Matrix3x2f set(float[] fArray) {
        MemUtil.INSTANCE.copy(fArray, 0, this);
        return this;
    }

    public float determinant() {
        return this.m00 * this.m11 - this.m01 * this.m10;
    }

    public Matrix3x2f invert() {
        return this.invert(this);
    }

    public Matrix3x2f invert(Matrix3x2f matrix3x2f) {
        float f2 = 1.0f / (this.m00 * this.m11 - this.m01 * this.m10);
        float f3 = this.m11 * f2;
        float f4 = -this.m01 * f2;
        float f5 = -this.m10 * f2;
        float f6 = this.m00 * f2;
        float f7 = (this.m10 * this.m21 - this.m20 * this.m11) * f2;
        float f8 = (this.m20 * this.m01 - this.m00 * this.m21) * f2;
        matrix3x2f.m00 = f3;
        matrix3x2f.m01 = f4;
        matrix3x2f.m10 = f5;
        matrix3x2f.m11 = f6;
        matrix3x2f.m20 = f7;
        matrix3x2f.m21 = f8;
        return matrix3x2f;
    }

    public Matrix3x2f translation(float f2, float f3) {
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m20 = f2;
        this.m21 = f3;
        return this;
    }

    public Matrix3x2f translation(Vector2fc vector2fc) {
        return this.translation(vector2fc.x(), vector2fc.y());
    }

    public Matrix3x2f setTranslation(float f2, float f3) {
        this.m20 = f2;
        this.m21 = f3;
        return this;
    }

    public Matrix3x2f setTranslation(Vector2f vector2f) {
        return this.setTranslation(vector2f.x, vector2f.y);
    }

    public Matrix3x2f translate(float f2, float f3, Matrix3x2f matrix3x2f) {
        float f4 = f2;
        float f5 = f3;
        matrix3x2f.m20 = this.m00 * f4 + this.m10 * f5 + this.m20;
        matrix3x2f.m21 = this.m01 * f4 + this.m11 * f5 + this.m21;
        matrix3x2f.m00 = this.m00;
        matrix3x2f.m01 = this.m01;
        matrix3x2f.m10 = this.m10;
        matrix3x2f.m11 = this.m11;
        return matrix3x2f;
    }

    public Matrix3x2f translate(float f2, float f3) {
        return this.translate(f2, f3, this);
    }

    public Matrix3x2f translate(Vector2fc vector2fc, Matrix3x2f matrix3x2f) {
        return this.translate(vector2fc.x(), vector2fc.y(), matrix3x2f);
    }

    public Matrix3x2f translate(Vector2fc vector2fc) {
        return this.translate(vector2fc.x(), vector2fc.y(), this);
    }

    public Matrix3x2f translateLocal(Vector2fc vector2fc) {
        return this.translateLocal(vector2fc.x(), vector2fc.y());
    }

    public Matrix3x2f translateLocal(Vector2fc vector2fc, Matrix3x2f matrix3x2f) {
        return this.translateLocal(vector2fc.x(), vector2fc.y(), matrix3x2f);
    }

    public Matrix3x2f translateLocal(float f2, float f3, Matrix3x2f matrix3x2f) {
        matrix3x2f.m00 = this.m00;
        matrix3x2f.m01 = this.m01;
        matrix3x2f.m10 = this.m10;
        matrix3x2f.m11 = this.m11;
        matrix3x2f.m20 = this.m20 + f2;
        matrix3x2f.m21 = this.m21 + f3;
        return matrix3x2f;
    }

    public Matrix3x2f translateLocal(float f2, float f3) {
        return this.translateLocal(f2, f3, this);
    }

    public String toString() {
        String string = this.toString(Options.NUMBER_FORMAT);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = Integer.MIN_VALUE;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == 'E') {
                n2 = i2;
            } else {
                if (c2 == ' ' && n2 == i2 - 1) {
                    stringBuffer.append('+');
                    continue;
                }
                if (Character.isDigit(c2) && n2 == i2 - 1) {
                    stringBuffer.append('+');
                }
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public String toString(NumberFormat numberFormat) {
        return Runtime.format(this.m00, numberFormat) + " " + Runtime.format(this.m10, numberFormat) + " " + Runtime.format(this.m20, numberFormat) + "\n" + Runtime.format(this.m01, numberFormat) + " " + Runtime.format(this.m11, numberFormat) + " " + Runtime.format(this.m21, numberFormat) + "\n";
    }

    public Matrix3x2f get(Matrix3x2f matrix3x2f) {
        return matrix3x2f.set(this);
    }

    public FloatBuffer get(FloatBuffer floatBuffer) {
        return this.get(floatBuffer.position(), floatBuffer);
    }

    public FloatBuffer get(int n2, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put(this, n2, floatBuffer);
        return floatBuffer;
    }

    public ByteBuffer get(ByteBuffer byteBuffer) {
        return this.get(byteBuffer.position(), byteBuffer);
    }

    public ByteBuffer get(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, n2, byteBuffer);
        return byteBuffer;
    }

    public FloatBuffer get3x3(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put3x3(this, 0, floatBuffer);
        return floatBuffer;
    }

    public FloatBuffer get3x3(int n2, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put3x3(this, n2, floatBuffer);
        return floatBuffer;
    }

    public ByteBuffer get3x3(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put3x3(this, 0, byteBuffer);
        return byteBuffer;
    }

    public ByteBuffer get3x3(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put3x3(this, n2, byteBuffer);
        return byteBuffer;
    }

    public FloatBuffer get4x4(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put4x4(this, 0, floatBuffer);
        return floatBuffer;
    }

    public FloatBuffer get4x4(int n2, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put4x4(this, n2, floatBuffer);
        return floatBuffer;
    }

    public ByteBuffer get4x4(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put4x4(this, 0, byteBuffer);
        return byteBuffer;
    }

    public ByteBuffer get4x4(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put4x4(this, n2, byteBuffer);
        return byteBuffer;
    }

    public Matrix3x2fc getToAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil$MemUtilUnsafe.put(this, l2);
        return this;
    }

    public float[] get(float[] fArray, int n2) {
        MemUtil.INSTANCE.copy(this, fArray, n2);
        return fArray;
    }

    public float[] get(float[] fArray) {
        return this.get(fArray, 0);
    }

    public float[] get3x3(float[] fArray, int n2) {
        MemUtil.INSTANCE.copy3x3(this, fArray, n2);
        return fArray;
    }

    public float[] get3x3(float[] fArray) {
        return this.get3x3(fArray, 0);
    }

    public float[] get4x4(float[] fArray, int n2) {
        MemUtil.INSTANCE.copy4x4(this, fArray, n2);
        return fArray;
    }

    public float[] get4x4(float[] fArray) {
        return this.get4x4(fArray, 0);
    }

    public Matrix3x2f set(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, floatBuffer.position(), floatBuffer);
        return this;
    }

    public Matrix3x2f set(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
        return this;
    }

    public Matrix3x2f set(int n2, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, n2, floatBuffer);
        return this;
    }

    public Matrix3x2f set(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n2, byteBuffer);
        return this;
    }

    public Matrix3x2f setFromAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil$MemUtilUnsafe.get(this, l2);
        return this;
    }

    public Matrix3x2f zero() {
        MemUtil.INSTANCE.zero(this);
        return this;
    }

    public Matrix3x2f identity() {
        MemUtil.INSTANCE.identity(this);
        return this;
    }

    public Matrix3x2f scale(float f2, float f3, Matrix3x2f matrix3x2f) {
        matrix3x2f.m00 = this.m00 * f2;
        matrix3x2f.m01 = this.m01 * f2;
        matrix3x2f.m10 = this.m10 * f3;
        matrix3x2f.m11 = this.m11 * f3;
        matrix3x2f.m20 = this.m20;
        matrix3x2f.m21 = this.m21;
        return matrix3x2f;
    }

    public Matrix3x2f scale(float f2, float f3) {
        return this.scale(f2, f3, this);
    }

    public Matrix3x2f scale(Vector2fc vector2fc) {
        return this.scale(vector2fc.x(), vector2fc.y(), this);
    }

    public Matrix3x2f scale(Vector2fc vector2fc, Matrix3x2f matrix3x2f) {
        return this.scale(vector2fc.x(), vector2fc.y(), matrix3x2f);
    }

    public Matrix3x2f scale(float f2, Matrix3x2f matrix3x2f) {
        return this.scale(f2, f2, matrix3x2f);
    }

    public Matrix3x2f scale(float f2) {
        return this.scale(f2, f2);
    }

    public Matrix3x2f scaleLocal(float f2, float f3, Matrix3x2f matrix3x2f) {
        matrix3x2f.m00 = f2 * this.m00;
        matrix3x2f.m01 = f3 * this.m01;
        matrix3x2f.m10 = f2 * this.m10;
        matrix3x2f.m11 = f3 * this.m11;
        matrix3x2f.m20 = f2 * this.m20;
        matrix3x2f.m21 = f3 * this.m21;
        return matrix3x2f;
    }

    public Matrix3x2f scaleLocal(float f2, float f3) {
        return this.scaleLocal(f2, f3, this);
    }

    public Matrix3x2f scaleLocal(float f2, Matrix3x2f matrix3x2f) {
        return this.scaleLocal(f2, f2, matrix3x2f);
    }

    public Matrix3x2f scaleLocal(float f2) {
        return this.scaleLocal(f2, f2, this);
    }

    public Matrix3x2f scaleAround(float f2, float f3, float f4, float f5, Matrix3x2f matrix3x2f) {
        float f6 = this.m00 * f4 + this.m10 * f5 + this.m20;
        float f7 = this.m01 * f4 + this.m11 * f5 + this.m21;
        matrix3x2f.m00 = this.m00 * f2;
        matrix3x2f.m01 = this.m01 * f2;
        matrix3x2f.m10 = this.m10 * f3;
        matrix3x2f.m11 = this.m11 * f3;
        matrix3x2f.m20 = matrix3x2f.m00 * -f4 + matrix3x2f.m10 * -f5 + f6;
        matrix3x2f.m21 = matrix3x2f.m01 * -f4 + matrix3x2f.m11 * -f5 + f7;
        return matrix3x2f;
    }

    public Matrix3x2f scaleAround(float f2, float f3, float f4, float f5) {
        return this.scaleAround(f2, f3, f4, f5, this);
    }

    public Matrix3x2f scaleAround(float f2, float f3, float f4, Matrix3x2f matrix3x2f) {
        return this.scaleAround(f2, f2, f3, f4, this);
    }

    public Matrix3x2f scaleAround(float f2, float f3, float f4) {
        return this.scaleAround(f2, f2, f3, f4, this);
    }

    public Matrix3x2f scaleAroundLocal(float f2, float f3, float f4, float f5, Matrix3x2f matrix3x2f) {
        matrix3x2f.m00 = f2 * this.m00;
        matrix3x2f.m01 = f3 * this.m01;
        matrix3x2f.m10 = f2 * this.m10;
        matrix3x2f.m11 = f3 * this.m11;
        matrix3x2f.m20 = f2 * this.m20 - f2 * f4 + f4;
        matrix3x2f.m21 = f3 * this.m21 - f3 * f5 + f5;
        return matrix3x2f;
    }

    public Matrix3x2f scaleAroundLocal(float f2, float f3, float f4, Matrix3x2f matrix3x2f) {
        return this.scaleAroundLocal(f2, f2, f3, f4, matrix3x2f);
    }

    public Matrix3x2f scaleAroundLocal(float f2, float f3, float f4, float f5, float f6, float f7) {
        return this.scaleAroundLocal(f2, f3, f5, f6, this);
    }

    public Matrix3x2f scaleAroundLocal(float f2, float f3, float f4) {
        return this.scaleAroundLocal(f2, f2, f3, f4, this);
    }

    public Matrix3x2f scaling(float f2) {
        return this.scaling(f2, f2);
    }

    public Matrix3x2f scaling(float f2, float f3) {
        this.m00 = f2;
        this.m01 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = f3;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        return this;
    }

    public Matrix3x2f rotation(float f2) {
        float f3 = Math.cos(f2);
        float f4 = Math.sin(f2);
        this.m00 = f3;
        this.m10 = -f4;
        this.m20 = 0.0f;
        this.m01 = f4;
        this.m11 = f3;
        this.m21 = 0.0f;
        return this;
    }

    public Vector3f transform(Vector3f vector3f) {
        return vector3f.mul(this);
    }

    public Vector3f transform(Vector3f vector3f, Vector3f vector3f2) {
        return vector3f.mul(this, vector3f2);
    }

    public Vector3f transform(float f2, float f3, float f4, Vector3f vector3f) {
        return vector3f.set(this.m00 * f2 + this.m10 * f3 + this.m20 * f4, this.m01 * f2 + this.m11 * f3 + this.m21 * f4, f4);
    }

    public Vector2f transformPosition(Vector2f vector2f) {
        vector2f.set(this.m00 * vector2f.x + this.m10 * vector2f.y + this.m20, this.m01 * vector2f.x + this.m11 * vector2f.y + this.m21);
        return vector2f;
    }

    public Vector2f transformPosition(Vector2fc vector2fc, Vector2f vector2f) {
        vector2f.set(this.m00 * vector2fc.x() + this.m10 * vector2fc.y() + this.m20, this.m01 * vector2fc.x() + this.m11 * vector2fc.y() + this.m21);
        return vector2f;
    }

    public Vector2f transformPosition(float f2, float f3, Vector2f vector2f) {
        return vector2f.set(this.m00 * f2 + this.m10 * f3 + this.m20, this.m01 * f2 + this.m11 * f3 + this.m21);
    }

    public Vector2f transformDirection(Vector2f vector2f) {
        vector2f.set(this.m00 * vector2f.x + this.m10 * vector2f.y, this.m01 * vector2f.x + this.m11 * vector2f.y);
        return vector2f;
    }

    public Vector2f transformDirection(Vector2fc vector2fc, Vector2f vector2f) {
        vector2f.set(this.m00 * vector2fc.x() + this.m10 * vector2fc.y(), this.m01 * vector2fc.x() + this.m11 * vector2fc.y());
        return vector2f;
    }

    public Vector2f transformDirection(float f2, float f3, Vector2f vector2f) {
        return vector2f.set(this.m00 * f2 + this.m10 * f3, this.m01 * f2 + this.m11 * f3);
    }

    public void writeExternal(ObjectOutput objectOutput) {
        objectOutput.writeFloat(this.m00);
        objectOutput.writeFloat(this.m01);
        objectOutput.writeFloat(this.m10);
        objectOutput.writeFloat(this.m11);
        objectOutput.writeFloat(this.m20);
        objectOutput.writeFloat(this.m21);
    }

    public void readExternal(ObjectInput objectInput) {
        this.m00 = objectInput.readFloat();
        this.m01 = objectInput.readFloat();
        this.m10 = objectInput.readFloat();
        this.m11 = objectInput.readFloat();
        this.m20 = objectInput.readFloat();
        this.m21 = objectInput.readFloat();
    }

    public Matrix3x2f rotate(float f2) {
        return this.rotate(f2, this);
    }

    public Matrix3x2f rotate(float f2, Matrix3x2f matrix3x2f) {
        float f3 = Math.cos(f2);
        float f4 = Math.sin(f2);
        float f5 = f3;
        float f6 = f4;
        float f7 = -f4;
        float f8 = f3;
        float f9 = this.m00 * f5 + this.m10 * f6;
        float f10 = this.m01 * f5 + this.m11 * f6;
        matrix3x2f.m10 = this.m00 * f7 + this.m10 * f8;
        matrix3x2f.m11 = this.m01 * f7 + this.m11 * f8;
        matrix3x2f.m00 = f9;
        matrix3x2f.m01 = f10;
        matrix3x2f.m20 = this.m20;
        matrix3x2f.m21 = this.m21;
        return matrix3x2f;
    }

    public Matrix3x2f rotateLocal(float f2, Matrix3x2f matrix3x2f) {
        float f3 = Math.sin(f2);
        float f4 = Math.cosFromSin(f3, f2);
        float f5 = f4 * this.m00 - f3 * this.m01;
        float f6 = f3 * this.m00 + f4 * this.m01;
        float f7 = f4 * this.m10 - f3 * this.m11;
        float f8 = f3 * this.m10 + f4 * this.m11;
        float f9 = f4 * this.m20 - f3 * this.m21;
        float f10 = f3 * this.m20 + f4 * this.m21;
        matrix3x2f.m00 = f5;
        matrix3x2f.m01 = f6;
        matrix3x2f.m10 = f7;
        matrix3x2f.m11 = f8;
        matrix3x2f.m20 = f9;
        matrix3x2f.m21 = f10;
        return matrix3x2f;
    }

    public Matrix3x2f rotateLocal(float f2) {
        return this.rotateLocal(f2, this);
    }

    public Matrix3x2f rotateAbout(float f2, float f3, float f4) {
        return this.rotateAbout(f2, f3, f4, this);
    }

    public Matrix3x2f rotateAbout(float f2, float f3, float f4, Matrix3x2f matrix3x2f) {
        float f5 = this.m00 * f3 + this.m10 * f4 + this.m20;
        float f6 = this.m01 * f3 + this.m11 * f4 + this.m21;
        float f7 = Math.cos(f2);
        float f8 = Math.sin(f2);
        float f9 = this.m00 * f7 + this.m10 * f8;
        float f10 = this.m01 * f7 + this.m11 * f8;
        matrix3x2f.m10 = this.m00 * -f8 + this.m10 * f7;
        matrix3x2f.m11 = this.m01 * -f8 + this.m11 * f7;
        matrix3x2f.m00 = f9;
        matrix3x2f.m01 = f10;
        matrix3x2f.m20 = matrix3x2f.m00 * -f3 + matrix3x2f.m10 * -f4 + f5;
        matrix3x2f.m21 = matrix3x2f.m01 * -f3 + matrix3x2f.m11 * -f4 + f6;
        return matrix3x2f;
    }

    public Matrix3x2f rotateTo(Vector2fc vector2fc, Vector2fc vector2fc2, Matrix3x2f matrix3x2f) {
        float f2 = vector2fc.x() * vector2fc2.x() + vector2fc.y() * vector2fc2.y();
        float f3 = vector2fc.x() * vector2fc2.y() - vector2fc.y() * vector2fc2.x();
        float f4 = f2;
        float f5 = f3;
        float f6 = -f3;
        float f7 = f2;
        float f8 = this.m00 * f4 + this.m10 * f5;
        float f9 = this.m01 * f4 + this.m11 * f5;
        matrix3x2f.m10 = this.m00 * f6 + this.m10 * f7;
        matrix3x2f.m11 = this.m01 * f6 + this.m11 * f7;
        matrix3x2f.m00 = f8;
        matrix3x2f.m01 = f9;
        matrix3x2f.m20 = this.m20;
        matrix3x2f.m21 = this.m21;
        return matrix3x2f;
    }

    public Matrix3x2f rotateTo(Vector2fc vector2fc, Vector2fc vector2fc2) {
        return this.rotateTo(vector2fc, vector2fc2, this);
    }

    public Matrix3x2f view(float f2, float f3, float f4, float f5, Matrix3x2f matrix3x2f) {
        float f6 = 2.0f / (f3 - f2);
        float f7 = 2.0f / (f5 - f4);
        float f8 = (f2 + f3) / (f2 - f3);
        float f9 = (f4 + f5) / (f4 - f5);
        matrix3x2f.m20 = this.m00 * f8 + this.m10 * f9 + this.m20;
        matrix3x2f.m21 = this.m01 * f8 + this.m11 * f9 + this.m21;
        matrix3x2f.m00 = this.m00 * f6;
        matrix3x2f.m01 = this.m01 * f6;
        matrix3x2f.m10 = this.m10 * f7;
        matrix3x2f.m11 = this.m11 * f7;
        return matrix3x2f;
    }

    public Matrix3x2f view(float f2, float f3, float f4, float f5) {
        return this.view(f2, f3, f4, f5, this);
    }

    public Matrix3x2f setView(float f2, float f3, float f4, float f5) {
        this.m00 = 2.0f / (f3 - f2);
        this.m01 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 2.0f / (f5 - f4);
        this.m20 = (f2 + f3) / (f2 - f3);
        this.m21 = (f4 + f5) / (f4 - f5);
        return this;
    }

    public Vector2f origin(Vector2f vector2f) {
        float f2 = 1.0f / (this.m00 * this.m11 - this.m01 * this.m10);
        vector2f.x = (this.m10 * this.m21 - this.m20 * this.m11) * f2;
        vector2f.y = (this.m20 * this.m01 - this.m00 * this.m21) * f2;
        return vector2f;
    }

    public float[] viewArea(float[] fArray) {
        float f2 = 1.0f / (this.m00 * this.m11 - this.m01 * this.m10);
        float f3 = this.m11 * f2;
        float f4 = -this.m01 * f2;
        float f5 = -this.m10 * f2;
        float f6 = this.m00 * f2;
        float f7 = (this.m10 * this.m21 - this.m20 * this.m11) * f2;
        float f8 = (this.m20 * this.m01 - this.m00 * this.m21) * f2;
        float f9 = -f3 - f5;
        float f10 = -f4 - f6;
        float f11 = f3 - f5;
        float f12 = f4 - f6;
        float f13 = -f3 + f5;
        float f14 = -f4 + f6;
        float f15 = f3 + f5;
        float f16 = f4 + f6;
        float f17 = f9;
        f17 = f17 < f13 ? f17 : f13;
        f17 = f17 < f11 ? f17 : f11;
        f17 = f17 < f15 ? f17 : f15;
        float f18 = f10;
        f18 = f18 < f14 ? f18 : f14;
        f18 = f18 < f12 ? f18 : f12;
        f18 = f18 < f16 ? f18 : f16;
        float f19 = f9;
        f19 = f19 > f13 ? f19 : f13;
        f19 = f19 > f11 ? f19 : f11;
        f19 = f19 > f15 ? f19 : f15;
        float f20 = f10;
        f20 = f20 > f14 ? f20 : f14;
        f20 = f20 > f12 ? f20 : f12;
        f20 = f20 > f16 ? f20 : f16;
        fArray[0] = f17 + f7;
        fArray[1] = f18 + f8;
        fArray[2] = f19 + f7;
        fArray[3] = f20 + f8;
        return fArray;
    }

    public Vector2f positiveX(Vector2f vector2f) {
        float f2 = this.m00 * this.m11 - this.m01 * this.m10;
        f2 = 1.0f / f2;
        vector2f.x = this.m11 * f2;
        vector2f.y = -this.m01 * f2;
        return vector2f.normalize(vector2f);
    }

    public Vector2f normalizedPositiveX(Vector2f vector2f) {
        vector2f.x = this.m11;
        vector2f.y = -this.m01;
        return vector2f;
    }

    public Vector2f positiveY(Vector2f vector2f) {
        float f2 = this.m00 * this.m11 - this.m01 * this.m10;
        f2 = 1.0f / f2;
        vector2f.x = -this.m10 * f2;
        vector2f.y = this.m00 * f2;
        return vector2f.normalize(vector2f);
    }

    public Vector2f normalizedPositiveY(Vector2f vector2f) {
        vector2f.x = -this.m10;
        vector2f.y = this.m00;
        return vector2f;
    }

    public Vector2f unproject(float f2, float f3, int[] nArray, Vector2f vector2f) {
        float f4 = 1.0f / (this.m00 * this.m11 - this.m01 * this.m10);
        float f5 = this.m11 * f4;
        float f6 = -this.m01 * f4;
        float f7 = -this.m10 * f4;
        float f8 = this.m00 * f4;
        float f9 = (this.m10 * this.m21 - this.m20 * this.m11) * f4;
        float f10 = (this.m20 * this.m01 - this.m00 * this.m21) * f4;
        float f11 = (f2 - (float)nArray[0]) / (float)nArray[2] * 2.0f - 1.0f;
        float f12 = (f3 - (float)nArray[1]) / (float)nArray[3] * 2.0f - 1.0f;
        vector2f.x = f5 * f11 + f7 * f12 + f9;
        vector2f.y = f6 * f11 + f8 * f12 + f10;
        return vector2f;
    }

    public Vector2f unprojectInv(float f2, float f3, int[] nArray, Vector2f vector2f) {
        float f4 = (f2 - (float)nArray[0]) / (float)nArray[2] * 2.0f - 1.0f;
        float f5 = (f3 - (float)nArray[1]) / (float)nArray[3] * 2.0f - 1.0f;
        vector2f.x = this.m00 * f4 + this.m10 * f5 + this.m20;
        vector2f.y = this.m01 * f4 + this.m11 * f5 + this.m21;
        return vector2f;
    }

    public Matrix3x2f shearX(float f2) {
        return this.shearX(f2, this);
    }

    public Matrix3x2f shearX(float f2, Matrix3x2f matrix3x2f) {
        float f3 = this.m00 * f2 + this.m10;
        float f4 = this.m01 * f2 + this.m11;
        matrix3x2f.m00 = this.m00;
        matrix3x2f.m01 = this.m01;
        matrix3x2f.m10 = f3;
        matrix3x2f.m11 = f4;
        matrix3x2f.m20 = this.m20;
        matrix3x2f.m21 = this.m21;
        return matrix3x2f;
    }

    public Matrix3x2f shearY(float f2) {
        return this.shearY(f2, this);
    }

    public Matrix3x2f shearY(float f2, Matrix3x2f matrix3x2f) {
        float f3 = this.m00 + this.m10 * f2;
        float f4 = this.m01 + this.m11 * f2;
        matrix3x2f.m00 = f3;
        matrix3x2f.m01 = f4;
        matrix3x2f.m10 = this.m10;
        matrix3x2f.m11 = this.m11;
        matrix3x2f.m20 = this.m20;
        matrix3x2f.m21 = this.m21;
        return matrix3x2f;
    }

    public Matrix3x2f span(Vector2f vector2f, Vector2f vector2f2, Vector2f vector2f3) {
        float f2 = 1.0f / (this.m00 * this.m11 - this.m01 * this.m10);
        float f3 = this.m11 * f2;
        float f4 = -this.m01 * f2;
        float f5 = -this.m10 * f2;
        float f6 = this.m00 * f2;
        vector2f.x = -f3 - f5 + (this.m10 * this.m21 - this.m20 * this.m11) * f2;
        vector2f.y = -f4 - f6 + (this.m20 * this.m01 - this.m00 * this.m21) * f2;
        vector2f2.x = 2.0f * f3;
        vector2f2.y = 2.0f * f4;
        vector2f3.x = 2.0f * f5;
        vector2f3.y = 2.0f * f6;
        return this;
    }

    public boolean testPoint(float f2, float f3) {
        float f4 = this.m00;
        float f5 = this.m10;
        float f6 = 1.0f + this.m20;
        float f7 = -this.m00;
        float f8 = -this.m10;
        float f9 = 1.0f - this.m20;
        float f10 = this.m01;
        float f11 = this.m11;
        float f12 = 1.0f + this.m21;
        float f13 = -this.m01;
        float f14 = -this.m11;
        float f15 = 1.0f - this.m21;
        return f4 * f2 + f5 * f3 + f6 >= 0.0f && f7 * f2 + f8 * f3 + f9 >= 0.0f && f10 * f2 + f11 * f3 + f12 >= 0.0f && f13 * f2 + f14 * f3 + f15 >= 0.0f;
    }

    public boolean testCircle(float f2, float f3, float f4) {
        float f5 = this.m00;
        float f6 = this.m10;
        float f7 = 1.0f + this.m20;
        float f8 = Math.invsqrt(f5 * f5 + f6 * f6);
        f5 *= f8;
        f6 *= f8;
        f7 *= f8;
        float f9 = -this.m00;
        float f10 = -this.m10;
        float f11 = 1.0f - this.m20;
        f8 = Math.invsqrt(f9 * f9 + f10 * f10);
        f9 *= f8;
        f10 *= f8;
        f11 *= f8;
        float f12 = this.m01;
        float f13 = this.m11;
        float f14 = 1.0f + this.m21;
        f8 = Math.invsqrt(f12 * f12 + f13 * f13);
        f12 *= f8;
        f13 *= f8;
        f14 *= f8;
        float f15 = -this.m01;
        float f16 = -this.m11;
        float f17 = 1.0f - this.m21;
        f8 = Math.invsqrt(f15 * f15 + f16 * f16);
        return f5 * f2 + f6 * f3 + f7 >= -f4 && f9 * f2 + f10 * f3 + f11 >= -f4 && f12 * f2 + f13 * f3 + f14 >= -f4 && (f15 *= f8) * f2 + (f16 *= f8) * f3 + (f17 *= f8) >= -f4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean testAar(float f2, float f3, float f4, float f5) {
        float f6 = this.m00;
        float f7 = this.m10;
        float f8 = 1.0f + this.m20;
        float f9 = -this.m00;
        float f10 = -this.m10;
        float f11 = 1.0f - this.m20;
        float f12 = this.m01;
        float f13 = this.m11;
        float f14 = 1.0f + this.m21;
        float f15 = -this.m01;
        float f16 = -this.m11;
        float f17 = 1.0f - this.m21;
        float f18 = f6 * (f6 < 0.0f ? f2 : f4);
        float f19 = f7 < 0.0f ? f3 : f5;
        if (!(f18 + f7 * f19 >= -f8)) return false;
        float f20 = f9 * (f9 < 0.0f ? f2 : f4);
        float f21 = f10 < 0.0f ? f3 : f5;
        if (!(f20 + f10 * f21 >= -f11)) return false;
        float f22 = f12 * (f12 < 0.0f ? f2 : f4);
        float f23 = f13 < 0.0f ? f3 : f5;
        if (!(f22 + f13 * f23 >= -f14)) return false;
        float f24 = f15 * (f15 < 0.0f ? f2 : f4);
        float f25 = f16 < 0.0f ? f3 : f5;
        if (!(f24 + f16 * f25 >= -f17)) return false;
        return true;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + Float.floatToIntBits(this.m00);
        n3 = 31 * n3 + Float.floatToIntBits(this.m01);
        n3 = 31 * n3 + Float.floatToIntBits(this.m10);
        n3 = 31 * n3 + Float.floatToIntBits(this.m11);
        n3 = 31 * n3 + Float.floatToIntBits(this.m20);
        n3 = 31 * n3 + Float.floatToIntBits(this.m21);
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Matrix3x2f matrix3x2f = (Matrix3x2f)object;
        if (Float.floatToIntBits(this.m00) != Float.floatToIntBits(matrix3x2f.m00)) {
            return false;
        }
        if (Float.floatToIntBits(this.m01) != Float.floatToIntBits(matrix3x2f.m01)) {
            return false;
        }
        if (Float.floatToIntBits(this.m10) != Float.floatToIntBits(matrix3x2f.m10)) {
            return false;
        }
        if (Float.floatToIntBits(this.m11) != Float.floatToIntBits(matrix3x2f.m11)) {
            return false;
        }
        if (Float.floatToIntBits(this.m20) != Float.floatToIntBits(matrix3x2f.m20)) {
            return false;
        }
        return Float.floatToIntBits(this.m21) == Float.floatToIntBits(matrix3x2f.m21);
    }

    public boolean equals(Matrix3x2fc matrix3x2fc, float f2) {
        if (this == matrix3x2fc) {
            return true;
        }
        if (matrix3x2fc == null) {
            return false;
        }
        if (!(matrix3x2fc instanceof Matrix3x2f)) {
            return false;
        }
        if (!Runtime.equals(this.m00, matrix3x2fc.m00(), f2)) {
            return false;
        }
        if (!Runtime.equals(this.m01, matrix3x2fc.m01(), f2)) {
            return false;
        }
        if (!Runtime.equals(this.m10, matrix3x2fc.m10(), f2)) {
            return false;
        }
        if (!Runtime.equals(this.m11, matrix3x2fc.m11(), f2)) {
            return false;
        }
        if (!Runtime.equals(this.m20, matrix3x2fc.m20(), f2)) {
            return false;
        }
        return Runtime.equals(this.m21, matrix3x2fc.m21(), f2);
    }

    public boolean isFinite() {
        return Math.isFinite(this.m00) && Math.isFinite(this.m01) && Math.isFinite(this.m10) && Math.isFinite(this.m11) && Math.isFinite(this.m20) && Math.isFinite(this.m21);
    }

    public Object clone() {
        return super.clone();
    }
}

