/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.joml.Matrix3x2d;

public class Matrix3x2dStack
extends Matrix3x2d
implements Cloneable {
    private static final long serialVersionUID = 1L;
    private Matrix3x2d[] mats;
    private int curr;

    public Matrix3x2dStack(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("stackSize must be >= 1");
        }
        this.mats = new Matrix3x2d[n2 - 1];
        for (int i2 = 0; i2 < this.mats.length; ++i2) {
            this.mats[i2] = new Matrix3x2d();
        }
    }

    public Matrix3x2dStack() {
    }

    public Matrix3x2dStack clear() {
        this.curr = 0;
        this.identity();
        return this;
    }

    public Matrix3x2dStack pushMatrix() {
        if (this.curr == this.mats.length) {
            throw new IllegalStateException("max stack size of " + (this.curr + 1) + " reached");
        }
        this.mats[this.curr++].set(this);
        return this;
    }

    public Matrix3x2dStack popMatrix() {
        if (this.curr == 0) {
            throw new IllegalStateException("already at the bottom of the stack");
        }
        this.set(this.mats[--this.curr]);
        return this;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = super.hashCode();
        n3 = 31 * n3 + this.curr;
        for (int i2 = 0; i2 < this.curr; ++i2) {
            n3 = 31 * n3 + this.mats[i2].hashCode();
        }
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (object instanceof Matrix3x2dStack) {
            Matrix3x2dStack matrix3x2dStack = (Matrix3x2dStack)object;
            if (this.curr != matrix3x2dStack.curr) {
                return false;
            }
            for (int i2 = 0; i2 < this.curr; ++i2) {
                if (this.mats[i2].equals(matrix3x2dStack.mats[i2])) continue;
                return false;
            }
        }
        return true;
    }

    public void writeExternal(ObjectOutput objectOutput) {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(this.curr);
        for (int i2 = 0; i2 < this.curr; ++i2) {
            objectOutput.writeObject(this.mats[i2]);
        }
    }

    public void readExternal(ObjectInput objectInput) {
        super.readExternal(objectInput);
        this.curr = objectInput.readInt();
        this.mats = new Matrix3x2dStack[this.curr];
        for (int i2 = 0; i2 < this.curr; ++i2) {
            Matrix3x2d matrix3x2d = new Matrix3x2d();
            matrix3x2d.readExternal(objectInput);
            this.mats[i2] = matrix3x2d;
        }
    }

    public Object clone() {
        Matrix3x2dStack matrix3x2dStack = (Matrix3x2dStack)super.clone();
        Matrix3x2d[] matrix3x2dArray = new Matrix3x2d[this.mats.length];
        for (int i2 = 0; i2 < this.mats.length; ++i2) {
            matrix3x2dArray[i2] = (Matrix3x2d)this.mats[i2].clone();
        }
        matrix3x2dStack.mats = matrix3x2dArray;
        return matrix3x2dStack;
    }
}

