/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.text.NumberFormat;
import org.joml.Math;
import org.joml.Matrix2d;
import org.joml.Matrix2dc;
import org.joml.Matrix2fc;
import org.joml.Matrix3x2dc;
import org.joml.MemUtil;
import org.joml.MemUtil$MemUtilUnsafe;
import org.joml.Options;
import org.joml.Runtime;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector2fc;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class Matrix3x2d
implements Externalizable,
Cloneable,
Matrix3x2dc {
    private static final long serialVersionUID = 1L;
    public double m00;
    public double m01;
    public double m10;
    public double m11;
    public double m20;
    public double m21;

    public Matrix3x2d() {
        this.m00 = 1.0;
        this.m11 = 1.0;
    }

    public Matrix3x2d(Matrix2dc matrix2dc) {
        if (matrix2dc instanceof Matrix2d) {
            MemUtil.INSTANCE.copy((Matrix2d)matrix2dc, this);
        } else {
            this.setMatrix2dc(matrix2dc);
        }
    }

    public Matrix3x2d(Matrix2fc matrix2fc) {
        this.m00 = matrix2fc.m00();
        this.m01 = matrix2fc.m01();
        this.m10 = matrix2fc.m10();
        this.m11 = matrix2fc.m11();
    }

    public Matrix3x2d(Matrix3x2dc matrix3x2dc) {
        if (matrix3x2dc instanceof Matrix3x2d) {
            MemUtil.INSTANCE.copy((Matrix3x2d)matrix3x2dc, this);
        } else {
            this.setMatrix3x2dc(matrix3x2dc);
        }
    }

    public Matrix3x2d(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.m00 = d2;
        this.m01 = d3;
        this.m10 = d4;
        this.m11 = d5;
        this.m20 = d6;
        this.m21 = d7;
    }

    public Matrix3x2d(DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.get(this, doubleBuffer.position(), doubleBuffer);
    }

    public double m00() {
        return this.m00;
    }

    public double m01() {
        return this.m01;
    }

    public double m10() {
        return this.m10;
    }

    public double m11() {
        return this.m11;
    }

    public double m20() {
        return this.m20;
    }

    public double m21() {
        return this.m21;
    }

    Matrix3x2d _m00(double d2) {
        this.m00 = d2;
        return this;
    }

    Matrix3x2d _m01(double d2) {
        this.m01 = d2;
        return this;
    }

    Matrix3x2d _m10(double d2) {
        this.m10 = d2;
        return this;
    }

    Matrix3x2d _m11(double d2) {
        this.m11 = d2;
        return this;
    }

    Matrix3x2d _m20(double d2) {
        this.m20 = d2;
        return this;
    }

    Matrix3x2d _m21(double d2) {
        this.m21 = d2;
        return this;
    }

    public Matrix3x2d set(Matrix3x2dc matrix3x2dc) {
        if (matrix3x2dc instanceof Matrix3x2d) {
            MemUtil.INSTANCE.copy((Matrix3x2d)matrix3x2dc, this);
        } else {
            this.setMatrix3x2dc(matrix3x2dc);
        }
        return this;
    }

    private void setMatrix3x2dc(Matrix3x2dc matrix3x2dc) {
        this.m00 = matrix3x2dc.m00();
        this.m01 = matrix3x2dc.m01();
        this.m10 = matrix3x2dc.m10();
        this.m11 = matrix3x2dc.m11();
        this.m20 = matrix3x2dc.m20();
        this.m21 = matrix3x2dc.m21();
    }

    public Matrix3x2d set(Matrix2dc matrix2dc) {
        if (matrix2dc instanceof Matrix2d) {
            MemUtil.INSTANCE.copy((Matrix2d)matrix2dc, this);
        } else {
            this.setMatrix2dc(matrix2dc);
        }
        return this;
    }

    private void setMatrix2dc(Matrix2dc matrix2dc) {
        this.m00 = matrix2dc.m00();
        this.m01 = matrix2dc.m01();
        this.m10 = matrix2dc.m10();
        this.m11 = matrix2dc.m11();
    }

    public Matrix3x2d set(Matrix2fc matrix2fc) {
        this.m00 = matrix2fc.m00();
        this.m01 = matrix2fc.m01();
        this.m10 = matrix2fc.m10();
        this.m11 = matrix2fc.m11();
        return this;
    }

    public Matrix3x2d mul(Matrix3x2dc matrix3x2dc) {
        return this.mul(matrix3x2dc, this);
    }

    public Matrix3x2d mul(Matrix3x2dc matrix3x2dc, Matrix3x2d matrix3x2d) {
        double d2 = this.m00 * matrix3x2dc.m00() + this.m10 * matrix3x2dc.m01();
        double d3 = this.m01 * matrix3x2dc.m00() + this.m11 * matrix3x2dc.m01();
        double d4 = this.m00 * matrix3x2dc.m10() + this.m10 * matrix3x2dc.m11();
        double d5 = this.m01 * matrix3x2dc.m10() + this.m11 * matrix3x2dc.m11();
        double d6 = this.m00 * matrix3x2dc.m20() + this.m10 * matrix3x2dc.m21() + this.m20;
        double d7 = this.m01 * matrix3x2dc.m20() + this.m11 * matrix3x2dc.m21() + this.m21;
        matrix3x2d.m00 = d2;
        matrix3x2d.m01 = d3;
        matrix3x2d.m10 = d4;
        matrix3x2d.m11 = d5;
        matrix3x2d.m20 = d6;
        matrix3x2d.m21 = d7;
        return matrix3x2d;
    }

    public Matrix3x2d mulLocal(Matrix3x2dc matrix3x2dc) {
        return this.mulLocal(matrix3x2dc, this);
    }

    public Matrix3x2d mulLocal(Matrix3x2dc matrix3x2dc, Matrix3x2d matrix3x2d) {
        double d2 = matrix3x2dc.m00() * this.m00 + matrix3x2dc.m10() * this.m01;
        double d3 = matrix3x2dc.m01() * this.m00 + matrix3x2dc.m11() * this.m01;
        double d4 = matrix3x2dc.m00() * this.m10 + matrix3x2dc.m10() * this.m11;
        double d5 = matrix3x2dc.m01() * this.m10 + matrix3x2dc.m11() * this.m11;
        double d6 = matrix3x2dc.m00() * this.m20 + matrix3x2dc.m10() * this.m21 + matrix3x2dc.m20();
        double d7 = matrix3x2dc.m01() * this.m20 + matrix3x2dc.m11() * this.m21 + matrix3x2dc.m21();
        matrix3x2d.m00 = d2;
        matrix3x2d.m01 = d3;
        matrix3x2d.m10 = d4;
        matrix3x2d.m11 = d5;
        matrix3x2d.m20 = d6;
        matrix3x2d.m21 = d7;
        return matrix3x2d;
    }

    public Matrix3x2d set(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.m00 = d2;
        this.m01 = d3;
        this.m10 = d4;
        this.m11 = d5;
        this.m20 = d6;
        this.m21 = d7;
        return this;
    }

    public Matrix3x2d set(double[] dArray) {
        MemUtil.INSTANCE.copy(dArray, 0, this);
        return this;
    }

    public double determinant() {
        return this.m00 * this.m11 - this.m01 * this.m10;
    }

    public Matrix3x2d invert() {
        return this.invert(this);
    }

    public Matrix3x2d invert(Matrix3x2d matrix3x2d) {
        double d2 = 1.0 / (this.m00 * this.m11 - this.m01 * this.m10);
        double d3 = this.m11 * d2;
        double d4 = -this.m01 * d2;
        double d5 = -this.m10 * d2;
        double d6 = this.m00 * d2;
        double d7 = (this.m10 * this.m21 - this.m20 * this.m11) * d2;
        double d8 = (this.m20 * this.m01 - this.m00 * this.m21) * d2;
        matrix3x2d.m00 = d3;
        matrix3x2d.m01 = d4;
        matrix3x2d.m10 = d5;
        matrix3x2d.m11 = d6;
        matrix3x2d.m20 = d7;
        matrix3x2d.m21 = d8;
        return matrix3x2d;
    }

    public Matrix3x2d translation(double d2, double d3) {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m20 = d2;
        this.m21 = d3;
        return this;
    }

    public Matrix3x2d translation(Vector2dc vector2dc) {
        return this.translation(vector2dc.x(), vector2dc.y());
    }

    public Matrix3x2d setTranslation(double d2, double d3) {
        this.m20 = d2;
        this.m21 = d3;
        return this;
    }

    public Matrix3x2d setTranslation(Vector2dc vector2dc) {
        return this.setTranslation(vector2dc.x(), vector2dc.y());
    }

    public Matrix3x2d translate(double d2, double d3, Matrix3x2d matrix3x2d) {
        double d4 = d2;
        double d5 = d3;
        matrix3x2d.m20 = this.m00 * d4 + this.m10 * d5 + this.m20;
        matrix3x2d.m21 = this.m01 * d4 + this.m11 * d5 + this.m21;
        matrix3x2d.m00 = this.m00;
        matrix3x2d.m01 = this.m01;
        matrix3x2d.m10 = this.m10;
        matrix3x2d.m11 = this.m11;
        return matrix3x2d;
    }

    public Matrix3x2d translate(double d2, double d3) {
        return this.translate(d2, d3, this);
    }

    public Matrix3x2d translate(Vector2dc vector2dc, Matrix3x2d matrix3x2d) {
        return this.translate(vector2dc.x(), vector2dc.y(), matrix3x2d);
    }

    public Matrix3x2d translate(Vector2dc vector2dc) {
        return this.translate(vector2dc.x(), vector2dc.y(), this);
    }

    public Matrix3x2d translateLocal(Vector2dc vector2dc) {
        return this.translateLocal(vector2dc.x(), vector2dc.y());
    }

    public Matrix3x2d translateLocal(Vector2dc vector2dc, Matrix3x2d matrix3x2d) {
        return this.translateLocal(vector2dc.x(), vector2dc.y(), matrix3x2d);
    }

    public Matrix3x2d translateLocal(double d2, double d3, Matrix3x2d matrix3x2d) {
        matrix3x2d.m00 = this.m00;
        matrix3x2d.m01 = this.m01;
        matrix3x2d.m10 = this.m10;
        matrix3x2d.m11 = this.m11;
        matrix3x2d.m20 = this.m20 + d2;
        matrix3x2d.m21 = this.m21 + d3;
        return matrix3x2d;
    }

    public Matrix3x2d translateLocal(double d2, double d3) {
        return this.translateLocal(d2, d3, this);
    }

    public String toString() {
        String string = this.toString(Options.NUMBER_FORMAT);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = Integer.MIN_VALUE;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == 'E') {
                n2 = i2;
            } else {
                if (c2 == ' ' && n2 == i2 - 1) {
                    stringBuffer.append('+');
                    continue;
                }
                if (Character.isDigit(c2) && n2 == i2 - 1) {
                    stringBuffer.append('+');
                }
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public String toString(NumberFormat numberFormat) {
        return Runtime.format(this.m00, numberFormat) + " " + Runtime.format(this.m10, numberFormat) + " " + Runtime.format(this.m20, numberFormat) + "\n" + Runtime.format(this.m01, numberFormat) + " " + Runtime.format(this.m11, numberFormat) + " " + Runtime.format(this.m21, numberFormat) + "\n";
    }

    public Matrix3x2d get(Matrix3x2d matrix3x2d) {
        return matrix3x2d.set(this);
    }

    public DoubleBuffer get(DoubleBuffer doubleBuffer) {
        return this.get(doubleBuffer.position(), doubleBuffer);
    }

    public DoubleBuffer get(int n2, DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.put(this, n2, doubleBuffer);
        return doubleBuffer;
    }

    public ByteBuffer get(ByteBuffer byteBuffer) {
        return this.get(byteBuffer.position(), byteBuffer);
    }

    public ByteBuffer get(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, n2, byteBuffer);
        return byteBuffer;
    }

    public DoubleBuffer get3x3(DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.put3x3(this, 0, doubleBuffer);
        return doubleBuffer;
    }

    public DoubleBuffer get3x3(int n2, DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.put3x3(this, n2, doubleBuffer);
        return doubleBuffer;
    }

    public ByteBuffer get3x3(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put3x3(this, 0, byteBuffer);
        return byteBuffer;
    }

    public ByteBuffer get3x3(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put3x3(this, n2, byteBuffer);
        return byteBuffer;
    }

    public DoubleBuffer get4x4(DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.put4x4(this, 0, doubleBuffer);
        return doubleBuffer;
    }

    public DoubleBuffer get4x4(int n2, DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.put4x4(this, n2, doubleBuffer);
        return doubleBuffer;
    }

    public ByteBuffer get4x4(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put4x4(this, 0, byteBuffer);
        return byteBuffer;
    }

    public ByteBuffer get4x4(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put4x4(this, n2, byteBuffer);
        return byteBuffer;
    }

    public DoubleBuffer getTransposed(DoubleBuffer doubleBuffer) {
        return this.getTransposed(doubleBuffer.position(), doubleBuffer);
    }

    public DoubleBuffer getTransposed(int n2, DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.putTransposed(this, n2, doubleBuffer);
        return doubleBuffer;
    }

    public ByteBuffer getTransposed(ByteBuffer byteBuffer) {
        return this.getTransposed(byteBuffer.position(), byteBuffer);
    }

    public ByteBuffer getTransposed(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.putTransposed(this, n2, byteBuffer);
        return byteBuffer;
    }

    public FloatBuffer getTransposed(FloatBuffer floatBuffer) {
        return this.getTransposed(floatBuffer.position(), floatBuffer);
    }

    public FloatBuffer getTransposed(int n2, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.putfTransposed(this, n2, floatBuffer);
        return floatBuffer;
    }

    public ByteBuffer getTransposedFloats(ByteBuffer byteBuffer) {
        return this.getTransposedFloats(byteBuffer.position(), byteBuffer);
    }

    public ByteBuffer getTransposedFloats(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.putfTransposed(this, n2, byteBuffer);
        return byteBuffer;
    }

    public Matrix3x2dc getToAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil$MemUtilUnsafe.put(this, l2);
        return this;
    }

    public double[] get(double[] dArray, int n2) {
        MemUtil.INSTANCE.copy(this, dArray, n2);
        return dArray;
    }

    public double[] get(double[] dArray) {
        return this.get(dArray, 0);
    }

    public double[] get3x3(double[] dArray, int n2) {
        MemUtil.INSTANCE.copy3x3(this, dArray, n2);
        return dArray;
    }

    public double[] get3x3(double[] dArray) {
        return this.get3x3(dArray, 0);
    }

    public double[] get4x4(double[] dArray, int n2) {
        MemUtil.INSTANCE.copy4x4(this, dArray, n2);
        return dArray;
    }

    public double[] get4x4(double[] dArray) {
        return this.get4x4(dArray, 0);
    }

    public Matrix3x2d set(DoubleBuffer doubleBuffer) {
        int n2 = doubleBuffer.position();
        MemUtil.INSTANCE.get(this, n2, doubleBuffer);
        return this;
    }

    public Matrix3x2d set(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.position();
        MemUtil.INSTANCE.get(this, n2, byteBuffer);
        return this;
    }

    public Matrix3x2d set(int n2, DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.get(this, n2, doubleBuffer);
        return this;
    }

    public Matrix3x2d set(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n2, byteBuffer);
        return this;
    }

    public Matrix3x2d setFromAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil$MemUtilUnsafe.get(this, l2);
        return this;
    }

    public Matrix3x2d zero() {
        MemUtil.INSTANCE.zero(this);
        return this;
    }

    public Matrix3x2d identity() {
        MemUtil.INSTANCE.identity(this);
        return this;
    }

    public Matrix3x2d scale(double d2, double d3, Matrix3x2d matrix3x2d) {
        matrix3x2d.m00 = this.m00 * d2;
        matrix3x2d.m01 = this.m01 * d2;
        matrix3x2d.m10 = this.m10 * d3;
        matrix3x2d.m11 = this.m11 * d3;
        matrix3x2d.m20 = this.m20;
        matrix3x2d.m21 = this.m21;
        return matrix3x2d;
    }

    public Matrix3x2d scale(double d2, double d3) {
        return this.scale(d2, d3, this);
    }

    public Matrix3x2d scale(Vector2dc vector2dc) {
        return this.scale(vector2dc.x(), vector2dc.y(), this);
    }

    public Matrix3x2d scale(Vector2dc vector2dc, Matrix3x2d matrix3x2d) {
        return this.scale(vector2dc.x(), vector2dc.y(), matrix3x2d);
    }

    public Matrix3x2d scale(Vector2fc vector2fc) {
        return this.scale(vector2fc.x(), vector2fc.y(), this);
    }

    public Matrix3x2d scale(Vector2fc vector2fc, Matrix3x2d matrix3x2d) {
        return this.scale(vector2fc.x(), vector2fc.y(), matrix3x2d);
    }

    public Matrix3x2d scale(double d2, Matrix3x2d matrix3x2d) {
        return this.scale(d2, d2, matrix3x2d);
    }

    public Matrix3x2d scale(double d2) {
        return this.scale(d2, d2);
    }

    public Matrix3x2d scaleLocal(double d2, double d3, Matrix3x2d matrix3x2d) {
        matrix3x2d.m00 = d2 * this.m00;
        matrix3x2d.m01 = d3 * this.m01;
        matrix3x2d.m10 = d2 * this.m10;
        matrix3x2d.m11 = d3 * this.m11;
        matrix3x2d.m20 = d2 * this.m20;
        matrix3x2d.m21 = d3 * this.m21;
        return matrix3x2d;
    }

    public Matrix3x2d scaleLocal(double d2, double d3) {
        return this.scaleLocal(d2, d3, this);
    }

    public Matrix3x2d scaleLocal(double d2, Matrix3x2d matrix3x2d) {
        return this.scaleLocal(d2, d2, matrix3x2d);
    }

    public Matrix3x2d scaleLocal(double d2) {
        return this.scaleLocal(d2, d2, this);
    }

    public Matrix3x2d scaleAround(double d2, double d3, double d4, double d5, Matrix3x2d matrix3x2d) {
        double d6 = this.m00 * d4 + this.m10 * d5 + this.m20;
        double d7 = this.m01 * d4 + this.m11 * d5 + this.m21;
        matrix3x2d.m00 = this.m00 * d2;
        matrix3x2d.m01 = this.m01 * d2;
        matrix3x2d.m10 = this.m10 * d3;
        matrix3x2d.m11 = this.m11 * d3;
        matrix3x2d.m20 = matrix3x2d.m00 * -d4 + matrix3x2d.m10 * -d5 + d6;
        matrix3x2d.m21 = matrix3x2d.m01 * -d4 + matrix3x2d.m11 * -d5 + d7;
        return matrix3x2d;
    }

    public Matrix3x2d scaleAround(double d2, double d3, double d4, double d5) {
        return this.scaleAround(d2, d3, d4, d5, this);
    }

    public Matrix3x2d scaleAround(double d2, double d3, double d4, Matrix3x2d matrix3x2d) {
        return this.scaleAround(d2, d2, d3, d4, this);
    }

    public Matrix3x2d scaleAround(double d2, double d3, double d4) {
        return this.scaleAround(d2, d2, d3, d4, this);
    }

    public Matrix3x2d scaleAroundLocal(double d2, double d3, double d4, double d5, Matrix3x2d matrix3x2d) {
        matrix3x2d.m00 = d2 * this.m00;
        matrix3x2d.m01 = d3 * this.m01;
        matrix3x2d.m10 = d2 * this.m10;
        matrix3x2d.m11 = d3 * this.m11;
        matrix3x2d.m20 = d2 * this.m20 - d2 * d4 + d4;
        matrix3x2d.m21 = d3 * this.m21 - d3 * d5 + d5;
        return matrix3x2d;
    }

    public Matrix3x2d scaleAroundLocal(double d2, double d3, double d4, Matrix3x2d matrix3x2d) {
        return this.scaleAroundLocal(d2, d2, d3, d4, matrix3x2d);
    }

    public Matrix3x2d scaleAroundLocal(double d2, double d3, double d4, double d5, double d6, double d7) {
        return this.scaleAroundLocal(d2, d3, d5, d6, this);
    }

    public Matrix3x2d scaleAroundLocal(double d2, double d3, double d4) {
        return this.scaleAroundLocal(d2, d2, d3, d4, this);
    }

    public Matrix3x2d scaling(double d2) {
        return this.scaling(d2, d2);
    }

    public Matrix3x2d scaling(double d2, double d3) {
        this.m00 = d2;
        this.m01 = 0.0;
        this.m10 = 0.0;
        this.m11 = d3;
        this.m20 = 0.0;
        this.m21 = 0.0;
        return this;
    }

    public Matrix3x2d rotation(double d2) {
        double d3 = Math.cos(d2);
        double d4 = Math.sin(d2);
        this.m00 = d3;
        this.m10 = -d4;
        this.m20 = 0.0;
        this.m01 = d4;
        this.m11 = d3;
        this.m21 = 0.0;
        return this;
    }

    public Vector3d transform(Vector3d vector3d) {
        return vector3d.mul(this);
    }

    public Vector3d transform(Vector3dc vector3dc, Vector3d vector3d) {
        return vector3dc.mul(this, vector3d);
    }

    public Vector3d transform(double d2, double d3, double d4, Vector3d vector3d) {
        return vector3d.set(this.m00 * d2 + this.m10 * d3 + this.m20 * d4, this.m01 * d2 + this.m11 * d3 + this.m21 * d4, d4);
    }

    public Vector2d transformPosition(Vector2d vector2d) {
        vector2d.set(this.m00 * vector2d.x + this.m10 * vector2d.y + this.m20, this.m01 * vector2d.x + this.m11 * vector2d.y + this.m21);
        return vector2d;
    }

    public Vector2d transformPosition(Vector2dc vector2dc, Vector2d vector2d) {
        vector2d.set(this.m00 * vector2dc.x() + this.m10 * vector2dc.y() + this.m20, this.m01 * vector2dc.x() + this.m11 * vector2dc.y() + this.m21);
        return vector2d;
    }

    public Vector2d transformPosition(double d2, double d3, Vector2d vector2d) {
        return vector2d.set(this.m00 * d2 + this.m10 * d3 + this.m20, this.m01 * d2 + this.m11 * d3 + this.m21);
    }

    public Vector2d transformDirection(Vector2d vector2d) {
        vector2d.set(this.m00 * vector2d.x + this.m10 * vector2d.y, this.m01 * vector2d.x + this.m11 * vector2d.y);
        return vector2d;
    }

    public Vector2d transformDirection(Vector2dc vector2dc, Vector2d vector2d) {
        vector2d.set(this.m00 * vector2dc.x() + this.m10 * vector2dc.y(), this.m01 * vector2dc.x() + this.m11 * vector2dc.y());
        return vector2d;
    }

    public Vector2d transformDirection(double d2, double d3, Vector2d vector2d) {
        return vector2d.set(this.m00 * d2 + this.m10 * d3, this.m01 * d2 + this.m11 * d3);
    }

    public void writeExternal(ObjectOutput objectOutput) {
        objectOutput.writeDouble(this.m00);
        objectOutput.writeDouble(this.m01);
        objectOutput.writeDouble(this.m10);
        objectOutput.writeDouble(this.m11);
        objectOutput.writeDouble(this.m20);
        objectOutput.writeDouble(this.m21);
    }

    public void readExternal(ObjectInput objectInput) {
        this.m00 = objectInput.readDouble();
        this.m01 = objectInput.readDouble();
        this.m10 = objectInput.readDouble();
        this.m11 = objectInput.readDouble();
        this.m20 = objectInput.readDouble();
        this.m21 = objectInput.readDouble();
    }

    public Matrix3x2d rotate(double d2) {
        return this.rotate(d2, this);
    }

    public Matrix3x2d rotate(double d2, Matrix3x2d matrix3x2d) {
        double d3 = Math.cos(d2);
        double d4 = Math.sin(d2);
        double d5 = d3;
        double d6 = d4;
        double d7 = -d4;
        double d8 = d3;
        double d9 = this.m00 * d5 + this.m10 * d6;
        double d10 = this.m01 * d5 + this.m11 * d6;
        matrix3x2d.m10 = this.m00 * d7 + this.m10 * d8;
        matrix3x2d.m11 = this.m01 * d7 + this.m11 * d8;
        matrix3x2d.m00 = d9;
        matrix3x2d.m01 = d10;
        matrix3x2d.m20 = this.m20;
        matrix3x2d.m21 = this.m21;
        return matrix3x2d;
    }

    public Matrix3x2d rotateLocal(double d2, Matrix3x2d matrix3x2d) {
        double d3 = Math.sin(d2);
        double d4 = Math.cosFromSin(d3, d2);
        double d5 = d4 * this.m00 - d3 * this.m01;
        double d6 = d3 * this.m00 + d4 * this.m01;
        double d7 = d4 * this.m10 - d3 * this.m11;
        double d8 = d3 * this.m10 + d4 * this.m11;
        double d9 = d4 * this.m20 - d3 * this.m21;
        double d10 = d3 * this.m20 + d4 * this.m21;
        matrix3x2d.m00 = d5;
        matrix3x2d.m01 = d6;
        matrix3x2d.m10 = d7;
        matrix3x2d.m11 = d8;
        matrix3x2d.m20 = d9;
        matrix3x2d.m21 = d10;
        return matrix3x2d;
    }

    public Matrix3x2d rotateLocal(double d2) {
        return this.rotateLocal(d2, this);
    }

    public Matrix3x2d rotateAbout(double d2, double d3, double d4) {
        return this.rotateAbout(d2, d3, d4, this);
    }

    public Matrix3x2d rotateAbout(double d2, double d3, double d4, Matrix3x2d matrix3x2d) {
        double d5 = this.m00 * d3 + this.m10 * d4 + this.m20;
        double d6 = this.m01 * d3 + this.m11 * d4 + this.m21;
        double d7 = Math.cos(d2);
        double d8 = Math.sin(d2);
        double d9 = this.m00 * d7 + this.m10 * d8;
        double d10 = this.m01 * d7 + this.m11 * d8;
        matrix3x2d.m10 = this.m00 * -d8 + this.m10 * d7;
        matrix3x2d.m11 = this.m01 * -d8 + this.m11 * d7;
        matrix3x2d.m00 = d9;
        matrix3x2d.m01 = d10;
        matrix3x2d.m20 = matrix3x2d.m00 * -d3 + matrix3x2d.m10 * -d4 + d5;
        matrix3x2d.m21 = matrix3x2d.m01 * -d3 + matrix3x2d.m11 * -d4 + d6;
        return matrix3x2d;
    }

    public Matrix3x2d rotateTo(Vector2dc vector2dc, Vector2dc vector2dc2, Matrix3x2d matrix3x2d) {
        double d2 = vector2dc.x() * vector2dc2.x() + vector2dc.y() * vector2dc2.y();
        double d3 = vector2dc.x() * vector2dc2.y() - vector2dc.y() * vector2dc2.x();
        double d4 = d2;
        double d5 = d3;
        double d6 = -d3;
        double d7 = d2;
        double d8 = this.m00 * d4 + this.m10 * d5;
        double d9 = this.m01 * d4 + this.m11 * d5;
        matrix3x2d.m10 = this.m00 * d6 + this.m10 * d7;
        matrix3x2d.m11 = this.m01 * d6 + this.m11 * d7;
        matrix3x2d.m00 = d8;
        matrix3x2d.m01 = d9;
        matrix3x2d.m20 = this.m20;
        matrix3x2d.m21 = this.m21;
        return matrix3x2d;
    }

    public Matrix3x2d rotateTo(Vector2dc vector2dc, Vector2dc vector2dc2) {
        return this.rotateTo(vector2dc, vector2dc2, this);
    }

    public Matrix3x2d view(double d2, double d3, double d4, double d5, Matrix3x2d matrix3x2d) {
        double d6 = 2.0 / (d3 - d2);
        double d7 = 2.0 / (d5 - d4);
        double d8 = (d2 + d3) / (d2 - d3);
        double d9 = (d4 + d5) / (d4 - d5);
        matrix3x2d.m20 = this.m00 * d8 + this.m10 * d9 + this.m20;
        matrix3x2d.m21 = this.m01 * d8 + this.m11 * d9 + this.m21;
        matrix3x2d.m00 = this.m00 * d6;
        matrix3x2d.m01 = this.m01 * d6;
        matrix3x2d.m10 = this.m10 * d7;
        matrix3x2d.m11 = this.m11 * d7;
        return matrix3x2d;
    }

    public Matrix3x2d view(double d2, double d3, double d4, double d5) {
        return this.view(d2, d3, d4, d5, this);
    }

    public Matrix3x2d setView(double d2, double d3, double d4, double d5) {
        this.m00 = 2.0 / (d3 - d2);
        this.m01 = 0.0;
        this.m10 = 0.0;
        this.m11 = 2.0 / (d5 - d4);
        this.m20 = (d2 + d3) / (d2 - d3);
        this.m21 = (d4 + d5) / (d4 - d5);
        return this;
    }

    public Vector2d origin(Vector2d vector2d) {
        double d2 = 1.0 / (this.m00 * this.m11 - this.m01 * this.m10);
        vector2d.x = (this.m10 * this.m21 - this.m20 * this.m11) * d2;
        vector2d.y = (this.m20 * this.m01 - this.m00 * this.m21) * d2;
        return vector2d;
    }

    public double[] viewArea(double[] dArray) {
        double d2 = 1.0 / (this.m00 * this.m11 - this.m01 * this.m10);
        double d3 = this.m11 * d2;
        double d4 = -this.m01 * d2;
        double d5 = -this.m10 * d2;
        double d6 = this.m00 * d2;
        double d7 = (this.m10 * this.m21 - this.m20 * this.m11) * d2;
        double d8 = (this.m20 * this.m01 - this.m00 * this.m21) * d2;
        double d9 = -d3 - d5;
        double d10 = -d4 - d6;
        double d11 = d3 - d5;
        double d12 = d4 - d6;
        double d13 = -d3 + d5;
        double d14 = -d4 + d6;
        double d15 = d3 + d5;
        double d16 = d4 + d6;
        double d17 = d9;
        d17 = d17 < d13 ? d17 : d13;
        d17 = d17 < d11 ? d17 : d11;
        d17 = d17 < d15 ? d17 : d15;
        double d18 = d10;
        d18 = d18 < d14 ? d18 : d14;
        d18 = d18 < d12 ? d18 : d12;
        d18 = d18 < d16 ? d18 : d16;
        double d19 = d9;
        d19 = d19 > d13 ? d19 : d13;
        d19 = d19 > d11 ? d19 : d11;
        d19 = d19 > d15 ? d19 : d15;
        double d20 = d10;
        d20 = d20 > d14 ? d20 : d14;
        d20 = d20 > d12 ? d20 : d12;
        d20 = d20 > d16 ? d20 : d16;
        dArray[0] = d17 + d7;
        dArray[1] = d18 + d8;
        dArray[2] = d19 + d7;
        dArray[3] = d20 + d8;
        return dArray;
    }

    public Vector2d positiveX(Vector2d vector2d) {
        double d2 = this.m00 * this.m11 - this.m01 * this.m10;
        d2 = 1.0 / d2;
        vector2d.x = this.m11 * d2;
        vector2d.y = -this.m01 * d2;
        return vector2d.normalize(vector2d);
    }

    public Vector2d normalizedPositiveX(Vector2d vector2d) {
        vector2d.x = this.m11;
        vector2d.y = -this.m01;
        return vector2d;
    }

    public Vector2d positiveY(Vector2d vector2d) {
        double d2 = this.m00 * this.m11 - this.m01 * this.m10;
        d2 = 1.0 / d2;
        vector2d.x = -this.m10 * d2;
        vector2d.y = this.m00 * d2;
        return vector2d.normalize(vector2d);
    }

    public Vector2d normalizedPositiveY(Vector2d vector2d) {
        vector2d.x = -this.m10;
        vector2d.y = this.m00;
        return vector2d;
    }

    public Vector2d unproject(double d2, double d3, int[] nArray, Vector2d vector2d) {
        double d4 = 1.0 / (this.m00 * this.m11 - this.m01 * this.m10);
        double d5 = this.m11 * d4;
        double d6 = -this.m01 * d4;
        double d7 = -this.m10 * d4;
        double d8 = this.m00 * d4;
        double d9 = (this.m10 * this.m21 - this.m20 * this.m11) * d4;
        double d10 = (this.m20 * this.m01 - this.m00 * this.m21) * d4;
        double d11 = (d2 - (double)nArray[0]) / (double)nArray[2] * 2.0 - 1.0;
        double d12 = (d3 - (double)nArray[1]) / (double)nArray[3] * 2.0 - 1.0;
        vector2d.x = d5 * d11 + d7 * d12 + d9;
        vector2d.y = d6 * d11 + d8 * d12 + d10;
        return vector2d;
    }

    public Vector2d unprojectInv(double d2, double d3, int[] nArray, Vector2d vector2d) {
        double d4 = (d2 - (double)nArray[0]) / (double)nArray[2] * 2.0 - 1.0;
        double d5 = (d3 - (double)nArray[1]) / (double)nArray[3] * 2.0 - 1.0;
        vector2d.x = this.m00 * d4 + this.m10 * d5 + this.m20;
        vector2d.y = this.m01 * d4 + this.m11 * d5 + this.m21;
        return vector2d;
    }

    public Matrix3x2d span(Vector2d vector2d, Vector2d vector2d2, Vector2d vector2d3) {
        double d2 = 1.0 / (this.m00 * this.m11 - this.m01 * this.m10);
        double d3 = this.m11 * d2;
        double d4 = -this.m01 * d2;
        double d5 = -this.m10 * d2;
        double d6 = this.m00 * d2;
        vector2d.x = -d3 - d5 + (this.m10 * this.m21 - this.m20 * this.m11) * d2;
        vector2d.y = -d4 - d6 + (this.m20 * this.m01 - this.m00 * this.m21) * d2;
        vector2d2.x = 2.0 * d3;
        vector2d2.y = 2.0 * d4;
        vector2d3.x = 2.0 * d5;
        vector2d3.y = 2.0 * d6;
        return this;
    }

    public boolean testPoint(double d2, double d3) {
        double d4 = this.m00;
        double d5 = this.m10;
        double d6 = 1.0 + this.m20;
        double d7 = -this.m00;
        double d8 = -this.m10;
        double d9 = 1.0 - this.m20;
        double d10 = this.m01;
        double d11 = this.m11;
        double d12 = 1.0 + this.m21;
        double d13 = -this.m01;
        double d14 = -this.m11;
        double d15 = 1.0 - this.m21;
        return d4 * d2 + d5 * d3 + d6 >= 0.0 && d7 * d2 + d8 * d3 + d9 >= 0.0 && d10 * d2 + d11 * d3 + d12 >= 0.0 && d13 * d2 + d14 * d3 + d15 >= 0.0;
    }

    public boolean testCircle(double d2, double d3, double d4) {
        double d5 = this.m00;
        double d6 = this.m10;
        double d7 = 1.0 + this.m20;
        double d8 = Math.invsqrt(d5 * d5 + d6 * d6);
        d5 *= d8;
        d6 *= d8;
        d7 *= d8;
        double d9 = -this.m00;
        double d10 = -this.m10;
        double d11 = 1.0 - this.m20;
        d8 = Math.invsqrt(d9 * d9 + d10 * d10);
        d9 *= d8;
        d10 *= d8;
        d11 *= d8;
        double d12 = this.m01;
        double d13 = this.m11;
        double d14 = 1.0 + this.m21;
        d8 = Math.invsqrt(d12 * d12 + d13 * d13);
        d12 *= d8;
        d13 *= d8;
        d14 *= d8;
        double d15 = -this.m01;
        double d16 = -this.m11;
        double d17 = 1.0 - this.m21;
        d8 = Math.invsqrt(d15 * d15 + d16 * d16);
        return d5 * d2 + d6 * d3 + d7 >= -d4 && d9 * d2 + d10 * d3 + d11 >= -d4 && d12 * d2 + d13 * d3 + d14 >= -d4 && (d15 *= d8) * d2 + (d16 *= d8) * d3 + (d17 *= d8) >= -d4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean testAar(double d2, double d3, double d4, double d5) {
        double d6 = this.m00;
        double d7 = this.m10;
        double d8 = 1.0 + this.m20;
        double d9 = -this.m00;
        double d10 = -this.m10;
        double d11 = 1.0 - this.m20;
        double d12 = this.m01;
        double d13 = this.m11;
        double d14 = 1.0 + this.m21;
        double d15 = -this.m01;
        double d16 = -this.m11;
        double d17 = 1.0 - this.m21;
        double d18 = d6 * (d6 < 0.0 ? d2 : d4);
        double d19 = d7 < 0.0 ? d3 : d5;
        if (!(d18 + d7 * d19 >= -d8)) return false;
        double d20 = d9 * (d9 < 0.0 ? d2 : d4);
        double d21 = d10 < 0.0 ? d3 : d5;
        if (!(d20 + d10 * d21 >= -d11)) return false;
        double d22 = d12 * (d12 < 0.0 ? d2 : d4);
        double d23 = d13 < 0.0 ? d3 : d5;
        if (!(d22 + d13 * d23 >= -d14)) return false;
        double d24 = d15 * (d15 < 0.0 ? d2 : d4);
        double d25 = d16 < 0.0 ? d3 : d5;
        if (!(d24 + d16 * d25 >= -d17)) return false;
        return true;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        long l2 = Double.doubleToLongBits(this.m00);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.m01);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.m10);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.m11);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.m20);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.m21);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Matrix3x2d matrix3x2d = (Matrix3x2d)object;
        if (Double.doubleToLongBits(this.m00) != Double.doubleToLongBits(matrix3x2d.m00)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m01) != Double.doubleToLongBits(matrix3x2d.m01)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m10) != Double.doubleToLongBits(matrix3x2d.m10)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m11) != Double.doubleToLongBits(matrix3x2d.m11)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m20) != Double.doubleToLongBits(matrix3x2d.m20)) {
            return false;
        }
        return Double.doubleToLongBits(this.m21) == Double.doubleToLongBits(matrix3x2d.m21);
    }

    public boolean equals(Matrix3x2dc matrix3x2dc, double d2) {
        if (this == matrix3x2dc) {
            return true;
        }
        if (matrix3x2dc == null) {
            return false;
        }
        if (!(matrix3x2dc instanceof Matrix3x2d)) {
            return false;
        }
        if (!Runtime.equals(this.m00, matrix3x2dc.m00(), d2)) {
            return false;
        }
        if (!Runtime.equals(this.m01, matrix3x2dc.m01(), d2)) {
            return false;
        }
        if (!Runtime.equals(this.m10, matrix3x2dc.m10(), d2)) {
            return false;
        }
        if (!Runtime.equals(this.m11, matrix3x2dc.m11(), d2)) {
            return false;
        }
        if (!Runtime.equals(this.m20, matrix3x2dc.m20(), d2)) {
            return false;
        }
        return Runtime.equals(this.m21, matrix3x2dc.m21(), d2);
    }

    public boolean isFinite() {
        return Math.isFinite(this.m00) && Math.isFinite(this.m01) && Math.isFinite(this.m10) && Math.isFinite(this.m11) && Math.isFinite(this.m20) && Math.isFinite(this.m21);
    }

    public Object clone() {
        return super.clone();
    }
}

