/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.text.NumberFormat;
import org.joml.Math;
import org.joml.Matrix2fc;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.joml.MemUtil;
import org.joml.MemUtil$MemUtilUnsafe;
import org.joml.Options;
import org.joml.Runtime;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public class Matrix2f
implements Externalizable,
Cloneable,
Matrix2fc {
    private static final long serialVersionUID = 1L;
    public float m00;
    public float m01;
    public float m10;
    public float m11;

    public Matrix2f() {
        this.m00 = 1.0f;
        this.m11 = 1.0f;
    }

    public Matrix2f(Matrix2fc matrix2fc) {
        if (matrix2fc instanceof Matrix2f) {
            MemUtil.INSTANCE.copy((Matrix2f)matrix2fc, this);
        } else {
            this.setMatrix2fc(matrix2fc);
        }
    }

    public Matrix2f(Matrix3fc matrix3fc) {
        if (matrix3fc instanceof Matrix3f) {
            MemUtil.INSTANCE.copy((Matrix3f)matrix3fc, this);
        } else {
            this.setMatrix3fc(matrix3fc);
        }
    }

    public Matrix2f(float f2, float f3, float f4, float f5) {
        this.m00 = f2;
        this.m01 = f3;
        this.m10 = f4;
        this.m11 = f5;
    }

    public Matrix2f(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, floatBuffer.position(), floatBuffer);
    }

    public Matrix2f(Vector2fc vector2fc, Vector2fc vector2fc2) {
        this.m00 = vector2fc.x();
        this.m01 = vector2fc.y();
        this.m10 = vector2fc2.x();
        this.m11 = vector2fc2.y();
    }

    public float m00() {
        return this.m00;
    }

    public float m01() {
        return this.m01;
    }

    public float m10() {
        return this.m10;
    }

    public float m11() {
        return this.m11;
    }

    public Matrix2f m00(float f2) {
        this.m00 = f2;
        return this;
    }

    public Matrix2f m01(float f2) {
        this.m01 = f2;
        return this;
    }

    public Matrix2f m10(float f2) {
        this.m10 = f2;
        return this;
    }

    public Matrix2f m11(float f2) {
        this.m11 = f2;
        return this;
    }

    Matrix2f _m00(float f2) {
        this.m00 = f2;
        return this;
    }

    Matrix2f _m01(float f2) {
        this.m01 = f2;
        return this;
    }

    Matrix2f _m10(float f2) {
        this.m10 = f2;
        return this;
    }

    Matrix2f _m11(float f2) {
        this.m11 = f2;
        return this;
    }

    public Matrix2f set(Matrix2fc matrix2fc) {
        if (matrix2fc instanceof Matrix2f) {
            MemUtil.INSTANCE.copy((Matrix2f)matrix2fc, this);
        } else {
            this.setMatrix2fc(matrix2fc);
        }
        return this;
    }

    private void setMatrix2fc(Matrix2fc matrix2fc) {
        this.m00 = matrix2fc.m00();
        this.m01 = matrix2fc.m01();
        this.m10 = matrix2fc.m10();
        this.m11 = matrix2fc.m11();
    }

    public Matrix2f set(Matrix3x2fc matrix3x2fc) {
        if (matrix3x2fc instanceof Matrix3x2f) {
            MemUtil.INSTANCE.copy((Matrix3x2f)matrix3x2fc, this);
        } else {
            this.setMatrix3x2fc(matrix3x2fc);
        }
        return this;
    }

    private void setMatrix3x2fc(Matrix3x2fc matrix3x2fc) {
        this.m00 = matrix3x2fc.m00();
        this.m01 = matrix3x2fc.m01();
        this.m10 = matrix3x2fc.m10();
        this.m11 = matrix3x2fc.m11();
    }

    public Matrix2f set(Matrix3fc matrix3fc) {
        if (matrix3fc instanceof Matrix3f) {
            MemUtil.INSTANCE.copy((Matrix3f)matrix3fc, this);
        } else {
            this.setMatrix3fc(matrix3fc);
        }
        return this;
    }

    private void setMatrix3fc(Matrix3fc matrix3fc) {
        this.m00 = matrix3fc.m00();
        this.m01 = matrix3fc.m01();
        this.m10 = matrix3fc.m10();
        this.m11 = matrix3fc.m11();
    }

    public Matrix2f mul(Matrix2fc matrix2fc) {
        return this.mul(matrix2fc, this);
    }

    public Matrix2f mul(Matrix2fc matrix2fc, Matrix2f matrix2f) {
        float f2 = this.m00 * matrix2fc.m00() + this.m10 * matrix2fc.m01();
        float f3 = this.m01 * matrix2fc.m00() + this.m11 * matrix2fc.m01();
        float f4 = this.m00 * matrix2fc.m10() + this.m10 * matrix2fc.m11();
        float f5 = this.m01 * matrix2fc.m10() + this.m11 * matrix2fc.m11();
        matrix2f.m00 = f2;
        matrix2f.m01 = f3;
        matrix2f.m10 = f4;
        matrix2f.m11 = f5;
        return matrix2f;
    }

    public Matrix2f mulLocal(Matrix2fc matrix2fc) {
        return this.mulLocal(matrix2fc, this);
    }

    public Matrix2f mulLocal(Matrix2fc matrix2fc, Matrix2f matrix2f) {
        float f2 = matrix2fc.m00() * this.m00 + matrix2fc.m10() * this.m01;
        float f3 = matrix2fc.m01() * this.m00 + matrix2fc.m11() * this.m01;
        float f4 = matrix2fc.m00() * this.m10 + matrix2fc.m10() * this.m11;
        float f5 = matrix2fc.m01() * this.m10 + matrix2fc.m11() * this.m11;
        matrix2f.m00 = f2;
        matrix2f.m01 = f3;
        matrix2f.m10 = f4;
        matrix2f.m11 = f5;
        return matrix2f;
    }

    public Matrix2f set(float f2, float f3, float f4, float f5) {
        this.m00 = f2;
        this.m01 = f3;
        this.m10 = f4;
        this.m11 = f5;
        return this;
    }

    public Matrix2f set(float[] fArray) {
        MemUtil.INSTANCE.copy(fArray, 0, this);
        return this;
    }

    public Matrix2f set(Vector2fc vector2fc, Vector2fc vector2fc2) {
        this.m00 = vector2fc.x();
        this.m01 = vector2fc.y();
        this.m10 = vector2fc2.x();
        this.m11 = vector2fc2.y();
        return this;
    }

    public float determinant() {
        return this.m00 * this.m11 - this.m10 * this.m01;
    }

    public Matrix2f invert() {
        return this.invert(this);
    }

    public Matrix2f invert(Matrix2f matrix2f) {
        float f2 = 1.0f / this.determinant();
        float f3 = this.m11 * f2;
        float f4 = -this.m01 * f2;
        float f5 = -this.m10 * f2;
        float f6 = this.m00 * f2;
        matrix2f.m00 = f3;
        matrix2f.m01 = f4;
        matrix2f.m10 = f5;
        matrix2f.m11 = f6;
        return matrix2f;
    }

    public Matrix2f transpose() {
        return this.transpose(this);
    }

    public Matrix2f transpose(Matrix2f matrix2f) {
        matrix2f.set(this.m00, this.m10, this.m01, this.m11);
        return matrix2f;
    }

    public String toString() {
        String string = this.toString(Options.NUMBER_FORMAT);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = Integer.MIN_VALUE;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == 'E') {
                n2 = i2;
            } else {
                if (c2 == ' ' && n2 == i2 - 1) {
                    stringBuffer.append('+');
                    continue;
                }
                if (Character.isDigit(c2) && n2 == i2 - 1) {
                    stringBuffer.append('+');
                }
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public String toString(NumberFormat numberFormat) {
        return Runtime.format(this.m00, numberFormat) + " " + Runtime.format(this.m10, numberFormat) + "\n" + Runtime.format(this.m01, numberFormat) + " " + Runtime.format(this.m11, numberFormat) + "\n";
    }

    public Matrix2f get(Matrix2f matrix2f) {
        return matrix2f.set(this);
    }

    public Matrix3x2f get(Matrix3x2f matrix3x2f) {
        return matrix3x2f.set(this);
    }

    public Matrix3f get(Matrix3f matrix3f) {
        return matrix3f.set(this);
    }

    public float getRotation() {
        return Math.atan2(this.m01, this.m11);
    }

    public FloatBuffer get(FloatBuffer floatBuffer) {
        return this.get(floatBuffer.position(), floatBuffer);
    }

    public FloatBuffer get(int n2, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put(this, n2, floatBuffer);
        return floatBuffer;
    }

    public ByteBuffer get(ByteBuffer byteBuffer) {
        return this.get(byteBuffer.position(), byteBuffer);
    }

    public ByteBuffer get(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, n2, byteBuffer);
        return byteBuffer;
    }

    public FloatBuffer getTransposed(FloatBuffer floatBuffer) {
        return this.get(floatBuffer.position(), floatBuffer);
    }

    public FloatBuffer getTransposed(int n2, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.putTransposed(this, n2, floatBuffer);
        return floatBuffer;
    }

    public ByteBuffer getTransposed(ByteBuffer byteBuffer) {
        return this.get(byteBuffer.position(), byteBuffer);
    }

    public ByteBuffer getTransposed(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.putTransposed(this, n2, byteBuffer);
        return byteBuffer;
    }

    public Matrix2fc getToAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil$MemUtilUnsafe.put(this, l2);
        return this;
    }

    public float[] get(float[] fArray, int n2) {
        MemUtil.INSTANCE.copy(this, fArray, n2);
        return fArray;
    }

    public float[] get(float[] fArray) {
        return this.get(fArray, 0);
    }

    public Matrix2f set(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, floatBuffer.position(), floatBuffer);
        return this;
    }

    public Matrix2f set(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
        return this;
    }

    public Matrix2f set(int n2, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, n2, floatBuffer);
        return this;
    }

    public Matrix2f set(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n2, byteBuffer);
        return this;
    }

    public Matrix2f setFromAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil$MemUtilUnsafe.get(this, l2);
        return this;
    }

    public Matrix2f zero() {
        MemUtil.INSTANCE.zero(this);
        return this;
    }

    public Matrix2f identity() {
        MemUtil.INSTANCE.identity(this);
        return this;
    }

    public Matrix2f scale(Vector2fc vector2fc, Matrix2f matrix2f) {
        return this.scale(vector2fc.x(), vector2fc.y(), matrix2f);
    }

    public Matrix2f scale(Vector2fc vector2fc) {
        return this.scale(vector2fc.x(), vector2fc.y(), this);
    }

    public Matrix2f scale(float f2, float f3, Matrix2f matrix2f) {
        matrix2f.m00 = this.m00 * f2;
        matrix2f.m01 = this.m01 * f2;
        matrix2f.m10 = this.m10 * f3;
        matrix2f.m11 = this.m11 * f3;
        return matrix2f;
    }

    public Matrix2f scale(float f2, float f3) {
        return this.scale(f2, f3, this);
    }

    public Matrix2f scale(float f2, Matrix2f matrix2f) {
        return this.scale(f2, f2, matrix2f);
    }

    public Matrix2f scale(float f2) {
        return this.scale(f2, f2);
    }

    public Matrix2f scaleLocal(float f2, float f3, Matrix2f matrix2f) {
        matrix2f.m00 = f2 * this.m00;
        matrix2f.m01 = f3 * this.m01;
        matrix2f.m10 = f2 * this.m10;
        matrix2f.m11 = f3 * this.m11;
        return matrix2f;
    }

    public Matrix2f scaleLocal(float f2, float f3) {
        return this.scaleLocal(f2, f3, this);
    }

    public Matrix2f scaling(float f2) {
        MemUtil.INSTANCE.zero(this);
        this.m00 = f2;
        this.m11 = f2;
        return this;
    }

    public Matrix2f scaling(float f2, float f3) {
        MemUtil.INSTANCE.zero(this);
        this.m00 = f2;
        this.m11 = f3;
        return this;
    }

    public Matrix2f scaling(Vector2fc vector2fc) {
        return this.scaling(vector2fc.x(), vector2fc.y());
    }

    public Matrix2f rotation(float f2) {
        float f3;
        float f4 = Math.sin(f2);
        this.m00 = f3 = Math.cosFromSin(f4, f2);
        this.m01 = f4;
        this.m10 = -f4;
        this.m11 = f3;
        return this;
    }

    public Vector2f transform(Vector2f vector2f) {
        return vector2f.mul(this);
    }

    public Vector2f transform(Vector2fc vector2fc, Vector2f vector2f) {
        vector2fc.mul(this, vector2f);
        return vector2f;
    }

    public Vector2f transform(float f2, float f3, Vector2f vector2f) {
        vector2f.set(this.m00 * f2 + this.m10 * f3, this.m01 * f2 + this.m11 * f3);
        return vector2f;
    }

    public Vector2f transformTranspose(Vector2f vector2f) {
        return vector2f.mulTranspose(this);
    }

    public Vector2f transformTranspose(Vector2fc vector2fc, Vector2f vector2f) {
        vector2fc.mulTranspose(this, vector2f);
        return vector2f;
    }

    public Vector2f transformTranspose(float f2, float f3, Vector2f vector2f) {
        vector2f.set(this.m00 * f2 + this.m01 * f3, this.m10 * f2 + this.m11 * f3);
        return vector2f;
    }

    public void writeExternal(ObjectOutput objectOutput) {
        objectOutput.writeFloat(this.m00);
        objectOutput.writeFloat(this.m01);
        objectOutput.writeFloat(this.m10);
        objectOutput.writeFloat(this.m11);
    }

    public void readExternal(ObjectInput objectInput) {
        this.m00 = objectInput.readFloat();
        this.m01 = objectInput.readFloat();
        this.m10 = objectInput.readFloat();
        this.m11 = objectInput.readFloat();
    }

    public Matrix2f rotate(float f2) {
        return this.rotate(f2, this);
    }

    public Matrix2f rotate(float f2, Matrix2f matrix2f) {
        float f3 = Math.sin(f2);
        float f4 = Math.cosFromSin(f3, f2);
        float f5 = this.m00 * f4 + this.m10 * f3;
        float f6 = this.m01 * f4 + this.m11 * f3;
        float f7 = this.m10 * f4 - this.m00 * f3;
        float f8 = this.m11 * f4 - this.m01 * f3;
        matrix2f.m00 = f5;
        matrix2f.m01 = f6;
        matrix2f.m10 = f7;
        matrix2f.m11 = f8;
        return matrix2f;
    }

    public Matrix2f rotateLocal(float f2) {
        return this.rotateLocal(f2, this);
    }

    public Matrix2f rotateLocal(float f2, Matrix2f matrix2f) {
        float f3 = Math.sin(f2);
        float f4 = Math.cosFromSin(f3, f2);
        float f5 = f4 * this.m00 - f3 * this.m01;
        float f6 = f3 * this.m00 + f4 * this.m01;
        float f7 = f4 * this.m10 - f3 * this.m11;
        float f8 = f3 * this.m10 + f4 * this.m11;
        matrix2f.m00 = f5;
        matrix2f.m01 = f6;
        matrix2f.m10 = f7;
        matrix2f.m11 = f8;
        return matrix2f;
    }

    public Vector2f getRow(int n2, Vector2f vector2f) {
        switch (n2) {
            case 0: {
                vector2f.x = this.m00;
                vector2f.y = this.m10;
                break;
            }
            case 1: {
                vector2f.x = this.m01;
                vector2f.y = this.m11;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return vector2f;
    }

    public Matrix2f setRow(int n2, Vector2fc vector2fc) {
        return this.setRow(n2, vector2fc.x(), vector2fc.y());
    }

    public Matrix2f setRow(int n2, float f2, float f3) {
        switch (n2) {
            case 0: {
                this.m00 = f2;
                this.m10 = f3;
                break;
            }
            case 1: {
                this.m01 = f2;
                this.m11 = f3;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return this;
    }

    public Vector2f getColumn(int n2, Vector2f vector2f) {
        switch (n2) {
            case 0: {
                vector2f.x = this.m00;
                vector2f.y = this.m01;
                break;
            }
            case 1: {
                vector2f.x = this.m10;
                vector2f.y = this.m11;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return vector2f;
    }

    public Matrix2f setColumn(int n2, Vector2fc vector2fc) {
        return this.setColumn(n2, vector2fc.x(), vector2fc.y());
    }

    public Matrix2f setColumn(int n2, float f2, float f3) {
        switch (n2) {
            case 0: {
                this.m00 = f2;
                this.m01 = f3;
                break;
            }
            case 1: {
                this.m10 = f2;
                this.m11 = f3;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return this;
    }

    public float get(int n2, int n3) {
        switch (n2) {
            case 0: {
                switch (n3) {
                    case 0: {
                        return this.m00;
                    }
                    case 1: {
                        return this.m01;
                    }
                }
                break;
            }
            case 1: {
                switch (n3) {
                    case 0: {
                        return this.m10;
                    }
                    case 1: {
                        return this.m11;
                    }
                }
                break;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Matrix2f set(int n2, int n3, float f2) {
        switch (n2) {
            case 0: {
                switch (n3) {
                    case 0: {
                        this.m00 = f2;
                        return this;
                    }
                    case 1: {
                        this.m01 = f2;
                        return this;
                    }
                }
                break;
            }
            case 1: {
                switch (n3) {
                    case 0: {
                        this.m10 = f2;
                        return this;
                    }
                    case 1: {
                        this.m11 = f2;
                        return this;
                    }
                }
                break;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Matrix2f normal() {
        return this.normal(this);
    }

    public Matrix2f normal(Matrix2f matrix2f) {
        float f2 = this.m00 * this.m11 - this.m10 * this.m01;
        float f3 = 1.0f / f2;
        float f4 = this.m11 * f3;
        float f5 = -this.m10 * f3;
        float f6 = -this.m01 * f3;
        float f7 = this.m00 * f3;
        matrix2f.m00 = f4;
        matrix2f.m01 = f5;
        matrix2f.m10 = f6;
        matrix2f.m11 = f7;
        return matrix2f;
    }

    public Vector2f getScale(Vector2f vector2f) {
        vector2f.x = Math.sqrt(this.m00 * this.m00 + this.m01 * this.m01);
        vector2f.y = Math.sqrt(this.m10 * this.m10 + this.m11 * this.m11);
        return vector2f;
    }

    public Vector2f positiveX(Vector2f vector2f) {
        if (this.m00 * this.m11 < this.m01 * this.m10) {
            vector2f.x = -this.m11;
            vector2f.y = this.m01;
        } else {
            vector2f.x = this.m11;
            vector2f.y = -this.m01;
        }
        return vector2f.normalize(vector2f);
    }

    public Vector2f normalizedPositiveX(Vector2f vector2f) {
        if (this.m00 * this.m11 < this.m01 * this.m10) {
            vector2f.x = -this.m11;
            vector2f.y = this.m01;
        } else {
            vector2f.x = this.m11;
            vector2f.y = -this.m01;
        }
        return vector2f;
    }

    public Vector2f positiveY(Vector2f vector2f) {
        if (this.m00 * this.m11 < this.m01 * this.m10) {
            vector2f.x = this.m10;
            vector2f.y = -this.m00;
        } else {
            vector2f.x = -this.m10;
            vector2f.y = this.m00;
        }
        return vector2f.normalize(vector2f);
    }

    public Vector2f normalizedPositiveY(Vector2f vector2f) {
        if (this.m00 * this.m11 < this.m01 * this.m10) {
            vector2f.x = this.m10;
            vector2f.y = -this.m00;
        } else {
            vector2f.x = -this.m10;
            vector2f.y = this.m00;
        }
        return vector2f;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + Float.floatToIntBits(this.m00);
        n3 = 31 * n3 + Float.floatToIntBits(this.m01);
        n3 = 31 * n3 + Float.floatToIntBits(this.m10);
        n3 = 31 * n3 + Float.floatToIntBits(this.m11);
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Matrix2f matrix2f = (Matrix2f)object;
        if (Float.floatToIntBits(this.m00) != Float.floatToIntBits(matrix2f.m00)) {
            return false;
        }
        if (Float.floatToIntBits(this.m01) != Float.floatToIntBits(matrix2f.m01)) {
            return false;
        }
        if (Float.floatToIntBits(this.m10) != Float.floatToIntBits(matrix2f.m10)) {
            return false;
        }
        return Float.floatToIntBits(this.m11) == Float.floatToIntBits(matrix2f.m11);
    }

    public boolean equals(Matrix2fc matrix2fc, float f2) {
        if (this == matrix2fc) {
            return true;
        }
        if (matrix2fc == null) {
            return false;
        }
        if (!(matrix2fc instanceof Matrix2f)) {
            return false;
        }
        if (!Runtime.equals(this.m00, matrix2fc.m00(), f2)) {
            return false;
        }
        if (!Runtime.equals(this.m01, matrix2fc.m01(), f2)) {
            return false;
        }
        if (!Runtime.equals(this.m10, matrix2fc.m10(), f2)) {
            return false;
        }
        return Runtime.equals(this.m11, matrix2fc.m11(), f2);
    }

    public Matrix2f swap(Matrix2f matrix2f) {
        MemUtil.INSTANCE.swap(this, matrix2f);
        return this;
    }

    public Matrix2f add(Matrix2fc matrix2fc) {
        return this.add(matrix2fc, this);
    }

    public Matrix2f add(Matrix2fc matrix2fc, Matrix2f matrix2f) {
        matrix2f.m00 = this.m00 + matrix2fc.m00();
        matrix2f.m01 = this.m01 + matrix2fc.m01();
        matrix2f.m10 = this.m10 + matrix2fc.m10();
        matrix2f.m11 = this.m11 + matrix2fc.m11();
        return matrix2f;
    }

    public Matrix2f sub(Matrix2fc matrix2fc) {
        return this.sub(matrix2fc, this);
    }

    public Matrix2f sub(Matrix2fc matrix2fc, Matrix2f matrix2f) {
        matrix2f.m00 = this.m00 - matrix2fc.m00();
        matrix2f.m01 = this.m01 - matrix2fc.m01();
        matrix2f.m10 = this.m10 - matrix2fc.m10();
        matrix2f.m11 = this.m11 - matrix2fc.m11();
        return matrix2f;
    }

    public Matrix2f mulComponentWise(Matrix2fc matrix2fc) {
        return this.mulComponentWise(matrix2fc, this);
    }

    public Matrix2f mulComponentWise(Matrix2fc matrix2fc, Matrix2f matrix2f) {
        matrix2f.m00 = this.m00 * matrix2fc.m00();
        matrix2f.m01 = this.m01 * matrix2fc.m01();
        matrix2f.m10 = this.m10 * matrix2fc.m10();
        matrix2f.m11 = this.m11 * matrix2fc.m11();
        return matrix2f;
    }

    public Matrix2f lerp(Matrix2fc matrix2fc, float f2) {
        return this.lerp(matrix2fc, f2, this);
    }

    public Matrix2f lerp(Matrix2fc matrix2fc, float f2, Matrix2f matrix2f) {
        matrix2f.m00 = Math.fma(matrix2fc.m00() - this.m00, f2, this.m00);
        matrix2f.m01 = Math.fma(matrix2fc.m01() - this.m01, f2, this.m01);
        matrix2f.m10 = Math.fma(matrix2fc.m10() - this.m10, f2, this.m10);
        matrix2f.m11 = Math.fma(matrix2fc.m11() - this.m11, f2, this.m11);
        return matrix2f;
    }

    public boolean isFinite() {
        return Math.isFinite(this.m00) && Math.isFinite(this.m01) && Math.isFinite(this.m10) && Math.isFinite(this.m11);
    }

    public Object clone() {
        return super.clone();
    }
}

