/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.text.NumberFormat;
import org.joml.Math;
import org.joml.Matrix2dc;
import org.joml.Matrix2fc;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Matrix3fc;
import org.joml.Matrix3x2d;
import org.joml.Matrix3x2dc;
import org.joml.Matrix3x2fc;
import org.joml.MemUtil;
import org.joml.MemUtil$MemUtilUnsafe;
import org.joml.Options;
import org.joml.Runtime;
import org.joml.Vector2d;
import org.joml.Vector2dc;

public class Matrix2d
implements Externalizable,
Cloneable,
Matrix2dc {
    private static final long serialVersionUID = 1L;
    public double m00;
    public double m01;
    public double m10;
    public double m11;

    public Matrix2d() {
        this.m00 = 1.0;
        this.m11 = 1.0;
    }

    public Matrix2d(Matrix2dc matrix2dc) {
        if (matrix2dc instanceof Matrix2d) {
            MemUtil.INSTANCE.copy((Matrix2d)matrix2dc, this);
        } else {
            this.setMatrix2dc(matrix2dc);
        }
    }

    public Matrix2d(Matrix2fc matrix2fc) {
        this.m00 = matrix2fc.m00();
        this.m01 = matrix2fc.m01();
        this.m10 = matrix2fc.m10();
        this.m11 = matrix2fc.m11();
    }

    public Matrix2d(Matrix3dc matrix3dc) {
        if (matrix3dc instanceof Matrix3d) {
            MemUtil.INSTANCE.copy((Matrix3d)matrix3dc, this);
        } else {
            this.setMatrix3dc(matrix3dc);
        }
    }

    public Matrix2d(Matrix3fc matrix3fc) {
        this.m00 = matrix3fc.m00();
        this.m01 = matrix3fc.m01();
        this.m10 = matrix3fc.m10();
        this.m11 = matrix3fc.m11();
    }

    public Matrix2d(double d2, double d3, double d4, double d5) {
        this.m00 = d2;
        this.m01 = d3;
        this.m10 = d4;
        this.m11 = d5;
    }

    public Matrix2d(DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.get(this, doubleBuffer.position(), doubleBuffer);
    }

    public Matrix2d(Vector2dc vector2dc, Vector2dc vector2dc2) {
        this.m00 = vector2dc.x();
        this.m01 = vector2dc.y();
        this.m10 = vector2dc2.x();
        this.m11 = vector2dc2.y();
    }

    public double m00() {
        return this.m00;
    }

    public double m01() {
        return this.m01;
    }

    public double m10() {
        return this.m10;
    }

    public double m11() {
        return this.m11;
    }

    public Matrix2d m00(double d2) {
        this.m00 = d2;
        return this;
    }

    public Matrix2d m01(double d2) {
        this.m01 = d2;
        return this;
    }

    public Matrix2d m10(double d2) {
        this.m10 = d2;
        return this;
    }

    public Matrix2d m11(double d2) {
        this.m11 = d2;
        return this;
    }

    Matrix2d _m00(double d2) {
        this.m00 = d2;
        return this;
    }

    Matrix2d _m01(double d2) {
        this.m01 = d2;
        return this;
    }

    Matrix2d _m10(double d2) {
        this.m10 = d2;
        return this;
    }

    Matrix2d _m11(double d2) {
        this.m11 = d2;
        return this;
    }

    public Matrix2d set(Matrix2dc matrix2dc) {
        if (matrix2dc instanceof Matrix2d) {
            MemUtil.INSTANCE.copy((Matrix2d)matrix2dc, this);
        } else {
            this.setMatrix2dc(matrix2dc);
        }
        return this;
    }

    private void setMatrix2dc(Matrix2dc matrix2dc) {
        this.m00 = matrix2dc.m00();
        this.m01 = matrix2dc.m01();
        this.m10 = matrix2dc.m10();
        this.m11 = matrix2dc.m11();
    }

    public Matrix2d set(Matrix2fc matrix2fc) {
        this.m00 = matrix2fc.m00();
        this.m01 = matrix2fc.m01();
        this.m10 = matrix2fc.m10();
        this.m11 = matrix2fc.m11();
        return this;
    }

    public Matrix2d set(Matrix3x2dc matrix3x2dc) {
        if (matrix3x2dc instanceof Matrix3x2d) {
            MemUtil.INSTANCE.copy((Matrix3x2d)matrix3x2dc, this);
        } else {
            this.setMatrix3x2dc(matrix3x2dc);
        }
        return this;
    }

    private void setMatrix3x2dc(Matrix3x2dc matrix3x2dc) {
        this.m00 = matrix3x2dc.m00();
        this.m01 = matrix3x2dc.m01();
        this.m10 = matrix3x2dc.m10();
        this.m11 = matrix3x2dc.m11();
    }

    public Matrix2d set(Matrix3x2fc matrix3x2fc) {
        this.m00 = matrix3x2fc.m00();
        this.m01 = matrix3x2fc.m01();
        this.m10 = matrix3x2fc.m10();
        this.m11 = matrix3x2fc.m11();
        return this;
    }

    public Matrix2d set(Matrix3dc matrix3dc) {
        if (matrix3dc instanceof Matrix3d) {
            MemUtil.INSTANCE.copy((Matrix3d)matrix3dc, this);
        } else {
            this.setMatrix3dc(matrix3dc);
        }
        return this;
    }

    private void setMatrix3dc(Matrix3dc matrix3dc) {
        this.m00 = matrix3dc.m00();
        this.m01 = matrix3dc.m01();
        this.m10 = matrix3dc.m10();
        this.m11 = matrix3dc.m11();
    }

    public Matrix2d set(Matrix3fc matrix3fc) {
        this.m00 = matrix3fc.m00();
        this.m01 = matrix3fc.m01();
        this.m10 = matrix3fc.m10();
        this.m11 = matrix3fc.m11();
        return this;
    }

    public Matrix2d mul(Matrix2dc matrix2dc) {
        return this.mul(matrix2dc, this);
    }

    public Matrix2d mul(Matrix2dc matrix2dc, Matrix2d matrix2d) {
        double d2 = this.m00 * matrix2dc.m00() + this.m10 * matrix2dc.m01();
        double d3 = this.m01 * matrix2dc.m00() + this.m11 * matrix2dc.m01();
        double d4 = this.m00 * matrix2dc.m10() + this.m10 * matrix2dc.m11();
        double d5 = this.m01 * matrix2dc.m10() + this.m11 * matrix2dc.m11();
        matrix2d.m00 = d2;
        matrix2d.m01 = d3;
        matrix2d.m10 = d4;
        matrix2d.m11 = d5;
        return matrix2d;
    }

    public Matrix2d mul(Matrix2fc matrix2fc) {
        return this.mul(matrix2fc, this);
    }

    public Matrix2d mul(Matrix2fc matrix2fc, Matrix2d matrix2d) {
        double d2 = this.m00 * (double)matrix2fc.m00() + this.m10 * (double)matrix2fc.m01();
        double d3 = this.m01 * (double)matrix2fc.m00() + this.m11 * (double)matrix2fc.m01();
        double d4 = this.m00 * (double)matrix2fc.m10() + this.m10 * (double)matrix2fc.m11();
        double d5 = this.m01 * (double)matrix2fc.m10() + this.m11 * (double)matrix2fc.m11();
        matrix2d.m00 = d2;
        matrix2d.m01 = d3;
        matrix2d.m10 = d4;
        matrix2d.m11 = d5;
        return matrix2d;
    }

    public Matrix2d mulLocal(Matrix2dc matrix2dc) {
        return this.mulLocal(matrix2dc, this);
    }

    public Matrix2d mulLocal(Matrix2dc matrix2dc, Matrix2d matrix2d) {
        double d2 = matrix2dc.m00() * this.m00 + matrix2dc.m10() * this.m01;
        double d3 = matrix2dc.m01() * this.m00 + matrix2dc.m11() * this.m01;
        double d4 = matrix2dc.m00() * this.m10 + matrix2dc.m10() * this.m11;
        double d5 = matrix2dc.m01() * this.m10 + matrix2dc.m11() * this.m11;
        matrix2d.m00 = d2;
        matrix2d.m01 = d3;
        matrix2d.m10 = d4;
        matrix2d.m11 = d5;
        return matrix2d;
    }

    public Matrix2d set(double d2, double d3, double d4, double d5) {
        this.m00 = d2;
        this.m01 = d3;
        this.m10 = d4;
        this.m11 = d5;
        return this;
    }

    public Matrix2d set(double[] dArray) {
        MemUtil.INSTANCE.copy(dArray, 0, this);
        return this;
    }

    public Matrix2d set(Vector2dc vector2dc, Vector2dc vector2dc2) {
        this.m00 = vector2dc.x();
        this.m01 = vector2dc.y();
        this.m10 = vector2dc2.x();
        this.m11 = vector2dc2.y();
        return this;
    }

    public double determinant() {
        return this.m00 * this.m11 - this.m10 * this.m01;
    }

    public Matrix2d invert() {
        return this.invert(this);
    }

    public Matrix2d invert(Matrix2d matrix2d) {
        double d2 = 1.0 / this.determinant();
        double d3 = this.m11 * d2;
        double d4 = -this.m01 * d2;
        double d5 = -this.m10 * d2;
        double d6 = this.m00 * d2;
        matrix2d.m00 = d3;
        matrix2d.m01 = d4;
        matrix2d.m10 = d5;
        matrix2d.m11 = d6;
        return matrix2d;
    }

    public Matrix2d transpose() {
        return this.transpose(this);
    }

    public Matrix2d transpose(Matrix2d matrix2d) {
        matrix2d.set(this.m00, this.m10, this.m01, this.m11);
        return matrix2d;
    }

    public String toString() {
        String string = this.toString(Options.NUMBER_FORMAT);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = Integer.MIN_VALUE;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == 'E') {
                n2 = i2;
            } else {
                if (c2 == ' ' && n2 == i2 - 1) {
                    stringBuffer.append('+');
                    continue;
                }
                if (Character.isDigit(c2) && n2 == i2 - 1) {
                    stringBuffer.append('+');
                }
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public String toString(NumberFormat numberFormat) {
        return Runtime.format(this.m00, numberFormat) + " " + Runtime.format(this.m10, numberFormat) + "\n" + Runtime.format(this.m01, numberFormat) + " " + Runtime.format(this.m11, numberFormat) + "\n";
    }

    public Matrix2d get(Matrix2d matrix2d) {
        return matrix2d.set(this);
    }

    public Matrix3x2d get(Matrix3x2d matrix3x2d) {
        return matrix3x2d.set(this);
    }

    public Matrix3d get(Matrix3d matrix3d) {
        return matrix3d.set(this);
    }

    public double getRotation() {
        return Math.atan2(this.m01, this.m11);
    }

    public DoubleBuffer get(DoubleBuffer doubleBuffer) {
        return this.get(doubleBuffer.position(), doubleBuffer);
    }

    public DoubleBuffer get(int n2, DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.put(this, n2, doubleBuffer);
        return doubleBuffer;
    }

    public ByteBuffer get(ByteBuffer byteBuffer) {
        return this.get(byteBuffer.position(), byteBuffer);
    }

    public ByteBuffer get(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, n2, byteBuffer);
        return byteBuffer;
    }

    public ByteBuffer getFloats(ByteBuffer byteBuffer) {
        return this.getFloats(byteBuffer.position(), byteBuffer);
    }

    public ByteBuffer getFloats(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.putf(this, n2, byteBuffer);
        return byteBuffer;
    }

    public DoubleBuffer getTransposed(DoubleBuffer doubleBuffer) {
        return this.getTransposed(doubleBuffer.position(), doubleBuffer);
    }

    public DoubleBuffer getTransposed(int n2, DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.putTransposed(this, n2, doubleBuffer);
        return doubleBuffer;
    }

    public FloatBuffer getTransposed(FloatBuffer floatBuffer) {
        return this.getTransposed(floatBuffer.position(), floatBuffer);
    }

    public FloatBuffer getTransposed(int n2, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.putfTransposed(this, n2, floatBuffer);
        return floatBuffer;
    }

    public ByteBuffer getTransposed(ByteBuffer byteBuffer) {
        return this.getTransposed(byteBuffer.position(), byteBuffer);
    }

    public ByteBuffer getTransposed(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.putTransposed(this, n2, byteBuffer);
        return byteBuffer;
    }

    public ByteBuffer getTransposedFloats(ByteBuffer byteBuffer) {
        return this.getTransposedFloats(byteBuffer.position(), byteBuffer);
    }

    public ByteBuffer getTransposedFloats(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.putfTransposed(this, n2, byteBuffer);
        return byteBuffer;
    }

    public Matrix2dc getToAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil$MemUtilUnsafe.put(this, l2);
        return this;
    }

    public double[] get(double[] dArray, int n2) {
        MemUtil.INSTANCE.copy(this, dArray, n2);
        return dArray;
    }

    public double[] get(double[] dArray) {
        return this.get(dArray, 0);
    }

    public Matrix2d set(DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.get(this, doubleBuffer.position(), doubleBuffer);
        return this;
    }

    public Matrix2d set(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
        return this;
    }

    public Matrix2d set(int n2, DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.get(this, n2, doubleBuffer);
        return this;
    }

    public Matrix2d set(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n2, byteBuffer);
        return this;
    }

    public Matrix2d setFromAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil$MemUtilUnsafe.get(this, l2);
        return this;
    }

    public Matrix2d zero() {
        MemUtil.INSTANCE.zero(this);
        return this;
    }

    public Matrix2d identity() {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        return this;
    }

    public Matrix2d scale(Vector2dc vector2dc, Matrix2d matrix2d) {
        return this.scale(vector2dc.x(), vector2dc.y(), matrix2d);
    }

    public Matrix2d scale(Vector2dc vector2dc) {
        return this.scale(vector2dc.x(), vector2dc.y(), this);
    }

    public Matrix2d scale(double d2, double d3, Matrix2d matrix2d) {
        matrix2d.m00 = this.m00 * d2;
        matrix2d.m01 = this.m01 * d2;
        matrix2d.m10 = this.m10 * d3;
        matrix2d.m11 = this.m11 * d3;
        return matrix2d;
    }

    public Matrix2d scale(double d2, double d3) {
        return this.scale(d2, d3, this);
    }

    public Matrix2d scale(double d2, Matrix2d matrix2d) {
        return this.scale(d2, d2, matrix2d);
    }

    public Matrix2d scale(double d2) {
        return this.scale(d2, d2);
    }

    public Matrix2d scaleLocal(double d2, double d3, Matrix2d matrix2d) {
        matrix2d.m00 = d2 * this.m00;
        matrix2d.m01 = d3 * this.m01;
        matrix2d.m10 = d2 * this.m10;
        matrix2d.m11 = d3 * this.m11;
        return matrix2d;
    }

    public Matrix2d scaleLocal(double d2, double d3) {
        return this.scaleLocal(d2, d3, this);
    }

    public Matrix2d scaling(double d2) {
        MemUtil.INSTANCE.zero(this);
        this.m00 = d2;
        this.m11 = d2;
        return this;
    }

    public Matrix2d scaling(double d2, double d3) {
        MemUtil.INSTANCE.zero(this);
        this.m00 = d2;
        this.m11 = d3;
        return this;
    }

    public Matrix2d scaling(Vector2dc vector2dc) {
        return this.scaling(vector2dc.x(), vector2dc.y());
    }

    public Matrix2d rotation(double d2) {
        double d3;
        double d4 = Math.sin(d2);
        this.m00 = d3 = Math.cosFromSin(d4, d2);
        this.m01 = d4;
        this.m10 = -d4;
        this.m11 = d3;
        return this;
    }

    public Vector2d transform(Vector2d vector2d) {
        return vector2d.mul(this);
    }

    public Vector2d transform(Vector2dc vector2dc, Vector2d vector2d) {
        vector2dc.mul(this, vector2d);
        return vector2d;
    }

    public Vector2d transform(double d2, double d3, Vector2d vector2d) {
        vector2d.set(this.m00 * d2 + this.m10 * d3, this.m01 * d2 + this.m11 * d3);
        return vector2d;
    }

    public Vector2d transformTranspose(Vector2d vector2d) {
        return vector2d.mulTranspose(this);
    }

    public Vector2d transformTranspose(Vector2dc vector2dc, Vector2d vector2d) {
        vector2dc.mulTranspose(this, vector2d);
        return vector2d;
    }

    public Vector2d transformTranspose(double d2, double d3, Vector2d vector2d) {
        vector2d.set(this.m00 * d2 + this.m01 * d3, this.m10 * d2 + this.m11 * d3);
        return vector2d;
    }

    public void writeExternal(ObjectOutput objectOutput) {
        objectOutput.writeDouble(this.m00);
        objectOutput.writeDouble(this.m01);
        objectOutput.writeDouble(this.m10);
        objectOutput.writeDouble(this.m11);
    }

    public void readExternal(ObjectInput objectInput) {
        this.m00 = objectInput.readDouble();
        this.m01 = objectInput.readDouble();
        this.m10 = objectInput.readDouble();
        this.m11 = objectInput.readDouble();
    }

    public Matrix2d rotate(double d2) {
        return this.rotate(d2, this);
    }

    public Matrix2d rotate(double d2, Matrix2d matrix2d) {
        double d3 = Math.sin(d2);
        double d4 = Math.cosFromSin(d3, d2);
        double d5 = this.m00 * d4 + this.m10 * d3;
        double d6 = this.m01 * d4 + this.m11 * d3;
        double d7 = this.m10 * d4 - this.m00 * d3;
        double d8 = this.m11 * d4 - this.m01 * d3;
        matrix2d.m00 = d5;
        matrix2d.m01 = d6;
        matrix2d.m10 = d7;
        matrix2d.m11 = d8;
        return matrix2d;
    }

    public Matrix2d rotateLocal(double d2) {
        return this.rotateLocal(d2, this);
    }

    public Matrix2d rotateLocal(double d2, Matrix2d matrix2d) {
        double d3 = Math.sin(d2);
        double d4 = Math.cosFromSin(d3, d2);
        double d5 = d4 * this.m00 - d3 * this.m01;
        double d6 = d3 * this.m00 + d4 * this.m01;
        double d7 = d4 * this.m10 - d3 * this.m11;
        double d8 = d3 * this.m10 + d4 * this.m11;
        matrix2d.m00 = d5;
        matrix2d.m01 = d6;
        matrix2d.m10 = d7;
        matrix2d.m11 = d8;
        return matrix2d;
    }

    public Vector2d getRow(int n2, Vector2d vector2d) {
        switch (n2) {
            case 0: {
                vector2d.x = this.m00;
                vector2d.y = this.m10;
                break;
            }
            case 1: {
                vector2d.x = this.m01;
                vector2d.y = this.m11;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return vector2d;
    }

    public Matrix2d setRow(int n2, Vector2dc vector2dc) {
        return this.setRow(n2, vector2dc.x(), vector2dc.y());
    }

    public Matrix2d setRow(int n2, double d2, double d3) {
        switch (n2) {
            case 0: {
                this.m00 = d2;
                this.m10 = d3;
                break;
            }
            case 1: {
                this.m01 = d2;
                this.m11 = d3;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return this;
    }

    public Vector2d getColumn(int n2, Vector2d vector2d) {
        switch (n2) {
            case 0: {
                vector2d.x = this.m00;
                vector2d.y = this.m01;
                break;
            }
            case 1: {
                vector2d.x = this.m10;
                vector2d.y = this.m11;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return vector2d;
    }

    public Matrix2d setColumn(int n2, Vector2dc vector2dc) {
        return this.setColumn(n2, vector2dc.x(), vector2dc.y());
    }

    public Matrix2d setColumn(int n2, double d2, double d3) {
        switch (n2) {
            case 0: {
                this.m00 = d2;
                this.m01 = d3;
                break;
            }
            case 1: {
                this.m10 = d2;
                this.m11 = d3;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return this;
    }

    public double get(int n2, int n3) {
        switch (n2) {
            case 0: {
                switch (n3) {
                    case 0: {
                        return this.m00;
                    }
                    case 1: {
                        return this.m01;
                    }
                }
                break;
            }
            case 1: {
                switch (n3) {
                    case 0: {
                        return this.m10;
                    }
                    case 1: {
                        return this.m11;
                    }
                }
                break;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Matrix2d set(int n2, int n3, double d2) {
        switch (n2) {
            case 0: {
                switch (n3) {
                    case 0: {
                        this.m00 = d2;
                        return this;
                    }
                    case 1: {
                        this.m01 = d2;
                        return this;
                    }
                }
                break;
            }
            case 1: {
                switch (n3) {
                    case 0: {
                        this.m10 = d2;
                        return this;
                    }
                    case 1: {
                        this.m11 = d2;
                        return this;
                    }
                }
                break;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Matrix2d normal() {
        return this.normal(this);
    }

    public Matrix2d normal(Matrix2d matrix2d) {
        double d2 = this.m00 * this.m11 - this.m10 * this.m01;
        double d3 = 1.0 / d2;
        double d4 = this.m11 * d3;
        double d5 = -this.m10 * d3;
        double d6 = -this.m01 * d3;
        double d7 = this.m00 * d3;
        matrix2d.m00 = d4;
        matrix2d.m01 = d5;
        matrix2d.m10 = d6;
        matrix2d.m11 = d7;
        return matrix2d;
    }

    public Vector2d getScale(Vector2d vector2d) {
        vector2d.x = Math.sqrt(this.m00 * this.m00 + this.m01 * this.m01);
        vector2d.y = Math.sqrt(this.m10 * this.m10 + this.m11 * this.m11);
        return vector2d;
    }

    public Vector2d positiveX(Vector2d vector2d) {
        if (this.m00 * this.m11 < this.m01 * this.m10) {
            vector2d.x = -this.m11;
            vector2d.y = this.m01;
        } else {
            vector2d.x = this.m11;
            vector2d.y = -this.m01;
        }
        return vector2d.normalize(vector2d);
    }

    public Vector2d normalizedPositiveX(Vector2d vector2d) {
        if (this.m00 * this.m11 < this.m01 * this.m10) {
            vector2d.x = -this.m11;
            vector2d.y = this.m01;
        } else {
            vector2d.x = this.m11;
            vector2d.y = -this.m01;
        }
        return vector2d;
    }

    public Vector2d positiveY(Vector2d vector2d) {
        if (this.m00 * this.m11 < this.m01 * this.m10) {
            vector2d.x = this.m10;
            vector2d.y = -this.m00;
        } else {
            vector2d.x = -this.m10;
            vector2d.y = this.m00;
        }
        return vector2d.normalize(vector2d);
    }

    public Vector2d normalizedPositiveY(Vector2d vector2d) {
        if (this.m00 * this.m11 < this.m01 * this.m10) {
            vector2d.x = this.m10;
            vector2d.y = -this.m00;
        } else {
            vector2d.x = -this.m10;
            vector2d.y = this.m00;
        }
        return vector2d;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        long l2 = Double.doubleToLongBits(this.m00);
        n3 = 31 * n3 + (int)(l2 >>> 32 ^ l2);
        l2 = Double.doubleToLongBits(this.m01);
        n3 = 31 * n3 + (int)(l2 >>> 32 ^ l2);
        l2 = Double.doubleToLongBits(this.m10);
        n3 = 31 * n3 + (int)(l2 >>> 32 ^ l2);
        l2 = Double.doubleToLongBits(this.m11);
        n3 = 31 * n3 + (int)(l2 >>> 32 ^ l2);
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Matrix2d matrix2d = (Matrix2d)object;
        if (Double.doubleToLongBits(this.m00) != Double.doubleToLongBits(matrix2d.m00)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m01) != Double.doubleToLongBits(matrix2d.m01)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m10) != Double.doubleToLongBits(matrix2d.m10)) {
            return false;
        }
        return Double.doubleToLongBits(this.m11) == Double.doubleToLongBits(matrix2d.m11);
    }

    public boolean equals(Matrix2dc matrix2dc, double d2) {
        if (this == matrix2dc) {
            return true;
        }
        if (matrix2dc == null) {
            return false;
        }
        if (!(matrix2dc instanceof Matrix2d)) {
            return false;
        }
        if (!Runtime.equals(this.m00, matrix2dc.m00(), d2)) {
            return false;
        }
        if (!Runtime.equals(this.m01, matrix2dc.m01(), d2)) {
            return false;
        }
        if (!Runtime.equals(this.m10, matrix2dc.m10(), d2)) {
            return false;
        }
        return Runtime.equals(this.m11, matrix2dc.m11(), d2);
    }

    public Matrix2d swap(Matrix2d matrix2d) {
        MemUtil.INSTANCE.swap(this, matrix2d);
        return this;
    }

    public Matrix2d add(Matrix2dc matrix2dc) {
        return this.add(matrix2dc, this);
    }

    public Matrix2d add(Matrix2dc matrix2dc, Matrix2d matrix2d) {
        matrix2d.m00 = this.m00 + matrix2dc.m00();
        matrix2d.m01 = this.m01 + matrix2dc.m01();
        matrix2d.m10 = this.m10 + matrix2dc.m10();
        matrix2d.m11 = this.m11 + matrix2dc.m11();
        return matrix2d;
    }

    public Matrix2d sub(Matrix2dc matrix2dc) {
        return this.sub(matrix2dc, this);
    }

    public Matrix2d sub(Matrix2dc matrix2dc, Matrix2d matrix2d) {
        matrix2d.m00 = this.m00 - matrix2dc.m00();
        matrix2d.m01 = this.m01 - matrix2dc.m01();
        matrix2d.m10 = this.m10 - matrix2dc.m10();
        matrix2d.m11 = this.m11 - matrix2dc.m11();
        return matrix2d;
    }

    public Matrix2d mulComponentWise(Matrix2dc matrix2dc) {
        return this.mulComponentWise(matrix2dc, this);
    }

    public Matrix2d mulComponentWise(Matrix2dc matrix2dc, Matrix2d matrix2d) {
        matrix2d.m00 = this.m00 * matrix2dc.m00();
        matrix2d.m01 = this.m01 * matrix2dc.m01();
        matrix2d.m10 = this.m10 * matrix2dc.m10();
        matrix2d.m11 = this.m11 * matrix2dc.m11();
        return matrix2d;
    }

    public Matrix2d lerp(Matrix2dc matrix2dc, double d2) {
        return this.lerp(matrix2dc, d2, this);
    }

    public Matrix2d lerp(Matrix2dc matrix2dc, double d2, Matrix2d matrix2d) {
        matrix2d.m00 = Math.fma(matrix2dc.m00() - this.m00, d2, this.m00);
        matrix2d.m01 = Math.fma(matrix2dc.m01() - this.m01, d2, this.m01);
        matrix2d.m10 = Math.fma(matrix2dc.m10() - this.m10, d2, this.m10);
        matrix2d.m11 = Math.fma(matrix2dc.m11() - this.m11, d2, this.m11);
        return matrix2d;
    }

    public boolean isFinite() {
        return Math.isFinite(this.m00) && Math.isFinite(this.m01) && Math.isFinite(this.m10) && Math.isFinite(this.m11);
    }

    public Object clone() {
        return super.clone();
    }
}

